---
jupyter:
  jupytext:
    text_representation:
      extension: .md
      format_name: markdown
      format_version: '1.3'
      jupytext_version: 1.16.7
  kernelspec:
    display_name: Logtalk
    language: logtalk
    name: logtalk_kernel
---

<!--
________________________________________________________________________

This file is part of Logtalk <https://logtalk.org/>  
SPDX-FileCopyrightText: 1998-2026 Paulo Moura <pmoura@logtalk.org>  
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
________________________________________________________________________
-->

# threads - ping_pong

This folder contains a simple multi-threaded implementation of a ping-pong
game using a thread per player and threaded notifications to communicate
moves. The player threads are automatically terminated when the game is over.

When using XVM as the backend, this example must be run from the top-level
interpreter.

Print Logtalk, Prolog backend, and kernel versions (if running as a notebook):

```logtalk
%versions
```

Start by loading the example:

```logtalk
logtalk_load(ping_pong(loader)).
```

Run example:

```logtalk
ping_pong::play(1).
```

<!--
Ping ...
.... Pong
Game over!

true.
-->

```logtalk
ping_pong::play(5).
```

<!--
Ping ...
.... Pong
Ping ...
.... Pong
Ping ...
.... Pong
Ping ...
.... Pong
Ping ...
.... Pong
Game over!

true.
-->
