# Logtalk APIs

## Libraries

To load any library (including developer tools, ports, and contributions), use the goal `logtalk_load(library_name(loader))`. To run the library tests, use the goal `logtalk_load(library_name(tester))`. To load an entity, always load the loader file of the library that includes it to ensure that all required dependencies are also loaded and that any required flags are used. The loading goal can be found in the entity documentation.

### ada_boost")

**object**

#### `ada_boost`

AdaBoost (Adaptive Boosting) classifier using C4.5 decision trees as base learners. Implements the SAMME (Stagewise Additive Modeling using a Multi-class Exponential loss function) variant, which supports multi-class classification. Builds an ensemble of weighted decision trees where each subsequent tree focuses on the examples misclassified by previous trees.

**Availability:**

`logtalk_load(ada_boost(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` classifier_protocol

**Imports:**

`public` options

**Uses:**

c45

fast_random(Algorithm)

format

list

pairs

type

**Remarks:**

> - Algorithm: AdaBoost iteratively trains weak learners (C4.5 decision trees) on weighted versions of the training data. After each iteration, the weights of misclassified examples are increased so that subsequent learners focus more on difficult cases.
>
> - SAMME variant: This implementation uses the SAMME algorithm (Zhu et al., 2009) which extends AdaBoost to the multi-class case by adjusting the weight update formula to account for the number of classes.
>
> - Learner weights: Each base learner receives a weight (alpha) proportional to its accuracy. More accurate learners have higher weights in the final ensemble vote.
>
> - Classifier representation: The learned classifier is represented as a `ab_classifier(WeightedTrees,`` ``ClassValues,`` ``Options)` term where `WeightedTrees` is a list of `weighted_tree(Alpha,`` ``Tree,`` ``AttributeNames)` elements.
>
> - Early stopping: Training stops early if a perfect classifier is found (zero weighted error) or if a base learner performs worse than random guessing.

**Inherited public predicates:**

 check_option/1  check_options/1  classifier_to_clauses/4  classifier_to_file/4  default_option/1  default_options/1  learn/2  option/2  option/3  predict/3  print_classifier/1  valid_option/1  valid_options/1

- Public predicates

  - `learn/3`

  - `predict_probabilities/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `learn/3`

Learns a classifier from the given dataset object using the specified options.

**Compilation flags:**

`static`

**Template:**

`learn(Dataset,Classifier,Options)`

**Mode and number of proofs:**

`learn(+object_identifier,-compound,+list(compound))` - `one`

------------------------------------------------------------------------

###### `predict_probabilities/3`

Predicts class probabilities for a new instance using the learned classifier. Returns a list of `Class-Probability` pairs sorted by descending probability. Probabilities are derived from the weighted votes of all base learners.

**Compilation flags:**

`static`

**Template:**

`predict_probabilities(Classifier,Instance,Probabilities)`

**Mode and number of proofs:**

`predict_probabilities(+compound,+list,-list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

dataset_protocol, c45, isolation_forest, knn, naive_bayes, nearest_centroid, random_forest

### amqp")

**object**

#### `amqp`

Portable AMQP 0-9-1 (Advanced Message Queuing Protocol) client. Uses the sockets library for TCP communication.

**Availability:**

`logtalk_load(amqp(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

list

os

socket

term_io

**Remarks:**

> - Supported backends: ECLiPSe, GNU Prolog, SICStus Prolog, SWI-Prolog, Trealla Prolog, and XVM (same as the sockets library).
>
> - Protocol version: Implements AMQP 0-9-1 specification.
>
> - Binary protocol: AMQP is a binary protocol with typed frame encoding.
>
> - Channels: Supports multiple concurrent channels over a single connection.
>
> - Exchanges and queues: Full support for declaring exchanges, queues, and bindings.
>
> - Content: Supports message publishing and consuming with content headers.
>
> - Transactions: Supports AMQP transactions with tx.select, tx.commit, and tx.rollback.
>
> - Publisher confirms: Support for publisher confirms can be added.
>
> - Heartbeat: Supports heartbeat negotiation to keep connections alive.
>
> - Reconnection: Automatic reconnection with configurable retry attempts and delays.

**Inherited public predicates:**

(none)

- Public predicates

  - `connect/4`

  - `close/1`

  - `close/3`

  - `connection_alive/1`

  - `channel_open/3`

  - `channel_close/1`

  - `channel_close/3`

  - `exchange_declare/3`

  - `exchange_delete/3`

  - `exchange_bind/4`

  - `exchange_unbind/4`

  - `queue_declare/3`

  - `queue_delete/3`

  - `queue_bind/4`

  - `queue_unbind/4`

  - `queue_purge/2`

  - `basic_publish/4`

  - `basic_consume/3`

  - `basic_cancel/3`

  - `basic_get/3`

  - `basic_ack/3`

  - `basic_nack/3`

  - `basic_reject/3`

  - `basic_qos/2`

  - `basic_recover/2`

  - `receive/3`

  - `tx_select/1`

  - `tx_commit/1`

  - `tx_rollback/1`

  - `confirm_select/1`

  - `send_heartbeat/1`

  - `message_body/2`

  - `message_properties/2`

  - `message_property/3`

  - `message_delivery_tag/2`

  - `message_exchange/2`

  - `message_routing_key/2`

  - `encode_frame/2`

  - `decode_frame/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `connect/4`

Connects to an AMQP 0-9-1 server and performs the protocol handshake. Returns a connection handle for subsequent operations. Supports automatic reconnection on connection failures.

**Compilation flags:**

`static`

**Template:**

`connect(Host,Port,Connection,Options)`

**Mode and number of proofs:**

`connect(+atom,+integer,--compound,+list)` - `one_or_error`

**Exceptions:**

Connection refused or network error:

`amqp_error(connection_failed)`

Server rejected connection:

`amqp_error(protocol_error(Message))`

Authentication failed:

`amqp_error(auth_failed)`

All reconnection attempts failed:

`amqp_error(reconnect_failed)`

**Remarks:**

> - Option username(Username): Username for authentication. Default is guest.
>
> - Option password(Password): Password for authentication. Default is guest.
>
> - Option virtual_host(VHost): Virtual host name. Default is /.
>
> - Option heartbeat(Seconds): Heartbeat interval in seconds. Default is 60.
>
> - Option channel_max(Max): Maximum number of channels. Default is 0 (no limit).
>
> - Option frame_max(Max): Maximum frame size. Default is 131072.
>
> - Option reconnect(Boolean): Enable automatic reconnection on connection failure. Default is false.
>
> - Option reconnect_attempts(N): Maximum number of reconnection attempts. Default is 3. Only used when reconnect(true).
>
> - Option reconnect_delay(Seconds): Delay between reconnection attempts in seconds. Default is 1. Only used when reconnect(true).

------------------------------------------------------------------------

###### `close/1`

Gracefully closes the AMQP connection. Closes all channels and the connection itself.

**Compilation flags:**

`static`

**Template:**

`close(Connection)`

**Mode and number of proofs:**

`close(+compound)` - `one_or_error`

------------------------------------------------------------------------

###### `close/3`

Closes the AMQP connection with a specific reply code and reason.

**Compilation flags:**

`static`

**Template:**

`close(Connection,ReplyCode,ReplyText)`

**Mode and number of proofs:**

`close(+compound,+integer,+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `connection_alive/1`

Checks if the connection is still open and valid.

**Compilation flags:**

`static`

**Template:**

`connection_alive(Connection)`

**Mode and number of proofs:**

`connection_alive(+compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `channel_open/3`

Opens a new channel on the connection. Returns a channel handle.

**Compilation flags:**

`static`

**Template:**

`channel_open(Connection,ChannelNumber,Channel)`

**Mode and number of proofs:**

`channel_open(+compound,+integer,--compound)` - `one_or_error`

**Exceptions:**

Channel already open:

`amqp_error(channel_error(Message))`

------------------------------------------------------------------------

###### `channel_close/1`

Closes a channel.

**Compilation flags:**

`static`

**Template:**

`channel_close(Channel)`

**Mode and number of proofs:**

`channel_close(+compound)` - `one_or_error`

------------------------------------------------------------------------

###### `channel_close/3`

Closes a channel with a specific reply code and reason.

**Compilation flags:**

`static`

**Template:**

`channel_close(Channel,ReplyCode,ReplyText)`

**Mode and number of proofs:**

`channel_close(+compound,+integer,+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `exchange_declare/3`

Declares an exchange on the server.

**Compilation flags:**

`static`

**Template:**

`exchange_declare(Channel,Exchange,Options)`

**Mode and number of proofs:**

`exchange_declare(+compound,+atom,+list)` - `one_or_error`

**Remarks:**

> - Option type(Type): Exchange type: direct, fanout, topic, headers. Default is direct.
>
> - Option durable(Boolean): Survive server restart. Default is false.
>
> - Option auto_delete(Boolean): Delete when unused. Default is false.
>
> - Option internal(Boolean): Internal exchange. Default is false.
>
> - Option arguments(Arguments): Additional arguments as key-value pairs.

------------------------------------------------------------------------

###### `exchange_delete/3`

Deletes an exchange.

**Compilation flags:**

`static`

**Template:**

`exchange_delete(Channel,Exchange,Options)`

**Mode and number of proofs:**

`exchange_delete(+compound,+atom,+list)` - `one_or_error`

**Remarks:**

> - Option if_unused(Boolean): Only delete if unused. Default is false.

------------------------------------------------------------------------

###### `exchange_bind/4`

Binds an exchange to another exchange.

**Compilation flags:**

`static`

**Template:**

`exchange_bind(Channel,Destination,Source,Options)`

**Mode and number of proofs:**

`exchange_bind(+compound,+atom,+atom,+list)` - `one_or_error`

**Remarks:**

> - Option routing_key(Key): Routing key for binding. Default is empty.
>
> - Option arguments(Arguments): Additional arguments.

------------------------------------------------------------------------

###### `exchange_unbind/4`

Unbinds an exchange from another exchange.

**Compilation flags:**

`static`

**Template:**

`exchange_unbind(Channel,Destination,Source,Options)`

**Mode and number of proofs:**

`exchange_unbind(+compound,+atom,+atom,+list)` - `one_or_error`

------------------------------------------------------------------------

###### `queue_declare/3`

Declares a queue on the server. If Queue is a variable, the server generates a unique name.

**Compilation flags:**

`static`

**Template:**

`queue_declare(Channel,Queue,Options)`

**Mode and number of proofs:**

`queue_declare(+compound,?atom,+list)` - `one_or_error`

**Remarks:**

> - Option durable(Boolean): Survive server restart. Default is false.
>
> - Option exclusive(Boolean): Exclusive to this connection. Default is false.
>
> - Option auto_delete(Boolean): Delete when unused. Default is false.
>
> - Option arguments(Arguments): Additional arguments (e.g., message TTL, dead letter exchange).

------------------------------------------------------------------------

###### `queue_delete/3`

Deletes a queue.

**Compilation flags:**

`static`

**Template:**

`queue_delete(Channel,Queue,Options)`

**Mode and number of proofs:**

`queue_delete(+compound,+atom,+list)` - `one_or_error`

**Remarks:**

> - Option if_unused(Boolean): Only delete if unused. Default is false.
>
> - Option if_empty(Boolean): Only delete if empty. Default is false.

------------------------------------------------------------------------

###### `queue_bind/4`

Binds a queue to an exchange.

**Compilation flags:**

`static`

**Template:**

`queue_bind(Channel,Queue,Exchange,Options)`

**Mode and number of proofs:**

`queue_bind(+compound,+atom,+atom,+list)` - `one_or_error`

**Remarks:**

> - Option routing_key(Key): Routing key for binding. Default is empty.
>
> - Option arguments(Arguments): Additional arguments.

------------------------------------------------------------------------

###### `queue_unbind/4`

Unbinds a queue from an exchange.

**Compilation flags:**

`static`

**Template:**

`queue_unbind(Channel,Queue,Exchange,Options)`

**Mode and number of proofs:**

`queue_unbind(+compound,+atom,+atom,+list)` - `one_or_error`

------------------------------------------------------------------------

###### `queue_purge/2`

Purges all messages from a queue.

**Compilation flags:**

`static`

**Template:**

`queue_purge(Channel,Queue)`

**Mode and number of proofs:**

`queue_purge(+compound,+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `basic_publish/4`

Publishes a message to an exchange.

**Compilation flags:**

`static`

**Template:**

`basic_publish(Channel,Exchange,Body,Options)`

**Mode and number of proofs:**

`basic_publish(+compound,+atom,+term,+list)` - `one_or_error`

**Remarks:**

> - Option routing_key(Key): Routing key for message. Default is empty.
>
> - Option mandatory(Boolean): Return if not routable. Default is false.
>
> - Option immediate(Boolean): Return if not deliverable. Default is false (deprecated in RabbitMQ).
>
> - Option content_type(Type): MIME content type.
>
> - Option content_encoding(Enc): Content encoding.
>
> - Option correlation_id(Id): Correlation identifier.
>
> - Option reply_to(Queue): Reply queue name.
>
> - Option expiration(Ms): Message TTL in milliseconds.
>
> - Option message_id(Id): Application message identifier.
>
> - Option timestamp(Ts): Message timestamp.
>
> - Option type(Type): Message type name.
>
> - Option user_id(Id): Creating user ID.
>
> - Option app_id(Id): Creating application ID.
>
> - Option delivery_mode(Mode): 1 for non-persistent, 2 for persistent.
>
> - Option priority(P): Message priority (0-9).
>
> - Option headers(H): Application headers as key-value pairs.

------------------------------------------------------------------------

###### `basic_consume/3`

Starts consuming messages from a queue.

**Compilation flags:**

`static`

**Template:**

`basic_consume(Channel,Queue,Options)`

**Mode and number of proofs:**

`basic_consume(+compound,+atom,+list)` - `one_or_error`

**Remarks:**

> - Option consumer_tag(Tag): Consumer identifier. Server generates if not provided.
>
> - Option no_local(Boolean): Do not receive own messages. Default is false.
>
> - Option no_ack(Boolean): No acknowledgment required. Default is false.
>
> - Option exclusive(Boolean): Exclusive consumer. Default is false.
>
> - Option arguments(Arguments): Additional arguments.

------------------------------------------------------------------------

###### `basic_cancel/3`

Cancels a consumer.

**Compilation flags:**

`static`

**Template:**

`basic_cancel(Channel,ConsumerTag,Options)`

**Mode and number of proofs:**

`basic_cancel(+compound,+atom,+list)` - `one_or_error`

------------------------------------------------------------------------

###### `basic_get/3`

Synchronously gets a message from a queue.

**Compilation flags:**

`static`

**Template:**

`basic_get(Channel,Queue,Options)`

**Mode and number of proofs:**

`basic_get(+compound,+atom,+list)` - `one_or_error`

**Remarks:**

> - Option no_ack(Boolean): No acknowledgment required. Default is false.

------------------------------------------------------------------------

###### `basic_ack/3`

Acknowledges a message.

**Compilation flags:**

`static`

**Template:**

`basic_ack(Channel,DeliveryTag,Options)`

**Mode and number of proofs:**

`basic_ack(+compound,+integer,+list)` - `one_or_error`

**Remarks:**

> - Option multiple(Boolean): Acknowledge all up to this tag. Default is false.

------------------------------------------------------------------------

###### `basic_nack/3`

Negatively acknowledges a message (RabbitMQ extension).

**Compilation flags:**

`static`

**Template:**

`basic_nack(Channel,DeliveryTag,Options)`

**Mode and number of proofs:**

`basic_nack(+compound,+integer,+list)` - `one_or_error`

**Remarks:**

> - Option multiple(Boolean): Reject all up to this tag. Default is false.
>
> - Option requeue(Boolean): Requeue the message. Default is true.

------------------------------------------------------------------------

###### `basic_reject/3`

Rejects a message.

**Compilation flags:**

`static`

**Template:**

`basic_reject(Channel,DeliveryTag,Options)`

**Mode and number of proofs:**

`basic_reject(+compound,+integer,+list)` - `one_or_error`

**Remarks:**

> - Option requeue(Boolean): Requeue the message. Default is true.

------------------------------------------------------------------------

###### `basic_qos/2`

Sets quality of service (prefetch) settings.

**Compilation flags:**

`static`

**Template:**

`basic_qos(Channel,Options)`

**Mode and number of proofs:**

`basic_qos(+compound,+list)` - `one_or_error`

**Remarks:**

> - Option prefetch_size(Size): Prefetch window size in bytes. Default is 0 (no limit).
>
> - Option prefetch_count(Count): Prefetch window in messages. Default is 0 (no limit).
>
> - Option global(Boolean): Apply to entire connection. Default is false.

------------------------------------------------------------------------

###### `basic_recover/2`

Asks the server to redeliver unacknowledged messages.

**Compilation flags:**

`static`

**Template:**

`basic_recover(Channel,Options)`

**Mode and number of proofs:**

`basic_recover(+compound,+list)` - `one_or_error`

**Remarks:**

> - Option requeue(Boolean): Requeue messages. Default is false.

------------------------------------------------------------------------

###### `receive/3`

Receives a message or method from the server. Blocks until data is available or timeout.

**Compilation flags:**

`static`

**Template:**

`receive(Channel,Message,Options)`

**Mode and number of proofs:**

`receive(+compound,-compound,+list)` - `zero_or_one_or_error`

**Remarks:**

> - Option timeout(Milliseconds): Timeout in milliseconds. 0 for non-blocking, -1 for infinite. Default is -1.

------------------------------------------------------------------------

###### `tx_select/1`

Enables transaction mode on a channel.

**Compilation flags:**

`static`

**Template:**

`tx_select(Channel)`

**Mode and number of proofs:**

`tx_select(+compound)` - `one_or_error`

------------------------------------------------------------------------

###### `tx_commit/1`

Commits the current transaction.

**Compilation flags:**

`static`

**Template:**

`tx_commit(Channel)`

**Mode and number of proofs:**

`tx_commit(+compound)` - `one_or_error`

------------------------------------------------------------------------

###### `tx_rollback/1`

Rolls back the current transaction.

**Compilation flags:**

`static`

**Template:**

`tx_rollback(Channel)`

**Mode and number of proofs:**

`tx_rollback(+compound)` - `one_or_error`

------------------------------------------------------------------------

###### `confirm_select/1`

Enables publisher confirms on a channel (RabbitMQ extension).

**Compilation flags:**

`static`

**Template:**

`confirm_select(Channel)`

**Mode and number of proofs:**

`confirm_select(+compound)` - `one_or_error`

------------------------------------------------------------------------

###### `send_heartbeat/1`

Sends a heartbeat frame to the server.

**Compilation flags:**

`static`

**Template:**

`send_heartbeat(Connection)`

**Mode and number of proofs:**

`send_heartbeat(+compound)` - `one_or_error`

------------------------------------------------------------------------

###### `message_body/2`

Extracts the body from a message.

**Compilation flags:**

`static`

**Template:**

`message_body(Message,Body)`

**Mode and number of proofs:**

`message_body(+compound,-term)` - `one`

------------------------------------------------------------------------

###### `message_properties/2`

Extracts the properties from a message as a list.

**Compilation flags:**

`static`

**Template:**

`message_properties(Message,Properties)`

**Mode and number of proofs:**

`message_properties(+compound,-list)` - `one`

------------------------------------------------------------------------

###### `message_property/3`

Extracts a specific property from a message. Fails if not present.

**Compilation flags:**

`static`

**Template:**

`message_property(Message,PropertyName,Value)`

**Mode and number of proofs:**

`message_property(+compound,+atom,-term)` - `zero_or_one`

------------------------------------------------------------------------

###### `message_delivery_tag/2`

Extracts the delivery tag from a message.

**Compilation flags:**

`static`

**Template:**

`message_delivery_tag(Message,DeliveryTag)`

**Mode and number of proofs:**

`message_delivery_tag(+compound,-integer)` - `one`

------------------------------------------------------------------------

###### `message_exchange/2`

Extracts the exchange name from a message.

**Compilation flags:**

`static`

**Template:**

`message_exchange(Message,Exchange)`

**Mode and number of proofs:**

`message_exchange(+compound,-atom)` - `one`

------------------------------------------------------------------------

###### `message_routing_key/2`

Extracts the routing key from a message.

**Compilation flags:**

`static`

**Template:**

`message_routing_key(Message,RoutingKey)`

**Mode and number of proofs:**

`message_routing_key(+compound,-atom)` - `one`

------------------------------------------------------------------------

###### `encode_frame/2`

Encodes an AMQP frame to a list of bytes.

**Compilation flags:**

`static`

**Template:**

`encode_frame(Frame,Bytes)`

**Mode and number of proofs:**

`encode_frame(+compound,-list)` - `one`

------------------------------------------------------------------------

###### `decode_frame/2`

Decodes a list of bytes to an AMQP frame.

**Compilation flags:**

`static`

**Template:**

`decode_frame(Bytes,Frame)`

**Mode and number of proofs:**

`decode_frame(+list,-compound)` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `amqp_pool`

AMQP connection pool category. Import this category into an object to create a named connection pool with automatic connection management.

**Availability:**

`logtalk_load(amqp(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static`

**Uses:**

amqp

list

os

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `initialize/1`

  - `destroy/0`

  - `acquire/1`

  - `release/1`

  - `with_connection/1`

  - `stats/1`

  - `resize/2`

- Protected predicates

- Private predicates

  - `pool_config/5`

  - `available/1`

  - `in_use/2`

- Operators

##### Public predicates

###### `initialize/1`

Initializes the connection pool with the given configuration options. Must be called before using other pool predicates.

**Compilation flags:**

`static`

**Template:**

`initialize(Options)`

**Mode and number of proofs:**

`initialize(+list)` - `one_or_error`

**Remarks:**

> - Option host(Host): AMQP server hostname. Default is localhost.
>
> - Option port(Port): AMQP server port. Default is 5672.
>
> - Option min_size(N): Minimum number of connections to maintain. Default is 1.
>
> - Option max_size(N): Maximum number of connections allowed. Default is 10.
>
> - Option connection_options(Options): Options passed to amqp::connect/4. Default is \[\].

------------------------------------------------------------------------

###### `destroy/0`

Destroys the pool, closing all connections and clearing state.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`destroy` - `one`

------------------------------------------------------------------------

###### `acquire/1`

Acquires a connection from the pool. Returns an available connection or creates a new one if the pool is not at maximum capacity.

**Compilation flags:**

`static`

**Template:**

`acquire(Connection)`

**Mode and number of proofs:**

`acquire(--compound)` - `one_or_error`

**Exceptions:**

Pool not initialized:

`pool_error(not_initialized)`

Pool exhausted (at max capacity):

`pool_error(exhausted)`

------------------------------------------------------------------------

###### `release/1`

Releases a connection back to the pool, making it available for reuse.

**Compilation flags:**

`static`

**Template:**

`release(Connection)`

**Mode and number of proofs:**

`release(+compound)` - `one`

------------------------------------------------------------------------

###### `with_connection/1`

Acquires a connection, calls Goal with the connection as argument, and releases the connection. The connection is released even if Goal fails or throws an exception.

**Compilation flags:**

`static`

**Template:**

`with_connection(Goal)`

**Meta-predicate template:**

`with_connection(1)`

**Mode and number of proofs:**

`with_connection(+callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `stats/1`

Returns pool statistics as a compound term stats(Available, InUse, Total, MinSize, MaxSize).

**Compilation flags:**

`static`

**Template:**

`stats(Stats)`

**Mode and number of proofs:**

`stats(-compound)` - `one`

------------------------------------------------------------------------

###### `resize/2`

Resizes the pool by setting new minimum and maximum sizes.

**Compilation flags:**

`static`

**Template:**

`resize(MinSize,MaxSize)`

**Mode and number of proofs:**

`resize(+integer,+integer)` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `pool_config/5`

Stores the pool configuration parameters.

**Compilation flags:**

`dynamic`

**Template:**

`pool_config(Host,Port,MinSize,MaxSize,ConnectionOptions)`

**Mode and number of proofs:**

`pool_config(?atom,?integer,?integer,?integer,?list)` - `zero_or_one`

------------------------------------------------------------------------

###### `available/1`

Tracks connections that are available for use.

**Compilation flags:**

`dynamic`

**Template:**

`available(Connection)`

**Mode and number of proofs:**

`available(?compound)` - `zero_or_more`

------------------------------------------------------------------------

###### `in_use/2`

Tracks connections currently in use along with their acquisition timestamp.

**Compilation flags:**

`dynamic`

**Template:**

`in_use(Connection,AcquireTimestamp)`

**Mode and number of proofs:**

`in_use(?compound,?compound)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

### arbitrary")

**category**

#### `arbitrary`

Adds predicates for generating and shrinking random values for selected types to the library `type` object. User extensible.

**Availability:**

`logtalk_load(arbitrary(loader))`

**Author:** Paulo Moura

**Version:** 2:37:0

**Date:** 2026-02-11

**Compilation flags:**

`static`

**Complements:**

type

**Uses:**

fast_random

integer

list

type

**Remarks:**

> - Logtalk specific types: `entity`, `object`, `protocol`, `category`, `entity_identifier`, `object_identifier`, `protocol_identifier`, `category_identifier`, `event`, `predicate`.
>
> - Prolog module related types (when the backend compiler supports modules): `module`, `module_identifier`, `qualified_callable`.
>
> - Prolog base types: `term`, `var`, `nonvar`, `atomic`, `atom`, `number`, `integer`, `float`, `compound`, `callable`, `ground`.
>
> - Atom derived types: `non_quoted_atom`, `non_empty_atom`, `non_empty_atom(CharSet)`, `boolean`, `character`, `in_character`, `char`, `operator_specifier`, `hex_char`.
>
> - Atom derived parametric types: `atom(CharSet)`, `atom(CharSet,Length)`, `non_empty_atom(CharSet)`, `character(CharSet)`, `in_character(CharSet)`, `char(CharSet)`.
>
> - Number derived types: `positive_number`, `negative_number`, `non_positive_number`, `non_negative_number`.
>
> - Float derived types: `positive_float`, `negative_float`, `non_positive_float`, `non_negative_float`, `probability`.
>
> - Integer derived types: `positive_integer`, `negative_integer`, `non_positive_integer`, `non_negative_integer`, `byte`, `in_byte`, `character_code`, `in_character_code`, `code`, `operator_priority`, `hex_code`.
>
> - Integer derived parametric types: `character_code(CharSet)`, `in_character_code(CharSet)`, `code(CharSet)`.
>
> - List types (compound derived types): `list`, `non_empty_list`, `partial_list`, `list_or_partial_list`, `list(Type)`, `list(Type,Length)`, `list(Type,Min,Max)`, `list(Type,Length,Min,Max)`, `non_empty_list(Type)`, `codes`, `chars`.
>
> - Difference list types (compound derived types): `difference_list`, `difference_list(Type)`.
>
> - List and difference list types length: The types that do not take a fixed length generate lists with a length in the `[0,MaxSize]` interval (`[1,MaxSize]` for non-empty list types).
>
> - Predicate and non-terminal indicator types arity: These types generate indicators with an arity in the `[0,MaxSize]` interval.
>
> - Other compound derived types: `compound(Name,Types)`, `predicate_indicator`, `non_terminal_indicator`, `predicate_or_non_terminal_indicator`, `clause`, `grammar_rule`, `pair`, `pair(KeyType,ValueType)`.
>
> - Other types: `text`, `text(CharSet)`, `Object::Closure`, `between(Type,Lower,Upper)`, `property(Type,LambdaExpression)`, `one_of(Type,Set)`, `var_or(Type)`, `ground(Type)`, `types(Types)`, `types_frequency(Pairs)`, `transform(Type,Closure)`, `constrain(Type,Closure)`.
>
> - Types `text` and `text(CharSet)` notes: Generate random text represented using either atoms, character lists, or character code lists.
>
> - Type `Object::Closure` notes: Allows calling public object predicates as generators and shrinkers. The `Closure` closure is extended with either a single argument, the generated arbitrary value, or with two arguments, when shrinking a value.
>
> - Type `compound(Name,Types)` notes: Generate a random compound term with the given name with a random argument for each type.
>
> - Type `types_frequency(Pairs)` notes: Generate a random term for one of the types in a list of `Type-Frequency` pairs. The type is randomly selected taking into account the types frequency.
>
> - Type `transform(Type,Closure)` notes: Generate a random term by transforming the term generated for the given type using the given closure.
>
> - Type `constrain(Type,Closure)` notes: Generate a random term for the given type that satisfy the given closure.
>
> - Registering new types: Add clauses for the `arbitrary/1-2` multifile predicates and optionally for the `shrinker/1` and `shrink/3` multifile predicates. The clauses must have a bound first argument to avoid introducing spurious choice-points.
>
> - Shrinking values: The `shrink/3` should either succeed or fail but never throw an exception.
>
> - Character sets: `ascii_identifier`, `ascii_printable`, `ascii_full`, `byte`, `unicode_bmp`, `unicode_full`.
>
> - Default character sets: The default character set when using a parameterizable type that takes a character set parameter depends on the type.
>
> - Default character sets: Entity, predicate, and non-terminal identifier types plus compound and callable types default to an `ascii_identifier` functor. Character and character code types default to `ascii_full`. Other types default to `ascii_printable`.
>
> - Caveats: The type argument (and any type parameterization) to the predicates is not type-checked (or checked for consistency) for performance reasons.
>
> - Unicode limitations: Currently, correct character/code generation is only ensured for SWI-Prolog and XVM as other backends do not provide support for querying a Unicode code point category.

**Inherited public predicates:**

(none)

- Public predicates

  - `arbitrary/1`

  - `arbitrary/2`

  - `shrinker/1`

  - `shrink/3`

  - `shrink_sequence/3`

  - `edge_case/2`

  - `get_seed/1`

  - `set_seed/1`

  - `max_size/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `arbitrary/1`

Table of defined types for which an arbitrary value can be generated. A new type can be registered by defining a clause for this predicate and adding a clause for the `arbitrary/2` multifile predicate.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`arbitrary(Type)`

**Mode and number of proofs:**

`arbitrary(?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `arbitrary/2`

Generates an arbitrary term of the specified type. Fails if the type is not supported. A new generator can be defined by adding a clause for this predicate and registering it via the `arbitrary/1` predicate.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`arbitrary(Type,Term)`

**Meta-predicate template:**

`arbitrary(::,*)`

**Mode and number of proofs:**

`arbitrary(@callable,-term)` - `zero_or_one`

------------------------------------------------------------------------

###### `shrinker/1`

Table of defined types for which a shrinker is provided. A new shrinker can be registered by defining a clause for this predicate and adding a definition for the `shrink/3` multifile predicate.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`shrinker(Type)`

**Mode and number of proofs:**

`shrinker(?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `shrink/3`

Shrinks a value to a smaller value if possible. Must generate a finite number of solutions. Fails if the type is not supported. A new shrinker can be defined by adding a clause for this predicate and registering it via the `shrinker/1` predicate.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`shrink(Type,Large,Small)`

**Mode and number of proofs:**

`shrink(@callable,@term,-term)` - `zero_or_more`

------------------------------------------------------------------------

###### `shrink_sequence/3`

Shrinks a value repeatedly until shrinking is no longer possible returning the sequence of values (ordered from larger to smaller value). Fails if the type is not supported.

**Compilation flags:**

`static`

**Template:**

`shrink_sequence(Type,Value,Sequence)`

**Mode and number of proofs:**

`shrink_sequence(@callable,@term,-list(term))` - `zero_or_one`

------------------------------------------------------------------------

###### `edge_case/2`

Table of type edge cases. Fails if the given type have no defined edge cases. New edge cases for existing or new types can be added by defining a clause for this multifile predicate.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`edge_case(Type,Term)`

**Mode and number of proofs:**

`edge_case(?callable,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `get_seed/1`

Gets the current random generator seed. Seed should be regarded as an opaque ground term.

**Compilation flags:**

`static`

**Template:**

`get_seed(Seed)`

**Mode and number of proofs:**

`get_seed(-ground)` - `one`

------------------------------------------------------------------------

###### `set_seed/1`

Sets the random generator seed to a given value returned by calling the `get_seed/1` predicate.

**Compilation flags:**

`static`

**Template:**

`set_seed(Seed)`

**Mode and number of proofs:**

`set_seed(+ground)` - `one`

------------------------------------------------------------------------

###### `max_size/1`

User defined maximum size for types where its meaningful and implicit. When not defined, defaults to 42. When multiple definitions exist, the first valid one found is used.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`max_size(Size)`

**Mode and number of proofs:**

`max_size(?positive_integer)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

type

### assertions")

**object**

#### `assertions`

Proxy object for simplifying the use of the assertion meta-predicates.

**Availability:**

`logtalk_load(assertions(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2014-04-03

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` assertions(\_)

**Remarks:**

(none)

**Inherited public predicates:**

 assertion/1  assertion/2  goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `assertions(Mode)`

A simple assertions framework. Can be used as a hook object for either suppressing assertions (`production` mode) or expanding them with file context information (`debug` mode).

**Availability:**

`logtalk_load(assertions(loader))`

**Author:** Paulo Moura

**Version:** 2:2:2

**Date:** 2022-07-04

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Uses:**

logtalk

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

  - `assertion/1`

  - `assertion/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `assertion/1`

Checks that an assertion is true. Uses the structured message printing mechanism for printing the results using a silent message for assertion success and a error message for assertion failure.

**Compilation flags:**

`static`

**Template:**

`assertion(Goal)`

**Meta-predicate template:**

`assertion(0)`

**Mode and number of proofs:**

`assertion(@callable)` - `one`

------------------------------------------------------------------------

###### `assertion/2`

Checks that an assertion is true. Uses the structured message printing mechanism for printing the results using a silent message for assertion success and a error message for assertion failure. The context argument can be used to e.g. pass location data.

**Compilation flags:**

`static`

**Template:**

`assertion(Context,Goal)`

**Meta-predicate template:**

`assertion(*,0)`

**Mode and number of proofs:**

`assertion(@term,@callable)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `assertions_messages`

Assertions framework default message translations.

**Availability:**

`logtalk_load(assertions(loader))`

**Author:** Paulo Moura

**Version:** 2:2:0

**Date:** 2018-02-20

**Compilation flags:**

`static`

**Provides:**

logtalk::message_prefix_stream/4

logtalk::message_tokens//2

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### assignvars")

**object**

#### `assignvars`

Assignable variables (supporting backtracable assignment of non-variable terms).

**Availability:**

`logtalk_load(assignvars(loader))`

**Author:** Nobukuni Kino and Paulo Moura

**Version:** 1:7:0

**Date:** 2018-07-11

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` assignvarsp

**Remarks:**

(none)

**Inherited public predicates:**

 (\<=)/2  (=\>)/2  assignable/1  assignable/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `assignvarsp`

Assignable variables (supporting backtracable assignment of non-variable terms) protocol.

**Availability:**

`logtalk_load(assignvars(loader))`

**Author:** Nobukuni Kino and Paulo Moura

**Version:** 1:0:1

**Date:** 2019-06-10

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `assignable/1`

  - `assignable/2`

  - `(<=)/2`

  - `(=>)/2`

- Protected predicates

- Private predicates

- Operators

  - `op(100,xfx,<=)`

  - `op(100,xfx,=>)`

##### Public predicates

###### `assignable/1`

Makes `Variable` an assignable variable. Initial state will be empty.

**Compilation flags:**

`static`

**Template:**

`assignable(Variable)`

**Mode and number of proofs:**

`assignable(--assignvar)` - `one`

**Exceptions:**

Variable is not a variable:

`type_error(variable,Variable)`

------------------------------------------------------------------------

###### `assignable/2`

Makes `Variable` an assignable variable and sets its initial state to `Value`.

**Compilation flags:**

`static`

**Template:**

`assignable(Variable,Value)`

**Mode and number of proofs:**

`assignable(--assignvar,@nonvar)` - `one`

**Exceptions:**

Variable is not a variable:

`type_error(variable,Variable)`

Value is not instantiated:

`instantiation_error`

------------------------------------------------------------------------

###### `(<=)/2`

Sets the state of the assignable variable `Variable` to `Value` (initializing the variable if needed).

**Compilation flags:**

`static`

**Template:**

`Variable<=Value`

**Mode and number of proofs:**

`(?assignvar)<=(@nonvar)` - `one`

**Exceptions:**

Value is not instantiated:

`instantiation_error`

------------------------------------------------------------------------

###### `(=>)/2`

Unifies `Value` with the current state of the assignable variable `Variable`.

**Compilation flags:**

`static`

**Template:**

`Variable=>Value`

**Mode and number of proofs:**

`+assignvar=>`` ``?nonvar` - `zero_or_one`

**Exceptions:**

Variable is not instantiated:

`instantiation_error`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

###### `op(100,xfx,<=)`

**Scope:**

`public`

###### `op(100,xfx,=>)`

**Scope:**

`public`

See also

assignvars

### avro")

**object**

#### `avro`

Apache Avro binary format parser and generator.

**Availability:**

`logtalk_load(avro(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-05

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

json(ObjectRepresentation,PairRepresentation,StringRepresentation)

list

reader

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `parse/3`

  - `generate/3`

  - `generate/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses Avro binary data from the given source (`bytes(List)`, `stream(Stream)`, or `file(Path)`) returning a `Schema-Data` pair. When the schema is not present in the file, `Schema` is unified with `false`.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Schema-Data)`

**Mode and number of proofs:**

`parse(++compound,--pair)` - `one_or_error`

------------------------------------------------------------------------

###### `parse/3`

Parses Avro binary data from the given source using the provided schema, returning the decoded data.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Schema,Data)`

**Mode and number of proofs:**

`parse(++compound,++term,--term)` - `one_or_error`

------------------------------------------------------------------------

###### `generate/3`

Generates Avro binary data to the given sink (`bytes(List)`, `stream(Stream)`, or `file(Path)`) from the given schema and data. The schema is not included in the output.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Schema,Data)`

**Mode and number of proofs:**

`generate(++compound,++term,++term)` - `one_or_error`

------------------------------------------------------------------------

###### `generate/4`

Generates Avro binary data to the given sink from the given schema and data. When `IncludeSchema` is `true`, generates an Avro Object Container File with the schema embedded.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,IncludeSchema,Schema,Data)`

**Mode and number of proofs:**

`generate(++compound,++boolean,++term,++term)` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### base32")

**object**

#### `base32`

Base32 encoder and decoder (RFC 4648).

**Availability:**

`logtalk_load(base32(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2025-01-23

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

reader

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses Base32 data from the given source (`atom(Atom)`, `chars(List)`, `codes(List)`, `stream(Stream)`, or `file(Path)`) into a list of bytes.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Bytes)`

**Mode and number of proofs:**

`parse(++compound,--list(byte))` - `one_or_error`

------------------------------------------------------------------------

###### `generate/2`

Generates Base32 in the representation specified in the first argument (`atom(Atom)`, `chars(List)`, `codes(List)`, `stream(Stream)`, or `file(Path)`) for the list of bytes in the second argument.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Bytes)`

**Mode and number of proofs:**

`generate(+compound,+list(byte))` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### base58")

**object**

#### `base58`

Base58 encoder and decoder (Bitcoin alphabet variant).

**Availability:**

`logtalk_load(base58(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2025-01-23

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses Base58 data from the given source (`atom(Atom)`, `chars(List)`, or `codes(List)`) into a list of bytes.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Bytes)`

**Mode and number of proofs:**

`parse(++compound,--list(byte))` - `one_or_error`

------------------------------------------------------------------------

###### `generate/2`

Generates Base58 in the representation specified in the first argument (`atom(Atom)`, `chars(List)`, or `codes(List)`) for the list of bytes in the second argument.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Bytes)`

**Mode and number of proofs:**

`generate(+compound,+list(byte))` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### base64")

**object**

#### `base64`

Base64 parser and generator.

**Availability:**

`logtalk_load(base64(loader))`

**Author:** Paulo Moura

**Version:** 0:10:0

**Date:** 2021-03-22

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

reader

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses the Base64 data from the given source (`atom(Atom)`, `chars(List)`, `codes(List)`, `stream(Stream)`, or `file(Path)` into a list of bytes.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Bytes)`

**Mode and number of proofs:**

`parse(++compound,--list(byte))` - `one_or_error`

------------------------------------------------------------------------

###### `generate/2`

Generates Base64 in the representation specified in the first argument (`atom(Atom)`, `chars(List)`, `codes(List)`, `stream(Stream)`, or `file(Path)` for the list of bytes in the second argument.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Bytes)`

**Mode and number of proofs:**

`generate(+compound,+list(byte))` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `base64url`

Base64URL parser and generator.

**Availability:**

`logtalk_load(base64(loader))`

**Author:** Paulo Moura

**Version:** 0:9:0

**Date:** 2021-03-10

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses the Base64URL data from the given source (`atom(Atom)`, `chars(List)`, or `codes(List)` into a URL (using the same format as the source).

**Compilation flags:**

`static`

**Template:**

`parse(Source,URL)`

**Mode and number of proofs:**

`parse(++compound,--types([atom,chars,codes]))` - `one_or_error`

------------------------------------------------------------------------

###### `generate/2`

Generates Base64URL data in the representation specified in the first argument (`atom(Atom)`, `chars(List)`, or `codes(List)` for the given URL (given in the same format as the sink).

**Compilation flags:**

`static`

**Template:**

`generate(Sink,URL)`

**Mode and number of proofs:**

`generate(+compound,+types([atom,chars,codes]))` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### base85")

**object**

#### `base85`

Base85 encoder and decoder (Ascii85/btoa variant).

**Availability:**

`logtalk_load(base85(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2025-01-23

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses Base85 (Ascii85) data from the given source (`atom(Atom)`, `chars(List)`, or `codes(List)`) into a list of bytes.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Bytes)`

**Mode and number of proofs:**

`parse(++compound,--list(byte))` - `one_or_error`

------------------------------------------------------------------------

###### `generate/2`

Generates Base85 (Ascii85) in the representation specified in the first argument (`atom(Atom)`, `chars(List)`, or `codes(List)`) for the list of bytes in the second argument.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Bytes)`

**Mode and number of proofs:**

`generate(+compound,+list(byte))` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### c45")

**object**

#### `c45`

C4.5 decision tree learning algorithm. Builds a decision tree from a dataset object implementing the `dataset_protocol` protocol and provides predicates for exporting the learned tree as a list of predicate clauses or to a file. Supports both discrete and continuous attributes, handles missing values, and supports tree pruning.

**Availability:**

`logtalk_load(c45(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` classifier_protocol

**Uses:**

format

list

numberlist

pairs

**Remarks:**

> - Algorithm: C4.5 is an extension of the ID3 algorithm that uses information gain ratio instead of information gain for attribute selection, which avoids bias towards attributes with many values.
>
> - Discrete attributes: The learned decision tree is represented as `leaf(Class)` for leaf nodes and `tree(Attribute,`` ``Subtrees)` for internal nodes with discrete attributes, where `Subtrees` is a list of `Value-Subtree` pairs.
>
> - Continuous attributes: For continuous (numeric) attributes, the tree uses binary threshold splits represented as `tree(Attribute,`` ``threshold(Threshold),`` ``LeftSubtree,`` ``RightSubtree)` where `LeftSubtree` corresponds to values `=<`` ``Threshold` and `RightSubtree` to values `>`` ``Threshold`.
>
> - Missing values: Missing attribute values are represented using anonymous variables. During tree construction, examples with missing values for the split attribute are distributed to all branches. Entropy and gain calculations use only examples with known values for the attribute being evaluated.
>
> - Tree pruning: The `prune/3` and `prune/5` predicates implement pessimistic error pruning (PEP), which estimates error rates using the upper confidence bound of the binomial distribution (Wilson score interval) with a configurable confidence factor (default 0.25, range `(0.0,`` ``1.0)`) and minimum instances per leaf (default 2). Subtrees are replaced with leaf nodes when doing so would not increase the estimated error.

**Inherited public predicates:**

 classifier_to_clauses/4  classifier_to_file/4  learn/2  predict/3  print_classifier/1

- Public predicates

  - `prune/5`

  - `prune/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `prune/5`

Prunes a decision tree using pessimistic error pruning (PEP). This post-pruning method estimates error rates using the upper confidence bound of the binomial distribution with the given confidence factor and replaces subtrees with leaf nodes when doing so would not increase the estimated error. Pruning helps reduce overfitting and can improve generalization to unseen data.

**Compilation flags:**

`static`

**Template:**

`prune(Dataset,Tree,ConfidenceFactor,MinInstances,PrunedTree)`

**Mode and number of proofs:**

`prune(+object_identifier,+tree,+float,+positive_integer,-tree)` - `one`

**Remarks:**

> - Confidence factor: The confidence factor controls the aggressiveness of pruning. It must be in the range `(0.0,`` ``1.0)`. Lower values result in more aggressive pruning (smaller, simpler trees), while higher values result in less pruning (larger, more complex trees). The default value is `0.25`.
>
> - Minimum instances per leaf: The minimum number of instances required at a leaf node. When a node has fewer instances than this value, the node may be pruned. It must be a positive integer. The default value is `2`.
>
> - Statistical basis: The pruning uses the upper confidence bound of the binomial distribution to estimate the true error rate.

------------------------------------------------------------------------

###### `prune/3`

Prunes a decision tree using pessimistic error pruning (PEP) with default parameter values. Calls `prune/5` with `ConfidenceFactor`` ``=`` ``0.25` and `MinInstances`` ``=`` ``2`.

**Compilation flags:**

`static`

**Template:**

`prune(Dataset,Tree,PrunedTree)`

**Mode and number of proofs:**

`prune(+object_identifier,+tree,-tree)` - `one`

**Remarks:**

> - Default parameters: Uses the standard C4.5 default values: confidence factor of `0.25` (the confidence level for computing the upper bound of the error estimate) and minimum instances per leaf of `2`.

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

dataset_protocol, isolation_forest, knn, naive_bayes, nearest_centroid, random_forest, ada_boost

### cbor")

**object**

#### `cbor`

Concise Binary Object Representation (CBOR) format exporter and importer. Uses atoms to represent decoded CBOR strings.

**Availability:**

`logtalk_load(cbor(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2021-03-04

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` cbor(atom)

**Remarks:**

(none)

**Inherited public predicates:**

 generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `cbor(StringRepresentation)`

- `StringRepresentation` - Text representation to be used when decoding CBOR strings. Possible values are `atom` (default), `chars`, and `codes`.

Concise Binary Object Representation (CBOR) format exporter and importer.

**Availability:**

`logtalk_load(cbor(loader))`

**Author:** Paulo Moura

**Version:** 0:11:1

**Date:** 2021-12-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses a list of bytes in the CBOR format returning the corresponding term representation. Throws an error when parsing is not possible (usually due to an invalid byte sequence).

**Compilation flags:**

`static`

**Template:**

`parse(Bytes,Term)`

**Mode and number of proofs:**

`parse(@list(byte),-ground)` - `one_or_error`

------------------------------------------------------------------------

###### `generate/2`

Generates a list of bytes in the CBOR format representing the given term. Throws an error when generating is not possible (usually due to a term that have no CBOR corresponding representation).

**Compilation flags:**

`static`

**Template:**

`generate(Term,Bytes)`

**Mode and number of proofs:**

`generate(@ground,-list(byte))` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### ccsds")

**object**

#### `ccsds`

CCSDS Space Packet parser with no secondary header parsing. For secondary header support, use ccsds(Length) where Length is the secondary header size in bytes.

**Availability:**

`logtalk_load(ccsds(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2025-12-05

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` ccsds(0)

**Remarks:**

(none)

**Inherited public predicates:**

 apid/2  data_length/2  generate/2  generate/3  parse/2  secondary_header/2  secondary_header_flag/2  secondary_header_time/2  sequence_count/2  sequence_flags/2  type/2  user_data/2  version/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `ccsds(SecondaryHeaderLength)`

- `SecondaryHeaderLength` - Length in bytes of the secondary header when present (0 for no secondary header parsing, or a positive integer).

CCSDS Space Packet parser following the CCSDS 133.0-B-2 standard. Parses binary packet data including optional secondary headers.

**Availability:**

`logtalk_load(ccsds(loader))`

**Author:** Paulo Moura

**Version:** 0:5:1

**Date:** 2026-02-04

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

list

reader

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

  - `generate/3`

  - `version/2`

  - `type/2`

  - `secondary_header_flag/2`

  - `apid/2`

  - `sequence_flags/2`

  - `sequence_count/2`

  - `data_length/2`

  - `user_data/2`

  - `secondary_header/2`

  - `secondary_header_time/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses CCSDS packet(s) from a source into a list of packet terms. The source can be `file(File)`, `stream(Stream)`, or `bytes(Bytes)`.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Packets)`

**Mode and number of proofs:**

`parse(+compound,-list(compound))` - `one_or_error`

**Exceptions:**

`Source` is a variable:

`instantiation_error`

`Source` is neither a variable nor a valid source:

`domain_error(ccsds_source,Source)`

`Source` is a valid source but the data cannot be parsed as a CCSDS packet:

`domain_error(ccsds_byte_sequence,Bytes)`

------------------------------------------------------------------------

###### `generate/2`

Generates CCSDS packet bytes to a sink from a list of packet terms. The sink can be `file(File)`, `stream(Stream)`, or `bytes(Bytes)`. For `file(File)` and `stream(Stream)`, writes to the binary file or stream. For `bytes(Bytes)`, unifies Bytes with the generated byte list.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Packets)`

**Mode and number of proofs:**

`generate(+compound,+list(compound))` - `one_or_error`

**Exceptions:**

`Sink` is a variable:

`instantiation_error`

`Sink` is neither a variable nor a valid sink:

`domain_error(ccsds_sink,Sink)`

`Packets` is a partial list or a list with an element `Packet` which is a variable:

`instantiation_error`

An element `Packet` of the list `Packets` is neither a variable nor a valid CCSDS packet term:

`domain_error(ccsds_packet_term,Packet)`

------------------------------------------------------------------------

###### `generate/3`

Generates a list of bytes from a CCSDS packet term with an open tail. Mainly used when generating arbitrary CCSDS packets.

**Compilation flags:**

`static`

**Template:**

`generate(Packet,Bytes,Tail)`

**Mode and number of proofs:**

`generate(+compound,-list(byte),--variable)` - `one_or_error`

**Exceptions:**

`Packet` is a variable:

`instantiation_error`

`Packet` is neither a variable nor a valid CCSDS packet term:

`domain_error(ccsds_packet_term,Packet)`

------------------------------------------------------------------------

###### `version/2`

Extracts the version number from a packet (always 0 for CCSDS Space Packets).

**Compilation flags:**

`static`

**Template:**

`version(Packet,Version)`

**Mode and number of proofs:**

`version(+compound,-integer)` - `one`

------------------------------------------------------------------------

###### `type/2`

Extracts the packet type from a packet. Returns `telemetry` or `telecommand`.

**Compilation flags:**

`static`

**Template:**

`type(Packet,Type)`

**Mode and number of proofs:**

`type(+compound,-atom)` - `one`

------------------------------------------------------------------------

###### `secondary_header_flag/2`

Extracts the secondary header flag. Returns `absent` or `present`.

**Compilation flags:**

`static`

**Template:**

`secondary_header_flag(Packet,Flag)`

**Mode and number of proofs:**

`secondary_header_flag(+compound,-atom)` - `one`

------------------------------------------------------------------------

###### `apid/2`

Extracts the Application Process Identifier (APID) from a packet.

**Compilation flags:**

`static`

**Template:**

`apid(Packet,APID)`

**Mode and number of proofs:**

`apid(+compound,-integer)` - `one`

------------------------------------------------------------------------

###### `sequence_flags/2`

Extracts the sequence flags. Returns `continuation`, `first`, `last`, or `standalone`.

**Compilation flags:**

`static`

**Template:**

`sequence_flags(Packet,Flags)`

**Mode and number of proofs:**

`sequence_flags(+compound,-atom)` - `one`

------------------------------------------------------------------------

###### `sequence_count/2`

Extracts the packet sequence count (0-16383).

**Compilation flags:**

`static`

**Template:**

`sequence_count(Packet,Count)`

**Mode and number of proofs:**

`sequence_count(+compound,-integer)` - `one`

------------------------------------------------------------------------

###### `data_length/2`

Extracts the packet data length field value.

**Compilation flags:**

`static`

**Template:**

`data_length(Packet,Length)`

**Mode and number of proofs:**

`data_length(+compound,-integer)` - `one`

------------------------------------------------------------------------

###### `user_data/2`

Extracts the user data field as a list of bytes.

**Compilation flags:**

`static`

**Template:**

`user_data(Packet,Data)`

**Mode and number of proofs:**

`user_data(+compound,-list(byte))` - `one`

------------------------------------------------------------------------

###### `secondary_header/2`

Extracts the secondary header. Returns none if not present, or secondary_header(Bytes) with the raw bytes.

**Compilation flags:**

`static`

**Template:**

`secondary_header(Packet,SecondaryHeader)`

**Mode and number of proofs:**

`secondary_header(+compound,-compound)` - `one`

------------------------------------------------------------------------

###### `secondary_header_time/2`

Extracts time from a secondary header as cuc_time(Coarse, Fine) for CCSDS Unsegmented Time Code. Fails if no secondary header or time cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`secondary_header_time(Packet,Time)`

**Mode and number of proofs:**

`secondary_header_time(+compound,-compound)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `ccsds_types`

Type definitions and arbitrary generators for CCSDS packets.

**Availability:**

`logtalk_load(ccsds(loader))`

**Author:** Paulo Moura

**Version:** 0:5:0

**Date:** 2025-12-15

**Compilation flags:**

`static`

**Provides:**

type::type/1

type::check/2

arbitrary::arbitrary/1

arbitrary::arbitrary/2

**Uses:**

ccsds(SecondaryHeaderLength)

type

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### classifier_protocols")

**protocol**

#### `classifier_protocol`

Protocol for machine learning classifiers.

**Availability:**

`logtalk_load(classifier_protocols(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `learn/2`

  - `predict/3`

  - `classifier_to_clauses/4`

  - `classifier_to_file/4`

  - `print_classifier/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `learn/2`

Learns a classifier from the given dataset object.

**Compilation flags:**

`static`

**Template:**

`learn(Dataset,Classifier)`

**Mode and number of proofs:**

`learn(+object_identifier,-compound)` - `one`

------------------------------------------------------------------------

###### `predict/3`

Predicts the class label for a new instance using the learned classifier. The instance is a list of `Attribute-Value` pairs.

**Compilation flags:**

`static`

**Template:**

`predict(Classifier,Instance,Class)`

**Mode and number of proofs:**

`predict(+compound,+list,-atom)` - `one`

------------------------------------------------------------------------

###### `classifier_to_clauses/4`

Converts a classifier into a list of predicate clauses. `Functor` is the functor for the generated predicate clauses.

**Compilation flags:**

`static`

**Template:**

`classifier_to_clauses(Dataset,Classifier,Functor,Clauses)`

**Mode and number of proofs:**

`classifier_to_clauses(+object_identifier,+compound,+callable,-list(clause))` - `one`

------------------------------------------------------------------------

###### `classifier_to_file/4`

Exports a classifier to a file. `Functor` is the functor for the generated predicate clauses.

**Compilation flags:**

`static`

**Template:**

`classifier_to_file(Dataset,Classifier,Functor,File)`

**Mode and number of proofs:**

`classifier_to_file(+object_identifier,+compound,+callable,+atom)` - `one`

------------------------------------------------------------------------

###### `print_classifier/1`

Prints a classifier to the current output stream in a human-readable format.

**Compilation flags:**

`static`

**Template:**

`print_classifier(Classifier)`

**Mode and number of proofs:**

`print_classifier(+compound)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

c45, isolation_forest, knn, naive_bayes, nearest_centroid, random_forest

**protocol**

#### `dataset_protocol`

Protocol for datasets used with classifier algorithms.

**Availability:**

`logtalk_load(classifier_protocols(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `attribute_values/2`

  - `class/1`

  - `class_values/1`

  - `example/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `attribute_values/2`

Enumerates by backtracking the attributes and their possible values. For discrete attributes, `Values` is a list of possible values. For continuous (numeric) attributes, `Values` is the atom `continuous`.

**Compilation flags:**

`static`

**Template:**

`attribute_values(Attribute,Values)`

**Mode and number of proofs:**

`attribute_values(?atom,-list(atom))` - `zero_or_more`

`attribute_values(?atom,-atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `class/1`

Returns the name of the target class attribute.

**Compilation flags:**

`static`

**Template:**

`class(Class)`

**Mode and number of proofs:**

`class(-atom)` - `one`

------------------------------------------------------------------------

###### `class_values/1`

Returns the list of possible values for the target class attribute.

**Compilation flags:**

`static`

**Template:**

`class_values(Values)`

**Mode and number of proofs:**

`class_values(-list(atom))` - `one`

------------------------------------------------------------------------

###### `example/3`

Enumerates by backtracking the examples in the dataset. Each example has an `Id`, a `Class` value, and a list of `Attribute-Value` pairs.

**Compilation flags:**

`static`

**Template:**

`example(Id,Class,AttributeValues)`

**Mode and number of proofs:**

`example(-integer,-atom,-list(pair))` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### code_metrics")

**object**

#### `cc_metric`

Cyclomatic complexity metric. All defined predicates that are not called or updated are counted as graph connected components (the reasoning being that these predicates can be considered entry points). The score is represented by a non-negative integer.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Paulo Moura

**Version:** 0:5:2

**Date:** 2024-05-15

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metrics_utilities

`public` code_metric

**Provides:**

logtalk::message_tokens//2

**Uses:**

list

logtalk

numberlist

**Remarks:**

(none)

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `code_metric`

Core predicates for computing source code metrics.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Ebrahim Azarisooreh and Paulo Moura

**Version:** 0:13:0

**Date:** 2025-10-06

**Compilation flags:**

`static`

**Extends:**

`public` code_metrics_utilities

`public` options

**Uses:**

list

logtalk

os

type

**Remarks:**

(none)

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  option/2  option/3  valid_option/1  valid_options/1

- Public predicates

  - `entity/1`

  - `file/2`

  - `file/1`

  - `directory/2`

  - `directory/1`

  - `rdirectory/2`

  - `rdirectory/1`

  - `library/2`

  - `library/1`

  - `rlibrary/2`

  - `rlibrary/1`

  - `all/1`

  - `all/0`

  - `entity_score/2`

  - `library_score/2`

  - `rlibrary_score/2`

  - `file_score/2`

  - `directory_score/2`

  - `rdirectory_score/2`

  - `all_score/1`

  - `format_entity_score//2`

- Protected predicates

  - `process_entity/2`

  - `process_file/2`

  - `process_directory/2`

  - `process_rdirectory/2`

  - `process_library/2`

  - `process_rlibrary/2`

  - `process_all/1`

  - `sub_directory/2`

  - `sub_library/2`

- Private predicates

- Operators

##### Public predicates

###### `entity/1`

Scans an entity and prints its metric score.

**Compilation flags:**

`static`

**Template:**

`entity(Entity)`

**Mode and number of proofs:**

`entity(+term)` - `zero_or_one`

------------------------------------------------------------------------

###### `file/2`

Prints metric scores for all the entities defined in a loaded source file using the given options.

**Compilation flags:**

`static`

**Template:**

`file(File,Options)`

**Mode and number of proofs:**

`file(+atom,+list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `file/1`

Prints metric scores for all the entities defined in a loaded source file using default options.

**Compilation flags:**

`static`

**Template:**

`file(File)`

**Mode and number of proofs:**

`file(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `directory/2`

Scans a directory and prints metric scores for all entities defined in its loaded source files using the given options.

**Compilation flags:**

`static`

**Template:**

`directory(Directory,Options)`

**Mode and number of proofs:**

`directory(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `directory/1`

Scans a directory and prints metric scores for all entities defined in its loaded source files using default options.

**Compilation flags:**

`static`

**Template:**

`directory(Directory)`

**Mode and number of proofs:**

`directory(+atom)` - `one`

------------------------------------------------------------------------

###### `rdirectory/2`

Recursive version of the `directory/1` predicate using the given options.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Directory,Options)`

**Mode and number of proofs:**

`rdirectory(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `rdirectory/1`

Recursive version of the `directory/1` predicate using default options.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Directory)`

**Mode and number of proofs:**

`rdirectory(+atom)` - `one`

------------------------------------------------------------------------

###### `library/2`

Prints metrics scores for all loaded entities from a given library using the given options.

**Compilation flags:**

`static`

**Template:**

`library(Library,Options)`

**Mode and number of proofs:**

`library(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `library/1`

Prints metrics scores for all loaded entities from a given library using default options.

**Compilation flags:**

`static`

**Template:**

`library(Library)`

**Mode and number of proofs:**

`library(+atom)` - `one`

------------------------------------------------------------------------

###### `rlibrary/2`

Recursive version of the `library/1` predicate using the given options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library,Options)`

**Mode and number of proofs:**

`rlibrary(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `rlibrary/1`

Recursive version of the `library/1` predicate using default options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library)`

**Mode and number of proofs:**

`rlibrary(+atom)` - `one`

------------------------------------------------------------------------

###### `all/1`

Scans all loaded entities and prints their metric scores using the given options.

**Compilation flags:**

`static`

**Template:**

`all(Options)`

**Mode and number of proofs:**

`all(+list(compound))` - `one`

------------------------------------------------------------------------

###### `all/0`

Scans all loaded entities and prints their metric scores using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`all` - `one`

------------------------------------------------------------------------

###### `entity_score/2`

Score is a term that represents the metric score associated with a loaded entity. Fails if the metric does not apply.

**Compilation flags:**

`static`

**Template:**

`entity_score(Entity,Score)`

**Mode and number of proofs:**

`entity_score(@entity_identifier,-ground)` - `zero_or_one`

------------------------------------------------------------------------

###### `library_score/2`

Score is a term that represents the metric score associated with a loaded library source files. Fails if the metric does not apply.

**Compilation flags:**

`static`

**Template:**

`library_score(Library,Score)`

**Mode and number of proofs:**

`library_score(@atom,-ground)` - `zero_or_one`

------------------------------------------------------------------------

###### `rlibrary_score/2`

Score is a term that represents the metric score associated with loaded source files from a library and its sub-libraries. Fails if the metric does not apply.

**Compilation flags:**

`static`

**Template:**

`rlibrary_score(Library,Score)`

**Mode and number of proofs:**

`rlibrary_score(@atom,-ground)` - `zero_or_one`

------------------------------------------------------------------------

###### `file_score/2`

Score is a term that represents the metric score associated with a loaded source file. Fails if the metric does not apply.

**Compilation flags:**

`static`

**Template:**

`file_score(File,Score)`

**Mode and number of proofs:**

`file_score(@atom,-ground)` - `zero_or_one`

------------------------------------------------------------------------

###### `directory_score/2`

Score is a term that represents the metric score associated with loaded source files from a directory. Fails if the metric does not apply.

**Compilation flags:**

`static`

**Template:**

`directory_score(Directory,Score)`

**Mode and number of proofs:**

`directory_score(@atom,-ground)` - `zero_or_one`

------------------------------------------------------------------------

###### `rdirectory_score/2`

Score is a term that represents the metric score associated with loaded source files from a directory and its sub-directories. Fails if the metric does not apply.

**Compilation flags:**

`static`

**Template:**

`rdirectory_score(Directory,Score)`

**Mode and number of proofs:**

`rdirectory_score(@atom,-ground)` - `zero_or_one`

------------------------------------------------------------------------

###### `all_score/1`

Score is a term that represents the metric score associated with all loaded source files. Fails if the metric does not apply.

**Compilation flags:**

`static`

**Template:**

`all_score(Score)`

**Mode and number of proofs:**

`all_score(-ground)` - `zero_or_one`

------------------------------------------------------------------------

###### `format_entity_score//2`

Formats the entity score for pretty printing.

**Compilation flags:**

`static`

**Template:**

`format_entity_score(Entity,Score)`

**Mode and number of proofs:**

`format_entity_score(@entity_identifier,+ground)` - `one`

------------------------------------------------------------------------

##### Protected predicates

###### `process_entity/2`

Processes an entity of the given kind.

**Compilation flags:**

`static`

**Template:**

`process_entity(Kind,Entity)`

**Mode and number of proofs:**

`process_entity(+atom,@entity_identifier)` - `one`

------------------------------------------------------------------------

###### `process_file/2`

Processes a source file using the given options.

**Compilation flags:**

`static`

**Template:**

`process_file(Path,Options)`

**Mode and number of proofs:**

`process_file(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `process_directory/2`

Processes a directory of source files using the given options.

**Compilation flags:**

`static`

**Template:**

`process_directory(Path,Options)`

**Mode and number of proofs:**

`process_directory(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `process_rdirectory/2`

Recursively process a directory of source files using the given options.

**Compilation flags:**

`static`

**Template:**

`process_rdirectory(Path,Options)`

**Mode and number of proofs:**

`process_rdirectory(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `process_library/2`

Processes a library of source files using the given options.

**Compilation flags:**

`static`

**Template:**

`process_library(Library,Options)`

**Mode and number of proofs:**

`process_library(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `process_rlibrary/2`

Recursively process a library of source files using the given options.

**Compilation flags:**

`static`

**Template:**

`process_rlibrary(Library,Options)`

**Mode and number of proofs:**

`process_rlibrary(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `process_all/1`

Processes all loaded source code using the given options.

**Compilation flags:**

`static`

**Template:**

`process_all(Options)`

**Mode and number of proofs:**

`process_all(+list(compound))` - `one`

------------------------------------------------------------------------

###### `sub_directory/2`

Enumerates, by backtracking, all directory sub-directories containing loaded files.

**Compilation flags:**

`static`

**Template:**

`sub_directory(Directory,SubDirectory)`

**Mode and number of proofs:**

`sub_directory(+atom,-atom)` - `one`

------------------------------------------------------------------------

###### `sub_library/2`

Enumerates, by backtracking, all library sub-libraries.

**Compilation flags:**

`static`

**Template:**

`sub_library(Library,SubLibrary)`

**Mode and number of proofs:**

`sub_library(+atom,-atom)` - `one`

------------------------------------------------------------------------

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `code_metrics`

Helper object to apply all loaded code metrics.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Ebrahim Azarisooreh and Paulo Moura

**Version:** 0:1:0

**Date:** 2017-12-31

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metric

**Uses:**

logtalk

**Remarks:**

(none)

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `code_metrics_messages`

Message translations for the `code_metrics` tool.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Ebrahim Azarisooreh and Paulo Moura

**Version:** 0:8:0

**Date:** 2022-05-05

**Compilation flags:**

`static`

**Provides:**

logtalk::message_prefix_stream/4

logtalk::message_tokens//2

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `code_metrics_utilities`

Internal predicates for analyzing source code.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Ebrahim Azarisooreh

**Version:** 0:7:0

**Date:** 2024-03-28

**Compilation flags:**

`static`

**Uses:**

list

logtalk

**Remarks:**

> - Usage: This is meant to be imported by any metric added to the system.
>
> - Predicate Scope: This is meant for internal use by metrics only. As such, all provided predicates are protected.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

  - `ancestor/4`

  - `current_entity/1`

  - `declares_predicate/2`

  - `defines_predicate/2`

  - `defines_predicate/3`

  - `entity_calls/3`

  - `entity_kind/2`

  - `entity_property/2`

  - `entity_updates/3`

  - `not_excluded_file/3`

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

###### `ancestor/4`

True if `Entity` descends from `Ancestor`, and `EntityKind` and `AncestorKind` unify with their respective entity types.

**Compilation flags:**

`static`

**Template:**

`ancestor(EntityKind,Entity,AncestorKind,Ancestor)`

**Mode and number of proofs:**

`ancestor(?entity,?entity_identifier,?entity,?entity_identifier)` - `zero_or_more`

------------------------------------------------------------------------

###### `current_entity/1`

True if `Entity` is a currently loaded entity.

**Compilation flags:**

`static`

**Template:**

`current_entity(Entity)`

**Mode and number of proofs:**

`current_entity(?entity_identifier)` - `zero_or_more`

------------------------------------------------------------------------

###### `declares_predicate/2`

True if `Entity` declares `Predicate` internally.

**Compilation flags:**

`static`

**Template:**

`declares_predicate(Entity,Predicate)`

**Mode and number of proofs:**

`declares_predicate(?entity_identifier,?predicate_indicator)` - `zero_or_more`

------------------------------------------------------------------------

###### `defines_predicate/2`

True if `Entity` defines an implementation of `Predicate` internally. Auxiliary predicates are excluded from results.

**Compilation flags:**

`static`

**Template:**

`defines_predicate(Entity,Predicate)`

**Mode and number of proofs:**

`defines_predicate(?entity_identifier,?predicate_indicator)` - `zero_or_more`

------------------------------------------------------------------------

###### `defines_predicate/3`

Same as `defines_predicate/2`, except `Property` is unified with a property of the predicate.

**Compilation flags:**

`static`

**Template:**

`defines_predicate(Entity,Predicate,Property)`

**Mode and number of proofs:**

`defines_predicate(?entity_identifier,?predicate_indicator,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `entity_calls/3`

True if a predicate `Caller` within `Entity` makes a `Call`.

**Compilation flags:**

`static`

**Template:**

`entity_calls(Entity,Caller,Call)`

**Mode and number of proofs:**

`entity_calls(?entity_identifier,?predicate_indicator,?predicate_indicator)` - `zero_or_one`

------------------------------------------------------------------------

###### `entity_kind/2`

True if `Kind` defines `Entity` and is one of category, protocol, or object.

**Compilation flags:**

`static`

**Template:**

`entity_kind(Entity,Kind)`

**Mode and number of proofs:**

`entity_kind(+entity_identifier,-entity)` - `zero_or_one`

------------------------------------------------------------------------

###### `entity_property/2`

True if `Property` is a valid property of `Entity`. Entity can be either a category, a protocol, or an object.

**Compilation flags:**

`static`

**Template:**

`entity_property(Entity,Property)`

**Mode and number of proofs:**

`entity_property(+entity_identifier,-term)` - `zero_or_more`

------------------------------------------------------------------------

###### `entity_updates/3`

True if a predicate `Updater` within `Entity` makes a dynamic update to `Updated` (by using e.g. the `asserta/1` or `retract/1` predicates).

**Compilation flags:**

`static`

**Template:**

`entity_updates(Entity,Updater,Updated)`

**Mode and number of proofs:**

`entity_updates(+entity_identifier,?predicate_indicator,?predicate_indicator)` - `zero_or_one`

------------------------------------------------------------------------

###### `not_excluded_file/3`

True if the file is not being excluded.

**Compilation flags:**

`static`

**Template:**

`not_excluded_file(ExcludedFiles,Path,Basename)`

**Mode and number of proofs:**

`not_excluded_file(+list(atom),+atom,+atom)` - `zero_or_one`

------------------------------------------------------------------------

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `coupling_metric`

Computes entity efferent coupling, afferent coupling, and instability.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Ebrahim Azarisooreh and Paulo Moura

**Version:** 0:14:0

**Date:** 2024-03-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metrics_utilities

`public` code_metric

**Uses:**

list

**Remarks:**

> - Efferent coupling (Ce): Number of entities that an entity depends on.
>
> - Afferent coupling (Ca): Number of entities that depend on an entity.
>
> - Instability (I): Computed as `Ce`` ``/`` ``(Ce`` ``+`` ``Ca)`. Measures the entity resilience to change. Ranging from 0 to 1, with 0 indicating a maximally stable entity and 1 indicating a maximally unstable entity. Ideally, an entity is either maximally stable or maximally unstable.
>
> - Abstractness (A): Computed as the ratio between the number of static predicates with scope directives without a local definition and the number of static predicates with scope directives. Measures the rigidity of an entity. Ranging from 0 to 1, with 0 indicating a fully concrete entity and 1 indicating a fully abstract entity.
>
> - Entity score: Represented as the compound term `ce_ca_i_a(Ce,Ca,I,A)`.
>
> - Dependencies count: Includes direct entity relations plus calls or dynamic updates to predicates in external objects or categories.

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `dit_metric`

Analyzes the depth of inheritance for objects, protocols, and categories.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Ebrahim Azarisooreh

**Version:** 0:6:1

**Date:** 2024-03-28

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metrics_utilities

`public` code_metric

**Uses:**

numberlist

**Remarks:**

> - Depth: The depth is the maximum length of a node to the root entity. Lower scores are generally better.
>
> - Inheritance: A level of inheritance defined by either one of specialization, instantiation, extension, importation, or implementation.
>
> - Scoring: The maximum path length is determined for each entity in question.

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `doc_metric`

Entity and entity predicates documentation score.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Paulo Moura

**Version:** 0:13:0

**Date:** 2022-05-05

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metrics_utilities

`public` code_metric

**Uses:**

list

numberlist

**Remarks:**

> - Score range: Score is a integer percentage where a 100% score means that all expected documentation information is present.
>
> - Score weights: The score is split by default between 20% for the entity documentation and 80% for the entity predicates documentation, Can be customized using the predicate `entity_predicates_weights_hook/2`.
>
> - Score customization: The individual scores of entity `info/1` pairs and predicate `info/2` pairs can be customized using the `entity_info_pair_score_hook/3` and `predicate_info_pair_score_hook/4` predicates.

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

  - `entity_predicates_weights_hook/2`

  - `entity_info_score_hook/2`

  - `entity_info_pair_score_hook/3`

  - `predicate_mode_score_hook/3`

  - `predicate_mode_score_hook/5`

  - `predicate_info_score_hook/3`

  - `predicate_info_pair_score_hook/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `entity_predicates_weights_hook/2`

Relative weight between entity documentation and predicates documentation in percentage. The sum of the two values must be equal to 100.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`entity_predicates_weights_hook(EntityWeight,PredicatesWeight)`

**Mode and number of proofs:**

`entity_predicates_weights_hook(?integer,?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `entity_info_score_hook/2`

Maximum score for entity `info/1` directives.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`entity_info_score_hook(Entity,MaximumScore)`

**Mode and number of proofs:**

`entity_info_score_hook(?term,?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `entity_info_pair_score_hook/3`

Score for relevant entity `info/1` directive pairs. If defined, the `entity_info_score_hook/2` predicate should be defined accordingly.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`entity_info_pair_score_hook(Pair,Entity,Score)`

**Mode and number of proofs:**

`entity_info_pair_score_hook(?callable,?term,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `predicate_mode_score_hook/3`

Maximum score for predicate `mode/2` directives.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`predicate_mode_score_hook(Entity,Predicate,MaximumScore)`

**Mode and number of proofs:**

`predicate_mode_score_hook(?term,?term,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `predicate_mode_score_hook/5`

Score for a predicate `mode/2` directive. If defined, the `predicate_mode_score_hook/3` predicate should be defined accordingly.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`predicate_mode_score_hook(Template,Solutions,Entity,Predicate,Score)`

**Mode and number of proofs:**

`predicate_mode_score_hook(?term,?term,?term,?term,?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `predicate_info_score_hook/3`

Maximum score for predicate `info/2` directives.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`predicate_info_score_hook(Entity,Predicate,MaximumScore)`

**Mode and number of proofs:**

`predicate_info_score_hook(?term,?term,?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `predicate_info_pair_score_hook/4`

Score for a predicate `info/2` directive pairs. If defined, the `predicate_info_score_hook/3` predicate should be defined accordingly.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`predicate_info_pair_score_hook(Pair,Entity,Predicate,Score)`

**Mode and number of proofs:**

`predicate_info_pair_score_hook(?callable,?term,?term,?integer)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `halstead_metric`

Computes Halstead complexity numbers for an entity using a Stroud of 18.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2018-06-08

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` halstead_metric(18)

**Remarks:**

(none)

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `halstead_metric(Stroud)`

- `Stroud` - Coefficient for computing the time required to program.

Computes Halstead complexity numbers for an entity.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Paulo Moura

**Version:** 0:10:0

**Date:** 2025-01-04

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metrics_utilities

`public` code_metric

**Uses:**

list

numberlist

pairs

**Remarks:**

> - Definition of operators: Predicates declared, user-defined, and called are interpreted as operators. Built-in predicates and built-in control constructs are ignored.
>
> - Definition of operands: Predicate arguments are abstracted and interpreted as operands. Note that this definition of operands is a significant deviation from the original definition, which used syntactic literals.
>
> - Pn: Number of distinct predicates (declared, defined, called, or updated).
>
> - PAn: Number of predicate arguments (assumed distinct).
>
> - Cn: Number of predicate calls/updates + number of clauses.
>
> - CAn: Number of predicate call/update arguments + number of clause head arguments.
>
> - EV: Entity vocabulary: `EV`` ``=`` ``Pn`` ``+`` ``PAn`.
>
> - EL: Entity length: `EL`` ``=`` ``Cn`` ``+`` ``CAn`.
>
> - V: Volume: `V`` ``=`` ``EL`` ``*`` ``log2(EV)`.
>
> - D: Difficulty: `D`` ``=`` ``(Pn/2)`` ``*`` ``(CAn/An)`.
>
> - E: Effort: `E`` ``=`` ``D`` ``*`` ``V`.
>
> - T: Time required to program: `T`` ``=`` ``E/k` seconds (`k` is the Stroud number; defaults to 18).
>
> - B: Number of delivered bugs: `B`` ``=`` ``V/3000`.
>
> - Entity score: Represented as the compound term `pn_pan_cn_can_ev_el_v_d_e_t_b/11`.

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `noc_metric`

Number of entity clauses metric. The score is represented using the compound term `number_of_clauses(Total,`` ``User)`.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Ebrahim Azarisooreh and Paulo Moura

**Version:** 0:14:1

**Date:** 2024-05-08

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metrics_utilities

`public` code_metric

**Provides:**

logtalk::message_tokens//2

**Uses:**

list

logtalk

**Remarks:**

(none)

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `nor_metric`

Number of entity rules metric. The score is represented using the compound term `number_of_rules(Total,`` ``User)`.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Paulo Moura

**Version:** 0:5:1

**Date:** 2024-05-08

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metrics_utilities

`public` code_metric

**Provides:**

logtalk::message_tokens//2

**Uses:**

list

logtalk

**Remarks:**

(none)

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `size_metric`

Source code size metric. Returned scores are upper bounds and based solely in source file sizes (expressed in bytes).

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Paulo Moura

**Version:** 0:7:1

**Date:** 2024-05-08

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metrics_utilities

`public` code_metric

**Provides:**

logtalk::message_tokens//2

**Uses:**

list

logtalk

numberlist

os

**Remarks:**

(none)

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `upn_metric`

Number of unique predicates nodes metric. The nodes include called and updated predicates independently of where they are defined. The score is represented by a non-negative integer.

**Availability:**

`logtalk_load(code_metrics(loader))`

**Author:** Paulo Moura

**Version:** 0:6:2

**Date:** 2024-05-15

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` code_metrics_utilities

`public` code_metric

**Provides:**

logtalk::message_tokens//2

**Uses:**

list

logtalk

numberlist

**Remarks:**

(none)

**Inherited public predicates:**

 all/0  all/1  all_score/1  check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  directory_score/2  entity/1  entity_score/2  file/1  file/2  file_score/2  format_entity_score//2  library/1  library/2  library_score/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory_score/2  rlibrary/1  rlibrary/2  rlibrary_score/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### combinations")

**object**

#### `combinations`

Implementation of combinations operations over lists.

**Availability:**

`logtalk_load(combinations(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` combinations_protocol

**Uses:**

fast_random(Algorithm)

list

natural

**Remarks:**

(none)

**Inherited public predicates:**

 combination/3  combination/4  combination_index/4  combination_with_replacement/3  combination_with_replacement/4  combinations/3  combinations/4  combinations_with_replacement/3  combinations_with_replacement/4  count_combinations/3  count_combinations_with_replacement/3  distinct_combination/3  distinct_combination/4  distinct_combinations/3  distinct_combinations/4  nth_combination/4  random_combination/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `combinations_protocol`

Protocol for combinations operations over lists.

**Availability:**

`logtalk_load(combinations(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `combinations/3`

  - `combination/3`

  - `combinations/4`

  - `combination/4`

  - `combinations_with_replacement/3`

  - `combinations_with_replacement/4`

  - `combination_with_replacement/3`

  - `combination_with_replacement/4`

  - `distinct_combinations/3`

  - `distinct_combination/3`

  - `distinct_combinations/4`

  - `distinct_combination/4`

  - `nth_combination/4`

  - `combination_index/4`

  - `count_combinations/3`

  - `count_combinations_with_replacement/3`

  - `random_combination/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `combinations/3`

Generates all K-element combinations of a list.

**Compilation flags:**

`static`

**Template:**

`combinations(K,List,Combinations)`

**Mode and number of proofs:**

`combinations(+integer,+list,-list)` - `one`

------------------------------------------------------------------------

###### `combination/3`

True iff the third argument is a K-element combination of a list.

**Compilation flags:**

`static`

**Template:**

`combination(K,List,Combination)`

**Mode and number of proofs:**

`combination(+integer,+list,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `combinations/4`

Generates all K-element combinations with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`combinations(K,List,Order,Combinations)`

**Mode and number of proofs:**

`combinations(+integer,+list,+atom,-list)` - `one`

------------------------------------------------------------------------

###### `combination/4`

True iff the fourth argument is a K-element combination with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`combination(K,List,Order,Combination)`

**Mode and number of proofs:**

`combination(+integer,+list,+atom,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `combinations_with_replacement/3`

Generates all K-element combinations with replacement.

**Compilation flags:**

`static`

**Template:**

`combinations_with_replacement(K,List,Combinations)`

**Mode and number of proofs:**

`combinations_with_replacement(+integer,+list,-list)` - `one`

------------------------------------------------------------------------

###### `combinations_with_replacement/4`

Generates all K-element combinations with replacement with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`combinations_with_replacement(K,List,Order,Combinations)`

**Mode and number of proofs:**

`combinations_with_replacement(+integer,+list,+atom,-list)` - `one`

------------------------------------------------------------------------

###### `combination_with_replacement/3`

True iff the third argument is a K-element combination with replacement.

**Compilation flags:**

`static`

**Template:**

`combination_with_replacement(K,List,Combination)`

**Mode and number of proofs:**

`combination_with_replacement(+integer,+list,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `combination_with_replacement/4`

True iff the fourth argument is a K-element combination with replacement with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`combination_with_replacement(K,List,Order,Combination)`

**Mode and number of proofs:**

`combination_with_replacement(+integer,+list,+atom,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `distinct_combinations/3`

Generates all distinct K-element combinations of a list (deduplicating equal-valued combinations).

**Compilation flags:**

`static`

**Template:**

`distinct_combinations(K,List,Combinations)`

**Mode and number of proofs:**

`distinct_combinations(+integer,+list,-list)` - `one`

------------------------------------------------------------------------

###### `distinct_combination/3`

True iff the third argument is a distinct K-element combination of a list.

**Compilation flags:**

`static`

**Template:**

`distinct_combination(K,List,Combination)`

**Mode and number of proofs:**

`distinct_combination(+integer,+list,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `distinct_combinations/4`

Generates all distinct K-element combinations with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`distinct_combinations(K,List,Order,Combinations)`

**Mode and number of proofs:**

`distinct_combinations(+integer,+list,+atom,-list)` - `one`

------------------------------------------------------------------------

###### `distinct_combination/4`

True iff the fourth argument is a distinct K-element combination with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`distinct_combination(K,List,Order,Combination)`

**Mode and number of proofs:**

`distinct_combination(+integer,+list,+atom,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `nth_combination/4`

Returns the combination at a given zero-based index.

**Compilation flags:**

`static`

**Template:**

`nth_combination(K,List,Index,Combination)`

**Mode and number of proofs:**

`nth_combination(+integer,+list,+integer,-list)` - `zero_or_one`

------------------------------------------------------------------------

###### `combination_index/4`

Returns the zero-based index of a combination.

**Compilation flags:**

`static`

**Template:**

`combination_index(K,List,Combination,Index)`

**Mode and number of proofs:**

`combination_index(+integer,+list,+list,-integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `count_combinations/3`

Counts the number of K-element combinations of a list.

**Compilation flags:**

`static`

**Template:**

`count_combinations(K,List,Count)`

**Mode and number of proofs:**

`count_combinations(+integer,+list,-integer)` - `one`

------------------------------------------------------------------------

###### `count_combinations_with_replacement/3`

Counts the number of K-element combinations with replacement of a list.

**Compilation flags:**

`static`

**Template:**

`count_combinations_with_replacement(K,List,Count)`

**Mode and number of proofs:**

`count_combinations_with_replacement(+integer,+list,-integer)` - `one`

------------------------------------------------------------------------

###### `random_combination/3`

Returns a random K-element combination of a list.

**Compilation flags:**

`static`

**Template:**

`random_combination(K,List,Combination)`

**Mode and number of proofs:**

`random_combination(+integer,+list,-list)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### command_line_options")

**category**

#### `command_line_option`

Category for defining command-line options. Import this category into objects that represent individual command-line options and override the predicates as needed.

**Availability:**

`logtalk_load(command_line_options(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static`

**Uses:**

type

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `check/0`

  - `valid/0`

  - `name/1`

  - `short_flags/1`

  - `long_flags/1`

  - `type/1`

  - `default/1`

  - `meta/1`

  - `help/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `check/0`

Checks if the command-line option definition is valid. Throws an error if the definition is invalid.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`check` - `one_or_error`

------------------------------------------------------------------------

###### `valid/0`

Succeeds if the command-line option definition is valid. Fails otherwise.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`valid` - `zero_or_one`

------------------------------------------------------------------------

###### `name/1`

Name used to identify this option in the parsed results. This predicate must be overridden. No default.

**Compilation flags:**

`static`

**Template:**

`name(Name)`

**Mode and number of proofs:**

`name(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `short_flags/1`

List of single-character short flags for this option (e.g., `[v]` for `-v`). Default is an empty list.

**Compilation flags:**

`static`

**Template:**

`short_flags(Flags)`

**Mode and number of proofs:**

`short_flags(-list(character))` - `one`

------------------------------------------------------------------------

###### `long_flags/1`

List of long flags for this option (e.g., `[verbose]` for `--verbose`). Default is an empty list.

**Compilation flags:**

`static`

**Template:**

`long_flags(Flags)`

**Mode and number of proofs:**

`long_flags(-list(atom))` - `one`

------------------------------------------------------------------------

###### `type/1`

Option value type. One of `boolean`, `atom`, `integer`, `float`, or `term`. Default is `term`.

**Compilation flags:**

`static`

**Template:**

`type(Type)`

**Mode and number of proofs:**

`type(-atom)` - `one`

------------------------------------------------------------------------

###### `default/1`

Default value for this option if any.

**Compilation flags:**

`static`

**Template:**

`default(Default)`

**Mode and number of proofs:**

`default(-term)` - `zero_or_one`

------------------------------------------------------------------------

###### `meta/1`

Metasyntactic variable name for the help text (e.g., `'FILE'`). Default is an empty atom.

**Compilation flags:**

`static`

**Template:**

`meta(Meta)`

**Mode and number of proofs:**

`meta(-atom)` - `one`

------------------------------------------------------------------------

###### `help/1`

Help text for this option. Can be an atom or a list of atoms for pre-broken lines. Default is an empty atom.

**Compilation flags:**

`static`

**Template:**

`help(Help)`

**Mode and number of proofs:**

`help(-atom)` - `one`

`help(-list(atom))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

command_line_options

**object**

#### `command_line_options`

Command line options parsing predicates. Uses object-based option specifications with the `command_line_option` category.

**Availability:**

`logtalk_load(command_line_options(loader))`

**Author:** Marcus Uneson and Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` options

**Uses:**

atom

list

meta

numberlist

term_io

type

user

**Remarks:**

(none)

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  option/2  option/3  valid_option/1  valid_options/1

- Public predicates

  - `parse/4`

  - `parse/5`

  - `help/2`

  - `help/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/4`

Parses the arguments `ApplArguments` according to the option objects `OptionObjects` using default parsing options.

**Compilation flags:**

`static`

**Template:**

`parse(OptionObjects,ApplArguments,Options,PositionalArguments)`

**Mode and number of proofs:**

`parse(+list(object),+list(atom),-list,-list(atom))` - `one_or_error`

------------------------------------------------------------------------

###### `parse/5`

Parses the arguments `ApplArguments` according to the option objects `OptionObjects` and the parsing options `ParseOptions`. `Options` is a list of parsed options as `Name(Value)` terms by default (or `Func(Name,Value)` when the `output_functor(Func)` parse option is used). `PositionalArguments` are the remaining non-dashed arguments. `ParseOptions` include `output_functor(Func)`, `duplicated_flags(Keep)` (one of `keepfirst`, `keeplast`, `keepall`; default `keeplast`), and `allow_empty_flag_spec(Bool)` (default `true`).

**Compilation flags:**

`static`

**Template:**

`parse(OptionObjects,ApplArguments,Options,PositionalArguments,ParseOptions)`

**Mode and number of proofs:**

`parse(+list(object),+list(atom),-list,-list(atom),+list)` - `one_or_error`

------------------------------------------------------------------------

###### `help/2`

Synthesizes a help text `Help` as an atom from the option objects `OptionObjects` using default help options.

**Compilation flags:**

`static`

**Template:**

`help(OptionObjects,Help)`

**Mode and number of proofs:**

`help(+list(object),-atom)` - `one_or_error`

------------------------------------------------------------------------

###### `help/3`

Synthesizes a help text `Help` as an atom from the option objects `OptionObjects` using the given `HelpOptions`. `HelpOptions` include `line_width(Width)` (default 80), `min_help_width(Width)` (default 40), `break_long_flags(Boolean)` (default `false`), and `suppress_empty_meta(Boolean)` (default `true`).

**Compilation flags:**

`static`

**Template:**

`help(OptionObjects,Help,HelpOptions)`

**Mode and number of proofs:**

`help(+list(object),-atom,+list)` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

command_line_option

### core")

**category**

#### `core_messages`

Logtalk core (compiler and runtime) default message tokenization.

**Availability:**

`built_in`

**Author:** Paulo Moura

**Version:** 1:145:0

**Date:** 2025-11-15

**Compilation flags:**

`static`

**Provides:**

logtalk::message_prefix_stream/4

logtalk::message_tokens//2

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `expanding`

Term and goal expansion protocol.

**Availability:**

`built_in`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2016-07-12

**Compilation flags:**

`static,`` ``built_in`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `goal_expansion/2`

  - `term_expansion/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `goal_expansion/2`

Defines a goal expansion. Called recursively until a fixed point is reached on goals found while compiling a source file (except for goals wrapped using the `{}/1` compiler bypass control construct).

**Compilation flags:**

`static`

**Template:**

`goal_expansion(Goal,ExpandedGoal)`

**Mode and number of proofs:**

`goal_expansion(+callable,-callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `term_expansion/2`

Defines a term expansion. Called until it succeeds on all terms read while compiling a source file (except for terms skipped by using the conditional compilation directives or wrapped using the `{}/1` compiler bypass control construct).

**Compilation flags:**

`static`

**Template:**

`term_expansion(Term,ExpandedTerms)`

**Mode and number of proofs:**

`term_expansion(+term,-term)` - `zero_or_one`

`term_expansion(+term,-list(term))` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**protocol**

#### `forwarding`

Message forwarding protocol.

**Availability:**

`built_in`

**Author:** Paulo Moura

**Version:** 1:0:1

**Date:** 2025-05-15

**Compilation flags:**

`static,`` ``built_in`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `forward/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `forward/1`

User-defined message forwarding handler, automatically called (if defined) by the runtime for any message that the receiving object does not understand.

**Compilation flags:**

`static`

**Template:**

`forward(Message)`

**Mode and number of proofs:**

`forward(+callable)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**object**

#### `logtalk`

Built-in object providing message printing, debugging, library, source file, and hacking methods.

**Availability:**

`built_in`

**Author:** Paulo Moura

**Version:** 3:4:0

**Date:** 2025-11-11

**Compilation flags:**

`static,`` ``built_in,`` ``context_switching_calls,`` ``threaded`

**Dependencies:**

(none)

**Remarks:**

> - Default message kinds: `silent`, `silent(Key)`, `banner`, `help`, `comment`, `comment(Key)`, `information`, `information(Key)`, `warning`, `warning(Key)`, `error`, `error(Key)`, `debug`, `debug(Key)`, `question`, and `question(Key)`.
>
> - Printing of silent messages: By default, silent messages are not printed. These messages are only useful when intercepted.
>
> - Printing of banner and comment messages: By default, banner and comment messages are only printed when the `report` flag is turned on.
>
> - Printing of help, information, and question messages: These messages are always printed by default as they provide requested output.
>
> - Printing of warning messages: By default, warning messages are not printed when the `report` flag is turned off.
>
> - Printing of error messages: These messages are always printed by default.
>
> - Printing of debug messages: By default, debug messages are only printed when the `debug` flag is turned on. The compiler suppresses debug message printing goals when compiling in optimized mode.
>
> - Meta messages: A *meta message* is a message that have another message as argument and is typically used for debugging messages. Meta messages avoid the need of defining tokenizer rules for every message but can be intercepted as any other message.
>
> - Meta message `@Message`: By default, the message is printed as passed to the `write/1` predicate followed by a newline.
>
> - Meta message `Key-Value`: By default, the message is printed as “Key: Value” followed by a newline. The key is printed as passed to the `write/1` predicate while the value is printed as passed to the `writeq/1` predicate.
>
> - Meta message `Format+Arguments`: By default, the message is printed as passed to the `format/2` predicate.
>
> - Meta message `List`: By default, the list items are printed indented one per line. The items are preceded by a dash and can be `@Message`, `Key-Value`, or `Format+Arguments` messages. If that is not the case, the item is printed as passed to the `writeq/1` predicate.
>
> - Meta message `Title::List`: By default, the title is printed followed by a newline and the indented list items, one per line. The items are printed as in the `List` meta message.
>
> - Meta message `[Stream,Prefix]>>Goal`: By default, call user-defined `Goal` in the context of `user`. The use of a lambda expression allows passing the message stream and prefix. Printing the prefix is delegated to the goal.
>
> - Meta message `[Stream]>>Goal`: By default, call user-defined `Goal` in the context of `user`. The use of a lambda expression allows passing the message stream.
>
> - Message tokens: `at_same_line`, `tab(Expression)`, `nl`, `flush`, `Format-Arguments`, `term(Term,Options)`, `ansi(Attributes,Format,Arguments)`, `begin(Kind,Variable)`, and `end(Variable)`.
>
> - Multi-threading applications: Predicates calling methods such as `print_message/3`, `ask_question/5`, or `compile_aux_clauses/1` may need to be declared synchronized in order to avoid race conditions.

**Inherited public predicates:**

(none)

- Public predicates

  - `print_message/3`

  - `print_message_tokens/3`

  - `print_message_token/4`

  - `message_tokens//2`

  - `message_prefix_stream/4`

  - `message_prefix_file/6`

  - `message_hook/4`

  - `ask_question/5`

  - `question_hook/6`

  - `question_prompt_stream/4`

  - `trace_event/2`

  - `debug_handler/1`

  - `active_debug_handler/1`

  - `activate_debug_handler/1`

  - `deactivate_debug_handler/0`

  - `debug_handler/3`

  - `expand_library_path/2`

  - `loaded_file/1`

  - `loaded_file_property/2`

  - `loaded_files_topological_sort/1`

  - `loaded_files_topological_sort/2`

  - `file_type_extension/2`

  - `compile_aux_clauses/1`

  - `entity_prefix/2`

  - `compile_predicate_heads/4`

  - `compile_predicate_indicators/3`

  - `decompile_predicate_heads/4`

  - `decompile_predicate_indicators/4`

  - `execution_context/7`

- Protected predicates

- Private predicates

  - `active_debug_handler_/1`

- Operators

##### Public predicates

###### `print_message/3`

Prints a message of the given kind for the specified component.

**Compilation flags:**

`static`

**Template:**

`print_message(Kind,Component,Message)`

**Mode and number of proofs:**

`print_message(+nonvar,+nonvar,+nonvar)` - `one`

------------------------------------------------------------------------

###### `print_message_tokens/3`

Print the messages tokens to the given stream, prefixing each line with the specified atom.

**Compilation flags:**

`static`

**Template:**

`print_message_tokens(Stream,Prefix,Tokens)`

**Mode and number of proofs:**

`print_message_tokens(@stream_or_alias,+atom,@list(nonvar))` - `one`

------------------------------------------------------------------------

###### `print_message_token/4`

User-defined hook predicate for printing a message token (see this object remarks).

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`print_message_token(Stream,Prefix,Token,Tokens)`

**Mode and number of proofs:**

`print_message_token(@stream_or_alias,@atom,@nonvar,@list(nonvar))` - `zero_or_one`

------------------------------------------------------------------------

###### `message_tokens//2`

User-defined hook grammar rule for converting a message into a list of tokens (see this object remarks).

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`message_tokens(Message,Component)`

**Mode and number of proofs:**

`message_tokens(+nonvar,+nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `message_prefix_stream/4`

Message line prefix and output stream to be used when printing a message given its kind and component.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`message_prefix_stream(Kind,Component,Prefix,Stream)`

**Mode and number of proofs:**

`message_prefix_stream(?nonvar,?nonvar,?atom,?stream_or_alias)` - `zero_or_more`

------------------------------------------------------------------------

###### `message_prefix_file/6`

Message line prefix and output file to be used when printing a message given its kind and component.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`message_prefix_file(Kind,Component,Prefix,File,Mode,Options)`

**Mode and number of proofs:**

`message_prefix_file(?nonvar,?nonvar,?atom,?atom,?atom,?list(compound))` - `zero_or_more`

------------------------------------------------------------------------

###### `message_hook/4`

User-defined hook predicate for intercepting message printing calls.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`message_hook(Message,Kind,Component,Tokens)`

**Mode and number of proofs:**

`message_hook(+nonvar,+nonvar,+nonvar,+list(nonvar))` - `zero_or_one`

------------------------------------------------------------------------

###### `ask_question/5`

Asks a question and reads the answer until the check predicate is true.

**Compilation flags:**

`static`

**Template:**

`ask_question(Kind,Component,Question,Check,Answer)`

**Meta-predicate template:**

`ask_question(*,*,*,1,*)`

**Mode and number of proofs:**

`ask_question(+nonvar,+nonvar,+nonvar,+callable,-term)` - `one`

------------------------------------------------------------------------

###### `question_hook/6`

User-defined hook predicate for intercepting question asking calls.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`question_hook(Question,Kind,Component,Tokens,Check,Answer)`

**Meta-predicate template:**

`question_hook(*,*,*,*,1,*)`

**Mode and number of proofs:**

`question_hook(+nonvar,+nonvar,+nonvar,+list(nonvar),+callable,-term)` - `zero_or_one`

------------------------------------------------------------------------

###### `question_prompt_stream/4`

Prompt and input stream to be used when asking a question given its kind and component.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`question_prompt_stream(Kind,Component,Prompt,Stream)`

**Mode and number of proofs:**

`question_prompt_stream(?nonvar,?nonvar,?atom,?stream_or_alias)` - `zero_or_more`

------------------------------------------------------------------------

###### `trace_event/2`

Trace event handler. The runtime calls all trace event handlers using a failure-driven loop before calling the debug event handler.

**Compilation flags:**

`dynamic,`` ``multifile`

**Template:**

`trace_event(Event,ExecutionContext)`

**Mode and number of proofs:**

`trace_event(@callable,@execution_context)` - `zero`

**Remarks:**

> - Unification events: Generated after a successful unification with a fact - `fact(Entity,Fact,Clause,File,Line)` - or a rule head - `rule(Entity,Head,Clause,File,Line)`.
>
> - Goal events: Generated when calling a goal: `top_goal(Goal,CompiledGoal)` or `goal(Goal,CompiledGoal)`.

------------------------------------------------------------------------

###### `debug_handler/1`

Enumerates, by backtracking, all declared debug handler providers. Define a clause for this predicate to declare a new debug handler provider.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`debug_handler(Provider)`

**Mode and number of proofs:**

`debug_handler(?object_identifier)` - `zero_or_more`

`debug_handler(?category_identifier)` - `zero_or_more`

------------------------------------------------------------------------

###### `active_debug_handler/1`

Current active debug handler provider if any. There is at most one active debug handler provider at any given moment.

**Compilation flags:**

`static`

**Template:**

`active_debug_handler(Provider)`

**Mode and number of proofs:**

`active_debug_handler(?category_identifier)` - `zero_or_one`

`active_debug_handler(?category_identifier)` - `zero_or_one`

------------------------------------------------------------------------

###### `activate_debug_handler/1`

Activates the given debug handler provider. There is at most one active debug handler provider at any given moment. Fails if the object or category is not declared as a debug handler provider.

**Compilation flags:**

`static`

**Template:**

`activate_debug_handler(Provider)`

**Mode and number of proofs:**

`activate_debug_handler(@object_identifier)` - `zero_or_one`

`activate_debug_handler(@category_identifier)` - `zero_or_one`

------------------------------------------------------------------------

###### `deactivate_debug_handler/0`

Deactivates the current debug handler provider if any.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`deactivate_debug_handler` - `one`

------------------------------------------------------------------------

###### `debug_handler/3`

Debug event handler. Called by the runtime when the given provider is active.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`debug_handler(Provider,Event,ExecutionContext)`

**Mode and number of proofs:**

`debug_handler(+object_identifier,+callable,+execution_context)` - `zero_or_more`

`debug_handler(+category_identifier,+callable,+execution_context)` - `zero_or_more`

**Remarks:**

> - Unification events: Generated after a successful unification with a fact - `fact(Entity,Fact,Clause,File,Line)` - or a rule head - `rule(Entity,Head,Clause,File,Line)`.
>
> - Goal events: Generated when calling a goal: `top_goal(Goal,CompiledGoal)` or `goal(Goal,CompiledGoal)`.

------------------------------------------------------------------------

###### `expand_library_path/2`

Expands a library alias (an atom) or a compound term (using library notation) into its absolute path. Uses a depth bound to prevent loops.

**Compilation flags:**

`static`

**Template:**

`expand_library_path(LibraryAlias,AbsolutePath)`

**Mode and number of proofs:**

`expand_library_path(+atom,?atom)` - `zero_or_one`

`expand_library_path(+callable,?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `loaded_file/1`

Enumerates, by backtracking, all loaded files, returning their full paths.

**Compilation flags:**

`static`

**Template:**

`loaded_file(Path)`

**Mode and number of proofs:**

`loaded_file(?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `loaded_file_property/2`

Enumerates, by backtracking, loaded file properties.

**Compilation flags:**

`static`

**Template:**

`loaded_file_property(Path,Property)`

**Mode and number of proofs:**

`loaded_file_property(?atom,?compound)` - `zero_or_more`

**Remarks:**

> - Property `basename/1`: Basename of the file (includes the file extension, if any).
>
> - Property `directory/1`: Directory of the file (ending with a slash).
>
> - Property `mode/1`: Compilation mode of the file (possible values are `optimal`, `normal`, and `debug`).
>
> - Property `flags/1`: Explicit flags used for compiling the file.
>
> - Property `text_properties/1`: List of the file text properties (`encoding/1` and `bom/1`). Empty if no `encoding/1` directive is present and the stream used for reading the file does not have a `bom/1` (or equivalent) property.
>
> - Property `target/1`: Full path of the generated intermediate Prolog file.
>
> - Property `modified/1`: File modification time stamp (should be regarded as an opaque but otherwise comparable term).
>
> - Property `parent/1`: Full path of the parent file that loaded the file.
>
> - Property `includes/2`: Full path of a file included by the file and the line of the `include/1` directive.
>
> - Property `includes/1`: Full path of a file included by the file.
>
> - Property `library/1`: Library alias for the library that includes the file.
>
> - Property `object/3`: Identifier for an object defined in the file and the start and end lines of its definition.
>
> - Property `object/1`: Identifier for an object defined in the file.
>
> - Property `protocol/3`: Identifier for a protocol defined in the file and the start and end lines of its definition.
>
> - Property `protocol/1`: Identifier for a protocol defined in the file.
>
> - Property `category/3`: Identifier for a category defined in the file and the start and end lines of its definition.
>
> - Property `category/1`: Identifier for a category defined in the file.

------------------------------------------------------------------------

###### `loaded_files_topological_sort/1`

Returns a list of full paths for all loaded user-defined files sorted by dependencies.

**Compilation flags:**

`static`

**Template:**

`loaded_files_topological_sort(Sorted)`

**Mode and number of proofs:**

`loaded_files_topological_sort(--list(atom))` - `one`

------------------------------------------------------------------------

###### `loaded_files_topological_sort/2`

Sorts a list of full paths for loaded files by dependencies.

**Compilation flags:**

`static`

**Template:**

`loaded_files_topological_sort(Paths,Sorted)`

**Mode and number of proofs:**

`loaded_files_topological_sort(+list(atom),--list(atom))` - `one`

------------------------------------------------------------------------

###### `file_type_extension/2`

Enumerates, by backtracking, all defined file type extensions. The defined types are: `source`, `object`, `logtalk`, `prolog`, and `tmp`. The source type returns both `logtalk` and `prolog` type extensions.

**Compilation flags:**

`static`

**Template:**

`file_type_extension(Type,Extension)`

**Mode and number of proofs:**

`file_type_extension(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `compile_aux_clauses/1`

Compiles a list of auxiliary clauses. Can only be called during source file compilation, usually from `term_expansion/2` or `goal_expansion/2` hook predicate definitions.

**Compilation flags:**

`static`

**Template:**

`compile_aux_clauses(Clauses)`

**Mode and number of proofs:**

`compile_aux_clauses(@list(clause))` - `one`

------------------------------------------------------------------------

###### `entity_prefix/2`

Converts between an entity identifier and the entity prefix that is used for its compiled code. When none of the arguments is instantiated, it returns the identifier and the prefix of the entity under compilation, if any.

**Compilation flags:**

`static`

**Template:**

`entity_prefix(Entity,Prefix)`

**Mode and number of proofs:**

`entity_prefix(?entity_identifier,?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `compile_predicate_heads/4`

Compiles clause heads. The heads are compiled in the context of the entity under compilation when the entity argument is not instantiated.

**Compilation flags:**

`static`

**Template:**

`compile_predicate_heads(Heads,Entity,CompiledHeads,ExecutionContext)`

**Mode and number of proofs:**

`compile_predicate_heads(@list(callable),?entity_identifier,-list(callable),@execution_context)` - `zero_or_one`

`compile_predicate_heads(@conjunction(callable),?entity_identifier,-conjunction(callable),@execution_context)` - `zero_or_one`

`compile_predicate_heads(@callable,?entity_identifier,-callable,@execution_context)` - `zero_or_one`

------------------------------------------------------------------------

###### `compile_predicate_indicators/3`

Compiles predicate indicators. The predicate are compiled in the context of the entity under compilation when the entity argument is not instantiated.

**Compilation flags:**

`static`

**Template:**

`compile_predicate_indicators(PredicateIndicators,Entity,CompiledPredicateIndicators)`

**Mode and number of proofs:**

`compile_predicate_indicators(@list(predicate_indicator),?entity_identifier,-list(predicate_indicator))` - `zero_or_one`

`compile_predicate_indicators(@conjunction(predicate_indicator),?entity_identifier,-conjunction(predicate_indicator))` - `zero_or_one`

`compile_predicate_indicators(@predicate_indicator,?entity_identifier,-predicate_indicator)` - `zero_or_one`

------------------------------------------------------------------------

###### `decompile_predicate_heads/4`

Decompiles clause heads. All compiled clause heads must belong to the same entity, which must be loaded.

**Compilation flags:**

`static`

**Template:**

`decompile_predicate_heads(CompiledHeads,Entity,Type,Heads)`

**Mode and number of proofs:**

`decompile_predicate_heads(@list(callable),-entity_identifier,-atom,-list(callable))` - `zero_or_one`

`decompile_predicate_heads(@conjunction(callable),-entity_identifier,-atom,-conjunction(callable))` - `zero_or_one`

`decompile_predicate_heads(@callable,-entity_identifier,-atom,-callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `decompile_predicate_indicators/4`

Decompiles predicate indicators. All compiled predicate indicators must belong to the same entity, which must be loaded.

**Compilation flags:**

`static`

**Template:**

`decompile_predicate_indicators(CompiledPredicateIndicators,Entity,Type,PredicateIndicators)`

**Mode and number of proofs:**

`decompile_predicate_indicators(@list(predicate_indicator),-entity_identifier,-atom,-list(predicate_indicator))` - `zero_or_one`

`decompile_predicate_indicators(@conjunction(predicate_indicator),-entity_identifier,-atom,-conjunction(predicate_indicator))` - `zero_or_one`

`decompile_predicate_indicators(@predicate_indicator,-entity_identifier,-atom,-predicate_indicator)` - `zero_or_one`

------------------------------------------------------------------------

###### `execution_context/7`

Execution context term data. Execution context terms should be considered opaque terms subject to change without notice.

**Compilation flags:**

`static`

**Template:**

`execution_context(ExecutionContext,Entity,Sender,This,Self,MetaCallContext,CoinductionStack)`

**Mode and number of proofs:**

`execution_context(?nonvar,?entity_identifier,?object_identifier,?object_identifier,?object_identifier,@list(callable),@list(callable))` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

###### `active_debug_handler_/1`

Current active debug handler provider. There is at most one active debug handler provider at any given moment.

**Compilation flags:**

`dynamic`

**Template:**

`active_debug_handler_(Provider)`

**Mode and number of proofs:**

`active_debug_handler_(?entity_identifier)` - `zero_or_one`

------------------------------------------------------------------------

##### Operators

(none)

**protocol**

#### `monitoring`

Event handlers protocol. The handlers are automatically called by the runtime for messages sent using the `::/2` control construct from objects or categories compiled with the `events` flag set to `allow`.

**Availability:**

`built_in`

**Author:** Paulo Moura

**Version:** 1:2:0

**Date:** 2018-11-29

**Compilation flags:**

`static,`` ``built_in`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `before/3`

  - `after/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `before/3`

Event handler for `before` events. A `before` event handler may prevent a method from being looked up or called by failing.

**Compilation flags:**

`static`

**Template:**

`before(Object,Message,Sender)`

**Mode and number of proofs:**

`before(?term,?term,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `after/3`

Event handler for `after` events. An `after` event handler may prevent a method from succeeding by failing.

**Compilation flags:**

`static`

**Template:**

`after(Object,Message,Sender)`

**Mode and number of proofs:**

`after(?term,?term,?term)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**object**

#### `user`

Pseudo-object representing the plain Prolog database. Can be used as a monitor by defining `before/3` and `after/3` predicates. Can be used as a hook object by defining `term_expansion/2` and `goal_expansion/2` multifile and dynamic predicates.

**Availability:**

`built_in`

**Author:** Paulo Moura

**Version:** 1:6:0

**Date:** 2024-11-11

**Compilation flags:**

`static,`` ``built_in,`` ``context_switching_calls,`` ``dynamic_declarations,`` ``threaded`

**Implements:**

`public` expanding

`public` forwarding

`public` monitoring

**Uses:**

user

**Remarks:**

(none)

**Inherited public predicates:**

 after/3  before/3  forward/1  goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### coroutining")

**object**

#### `coroutining`

Coroutining predicates.

**Availability:**

`logtalk_load(coroutining(loader))`

**Author:** Paulo Moura

**Version:** 0:5:0

**Date:** 2021-12-17

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

> - Supported backend Prolog systems: ECLiPSe, SICStus Prolog, SWI-Prolog, Trealla Prolog, XVM, and YAP.

**Inherited public predicates:**

(none)

- Public predicates

  - `dif/2`

  - `dif/1`

  - `freeze/2`

  - `frozen/2`

  - `when/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `dif/2`

Sets a constraint that is true iff the two terms are different.

**Compilation flags:**

`static`

**Template:**

`dif(Term1,Term2)`

**Mode and number of proofs:**

`dif(+term,+term)` - `zero_or_one`

------------------------------------------------------------------------

###### `dif/1`

Sets a set of constraints that are true iff all terms in a list are different.

**Compilation flags:**

`static`

**Template:**

`dif(Terms)`

**Mode and number of proofs:**

`dif(+list(term))` - `zero_or_one`

------------------------------------------------------------------------

###### `freeze/2`

Delays the execution of a goal until a variable is bound.

**Compilation flags:**

`static`

**Template:**

`freeze(Variable,Goal)`

**Meta-predicate template:**

`freeze(*,0)`

**Mode and number of proofs:**

`freeze(+term,+callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `frozen/2`

Unifies `Goal` with the goal delayed by `Variable`. When no goals are frozen on `Variable`, `Goal` is unified with true.

**Compilation flags:**

`static`

**Template:**

`frozen(Variable,Goal)`

**Mode and number of proofs:**

`frozen(@var,--callable)` - `one`

------------------------------------------------------------------------

###### `when/2`

Calls `Goal` when `Condition` becomes true. The portable conditions are: `nonvar/1`, `ground/1`, `(,)/2`, and `(;)/2`.

**Compilation flags:**

`static`

**Template:**

`when(Condition,Goal)`

**Meta-predicate template:**

`when(*,0)`

**Mode and number of proofs:**

`when(+callable,+callable)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### csv")

**object**

#### `csv`

CSV files reading and writing predicates using the options Header - `keep`, Separator - `comma`, and IgnoreQuotes - `false`.

**Availability:**

`logtalk_load(csv(loader))`

**Author:** Jacinto Dávila

**Version:** 1:0:0

**Date:** 2021-02-02

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` csv(keep,comma,false,false)

**Remarks:**

(none)

**Inherited public predicates:**

 guess_arity/2  guess_separator/2  read_file/2  read_file/3  read_file_by_line/2  read_file_by_line/3  read_stream/2  read_stream/3  read_stream_by_line/2  read_stream_by_line/3  write_file/3  write_stream/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `csv(A,B,C)`

Backward-compatible parametric object equivalent to using `csv(_Header_,`` ``_Separator_,`` ``_IgnoreQuotes_,`` ``false)`.

**Availability:**

`logtalk_load(csv(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` csv(A,B,C,false)

**Remarks:**

(none)

**Inherited public predicates:**

 guess_arity/2  guess_separator/2  read_file/2  read_file/3  read_file_by_line/2  read_file_by_line/3  read_stream/2  read_stream/3  read_stream_by_line/2  read_stream_by_line/3  write_file/3  write_stream/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `csv(Header,Separator,IgnoreQuotes,Comments)`

- `Header` - Header handling option with possible values `missing`, `skip`, and `keep` (default).

- `Separator` - Separator handling option with possible values `comma` (default for non `.tsv` and non `.tab` files or when no file name extension is available), `tab` (default for `.tsv` and `.tab` files), `semicolon`, and `colon`.

- `IgnoreQuotes` - Double-quotes handling option to ignore (`true`) or preserve (`false`; default) double quotes surrounding data.

- `Comments` - Comment handling option with possible values `true` and `false` (default). When `true`, lines starting with `#` are skipped when reading CSV files and streams.

CSV file and stream reading and writing predicates.

**Availability:**

`logtalk_load(csv(loader))`

**Author:** Jacinto Dávila and Paulo Moura

**Version:** 2:2:0

**Date:** 2026-02-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` csv_protocol

**Uses:**

list

logtalk

os

reader

type

**Remarks:**

(none)

**Inherited public predicates:**

 guess_arity/2  guess_separator/2  read_file/2  read_file/3  read_file_by_line/2  read_file_by_line/3  read_stream/2  read_stream/3  read_stream_by_line/2  read_stream_by_line/3  write_file/3  write_stream/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `csv_guess_questions`

Support for asking questions when guessing the separator and the record arity of CSV files.

**Availability:**

`logtalk_load(csv(loader))`

**Author:** Jacinto Dávila

**Version:** 1:0:0

**Date:** 2021-02-03

**Compilation flags:**

`static`

**Provides:**

logtalk::message_tokens//2

logtalk::question_prompt_stream/4

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `csv_protocol`

CSV file and stream reading and writing protocol.

**Availability:**

`logtalk_load(csv(loader))`

**Author:** Jacinto Dávila and Paulo Moura

**Version:** 2:0:1

**Date:** 2025-05-07

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

> - Type-checking: Some of the predicate file and stream argument type-checking exceptions depend on the Prolog backend compliance with standards.

**Inherited public predicates:**

(none)

- Public predicates

  - `read_file/3`

  - `read_stream/3`

  - `read_file/2`

  - `read_stream/2`

  - `read_file_by_line/3`

  - `read_stream_by_line/3`

  - `read_file_by_line/2`

  - `read_stream_by_line/2`

  - `write_file/3`

  - `write_stream/3`

  - `guess_separator/2`

  - `guess_arity/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `read_file/3`

Reads a CSV file saving the data as clauses for the specified object predicate. Fails if the file cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`read_file(File,Object,Predicate)`

**Mode and number of proofs:**

`read_file(+atom,+object_identifier,+predicate_indicator)` - `zero_or_one`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an atom but not an existing file:

`existence_error(file,File)`

`File` is an existing file but cannot be opened for reading:

`permission_error(open,source_sink,File)`

`Object` is a variable:

`instantiation_error`

`Object` is neither a variable nor an object identifier:

`type_error(object_identifier,Object)`

`Object` is a valid object identifier but not an existing object:

`existence_error(object,Object)`

`Predicate` is a variable:

`instantiation_error`

`Predicate` is neither a variable nor a predicate indicator:

`type_error(predicate_indicator,Predicate)`

`Predicate` is a valid predicate indicator but not an existing public predicate:

`existence_error(predicate,Predicate)`

------------------------------------------------------------------------

###### `read_stream/3`

Reads a CSV stream saving the data as clauses for the specified object predicate. Fails if the stream cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`read_stream(Stream,Object,Predicate)`

**Mode and number of proofs:**

`read_stream(+stream_or_alias,+object_identifier,+predicate_indicator)` - `zero_or_one`

**Exceptions:**

`Stream` is a variable:

`instantiation_error`

`Stream` is neither a variable nor a stream-term or alias:

`domain_error(stream_or_alias,Stream)`

`Stream` is not an open stream:

`existence_error(stream,Stream)`

`Stream` is an output stream:

`permission_error(input,stream,Stream)`

`Stream` is a binary stream:

`permission_error(input,binary_stream,Stream)`

`Object` is a variable:

`instantiation_error`

`Object` is neither a variable nor an object identifier:

`type_error(object_identifier,Object)`

`Object` is a valid object identifier but not an existing object:

`existence_error(object,Object)`

`Predicate` is a variable:

`instantiation_error`

`Predicate` is neither a variable nor a predicate indicator:

`type_error(predicate_indicator,Predicate)`

`Predicate` is a valid predicate indicator but not an existing public predicate:

`existence_error(predicate,Predicate)`

------------------------------------------------------------------------

###### `read_file/2`

Reads a CSV file returning the data as a list of rows, each row a list of fields. Fails if the file cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`read_file(File,Rows)`

**Mode and number of proofs:**

`read_file(+atom,-list(list))` - `zero_or_one`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an atom but not an existing file:

`existence_error(file,File)`

`File` is an existing file but cannot be opened for reading:

`permission_error(open,source_sink,File)`

------------------------------------------------------------------------

###### `read_stream/2`

Reads a CSV stream returning the data as a list of rows, each row a list of fields. Fails if the stream cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`read_stream(Stream,Rows)`

**Mode and number of proofs:**

`read_stream(+stream_or_alias,-list(list))` - `zero_or_one`

**Exceptions:**

`Stream` is a variable:

`instantiation_error`

`Stream` is neither a variable nor a stream-term or alias:

`domain_error(stream_or_alias,Stream)`

`Stream` is not an open stream:

`existence_error(stream,Stream)`

`Stream` is an output stream:

`permission_error(input,stream,Stream)`

`Stream` is a binary stream:

`permission_error(input,binary_stream,Stream)`

------------------------------------------------------------------------

###### `read_file_by_line/3`

Reads a CSV file saving the data as clauses for the specified object predicate. The file is read line by line. Fails if the file cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`read_file_by_line(File,Object,Predicate)`

**Mode and number of proofs:**

`read_file_by_line(+atom,+object_identifier,+predicate_indicator)` - `zero_or_one`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an atom but not an existing file:

`existence_error(file,File)`

`File` is an existing file but cannot be opened for reading:

`permission_error(open,source_sink,File)`

`Object` is a variable:

`instantiation_error`

`Object` is neither a variable nor an object identifier:

`type_error(object_identifier,Object)`

`Object` is a valid object identifier but not an existing object:

`existence_error(object,Object)`

`Predicate` is a variable:

`instantiation_error`

`Predicate` is neither a variable nor a predicate indicator:

`type_error(predicate_indicator,Predicate)`

`Predicate` is a valid predicate indicator but not an existing public predicate:

`existence_error(predicate,Predicate)`

------------------------------------------------------------------------

###### `read_stream_by_line/3`

Reads a CSV stream saving the data as clauses for the specified object predicate. The stream is read line by line. Fails if the stream cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`read_stream_by_line(Stream,Object,Predicate)`

**Mode and number of proofs:**

`read_stream_by_line(+stream_or_alias,+object_identifier,+predicate_indicator)` - `zero_or_one`

**Exceptions:**

`Stream` is a variable:

`instantiation_error`

`Stream` is neither a variable nor a stream-term or alias:

`domain_error(stream_or_alias,Stream)`

`Stream` is not an open stream:

`existence_error(stream,Stream)`

`Stream` is an output stream:

`permission_error(input,stream,Stream)`

`Stream` is a binary stream:

`permission_error(input,binary_stream,Stream)`

`Object` is a variable:

`instantiation_error`

`Object` is neither a variable nor an object identifier:

`type_error(object_identifier,Object)`

`Object` is a valid object identifier but not an existing object:

`existence_error(object,Object)`

`Predicate` is a variable:

`instantiation_error`

`Predicate` is neither a variable nor a predicate indicator:

`type_error(predicate_indicator,Predicate)`

`Predicate` is a valid predicate indicator but not an existing public predicate:

`existence_error(predicate,Predicate)`

------------------------------------------------------------------------

###### `read_file_by_line/2`

Reads a CSV file returning the data as a list of rows, each row a list of fields. The file is read line by line. Fails if the file cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`read_file_by_line(File,Rows)`

**Mode and number of proofs:**

`read_file_by_line(+atom,-list(list))` - `zero_or_one`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an atom but not an existing file:

`existence_error(file,File)`

`File` is an existing file but cannot be opened for reading:

`permission_error(open,source_sink,File)`

------------------------------------------------------------------------

###### `read_stream_by_line/2`

Reads a CSV stream returning the data as a list of rows, each row a list of fields. The stream is read line by line. Fails if the stream cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`read_stream_by_line(Stream,Rows)`

**Mode and number of proofs:**

`read_stream_by_line(+stream_or_alias,-list(list))` - `zero_or_one`

**Exceptions:**

`Stream` is a variable:

`instantiation_error`

`Stream` is neither a variable nor a stream-term or alias:

`domain_error(stream_or_alias,Stream)`

`Stream` is not an open stream:

`existence_error(stream,Stream)`

`Stream` is an output stream:

`permission_error(input,stream,Stream)`

`Stream` is a binary stream:

`permission_error(input,binary_stream,Stream)`

------------------------------------------------------------------------

###### `write_file/3`

Writes a CSV file with the data represented by the solutions to the specified object predicate.

**Compilation flags:**

`static`

**Template:**

`write_file(File,Object,Predicate)`

**Mode and number of proofs:**

`write_file(+atom,+object_identifier,+predicate_indicator)` - `one`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an atom but cannot be opened for writing:

`permission_error(open,source_sink,File)`

`Object` is a variable:

`instantiation_error`

`Object` is neither a variable nor an object identifier:

`type_error(object_identifier,Object)`

`Object` is a valid object identifier but not an existing object:

`existence_error(object,Object)`

`Predicate` is a variable:

`instantiation_error`

`Predicate` is neither a variable nor a predicate indicator:

`type_error(predicate_indicator,Predicate)`

`Predicate` is a valid predicate indicator but not an existing public predicate:

`existence_error(predicate,Predicate)`

------------------------------------------------------------------------

###### `write_stream/3`

Writes a CSV stream with the data represented by the solutions to the specified object predicate.

**Compilation flags:**

`static`

**Template:**

`write_stream(Stream,Object,Predicate)`

**Mode and number of proofs:**

`write_stream(+stream_or_alias,+object_identifier,+predicate_indicator)` - `one`

**Exceptions:**

`Stream` is a variable:

`instantiation_error`

`Stream` is neither a variable nor a stream-term or alias:

`domain_error(stream_or_alias,Stream)`

`Stream` is not an open stream:

`existence_error(stream,Stream)`

`Stream` is an input stream:

`permission_error(output,stream,Stream)`

`Stream` is a binary stream:

`permission_error(output,binary_stream,Stream)`

`Object` is a variable:

`instantiation_error`

`Object` is neither a variable nor an object identifier:

`type_error(object_identifier,Object)`

`Object` is a valid object identifier but not an existing object:

`existence_error(object,Object)`

`Predicate` is a variable:

`instantiation_error`

`Predicate` is neither a variable nor a predicate indicator:

`type_error(predicate_indicator,Predicate)`

`Predicate` is a valid predicate indicator but not an existing public predicate:

`existence_error(predicate,Predicate)`

------------------------------------------------------------------------

###### `guess_separator/2`

Guesses the separator used in a given file, asking the user to confirm.

**Compilation flags:**

`static`

**Template:**

`guess_separator(File,Separator)`

**Mode and number of proofs:**

`guess_separator(+atom,-atom)` - `one`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an atom but not an existing file:

`existence_error(file,File)`

`File` is an atom but cannot be opened for writing:

`permission_error(open,source_sink,File)`

------------------------------------------------------------------------

###### `guess_arity/2`

Guesses the arity of records in a given file, asking the user to confirm.

**Compilation flags:**

`static`

**Template:**

`guess_arity(File,Arity)`

**Mode and number of proofs:**

`guess_arity(+atom,-number)` - `one`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an atom but not an existing file:

`existence_error(file,File)`

`File` is an atom but cannot be opened for writing:

`permission_error(open,source_sink,File)`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### cuid2")

**object**

#### `cuid2`

Cuid2 generator using atom representation, 24 symbols, and a lowercase alphanumeric alphabet.

**Availability:**

`logtalk_load(cuid2(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` cuid2(atom,24,abcdefghijklmnopqrstuvwxyz0123456789)

**Remarks:**

(none)

**Inherited public predicates:**

 generate/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

cuid2(Representation,Size,Alphabet), ids, ksuid, nanoid, snowflakeid, ulid, uuid

**object**

#### `cuid2(Representation,Size,Alphabet)`

- `Representation` - Text representation for the Cuid2 identifier. Possible values are `atom`, `chars`, and `codes`.

- `Size` - Number of symbols in the Cuid2 identifier.

- `Alphabet` - Alphabet used for generating Cuid2 identifiers represented as an atom, list of characters, or list of character codes.

Cuid2 generator.

**Availability:**

`logtalk_load(cuid2(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` cuid2_protocol

**Uses:**

fast_random(Algorithm)

list

os

**Remarks:**

(none)

**Inherited public predicates:**

 generate/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

cuid2, ids(Representation,Bytes), ksuid(Representation,Alphabet), nanoid(Representation,Size,Alphabet), snowflakeid(Representation,EpochMilliseconds,TimeUnitMilliseconds,TimestampBits,NodeBits,SequenceBits,Node), ulid(Representation), uuid(Representation)

**protocol**

#### `cuid2_protocol`

Cuid2 generator protocol.

**Availability:**

`logtalk_load(cuid2(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `generate/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `generate/1`

Returns a Cuid2 identifier.

**Compilation flags:**

`static`

**Template:**

`generate(Cuid2)`

**Mode and number of proofs:**

`generate(--ground)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### datalog")

**object**

#### `datalog`

Portable Datalog engine with stratified negation and incremental updates.

**Availability:**

`logtalk_load(datalog(loader))`

**Author:** Paulo Moura

**Version:** 0:1:0

**Date:** 2026-02-13

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` datalog_protocol

**Uses:**

list

numberlist

type

varlist

**Remarks:**

(none)

**Inherited public predicates:**

 add_rule/3  assert_fact/1  begin/0  clear/0  commit/0  explain/2  facts/1  load_program/1  materialize/0  predicate_stratum/3  query/1  query/2  remove_rule/1  retract_fact/1  rollback/0  (rules)/1  strata/1  update/3

- Public predicates

- Protected predicates

- Private predicates

  - `rule_/3`

  - `edb_fact_/1`

  - `idb_fact_/1`

  - `support_count_/2`

  - `support_edge_/3`

  - `predicate_stratum_/3`

  - `snapshot_/6`

  - `restore_snapshot/6`

  - `restore_edb_facts/1`

  - `restore_idb_facts/1`

  - `restore_support_counts/1`

  - `restore_support_edges/1`

  - `restore_predicate_strata/1`

  - `strata_from_numbers/2`

  - `predicates_in_stratum/2`

  - `has_aggregate_rules/0`

  - `aggregate_body_predicate/2`

  - `derive_aggregate_literal/2`

  - `derive_aggregate_goals/1`

  - `optimize_rule_body/2`

  - `partition_body_literals/5`

  - `literal_bucket/2`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `rule_/3`

Table of loaded rules represented as rule id, head, and body literals.

**Compilation flags:**

`dynamic`

**Template:**

`rule_(Id,Head,Body)`

**Mode and number of proofs:**

`rule_(?nonvar,?callable,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `edb_fact_/1`

Table of extensional database (EDB) facts.

**Compilation flags:**

`dynamic`

**Template:**

`edb_fact_(Fact)`

**Mode and number of proofs:**

`edb_fact_(?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `idb_fact_/1`

Table of intensional database (IDB) currently derived facts.

**Compilation flags:**

`dynamic`

**Template:**

`idb_fact_(Fact)`

**Mode and number of proofs:**

`idb_fact_(?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `support_count_/2`

Table of derivation support counts for currently derived facts.

**Compilation flags:**

`dynamic`

**Template:**

`support_count_(Fact,Count)`

**Mode and number of proofs:**

`support_count_(?callable,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `support_edge_/3`

Table of concrete derivation edges as fact, rule id, and supporting literals.

**Compilation flags:**

`dynamic`

**Template:**

`support_edge_(Fact,RuleId,Supports)`

**Mode and number of proofs:**

`support_edge_(?callable,?nonvar,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `predicate_stratum_/3`

Table of computed predicate strata represented as name, arity, and stratum number.

**Compilation flags:**

`dynamic`

**Template:**

`predicate_stratum_(Name,Arity,Stratum)`

**Mode and number of proofs:**

`predicate_stratum_(?atom,?integer,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `snapshot_/6`

Transaction snapshot of rules, EDB facts, IDB facts, support counts, support edges, and predicate strata.

**Compilation flags:**

`dynamic`

**Template:**

`snapshot_(Rules,EdbFacts,IdbFacts,SupportCounts,SupportEdges,PredicateStrata)`

**Mode and number of proofs:**

`snapshot_(?list,?list,?list,?list,?list,?list)` - `zero_or_one`

------------------------------------------------------------------------

###### `restore_snapshot/6`

Restores a saved transaction snapshot into the current engine state.

**Compilation flags:**

`static`

**Template:**

`restore_snapshot(Rules,EdbFacts,IdbFacts,SupportCounts,SupportEdges,PredicateStrata)`

**Mode and number of proofs:**

`restore_snapshot(+list,+list,+list,+list,+list,+list)` - `one`

------------------------------------------------------------------------

###### `restore_edb_facts/1`

Restores EDB facts from a saved list.

**Compilation flags:**

`static`

**Template:**

`restore_edb_facts(Facts)`

**Mode and number of proofs:**

`restore_edb_facts(+list(callable))` - `one`

------------------------------------------------------------------------

###### `restore_idb_facts/1`

Restores IDB facts from a saved list.

**Compilation flags:**

`static`

**Template:**

`restore_idb_facts(Facts)`

**Mode and number of proofs:**

`restore_idb_facts(+list(callable))` - `one`

------------------------------------------------------------------------

###### `restore_support_counts/1`

Restores support counts from a saved list.

**Compilation flags:**

`static`

**Template:**

`restore_support_counts(Supports)`

**Mode and number of proofs:**

`restore_support_counts(+list)` - `one`

------------------------------------------------------------------------

###### `restore_support_edges/1`

Restores support edges from a saved list.

**Compilation flags:**

`static`

**Template:**

`restore_support_edges(Edges)`

**Mode and number of proofs:**

`restore_support_edges(+list)` - `one`

------------------------------------------------------------------------

###### `restore_predicate_strata/1`

Restores predicate strata from a saved list.

**Compilation flags:**

`static`

**Template:**

`restore_predicate_strata(Strata)`

**Mode and number of proofs:**

`restore_predicate_strata(+list)` - `one`

------------------------------------------------------------------------

###### `strata_from_numbers/2`

Builds grouped strata terms from a sorted list of stratum numbers.

**Compilation flags:**

`static`

**Template:**

`strata_from_numbers(StratumNumbers,Strata)`

**Mode and number of proofs:**

`strata_from_numbers(+list(integer),-list)` - `one`

------------------------------------------------------------------------

###### `predicates_in_stratum/2`

Returns predicates in a given stratum as sorted `predicate(Name,`` ``Arity)` terms.

**Compilation flags:**

`static`

**Template:**

`predicates_in_stratum(Stratum,Predicates)`

**Mode and number of proofs:**

`predicates_in_stratum(+integer,-list)` - `one`

------------------------------------------------------------------------

###### `has_aggregate_rules/0`

True when at least one loaded rule body contains an aggregate literal.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`has_aggregate_rules` - `zero_or_one`

------------------------------------------------------------------------

###### `aggregate_body_predicate/2`

Enumerates predicate indicators referenced in aggregate goals from a body literal list.

**Compilation flags:**

`static`

**Template:**

`aggregate_body_predicate(Body,Predicate)`

**Mode and number of proofs:**

`aggregate_body_predicate(+list,-compound)` - `zero_or_more`

------------------------------------------------------------------------

###### `derive_aggregate_literal/2`

Evaluates an aggregate literal and returns a normalized support term.

**Compilation flags:**

`static`

**Template:**

`derive_aggregate_literal(AggregateLiteral,Support)`

**Mode and number of proofs:**

`derive_aggregate_literal(+compound,-nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `derive_aggregate_goals/1`

Succeeds when all aggregate goals are true for the current bindings.

**Compilation flags:**

`static`

**Template:**

`derive_aggregate_goals(Goals)`

**Mode and number of proofs:**

`derive_aggregate_goals(+list(callable))` - `zero_or_one`

------------------------------------------------------------------------

###### `optimize_rule_body/2`

Normalizes a rule body by placing positive ground literals first, then positive non-ground literals, then aggregates, and finally negative literals.

**Compilation flags:**

`static`

**Template:**

`optimize_rule_body(Body,OptimizedBody)`

**Mode and number of proofs:**

`optimize_rule_body(+list,-list)` - `one`

------------------------------------------------------------------------

###### `partition_body_literals/5`

Partitions body literals into positive-ground, positive-non-ground, aggregate, and negative lists preserving relative order.

**Compilation flags:**

`static`

**Template:**

`partition_body_literals(Body,PositiveGround,PositiveNonGround,Aggregates,Negatives)`

**Mode and number of proofs:**

`partition_body_literals(+list,-list,-list,-list,-list)` - `one`

------------------------------------------------------------------------

###### `literal_bucket/2`

Classifies a body literal into one of the normalization buckets.

**Compilation flags:**

`static`

**Template:**

`literal_bucket(Literal,Bucket)`

**Mode and number of proofs:**

`literal_bucket(+nonvar,-atom)` - `one`

------------------------------------------------------------------------

##### Operators

(none)

**protocol**

#### `datalog_protocol`

Datalog and incremental rule engine protocol (stratified negation subset).

**Availability:**

`logtalk_load(datalog(loader))`

**Author:** Paulo Moura

**Version:** 0:1:0

**Date:** 2026-02-13

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

> - Rules: Rules are represented as `rule(Id,`` ``Head,`` ``Body)` where `Body` is a list of literals using `Term` for positive, `neg(Term)` for negative, and `agg(Op,`` ``Template,`` ``Goals,`` ``Result)` for aggregates where `Op` is one of `count`, `sum`, `min`, or `max`.
>
> - Facts: EDB facts are represented by callable and ground terms.
>
> - Limitations: Current version requires aggregate dependencies to be in lower strata.

**Inherited public predicates:**

(none)

- Public predicates

  - `clear/0`

  - `load_program/1`

  - `add_rule/3`

  - `remove_rule/1`

  - `begin/0`

  - `commit/0`

  - `rollback/0`

  - `assert_fact/1`

  - `retract_fact/1`

  - `materialize/0`

  - `update/3`

  - `query/1`

  - `query/2`

  - `explain/2`

  - `(rules)/1`

  - `facts/1`

  - `predicate_stratum/3`

  - `strata/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `clear/0`

Clears all loaded rules, base facts, derived facts, and explanation supports.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`clear` - `one`

------------------------------------------------------------------------

###### `load_program/1`

Loads a full program represented as a list of `rule(Id,Head,Body)` and `fact(Fact)` terms, replacing current engine state.

**Compilation flags:**

`static`

**Template:**

`load_program(Program)`

**Mode and number of proofs:**

`load_program(+list)` - `one`

------------------------------------------------------------------------

###### `add_rule/3`

Adds or replaces a rule. Rule safety is checked.

**Compilation flags:**

`static`

**Template:**

`add_rule(Id,Head,Body)`

**Mode and number of proofs:**

`add_rule(+nonvar,+callable,+list(callable))` - `one`

------------------------------------------------------------------------

###### `remove_rule/1`

Removes all rules matching a rule identifier.

**Compilation flags:**

`static`

**Template:**

`remove_rule(Id)`

**Mode and number of proofs:**

`remove_rule(+nonvar)` - `one`

------------------------------------------------------------------------

###### `begin/0`

Starts a transaction by saving the current engine state snapshot.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`begin` - `one`

------------------------------------------------------------------------

###### `commit/0`

Commits a transaction by discarding the saved state snapshot.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`commit` - `one`

------------------------------------------------------------------------

###### `rollback/0`

Rolls back a transaction by restoring the saved state snapshot.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`rollback` - `one`

------------------------------------------------------------------------

###### `assert_fact/1`

Asserts a ground EDB fact if not already present.

**Compilation flags:**

`static`

**Template:**

`assert_fact(Fact)`

**Mode and number of proofs:**

`assert_fact(+callable)` - `one`

------------------------------------------------------------------------

###### `retract_fact/1`

Retracts an EDB fact if present.

**Compilation flags:**

`static`

**Template:**

`retract_fact(Fact)`

**Mode and number of proofs:**

`retract_fact(+callable)` - `one`

------------------------------------------------------------------------

###### `materialize/0`

Computes rule closure from current EDB facts and loaded rules using a fixpoint algorithm.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`materialize` - `one`

------------------------------------------------------------------------

###### `update/3`

Applies incremental EDB updates and propagates derivation additions/removals; returns the resulting truth delta.

**Compilation flags:**

`static`

**Template:**

`update(Inserts,Deletes,Delta)`

**Mode and number of proofs:**

`update(+list(callable),+list(callable),-compound)` - `one`

------------------------------------------------------------------------

###### `query/1`

Enumerates currently true facts (EDB + IDB).

**Compilation flags:**

`static`

**Template:**

`query(Goal)`

**Mode and number of proofs:**

`query(?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `query/2`

Same as `query/1` while returning the unified goal as the second argument.

**Compilation flags:**

`static`

**Template:**

`query(Goal,Bindings)`

**Mode and number of proofs:**

`query(?callable,?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `explain/2`

Returns one explanation for a currently true fact.

**Compilation flags:**

`static`

**Template:**

`explain(Fact,Explanation)`

**Mode and number of proofs:**

`explain(+callable,-nonvar)` - `zero_or_more`

------------------------------------------------------------------------

###### `(rules)/1`

Returns the loaded rules.

**Compilation flags:**

`static`

**Template:**

`rules`` ``Rules`

**Mode and number of proofs:**

`rules-list` - `one`

------------------------------------------------------------------------

###### `facts/1`

Returns all currently true facts as a sorted list.

**Compilation flags:**

`static`

**Template:**

`facts(Facts)`

**Mode and number of proofs:**

`facts(-list(callable))` - `one`

------------------------------------------------------------------------

###### `predicate_stratum/3`

Enumerates predicate strata as functor, arity, and stratum number.

**Compilation flags:**

`static`

**Template:**

`predicate_stratum(Functor,Arity,Stratum)`

**Mode and number of proofs:**

`predicate_stratum(?atom,?integer,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `strata/1`

Returns all strata grouped by stratum number and contained predicates.

**Compilation flags:**

`static`

**Template:**

`strata(Strata)`

**Mode and number of proofs:**

`strata(-list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### dates")

**object**

#### `date`

Date predicates.

**Availability:**

`logtalk_load(dates(loader))`

**Author:** Paulo Moura

**Version:** 1:3:0

**Date:** 2026-02-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` datep

**Uses:**

os

**Remarks:**

(none)

**Inherited public predicates:**

 add_duration/3  date_time_to_unix/2  day_of_year/2  days_in_month/3  duration_between/3  leap_year/1  local_to_utc/3  name_of_day/3  name_of_month/3  normalize_date_time/2  subtract_duration/3  today/3  unix_to_date_time/2  utc_to_local/3  valid/3  valid_date_time/1  valid_date_time/2  week_of_year_iso/2  weekday/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `datep`

Date protocol.

**Availability:**

`logtalk_load(dates(loader))`

**Author:** Paulo Moura

**Version:** 1:2:0

**Date:** 2026-02-25

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `today/3`

  - `leap_year/1`

  - `name_of_day/3`

  - `name_of_month/3`

  - `days_in_month/3`

  - `valid/3`

  - `date_time_to_unix/2`

  - `unix_to_date_time/2`

  - `add_duration/3`

  - `subtract_duration/3`

  - `duration_between/3`

  - `utc_to_local/3`

  - `local_to_utc/3`

  - `day_of_year/2`

  - `week_of_year_iso/2`

  - `weekday/2`

  - `normalize_date_time/2`

  - `valid_date_time/1`

  - `valid_date_time/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `today/3`

Returns current date.

**Compilation flags:**

`static`

**Template:**

`today(Year,Month,Day)`

**Mode and number of proofs:**

`today(-integer,-integer,-integer)` - `one`

------------------------------------------------------------------------

###### `leap_year/1`

True if the argument is a leap year.

**Compilation flags:**

`static`

**Template:**

`leap_year(Year)`

**Mode and number of proofs:**

`leap_year(+integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `name_of_day/3`

Name and short name of day.

**Compilation flags:**

`static`

**Template:**

`name_of_day(Index,Name,Short)`

**Mode and number of proofs:**

`name_of_day(?integer,?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `name_of_month/3`

Name and short name of month.

**Compilation flags:**

`static`

**Template:**

`name_of_month(Index,Name,Short)`

**Mode and number of proofs:**

`name_of_month(?integer,?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `days_in_month/3`

Number of days in a month.

**Compilation flags:**

`static`

**Template:**

`days_in_month(Month,Year,Days)`

**Mode and number of proofs:**

`days_in_month(?integer,+integer,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `valid/3`

True if the arguments represent a valid date.

**Compilation flags:**

`static`

**Template:**

`valid(Year,Month,Day)`

**Mode and number of proofs:**

`valid(@integer,@integer,@integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `date_time_to_unix/2`

Converts a UTC date-time term `date_time(Year,Month,Day,Hours,Minutes,Seconds)` to Unix epoch seconds.

**Compilation flags:**

`static`

**Template:**

`date_time_to_unix(DateTime,UnixTime)`

**Mode and number of proofs:**

`date_time_to_unix(+compound,-integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `unix_to_date_time/2`

Converts Unix epoch seconds to a UTC date-time term `date_time(Year,Month,Day,Hours,Minutes,Seconds)`.

**Compilation flags:**

`static`

**Template:**

`unix_to_date_time(UnixTime,DateTime)`

**Mode and number of proofs:**

`unix_to_date_time(+integer,-compound)` - `one`

------------------------------------------------------------------------

###### `add_duration/3`

Adds a duration to a datetime. Duration can be integer seconds or `duration(Days,Hours,Minutes,Seconds)`.

**Compilation flags:**

`static`

**Template:**

`add_duration(DateTime,Duration,ResultDateTime)`

**Mode and number of proofs:**

`add_duration(+compound,+nonvar,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `subtract_duration/3`

Subtracts a duration from a datetime. Duration can be integer seconds or `duration(Days,Hours,Minutes,Seconds)`.

**Compilation flags:**

`static`

**Template:**

`subtract_duration(DateTime,Duration,ResultDateTime)`

**Mode and number of proofs:**

`subtract_duration(+compound,+nonvar,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `duration_between/3`

Computes the difference between two datetimes as integer seconds or as `duration(Days,Hours,Minutes,Seconds)`.

**Compilation flags:**

`static`

**Template:**

`duration_between(StartDateTime,EndDateTime,Duration)`

**Mode and number of proofs:**

`duration_between(+compound,+compound,?term)` - `zero_or_one`

------------------------------------------------------------------------

###### `utc_to_local/3`

Converts a UTC datetime to a local datetime using an explicit timezone offset atom (`Z` or `±HH:MM`).

**Compilation flags:**

`static`

**Template:**

`utc_to_local(UTCDateTime,Offset,LocalDateTime)`

**Mode and number of proofs:**

`utc_to_local(+compound,+atom,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `local_to_utc/3`

Converts a local datetime to UTC using an explicit timezone offset atom (`Z` or `±HH:MM`).

**Compilation flags:**

`static`

**Template:**

`local_to_utc(LocalDateTime,Offset,UTCDateTime)`

**Mode and number of proofs:**

`local_to_utc(+compound,+atom,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `day_of_year/2`

Computes the day of year (1-366) for a `date(Year,Month,Day)` or `date_time(...)` term.

**Compilation flags:**

`static`

**Template:**

`day_of_year(DateLike,DayOfYear)`

**Mode and number of proofs:**

`day_of_year(+compound,?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `week_of_year_iso/2`

Computes ISO week for a `date(Year,Month,Day)` or `date_time(...)` term as `week(Week,Year)`.

**Compilation flags:**

`static`

**Template:**

`week_of_year_iso(DateLike,ISOWeek)`

**Mode and number of proofs:**

`week_of_year_iso(+compound,?compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `weekday/2`

Computes ISO weekday number (Monday=1, …, Sunday=7) for a `date(Year,Month,Day)` or `date_time(...)` term.

**Compilation flags:**

`static`

**Template:**

`weekday(DateLike,Weekday)`

**Mode and number of proofs:**

`weekday(+compound,?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `normalize_date_time/2`

Normalizes a datetime term by carrying overflows/underflows in date and time fields.

**Compilation flags:**

`static`

**Template:**

`normalize_date_time(DateTime,NormalizedDateTime)`

**Mode and number of proofs:**

`normalize_date_time(+compound,-compound)` - `one`

------------------------------------------------------------------------

###### `valid_date_time/1`

True iff a datetime term is valid in strict mode.

**Compilation flags:**

`static`

**Template:**

`valid_date_time(DateTime)`

**Mode and number of proofs:**

`valid_date_time(@compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `valid_date_time/2`

Validates a datetime term in `strict` or `relaxed` mode.

**Compilation flags:**

`static`

**Template:**

`valid_date_time(DateTime,Mode)`

**Mode and number of proofs:**

`valid_date_time(@compound,+atom)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

date, timep

**object**

#### `time`

Time predicates.

**Availability:**

`logtalk_load(dates(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2014-09-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` timep

**Uses:**

os

**Remarks:**

(none)

**Inherited public predicates:**

 cpu_time/1  now/3  valid/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

datep

**protocol**

#### `timep`

Time protocol.

**Availability:**

`logtalk_load(dates(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2000-07-24

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `now/3`

  - `cpu_time/1`

  - `valid/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `now/3`

Returns current time.

**Compilation flags:**

`static`

**Template:**

`now(Hours,Mins,Secs)`

**Mode and number of proofs:**

`now(-integer,-integer,-integer)` - `one`

------------------------------------------------------------------------

###### `cpu_time/1`

Returns the current cpu time.

**Compilation flags:**

`static`

**Template:**

`cpu_time(Time)`

**Mode and number of proofs:**

`cpu_time(-number)` - `one`

------------------------------------------------------------------------

###### `valid/3`

True if the arguments represent a valid time value.

**Compilation flags:**

`static`

**Template:**

`valid(Hours,Mins,Secs)`

**Mode and number of proofs:**

`valid(+integer,+integer,+integer)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

time, datep

### dead_code_scanner")

**object**

#### `dead_code_scanner`

A tool for detecting *likely* dead code in compiled Logtalk entities and Prolog modules compiled as objects.

**Availability:**

`logtalk_load(dead_code_scanner(loader))`

**Author:** Barry Evans and Paulo Moura

**Version:** 0:15:2

**Date:** 2024-10-21

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` options

**Uses:**

list

logtalk

os

type

**Remarks:**

> - Dead code: A predicate or non-terminal that is not called (directly or indirectly) by any scoped predicate or non-terminal. These predicates and non-terminals are not used, cannot be called without breaking encapsulation, and are thus considered dead code.
>
> - Known issues: Use of local meta-calls with goal arguments only know at runtime can result in false positives. Calls from non-standard meta-predicates may be missed if the meta-calls are not optimized.
>
> - Requirements: Source files must be compiled with the `source_data` flag turned on. To avoid false positives do to meta-calls, compilation of source files with the `optimized` flag turned on is also advised.

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  option/2  option/3  valid_option/1  valid_options/1

- Public predicates

  - `entity/1`

  - `file/2`

  - `file/1`

  - `directory/2`

  - `directory/1`

  - `rdirectory/2`

  - `rdirectory/1`

  - `library/2`

  - `library/1`

  - `rlibrary/2`

  - `rlibrary/1`

  - `all/1`

  - `all/0`

  - `predicates/2`

  - `predicate/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `entity/1`

Scans a loaded entity for dead code. Fails if the entity does not exist.

**Compilation flags:**

`static`

**Template:**

`entity(Entity)`

**Mode and number of proofs:**

`entity(+entity_identifier)` - `zero_or_one`

------------------------------------------------------------------------

###### `file/2`

Scans all entities in a loaded source file for dead code using the given options. The file can be given by name, basename, full path, or using library notation. Fails if the file is not loaded.

**Compilation flags:**

`static`

**Template:**

`file(File,Options)`

**Mode and number of proofs:**

`file(+atom,+list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `file/1`

Scans all entities in a loaded source file for dead code using default options. The file can be given by name, basename, full path, or using library notation. Fails if the file is not loaded.

**Compilation flags:**

`static`

**Template:**

`file(File)`

**Mode and number of proofs:**

`file(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `directory/2`

Scans all entities in all loaded files from a given directory for dead code using the given options.

**Compilation flags:**

`static`

**Template:**

`directory(Directory,Options)`

**Mode and number of proofs:**

`directory(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `directory/1`

Scans all entities in all loaded files from a given directory for dead code using default options.

**Compilation flags:**

`static`

**Template:**

`directory(Directory)`

**Mode and number of proofs:**

`directory(+atom)` - `one`

------------------------------------------------------------------------

###### `rdirectory/2`

Scans all entities in all loaded files from a given directory and its sub-directories for dead code using the given options.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Directory,Options)`

**Mode and number of proofs:**

`rdirectory(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `rdirectory/1`

Scans all entities in all loaded files from a given directory and its sub-directories for dead code using default options.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Directory)`

**Mode and number of proofs:**

`rdirectory(+atom)` - `one`

------------------------------------------------------------------------

###### `library/2`

Scans all entities in all loaded files from a given library for dead code using the given options.

**Compilation flags:**

`static`

**Template:**

`library(Library,Options)`

**Mode and number of proofs:**

`library(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `library/1`

Scans all entities in all loaded files from a given library for dead code using default options.

**Compilation flags:**

`static`

**Template:**

`library(Library)`

**Mode and number of proofs:**

`library(+atom)` - `one`

------------------------------------------------------------------------

###### `rlibrary/2`

Scans all entities in all loaded files in a loaded library and its sub-libraries for dead code using the given options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library,Options)`

**Mode and number of proofs:**

`rlibrary(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `rlibrary/1`

Scans all entities in all loaded files in a loaded library and its sub-libraries for dead code using default options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library)`

**Mode and number of proofs:**

`rlibrary(+atom)` - `one`

------------------------------------------------------------------------

###### `all/1`

Scans all entities for dead code using the given options.

**Compilation flags:**

`static`

**Template:**

`all(Options)`

**Mode and number of proofs:**

`all(+list(compound))` - `one`

------------------------------------------------------------------------

###### `all/0`

Scans all entities for dead code using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`all` - `one`

------------------------------------------------------------------------

###### `predicates/2`

Returns an ordered set of local predicates (and non-terminals) that are not used, directly or indirectly, by scoped predicates for a loaded entity.

**Compilation flags:**

`static`

**Template:**

`predicates(Entity,Predicates)`

**Mode and number of proofs:**

`predicates(+entity_identifier,-list(predicate_indicator))` - `one`

------------------------------------------------------------------------

###### `predicate/2`

Enumerates, by backtracking, local predicates (and non-terminals) that are not used, directly or indirectly, by scoped predicates for a loaded entity.

**Compilation flags:**

`static`

**Template:**

`predicate(Entity,Predicate)`

**Mode and number of proofs:**

`predicate(+entity_identifier,?predicate_indicator)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `dead_code_scanner_messages`

Logtalk `dead_code_scanner` tool default message translations.

**Availability:**

`logtalk_load(dead_code_scanner(loader))`

**Author:** Barry Evans and Paulo Moura

**Version:** 0:8:0

**Date:** 2024-05-07

**Compilation flags:**

`static`

**Provides:**

logtalk::message_prefix_stream/4

logtalk::message_tokens//2

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### debug_messages")

**object**

#### `debug_messages`

Supports selective enabling and disabling of `debug` and `debug(Group)` messages.

**Availability:**

`logtalk_load(debug_messages(loader))`

**Author:** Paulo Moura

**Version:** 1:0:1

**Date:** 2022-05-05

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Uses:**

logtalk

**Remarks:**

> - Limitations: Debug messages are suppressed by the compiler when the `optimize` flag is turned on and thus cannot be enabled in this case.

**Inherited public predicates:**

(none)

- Public predicates

  - `enable/1`

  - `disable/1`

  - `enabled/1`

  - `enable/2`

  - `disable/2`

  - `enabled/2`

- Protected predicates

- Private predicates

  - `enabled_/1`

  - `enabled_/2`

- Operators

##### Public predicates

###### `enable/1`

Enables all `debug` and `debug(Group)` messages for the given component.

**Compilation flags:**

`static`

**Template:**

`enable(Component)`

**Mode and number of proofs:**

`enable(@term)` - `one`

------------------------------------------------------------------------

###### `disable/1`

Disables all `debug` and `debug(Group)` messages for the given component.

**Compilation flags:**

`static`

**Template:**

`disable(Component)`

**Mode and number of proofs:**

`disable(@term)` - `one`

------------------------------------------------------------------------

###### `enabled/1`

Enumerates by backtracking the components with enabled `debug` and `debug(Group)` messages.

**Compilation flags:**

`static`

**Template:**

`enabled(Component)`

**Mode and number of proofs:**

`enabled(?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `enable/2`

Enables `debug(Group)` messages for the given component and group.

**Compilation flags:**

`static`

**Template:**

`enable(Component,Group)`

**Mode and number of proofs:**

`enable(@term,@term)` - `one`

------------------------------------------------------------------------

###### `disable/2`

Disables `debug(Group)` messages for the given component and group.

**Compilation flags:**

`static`

**Template:**

`disable(Component,Group)`

**Mode and number of proofs:**

`disable(@term,@term)` - `one`

------------------------------------------------------------------------

###### `enabled/2`

Enumerates by backtracking the enabled `debug(Group)` messages for each component.

**Compilation flags:**

`static`

**Template:**

`enabled(Component,Group)`

**Mode and number of proofs:**

`enabled(?term,?term)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `enabled_/1`

Table of components with currently enabled `debug` and `debug(Group)` messages.

**Compilation flags:**

`dynamic`

**Template:**

`enabled_(Component)`

**Mode and number of proofs:**

`enabled_(?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `enabled_/2`

Table of currently enabled `debug(Group)` per component.

**Compilation flags:**

`dynamic`

**Template:**

`enabled_(Component,Group)`

**Mode and number of proofs:**

`enabled_(?term,?term)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

### debugger")

**object**

#### `debugger`

Command-line debugger based on an extended procedure box model supporting execution tracing and spy points.

**Availability:**

`logtalk_load(debugger(loader))`

**Author:** Paulo Moura

**Version:** 8:0:1

**Date:** 2026-02-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` debuggerp

**Provides:**

logtalk::debug_handler/1

logtalk::debug_handler/3

**Uses:**

logtalk

**Remarks:**

(none)

**Inherited public predicates:**

 debug/0  debugging/0  debugging/1  leash/1  leashing/1  log/3  logging/3  nodebug/0  nolog/3  nologall/0  nospy/1  nospy/3  nospy/4  nospyall/0  notrace/0  reset/0  set_write_max_depth/1  spy/1  spy/3  spy/4  spying/1  spying/3  spying/4  trace/0  write_max_depth/1

- Public predicates

- Protected predicates

- Private predicates

  - `debugging_/0`

  - `tracing_/0`

  - `explicit_tracing_/0`

  - `skipping_/0`

  - `skipping_unleashed_/1`

  - `quasi_skipping_/0`

  - `leaping_/1`

  - `leashing_/1`

  - `invocation_number_/1`

  - `jump_to_invocation_number_/1`

  - `zap_to_port_/1`

  - `write_max_depth_/1`

  - `log_point_/3`

  - `clause_breakpoint_/2`

  - `predicate_breakpoint_/3`

  - `entity_predicate_breakpoint_/4`

  - `context_breakpoint_/4`

  - `conditional_breakpoint_/3`

  - `triggered_breakpoint_/4`

  - `triggered_breakpoint_enabled_/2`

  - `file_line_hit_count_/3`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `debugging_/0`

True iff debug is on.

**Compilation flags:**

`dynamic`

**Mode and number of proofs:**

`debugging_` - `zero_or_one`

------------------------------------------------------------------------

###### `tracing_/0`

True iff tracing is on.

**Compilation flags:**

`dynamic`

**Mode and number of proofs:**

`tracing_` - `zero_or_one`

------------------------------------------------------------------------

###### `explicit_tracing_/0`

True iff tracing is on due to a call to the trace/0 predicate.

**Compilation flags:**

`dynamic`

**Mode and number of proofs:**

`explicit_tracing_` - `zero_or_one`

------------------------------------------------------------------------

###### `skipping_/0`

True iff skipping.

**Compilation flags:**

`dynamic`

**Mode and number of proofs:**

`skipping_` - `zero_or_one`

------------------------------------------------------------------------

###### `skipping_unleashed_/1`

True iff skipping (a goal with invocation number `N`) but showing intermediate ports as unleashed.

**Compilation flags:**

`dynamic`

**Template:**

`skipping_unleashed_(N)`

**Mode and number of proofs:**

`skipping_unleashed_(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `quasi_skipping_/0`

True iff quasi-skipping.

**Compilation flags:**

`dynamic`

**Mode and number of proofs:**

`quasi_skipping_` - `zero_or_one`

------------------------------------------------------------------------

###### `leaping_/1`

True iff leaping in tracing or debugging mode.

**Compilation flags:**

`dynamic`

**Template:**

`leaping_(Mode)`

**Mode and number of proofs:**

`leaping_(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `leashing_/1`

Table of currently leashed ports.

**Compilation flags:**

`dynamic`

**Template:**

`leashing_(Port)`

**Mode and number of proofs:**

`leashing_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `invocation_number_/1`

Current call stack invocation number.

**Compilation flags:**

`dynamic`

**Template:**

`invocation_number_(N)`

**Mode and number of proofs:**

`invocation_number_(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `jump_to_invocation_number_/1`

Invocation number to jump to.

**Compilation flags:**

`dynamic`

**Template:**

`jump_to_invocation_number_(N)`

**Mode and number of proofs:**

`jump_to_invocation_number_(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `zap_to_port_/1`

Port to zap to.

**Compilation flags:**

`dynamic`

**Template:**

`zap_to_port_(Port)`

**Mode and number of proofs:**

`zap_to_port_(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `write_max_depth_/1`

Current term write maximum depth.

**Compilation flags:**

`dynamic`

**Template:**

`write_max_depth_(MaxDepth)`

**Mode and number of proofs:**

`write_max_depth_(?non_negative_integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `log_point_/3`

Table of log points.

**Compilation flags:**

`dynamic`

**Template:**

`log_point_(Entity,Line,Message)`

**Mode and number of proofs:**

`log_point_(?object_identifier,?integer,?atom)` - `zero_or_more`

`log_point_(?category_identifier,?integer,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `clause_breakpoint_/2`

Table of clause breakpoints.

**Compilation flags:**

`dynamic`

**Template:**

`clause_breakpoint_(Entity,Line)`

**Mode and number of proofs:**

`clause_breakpoint_(?object_identifier,?integer)` - `zero_or_more`

`clause_breakpoint_(?category_identifier,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `predicate_breakpoint_/3`

Table of predicate breakpoints.

**Compilation flags:**

`dynamic`

**Template:**

`predicate_breakpoint_(Functor,Arity,Original)`

**Mode and number of proofs:**

`predicate_breakpoint_(?atom,?integer,?predicate_indicator)` - `zero_or_more`

`predicate_breakpoint_(?atom,?integer,?non_terminal_indicator)` - `zero_or_more`

------------------------------------------------------------------------

###### `entity_predicate_breakpoint_/4`

Table of entity predicate breakpoints.

**Compilation flags:**

`dynamic`

**Template:**

`entity_predicate_breakpoint_(Entity,Functor,Arity,Original)`

**Mode and number of proofs:**

`entity_predicate_breakpoint_(?callable,?atom,?integer,?qualified_predicate_indicator)` - `zero_or_more`

`entity_predicate_breakpoint_(?callable,?atom,?integer,?qualified_non_terminal_indicator)` - `zero_or_more`

------------------------------------------------------------------------

###### `context_breakpoint_/4`

Table of context breakpoints.

**Compilation flags:**

`dynamic`

**Template:**

`context_breakpoint_(Sender,This,Self,Goal)`

**Mode and number of proofs:**

`context_breakpoint_(?object_identifier,?object_identifier,?object_identifier,?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `conditional_breakpoint_/3`

Table of conditional breakpoints.

**Compilation flags:**

`dynamic`

**Template:**

`conditional_breakpoint_(Entity,Line,Condition)`

**Mode and number of proofs:**

`conditional_breakpoint_(?object_identifier,?integer,?callable)` - `zero_or_more`

`conditional_breakpoint_(?category_identifier,?integer,?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `triggered_breakpoint_/4`

Table of defined triggered breakpoints.

**Compilation flags:**

`dynamic`

**Template:**

`triggered_breakpoint_(Entity,Line,TriggerEntity,TriggerLine)`

**Mode and number of proofs:**

`triggered_breakpoint_(?object_identifier,?integer,?object_identifier,?integer)` - `zero_or_more`

`triggered_breakpoint_(?object_identifier,?integer,?category_identifier,?integer)` - `zero_or_more`

`triggered_breakpoint_(?category_identifier,?integer,?object_identifier,?integer)` - `zero_or_more`

`triggered_breakpoint_(?category_identifier,?integer,?category_identifier,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `triggered_breakpoint_enabled_/2`

Table of enabled triggered breakpoints.

**Compilation flags:**

`dynamic`

**Template:**

`triggered_breakpoint_enabled_(Entity,Line)`

**Mode and number of proofs:**

`triggered_breakpoint_enabled_(?object_identifier,?integer)` - `zero_or_more`

`triggered_breakpoint_enabled_(?category_identifier,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `file_line_hit_count_/3`

Table of file and line hit counts (successful unifications with clause heads).

**Compilation flags:**

`dynamic`

**Template:**

`file_line_hit_count_(File,Line,Count)`

**Mode and number of proofs:**

`file_line_hit_count_(?atom,?integer,?integer)` - `zero_or_one`

------------------------------------------------------------------------

##### Operators

(none)

**category**

#### `debugger_messages`

Logtalk `debugger` tool default message translations.

**Availability:**

`logtalk_load(debugger(loader))`

**Author:** Paulo Moura

**Version:** 4:0:0

**Date:** 2025-12-18

**Compilation flags:**

`static`

**Provides:**

logtalk::message_prefix_stream/4

logtalk::question_prompt_stream/4

logtalk::message_tokens//2

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `debuggerp`

Debugger protocol.

**Availability:**

`logtalk_load(debugger(loader))`

**Author:** Paulo Moura

**Version:** 3:6:0

**Date:** 2025-09-05

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

> - Debugger help: Type the character `h` (condensed help) or the character `?` (extended help) at a leashed port.
>
> - Predicate breakpoint: Specified as a ground term `Functor/Arity`.
>
> - Non-terminal breakpoint: Specified as a ground term `Functor//Arity`.
>
> - Entity predicate breakpoint: Specified as a term `Entity::Functor/Arity`. `Entity` must be an object or category and may not be ground if parametric.
>
> - Entity non-terminal breakpoint: Specified as a term `Entity::Functor//Arity`. `Entity` must be an object or category and may not be ground if parametric.
>
> - Clause breakpoint: Specified as an `Entity-Line` term with both `Entity` and `Line` bound. `Line` must be the first source file line of an entity clause.
>
> - Conditional breakpoint: Specified using `Entity` and `Line` for the clause head and a condition. `Line` must be the first source file line of an entity clause.
>
> - Hit count breakpoint: Specified using `Entity` and `Line` for the clause head and an unification count expression as a condition. `Line` must be the first source file line of an entity clause.
>
> - Triggered breakpoint: Specified using `Entity` and `Line` for the clause head and another breakpoint as a condition. `Line` must be the first source file line of an entity clause.
>
> - Context breakpoint: Specified as a `(Sender,`` ``This,`` ``Self,`` ``Goal)` tuple.
>
> - Log point: Specified using `Entity` and `Line` for the clause head and a message.
>
> - Leash port shorthands: `none` - `[]`, `loose` - `[fact,rule,call]`, `half` - `[fact,rule,call,redo]`, `tight` - `[fact,rule,call,redo,fail,exception]`, and `full` - `[fact,rule,call,exit,redo,fail,exception]`.

**Inherited public predicates:**

(none)

- Public predicates

  - `reset/0`

  - `debug/0`

  - `nodebug/0`

  - `debugging/0`

  - `debugging/1`

  - `trace/0`

  - `notrace/0`

  - `leash/1`

  - `leashing/1`

  - `spy/1`

  - `spying/1`

  - `nospy/1`

  - `spy/3`

  - `spying/3`

  - `nospy/3`

  - `spy/4`

  - `spying/4`

  - `nospy/4`

  - `nospyall/0`

  - `log/3`

  - `logging/3`

  - `nolog/3`

  - `nologall/0`

  - `write_max_depth/1`

  - `set_write_max_depth/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `reset/0`

Resets all debugging settings (including breakpoints, log points, and leashed ports) and turns off debugging.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`reset` - `one`

**See also:**

nospyall/0

------------------------------------------------------------------------

###### `debug/0`

Starts debugging for all defined breakpoints.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`debug` - `one`

------------------------------------------------------------------------

###### `nodebug/0`

Stops debugging for all defined breakpoints. Also turns off tracing. Does not remove defined breakpoints.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`nodebug` - `one`

**See also:**

reset/0

------------------------------------------------------------------------

###### `debugging/0`

Reports current debugging settings, including breakpoints and log points.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`debugging` - `one`

------------------------------------------------------------------------

###### `debugging/1`

Enumerates, by backtracking, all entities compiled in debug mode.

**Compilation flags:**

`static`

**Template:**

`debugging(Entity)`

**Mode and number of proofs:**

`debugging(?entity_identifier)` - `zero_or_more`

------------------------------------------------------------------------

###### `trace/0`

Starts tracing all calls compiled in debug mode.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`trace` - `one`

------------------------------------------------------------------------

###### `notrace/0`

Stops tracing of calls compiled in debug mode. Debugger will still stop at defined breakpoints.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`notrace` - `one`

------------------------------------------------------------------------

###### `leash/1`

Sets the debugger leash ports using an abbreviation (`none`, `loose`, `half`, `tight`, or `full`) or a list of ports (valid ports are `fact`, `rule`, `call`, `exit`, `redo`, `fail`, and `exception`).

**Compilation flags:**

`static`

**Template:**

`leash(Ports)`

**Mode and number of proofs:**

`leash(+atom)` - `one`

`leash(+list(atom))` - `one`

------------------------------------------------------------------------

###### `leashing/1`

Enumerates, by backtracking, all leashed ports (valid ports are `fact`, `rule`, `call`, `exit`, `redo`, `fail`, and `exception`).

**Compilation flags:**

`static`

**Template:**

`leashing(Port)`

**Mode and number of proofs:**

`leashing(?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `spy/1`

Sets a predicate or clause breakpoint (removing any existing log point or breakpoint defined for the same location, or a list of breakpoints. Fails if a breakpoint is invalid.

**Compilation flags:**

`static`

**Template:**

`spy(Breakpoint)`

**Mode and number of proofs:**

`spy(@spy_point)` - `zero_or_one`

`spy(@list(spy_point))` - `zero_or_one`

------------------------------------------------------------------------

###### `spying/1`

Enumerates, by backtracking, all defined predicate and clause breakpoints.

**Compilation flags:**

`static`

**Template:**

`spying(Breakpoint)`

**Mode and number of proofs:**

`spying(?spy_point)` - `zero_or_more`

------------------------------------------------------------------------

###### `nospy/1`

Removes all matching predicate and clause breakpoints.

**Compilation flags:**

`static`

**Template:**

`nospy(Breakpoint)`

**Mode and number of proofs:**

`nospy(@var)` - `one`

`nospy(@spy_point)` - `one`

`nospy(@list(spy_point))` - `one`

------------------------------------------------------------------------

###### `spy/3`

Sets a conditional or triggered breakpoint (removing any existing log point or breakpoint defined for the same location) at a clause head. The condition can be a unification count expression, a lambda expression, or another breakpoint. Fails if the breakpoint is invalid.

**Compilation flags:**

`static`

**Template:**

`spy(Entity,Line,Condition)`

**Mode and number of proofs:**

`spy(+atom,+integer,@callable)` - `zero_or_one`

**Remarks:**

> - Unification count expression conditions: `>(Count)`, `>=(Count)`, `=:=(Count)`, `=<(Count)`, `<(Count)`, `mod(M)`, and `Count`.
>
> - Lambda expression conditions: `[Count,N,Goal]>>Condition` and `[Goal]>>Condition` where `Count` is the unification count, `N` is the invocation number, and `Goal` is the goal that unified with the clause head; `Condition` is called in the context of `user`.
>
> - Triggered breakpoint conditions: `Entity-Line`.

------------------------------------------------------------------------

###### `spying/3`

Enumerates, by backtracking, all conditional and triggered breakpoints.

**Compilation flags:**

`static`

**Template:**

`spying(Entity,Line,Condition)`

**Mode and number of proofs:**

`spying(?atom,?integer,?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `nospy/3`

Removes all matching conditional and triggered breakpoints.

**Compilation flags:**

`static`

**Template:**

`nospy(Entity,Line,Condition)`

**Mode and number of proofs:**

`nospy(@term,@term,@term)` - `one`

------------------------------------------------------------------------

###### `spy/4`

Sets a context breakpoint.

**Compilation flags:**

`static`

**Template:**

`spy(Sender,This,Self,Goal)`

**Mode and number of proofs:**

`spy(@term,@term,@term,@term)` - `one`

------------------------------------------------------------------------

###### `spying/4`

Enumerates, by backtracking, all defined context breakpoints.

**Compilation flags:**

`static`

**Template:**

`spying(Sender,This,Self,Goal)`

**Mode and number of proofs:**

`spying(?term,?term,?term,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `nospy/4`

Removes all matching context breakpoints.

**Compilation flags:**

`static`

**Template:**

`nospy(Sender,This,Self,Goal)`

**Mode and number of proofs:**

`nospy(@term,@term,@term,@term)` - `one`

------------------------------------------------------------------------

###### `nospyall/0`

Removes all breakpoints and log points.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`nospyall` - `one`

**See also:**

reset/0

------------------------------------------------------------------------

###### `log/3`

Sets a log point (removing any existing breakpoint defined for the same location) at a clause head. Fails if the log point is invalid.

**Compilation flags:**

`static`

**Template:**

`log(Entity,Line,Message)`

**Mode and number of proofs:**

`log(@object_identifier,+integer,+atom)` - `zero_or_one`

`log(@category_identifier,+integer,+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `logging/3`

Enumerates, by backtracking, all defined log points.

**Compilation flags:**

`static`

**Template:**

`logging(Entity,Line,Message)`

**Mode and number of proofs:**

`logging(?object_identifier,?integer,?atom)` - `zero_or_more`

`logging(?category_identifier,?integer,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `nolog/3`

Removes all matching log points.

**Compilation flags:**

`static`

**Template:**

`nolog(Entity,Line,Message)`

**Mode and number of proofs:**

`nolog(@var_or(object_identifier),@var_or(integer),@var_or(atom))` - `one`

`nolog(@var_or(category_identifier),@var_or(integer),@var_or(atom))` - `one`

------------------------------------------------------------------------

###### `nologall/0`

Removes all log points.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`nologall` - `one`

**See also:**

reset/0

------------------------------------------------------------------------

###### `write_max_depth/1`

Current term write maximum depth. When not defined, the backend default is used.

**Compilation flags:**

`static`

**Template:**

`write_max_depth(MaxDepth)`

**Mode and number of proofs:**

`write_max_depth(?non_negative_integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `set_write_max_depth/1`

Sets the default term maximum write depth. For most backends, a value of zero means that the whole term is written.

**Compilation flags:**

`static`

**Template:**

`set_write_max_depth(MaxDepth)`

**Mode and number of proofs:**

`set_write_max_depth(+non_negative_integer)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

debugger

**object**

#### `dump_trace`

Simple solution for redirecting a debugger trace to a file.

**Availability:**

`logtalk_load(debugger(loader))`

**Author:** Paulo Moura

**Version:** 1:0:1

**Date:** 2021-11-12

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

debugger

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `start_redirect_to_file/2`

  - `stop_redirect_to_file/0`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `start_redirect_to_file/2`

Starts redirecting debugger trace messages to a file.

**Compilation flags:**

`static`

**Template:**

`start_redirect_to_file(File,Goal)`

**Meta-predicate template:**

`start_redirect_to_file(*,0)`

**Mode and number of proofs:**

`start_redirect_to_file(+atom,+callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `stop_redirect_to_file/0`

Stops redirecting debugger trace messages to a file.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`stop_redirect_to_file` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### dependents")

**category**

#### `observer`

Smalltalk dependent protocol.

**Availability:**

`logtalk_load(dependents(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2003-02-09

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `update/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `update/1`

Called when an observed object is updated.

**Compilation flags:**

`static`

**Template:**

`update(Change)`

**Mode and number of proofs:**

`update(?nonvar)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

subject

**category**

#### `subject`

Smalltalk dependent handling predicates.

**Availability:**

`logtalk_load(dependents(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2003-02-09

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `changed/0`

  - `changed/1`

  - `dependents/1`

  - `addDependent/1`

  - `removeDependent/1`

- Protected predicates

- Private predicates

  - `dependent_/1`

- Operators

##### Public predicates

###### `changed/0`

Receiver changed in some way. Notify all dependents.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`changed` - `one`

------------------------------------------------------------------------

###### `changed/1`

Receiver changed as specified in the argument. Notify all dependents.

**Compilation flags:**

`static`

**Template:**

`changed(Change)`

**Mode and number of proofs:**

`changed(?nonvar)` - `one`

------------------------------------------------------------------------

###### `dependents/1`

Returns a list of all dependent objects.

**Compilation flags:**

`static`

**Template:**

`dependents(Dependents)`

**Mode and number of proofs:**

`dependents(-list)` - `one`

------------------------------------------------------------------------

###### `addDependent/1`

Adds a new dependent object.

**Compilation flags:**

`static`

**Template:**

`addDependent(Dependent)`

**Mode and number of proofs:**

`addDependent(@object)` - `one`

------------------------------------------------------------------------

###### `removeDependent/1`

Removes a dependent object.

**Compilation flags:**

`static`

**Template:**

`removeDependent(Dependent)`

**Mode and number of proofs:**

`removeDependent(?object)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

###### `dependent_/1`

Table of dependent objects.

**Compilation flags:**

`dynamic`

**Template:**

`dependent_(Dependent)`

**Mode and number of proofs:**

`dependent_(?object)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

observer

### deques")

**object**

#### `deque`

Double-ended queue (deque) implementation using difference lists to provide O(1) operations at both ends.

**Availability:**

`logtalk_load(deques(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-09

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` deque_protocol

**Extends:**

`public` compound

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_deque/2  as_list/2  check/1  depth/2  empty/1  ground/1  length/2  map/2  map/3  new/1  numbervars/1  numbervars/3  occurs/2  peek_back/2  peek_front/2  pop_back/3  pop_front/3  push_back/3  push_front/3  singletons/2  subsumes/2  subterm/2  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `deque_protocol`

Extracted protocol entity

**Availability:**

`logtalk_load(deques(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-08

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `empty/1`

  - `push_front/3`

  - `push_back/3`

  - `pop_front/3`

  - `pop_back/3`

  - `peek_front/2`

  - `peek_back/2`

  - `length/2`

  - `map/2`

  - `map/3`

  - `as_list/2`

  - `as_deque/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `empty/1`

True iff the deque is empty.

**Compilation flags:**

`static`

**Template:**

`empty(Deque)`

**Mode and number of proofs:**

`empty(+deque)` - `zero_or_one`

------------------------------------------------------------------------

###### `push_front/3`

Adds an element to the front of the deque.

**Compilation flags:**

`static`

**Template:**

`push_front(Element,DequeIn,DequeOut)`

**Mode and number of proofs:**

`push_front(+term,+deque,-deque)` - `one`

------------------------------------------------------------------------

###### `push_back/3`

Adds an element to the back of the deque.

**Compilation flags:**

`static`

**Template:**

`push_back(Element,DequeIn,DequeOut)`

**Mode and number of proofs:**

`push_back(+term,+deque,-deque)` - `one`

------------------------------------------------------------------------

###### `pop_front/3`

Removes and returns the front element.

**Compilation flags:**

`static`

**Template:**

`pop_front(DequeIn,Element,DequeOut)`

**Mode and number of proofs:**

`pop_front(+deque,-term,-deque)` - `zero_or_one`

------------------------------------------------------------------------

###### `pop_back/3`

Removes and returns the back element.

**Compilation flags:**

`static`

**Template:**

`pop_back(DequeIn,Element,DequeOut)`

**Mode and number of proofs:**

`pop_back(+deque,-term,-deque)` - `zero_or_one`

------------------------------------------------------------------------

###### `peek_front/2`

Returns the front element without removing it.

**Compilation flags:**

`static`

**Template:**

`peek_front(Deque,Element)`

**Mode and number of proofs:**

`peek_front(+deque,-term)` - `zero_or_one`

------------------------------------------------------------------------

###### `peek_back/2`

Returns the back element without removing it.

**Compilation flags:**

`static`

**Template:**

`peek_back(Deque,Element)`

**Mode and number of proofs:**

`peek_back(+deque,-term)` - `zero_or_one`

------------------------------------------------------------------------

###### `length/2`

Returns the number of elements in the deque.

**Compilation flags:**

`static`

**Template:**

`length(Deque,Length)`

**Mode and number of proofs:**

`length(+deque,-integer)` - `one`

------------------------------------------------------------------------

###### `map/2`

Applies a closure to all elements of a deque.

**Compilation flags:**

`static`

**Template:**

`map(Closure,Deque)`

**Meta-predicate template:**

`map(1,*)`

**Mode and number of proofs:**

`map(+callable,+deque)` - `zero_or_one`

------------------------------------------------------------------------

###### `map/3`

Applies a closure to all elements of a deque constructing a new deque.

**Compilation flags:**

`static`

**Template:**

`map(Closure,Deque,NewQueue)`

**Meta-predicate template:**

`map(2,*,*)`

**Mode and number of proofs:**

`map(+callable,+deque,?deque)` - `zero_or_one`

------------------------------------------------------------------------

###### `as_list/2`

Converts a deque to a list.

**Compilation flags:**

`static`

**Template:**

`as_list(Deque,List)`

**Mode and number of proofs:**

`as_list(+deque,-list)` - `one`

------------------------------------------------------------------------

###### `as_deque/2`

Converts a list to a deque.

**Compilation flags:**

`static`

**Template:**

`as_deque(List,Deque)`

**Mode and number of proofs:**

`as_deque(+list,-deque)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### diagrams")

**object**

#### `d2_graph_language`

Predicates for generating graph files in the DOT language (version 2.36.0 or later).

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 1:3:0

**Date:** 2025-10-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` graph_language_protocol

**Imports:**

`public` options

**Provides:**

graph_language_registry::language_object/2

**Uses:**

list

os

term_io

user

**Remarks:**

(none)

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  edge/6  file_footer/3  file_header/3  graph_footer/5  graph_header/5  node/7  option/2  option/3  output_file_name/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `diagram(Format)`

- `Format` - Graph language file format.

Common predicates for generating diagrams.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 3:16:1

**Date:** 2025-11-26

**Compilation flags:**

`static`

**Extends:**

`public` options

**Provides:**

logtalk::message_prefix_stream/4

logtalk::message_tokens//2

**Uses:**

graph_language_registry

list

logtalk

modules_diagram_support

os

pairs

type

user

**Remarks:**

(none)

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  option/2  option/3  valid_option/1  valid_options/1

- Public predicates

  - `libraries/3`

  - `libraries/2`

  - `libraries/1`

  - `all_libraries/1`

  - `all_libraries/0`

  - `rlibrary/2`

  - `rlibrary/1`

  - `library/2`

  - `library/1`

  - `directories/3`

  - `directories/2`

  - `rdirectory/3`

  - `rdirectory/2`

  - `rdirectory/1`

  - `directory/3`

  - `directory/2`

  - `directory/1`

  - `files/3`

  - `files/2`

  - `files/1`

  - `all_files/1`

  - `all_files/0`

  - `format_object/1`

  - `diagram_description/1`

  - `diagram_name_suffix/1`

- Protected predicates

  - `diagram_caption/3`

  - `output_rlibrary/3`

  - `output_library/3`

  - `output_rdirectory/3`

  - `output_externals/1`

  - `output_files/2`

  - `output_file/4`

  - `output_sub_diagrams/1`

  - `reset/0`

  - `output_node/6`

  - `node/6`

  - `edge/5`

  - `output_edges/1`

  - `save_edge/5`

  - `output_missing_externals/1`

  - `not_excluded_file/4`

  - `output_file_path/4`

  - `locate_library/2`

  - `locate_directory/2`

  - `locate_file/5`

  - `ground_entity_identifier/3`

  - `filter_file_extension/3`

  - `filter_external_file_extension/3`

  - `add_link_options/3`

  - `supported_editor_url_scheme_prefix/1`

  - `omit_path_prefix/3`

  - `add_node_zoom_option/4`

  - `message_diagram_description/1`

- Private predicates

  - `node_/6`

  - `node_path_/2`

  - `edge_/5`

- Operators

##### Public predicates

###### `libraries/3`

Creates a diagram for a set of libraries using the specified options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`libraries(Project,Libraries,Options)`

**Mode and number of proofs:**

`libraries(+atom,+list(atom),+list(compound))` - `one`

------------------------------------------------------------------------

###### `libraries/2`

Creates a diagram for a set of libraries using the default options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`libraries(Project,Libraries)`

**Mode and number of proofs:**

`libraries(+atom,+list(atom))` - `one`

------------------------------------------------------------------------

###### `libraries/1`

Creates a diagram for a set of libraries using the default options. The prefix `libraries` is used for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`libraries(Libraries)`

**Mode and number of proofs:**

`libraries(+list(atom))` - `one`

------------------------------------------------------------------------

###### `all_libraries/1`

Creates a diagram for all loaded libraries using the specified options.

**Compilation flags:**

`static`

**Template:**

`all_libraries(Options)`

**Mode and number of proofs:**

`all_libraries(+list(compound))` - `one`

------------------------------------------------------------------------

###### `all_libraries/0`

Creates a diagram for all loaded libraries using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`all_libraries` - `one`

------------------------------------------------------------------------

###### `rlibrary/2`

Creates a diagram for a library and its sub-libraries using the specified options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library,Options)`

**Mode and number of proofs:**

`rlibrary(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `rlibrary/1`

Creates a diagram for a library and its sub-libraries using default options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library)`

**Mode and number of proofs:**

`rlibrary(+atom)` - `one`

------------------------------------------------------------------------

###### `library/2`

Creates a diagram for a library using the specified options.

**Compilation flags:**

`static`

**Template:**

`library(Library,Options)`

**Mode and number of proofs:**

`library(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `library/1`

Creates a diagram for a library using default options.

**Compilation flags:**

`static`

**Template:**

`library(Library)`

**Mode and number of proofs:**

`library(+atom)` - `one`

------------------------------------------------------------------------

###### `directories/3`

Creates a diagram for a set of directories using the specified options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`directories(Project,Directories,Options)`

**Mode and number of proofs:**

`directories(+atom,+list(atom),+list(compound))` - `one`

------------------------------------------------------------------------

###### `directories/2`

Creates a diagram for a set of directories using the default options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`directories(Project,Directories)`

**Mode and number of proofs:**

`directories(+atom,+list(atom))` - `one`

------------------------------------------------------------------------

###### `rdirectory/3`

Creates a diagram for a directory and its sub-directories using the specified options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Project,Directory,Options)`

**Mode and number of proofs:**

`rdirectory(+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `rdirectory/2`

Creates a diagram for a directory and its sub-directories using default options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Project,Directory)`

**Mode and number of proofs:**

`rdirectory(+atom,+atom)` - `one`

------------------------------------------------------------------------

###### `rdirectory/1`

Creates a diagram for a directory and its sub-directories using default options. The name of the directory is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Directory)`

**Mode and number of proofs:**

`rdirectory(+atom)` - `one`

------------------------------------------------------------------------

###### `directory/3`

Creates a diagram for a directory using the specified options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`directory(Project,Directory,Options)`

**Mode and number of proofs:**

`directory(+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `directory/2`

Creates a diagram for a directory using default options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`directory(Project,Directory)`

**Mode and number of proofs:**

`directory(+atom,+atom)` - `one`

------------------------------------------------------------------------

###### `directory/1`

Creates a diagram for a directory using default options. The name of the directory is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`directory(Directory)`

**Mode and number of proofs:**

`directory(+atom)` - `one`

------------------------------------------------------------------------

###### `files/3`

Creates a diagram for a set of files using the specified options. The file can be specified by name, basename, full path, or using library notation. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`files(Project,Files,Options)`

**Mode and number of proofs:**

`files(+atom,+list(atom),+list(compound))` - `one`

------------------------------------------------------------------------

###### `files/2`

Creates a diagram for a set of files using the default options. The file can be specified by name, basename, full path, or using library notation. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`files(Project,Files)`

**Mode and number of proofs:**

`files(+atom,+list(atom))` - `one`

------------------------------------------------------------------------

###### `files/1`

Creates a diagram for a set of files using the default options. The file can be specified by name, basename, full path, or using library notation. The prefix `files` is used for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`files(Files)`

**Mode and number of proofs:**

`files(+list(atom))` - `one`

------------------------------------------------------------------------

###### `all_files/1`

Creates a diagram for all loaded files using the specified options.

**Compilation flags:**

`static`

**Template:**

`all_files(Options)`

**Mode and number of proofs:**

`all_files(+list(compound))` - `one`

------------------------------------------------------------------------

###### `all_files/0`

Creates a diagram for all loaded files using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`all_files` - `one`

------------------------------------------------------------------------

###### `format_object/1`

Returns the identifier of the object implementing the graph language currently being used. Fails if none is specified.

**Compilation flags:**

`static`

**Template:**

`format_object(Object)`

**Mode and number of proofs:**

`format_object(-object_identifier)` - `zero_or_one`

------------------------------------------------------------------------

###### `diagram_description/1`

Returns the diagram description.

**Compilation flags:**

`static`

**Template:**

`diagram_description(Description)`

**Mode and number of proofs:**

`diagram_description(-atom)` - `one`

------------------------------------------------------------------------

###### `diagram_name_suffix/1`

Returns the diagram name suffix.

**Compilation flags:**

`static`

**Template:**

`diagram_name_suffix(Suffix)`

**Mode and number of proofs:**

`diagram_name_suffix(-atom)` - `one`

------------------------------------------------------------------------

##### Protected predicates

###### `diagram_caption/3`

Creates a diagram caption from the diagram description and the subject and its kind.

**Compilation flags:**

`static`

**Template:**

`diagram_caption(Kind,Subject,Description)`

**Mode and number of proofs:**

`diagram_caption(+atom,+callable,-atom)` - `one`

------------------------------------------------------------------------

###### `output_rlibrary/3`

Generates diagram output for a library and its sub-libraries using the specified options.

**Compilation flags:**

`static`

**Template:**

`output_rlibrary(Library,Path,Options)`

**Mode and number of proofs:**

`output_rlibrary(+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `output_library/3`

Generates diagram output for a library using the specified options.

**Compilation flags:**

`static`

**Template:**

`output_library(Library,Path,Options)`

**Mode and number of proofs:**

`output_library(+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `output_rdirectory/3`

Generates diagram output for a directory and its sub-directories using the specified options.

**Compilation flags:**

`static`

**Template:**

`output_rdirectory(Project,Path,Options)`

**Mode and number of proofs:**

`output_rdirectory(+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `output_externals/1`

Output external nodes using the specified options depending on the value of the boolean option `externals/1`.

**Compilation flags:**

`static`

**Template:**

`output_externals(Options)`

**Mode and number of proofs:**

`output_externals(+list(compound))` - `one`

------------------------------------------------------------------------

###### `output_files/2`

Generates diagram output for a list of files using the specified options.

**Compilation flags:**

`static`

**Template:**

`output_files(Files,Options)`

**Mode and number of proofs:**

`output_files(+list,+list(compound))` - `one`

------------------------------------------------------------------------

###### `output_file/4`

Generates diagram output for a file using the specified options.

**Compilation flags:**

`static`

**Template:**

`output_file(Path,Basename,Directory,Options)`

**Mode and number of proofs:**

`output_file(+atom,+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `output_sub_diagrams/1`

Outputs sub-diagrams using the specified options.

**Compilation flags:**

`static`

**Template:**

`output_sub_diagrams(Options)`

**Mode and number of proofs:**

`output_sub_diagrams(+list(compound))` - `one`

------------------------------------------------------------------------

###### `reset/0`

Resets all temporary information used when generating a diagram.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`reset` - `one`

------------------------------------------------------------------------

###### `output_node/6`

Outputs a graph node.

**Compilation flags:**

`static`

**Template:**

`output_node(Identifier,Label,Caption,Contents,Kind,Options)`

**Mode and number of proofs:**

`output_node(+nonvar,+nonvar,+nonvar,+list(nonvar),+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `node/6`

Enumerates, by backtracking, all saved nodes.

**Compilation flags:**

`static`

**Template:**

`node(Identifier,Label,Caption,Contents,Kind,Options)`

**Mode and number of proofs:**

`node(?nonvar,?nonvar,?nonvar,?list(compound),?atom,?list(compound))` - `zero_or_more`

------------------------------------------------------------------------

###### `edge/5`

Enumerates, by backtracking, all saved edges.

**Compilation flags:**

`static`

**Template:**

`edge(From,To,Labels,Kind,Options)`

**Mode and number of proofs:**

`edge(?nonvar,?nonvar,?list(nonvar),?atom,?list(compound))` - `zero_or_more`

------------------------------------------------------------------------

###### `output_edges/1`

Outputs all edges.

**Compilation flags:**

`static`

**Template:**

`output_edges(Options)`

**Mode and number of proofs:**

`output_edges(+list(compound))` - `one`

------------------------------------------------------------------------

###### `save_edge/5`

Saves a graph edge.

**Compilation flags:**

`static`

**Template:**

`save_edge(From,To,Labels,Kind,Options)`

**Mode and number of proofs:**

`save_edge(+nonvar,+nonvar,+list(nonvar),+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `output_missing_externals/1`

Outputs missing external nodes (usually due to unloaded resources) that are referenced from edges.

**Compilation flags:**

`static`

**Template:**

`output_missing_externals(Options)`

**Mode and number of proofs:**

`output_missing_externals(+list(compound))` - `one`

------------------------------------------------------------------------

###### `not_excluded_file/4`

True when the given file is not excluded from the generated output. Excluded files may be specified by full path or by basename and with or without extension. Excluded directories may be listed by full or relative path.

**Compilation flags:**

`static`

**Template:**

`not_excluded_file(Path,Basename,ExcludedDirectories,ExcludedFiles)`

**Mode and number of proofs:**

`not_excluded_file(+atom,+atom,+list(atom),+list(atom))` - `zero_or_one`

------------------------------------------------------------------------

###### `output_file_path/4`

Returns the output file path.

**Compilation flags:**

`static`

**Template:**

`output_file_path(Name,Options,Format,Path)`

**Mode and number of proofs:**

`output_file_path(+atom,+list(atom),+object_identifier,-atom)` - `one`

------------------------------------------------------------------------

###### `locate_library/2`

Locates a library given its name.

**Compilation flags:**

`static`

**Template:**

`locate_library(Library,Path)`

**Mode and number of proofs:**

`locate_library(+atom,-atom)` - `one`

------------------------------------------------------------------------

###### `locate_directory/2`

Locates a directory given its name or full path.

**Compilation flags:**

`static`

**Template:**

`locate_directory(Directory,Path)`

**Mode and number of proofs:**

`locate_directory(+atom,-atom)` - `one`

------------------------------------------------------------------------

###### `locate_file/5`

Locates a file given its name, basename, full path, or library notation representation.

**Compilation flags:**

`static`

**Template:**

`locate_file(File,Basename,Extension,Directory,Path)`

**Mode and number of proofs:**

`locate_file(+atom,+atom,+atom,+atom,-atom)` - `one`

------------------------------------------------------------------------

###### `ground_entity_identifier/3`

Converts an entity identifier to a ground term.

**Compilation flags:**

`static`

**Template:**

`ground_entity_identifier(Kind,Identifier,GroundIdentifier)`

**Mode and number of proofs:**

`ground_entity_identifier(+atom,+callable,-callable)` - `one`

------------------------------------------------------------------------

###### `filter_file_extension/3`

Filters the file name extension depending on the `file_extensions/1` option.

**Compilation flags:**

`static`

**Template:**

`filter_file_extension(Basename,Options,Name)`

**Mode and number of proofs:**

`filter_file_extension(+atom,+list(compound),-atom)` - `one`

------------------------------------------------------------------------

###### `filter_external_file_extension/3`

Filters the external file name extension depending on the `file_extensions/1` option.

**Compilation flags:**

`static`

**Template:**

`filter_external_file_extension(Path,Options,Name)`

**Mode and number of proofs:**

`filter_external_file_extension(+atom,+list(compound),-atom)` - `one`

------------------------------------------------------------------------

###### `add_link_options/3`

Adds `url/1`, `urls/2`, and `tooltip/1` link options (for use by the graph language) based on the specified path to the list of options.

**Compilation flags:**

`static`

**Template:**

`add_link_options(Path,Options,LinkingOptions)`

**Mode and number of proofs:**

`add_link_options(+atom,+list(compound),-list(compound))` - `one`

------------------------------------------------------------------------

###### `supported_editor_url_scheme_prefix/1`

Table of prefixes for text editors that supports a URL scheme to open diagram links.

**Compilation flags:**

`static`

**Template:**

`supported_editor_url_scheme_prefix(Prefix)`

**Mode and number of proofs:**

`supported_editor_url_scheme_prefix(?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `omit_path_prefix/3`

Removes a prefix from a path, returning the relative path, when using the option `omit_path_prefixes/1`. Used mainly for constructing directory and file node identifiers and captions.

**Compilation flags:**

`static`

**Template:**

`omit_path_prefix(Path,Options,Relative)`

**Mode and number of proofs:**

`omit_path_prefix(+atom,+list(compound),-atom)` - `one`

------------------------------------------------------------------------

###### `add_node_zoom_option/4`

Adds node zoom options when using the zoom option.

**Compilation flags:**

`static`

**Template:**

`add_node_zoom_option(Identifier,Suffix,Options,NodeOptions)`

**Mode and number of proofs:**

`add_node_zoom_option(+atom,+atom,+list(compound),-list(compound))` - `one`

------------------------------------------------------------------------

###### `message_diagram_description/1`

Diagram description for progress messages.

**Compilation flags:**

`static`

**Template:**

`message_diagram_description(Description)`

**Mode and number of proofs:**

`message_diagram_description(?atom)` - `one`

------------------------------------------------------------------------

##### Private predicates

###### `node_/6`

Table of saved nodes.

**Compilation flags:**

`dynamic`

**Template:**

`node_(Identifier,Label,Caption,Contents,Kind,Options)`

**Mode and number of proofs:**

`node_(?nonvar,?nonvar,?nonvar,?list(compound),?atom,?list(compound))` - `zero_or_more`

------------------------------------------------------------------------

###### `node_path_/2`

Table of node paths.

**Compilation flags:**

`dynamic`

**Template:**

`node_path_(Node,Path)`

**Mode and number of proofs:**

`node_path_(?ground,?list(ground))` - `zero_or_more`

------------------------------------------------------------------------

###### `edge_/5`

Table of saved edges.

**Compilation flags:**

`dynamic`

**Template:**

`edge_(From,To,Labels,Kind,Options)`

**Mode and number of proofs:**

`edge_(?nonvar,?nonvar,?list(nonvar),?atom,?list(compound))` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `diagrams`

Predicates for generating all supported diagrams for libraries, directories, and files in one step using the DOT format.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:1:0

**Date:** 2019-04-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` diagrams(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  libraries/1  libraries/2  libraries/3  library/1  library/2  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `diagrams(Format)`

- `Format` - Graph language file format.

Predicates for generating all supported diagrams for libraries, directories, or files in one step using the specified format.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:8:0

**Date:** 2019-06-13

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

list

os

**Remarks:**

> - Common options: `title/1`, `date/1`, `output_directory/1`, `relation_labels/1`, `node_type_captions/1`, `exclude_files/1`, `exclude_libraries/1`, `url_prefixes/1`, `omit_path_prefix/1`, `entity_url_suffix_target/2`, and `layout/1`.
>
> - Limitations: Some of the provided predicates only make sense for some types of diagrams. Also, fine tuning may require generating individual diagrams directly instead of as a batch using this utility object.

**Inherited public predicates:**

(none)

- Public predicates

  - `libraries/3`

  - `libraries/2`

  - `libraries/1`

  - `all_libraries/1`

  - `all_libraries/0`

  - `rlibrary/2`

  - `rlibrary/1`

  - `library/2`

  - `library/1`

  - `directories/3`

  - `directories/2`

  - `rdirectory/3`

  - `rdirectory/2`

  - `rdirectory/1`

  - `directory/3`

  - `directory/2`

  - `directory/1`

  - `files/3`

  - `files/2`

  - `files/1`

  - `all_files/1`

  - `all_files/0`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `libraries/3`

Creates all supported diagrams for a set of libraries using the specified options. The `Project` argument is used as a prefix for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`libraries(Project,Libraries,Options)`

**Mode and number of proofs:**

`libraries(+atom,+list(atom),+list(compound))` - `one`

------------------------------------------------------------------------

###### `libraries/2`

Creates all supported diagrams for a set of libraries using the default options. The `Project` argument is used as a prefix for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`libraries(Project,Libraries)`

**Mode and number of proofs:**

`libraries(+atom,+list(atom))` - `one`

------------------------------------------------------------------------

###### `libraries/1`

Creates all supported diagrams for a set of libraries using the default options. The prefix `libraries` is used for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`libraries(Libraries)`

**Mode and number of proofs:**

`libraries(+list(atom))` - `one`

------------------------------------------------------------------------

###### `all_libraries/1`

Creates all supported diagrams for all loaded libraries using the specified options.

**Compilation flags:**

`static`

**Template:**

`all_libraries(Options)`

**Mode and number of proofs:**

`all_libraries(+list(compound))` - `one`

------------------------------------------------------------------------

###### `all_libraries/0`

Creates all supported diagrams for all loaded libraries using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`all_libraries` - `one`

------------------------------------------------------------------------

###### `rlibrary/2`

Creates all supported diagrams for a library and its sub-libraries using the specified options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library,Options)`

**Mode and number of proofs:**

`rlibrary(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `rlibrary/1`

Creates all supported diagrams for a library and its sub-libraries using default options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library)`

**Mode and number of proofs:**

`rlibrary(+atom)` - `one`

------------------------------------------------------------------------

###### `library/2`

Creates all supported diagrams for a library using the specified options.

**Compilation flags:**

`static`

**Template:**

`library(Library,Options)`

**Mode and number of proofs:**

`library(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `library/1`

Creates all supported diagrams for a library using default options.

**Compilation flags:**

`static`

**Template:**

`library(Library)`

**Mode and number of proofs:**

`library(+atom)` - `one`

------------------------------------------------------------------------

###### `directories/3`

Creates all supported diagrams for a set of directories using the specified options. The `Project` argument is used as a prefix for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`directories(Project,Directories,Options)`

**Mode and number of proofs:**

`directories(+atom,+list(atom),+list(compound))` - `one`

------------------------------------------------------------------------

###### `directories/2`

Creates all supported diagrams for a directory using default options. The `Project` argument is used as a prefix for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`directories(Project,Directories)`

**Mode and number of proofs:**

`directories(+atom,+list(atom))` - `one`

------------------------------------------------------------------------

###### `rdirectory/3`

Creates all supported diagrams for a directory and its sub-directories using the specified options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Project,Directory,Options)`

**Mode and number of proofs:**

`rdirectory(+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `rdirectory/2`

Creates all supported diagrams for a directory and its sub-directories using default options. The `Project` argument is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Project,Directory)`

**Mode and number of proofs:**

`rdirectory(+atom,+atom)` - `one`

------------------------------------------------------------------------

###### `rdirectory/1`

Creates all supported diagrams for a directory and its sub-directories using default options. The name of the directory is used as a prefix for the diagram file name.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Directory)`

**Mode and number of proofs:**

`rdirectory(+atom)` - `one`

------------------------------------------------------------------------

###### `directory/3`

Creates all supported diagrams for a directory using the specified options. The `Project` argument is used as a prefix for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`directory(Project,Directory,Options)`

**Mode and number of proofs:**

`directory(+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `directory/2`

Creates all supported diagrams for a directory using default options. The `Project` argument is used as a prefix for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`directory(Project,Directory)`

**Mode and number of proofs:**

`directory(+atom,+atom)` - `one`

------------------------------------------------------------------------

###### `directory/1`

Creates all supported diagrams for a directory using default options. The name of the directory is used as a prefix for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`directory(Directory)`

**Mode and number of proofs:**

`directory(+atom)` - `one`

------------------------------------------------------------------------

###### `files/3`

Creates all supported diagrams for a set of files using the specified options. The file can be specified by name, basename, full path, or using library notation. The Project argument is used as a prefix for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`files(Project,Files,Options)`

**Mode and number of proofs:**

`files(+atom,+list(atom),+list(compound))` - `one`

------------------------------------------------------------------------

###### `files/2`

Creates all supported diagrams for a set of files using the default options. The file can be specified by name, basename, full path, or using library notation. The Project argument is used as a prefix for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`files(Project,Files)`

**Mode and number of proofs:**

`files(+atom,+list(atom))` - `one`

------------------------------------------------------------------------

###### `files/1`

Creates all supported diagrams for a set of files using the default options. The file can be specified by name, basename, full path, or using library notation. The prefix “files” is used for the diagram file names.

**Compilation flags:**

`static`

**Template:**

`files(Files)`

**Mode and number of proofs:**

`files(+list(atom))` - `one`

------------------------------------------------------------------------

###### `all_files/1`

Creates all supported diagrams for all loaded files using the specified options.

**Compilation flags:**

`static`

**Template:**

`all_files(Options)`

**Mode and number of proofs:**

`all_files(+list(compound))` - `one`

------------------------------------------------------------------------

###### `all_files/0`

Creates all supported diagrams for all loaded files using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`all_files` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `directory_dependency_diagram`

Predicates for generating directory dependency diagrams in DOT format.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2019-04-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` directory_dependency_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

directory_load_diagram, file_load_diagram

**object**

#### `directory_dependency_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating directory dependency diagrams. A dependency exists when an entity in one directory makes a reference to an entity in another directory.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 3:1:0

**Date:** 2025-12-03

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` directory_diagram(Format)

**Uses:**

file_dependency_diagram(Format)

list

logtalk

modules_diagram_support

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

  - `sub_diagram_/2`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `sub_diagram_/2`

Table of directory sub-diagrams to support their generation.

**Compilation flags:**

`dynamic`

**Template:**

`sub_diagram_(Project,Directory)`

**Mode and number of proofs:**

`sub_diagram_(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

directory_load_diagram(Format), file_load_diagram(Format), library_load_diagram(Format)

**category**

#### `directory_diagram(Format)`

- `Format` - Graph language file format.

Common predicates for generating directory diagrams.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 1:13:0

**Date:** 2024-12-04

**Compilation flags:**

`static`

**Extends:**

`public` diagram(Format)

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

  - `remember_included_directory/1`

  - `remember_referenced_logtalk_directory/1`

  - `remember_referenced_prolog_directory/1`

- Private predicates

  - `included_directory_/1`

  - `referenced_logtalk_directory_/1`

  - `referenced_prolog_directory_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

###### `remember_included_directory/1`

Remember included Logtalk directory in the diagram.

**Compilation flags:**

`static`

**Template:**

`remember_included_directory(Path)`

**Mode and number of proofs:**

`remember_included_directory(+atom)` - `one`

------------------------------------------------------------------------

###### `remember_referenced_logtalk_directory/1`

Remember referenced Logtalk directory in the diagram.

**Compilation flags:**

`static`

**Template:**

`remember_referenced_logtalk_directory(Path)`

**Mode and number of proofs:**

`remember_referenced_logtalk_directory(+atom)` - `one`

------------------------------------------------------------------------

###### `remember_referenced_prolog_directory/1`

Remember referenced Prolog directory in the diagram.

**Compilation flags:**

`static`

**Template:**

`remember_referenced_prolog_directory(Path)`

**Mode and number of proofs:**

`remember_referenced_prolog_directory(+atom)` - `one`

------------------------------------------------------------------------

##### Private predicates

###### `included_directory_/1`

Table of Logtalk directories already included in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`included_directory_(Path)`

**Mode and number of proofs:**

`included_directory_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `referenced_logtalk_directory_/1`

Table of referenced Logtalk directories in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`referenced_logtalk_directory_(Path)`

**Mode and number of proofs:**

`referenced_logtalk_directory_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `referenced_prolog_directory_/1`

Table of referenced Prolog directories in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`referenced_prolog_directory_(Path)`

**Mode and number of proofs:**

`referenced_prolog_directory_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `directory_load_diagram`

Predicates for generating directory loading dependency diagrams in DOT format.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2019-04-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` directory_load_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

directory_dependency_diagram, file_dependency_diagram

**object**

#### `directory_load_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating directory loading dependency diagrams.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 3:0:1

**Date:** 2024-04-01

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` directory_diagram(Format)

**Uses:**

file_dependency_diagram(Format)

file_load_diagram(Format)

list

logtalk

modules_diagram_support

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

  - `sub_diagram_/2`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `sub_diagram_/2`

Table of directory sub-diagrams to support their generation.

**Compilation flags:**

`dynamic`

**Template:**

`sub_diagram_(Project,Directory)`

**Mode and number of proofs:**

`sub_diagram_(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

directory_dependency_diagram(Format), file_dependency_diagram(Format), library_dependency_diagram(Format)

**object**

#### `dot_graph_language`

Predicates for generating graph files in the DOT language (version 2.36.0 or later).

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 3:12:0

**Date:** 2025-10-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` graph_language_protocol

**Imports:**

`public` options

**Provides:**

graph_language_registry::language_object/2

**Uses:**

list

os

term_io

user

**Remarks:**

(none)

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  edge/6  file_footer/3  file_header/3  graph_footer/5  graph_header/5  node/7  option/2  option/3  output_file_name/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `entity_diagram`

Predicates for generating entity diagrams in DOT format with both inheritance and cross-referencing relation edges.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2014-01-01

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` entity_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  file/1  file/2  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

inheritance_diagram, uses_diagram, xref_diagram

**object**

#### `entity_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating entity diagrams in the specified format with both inheritance and cross-referencing relation edges.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:60:0

**Date:** 2024-12-04

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` diagram(Format)

**Uses:**

list

logtalk

modules_diagram_support

user

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

  - `file/2`

  - `file/1`

- Protected predicates

- Private predicates

  - `included_entity_/1`

  - `included_module_/1`

  - `referenced_entity_/2`

  - `referenced_module_/2`

- Operators

##### Public predicates

###### `file/2`

Creates a diagram for all entities in a loaded source file using the specified options. The file can be specified by name, basename, full path, or using library notation.

**Compilation flags:**

`static`

**Template:**

`file(File,Options)`

**Mode and number of proofs:**

`file(+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `file/1`

Creates a diagram for all entities in a loaded source file using default options. The file can be specified by name, basename, full path, or using library notation.

**Compilation flags:**

`static`

**Template:**

`file(File)`

**Mode and number of proofs:**

`file(+atom)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `included_entity_/1`

Table of Logtalk entities already included in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`included_entity_(Entity)`

**Mode and number of proofs:**

`included_entity_(?entity_identifier)` - `zero_or_more`

------------------------------------------------------------------------

###### `included_module_/1`

Table of Prolog modules already included in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`included_module_(Module)`

**Mode and number of proofs:**

`included_module_(?module_identifier)` - `zero_or_more`

------------------------------------------------------------------------

###### `referenced_entity_/2`

Table of referenced Logtalk entities in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`referenced_entity_(Referencer,Entity)`

**Mode and number of proofs:**

`referenced_entity_(?entity_identifier,?entity_identifier)` - `zero_or_more`

------------------------------------------------------------------------

###### `referenced_module_/2`

Table of referenced Logtalk entities in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`referenced_module_(Referencer,Entity)`

**Mode and number of proofs:**

`referenced_module_(?entity_identifier,?module_identifier)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

inheritance_diagram(Format), uses_diagram(Format), xref_diagram(Format), library_diagram(Format)

**object**

#### `file_dependency_diagram`

Predicates for generating file contents dependency diagrams in DOT format. A dependency exists when an entity in one file makes a reference to an entity in another file.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:1:0

**Date:** 2019-06-13

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` file_dependency_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

file_load_diagram, directory_load_diagram, library_load_diagram

**object**

#### `file_dependency_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating file contents dependency diagrams. A dependency exists when an entity in one file makes a reference to an entity in another file.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:28:3

**Date:** 2024-04-01

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` file_diagram(Format)

**Uses:**

entity_diagram(Format)

list

logtalk

modules_diagram_support

os

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

  - `sub_diagram_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `sub_diagram_/1`

Table of file sub-diagrams to support their generation.

**Compilation flags:**

`dynamic`

**Template:**

`sub_diagram_(File)`

**Mode and number of proofs:**

`sub_diagram_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

file_load_diagram(Format), directory_load_diagram(Format), library_load_diagram(Format)

**category**

#### `file_diagram(Format)`

- `Format` - Graph language file format.

Common predicates for generating file diagrams.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:14:0

**Date:** 2024-12-04

**Compilation flags:**

`static`

**Extends:**

`public` diagram(Format)

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

  - `remember_included_file/1`

  - `remember_referenced_logtalk_file/1`

  - `remember_referenced_prolog_file/1`

- Private predicates

  - `included_file_/1`

  - `referenced_logtalk_file_/1`

  - `referenced_prolog_file_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

###### `remember_included_file/1`

Remember included Logtalk file in the diagram.

**Compilation flags:**

`static`

**Template:**

`remember_included_file(Path)`

**Mode and number of proofs:**

`remember_included_file(+atom)` - `one`

------------------------------------------------------------------------

###### `remember_referenced_logtalk_file/1`

Remember referenced Logtalk file in the diagram.

**Compilation flags:**

`static`

**Template:**

`remember_referenced_logtalk_file(Path)`

**Mode and number of proofs:**

`remember_referenced_logtalk_file(+atom)` - `one`

------------------------------------------------------------------------

###### `remember_referenced_prolog_file/1`

Remember referenced Prolog file in the diagram.

**Compilation flags:**

`static`

**Template:**

`remember_referenced_prolog_file(Path)`

**Mode and number of proofs:**

`remember_referenced_prolog_file(+atom)` - `one`

------------------------------------------------------------------------

##### Private predicates

###### `included_file_/1`

Table of Logtalk files already included in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`included_file_(Path)`

**Mode and number of proofs:**

`included_file_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `referenced_logtalk_file_/1`

Table of referenced Logtalk files in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`referenced_logtalk_file_(Path)`

**Mode and number of proofs:**

`referenced_logtalk_file_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `referenced_prolog_file_/1`

Table of referenced Prolog files in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`referenced_prolog_file_(Path)`

**Mode and number of proofs:**

`referenced_prolog_file_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `file_load_diagram`

Predicates for generating file loading dependency diagrams in DOT format. A dependency exists when a file loads or includes another file.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:1:0

**Date:** 2019-06-13

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` file_load_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

file_dependency_diagram, directory_dependency_diagram, library_dependency_diagram

**object**

#### `file_load_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating file loading dependency diagrams. A dependency exists when a file loads or includes another file.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:30:3

**Date:** 2024-12-05

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` file_diagram(Format)

**Uses:**

entity_diagram(Format)

list

logtalk

modules_diagram_support

os

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

  - `sub_diagram_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `sub_diagram_/1`

Table of file sub-diagrams to support their generation.

**Compilation flags:**

`dynamic`

**Template:**

`sub_diagram_(File)`

**Mode and number of proofs:**

`sub_diagram_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

file_dependency_diagram(Format), directory_dependency_diagram(Format), library_dependency_diagram(Format)

**protocol**

#### `graph_language_protocol`

Predicates for generating graph files.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2014-12-30

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `output_file_name/2`

  - `file_header/3`

  - `file_footer/3`

  - `graph_header/5`

  - `graph_footer/5`

  - `node/7`

  - `edge/6`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `output_file_name/2`

Constructs the diagram file basename by adding a graph language dependent extension to the given name.

**Compilation flags:**

`static`

**Template:**

`output_file_name(Name,Basename)`

**Mode and number of proofs:**

`output_file_name(+atom,-atom)` - `one`

------------------------------------------------------------------------

###### `file_header/3`

Writes the output file header using the specified options.

**Compilation flags:**

`static`

**Template:**

`file_header(Stream,Identifier,Options)`

**Mode and number of proofs:**

`file_header(+stream_or_alias,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `file_footer/3`

Writes the output file footer using the specified options.

**Compilation flags:**

`static`

**Template:**

`file_footer(Stream,Identifier,Options)`

**Mode and number of proofs:**

`file_footer(+stream_or_alias,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `graph_header/5`

Writes a graph header using the specified options.

**Compilation flags:**

`static`

**Template:**

`graph_header(Stream,Identifier,Label,Kind,Options)`

**Mode and number of proofs:**

`graph_header(+stream_or_alias,+atom,+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `graph_footer/5`

Writes a graph footer using the specified options.

**Compilation flags:**

`static`

**Template:**

`graph_footer(Stream,Identifier,Label,Kind,Options)`

**Mode and number of proofs:**

`graph_footer(+stream_or_alias,+atom,+atom,+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `node/7`

Writes a node using the specified options.

**Compilation flags:**

`static`

**Template:**

`node(Stream,Identifier,Label,Caption,Lines,Kind,Options)`

**Mode and number of proofs:**

`node(+stream_or_alias,+nonvar,+nonvar,+nonvar,+list(nonvar),+atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `edge/6`

Writes an edge between two nodes using the specified options.

**Compilation flags:**

`static`

**Template:**

`edge(Stream,Start,End,Labels,Kind,Options)`

**Mode and number of proofs:**

`edge(+stream_or_alias,+nonvar,+nonvar,+list(nonvar),+atom,+list(compound))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**object**

#### `graph_language_registry`

Registry of implemented graph languages.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 1:0:1

**Date:** 2020-03-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `language_object/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `language_object/2`

Table of defined graph languages and their implementation objects.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`language_object(Language,Object)`

**Mode and number of proofs:**

`language_object(?atom,?object_identifier)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**object**

#### `inheritance_diagram`

Predicates for generating entity diagrams in DOT format with inheritance relation edges but no cross-referencing relation edges.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2014-01-15

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` inheritance_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  file/1  file/2  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

entity_diagram, uses_diagram, xref_diagram

**object**

#### `inheritance_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating entity diagrams in the specified format with inheritance relation edges but no cross-referencing relation edges.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:20:0

**Date:** 2024-03-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` entity_diagram(Format)

**Uses:**

logtalk

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  file/1  file/2  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

entity_diagram(Format), uses_diagram(Format), xref_diagram(Format)

**object**

#### `library_dependency_diagram`

Predicates for generating library dependency diagrams in DOT format.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:1:0

**Date:** 2019-06-13

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` library_dependency_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

library_load_diagram, file_load_diagram, entity_diagram

**object**

#### `library_dependency_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating library dependency diagrams. A dependency exists when an entity in one library makes a reference to an entity in another library.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:34:0

**Date:** 2025-12-03

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` library_diagram(Format)

**Uses:**

entity_diagram(Format)

list

logtalk

modules_diagram_support

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

  - `sub_diagram_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `sub_diagram_/1`

Table of library sub-diagrams to support their generation.

**Compilation flags:**

`dynamic`

**Template:**

`sub_diagram_(Library)`

**Mode and number of proofs:**

`sub_diagram_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

library_load_diagram(Format), directory_load_diagram(Format), file_load_diagram(Format), entity_diagram(Format)

**category**

#### `library_diagram(Format)`

- `Format` - Graph language file format.

Common predicates for generating library diagrams.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:17:0

**Date:** 2024-12-04

**Compilation flags:**

`static`

**Extends:**

`public` diagram(Format)

**Uses:**

list

user

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

  - `add_library_documentation_url/4`

  - `remember_included_library/2`

  - `remember_referenced_logtalk_library/2`

  - `remember_referenced_prolog_library/2`

- Private predicates

  - `included_library_/2`

  - `referenced_logtalk_library_/2`

  - `referenced_prolog_library_/2`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

###### `add_library_documentation_url/4`

Adds a documentation URL when using the option url_prefixes/2.

**Compilation flags:**

`static`

**Template:**

`add_library_documentation_url(Kind,Options,Library,NodeOptions)`

**Mode and number of proofs:**

`add_library_documentation_url(+atom,+list(compound),+atom,-list(compound))` - `one`

------------------------------------------------------------------------

###### `remember_included_library/2`

Remember included Logtalk library in the diagram.

**Compilation flags:**

`static`

**Template:**

`remember_included_library(Library,Path)`

**Mode and number of proofs:**

`remember_included_library(+atom,+atom)` - `one`

------------------------------------------------------------------------

###### `remember_referenced_logtalk_library/2`

Remember referenced Logtalk library in the diagram.

**Compilation flags:**

`static`

**Template:**

`remember_referenced_logtalk_library(Library,Path)`

**Mode and number of proofs:**

`remember_referenced_logtalk_library(+atom,+atom)` - `one`

------------------------------------------------------------------------

###### `remember_referenced_prolog_library/2`

Remember referenced Prolog library in the diagram.

**Compilation flags:**

`static`

**Template:**

`remember_referenced_prolog_library(Library,Path)`

**Mode and number of proofs:**

`remember_referenced_prolog_library(+atom,+atom)` - `one`

------------------------------------------------------------------------

##### Private predicates

###### `included_library_/2`

Table of Logtalk libraries already included in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`included_library_(Library,Path)`

**Mode and number of proofs:**

`included_library_(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `referenced_logtalk_library_/2`

Table of referenced Logtalk libraries in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`referenced_logtalk_library_(Library,Path)`

**Mode and number of proofs:**

`referenced_logtalk_library_(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `referenced_prolog_library_/2`

Table of referenced Prolog libraries in the diagram.

**Compilation flags:**

`dynamic`

**Template:**

`referenced_prolog_library_(Library,Path)`

**Mode and number of proofs:**

`referenced_prolog_library_(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

inheritance_diagram(Format), uses_diagram(Format), xref_diagram(Format), entity_diagram(Format)

**object**

#### `library_load_diagram`

Predicates for generating library loading dependency diagrams in DOT format.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:1:0

**Date:** 2019-06-13

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` library_load_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

library_dependency_diagram, file_dependency_diagram, entity_diagram

**object**

#### `library_load_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating library loading dependency diagrams.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:33:1

**Date:** 2024-04-01

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` library_diagram(Format)

**Uses:**

entity_diagram(Format)

list

logtalk

modules_diagram_support

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

  - `sub_diagram_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `sub_diagram_/1`

Table of library sub-diagrams to support their generation.

**Compilation flags:**

`dynamic`

**Template:**

`sub_diagram_(Library)`

**Mode and number of proofs:**

`sub_diagram_(?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

library_dependency_diagram(Format), directory_dependency_diagram(Format), file_dependency_diagram(Format), entity_diagram(Format)

**object**

#### `mermaid_graph_language`

Predicates for generating graph files using Mermaid.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 0:3:1

**Date:** 2025-11-11

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` graph_language_protocol

**Imports:**

`public` options

**Provides:**

graph_language_registry::language_object/2

**Uses:**

list

os

term_io

user

**Remarks:**

(none)

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  edge/6  file_footer/3  file_header/3  graph_footer/5  graph_header/5  node/7  option/2  option/3  output_file_name/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `modules_diagram_support`

Utility predicates for supporting Prolog modules in diagrams.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 0:19:5

**Date:** 2022-07-08

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

> - Supported backend Prolog systems: ECLiPSe, SICStus Prolog, SWI-Prolog, and YAP.

**Inherited public predicates:**

(none)

- Public predicates

  - `module_property/2`

  - `loaded_file_property/2`

  - `source_file_extension/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `module_property/2`

Access to module properties, at least `exports/1`, `file/1`, and `file/2` but also `declares/2`, `defines/2`, `calls/2`, and `provides/3` when possible.

**Compilation flags:**

`static`

**Template:**

`module_property(Module,Property)`

**Mode and number of proofs:**

`module_property(?atom,?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `loaded_file_property/2`

Access to loaded source file properties, at least `basename/1`, `directory/1` but also `parent/1` when possible.

**Compilation flags:**

`static`

**Template:**

`loaded_file_property(File,Property)`

**Mode and number of proofs:**

`loaded_file_property(?atom,?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `source_file_extension/1`

Valid source file extension for Prolog source files.

**Compilation flags:**

`static`

**Template:**

`source_file_extension(Extension)`

**Mode and number of proofs:**

`source_file_extension(?atom)` - `one_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**object**

#### `uses_diagram`

Predicates for generating entity diagrams in DOT format with only `uses/2` and `use_module/2` relation edges.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:0:1

**Date:** 2020-03-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` uses_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  file/1  file/2  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

entity_diagram, inheritance_diagram, xref_diagram

**object**

#### `uses_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating entity diagrams with only `uses/2` and `use_module/2` relation edges.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:21:0

**Date:** 2024-03-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` entity_diagram(Format)

**Uses:**

logtalk

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  file/1  file/2  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

entity_diagram(Format), inheritance_diagram(Format), xref_diagram(Format)

**object**

#### `xref_diagram`

Predicates for generating predicate call cross-referencing diagrams in DOT format.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2014-01-01

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` xref_diagram(dot)

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  entity/1  entity/2  file/1  file/2  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

entity_diagram, inheritance_diagram, uses_diagram

**object**

#### `xref_diagram(Format)`

- `Format` - Graph language file format.

Predicates for generating predicate call cross-referencing diagrams.

**Availability:**

`logtalk_load(diagrams(loader))`

**Author:** Paulo Moura

**Version:** 2:85:1

**Date:** 2025-10-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` entity_diagram(Format)

**Uses:**

atom

list

logtalk

modules_diagram_support

os

user

**Remarks:**

(none)

**Inherited public predicates:**

 all_files/0  all_files/1  all_libraries/0  all_libraries/1  check_option/1  check_options/1  default_option/1  default_options/1  diagram_description/1  diagram_name_suffix/1  directories/2  directories/3  directory/1  directory/2  directory/3  file/1  file/2  files/1  files/2  files/3  format_object/1  libraries/1  libraries/2  libraries/3  library/1  library/2  option/2  option/3  rdirectory/1  rdirectory/2  rdirectory/3  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

  - `entity/2`

  - `entity/1`

- Protected predicates

- Private predicates

  - `included_predicate_/1`

  - `referenced_predicate_/1`

  - `external_predicate_/1`

- Operators

##### Public predicates

###### `entity/2`

Creates a diagram for a single entity using the specified options.

**Compilation flags:**

`static`

**Template:**

`entity(Entity,Options)`

**Mode and number of proofs:**

`entity(+entity_identifier,+list(compound))` - `one`

------------------------------------------------------------------------

###### `entity/1`

Creates a diagram for a single entity using default options.

**Compilation flags:**

`static`

**Template:**

`entity(Entity)`

**Mode and number of proofs:**

`entity(+entity_identifier)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `included_predicate_/1`

Table of predicates already included in the diagram for the entity under processing.

**Compilation flags:**

`dynamic`

**Template:**

`included_predicate_(Predicate)`

**Mode and number of proofs:**

`included_predicate_(?predicate_indicator)` - `zero_or_more`

------------------------------------------------------------------------

###### `referenced_predicate_/1`

Table of referenced predicates for the entity under processing.

**Compilation flags:**

`dynamic`

**Template:**

`referenced_predicate_(Predicate)`

**Mode and number of proofs:**

`referenced_predicate_(?predicate_indicator)` - `zero_or_more`

------------------------------------------------------------------------

###### `external_predicate_/1`

Table of external predicate references for all the entities under processing.

**Compilation flags:**

`dynamic`

**Template:**

`external_predicate_(Reference)`

**Mode and number of proofs:**

`external_predicate_(?compound)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

entity_diagram(Format), inheritance_diagram(Format), uses_diagram(Format)

### dictionaries")

**object**

#### `avltree`

AVL tree implementation of the dictionary protocol. Uses standard order to compare keys.

**Availability:**

`logtalk_load(dictionaries(loader))`

**Author:** R.A.O’Keefe, L.Damas, V.S.Costa, Glenn Burgess, Jiri Spitz, and Jan Wielemaker; Logtalk port and additional predicates by Paulo Moura

**Version:** 1:6:0

**Date:** 2026-02-10

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` dictionaryp

**Extends:**

`public` term

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  apply/4  as_curly_bracketed/2  as_dictionary/2  as_list/2  check/1  clone/3  clone/4  delete/4  delete_max/4  delete_min/4  depth/2  empty/1  ground/1  insert/4  intersection/2  intersection/3  keys/2  lookup/2  lookup/3  lookup/4  map/2  map/3  max/3  min/3  new/1  next/4  numbervars/1  numbervars/3  occurs/2  previous/4  singletons/2  size/2  subsumes/2  subterm/2  update/3  update/4  update/5  valid/1  values/2  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

bintree, rbtree

**object**

#### `bintree`

Simple binary tree implementation of the dictionary protocol. Uses standard order to compare keys.

**Availability:**

`logtalk_load(dictionaries(loader))`

**Author:** Paulo Moura and Paul Fodor

**Version:** 2:13:0

**Date:** 2026-02-10

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` dictionaryp

**Extends:**

`public` term

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  apply/4  as_curly_bracketed/2  as_dictionary/2  as_list/2  check/1  clone/3  clone/4  delete/4  delete_max/4  delete_min/4  depth/2  empty/1  ground/1  insert/4  intersection/2  intersection/3  keys/2  lookup/2  lookup/3  lookup/4  map/2  map/3  max/3  min/3  new/1  next/4  numbervars/1  numbervars/3  occurs/2  previous/4  singletons/2  size/2  subsumes/2  subterm/2  update/3  update/4  update/5  valid/1  values/2  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

  - `preorder/2`

  - `inorder/2`

  - `postorder/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `preorder/2`

Preorder tree traversal.

**Compilation flags:**

`static`

**Template:**

`preorder(Tree,List)`

**Mode and number of proofs:**

`preorder(@tree,-list)` - `one`

------------------------------------------------------------------------

###### `inorder/2`

Inorder tree traversal.

**Compilation flags:**

`static`

**Template:**

`inorder(Tree,List)`

**Mode and number of proofs:**

`inorder(@tree,-list)` - `one`

------------------------------------------------------------------------

###### `postorder/2`

Postorder tree traversal.

**Compilation flags:**

`static`

**Template:**

`postorder(Tree,List)`

**Mode and number of proofs:**

`postorder(@tree,-list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

avltree, rbtree, splaytree

**protocol**

#### `dictionaryp`

Dictionary protocol.

**Availability:**

`logtalk_load(dictionaries(loader))`

**Author:** Paulo Moura

**Version:** 2:6:0

**Date:** 2026-02-10

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `as_dictionary/2`

  - `as_list/2`

  - `as_curly_bracketed/2`

  - `clone/3`

  - `clone/4`

  - `insert/4`

  - `delete/4`

  - `update/4`

  - `update/5`

  - `update/3`

  - `empty/1`

  - `lookup/4`

  - `lookup/3`

  - `lookup/2`

  - `intersection/2`

  - `intersection/3`

  - `previous/4`

  - `next/4`

  - `min/3`

  - `max/3`

  - `delete_min/4`

  - `delete_max/4`

  - `keys/2`

  - `values/2`

  - `map/2`

  - `map/3`

  - `apply/4`

  - `size/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `as_dictionary/2`

Converts a list of key-value pairs to a dictionary.

**Compilation flags:**

`static`

**Template:**

`as_dictionary(Pairs,Dictionary)`

**Mode and number of proofs:**

`as_dictionary(@list(pairs),-dictionary)` - `one`

------------------------------------------------------------------------

###### `as_list/2`

Converts a dictionary to an ordered list (as per standard order) of key-value pairs.

**Compilation flags:**

`static`

**Template:**

`as_list(Dictionary,Pairs)`

**Mode and number of proofs:**

`as_list(@dictionary,-list(pairs))` - `one`

------------------------------------------------------------------------

###### `as_curly_bracketed/2`

Creates a curly-bracketed term representation of a dictionary.

**Compilation flags:**

`static`

**Template:**

`as_curly_bracketed(Dictionary,Term)`

**Mode and number of proofs:**

`as_curly_bracketed(+dictionary,--term)` - `one`

------------------------------------------------------------------------

###### `clone/3`

Clones a dictionary using the same keys but with all values unbound and returning a list of all the pairs in the new clone.

**Compilation flags:**

`static`

**Template:**

`clone(Dictionary,Clone,ClonePairs)`

**Mode and number of proofs:**

`clone(+dictionary,-dictionary,-list(pairs))` - `one`

------------------------------------------------------------------------

###### `clone/4`

Clones a dictionary using the same keys but with all values unbound and returning the list of all pairs in the dictionary and in the clone.

**Compilation flags:**

`static`

**Template:**

`clone(Dictionary,Pairs,Clone,ClonePairs)`

**Mode and number of proofs:**

`clone(+dictionary,-list(pairs),-dictionary,-list(pairs))` - `one`

------------------------------------------------------------------------

###### `insert/4`

Inserts a key-value pair into a dictionary, returning the updated dictionary. When the key already exists, the associated value is updated.

**Compilation flags:**

`static`

**Template:**

`insert(OldDictionary,Key,Value,NewDictionary)`

**Mode and number of proofs:**

`insert(+dictionary,+ground,@term,-dictionary)` - `one`

------------------------------------------------------------------------

###### `delete/4`

Deletes a matching key-value pair from a dictionary, returning the updated dictionary. Fails if it cannot find the key or if the key exists but the value does not unify.

**Compilation flags:**

`static`

**Template:**

`delete(OldDictionary,Key,Value,NewDictionary)`

**Mode and number of proofs:**

`delete(+dictionary,@ground,?term,-dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `update/4`

Updates the value associated with Key in a dictionary, returning the updated dictionary. Fails if it cannot find the key.

**Compilation flags:**

`static`

**Template:**

`update(OldDictionary,Key,NewValue,NewDictionary)`

**Mode and number of proofs:**

`update(+dictionary,@ground,+term,-dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `update/5`

Updates the value associated with a key in a dictionary, returning the updated dictionary. Fails if it cannot find the key or if the existing value does not unify.

**Compilation flags:**

`static`

**Template:**

`update(OldDictionary,Key,OldValue,NewValue,NewDictionary)`

**Mode and number of proofs:**

`update(+dictionary,@ground,?term,+term,-dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `update/3`

Updates the key-value pairs in a dictionary, returning the updated dictionary. Fails if it cannot find one of the keys.

**Compilation flags:**

`static`

**Template:**

`update(OldDictionary,Pairs,NewDictionary)`

**Mode and number of proofs:**

`update(+dictionary,@list(pair),-dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `empty/1`

True iff the dictionary is empty.

**Compilation flags:**

`static`

**Template:**

`empty(Dictionary)`

**Mode and number of proofs:**

`empty(@dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `lookup/4`

Lookups a matching key-value pair from a dictionary and returns the splayed dictionary with the key at the root. Fails if the key is not found. In implementations that do not update the dictionary on lookup, the same dictionary is returned.

**Compilation flags:**

`static`

**Template:**

`lookup(Key,Value,Dictionary,SplayedDictionary)`

**Mode and number of proofs:**

`lookup(+ground,?term,+tree,-tree)` - `zero_or_one`

------------------------------------------------------------------------

###### `lookup/3`

Lookups a matching key-value pair from a dictionary. Fails if no match is found.

**Compilation flags:**

`static`

**Template:**

`lookup(Key,Value,Dictionary)`

**Mode and number of proofs:**

`lookup(+ground,?term,@dictionary)` - `zero_or_one`

`lookup(-ground,?term,@dictionary)` - `zero_or_more`

------------------------------------------------------------------------

###### `lookup/2`

Lookups all matching key-value pairs from a dictionary. Fails if it cannot find one of the keys or if a value for a key does not unify.

**Compilation flags:**

`static`

**Template:**

`lookup(Pairs,Dictionary)`

**Mode and number of proofs:**

`lookup(+list(pair),@dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `intersection/2`

True iff the values of the dictionaries common keys unify. Trivially true when there are no common keys.

**Compilation flags:**

`static`

**Template:**

`intersection(Dictionary1,Dictionary2)`

**Mode and number of proofs:**

`intersection(+dictionary,+dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `intersection/3`

Returns the (possibly empty) intersection between two dictionaries when the values of their common keys unify.

**Compilation flags:**

`static`

**Template:**

`intersection(Dictionary1,Dictionary2,Intersection)`

**Mode and number of proofs:**

`intersection(+dictionary,+dictionary,-dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `previous/4`

Returns the previous pair in a dictionary given a key. Fails if there is no previous pair.

**Compilation flags:**

`static`

**Template:**

`previous(Dictionary,Key,Previous,Value)`

**Mode and number of proofs:**

`previous(+dictionary,+key,-key,-value)` - `zero_or_one`

------------------------------------------------------------------------

###### `next/4`

Returns the next pair in a dictionary given a key. Fails if there is no next pair.

**Compilation flags:**

`static`

**Template:**

`next(Dictionary,Key,Next,Value)`

**Mode and number of proofs:**

`next(+dictionary,+key,-key,-value)` - `zero_or_one`

------------------------------------------------------------------------

###### `min/3`

Returns the pair with the minimum key (as per standard order) in a dictionary. Fails if the dictionary is empty.

**Compilation flags:**

`static`

**Template:**

`min(Dictionary,Key,Value)`

**Mode and number of proofs:**

`min(+dictionary,-key,-value)` - `zero_or_one`

------------------------------------------------------------------------

###### `max/3`

Returns the pair with the maximum key (as per standard order) in a dictionary. Fails if the dictionary is empty.

**Compilation flags:**

`static`

**Template:**

`max(Dictionary,Key,Value)`

**Mode and number of proofs:**

`max(+dictionary,-key,-value)` - `zero_or_one`

------------------------------------------------------------------------

###### `delete_min/4`

Deletes the pair with the minimum key (as per standard order) from a dictionary, returning the deleted pair and the updated dictionary. Fails if the dictionary is empty.

**Compilation flags:**

`static`

**Template:**

`delete_min(OldDictionary,Key,Value,NewDictionary)`

**Mode and number of proofs:**

`delete_min(+dictionary,-key,-value,-dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `delete_max/4`

Deletes the pair with the maximum key (as per standard order) from a dictionary, returning the deleted pair and the updated dictionary. Fails if the dictionary is empty.

**Compilation flags:**

`static`

**Template:**

`delete_max(OldDictionary,Key,Value,NewDictionary)`

**Mode and number of proofs:**

`delete_max(+dictionary,-key,-value,-dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `keys/2`

Returns a list with all the dictionary keys in ascending order (as per standard order).

**Compilation flags:**

`static`

**Template:**

`keys(Dictionary,Keys)`

**Mode and number of proofs:**

`keys(@dictionary,-list)` - `one`

------------------------------------------------------------------------

###### `values/2`

Returns a list with all the dictionary values in ascending order of the keys (as per standard order).

**Compilation flags:**

`static`

**Template:**

`values(Dictionary,Values)`

**Mode and number of proofs:**

`values(@dictionary,-list)` - `one`

------------------------------------------------------------------------

###### `map/2`

Maps a closure over each dictionary key-value pair. Fails if the mapped closure attempts to modify the keys.

**Compilation flags:**

`static`

**Template:**

`map(Closure,Dictionary)`

**Meta-predicate template:**

`map(1,*)`

**Mode and number of proofs:**

`map(@callable,+dictionary)` - `zero_or_more`

------------------------------------------------------------------------

###### `map/3`

Maps a closure over each dictionary key-value pair, returning the new dictionary. Fails if the mapped closure attempts to modify the keys.

**Compilation flags:**

`static`

**Template:**

`map(Closure,OldDictionary,NewDictionary)`

**Meta-predicate template:**

`map(2,*,*)`

**Mode and number of proofs:**

`map(@callable,+dictionary,-dictionary)` - `zero_or_more`

------------------------------------------------------------------------

###### `apply/4`

Applies a closure to a specific key-value pair, returning the new dictionary. Fails if the key cannot be found or if the mapped closure attempts to modify the key.

**Compilation flags:**

`static`

**Template:**

`apply(Closure,OldDictionary,Key,NewDictionary)`

**Meta-predicate template:**

`apply(2,*,*,*)`

**Mode and number of proofs:**

`apply(+callable,+dictionary,+key,-dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `size/2`

Number of dictionary entries.

**Compilation flags:**

`static`

**Template:**

`size(Dictionary,Size)`

**Mode and number of proofs:**

`size(@dictionary,?integer)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

avltree, bintree, rbtree, splaytree

**object**

#### `rbtree`

Red-Black tree implementation of the dictionary protocol. Uses standard order to compare keys.

**Availability:**

`logtalk_load(dictionaries(loader))`

**Author:** Vitor Santos Costa; Logtalk port and additional predicates by Paulo Moura.

**Version:** 1:11:0

**Date:** 2026-02-10

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` dictionaryp

**Extends:**

`public` term

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  apply/4  as_curly_bracketed/2  as_dictionary/2  as_list/2  check/1  clone/3  clone/4  delete/4  delete_max/4  delete_min/4  depth/2  empty/1  ground/1  insert/4  intersection/2  intersection/3  keys/2  lookup/2  lookup/3  lookup/4  map/2  map/3  max/3  min/3  new/1  next/4  numbervars/1  numbervars/3  occurs/2  previous/4  singletons/2  size/2  subsumes/2  subterm/2  update/3  update/4  update/5  valid/1  values/2  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

  - `partial_map/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `partial_map/4`

Applies a closure to the tree pairs identified by a set of keys.

**Compilation flags:**

`static`

**Template:**

`partial_map(Tree,Keys,Closure,NewTree)`

**Meta-predicate template:**

`partial_map(*,*,2,*)`

**Mode and number of proofs:**

`partial_map(+tree,+list,@closure,-tree)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

avltree, splaytree, bintree

**object**

#### `splaytree`

Splay tree implementation of the dictionary protocol. A splay tree is a self-adjusting binary search tree with the property that recently accessed elements are quick to access again. Uses standard order to compare keys.

**Availability:**

`logtalk_load(dictionaries(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-10

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` dictionaryp

**Extends:**

`public` term

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  apply/4  as_curly_bracketed/2  as_dictionary/2  as_list/2  check/1  clone/3  clone/4  delete/4  delete_max/4  delete_min/4  depth/2  empty/1  ground/1  insert/4  intersection/2  intersection/3  keys/2  lookup/2  lookup/3  lookup/4  map/2  map/3  max/3  min/3  new/1  next/4  numbervars/1  numbervars/3  occurs/2  previous/4  singletons/2  size/2  subsumes/2  subterm/2  update/3  update/4  update/5  valid/1  values/2  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

avltree, bintree, rbtree

### dif")

**object**

#### `dif`

Provides dif/2 and derived predicates.

**Availability:**

`logtalk_load(dif(loader))`

**Author:** Paulo Moura

**Version:** 1:3:0

**Date:** 2023-10-02

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

> - Supported backend Prolog systems: B-Prolog, ECLiPSe, SICStus Prolog, SWI-Prolog, Trealla Prolog, and YAP.

**Inherited public predicates:**

(none)

- Public predicates

  - `dif/2`

  - `dif/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `dif/2`

Sets a constraint that is true iff the two terms are different.

**Compilation flags:**

`static`

**Template:**

`dif(Term1,Term2)`

**Mode and number of proofs:**

`dif(+term,+term)` - `zero_or_one`

------------------------------------------------------------------------

###### `dif/1`

Sets a set of constraints that are true iff all terms in a list are different.

**Compilation flags:**

`static`

**Template:**

`dif(Terms)`

**Mode and number of proofs:**

`dif(+list(term))` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### doclet")

**object**

#### `doclet`

Utility object to help automate (re)generating documentation for a project.

**Availability:**

`logtalk_load(doclet(loader))`

**Author:** Paulo Moura

**Version:** 0:5:0

**Date:** 2017-01-05

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_tokens//2

**Uses:**

logtalk

os

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `update/0`

  - `doc_goal/1`

  - `shell_command/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `update/0`

Updates the project documentation, first by calling a sequence of goals and second by executing a sequence of shell commands. Fails if any goal or shell command fails.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`update` - `zero_or_one`

------------------------------------------------------------------------

###### `doc_goal/1`

Table of goals, typically using the `diagrams` and the `lgtdoc` tools, used to generate the documentation. Goals are called in the order they are defined and in the context of the `user` pseudo-object.

**Compilation flags:**

`static`

**Template:**

`doc_goal(Goal)`

**Mode and number of proofs:**

`doc_goal(?callable)` - `one_or_more`

------------------------------------------------------------------------

###### `shell_command/1`

Table of shell commands to convert intermediate documentation files into user-friendly documentation. Commands are executed in the order they are defined.

**Compilation flags:**

`static`

**Template:**

`shell_command(Command)`

**Mode and number of proofs:**

`shell_command(?atom)` - `one_or_more`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

lgtdocp, diagram(Format)

### edcg")

**object**

#### `edcg`

Multiple hidden parameters: an extension to Prolog’s DCG notation. Ported to Logtalk as a hook object.

**Availability:**

`logtalk_load(edcg(loader))`

**Author:** Peter Van Roy; adapted to Logtalk by Paulo Moura.

**Version:** 1:4:2

**Date:** 2020-04-08

**Copyright:** Copyright (C) 1992 Peter Van Roy

**License:** MIT

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Provides:**

logtalk::message_tokens//2

**Uses:**

list

logtalk

**Remarks:**

> - Usage: Compile source files with objects (or categories) defining EDCGs using the compiler option `hook(edcg)`.

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

  - `pred_info/3`

  - `acc_info/7`

  - `acc_info/5`

  - `pass_info/2`

  - `pass_info/1`

- Operators

  - `op(1200,xfx,-->>)`

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `pred_info/3`

Declares predicates that have the listed hidden parameters.

**Compilation flags:**

`dynamic`

**Template:**

`pred_info(Name,Arity,HiddenParameters)`

**Mode and number of proofs:**

`pred_info(?atom,?integer,?list(atom))` - `zero_or_more`

------------------------------------------------------------------------

###### `acc_info/7`

Long form for declaring accumulators.

**Compilation flags:**

`dynamic`

**Template:**

`acc_info(Accumulator,Term,Left,Right,Joiner,LStart,RStart)`

**Mode and number of proofs:**

`acc_info(?atom,?term,?term,?term,?callable,?term,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `acc_info/5`

Short form for declaring accumulators.

**Compilation flags:**

`dynamic`

**Template:**

`acc_info(Accumulator,Term,Left,Right,Joiner)`

**Mode and number of proofs:**

`acc_info(?atom,?term,?term,?term,?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `pass_info/2`

Long form for declaring passed arguments. Passed arguments are conceptually the same as accumulators with `=/2` as the joiner function.

**Compilation flags:**

`dynamic`

**Template:**

`pass_info(Argument,PStart)`

**Mode and number of proofs:**

`pass_info(?atom,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `pass_info/1`

Short form for declaring passed arguments. Passed arguments are conceptually the same as accumulators with `=/2` as the joiner function.

**Compilation flags:**

`dynamic`

**Template:**

`pass_info(Argument)`

**Mode and number of proofs:**

`pass_info(?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

###### `op(1200,xfx,-->>)`

**Scope:**

`public`

### events")

**object**

#### `after_event_registry`

After events registry predicates.

**Availability:**

`logtalk_load(events(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2009-10-08

**Compilation flags:**

`static,`` ``context_switching_calls,`` ``events`

**Implements:**

`public` event_registryp

**Remarks:**

(none)

**Inherited public predicates:**

 del_monitors/0  del_monitors/4  monitor/1  monitor/4  monitored/1  monitors/1  set_monitor/4

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

before_event_registry, monitorp

**object**

#### `before_event_registry`

Before events registry predicates.

**Availability:**

`logtalk_load(events(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2009-10-08

**Compilation flags:**

`static,`` ``context_switching_calls,`` ``events`

**Implements:**

`public` event_registryp

**Remarks:**

(none)

**Inherited public predicates:**

 del_monitors/0  del_monitors/4  monitor/1  monitor/4  monitored/1  monitors/1  set_monitor/4

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

after_event_registry, monitorp

**object**

#### `event_registry`

Before and after events registry predicates.

**Availability:**

`logtalk_load(events(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2009-10-08

**Compilation flags:**

`static,`` ``context_switching_calls,`` ``events`

**Implements:**

`public` event_registryp

**Remarks:**

(none)

**Inherited public predicates:**

 del_monitors/0  del_monitors/4  monitor/1  monitor/4  monitored/1  monitors/1  set_monitor/4

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `event_registryp`

Event registry protocol.

**Availability:**

`logtalk_load(events(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2009-10-08

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `monitors/1`

  - `monitor/1`

  - `monitored/1`

  - `monitor/4`

  - `set_monitor/4`

  - `del_monitors/4`

  - `del_monitors/0`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `monitors/1`

Returns a list of all current monitors.

**Compilation flags:**

`static`

**Template:**

`monitors(Monitors)`

**Mode and number of proofs:**

`monitors(-list(object_identifier))` - `one`

------------------------------------------------------------------------

###### `monitor/1`

Monitor is an object playing the role of a monitor.

**Compilation flags:**

`static`

**Template:**

`monitor(Monitor)`

**Mode and number of proofs:**

`monitor(-object_identifier)` - `zero_or_more`

`monitor(+object_identifier)` - `zero_or_one`

------------------------------------------------------------------------

###### `monitored/1`

Returns a list of all currently monitored objects.

**Compilation flags:**

`static`

**Template:**

`monitored(Objects)`

**Mode and number of proofs:**

`monitored(-list(object_identifier))` - `one`

------------------------------------------------------------------------

###### `monitor/4`

True if the arguments describe a currently defined monitored event.

**Compilation flags:**

`static`

**Template:**

`monitor(Object,Message,Sender,Monitor)`

**Mode and number of proofs:**

`monitor(?object_identifier,?nonvar,?object_identifier,?object_identifier)` - `zero_or_more`

------------------------------------------------------------------------

###### `set_monitor/4`

Sets a monitor for the set of matching events.

**Compilation flags:**

`static`

**Template:**

`set_monitor(Object,Message,Sender,Monitor)`

**Mode and number of proofs:**

`set_monitor(?object_identifier,?nonvar,?object_identifier,+object_identifier)` - `zero_or_one`

------------------------------------------------------------------------

###### `del_monitors/4`

Deletes all matching monitored events.

**Compilation flags:**

`static`

**Template:**

`del_monitors(Object,Message,Sender,Monitor)`

**Mode and number of proofs:**

`del_monitors(?object_identifier,?nonvar,?object_identifier,?object_identifier)` - `one`

------------------------------------------------------------------------

###### `del_monitors/0`

Deletes all monitored events.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`del_monitors` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

event_registry, monitorp

**category**

#### `monitor`

Monitor predicates.

**Availability:**

`logtalk_load(events(loader))`

**Author:** Paulo Moura

**Version:** 1:3:0

**Date:** 2019-03-08

**Compilation flags:**

`static,`` ``events`

**Implements:**

`public` monitorp

**Remarks:**

(none)

**Inherited public predicates:**

 activate_monitor/0  del_spy_points/4  monitor_activated/0  reset_monitor/0  set_spy_point/4  spy_point/4  suspend_monitor/0

- Public predicates

- Protected predicates

- Private predicates

  - `spy_point_/4`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `spy_point_/4`

Stores current spy points.

**Compilation flags:**

`dynamic`

**Template:**

`spy_point_(Event,Object,Message,Sender)`

**Mode and number of proofs:**

`spy_point_(?event,?object,?callable,?object)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**protocol**

#### `monitorp`

Monitor protocol.

**Availability:**

`logtalk_load(events(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2000-07-24

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `monitor_activated/0`

  - `activate_monitor/0`

  - `suspend_monitor/0`

  - `reset_monitor/0`

  - `spy_point/4`

  - `set_spy_point/4`

  - `del_spy_points/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `monitor_activated/0`

True if monitor is currently active.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`monitor_activated` - `zero_or_one`

------------------------------------------------------------------------

###### `activate_monitor/0`

Activates all spy points and start monitoring.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`activate_monitor` - `one`

------------------------------------------------------------------------

###### `suspend_monitor/0`

Suspends monitoring, deactivating all spy points.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`suspend_monitor` - `one`

------------------------------------------------------------------------

###### `reset_monitor/0`

Resets monitor, deactivating and deleting all spy points.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`reset_monitor` - `one`

------------------------------------------------------------------------

###### `spy_point/4`

Current spy point.

**Compilation flags:**

`static`

**Template:**

`spy_point(Event,Object,Message,Sender)`

**Mode and number of proofs:**

`spy_point(?event,?object,?callable,?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `set_spy_point/4`

Sets a spy point.

**Compilation flags:**

`static`

**Template:**

`set_spy_point(Event,Object,Message,Sender)`

**Mode and number of proofs:**

`set_spy_point(?event,?object,?callable,?object)` - `one`

------------------------------------------------------------------------

###### `del_spy_points/4`

Deletes all matching spy points.

**Compilation flags:**

`static`

**Template:**

`del_spy_points(Event,Object,Message,Sender)`

**Mode and number of proofs:**

`del_spy_points(@event,@object,@callable,@object)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

monitor, event_registryp

### expand_library_alias_paths")

**object**

#### `expand_library_alias_paths`

Hook object for expanding library alias paths in `logtalk_library_path/2` facts when compiling a source file.

**Availability:**

`logtalk_load(expand_library_alias_paths(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2018-04-12

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Uses:**

logtalk

os

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### expecteds")

**object**

#### `either`

Types and predicates for extended type-checking and handling of expected terms.

**Availability:**

`logtalk_load(expecteds(loader))`

**Author:** Paulo Moura

**Version:** 0:9:0

**Date:** 2025-06-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

type::type/1

type::check/2

arbitrary::arbitrary/1

arbitrary::arbitrary/2

arbitrary::shrinker/1

arbitrary::shrink/3

arbitrary::edge_case/2

**Uses:**

expected

expected(Expected)

random

type

**Remarks:**

> - Type-checking support: Defines a `either(ValueType,`` ``ErrorType)` type for checking expected terms where the value and error terms must be of the given types.
>
> - QuickCheck support: Defines clauses for the `type::arbitrary/1-2`, `arbitrary::shrinker/1`, `arbitrary::shrink/3`, and `arbitrary::edge_case/2` predicates to allow generating random values for the `either(ValueType,`` ``ErrorType)` type.

**Inherited public predicates:**

(none)

- Public predicates

  - `expecteds/2`

  - `unexpecteds/2`

  - `partition/3`

  - `sequence/2`

  - `traverse/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `expecteds/2`

Returns the values stored in the expected terms that hold a value.

**Compilation flags:**

`static`

**Template:**

`expecteds(Expecteds,Values)`

**Mode and number of proofs:**

`expecteds(+list(expected),-list)` - `one`

------------------------------------------------------------------------

###### `unexpecteds/2`

Returns the errors stored in the expected terms that hold an error.

**Compilation flags:**

`static`

**Template:**

`unexpecteds(Expecteds,Errors)`

**Mode and number of proofs:**

`unexpecteds(+list(expected),-list)` - `one`

------------------------------------------------------------------------

###### `partition/3`

Retrieves and partitions the values and errors hold by the expected terms.

**Compilation flags:**

`static`

**Template:**

`partition(Expecteds,Values,Errors)`

**Mode and number of proofs:**

`partition(+list(expected),-list,-list)` - `one`

------------------------------------------------------------------------

###### `sequence/2`

Returns an expected term with a list of all values when all expected terms hold values. Otherwise returns the first expected term holding an error.

**Compilation flags:**

`static`

**Template:**

`sequence(Expecteds,Expected)`

**Mode and number of proofs:**

`sequence(+list(expected),--nonvar)` - `one`

------------------------------------------------------------------------

###### `traverse/3`

Applies a closure to each list element to generate expected terms and then sequences them into a single expected term holding all values or the first error.

**Compilation flags:**

`static`

**Template:**

`traverse(Closure,Terms,Expected)`

**Meta-predicate template:**

`traverse(2,*,*)`

**Mode and number of proofs:**

`traverse(+callable,+list,--nonvar)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

expected, expected(Expected), type, arbitrary

**object**

#### `expected`

Constructors for expected terms. An expected term contains either a value or an error. Expected terms should be regarded as opaque terms and always used with the `expected/1` object by passing the expected term as a parameter.

**Availability:**

`logtalk_load(expecteds(loader))`

**Author:** Paulo Moura

**Version:** 2:2:0

**Date:** 2026-02-21

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

type::type/1

type::check/2

**Remarks:**

> - Type-checking support: This object also defines a type `expected` for use with the `type` library object.

**Inherited public predicates:**

(none)

- Public predicates

  - `of_unexpected/2`

  - `of_expected/2`

  - `from_goal/4`

  - `from_goal/3`

  - `from_goal/2`

  - `from_generator/4`

  - `from_generator/3`

  - `from_generator/2`

  - `from_optional/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `of_unexpected/2`

Constructs an expected term from an error that represent that the expected value is missing.

**Compilation flags:**

`static`

**Template:**

`of_unexpected(Error,Expected)`

**Mode and number of proofs:**

`of_unexpected(@term,--nonvar)` - `one`

------------------------------------------------------------------------

###### `of_expected/2`

Constructs an expected term from an expected value.

**Compilation flags:**

`static`

**Template:**

`of_expected(Value,Expected)`

**Mode and number of proofs:**

`of_expected(@term,--nonvar)` - `one`

------------------------------------------------------------------------

###### `from_goal/4`

Constructs an expected term holding a value bound by calling the given goal. Otherwise returns an expected term with the unexpected goal error or failure represented by the `Error` argument.

**Compilation flags:**

`static`

**Template:**

`from_goal(Goal,Value,Error,Expected)`

**Meta-predicate template:**

`from_goal(0,*,*,*)`

**Mode and number of proofs:**

`from_goal(+callable,--term,@term,--nonvar)` - `one`

------------------------------------------------------------------------

###### `from_goal/3`

Constructs an expected term holding a value bound by calling the given goal. Otherwise returns an expected term with the unexpected goal error or the atom `fail` representing the unexpected failure.

**Compilation flags:**

`static`

**Template:**

`from_goal(Goal,Value,Expected)`

**Meta-predicate template:**

`from_goal(0,*,*)`

**Mode and number of proofs:**

`from_goal(+callable,--term,--nonvar)` - `one`

------------------------------------------------------------------------

###### `from_goal/2`

Constructs an expected term holding a value bound by calling the given closure. Otherwise returns an expected term holding the unexpected closure error or the atom `fail` representing the unexpected failure.

**Compilation flags:**

`static`

**Template:**

`from_goal(Closure,Expected)`

**Meta-predicate template:**

`from_goal(1,*)`

**Mode and number of proofs:**

`from_goal(+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `from_generator/4`

Constructs expected terms with the values generated by calling the given goal. On goal error or failure, returns an expected term with the unexpected goal error or failure represented by the `Error` argument.

**Compilation flags:**

`static`

**Template:**

`from_generator(Goal,Value,Error,Expected)`

**Meta-predicate template:**

`from_generator(0,*,*,*)`

**Mode and number of proofs:**

`from_generator(+callable,--term,@term,--nonvar)` - `one_or_more`

------------------------------------------------------------------------

###### `from_generator/3`

Constructs expected terms with the values generated by calling the given goal. On goal error or failure, returns an expected term with, respectively, the unexpected goal error or the atom `fail` representing the unexpected goal failure.

**Compilation flags:**

`static`

**Template:**

`from_generator(Goal,Value,Expected)`

**Meta-predicate template:**

`from_generator(0,*,*)`

**Mode and number of proofs:**

`from_generator(+callable,--term,--nonvar)` - `one_or_more`

------------------------------------------------------------------------

###### `from_generator/2`

Constructs expected terms with the values generated by calling the given closure. On closure error or failure, returns an expected term with, respectively, the unexpected closure error or the atom `fail` representing the unexpected closure failure.

**Compilation flags:**

`static`

**Template:**

`from_generator(Closure,Expected)`

**Meta-predicate template:**

`from_generator(1,*)`

**Mode and number of proofs:**

`from_generator(+callable,--nonvar)` - `one_or_more`

------------------------------------------------------------------------

###### `from_optional/3`

Converts an optional term to an expected term. Returns an expected term holding the value if the optional term is not empty. Returns an expected term with the given error otherwise.

**Compilation flags:**

`static`

**Template:**

`from_optional(Optional,Error,Expected)`

**Mode and number of proofs:**

`from_optional(+nonvar,@term,--nonvar)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

expected(Expected), type

**object**

#### `expected(Expected)`

Expected term predicates. Requires passing an expected term (constructed using the `expected` object predicates) as a parameter.

**Availability:**

`logtalk_load(expecteds(loader))`

**Author:** Paulo Moura

**Version:** 1:6:0

**Date:** 2026-02-21

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `is_expected/0`

  - `is_unexpected/0`

  - `if_expected/1`

  - `if_unexpected/1`

  - `if_expected_or_else/2`

  - `unexpected/1`

  - `expected/1`

  - `map/2`

  - `flat_map/2`

  - `either/3`

  - `or_else/2`

  - `or_else_get/2`

  - `or_else_call/2`

  - `or_else_throw/1`

  - `or_else_fail/1`

  - `filter/3`

  - `map_unexpected/2`

  - `map_catching/2`

  - `map_both/3`

  - `swap/1`

  - `map_or_else/3`

  - `or/2`

  - `or_else_throw/2`

  - `zip/3`

  - `to_optional/1`

  - `flatten/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `is_expected/0`

True if the expected term holds a value. See also the `if_expected/1` predicate.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`is_expected` - `zero_or_one`

------------------------------------------------------------------------

###### `is_unexpected/0`

True if the expected term holds an error. See also the `if_unexpected/1` predicate.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`is_unexpected` - `zero_or_one`

------------------------------------------------------------------------

###### `if_expected/1`

Applies a closure when the expected term holds a value using the value as argument. Succeeds otherwise.

**Compilation flags:**

`static`

**Template:**

`if_expected(Closure)`

**Meta-predicate template:**

`if_expected(1)`

**Mode and number of proofs:**

`if_expected(+callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `if_unexpected/1`

Applies a closure when the expected term holds an error using the error as argument. Succeeds otherwise. Can be used to throw the exception hold by the expected term by calling it the atom `throw`.

**Compilation flags:**

`static`

**Template:**

`if_unexpected(Closure)`

**Meta-predicate template:**

`if_unexpected(1)`

**Mode and number of proofs:**

`if_unexpected(+callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `if_expected_or_else/2`

Applies either `ExpectedClosure` or `UnexpectedClosure` depending on the expected term holding a value or an error.

**Compilation flags:**

`static`

**Template:**

`if_expected_or_else(ExpectedClosure,UnexpectedClosure)`

**Meta-predicate template:**

`if_expected_or_else(1,1)`

**Mode and number of proofs:**

`if_expected_or_else(+callable,+callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `unexpected/1`

Returns the error hold by the expected term. Throws an error otherwise.

**Compilation flags:**

`static`

**Template:**

`unexpected(Error)`

**Mode and number of proofs:**

`unexpected(--term)` - `one_or_error`

**Exceptions:**

Expected term holds a value:

`existence_error(unexpected_error,Expected)`

------------------------------------------------------------------------

###### `expected/1`

Returns the value hold by the expected term. Throws an error otherwise.

**Compilation flags:**

`static`

**Template:**

`expected(Value)`

**Mode and number of proofs:**

`expected(--term)` - `one_or_error`

**Exceptions:**

Expected term holds an error:

`existence_error(expected_value,Expected)`

------------------------------------------------------------------------

###### `map/2`

When the expected term does not hold an error and mapping a closure with the expected value and the new value as additional arguments is successful, returns an expected term with the new value. Otherwise returns the same expected term.

**Compilation flags:**

`static`

**Template:**

`map(Closure,NewExpected)`

**Meta-predicate template:**

`map(2,*)`

**Mode and number of proofs:**

`map(+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `flat_map/2`

When the expected term does not hold an error and mapping a closure with the expected value and the new expected term as additional arguments is successful, returns the new expected term. Otherwise returns the same expected term.

**Compilation flags:**

`static`

**Template:**

`flat_map(Closure,NewExpected)`

**Meta-predicate template:**

`flat_map(2,*)`

**Mode and number of proofs:**

`flat_map(+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `either/3`

Applies either `ExpectedClosure` if the expected term holds a value or `UnexpectedClosure` if the expected term holds an error. Returns a new expected term if the applied closure is successful. Otherwise returns the same expected term.

**Compilation flags:**

`static`

**Template:**

`either(ExpectedClosure,UnexpectedClosure,NewExpected)`

**Meta-predicate template:**

`either(2,2,*)`

**Mode and number of proofs:**

`either(+callable,+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `or_else/2`

Returns the value hold by the expected term if it does not hold an error or the given default term if the expected term holds an error.

**Compilation flags:**

`static`

**Template:**

`or_else(Value,Default)`

**Mode and number of proofs:**

`or_else(--term,@term)` - `one`

------------------------------------------------------------------------

###### `or_else_get/2`

Returns the value hold by the expected term if it does not hold an error. Otherwise applies a closure to compute the expected value. Throws an error when the expected term holds an error and a value cannot be computed.

**Compilation flags:**

`static`

**Template:**

`or_else_get(Value,Closure)`

**Meta-predicate template:**

`or_else_get(*,1)`

**Mode and number of proofs:**

`or_else_get(--term,+callable)` - `one_or_error`

**Exceptions:**

Expected term holds an unexpected error and an expected value cannot be computed:

`existence_error(expected_value,Expected)`

------------------------------------------------------------------------

###### `or_else_call/2`

Returns the value hold by the expected term if it does not hold an error. Calls a goal deterministically otherwise.

**Compilation flags:**

`static`

**Template:**

`or_else_call(Value,Goal)`

**Meta-predicate template:**

`or_else_call(*,0)`

**Mode and number of proofs:**

`or_else_call(--term,+callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `or_else_throw/1`

Returns the value hold by the expected term if present. Throws the error hold by the expected term as an exception otherwise.

**Compilation flags:**

`static`

**Template:**

`or_else_throw(Value)`

**Mode and number of proofs:**

`or_else_throw(--term)` - `one_or_error`

------------------------------------------------------------------------

###### `or_else_fail/1`

Returns the value hold by the expected term if it does not hold an error. Fails otherwise. Usually called to skip over expected terms holding errors.

**Compilation flags:**

`static`

**Template:**

`or_else_fail(Value)`

**Mode and number of proofs:**

`or_else_fail(--term)` - `zero_or_one`

------------------------------------------------------------------------

###### `filter/3`

When the expected term holds a value and the value satisfies the closure, returns the same expected term. When the expected term holds a value that does not satisfy the closure, returns an expected term with the given error. When the expected term holds an error, returns the same expected term.

**Compilation flags:**

`static`

**Template:**

`filter(Closure,Error,NewExpected)`

**Meta-predicate template:**

`filter(1,*,*)`

**Mode and number of proofs:**

`filter(+callable,@term,--nonvar)` - `one`

------------------------------------------------------------------------

###### `map_unexpected/2`

When the expected term holds an error and mapping a closure with the error and the new error as additional arguments is successful, returns an expected term with the new error. Otherwise returns the same expected term.

**Compilation flags:**

`static`

**Template:**

`map_unexpected(Closure,NewExpected)`

**Meta-predicate template:**

`map_unexpected(2,*)`

**Mode and number of proofs:**

`map_unexpected(+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `map_catching/2`

When the expected term holds a value, applies a closure to it. Returns an expected term with the new value if the closure succeeds. Returns an expected term with the error if the closure throws an error. Returns an expected term with the atom `fail` as error if the closure fails. When the expected term holds an error, returns the same expected term.

**Compilation flags:**

`static`

**Template:**

`map_catching(Closure,NewExpected)`

**Meta-predicate template:**

`map_catching(2,*)`

**Mode and number of proofs:**

`map_catching(+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `map_both/3`

When the expected term holds a value and mapping `ExpectedClosure` with the value is successful, returns an expected term with the new value. When the expected term holds an error and mapping `UnexpectedClosure` with the error is successful, returns an expected term with the new error. Otherwise returns the same expected term.

**Compilation flags:**

`static`

**Template:**

`map_both(ExpectedClosure,UnexpectedClosure,NewExpected)`

**Meta-predicate template:**

`map_both(2,2,*)`

**Mode and number of proofs:**

`map_both(+callable,+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `swap/1`

Swaps the expected and unexpected terms. If the expected term holds a value, returns an unexpected term with that value. If the expected term holds an error, returns an expected term with that error.

**Compilation flags:**

`static`

**Template:**

`swap(NewExpected)`

**Mode and number of proofs:**

`swap(--nonvar)` - `one`

------------------------------------------------------------------------

###### `map_or_else/3`

When the expected term holds a value and mapping a closure with the value and the new value as additional arguments is successful, returns the new value. Otherwise returns the given default value.

**Compilation flags:**

`static`

**Template:**

`map_or_else(Closure,Default,Value)`

**Meta-predicate template:**

`map_or_else(2,*,*)`

**Mode and number of proofs:**

`map_or_else(+callable,@term,--term)` - `one`

------------------------------------------------------------------------

###### `or/2`

Returns the same expected term if it holds a value. Otherwise calls closure to generate a new expected term. Fails if the expected term holds an error and calling the closure fails or throws an error.

**Compilation flags:**

`static`

**Template:**

`or(NewExpected,Closure)`

**Meta-predicate template:**

`or(*,1)`

**Mode and number of proofs:**

`or(--term,@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `or_else_throw/2`

Returns the value hold by the expected term if present. Throws the given error otherwise, ignoring any error hold by the expected term.

**Compilation flags:**

`static`

**Template:**

`or_else_throw(Value,Error)`

**Mode and number of proofs:**

`or_else_throw(--term,@nonvar)` - `one_or_error`

------------------------------------------------------------------------

###### `zip/3`

When both this expected and the other expected hold values and applying a closure with both values and the new value as additional arguments is successful, returns an expected term with the new value. Otherwise returns the first expected term that holds an error.

**Compilation flags:**

`static`

**Template:**

`zip(Closure,OtherExpected,NewExpected)`

**Meta-predicate template:**

`zip(3,*,*)`

**Mode and number of proofs:**

`zip(+callable,+nonvar,--nonvar)` - `one`

------------------------------------------------------------------------

###### `to_optional/1`

Converts the expected term to an optional term. Returns a non-empty optional term holding the value if the expected term holds a value. Returns an empty optional term if the expected term holds an error.

**Compilation flags:**

`static`

**Template:**

`to_optional(Optional)`

**Mode and number of proofs:**

`to_optional(--nonvar)` - `one`

------------------------------------------------------------------------

###### `flatten/1`

Flattens a nested expected term. When the expected term holds a value that is itself an expected term, returns the inner expected term. When the expected term holds a non-expected value, returns the same expected term. When the expected term holds an error, returns the same expected term.

**Compilation flags:**

`static`

**Template:**

`flatten(NewExpected)`

**Mode and number of proofs:**

`flatten(--nonvar)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

expected

### fcube")

**object**

#### `fcube`

FCube: An Efficient Prover for Intuitionistic Propositional Logic.

**Availability:**

`logtalk_load(fcube(loader))`

**Author:** Mauro Ferrari, Camillo Fiorentini, Guido Fiorino; ported to Logtalk by Paulo Moura.

**Version:** 5:0:1

**Date:** 2024-03-14

**Copyright:** Copyright 2012 Mauro Ferrari, Camillo Fiorentini, Guido Fiorino; Copyright 2020-2024 Paulo Moura

**License:** GPL-2.0-or-later

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

integer

list

os

set

user

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `gnu/0`

  - `fcube/0`

  - `decide/1`

  - `decide/2`

- Protected predicates

- Private predicates

- Operators

  - `op(1200,xfy,<=>)`

  - `op(1110,xfy,=>)`

  - `op(1000,xfy,&&)`

  - `op(500,fy,~)`

  - `op(1100,xfy,v)`

##### Public predicates

###### `gnu/0`

Prints banner with copyright and license information.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`gnu` - `one`

------------------------------------------------------------------------

###### `fcube/0`

Reads a formula and applies the prover to it, printing its counter-model.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`fcube` - `one`

------------------------------------------------------------------------

###### `decide/1`

Applies the prover to the given formula and prints its counter-model.

**Compilation flags:**

`static`

**Template:**

`decide(Formula)`

**Mode and number of proofs:**

`decide(++compound)` - `one`

------------------------------------------------------------------------

###### `decide/2`

Applies the prover to the given formula and returns its counter-model.

**Compilation flags:**

`static`

**Template:**

`decide(Formula,CounterModel)`

**Mode and number of proofs:**

`decide(++compound,--compound)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

###### `op(1200,xfy,<=>)`

**Scope:**

`public`

###### `op(1110,xfy,=>)`

**Scope:**

`public`

###### `op(1000,xfy,&&)`

**Scope:**

`public`

###### `op(500,fy,~)`

**Scope:**

`public`

###### `op(1100,xfy,v)`

**Scope:**

`public`

### flags")

**category**

#### `flags`

Implementation of persistent object flags.

**Availability:**

`logtalk_load(flags(loader))`

**Author:** Theofrastos Mantadelis

**Version:** 1:0:0

**Date:** 2010-11-27

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `get_flag_value/2`

  - `set_flag_value/2`

  - `set_flag_value/3`

  - `reset_flags/0`

  - `reset_flags/1`

  - `flag_groups/1`

  - `flag_group_chk/1`

  - `print_flags/0`

  - `print_flags/1`

  - `defined_flag/6`

  - `built_in_flag/2`

- Protected predicates

  - `unsafe_set_flag_value/2`

  - `define_flag/1`

  - `define_flag/2`

- Private predicates

  - `defined_flag_/6`

  - `flag_value_/2`

  - `validate/3`

  - `validate_type/1`

  - `is_validator/1`

- Operators

##### Public predicates

###### `get_flag_value/2`

Gets or tests the value of a flag.

**Compilation flags:**

`static`

**Template:**

`get_flag_value(Flag,Value)`

**Mode and number of proofs:**

`get_flag_value(+atom,?nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `set_flag_value/2`

Sets the value of a flag.

**Compilation flags:**

`static`

**Template:**

`set_flag_value(Flag,NewValue)`

**Mode and number of proofs:**

`set_flag_value(+atom,@nonvar)` - `one`

------------------------------------------------------------------------

###### `set_flag_value/3`

Sets the value of a flag, returning the old value.

**Compilation flags:**

`static`

**Template:**

`set_flag_value(Flag,OldValue,NewValue)`

**Mode and number of proofs:**

`set_flag_value(+atom,?nonvar,@nonvar)` - `one`

------------------------------------------------------------------------

###### `reset_flags/0`

Resets all flags to their default values.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`reset_flags` - `one`

------------------------------------------------------------------------

###### `reset_flags/1`

Resets all flags in a group to their default values.

**Compilation flags:**

`static`

**Template:**

`reset_flags(Group)`

**Mode and number of proofs:**

`reset_flags(+atom)` - `one`

------------------------------------------------------------------------

###### `flag_groups/1`

Returns a list of all flag groups.

**Compilation flags:**

`static`

**Template:**

`flag_groups(Groups)`

**Mode and number of proofs:**

`flag_groups(-list(atom))` - `one`

------------------------------------------------------------------------

###### `flag_group_chk/1`

Checks if a given atom is a flag group.

**Compilation flags:**

`static`

**Template:**

`flag_group_chk(Group)`

**Mode and number of proofs:**

`flag_group_chk(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `print_flags/0`

Prints a listing of all flags.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`print_flags` - `one`

------------------------------------------------------------------------

###### `print_flags/1`

Prints a listing of all flags in a group.

**Compilation flags:**

`static`

**Template:**

`print_flags(Group)`

**Mode and number of proofs:**

`print_flags(+atom)` - `one`

------------------------------------------------------------------------

###### `defined_flag/6`

Gets or test the existing (visible) flag definitions.

**Compilation flags:**

`static`

**Template:**

`defined_flag(Flag,Group,Type,DefaultValue,Description,Access)`

**Mode and number of proofs:**

`defined_flag(?atom,?atom,?nonvar,?nonvar,?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `built_in_flag/2`

True if the argument is a built-in flag type with the specified default value.

**Compilation flags:**

`static`

**Template:**

`built_in_flag(Type,DefaultValue)`

**Mode and number of proofs:**

`built_in_flag(?atom,?nonvar)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

###### `unsafe_set_flag_value/2`

Sets the value of a flag without performing any validation checks.

**Compilation flags:**

`static`

**Template:**

`unsafe_set_flag_value(Flag,NewValue)`

**Mode and number of proofs:**

`unsafe_set_flag_value(+atom,@nonvar)` - `one`

------------------------------------------------------------------------

###### `define_flag/1`

Defines a new flag using default options.

**Compilation flags:**

`static`

**Template:**

`define_flag(Flag)`

**Mode and number of proofs:**

`define_flag(+atom)` - `one`

------------------------------------------------------------------------

###### `define_flag/2`

Defines a new flag using a given set of options (for example, \[group(general), type(nonvar), default(true), description(Flag), access(read_write)\]).

**Compilation flags:**

`static`

**Template:**

`define_flag(Flag,Options)`

**Mode and number of proofs:**

`define_flag(+atom,@list)` - `one`

------------------------------------------------------------------------

##### Private predicates

###### `defined_flag_/6`

Gets or test the existing flag definitions.

**Compilation flags:**

`dynamic`

**Template:**

`defined_flag_(Flag,Group,Type,DefaultValue,Description,Access)`

**Mode and number of proofs:**

`defined_flag_(?atom,?atom,?nonvar,?nonvar,?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `flag_value_/2`

Table of flag values.

**Compilation flags:**

`dynamic`

**Template:**

`flag_value_(Flag,Value)`

**Mode and number of proofs:**

`flag_value_(?atom,?nonvar)` - `zero_or_more`

------------------------------------------------------------------------

###### `validate/3`

**Compilation flags:**

`static`

------------------------------------------------------------------------

###### `validate_type/1`

**Compilation flags:**

`static`

------------------------------------------------------------------------

###### `is_validator/1`

**Compilation flags:**

`static`

------------------------------------------------------------------------

##### Operators

(none)

**protocol**

#### `flags_validator`

Flag validation protocol. Must be implemented by validator objects.

**Availability:**

`logtalk_load(flags(loader))`

**Author:** Theofrastos Mantadelis

**Version:** 1:0:0

**Date:** 2010-11-27

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `print_flags/0`

  - `validate/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `print_flags/0`

Validates the validator object itself.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`print_flags` - `zero_or_one`

------------------------------------------------------------------------

###### `validate/1`

Validates a flag value.

**Compilation flags:**

`static`

**Template:**

`validate(Value)`

**Mode and number of proofs:**

`validate(@term)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### format")

**object**

#### `format`

Formatted output predicates.

**Availability:**

`logtalk_load(format(loader))`

**Author:** Paulo Moura

**Version:** 1:3:0

**Date:** 2025-11-18

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `format/3`

  - `format/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `format/3`

Writes a list of arguments after a format specification to the specified output stream.

**Compilation flags:**

`static`

**Template:**

`format(Stream,Format,Arguments)`

**Mode and number of proofs:**

`format(@stream_or_alias,+atom,@list)` - `zero_or_one`

`format(@stream_or_alias,+list(character_code),@list)` - `zero_or_one`

`format(@stream_or_alias,+list(character),@list)` - `zero_or_one`

------------------------------------------------------------------------

###### `format/2`

Writes a list of arguments after a format specification to the current output stream.

**Compilation flags:**

`static`

**Template:**

`format(Format,Arguments)`

**Mode and number of proofs:**

`format(+atom,@list)` - `zero_or_one`

`format(+list(character_code),@list)` - `zero_or_one`

`format(+list(character),@list)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### genint")

**object**

#### `genint`

Global object for generating increasing non-negative integers for named counters. The predicates are declared as synchronized when the library is compiled using a backend supporting threads.

**Availability:**

`logtalk_load(genint(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2022-07-21

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` genint_core

**Remarks:**

(none)

**Inherited public predicates:**

 genint/2  reset_genint/0  reset_genint/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `genint_core`

Predicates for generating increasing non-negative integers. The predicates are declared as synchronized when the library is compiled using a backend supporting threads.

**Availability:**

`logtalk_load(genint(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2022-07-26

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `reset_genint/0`

  - `reset_genint/1`

  - `genint/2`

- Protected predicates

- Private predicates

  - `counter_/2`

- Operators

##### Public predicates

###### `reset_genint/0`

Resets all counters.

**Compilation flags:**

`static,`` ``synchronized`

**Mode and number of proofs:**

`reset_genint` - `one`

------------------------------------------------------------------------

###### `reset_genint/1`

Resets the given counter.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`reset_genint(Counter)`

**Mode and number of proofs:**

`reset_genint(+atom)` - `one`

------------------------------------------------------------------------

###### `genint/2`

Returns the next integer for a given counter.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`genint(Counter,Integer)`

**Mode and number of proofs:**

`genint(+atom,-non_negative_integer)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

###### `counter_/2`

Table of current state of counters.

**Compilation flags:**

`dynamic`

**Template:**

`counter_(Counter,Latest)`

**Mode and number of proofs:**

`counter_(?atom,?non_negative_integer)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

### gensym")

**object**

#### `gensym`

Global object for generating unique atoms. The predicates are declared as synchronized when the library is compiled using a backend supporting threads.

**Availability:**

`logtalk_load(gensym(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2022-07-21

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` gensym_core

**Remarks:**

(none)

**Inherited public predicates:**

 gensym/2  reset_gensym/0  reset_gensym/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `gensym_core`

Predicates for generating unique atoms. Protocol based on the `gensym` module of SWI-Prolog. The predicates are declared as synchronized when the library is compiled using a backend supporting threads.

**Availability:**

`logtalk_load(gensym(loader))`

**Author:** Paulo Moura

**Version:** 2:1:0

**Date:** 2022-07-26

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `reset_gensym/0`

  - `reset_gensym/1`

  - `gensym/2`

- Protected predicates

- Private predicates

  - `base_/2`

- Operators

##### Public predicates

###### `reset_gensym/0`

Resets the generator counter for all bases.

**Compilation flags:**

`static,`` ``synchronized`

**Mode and number of proofs:**

`reset_gensym` - `one`

------------------------------------------------------------------------

###### `reset_gensym/1`

Resets the generator counter for a given base.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`reset_gensym(Base)`

**Mode and number of proofs:**

`reset_gensym(+atom)` - `one`

------------------------------------------------------------------------

###### `gensym/2`

Returns a new unique atom with a given base (prefix).

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`gensym(Base,Unique)`

**Mode and number of proofs:**

`gensym(+atom,-atom)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

###### `base_/2`

Table of generator bases and respective counters.

**Compilation flags:**

`dynamic`

**Template:**

`base_(Base,Counter)`

**Mode and number of proofs:**

`base_(?atom,?integer)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

### geospatial")

**object**

#### `geospatial`

Geospatial predicates over geographic coordinates represented as `(Latitude,Longitude)`.

**Availability:**

`logtalk_load(geospatial(loader))`

**Author:** Paulo Moura

**Version:** 0:2:0

**Date:** 2026-02-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` geospatial_protocol

**Uses:**

list

**Remarks:**

> - Distance unit: Kilometers.
>
> - Coordinate ranges: Latitude values must be in the `[-90.0,90.0]` range and longitude values in the `[-180.0,180.0]` range.

**Inherited public predicates:**

 along_track_distance/4  bbox_contains/2  bbox_expand/3  bbox_from_coordinates/2  bbox_intersects/2  bbox_union/3  bounding_box/3  clockwise_polygon/2  close_polygon/2  coordinates_bounding_box/2  counterclockwise_polygon/2  cross_track_distance/4  destination_point/4  equirectangular_inverse/4  equirectangular_projection/4  final_bearing/3  haversine_distance/3  initial_bearing/3  interpolate_great_circle/4  interpolate_rhumb/4  is_clockwise_polygon/1  is_valid_polygon/1  mean_center/2  midpoint/3  minimum_enclosing_circle/3  nearest_coordinate/5  nearest_point_on_polyline/4  nearest_point_on_segment/4  normalize_coordinate/2  normalize_polygon_orientation/3  point_in_polygon/2  point_to_polyline_distance/3  polygon_area/2  polygon_bounding_box/2  polygon_centroid/2  polygon_orientation/2  polygon_perimeter/2  polygon_perimeter/3  polygons_intersect/2  polyline_length/2  polyline_length/3  polyline_resample/3  polyline_simplify/3  polyline_split_at_distance/4  rhumb_bearing/3  rhumb_destination_point/4  rhumb_distance/3  rhumb_midpoint/3  route_distance/2  route_distance/3  route_distance/4  valid_coordinate/1  vincenty_distance/3  within_distance/4

- Public predicates

  - `distance/4`

  - `distance/5`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `distance/4`

Computes the distance in kilometers between two coordinates using a selected metric. Supported metrics are `haversine`, `vincenty`, and `rhumb`.

**Compilation flags:**

`static`

**Template:**

`distance(Coordinate1,Coordinate2,Metric,Distance)`

**Mode and number of proofs:**

`distance(+compound,+compound,+atom,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `distance/5`

Computes the distance between two coordinates using a selected metric and output unit. Supported metrics are `haversine`, `vincenty`, and `rhumb`. Valid `Unit` argument values are `kilometers`, `meters`, `miles`, and `nautical_miles`.

**Compilation flags:**

`static`

**Template:**

`distance(Coordinate1,Coordinate2,Metric,Unit,Distance)`

**Mode and number of proofs:**

`distance(+compound,+compound,+atom,+atom,-float)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

geospatial_protocol, numberlist

**protocol**

#### `geospatial_protocol`

Geospatial predicates protocol.

**Availability:**

`logtalk_load(geospatial(loader))`

**Author:** Paulo Moura

**Version:** 0:2:0

**Date:** 2026-02-25

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `valid_coordinate/1`

  - `normalize_coordinate/2`

  - `equirectangular_projection/4`

  - `equirectangular_inverse/4`

  - `haversine_distance/3`

  - `vincenty_distance/3`

  - `rhumb_distance/3`

  - `rhumb_bearing/3`

  - `rhumb_destination_point/4`

  - `interpolate_rhumb/4`

  - `rhumb_midpoint/3`

  - `distance/4`

  - `distance/5`

  - `initial_bearing/3`

  - `final_bearing/3`

  - `midpoint/3`

  - `destination_point/4`

  - `interpolate_great_circle/4`

  - `cross_track_distance/4`

  - `along_track_distance/4`

  - `within_distance/4`

  - `nearest_coordinate/5`

  - `mean_center/2`

  - `minimum_enclosing_circle/3`

  - `coordinates_bounding_box/2`

  - `point_in_polygon/2`

  - `polygon_area/2`

  - `polygon_centroid/2`

  - `polygon_bounding_box/2`

  - `close_polygon/2`

  - `polygon_orientation/2`

  - `is_clockwise_polygon/1`

  - `normalize_polygon_orientation/3`

  - `clockwise_polygon/2`

  - `counterclockwise_polygon/2`

  - `is_valid_polygon/1`

  - `bbox_contains/2`

  - `bbox_intersects/2`

  - `bbox_union/3`

  - `bbox_expand/3`

  - `bbox_from_coordinates/2`

  - `point_to_polyline_distance/3`

  - `nearest_point_on_segment/4`

  - `nearest_point_on_polyline/4`

  - `polyline_length/2`

  - `polyline_length/3`

  - `polyline_simplify/3`

  - `polyline_split_at_distance/4`

  - `polyline_resample/3`

  - `polygon_perimeter/2`

  - `polygon_perimeter/3`

  - `polygons_intersect/2`

  - `bounding_box/3`

  - `route_distance/2`

  - `route_distance/3`

  - `route_distance/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `valid_coordinate/1`

True if the argument is a valid geographic coordinate represented as `(Latitude,Longitude)` with latitude in the `[-90.0,90.0]` range and longitude in the `[-180.0,180.0]` range.

**Compilation flags:**

`static`

**Template:**

`valid_coordinate(Coordinate)`

**Mode and number of proofs:**

`valid_coordinate(@compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `normalize_coordinate/2`

Normalizes a coordinate by wrapping longitude to the `[-180.0,180.0]` range and reflecting latitude over the poles when necessary.

**Compilation flags:**

`static`

**Template:**

`normalize_coordinate(Coordinate,NormalizedCoordinate)`

**Mode and number of proofs:**

`normalize_coordinate(+compound,-compound)` - `one`

------------------------------------------------------------------------

###### `equirectangular_projection/4`

Projects a coordinate to local equirectangular planar coordinates in kilometers using a reference latitude in degrees.

**Compilation flags:**

`static`

**Template:**

`equirectangular_projection(Coordinate,ReferenceLatitude,X,Y)`

**Mode and number of proofs:**

`equirectangular_projection(+compound,+float,-float,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `equirectangular_inverse/4`

Converts local equirectangular planar coordinates in kilometers to a geographic coordinate using a reference latitude in degrees.

**Compilation flags:**

`static`

**Template:**

`equirectangular_inverse(X,Y,ReferenceLatitude,Coordinate)`

**Mode and number of proofs:**

`equirectangular_inverse(+float,+float,+float,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `haversine_distance/3`

Computes the great-circle distance in kilometers between two coordinates using the Haversine formula.

**Compilation flags:**

`static`

**Template:**

`haversine_distance(Coordinate1,Coordinate2,Distance)`

**Mode and number of proofs:**

`haversine_distance(+compound,+compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `vincenty_distance/3`

Computes the geodesic distance in kilometers between two coordinates using the Vincenty inverse formula over the WGS84 ellipsoid. Fails if the iterative method does not converge.

**Compilation flags:**

`static`

**Template:**

`vincenty_distance(Coordinate1,Coordinate2,Distance)`

**Mode and number of proofs:**

`vincenty_distance(+compound,+compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `rhumb_distance/3`

Computes the rhumb-line (loxodrome) distance in kilometers between two coordinates on a spherical Earth model.

**Compilation flags:**

`static`

**Template:**

`rhumb_distance(Coordinate1,Coordinate2,Distance)`

**Mode and number of proofs:**

`rhumb_distance(+compound,+compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `rhumb_bearing/3`

Computes the rhumb-line initial bearing in degrees in the `[0.0,360.0[` range from the first coordinate to the second coordinate.

**Compilation flags:**

`static`

**Template:**

`rhumb_bearing(Coordinate1,Coordinate2,Bearing)`

**Mode and number of proofs:**

`rhumb_bearing(+compound,+compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `rhumb_destination_point/4`

Computes the destination coordinate from a start coordinate, a rhumb-line bearing in degrees, and a distance in kilometers on a spherical Earth model.

**Compilation flags:**

`static`

**Template:**

`rhumb_destination_point(Start,Bearing,Distance,Destination)`

**Mode and number of proofs:**

`rhumb_destination_point(+compound,+float,+float,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `interpolate_rhumb/4`

Computes an intermediate coordinate along the rhumb-line path between two coordinates using a fraction in the `[0.0,1.0]` range.

**Compilation flags:**

`static`

**Template:**

`interpolate_rhumb(Coordinate1,Coordinate2,Fraction,Coordinate)`

**Mode and number of proofs:**

`interpolate_rhumb(+compound,+compound,+float,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `rhumb_midpoint/3`

Computes the midpoint along the rhumb-line path between two coordinates.

**Compilation flags:**

`static`

**Template:**

`rhumb_midpoint(Coordinate1,Coordinate2,Midpoint)`

**Mode and number of proofs:**

`rhumb_midpoint(+compound,+compound,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `distance/4`

Computes the distance in kilometers between two coordinates using a selected metric. Supported metrics are `haversine`, `vincenty`, and `rhumb`.

**Compilation flags:**

`static`

**Template:**

`distance(Coordinate1,Coordinate2,Metric,Distance)`

**Mode and number of proofs:**

`distance(+compound,+compound,+atom,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `distance/5`

Computes the distance between two coordinates using a selected metric and output unit. Supported metrics are `haversine`, `vincenty`, and `rhumb`. Valid `Unit` argument values are `kilometers`, `meters`, `miles`, and `nautical_miles`.

**Compilation flags:**

`static`

**Template:**

`distance(Coordinate1,Coordinate2,Metric,Unit,Distance)`

**Mode and number of proofs:**

`distance(+compound,+compound,+atom,+atom,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `initial_bearing/3`

Computes the initial bearing in degrees in the `[0.0,360.0[` range from the first coordinate to the second coordinate.

**Compilation flags:**

`static`

**Template:**

`initial_bearing(Coordinate1,Coordinate2,Bearing)`

**Mode and number of proofs:**

`initial_bearing(+compound,+compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `final_bearing/3`

Computes the final bearing in degrees in the `[0.0,360.0[` range when arriving at the second coordinate from the first coordinate.

**Compilation flags:**

`static`

**Template:**

`final_bearing(Coordinate1,Coordinate2,Bearing)`

**Mode and number of proofs:**

`final_bearing(+compound,+compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `midpoint/3`

Computes the geographic midpoint between two coordinates using a spherical Earth model.

**Compilation flags:**

`static`

**Template:**

`midpoint(Coordinate1,Coordinate2,Midpoint)`

**Mode and number of proofs:**

`midpoint(+compound,+compound,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `destination_point/4`

Computes the destination coordinate from a start coordinate, an initial bearing in degrees, and a distance in kilometers using a spherical Earth model.

**Compilation flags:**

`static`

**Template:**

`destination_point(Start,Bearing,Distance,Destination)`

**Mode and number of proofs:**

`destination_point(+compound,+float,+float,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `interpolate_great_circle/4`

Computes an intermediate coordinate along the great-circle path between two coordinates using a fraction in the `[0.0,1.0]` range.

**Compilation flags:**

`static`

**Template:**

`interpolate_great_circle(Coordinate1,Coordinate2,Fraction,Coordinate)`

**Mode and number of proofs:**

`interpolate_great_circle(+compound,+compound,+float,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `cross_track_distance/4`

Computes the signed cross-track distance in kilometers from a coordinate to the great-circle path defined by a start and end coordinate.

**Compilation flags:**

`static`

**Template:**

`cross_track_distance(Coordinate,Start,End,Distance)`

**Mode and number of proofs:**

`cross_track_distance(+compound,+compound,+compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `along_track_distance/4`

Computes the along-track distance in kilometers from the start coordinate to the closest point to a coordinate on the great-circle path defined by a start and end coordinate.

**Compilation flags:**

`static`

**Template:**

`along_track_distance(Coordinate,Start,End,Distance)`

**Mode and number of proofs:**

`along_track_distance(+compound,+compound,+compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `within_distance/4`

True when the distance between two coordinates is less than or equal to the given radius in kilometers using the selected metric.

**Compilation flags:**

`static`

**Template:**

`within_distance(Coordinate1,Coordinate2,Radius,Metric)`

**Mode and number of proofs:**

`within_distance(+compound,+compound,+float,+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `nearest_coordinate/5`

Finds the nearest coordinate to the origin coordinate in a list using the selected metric, returning the nearest coordinate and distance in kilometers.

**Compilation flags:**

`static`

**Template:**

`nearest_coordinate(Origin,Coordinates,Metric,Nearest,Distance)`

**Mode and number of proofs:**

`nearest_coordinate(+compound,+list(compound),+atom,-compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `mean_center/2`

Computes the arithmetic mean center of a list of one or more coordinates.

**Compilation flags:**

`static`

**Template:**

`mean_center(Coordinates,Center)`

**Mode and number of proofs:**

`mean_center(+list(compound),-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `minimum_enclosing_circle/3`

Computes an approximate minimum enclosing circle for a list of one or more coordinates, returning the circle center coordinate and radius in kilometers.

**Compilation flags:**

`static`

**Template:**

`minimum_enclosing_circle(Coordinates,Center,Radius)`

**Mode and number of proofs:**

`minimum_enclosing_circle(+list(compound),-compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `coordinates_bounding_box/2`

Computes the axis-aligned latitude/longitude bounding box for a list of one or more coordinates.

**Compilation flags:**

`static`

**Template:**

`coordinates_bounding_box(Coordinates,BoundingBox)`

**Mode and number of proofs:**

`coordinates_bounding_box(+list(compound),-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `point_in_polygon/2`

True when a coordinate is inside (or on the boundary of) a polygon represented as a list of coordinates. Uses a planar ray-casting algorithm over latitude/longitude coordinates.

**Compilation flags:**

`static`

**Template:**

`point_in_polygon(Point,Polygon)`

**Mode and number of proofs:**

`point_in_polygon(+compound,+list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `polygon_area/2`

Computes an approximate polygon area in square kilometers by projecting coordinates to a local equirectangular plane and applying the shoelace formula.

**Compilation flags:**

`static`

**Template:**

`polygon_area(Polygon,Area)`

**Mode and number of proofs:**

`polygon_area(+list(compound),-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `polygon_centroid/2`

Computes an approximate polygon centroid by using a local equirectangular projection and planar centroid formula.

**Compilation flags:**

`static`

**Template:**

`polygon_centroid(Polygon,Centroid)`

**Mode and number of proofs:**

`polygon_centroid(+list(compound),-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `polygon_bounding_box/2`

Computes the axis-aligned latitude/longitude bounding box for a polygon represented as a list of coordinates.

**Compilation flags:**

`static`

**Template:**

`polygon_bounding_box(Polygon,BoundingBox)`

**Mode and number of proofs:**

`polygon_bounding_box(+list(compound),-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `close_polygon/2`

Returns a closed polygon ring by ensuring the first coordinate is repeated at the end of the list.

**Compilation flags:**

`static`

**Template:**

`close_polygon(Polygon,ClosedPolygon)`

**Mode and number of proofs:**

`close_polygon(+list(compound),-list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `polygon_orientation/2`

Computes polygon ring orientation as `clockwise` or `counterclockwise` using a local projected signed area approximation.

**Compilation flags:**

`static`

**Template:**

`polygon_orientation(Polygon,Orientation)`

**Mode and number of proofs:**

`polygon_orientation(+list(compound),-atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_clockwise_polygon/1`

True when a polygon ring orientation is clockwise.

**Compilation flags:**

`static`

**Template:**

`is_clockwise_polygon(Polygon)`

**Mode and number of proofs:**

`is_clockwise_polygon(+list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `normalize_polygon_orientation/3`

Normalizes a polygon ring orientation to `clockwise` or `counterclockwise`.

**Compilation flags:**

`static`

**Template:**

`normalize_polygon_orientation(Polygon,Orientation,OrientedPolygon)`

**Mode and number of proofs:**

`normalize_polygon_orientation(+list(compound),+atom,-list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `clockwise_polygon/2`

Returns a polygon ring with clockwise orientation.

**Compilation flags:**

`static`

**Template:**

`clockwise_polygon(Polygon,ClockwisePolygon)`

**Mode and number of proofs:**

`clockwise_polygon(+list(compound),-list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `counterclockwise_polygon/2`

Returns a polygon ring with counterclockwise orientation.

**Compilation flags:**

`static`

**Template:**

`counterclockwise_polygon(Polygon,CounterclockwisePolygon)`

**Mode and number of proofs:**

`counterclockwise_polygon(+list(compound),-list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `is_valid_polygon/1`

True when a polygon has at least three valid coordinates after normalizing optional closure.

**Compilation flags:**

`static`

**Template:**

`is_valid_polygon(Polygon)`

**Mode and number of proofs:**

`is_valid_polygon(+list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `bbox_contains/2`

True when a coordinate is inside or on the boundary of a bounding box term `bbox((MinLatitude,MinLongitude),(MaxLatitude,MaxLongitude))`.

**Compilation flags:**

`static`

**Template:**

`bbox_contains(BoundingBox,Coordinate)`

**Mode and number of proofs:**

`bbox_contains(+compound,+compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `bbox_intersects/2`

True when two bounding boxes intersect or touch.

**Compilation flags:**

`static`

**Template:**

`bbox_intersects(BoundingBox1,BoundingBox2)`

**Mode and number of proofs:**

`bbox_intersects(+compound,+compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `bbox_union/3`

Computes the minimal bounding box containing two bounding boxes.

**Compilation flags:**

`static`

**Template:**

`bbox_union(BoundingBox1,BoundingBox2,BoundingBox)`

**Mode and number of proofs:**

`bbox_union(+compound,+compound,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `bbox_expand/3`

Expands a bounding box by a distance in kilometers on all sides using a local spherical approximation.

**Compilation flags:**

`static`

**Template:**

`bbox_expand(BoundingBox,Distance,ExpandedBoundingBox)`

**Mode and number of proofs:**

`bbox_expand(+compound,+number,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `bbox_from_coordinates/2`

Computes a bounding box from a list of one or more coordinates.

**Compilation flags:**

`static`

**Template:**

`bbox_from_coordinates(Coordinates,BoundingBox)`

**Mode and number of proofs:**

`bbox_from_coordinates(+list(compound),-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `point_to_polyline_distance/3`

Computes the minimum distance in kilometers from a coordinate to a polyline with two or more coordinates.

**Compilation flags:**

`static`

**Template:**

`point_to_polyline_distance(Point,Polyline,Distance)`

**Mode and number of proofs:**

`point_to_polyline_distance(+compound,+list(compound),-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `nearest_point_on_segment/4`

Computes the nearest coordinate on a segment to a coordinate using a local equirectangular approximation.

**Compilation flags:**

`static`

**Template:**

`nearest_point_on_segment(Point,SegmentStart,SegmentEnd,NearestPoint)`

**Mode and number of proofs:**

`nearest_point_on_segment(+compound,+compound,+compound,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `nearest_point_on_polyline/4`

Computes the nearest coordinate on a polyline to a coordinate and the corresponding distance in kilometers.

**Compilation flags:**

`static`

**Template:**

`nearest_point_on_polyline(Point,Polyline,NearestPoint,Distance)`

**Mode and number of proofs:**

`nearest_point_on_polyline(+compound,+list(compound),-compound,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `polyline_length/2`

Computes the polyline length in kilometers for a list of two or more coordinates using the default `haversine` metric.

**Compilation flags:**

`static`

**Template:**

`polyline_length(Coordinates,Length)`

**Mode and number of proofs:**

`polyline_length(+list(compound),-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `polyline_length/3`

Computes the polyline length in kilometers for a list of two or more coordinates using the selected metric.

**Compilation flags:**

`static`

**Template:**

`polyline_length(Coordinates,Metric,Length)`

**Mode and number of proofs:**

`polyline_length(+list(compound),+atom,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `polyline_simplify/3`

Simplifies a polyline using the Douglas-Peucker algorithm with a tolerance in kilometers.

**Compilation flags:**

`static`

**Template:**

`polyline_simplify(Coordinates,Tolerance,SimplifiedCoordinates)`

**Mode and number of proofs:**

`polyline_simplify(+list(compound),+number,-list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `polyline_split_at_distance/4`

Splits a polyline at a distance in kilometers from its first coordinate, returning left and right polylines that share the split coordinate.

**Compilation flags:**

`static`

**Template:**

`polyline_split_at_distance(Coordinates,Distance,LeftCoordinates,RightCoordinates)`

**Mode and number of proofs:**

`polyline_split_at_distance(+list(compound),+number,-list(compound),-list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `polyline_resample/3`

Resamples a polyline using a fixed step in kilometers, preserving first and last coordinates.

**Compilation flags:**

`static`

**Template:**

`polyline_resample(Coordinates,Step,ResampledCoordinates)`

**Mode and number of proofs:**

`polyline_resample(+list(compound),+number,-list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `polygon_perimeter/2`

Computes the polygon perimeter in kilometers using the default `haversine` metric.

**Compilation flags:**

`static`

**Template:**

`polygon_perimeter(Polygon,Perimeter)`

**Mode and number of proofs:**

`polygon_perimeter(+list(compound),-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `polygon_perimeter/3`

Computes the polygon perimeter in kilometers using the selected metric.

**Compilation flags:**

`static`

**Template:**

`polygon_perimeter(Polygon,Metric,Perimeter)`

**Mode and number of proofs:**

`polygon_perimeter(+list(compound),+atom,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `polygons_intersect/2`

True when two polygons intersect or one polygon is contained in the other.

**Compilation flags:**

`static`

**Template:**

`polygons_intersect(Polygon1,Polygon2)`

**Mode and number of proofs:**

`polygons_intersect(+list(compound),+list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `bounding_box/3`

Computes a spherical bounding box around a center coordinate for a given radius in kilometers. The returned bounding box term is `bbox((MinLatitude,MinLongitude),(MaxLatitude,MaxLongitude))`.

**Compilation flags:**

`static`

**Template:**

`bounding_box(Center,Radius,BoundingBox)`

**Mode and number of proofs:**

`bounding_box(+compound,+positive_number,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `route_distance/2`

Computes the route distance in kilometers for a list of two or more coordinates using the default `haversine` metric.

**Compilation flags:**

`static`

**Template:**

`route_distance(Coordinates,Distance)`

**Mode and number of proofs:**

`route_distance(+list(compound),-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `route_distance/3`

Computes the route distance in kilometers for a list of two or more coordinates using the selected metric. Supported metrics are `haversine`, `vincenty`, and `rhumb`.

**Compilation flags:**

`static`

**Template:**

`route_distance(Coordinates,Metric,Distance)`

**Mode and number of proofs:**

`route_distance(+list(compound),+atom,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `route_distance/4`

Computes the route distance for a list of two or more coordinates using the selected metric and output unit. Supported metrics are `haversine`, `vincenty`, and `rhumb`. Valid `Unit` argument values are `kilometers`, `meters`, `miles`, and `nautical_miles`.

**Compilation flags:**

`static`

**Template:**

`route_distance(Coordinates,Metric,Unit,Distance)`

**Mode and number of proofs:**

`route_distance(+list(compound),+atom,+atom,-float)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

geospatial, numberlistp, listp

### git")

**object**

#### `git`

Predicates for accessing a git project current branch and latest commit data.

**Availability:**

`logtalk_load(git(loader))`

**Author:** Paulo Moura

**Version:** 2:1:2

**Date:** 2024-03-11

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` git_protocol

**Uses:**

os

user

**Remarks:**

(none)

**Inherited public predicates:**

 branch/2  commit_author/2  commit_date/2  commit_hash/2  commit_hash_abbreviated/2  commit_log/3  commit_message/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `git_protocol`

Predicates for accessing a git project current branch and latest commit data.

**Availability:**

`logtalk_load(git(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2022-01-21

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `branch/2`

  - `commit_author/2`

  - `commit_date/2`

  - `commit_hash/2`

  - `commit_hash_abbreviated/2`

  - `commit_message/2`

  - `commit_log/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `branch/2`

Returns the name of the current git branch. Fails if the directory is not a git repo or a sub-directory of a git repo directory.

**Compilation flags:**

`static`

**Template:**

`branch(Directory,Branch)`

**Mode and number of proofs:**

`branch(+atom,?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `commit_author/2`

Returns the latest commit author. Fails if the directory is not a git repo or a sub-directory of a git repo directory.

**Compilation flags:**

`static`

**Template:**

`commit_author(Directory,Author)`

**Mode and number of proofs:**

`commit_author(+atom,-atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `commit_date/2`

Returns the latest commit date (strict ISO 8601 format). Fails if the directory is not a git repo or a sub-directory of a git repo directory.

**Compilation flags:**

`static`

**Template:**

`commit_date(Directory,Date)`

**Mode and number of proofs:**

`commit_date(+atom,-atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `commit_hash/2`

Returns the latest commit hash. Fails if the directory is not a git repo or a sub-directory of a git repo directory.

**Compilation flags:**

`static`

**Template:**

`commit_hash(Directory,Hash)`

**Mode and number of proofs:**

`commit_hash(+atom,-atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `commit_hash_abbreviated/2`

Returns the latest commit abbreviated hash. Fails if the directory is not a git repo or a sub-directory of a git repo directory.

**Compilation flags:**

`static`

**Template:**

`commit_hash_abbreviated(Directory,Hash)`

**Mode and number of proofs:**

`commit_hash_abbreviated(+atom,-atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `commit_message/2`

Returns the latest commit message. Fails if the directory is not a git repo or a sub-directory of a git repo directory.

**Compilation flags:**

`static`

**Template:**

`commit_message(Directory,Message)`

**Mode and number of proofs:**

`commit_message(+atom,-atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `commit_log/3`

Returns the git latest commit log output for the given format (see e.g. https://git-scm.com/docs/pretty-formats). Fails if the directory is not a git repo or a sub-directory of a git repo directory.

**Compilation flags:**

`static`

**Template:**

`commit_log(Directory,Format,Output)`

**Mode and number of proofs:**

`commit_log(+atom,+atom,-atom)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### grammars")

**object**

#### `blank_grammars(Format)`

Blank grammars.

**Availability:**

`logtalk_load(grammars(loader))`

**Author:** Paulo Moura

**Version:** 0:4:0

**Date:** 2025-10-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `white_space//0`

  - `white_spaces//0`

  - `space//0`

  - `spaces//0`

  - `tab//0`

  - `tabs//0`

  - `new_line//0`

  - `new_lines//0`

  - `blank//0`

  - `blanks//0`

  - `non_blank//1`

  - `non_blanks//1`

  - `control//0`

  - `controls//0`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `white_space//0`

Consumes a single space or tab.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`white_space` - `zero_or_one`

------------------------------------------------------------------------

###### `white_spaces//0`

Consumes zero or more spaces and tabs.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`white_spaces` - `one`

------------------------------------------------------------------------

###### `space//0`

Consumes a single space.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`space` - `zero_or_one`

------------------------------------------------------------------------

###### `spaces//0`

Consumes zero or more spaces.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`spaces` - `one`

------------------------------------------------------------------------

###### `tab//0`

Consumes a single tab.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`tab` - `zero_or_one`

------------------------------------------------------------------------

###### `tabs//0`

Consumes zero or more tabs.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`tabs` - `one`

------------------------------------------------------------------------

###### `new_line//0`

Consumes a single new line.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`new_line` - `zero_or_one`

------------------------------------------------------------------------

###### `new_lines//0`

Consumes zero or more new lines.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`new_lines` - `one`

------------------------------------------------------------------------

###### `blank//0`

Consumes a single space, tab, vertical tab, line feed, or new line.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`blank` - `zero_or_one`

------------------------------------------------------------------------

###### `blanks//0`

Consumes zero or more spaces, tabs, vertical tabs, line feeds, or new lines.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`blanks` - `one`

------------------------------------------------------------------------

###### `non_blank//1`

Returns a single non-blank character or character code.

**Compilation flags:**

`static`

**Template:**

`non_blank(NonBlank)`

**Mode and number of proofs:**

`non_blank(-atomic)` - `zero_or_one`

------------------------------------------------------------------------

###### `non_blanks//1`

Returns a (possibly empty) list of non-blank characters or character codes.

**Compilation flags:**

`static`

**Template:**

`non_blanks(NonBlanks)`

**Mode and number of proofs:**

`non_blanks(-list(atomic))` - `one`

------------------------------------------------------------------------

###### `control//0`

Consumes a single control character or character code. Support for the null control character depends on the Prolog backend.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`control` - `zero_or_one`

------------------------------------------------------------------------

###### `controls//0`

Consumes zero or more control characters or character codes. Support for the null control character depends on the Prolog backend.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`controls` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**object**

#### `ip_grammars(Format)`

IP address grammars.

**Availability:**

`logtalk_load(grammars(loader))`

**Author:** Paulo Moura

**Version:** 0:2:0

**Date:** 2025-10-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

number_grammars(Format)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `ipv4//1`

  - `ipv6//1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `ipv4//1`

Parses an IPv4 network address in the format XXX.XXX.XXX.XXX where each XXX is an octet (i.e., an integer between 0 and 255).

**Compilation flags:**

`static`

**Template:**

`ipv4(Octets)`

**Mode and number of proofs:**

`ipv4(?list(integer))` - `zero_or_one`

------------------------------------------------------------------------

###### `ipv6//1`

Parses an IPv6 network address in the format XXXX.XXXX.XXXX.XXXX.XXXX.XXXX.XXXX.XXXX where each X is a hexadecimal digit.

**Compilation flags:**

`static`

**Template:**

`ipv6(HexDigits)`

**Mode and number of proofs:**

`ipv6(?list(integer))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `number_grammars(Format)`

Number grammars.

**Availability:**

`logtalk_load(grammars(loader))`

**Author:** Paulo Moura

**Version:** 0:3:0

**Date:** 2025-10-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `bit//1`

  - `bits//1`

  - `digit//1`

  - `digits//1`

  - `hex_digit//1`

  - `hex_digits//1`

  - `natural//1`

  - `integer//1`

  - `float//1`

  - `number//1`

  - `sign//1`

  - `dot//1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `bit//1`

Parses a single bit.

**Compilation flags:**

`static`

**Template:**

`bit(Bit)`

**Mode and number of proofs:**

`bit(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `bits//1`

Parses a sequence of one or more bits.

**Compilation flags:**

`static`

**Template:**

`bits(Bits)`

**Mode and number of proofs:**

`bits(?list(integer))` - `zero_or_one`

------------------------------------------------------------------------

###### `digit//1`

Parses a single decimal digit.

**Compilation flags:**

`static`

**Template:**

`digit(Digit)`

**Mode and number of proofs:**

`digit(?atomic)` - `zero_or_one`

------------------------------------------------------------------------

###### `digits//1`

Parses a sequence of zero of more digits.

**Compilation flags:**

`static`

**Template:**

`digits(Digits)`

**Mode and number of proofs:**

`digits(?list(atomic))` - `one`

------------------------------------------------------------------------

###### `hex_digit//1`

Parses a single hexa-decimal digit.

**Compilation flags:**

`static`

**Template:**

`hex_digit(HexDigit)`

**Mode and number of proofs:**

`hex_digit(?atomic)` - `zero_or_one`

------------------------------------------------------------------------

###### `hex_digits//1`

Parses a sequence of zero or more hexa-decimal digits.

**Compilation flags:**

`static`

**Template:**

`hex_digits(HexDigits)`

**Mode and number of proofs:**

`hex_digits(?list(atomic))` - `one`

------------------------------------------------------------------------

###### `natural//1`

Parses a natural number (a non signed integer).

**Compilation flags:**

`static`

**Template:**

`natural(Natural)`

**Mode and number of proofs:**

`natural(?non_negative_integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `integer//1`

Parses an integer.

**Compilation flags:**

`static`

**Template:**

`integer(Integer)`

**Mode and number of proofs:**

`integer(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `float//1`

Parses a float.

**Compilation flags:**

`static`

**Template:**

`float(Float)`

**Mode and number of proofs:**

`float(?float)` - `zero_or_one`

------------------------------------------------------------------------

###### `number//1`

Parses a number (an integer or a float).

**Compilation flags:**

`static`

**Template:**

`number(Number)`

**Mode and number of proofs:**

`number(?number)` - `zero_or_one`

------------------------------------------------------------------------

###### `sign//1`

Parses a number sign (plus or minus).

**Compilation flags:**

`static`

**Template:**

`sign(Sign)`

**Mode and number of proofs:**

`sign(?atomic)` - `zero_or_one`

------------------------------------------------------------------------

###### `dot//1`

Parses a decimal dot.

**Compilation flags:**

`static`

**Template:**

`dot(Dot)`

**Mode and number of proofs:**

`dot(?atomic)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `sequence_grammars`

Sequence grammars.

**Availability:**

`logtalk_load(grammars(loader))`

**Author:** Paulo Moura

**Version:** 0:4:0

**Date:** 2025-10-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `zero_or_more//2`

  - `one_or_more//2`

  - `zero_or_more//1`

  - `one_or_more//1`

  - `zero_or_more//0`

  - `one_or_more//0`

  - `without//2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `zero_or_more//2`

Eagerly collect zero or more terminals that satisfy the given closure.

**Compilation flags:**

`static`

**Template:**

`zero_or_more(Closure,Terminals)`

**Meta-predicate template:**

`zero_or_more(1,*)`

**Mode and number of proofs:**

`zero_or_more(+callable,-list(atomic))` - `one`

------------------------------------------------------------------------

###### `one_or_more//2`

Eagerly collect one or more terminals that satisfy the given closure.

**Compilation flags:**

`static`

**Template:**

`one_or_more(Closure,Terminals)`

**Meta-predicate template:**

`one_or_more(1,*)`

**Mode and number of proofs:**

`one_or_more(+callable,-list(atomic))` - `zero_or_one`

------------------------------------------------------------------------

###### `zero_or_more//1`

Eagerly collect zero or more terminals.

**Compilation flags:**

`static`

**Template:**

`zero_or_more(Terminals)`

**Mode and number of proofs:**

`zero_or_more(-list(atomic))` - `one`

------------------------------------------------------------------------

###### `one_or_more//1`

Eagerly collect one or more terminals.

**Compilation flags:**

`static`

**Template:**

`one_or_more(Terminals)`

**Mode and number of proofs:**

`one_or_more(-list(atomic))` - `zero_or_one`

------------------------------------------------------------------------

###### `zero_or_more//0`

Eagerly parse zero or more terminals.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`zero_or_more` - `one`

------------------------------------------------------------------------

###### `one_or_more//0`

Eagerly parse one or more terminals.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`one_or_more` - `zero_or_one`

------------------------------------------------------------------------

###### `without//2`

Collects input terminals until one of the stop terminals is found. The stop terminals are excluded from the collected terminals.

**Compilation flags:**

`static`

**Template:**

`without(StopTerminals,Terminals)`

**Mode and number of proofs:**

`without(+list(atomic),-list(atomic))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### graphs")

**category**

#### `directed_graph_common`

Common directed graph predicates shared by directed graph objects. Uses self-dispatch to call object-specific predicates and avltree for internal bookkeeping.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-25

**Compilation flags:**

`static`

**Implements:**

`public` directed_graph_protocol

**Extends:**

`public` graph_common

**Uses:**

avltree

list

**Remarks:**

(none)

**Inherited public predicates:**

 add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  cycle/2  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edges/2  empty/1  has_cycle/1  has_path/3  in_degree/3  is_acyclic/1  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  out_degree/3  path/3  reachable/3  strongly_connected_components/2  symmetric_closure/2  topological_sort/2  transitive_closure/2  transpose/2  vertices/2  weakly_connected_components/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `directed_graph_protocol`

Protocol for directed graph predicates such as transpose, closures, topological sorting, degree queries, and strongly connected components.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-25

**Compilation flags:**

`static`

**Extends:**

`public` graph_protocol

**Remarks:**

(none)

**Inherited public predicates:**

 add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edges/2  empty/1  has_path/3  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2

- Public predicates

  - `transpose/2`

  - `transitive_closure/2`

  - `symmetric_closure/2`

  - `topological_sort/2`

  - `in_degree/3`

  - `out_degree/3`

  - `is_acyclic/1`

  - `has_cycle/1`

  - `cycle/2`

  - `strongly_connected_components/2`

  - `weakly_connected_components/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `transpose/2`

Unifies `NewGraph` with a graph obtained by reversing all edges.

**Compilation flags:**

`static`

**Template:**

`transpose(Graph,NewGraph)`

**Mode and number of proofs:**

`transpose(+graph,-graph)` - `one`

------------------------------------------------------------------------

###### `transitive_closure/2`

Generates the transitive closure of the graph.

**Compilation flags:**

`static`

**Template:**

`transitive_closure(Graph,Closure)`

**Mode and number of proofs:**

`transitive_closure(+graph,-graph)` - `one`

------------------------------------------------------------------------

###### `symmetric_closure/2`

Generates the symmetric closure of the graph.

**Compilation flags:**

`static`

**Template:**

`symmetric_closure(Graph,Closure)`

**Mode and number of proofs:**

`symmetric_closure(+graph,-graph)` - `one`

------------------------------------------------------------------------

###### `topological_sort/2`

Unifies `Sorted` with a topological sort of the vertices in the graph. Assumes the graph is a DAG.

**Compilation flags:**

`static`

**Template:**

`topological_sort(Graph,Sorted)`

**Mode and number of proofs:**

`topological_sort(+graph,-list(vertex))` - `one`

------------------------------------------------------------------------

###### `in_degree/3`

Unifies `Degree` with the number of incoming edges to `Vertex`. Fails if `Vertex` is not in the graph.

**Compilation flags:**

`static`

**Template:**

`in_degree(Vertex,Graph,Degree)`

**Mode and number of proofs:**

`in_degree(+vertex,+graph,-integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `out_degree/3`

Unifies `Degree` with the number of outgoing edges from `Vertex`. Fails if `Vertex` is not in the graph.

**Compilation flags:**

`static`

**Template:**

`out_degree(Vertex,Graph,Degree)`

**Mode and number of proofs:**

`out_degree(+vertex,+graph,-integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_acyclic/1`

True iff the graph is a directed acyclic graph (DAG).

**Compilation flags:**

`static`

**Template:**

`is_acyclic(Graph)`

**Mode and number of proofs:**

`is_acyclic(+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `has_cycle/1`

True iff the graph contains at least one directed cycle.

**Compilation flags:**

`static`

**Template:**

`has_cycle(Graph)`

**Mode and number of proofs:**

`has_cycle(+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `cycle/2`

Enumerates directed cycles as lists of vertices where the first and last vertices are the same.

**Compilation flags:**

`static`

**Template:**

`cycle(Graph,Cycle)`

**Mode and number of proofs:**

`cycle(+graph,-list(vertex))` - `zero_or_more`

------------------------------------------------------------------------

###### `strongly_connected_components/2`

Computes the strongly connected components of the graph using Tarjan’s algorithm. Each component is a sorted list of vertices. Components are returned in topological order.

**Compilation flags:**

`static`

**Template:**

`strongly_connected_components(Graph,SCCs)`

**Mode and number of proofs:**

`strongly_connected_components(+graph,-list(list(vertex)))` - `one`

------------------------------------------------------------------------

###### `weakly_connected_components/2`

Computes the weakly connected components of the graph by considering edge directions as undirected. Each component is returned as a sorted list of vertices.

**Compilation flags:**

`static`

**Template:**

`weakly_connected_components(Graph,Components)`

**Mode and number of proofs:**

`weakly_connected_components(+graph,-list(list(vertex)))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `graph_common`

Common graph predicates shared by all graph objects. Uses self-dispatch to call object-specific predicates such as `neighbors/3`, `vertices/2`, and `edges/2`.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-25

**Compilation flags:**

`static`

**Implements:**

`public` graph_protocol

**Uses:**

list

set

**Remarks:**

(none)

**Inherited public predicates:**

 add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edges/2  empty/1  has_path/3  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2

- Public predicates

- Protected predicates

  - `pairs_to_edges/2`

  - `vertex_neighbors_to_edges/4`

  - `wpairs_to_edges/2`

  - `wvertex_neighbors_to_edges/4`

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

###### `pairs_to_edges/2`

Converts a list of `Vertex-Neighbors` pairs from a dictionary into a flat list of `Vertex1-Vertex2` edges.

**Compilation flags:**

`static`

**Template:**

`pairs_to_edges(Pairs,Edges)`

**Mode and number of proofs:**

`pairs_to_edges(+list(pair),-list)` - `one`

------------------------------------------------------------------------

###### `vertex_neighbors_to_edges/4`

Converts a neighbor list for a vertex into edges using a difference list.

**Compilation flags:**

`static`

**Template:**

`vertex_neighbors_to_edges(Neighbors,Vertex,Edges,RestEdges)`

**Mode and number of proofs:**

`vertex_neighbors_to_edges(+list,+vertex,-list,-list)` - `one`

------------------------------------------------------------------------

###### `wpairs_to_edges/2`

Converts a list of `Vertex-WNeighbors` pairs from a dictionary into a flat list of `(Vertex1-Vertex2)-Weight` weighted edges.

**Compilation flags:**

`static`

**Template:**

`wpairs_to_edges(Pairs,Edges)`

**Mode and number of proofs:**

`wpairs_to_edges(+list(pair),-list)` - `one`

------------------------------------------------------------------------

###### `wvertex_neighbors_to_edges/4`

Converts a weighted neighbor list for a vertex into weighted edges using a difference list.

**Compilation flags:**

`static`

**Template:**

`wvertex_neighbors_to_edges(WNeighbors,Vertex,Edges,RestEdges)`

**Mode and number of proofs:**

`wvertex_neighbors_to_edges(+list,+vertex,-list,-list)` - `one`

------------------------------------------------------------------------

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `graph_protocol`

Common protocol for all types of graphs. Graphs are represented using a dictionary where keys are vertices and values are sorted lists of neighbors (implicitly defining edges).

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-25

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `new/1`

  - `new/2`

  - `new/3`

  - `empty/1`

  - `vertices/2`

  - `edges/2`

  - `add_vertex/3`

  - `add_vertices/3`

  - `delete_vertex/3`

  - `delete_vertices/3`

  - `add_edges/3`

  - `delete_edges/3`

  - `neighbors/3`

  - `reachable/3`

  - `breadth_first_order/3`

  - `depth_first_order/3`

  - `number_of_vertices/2`

  - `number_of_edges/2`

  - `path/3`

  - `has_path/3`

  - `min_path/5`

  - `max_path/5`

  - `min_distances/3`

  - `min_predecessors/3`

  - `all_pairs_min_paths/2`

  - `all_pairs_min_predecessors/2`

  - `is_complete/1`

  - `is_bipartite/1`

  - `is_sparse/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `new/1`

Creates a new empty graph.

**Compilation flags:**

`static`

**Template:**

`new(Graph)`

**Mode and number of proofs:**

`new(-graph)` - `one`

------------------------------------------------------------------------

###### `new/2`

Creates a new graph from a list of edges. Vertices are defined implicitly by edges.

**Compilation flags:**

`static`

**Template:**

`new(Edges,Graph)`

**Mode and number of proofs:**

`new(+list(edge),-graph)` - `one`

------------------------------------------------------------------------

###### `new/3`

Creates a new graph from a list of vertices and a list of edges. Vertices may also be defined implicitly by edges.

**Compilation flags:**

`static`

**Template:**

`new(Vertices,Edges,Graph)`

**Mode and number of proofs:**

`new(+list(vertex),+list(edge),-graph)` - `one`

------------------------------------------------------------------------

###### `empty/1`

True iff the given graph is empty.

**Compilation flags:**

`static`

**Template:**

`empty(Graph)`

**Mode and number of proofs:**

`empty(@graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `vertices/2`

Unifies `Vertices` with a sorted list of all vertices in the graph.

**Compilation flags:**

`static`

**Template:**

`vertices(Graph,Vertices)`

**Mode and number of proofs:**

`vertices(+graph,-list(vertex))` - `one`

------------------------------------------------------------------------

###### `edges/2`

Unifies `Edges` with a list of all edges in the graph.

**Compilation flags:**

`static`

**Template:**

`edges(Graph,Edges)`

**Mode and number of proofs:**

`edges(+graph,-list(edge))` - `one`

------------------------------------------------------------------------

###### `add_vertex/3`

Adds a vertex to the graph. If the vertex already exists, the graph is unchanged.

**Compilation flags:**

`static`

**Template:**

`add_vertex(Graph,Vertex,NewGraph)`

**Mode and number of proofs:**

`add_vertex(+graph,+vertex,-graph)` - `one`

------------------------------------------------------------------------

###### `add_vertices/3`

Adds a list of vertices to the graph.

**Compilation flags:**

`static`

**Template:**

`add_vertices(Graph,Vertices,NewGraph)`

**Mode and number of proofs:**

`add_vertices(+graph,+list(vertex),-graph)` - `one`

------------------------------------------------------------------------

###### `delete_vertex/3`

Deletes a vertex and all edges incident to it from the graph. If the vertex does not exist, the graph is unchanged.

**Compilation flags:**

`static`

**Template:**

`delete_vertex(Graph,Vertex,NewGraph)`

**Mode and number of proofs:**

`delete_vertex(+graph,+vertex,-graph)` - `one`

------------------------------------------------------------------------

###### `delete_vertices/3`

Deletes a list of vertices and all edges incident to them from the graph.

**Compilation flags:**

`static`

**Template:**

`delete_vertices(Graph,Vertices,NewGraph)`

**Mode and number of proofs:**

`delete_vertices(+graph,+list(vertex),-graph)` - `one`

------------------------------------------------------------------------

###### `add_edges/3`

Adds a list of edges to the graph. Vertices referenced by edges are added implicitly.

**Compilation flags:**

`static`

**Template:**

`add_edges(Graph,Edges,NewGraph)`

**Mode and number of proofs:**

`add_edges(+graph,+list(edge),-graph)` - `one`

------------------------------------------------------------------------

###### `delete_edges/3`

Deletes a list of edges from the graph. Vertices are not deleted. Non-existing edges are silently ignored.

**Compilation flags:**

`static`

**Template:**

`delete_edges(Graph,Edges,NewGraph)`

**Mode and number of proofs:**

`delete_edges(+graph,+list(edge),-graph)` - `one`

------------------------------------------------------------------------

###### `neighbors/3`

Unifies `Neighbors` with a sorted list of the neighbors of `Vertex` in the graph. Fails if `Vertex` is not in the graph.

**Compilation flags:**

`static`

**Template:**

`neighbors(Vertex,Graph,Neighbors)`

**Mode and number of proofs:**

`neighbors(+vertex,+graph,-list(vertex))` - `zero_or_one`

------------------------------------------------------------------------

###### `reachable/3`

Unifies `Vertices` with a sorted list of vertices reachable from `Vertex` (including `Vertex` itself). Fails if `Vertex` is not in the graph.

**Compilation flags:**

`static`

**Template:**

`reachable(Vertex,Graph,Vertices)`

**Mode and number of proofs:**

`reachable(+vertex,+graph,-list(vertex))` - `zero_or_one`

------------------------------------------------------------------------

###### `breadth_first_order/3`

Unifies `Vertices` with the breadth-first traversal order rooted at `Vertex`. Fails if `Vertex` is not in the graph.

**Compilation flags:**

`static`

**Template:**

`breadth_first_order(Vertex,Graph,Vertices)`

**Mode and number of proofs:**

`breadth_first_order(+vertex,+graph,-list(vertex))` - `zero_or_one`

------------------------------------------------------------------------

###### `depth_first_order/3`

Unifies `Vertices` with the depth-first traversal order rooted at `Vertex`. Fails if `Vertex` is not in the graph.

**Compilation flags:**

`static`

**Template:**

`depth_first_order(Vertex,Graph,Vertices)`

**Mode and number of proofs:**

`depth_first_order(+vertex,+graph,-list(vertex))` - `zero_or_one`

------------------------------------------------------------------------

###### `number_of_vertices/2`

Unifies `N` with the number of vertices in the graph.

**Compilation flags:**

`static`

**Template:**

`number_of_vertices(Graph,N)`

**Mode and number of proofs:**

`number_of_vertices(+graph,-integer)` - `one`

------------------------------------------------------------------------

###### `number_of_edges/2`

Unifies `N` with the number of edges in the graph.

**Compilation flags:**

`static`

**Template:**

`number_of_edges(Graph,N)`

**Mode and number of proofs:**

`number_of_edges(+graph,-integer)` - `one`

------------------------------------------------------------------------

###### `path/3`

Returns a maximal path (list of vertices) rooted at `Vertex`, enumerating different paths on backtracking. Fails if `Vertex` is not in the graph.

**Compilation flags:**

`static`

**Template:**

`path(Vertex,Graph,Path)`

**Mode and number of proofs:**

`path(+vertex,+graph,-list(vertex))` - `zero_or_more`

------------------------------------------------------------------------

###### `has_path/3`

True iff there is a path from `Vertex1` to `Vertex2` in the graph.

**Compilation flags:**

`static`

**Template:**

`has_path(Vertex1,Vertex2,Graph)`

**Mode and number of proofs:**

`has_path(+vertex,+vertex,+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `min_path/5`

Finds the minimum cost path from `Vertex1` to `Vertex2`. For unweighted graphs, cost is the number of edges. Fails if no path exists.

**Compilation flags:**

`static`

**Template:**

`min_path(Vertex1,Vertex2,Graph,Path,Cost)`

**Mode and number of proofs:**

`min_path(+vertex,+vertex,+graph,-list(vertex),-number)` - `zero_or_one`

------------------------------------------------------------------------

###### `max_path/5`

Finds the maximum cost acyclic path from `Vertex1` to `Vertex2`. For unweighted graphs, cost is the number of edges. Fails if no path exists.

**Compilation flags:**

`static`

**Template:**

`max_path(Vertex1,Vertex2,Graph,Path,Cost)`

**Mode and number of proofs:**

`max_path(+vertex,+vertex,+graph,-list(vertex),-number)` - `zero_or_one`

------------------------------------------------------------------------

###### `min_distances/3`

Computes minimum path costs from `Vertex` to all reachable vertices. Returns a list of `Target-Cost` pairs including `Vertex-0`.

**Compilation flags:**

`static`

**Template:**

`min_distances(Vertex,Graph,Distances)`

**Mode and number of proofs:**

`min_distances(+vertex,+graph,-list(pair))` - `zero_or_one`

------------------------------------------------------------------------

###### `min_predecessors/3`

Computes predecessor links for minimum paths rooted at `Vertex`. Returns a list of `Target-Predecessor` pairs; the source predecessor is `none`.

**Compilation flags:**

`static`

**Template:**

`min_predecessors(Vertex,Graph,Predecessors)`

**Mode and number of proofs:**

`min_predecessors(+vertex,+graph,-list(pair))` - `zero_or_one`

------------------------------------------------------------------------

###### `all_pairs_min_paths/2`

Computes minimum path costs for all ordered pairs of vertices with a path between them. Returns a list of `(Vertex1-Vertex2)-Cost` terms.

**Compilation flags:**

`static`

**Template:**

`all_pairs_min_paths(Graph,Pairs)`

**Mode and number of proofs:**

`all_pairs_min_paths(+graph,-list(pair))` - `one`

------------------------------------------------------------------------

###### `all_pairs_min_predecessors/2`

Computes predecessor links for minimum paths for all ordered source-target pairs with a path. Returns a list of `(Vertex1-Vertex2)-Predecessor` terms.

**Compilation flags:**

`static`

**Template:**

`all_pairs_min_predecessors(Graph,Pairs)`

**Mode and number of proofs:**

`all_pairs_min_predecessors(+graph,-list(pair))` - `one`

------------------------------------------------------------------------

###### `is_complete/1`

True iff every pair of distinct vertices in the graph is connected by an edge.

**Compilation flags:**

`static`

**Template:**

`is_complete(Graph)`

**Mode and number of proofs:**

`is_complete(+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_bipartite/1`

True iff the graph is bipartite, i.e. its vertices can be partitioned into two sets such that every edge connects a vertex in one set to a vertex in the other.

**Compilation flags:**

`static`

**Template:**

`is_bipartite(Graph)`

**Mode and number of proofs:**

`is_bipartite(+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_sparse/1`

True iff the graph is sparse, i.e. the number of edges is at most `|V|`` ``*`` ``log2(|V|)`. The cutoff `|E|`` ``=`` ``|V|`` ``*`` ``log2(|V|)` separates sparse graphs (where adjacency lists are efficient) from dense graphs (where adjacency matrix representations may be preferable).

**Compilation flags:**

`static`

**Template:**

`is_sparse(Graph)`

**Mode and number of proofs:**

`is_sparse(+graph)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**category**

#### `graph_types`

A set of graph related types and generators.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static`

**Provides:**

type::type/1

type::check/2

arbitrary::arbitrary/1

arbitrary::arbitrary/2

**Uses:**

integer

type

**Remarks:**

> - Provided types: This category adds `vertex`, `edge`, and `weighted_edge` types for type-checking when using the `type` library object.
>
> - Type `vertex`: Any non-variable term.
>
> - Type `edge`: An unweighted edge represented as a `V1-V2` pair of vertices.
>
> - Type `weighted_edge`: A weighted edge represented as `(V1-V2)-Weight` where `V1` and `V2` are vertices and `Weight` is a number.
>
> - Generating edges: Use the `edges(N,V0,V)` generator for unweighted edges or `weighted_edges(N,V0,V,W)` for weighted edges. `N` is the upper limit to the number of edges. `V0` and `V` must be positive integers and will be used for the range of vertices. `W` is the upper limit for edge weights (positive integers).

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `undirected_graph_common`

Common predicates shared by undirected graph objects. Uses self-dispatch to call object-specific predicates such as `is_connected/1`, `vertices/2`, `edges/2`, and `neighbors/3`.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-25

**Compilation flags:**

`static`

**Extends:**

`public` graph_common

**Uses:**

avltree

list

set

**Remarks:**

(none)

**Inherited public predicates:**

 add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edges/2  empty/1  has_path/3  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2

- Public predicates

  - `is_tree/1`

  - `has_cycle/1`

  - `cycle/2`

  - `graph_coloring/3`

  - `articulation_points/2`

  - `bridges/2`

  - `maximal_cliques/2`

  - `maximum_cliques/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `is_tree/1`

True iff the graph is a tree, i.e. it is connected and has exactly `|V|`` ``-`` ``1` edges.

**Compilation flags:**

`static`

**Template:**

`is_tree(Graph)`

**Mode and number of proofs:**

`is_tree(+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `has_cycle/1`

True iff the graph contains at least one cycle.

**Compilation flags:**

`static`

**Template:**

`has_cycle(Graph)`

**Mode and number of proofs:**

`has_cycle(+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `cycle/2`

Enumerates cycles as lists of vertices where the first and last vertices are the same.

**Compilation flags:**

`static`

**Template:**

`cycle(Graph,Cycle)`

**Mode and number of proofs:**

`cycle(+graph,-list(vertex))` - `zero_or_more`

------------------------------------------------------------------------

###### `graph_coloring/3`

Computes a greedy vertex coloring of the graph. `Coloring` is a list of `Vertex-Color` pairs where colors are integers starting from 1. `NumberOfColors` is the total number of colors used.

**Compilation flags:**

`static`

**Template:**

`graph_coloring(Graph,Coloring,NumberOfColors)`

**Mode and number of proofs:**

`graph_coloring(+graph,-list(pair),-integer)` - `one`

------------------------------------------------------------------------

###### `articulation_points/2`

Computes all articulation points (cut vertices) of the graph. The result is a sorted list of vertices.

**Compilation flags:**

`static`

**Template:**

`articulation_points(Graph,Points)`

**Mode and number of proofs:**

`articulation_points(+graph,-list(vertex))` - `one`

------------------------------------------------------------------------

###### `bridges/2`

Computes all bridges (cut edges) of the graph. Each bridge is returned once as `Vertex1-Vertex2` with `Vertex1`` ``@<`` ``Vertex2`.

**Compilation flags:**

`static`

**Template:**

`bridges(Graph,Bridges)`

**Mode and number of proofs:**

`bridges(+graph,-list(edge))` - `one`

------------------------------------------------------------------------

###### `maximal_cliques/2`

Computes all maximal cliques of the graph using the Bron-Kerbosch algorithm with pivoting. A maximal clique is a clique that cannot be extended by adding another adjacent vertex. Each clique is a sorted list of vertices. The list of cliques is sorted in standard order.

**Compilation flags:**

`static`

**Template:**

`maximal_cliques(Graph,Cliques)`

**Mode and number of proofs:**

`maximal_cliques(+graph,-list(list(vertex)))` - `one`

------------------------------------------------------------------------

###### `maximum_cliques/2`

Computes all maximum cliques of the graph, i.e. the largest maximal cliques. Each clique is a sorted list of vertices. The list of cliques is sorted in standard order. For an empty graph, returns an empty list.

**Compilation flags:**

`static`

**Template:**

`maximum_cliques(Graph,Cliques)`

**Mode and number of proofs:**

`maximum_cliques(+graph,-list(list(vertex)))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `unweighted_directed_graph`

Unweighted directed graph predicates using the AVL tree dictionary representation.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` unweighted_directed_graph(avltree)

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/4  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  complement/2  compose/3  cycle/2  delete_edge/4  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/3  edges/2  empty/1  has_cycle/1  has_path/3  in_degree/3  is_acyclic/1  is_bipartite/1  is_complete/1  is_sparse/1  leaves/2  max_path/5  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  out_degree/3  path/3  reachable/3  strongly_connected_components/2  symmetric_closure/2  topological_sort/2  topological_sort/3  transitive_closure/2  transitive_reduction/2  transpose/2  union/3  vertices/2  weakly_connected_components/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `unweighted_directed_graph(Dictionary)`

Unweighted directed graph predicates using a dictionary representation. The parametric object parameter is the dictionary to use for the graph representation.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` unweighted_graph_common(Dictionary)

`public` directed_graph_common

**Uses:**

pairs

set

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/4  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  complement/2  cycle/2  delete_edge/4  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/3  edges/2  empty/1  has_cycle/1  has_path/3  in_degree/3  is_acyclic/1  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  out_degree/3  path/3  reachable/3  strongly_connected_components/2  symmetric_closure/2  topological_sort/2  transitive_closure/2  transpose/2  vertices/2  weakly_connected_components/2

- Public predicates

  - `compose/3`

  - `union/3`

  - `topological_sort/3`

  - `leaves/2`

  - `transitive_reduction/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `compose/3`

Composes `NewGraph` by connecting the drains of `LeftGraph` to the sources of `RightGraph`.

**Compilation flags:**

`static`

**Template:**

`compose(LeftGraph,RightGraph,NewGraph)`

**Mode and number of proofs:**

`compose(+graph,+graph,-graph)` - `one`

------------------------------------------------------------------------

###### `union/3`

Unifies `UnionGraph` with the union of `Graph1` and `Graph2`.

**Compilation flags:**

`static`

**Template:**

`union(Graph1,Graph2,UnionGraph)`

**Mode and number of proofs:**

`union(+graph,+graph,-graph)` - `one`

------------------------------------------------------------------------

###### `topological_sort/3`

Difference list version of `topological_sort/2` where `Sorted0` is the tail of `Sorted`.

**Compilation flags:**

`static`

**Template:**

`topological_sort(Graph,Sorted0,Sorted)`

**Mode and number of proofs:**

`topological_sort(+graph,+list(vertex),-list(vertex))` - `one`

------------------------------------------------------------------------

###### `leaves/2`

Unifies `Leaves` with a sorted list of vertices with no outgoing edges.

**Compilation flags:**

`static`

**Template:**

`leaves(Graph,Leaves)`

**Mode and number of proofs:**

`leaves(+graph,-list(vertex))` - `one`

------------------------------------------------------------------------

###### `transitive_reduction/2`

Computes the transitive reduction of the graph. An edge Vertex1-Vertex2 is in the reduction iff it is in the graph and there is no other path of length \>= 2 from Vertex1 to Vertex2.

**Compilation flags:**

`static`

**Template:**

`transitive_reduction(Graph,Reduction)`

**Mode and number of proofs:**

`transitive_reduction(+graph,-graph)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `unweighted_graph_common(Dictionary)`

Common unweighted graph predicates shared by both unweighted directed and unweighted undirected graph objects. Uses self-dispatch to call object-specific predicates such as `add_edge/4`, `delete_edge/4`, and `neighbors/3`.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static`

**Implements:**

`public` unweighted_graph_protocol

**Extends:**

`public` graph_common

**Uses:**

avltree

list

set

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/4  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  complement/2  delete_edge/4  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/3  edges/2  empty/1  has_path/3  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `unweighted_graph_protocol`

Protocol for unweighted graph predicates, extending the common graph protocol with unweighted edge operations.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static`

**Extends:**

`public` graph_protocol

**Remarks:**

(none)

**Inherited public predicates:**

 add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edges/2  empty/1  has_path/3  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2

- Public predicates

  - `edge/3`

  - `add_edge/4`

  - `delete_edge/4`

  - `complement/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `edge/3`

True iff there is an edge between `Vertex1` and `Vertex2` in `Graph`.

**Compilation flags:**

`static`

**Template:**

`edge(Vertex1,Vertex2,Graph)`

**Mode and number of proofs:**

`edge(+vertex,+vertex,+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `add_edge/4`

Adds an edge between `Vertex1` and `Vertex2` to the graph.

**Compilation flags:**

`static`

**Template:**

`add_edge(Graph,Vertex1,Vertex2,NewGraph)`

**Mode and number of proofs:**

`add_edge(+graph,+vertex,+vertex,-graph)` - `one`

------------------------------------------------------------------------

###### `delete_edge/4`

Deletes the edge between `Vertex1` and `Vertex2` from the graph. The graph is unchanged if the edge does not exist.

**Compilation flags:**

`static`

**Template:**

`delete_edge(Graph,Vertex1,Vertex2,NewGraph)`

**Mode and number of proofs:**

`delete_edge(+graph,+vertex,+vertex,-graph)` - `one`

------------------------------------------------------------------------

###### `complement/2`

Unifies `NewGraph` with the complement graph where there is an edge between all pairs of vertices not connected in the original graph.

**Compilation flags:**

`static`

**Template:**

`complement(Graph,NewGraph)`

**Mode and number of proofs:**

`complement(+graph,-graph)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `unweighted_undirected_graph`

Unweighted undirected graph predicates using the AVL tree dictionary representation.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` unweighted_undirected_graph(avltree)

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/4  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  articulation_points/2  breadth_first_order/3  bridges/2  complement/2  connected_components/2  cycle/2  degree/3  delete_edge/4  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/3  edges/2  empty/1  graph_coloring/3  has_cycle/1  has_path/3  is_bipartite/1  is_complete/1  is_connected/1  is_sparse/1  is_tree/1  max_path/5  maximal_cliques/2  maximum_cliques/2  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `unweighted_undirected_graph(Dictionary)`

Unweighted undirected graph predicates using a dictionary representation. Undirected edges are stored as two directed edges. The parametric object parameter is the dictionary to use for the graph representation.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` unweighted_graph_common(Dictionary)

`public` undirected_graph_common

**Uses:**

list

set

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/4  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  articulation_points/2  breadth_first_order/3  bridges/2  complement/2  cycle/2  delete_edge/4  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/3  edges/2  empty/1  graph_coloring/3  has_cycle/1  has_path/3  is_bipartite/1  is_complete/1  is_sparse/1  is_tree/1  max_path/5  maximal_cliques/2  maximum_cliques/2  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2

- Public predicates

  - `degree/3`

  - `is_connected/1`

  - `connected_components/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `degree/3`

Unifies `Degree` with the number of edges incident to `Vertex`. Fails if `Vertex` is not in the graph.

**Compilation flags:**

`static`

**Template:**

`degree(Vertex,Graph,Degree)`

**Mode and number of proofs:**

`degree(+vertex,+graph,-integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_connected/1`

True iff the graph is connected (every vertex is reachable from every other vertex).

**Compilation flags:**

`static`

**Template:**

`is_connected(Graph)`

**Mode and number of proofs:**

`is_connected(+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `connected_components/2`

Unifies `Components` with a list of connected components. Each component is a sorted list of vertices.

**Compilation flags:**

`static`

**Template:**

`connected_components(Graph,Components)`

**Mode and number of proofs:**

`connected_components(+graph,-list(list(vertex)))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `weighted_directed_graph`

Weighted directed graph predicates using the AVL tree dictionary representation. Edge weights use a pair representation (Vertex-Weight in neighbor lists, (Vertex1-Vertex2)-Weight for edge lists).

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` weighted_directed_graph(avltree)

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/5  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  cycle/2  delete_edge/5  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/4  edges/2  empty/1  has_cycle/1  has_negative_cycle/1  has_path/3  in_degree/3  is_acyclic/1  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_path_bellman_ford/5  min_paths/3  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  out_degree/3  path/3  reachable/3  strongly_connected_components/2  symmetric_closure/2  topological_sort/2  transitive_closure/2  transpose/2  vertices/2  weakly_connected_components/2  wneighbors/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `weighted_directed_graph(Dictionary)`

Weighted directed graph predicates using a dictionary representation. Edge weights use a pair representation (Vertex-Weight in neighbor lists, (Vertex1-Vertex2)-Weight for edge lists). The parametric object parameter is the dictionary to use for the graph representation.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` weighted_graph_common(Dictionary)

`public` directed_graph_common

**Uses:**

pairs

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/5  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  cycle/2  delete_edge/5  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/4  edges/2  empty/1  has_cycle/1  has_negative_cycle/1  has_path/3  in_degree/3  is_acyclic/1  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_path_bellman_ford/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  out_degree/3  path/3  reachable/3  strongly_connected_components/2  symmetric_closure/2  topological_sort/2  transitive_closure/2  transpose/2  vertices/2  weakly_connected_components/2  wneighbors/3

- Public predicates

  - `min_paths/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `min_paths/3`

Computes shortest path tree from `Vertex1` to all reachable vertices.

**Compilation flags:**

`static`

**Template:**

`min_paths(Vertex1,Graph,PathTree)`

**Mode and number of proofs:**

`min_paths(+vertex,+graph,-graph)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `weighted_graph_common(Dictionary)`

Common weighted graph predicates shared by both weighted directed and weighted undirected graph objects. Uses self-dispatch to call object-specific predicates such as `add_edge/5`, `delete_edge/5`, and `edges/2`.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-25

**Compilation flags:**

`static`

**Implements:**

`public` weighted_graph_protocol

**Extends:**

`public` graph_common

**Uses:**

list

pairs

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/5  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  delete_edge/5  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/4  edges/2  empty/1  has_negative_cycle/1  has_path/3  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_path_bellman_ford/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2  wneighbors/3

- Public predicates

- Protected predicates

  - `winsert_neighbor/4`

  - `wremove_neighbor/4`

  - `wfind/3`

  - `wremove_vertex_from_all/3`

  - `relax_neighbors/7`

  - `pq_insert/3`

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

###### `winsert_neighbor/4`

Inserts a weighted neighbor into a sorted weighted neighbor list, replacing any existing entry for the same vertex.

**Compilation flags:**

`static`

**Template:**

`winsert_neighbor(WNeighbors,Vertex,Weight,NewWNeighbors)`

**Mode and number of proofs:**

`winsert_neighbor(+list,+vertex,+number,-list)` - `one`

------------------------------------------------------------------------

###### `wremove_neighbor/4`

Removes a vertex from a sorted weighted neighbor list, unifying the weight. Fails if the vertex is not found.

**Compilation flags:**

`static`

**Template:**

`wremove_neighbor(WNeighbors,Vertex,Weight,NewWNeighbors)`

**Mode and number of proofs:**

`wremove_neighbor(+list,+vertex,-number,-list)` - `zero_or_one`

------------------------------------------------------------------------

###### `wfind/3`

Finds the weight associated with a vertex in a weighted neighbor list.

**Compilation flags:**

`static`

**Template:**

`wfind(WNeighbors,Vertex,Weight)`

**Mode and number of proofs:**

`wfind(+list,+vertex,-number)` - `zero_or_one`

------------------------------------------------------------------------

###### `wremove_vertex_from_all/3`

Removes a vertex from all weighted neighbor lists in a list of vertex-neighbors pairs.

**Compilation flags:**

`static`

**Template:**

`wremove_vertex_from_all(Pairs,Vertex,NewPairs)`

**Mode and number of proofs:**

`wremove_vertex_from_all(+list(pair),+vertex,-list(pair))` - `one`

------------------------------------------------------------------------

###### `relax_neighbors/7`

Relaxes neighbors during Dijkstra shortest path computation, updating distances and priority queue.

**Compilation flags:**

`static`

**Template:**

`relax_neighbors(WNeighbors,Vertex,Distance,Queue,Dist,NewQueue,NewDist)`

**Mode and number of proofs:**

`relax_neighbors(+list,+vertex,+number,+list,+dictionary,-list,-dictionary)` - `one`

------------------------------------------------------------------------

###### `pq_insert/3`

Inserts an element into a sorted priority queue (list of Distance-Vertex pairs).

**Compilation flags:**

`static`

**Template:**

`pq_insert(Queue,Item,NewQueue)`

**Mode and number of proofs:**

`pq_insert(+list,+pair,-list)` - `one`

------------------------------------------------------------------------

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `weighted_graph_protocol`

Protocol for weighted graph predicates, extending the common graph protocol with weighted edge operations.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-25

**Compilation flags:**

`static`

**Extends:**

`public` graph_protocol

**Remarks:**

(none)

**Inherited public predicates:**

 add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  breadth_first_order/3  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edges/2  empty/1  has_path/3  is_bipartite/1  is_complete/1  is_sparse/1  max_path/5  min_distances/3  min_path/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2

- Public predicates

  - `edge/4`

  - `add_edge/5`

  - `delete_edge/5`

  - `wneighbors/3`

  - `min_path_bellman_ford/5`

  - `has_negative_cycle/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `edge/4`

True iff there is an edge between `Vertex1` and `Vertex2` with weight `Weight` in `Graph`.

**Compilation flags:**

`static`

**Template:**

`edge(Vertex1,Vertex2,Weight,Graph)`

**Mode and number of proofs:**

`edge(+vertex,+vertex,?number,+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `add_edge/5`

Adds a weighted edge between `Vertex1` and `Vertex2` with weight `Weight`.

**Compilation flags:**

`static`

**Template:**

`add_edge(Graph,Vertex1,Vertex2,Weight,NewGraph)`

**Mode and number of proofs:**

`add_edge(+graph,+vertex,+vertex,+number,-graph)` - `one`

------------------------------------------------------------------------

###### `delete_edge/5`

Deletes the weighted edge between `Vertex1` and `Vertex2`. Unifies `Weight` with the weight of the deleted edge. The graph is unchanged if the edge does not exist.

**Compilation flags:**

`static`

**Template:**

`delete_edge(Graph,Vertex1,Vertex2,Weight,NewGraph)`

**Mode and number of proofs:**

`delete_edge(+graph,+vertex,+vertex,?number,-graph)` - `one`

------------------------------------------------------------------------

###### `wneighbors/3`

Unifies `WNeighbors` with a list of `NeighborVertex-Weight` pairs for the neighbors of `Vertex`. Fails if `Vertex` is not in the graph.

**Compilation flags:**

`static`

**Template:**

`wneighbors(Vertex,Graph,WNeighbors)`

**Mode and number of proofs:**

`wneighbors(+vertex,+graph,-list(pair))` - `zero_or_one`

------------------------------------------------------------------------

###### `min_path_bellman_ford/5`

Finds the minimum cost path from `Vertex1` to `Vertex2` using the Bellman-Ford algorithm. Supports negative edge weights and fails if no path exists or if a reachable negative cycle makes the optimum undefined.

**Compilation flags:**

`static`

**Template:**

`min_path_bellman_ford(Vertex1,Vertex2,Graph,Path,Cost)`

**Mode and number of proofs:**

`min_path_bellman_ford(+vertex,+vertex,+graph,-list(vertex),-number)` - `zero_or_one`

------------------------------------------------------------------------

###### `has_negative_cycle/1`

True iff `Graph` contains a negative-weight cycle.

**Compilation flags:**

`static`

**Template:**

`has_negative_cycle(Graph)`

**Mode and number of proofs:**

`has_negative_cycle(+graph)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `weighted_undirected_graph`

Weighted undirected graph predicates using the AVL tree dictionary representation. Each edge is stored in both directions. Edge weights use a pair representation (Vertex-Weight in neighbor lists, (V1-V2)-Weight for edge lists).

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` weighted_undirected_graph(avltree)

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/5  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  articulation_points/2  breadth_first_order/3  bridges/2  connected_components/2  cycle/2  degree/3  delete_edge/5  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/4  edges/2  empty/1  graph_coloring/3  has_cycle/1  has_negative_cycle/1  has_path/3  is_bipartite/1  is_complete/1  is_connected/1  is_sparse/1  is_tree/1  max_path/5  max_tree/3  maximal_cliques/2  maximum_cliques/2  min_distances/3  min_path/5  min_path_bellman_ford/5  min_predecessors/3  min_tree/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2  wneighbors/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `weighted_undirected_graph(Dictionary)`

Weighted undirected graph predicates using a dictionary representation. Each edge is stored in both directions. Edge weights use a pair representation (`Vertex-Weight` in neighbor lists, `(Vertex1-Vertex2)-Weight` for edge lists). The parametric object parameter is the dictionary to use for the graph representation.

**Availability:**

`logtalk_load(graphs(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` weighted_graph_common(Dictionary)

`public` undirected_graph_common

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

 add_edge/5  add_edges/3  add_vertex/3  add_vertices/3  all_pairs_min_paths/2  all_pairs_min_predecessors/2  articulation_points/2  breadth_first_order/3  bridges/2  cycle/2  delete_edge/5  delete_edges/3  delete_vertex/3  delete_vertices/3  depth_first_order/3  edge/4  edges/2  empty/1  graph_coloring/3  has_cycle/1  has_negative_cycle/1  has_path/3  is_bipartite/1  is_complete/1  is_sparse/1  is_tree/1  max_path/5  maximal_cliques/2  maximum_cliques/2  min_distances/3  min_path/5  min_path_bellman_ford/5  min_predecessors/3  neighbors/3  new/1  new/2  new/3  number_of_edges/2  number_of_vertices/2  path/3  reachable/3  vertices/2  wneighbors/3

- Public predicates

  - `degree/3`

  - `is_connected/1`

  - `connected_components/2`

  - `min_tree/3`

  - `max_tree/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `degree/3`

Returns the degree (number of edges incident to the vertex) of `Vertex` in `Graph`.

**Compilation flags:**

`static`

**Template:**

`degree(Vertex,Graph,Degree)`

**Mode and number of proofs:**

`degree(+vertex,+graph,-integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_connected/1`

True if `Graph` is connected (all vertices are reachable from any vertex).

**Compilation flags:**

`static`

**Template:**

`is_connected(Graph)`

**Mode and number of proofs:**

`is_connected(+graph)` - `zero_or_one`

------------------------------------------------------------------------

###### `connected_components/2`

Returns the list of connected components (each a list of vertices).

**Compilation flags:**

`static`

**Template:**

`connected_components(Graph,Components)`

**Mode and number of proofs:**

`connected_components(+graph,-list(list))` - `one`

------------------------------------------------------------------------

###### `min_tree/3`

Constructs a minimum spanning tree and returns its total weight.

**Compilation flags:**

`static`

**Template:**

`min_tree(Graph,Tree,Cost)`

**Mode and number of proofs:**

`min_tree(+graph,-graph,-number)` - `zero_or_one`

------------------------------------------------------------------------

###### `max_tree/3`

Constructs a maximum spanning tree and returns its total weight.

**Compilation flags:**

`static`

**Template:**

`max_tree(Graph,Tree,Cost)`

**Mode and number of proofs:**

`max_tree(+graph,-graph,-number)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### heaps")

**object**

#### `binary_heap(Order)`

- `Order` - Either `<` for a min heap or `>` for a max heap.

Heap implementation, parameterized by the order to be used to compare keys (`<` or `>`).

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Richard O’Keefe; adapted to Logtalk by Paulo Moura and Victor Lagerkvist.

**Version:** 1:2:0

**Date:** 2026-01-28

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` heap_protocol

**Extends:**

`public` compound

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_heap/2  as_list/2  check/1  delete/4  depth/2  empty/1  ground/1  insert/4  insert_all/3  merge/3  new/1  numbervars/1  numbervars/3  occurs/2  singletons/2  size/2  subsumes/2  subterm/2  top/3  top_next/5  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

binary_heap_min, binary_heap_max

**object**

#### `binary_heap_max`

Max-heap implementation. Uses standard order to compare keys.

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2010-02-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` binary_heap(\>)

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_heap/2  as_list/2  check/1  delete/4  depth/2  empty/1  ground/1  insert/4  insert_all/3  merge/3  new/1  numbervars/1  numbervars/3  occurs/2  singletons/2  size/2  subsumes/2  subterm/2  top/3  top_next/5  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

binary_heap_min, binary_heap(Order)

**object**

#### `binary_heap_min`

Min-heap implementation. Uses standard order to compare keys.

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2010-02-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` binary_heap(\<)

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_heap/2  as_list/2  check/1  delete/4  depth/2  empty/1  ground/1  insert/4  insert_all/3  merge/3  new/1  numbervars/1  numbervars/3  occurs/2  singletons/2  size/2  subsumes/2  subterm/2  top/3  top_next/5  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

binary_heap_max, binary_heap(Order)

**object**

#### `heap(Order)`

- `Order` - Either `<` for a min heap or `>` for a max heap.

Heap implementation, parameterized by the order to be used to compare keys (`<` or `>`). Deprecated. Use the `binary_heap/1` object instead.

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-01-28

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` binary_heap(Order)

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_heap/2  as_list/2  check/1  delete/4  depth/2  empty/1  ground/1  insert/4  insert_all/3  merge/3  new/1  numbervars/1  numbervars/3  occurs/2  singletons/2  size/2  subsumes/2  subterm/2  top/3  top_next/5  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

binary_heap(Order)

**protocol**

#### `heap_protocol`

Heap protocol. Key-value pairs are represented as `Key-Value`.

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Richard O’Keefe; adapted to Logtalk by Paulo Moura and Victor Lagerkvist.

**Version:** 1:0:1

**Date:** 2010-11-13

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `insert/4`

  - `insert_all/3`

  - `delete/4`

  - `merge/3`

  - `empty/1`

  - `size/2`

  - `as_list/2`

  - `as_heap/2`

  - `top/3`

  - `top_next/5`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `insert/4`

Inserts the new pair into a heap, returning the updated heap.

**Compilation flags:**

`static`

**Template:**

`insert(Key,Value,Heap,NewHeap)`

**Mode and number of proofs:**

`insert(+key,+value,+heap,-heap)` - `one`

------------------------------------------------------------------------

###### `insert_all/3`

Inserts a list of pairs into a heap, returning the updated heap.

**Compilation flags:**

`static`

**Template:**

`insert_all(List,Heap,NewHeap)`

**Mode and number of proofs:**

`insert_all(@list(pairs),+heap,-heap)` - `one`

------------------------------------------------------------------------

###### `delete/4`

Deletes and returns the top pair in a heap returning the updated heap.

**Compilation flags:**

`static`

**Template:**

`delete(Heap,TopKey,TopValue,NewHeap)`

**Mode and number of proofs:**

`delete(+heap,?key,?value,-heap)` - `zero_or_one`

------------------------------------------------------------------------

###### `merge/3`

Merges two heaps.

**Compilation flags:**

`static`

**Template:**

`merge(Heap1,Heap2,NewHeap)`

**Mode and number of proofs:**

`merge(+heap,+heap,-heap)` - `one`

------------------------------------------------------------------------

###### `empty/1`

True if the heap is empty.

**Compilation flags:**

`static`

**Template:**

`empty(Heap)`

**Mode and number of proofs:**

`empty(@heap)` - `zero_or_one`

------------------------------------------------------------------------

###### `size/2`

Returns the number of heap elements.

**Compilation flags:**

`static`

**Template:**

`size(Heap,Size)`

**Mode and number of proofs:**

`size(+heap,?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `as_list/2`

Returns the current set of pairs in the heap as a list, sorted into ascending order of the keys.

**Compilation flags:**

`static`

**Template:**

`as_list(Heap,List)`

**Mode and number of proofs:**

`as_list(+heap,-list)` - `one`

------------------------------------------------------------------------

###### `as_heap/2`

Constructs a heap from a list of pairs.

**Compilation flags:**

`static`

**Template:**

`as_heap(List,Heap)`

**Mode and number of proofs:**

`as_heap(+list,-heap)` - `one`

------------------------------------------------------------------------

###### `top/3`

Returns the top pair in the heap. Fails if the heap is empty.

**Compilation flags:**

`static`

**Template:**

`top(Heap,TopKey,TopValue)`

**Mode and number of proofs:**

`top(+heap,?key,?value)` - `zero_or_one`

------------------------------------------------------------------------

###### `top_next/5`

Returns the top pair and the next pair in the heap. Fails if the heap does not have at least two elements.

**Compilation flags:**

`static`

**Template:**

`top_next(Heap,TopKey,TopValue,NextKey,NextValue)`

**Mode and number of proofs:**

`top_next(+heap,?key,?value,?key,?value)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

heap(Order), pairing_heap(Order)

**protocol**

#### `heapp`

Heap protocol. Deprecated. Use the `heap_protocol` protocol instead.

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-01-28

**Compilation flags:**

`static`

**Extends:**

`public` heap_protocol

**Remarks:**

(none)

**Inherited public predicates:**

 as_heap/2  as_list/2  delete/4  empty/1  insert/4  insert_all/3  merge/3  size/2  top/3  top_next/5

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

heap_protocol

**object**

#### `maxheap`

Max-heap implementation. Uses standard order to compare keys. Deprecated. Use the `binary_heap_max` object instead.

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2010-02-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` binary_heap(\>)

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_heap/2  as_list/2  check/1  delete/4  depth/2  empty/1  ground/1  insert/4  insert_all/3  merge/3  new/1  numbervars/1  numbervars/3  occurs/2  singletons/2  size/2  subsumes/2  subterm/2  top/3  top_next/5  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

binary_heap_max

**object**

#### `minheap`

Min-heap implementation. Uses standard order to compare keys. Deprecated. Use the `binary_heap_min` object instead.

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2010-02-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` binary_heap(\<)

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_heap/2  as_list/2  check/1  delete/4  depth/2  empty/1  ground/1  insert/4  insert_all/3  merge/3  new/1  numbervars/1  numbervars/3  occurs/2  singletons/2  size/2  subsumes/2  subterm/2  top/3  top_next/5  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

binary_heap_min

**object**

#### `pairing_heap(Order)`

- `Order` - Either `<` for a min heap or `>` for a max heap.

Pairing heap implementation, parameterized by the order to be used to compare keys (`<` or `>`).

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-01-28

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` heap_protocol

**Extends:**

`public` compound

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_heap/2  as_list/2  check/1  delete/4  depth/2  empty/1  ground/1  insert/4  insert_all/3  merge/3  new/1  numbervars/1  numbervars/3  occurs/2  singletons/2  size/2  subsumes/2  subterm/2  top/3  top_next/5  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

pairing_heap_min, pairing_heap_max

**object**

#### `pairing_heap_max`

Max-pairing heap implementation. Uses standard order to compare keys.

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-01-28

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` pairing_heap(\>)

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_heap/2  as_list/2  check/1  delete/4  depth/2  empty/1  ground/1  insert/4  insert_all/3  merge/3  new/1  numbervars/1  numbervars/3  occurs/2  singletons/2  size/2  subsumes/2  subterm/2  top/3  top_next/5  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

pairing_heap_min, pairing_heap(Order)

**object**

#### `pairing_heap_min`

Min-pairing heap implementation. Uses standard order to compare keys.

**Availability:**

`logtalk_load(heaps(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-01-28

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` pairing_heap(\<)

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  as_heap/2  as_list/2  check/1  delete/4  depth/2  empty/1  ground/1  insert/4  insert_all/3  merge/3  new/1  numbervars/1  numbervars/3  occurs/2  singletons/2  size/2  subsumes/2  subterm/2  top/3  top_next/5  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

pairing_heap_max, pairing_heap(Order)

### help")

**object**

#### `help`

Command-line help for Logtalk tools, libraries, entities, predicates, and non-terminals.

**Availability:**

`logtalk_load(help(loader))`

**Author:** Paulo Moura

**Version:** 0:43:0

**Date:** 2026-02-04

**Compilation flags:**

`static,`` ``context_switching_calls,`` ``complements(allow)`

**Implements:**

`public` forwarding

**Uses:**

atom

integer

list

os

user

**Remarks:**

(none)

**Inherited public predicates:**

 forward/1

- Public predicates

  - `help/0`

  - `handbook/0`

  - `apis/0`

  - `apis/1`

  - `tools/0`

  - `tool/1`

  - `libraries/0`

  - `library/1`

  - `entity/1`

  - `(/)/2`

  - `(//)/2`

  - `man/1`

  - `completion/2`

  - `completions/2`

  - `built_in_directive/4`

  - `built_in_predicate/4`

  - `built_in_method/4`

  - `control_construct/4`

  - `built_in_non_terminal/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `help/0`

Provides instructions on how to use the help tool.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`help` - `one`

------------------------------------------------------------------------

###### `handbook/0`

Provides access to the Handbook.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`handbook` - `one`

------------------------------------------------------------------------

###### `apis/0`

Provides access to the APIs documentation.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`apis` - `one`

------------------------------------------------------------------------

###### `apis/1`

Provides help on the given predicate or non-terminal.

**Compilation flags:**

`static`

**Template:**

`apis(Indicator)`

**Mode and number of proofs:**

`apis(+predicate_indicator)` - `one`

`apis(+non_terminal_indicator)` - `one`

------------------------------------------------------------------------

###### `tools/0`

Provides access to the developer tools documentation.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`tools` - `one`

------------------------------------------------------------------------

###### `tool/1`

Provides help on the given developer tool.

**Compilation flags:**

`static`

**Template:**

`tool(Tool)`

**Mode and number of proofs:**

`tool(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `libraries/0`

Provides access to the standard libraries documentation.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`libraries` - `one`

------------------------------------------------------------------------

###### `library/1`

Provides help on the given standard library.

**Compilation flags:**

`static`

**Template:**

`library(Library)`

**Mode and number of proofs:**

`library(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `entity/1`

Provides help on the given built-in, tool, and library entity (object, protocol, or category).

**Compilation flags:**

`static`

**Template:**

`entity(Entity)`

**Mode and number of proofs:**

`entity(+entity_identifier)` - `zero_or_one`

------------------------------------------------------------------------

###### `(/)/2`

Provides help on the `Name/Arity` built-in control construct, directive, predicate, or method.

**Compilation flags:**

`static`

**Template:**

`Name/Arity`

**Mode and number of proofs:**

`+atom/`` ``+integer` - `zero_or_one`

------------------------------------------------------------------------

###### `(//)/2`

Provides help on the `Name//Arity` built-in non-terminal.

**Compilation flags:**

`static`

**Template:**

`Name//Arity`

**Mode and number of proofs:**

`+atom//`` ``+integer` - `zero_or_one`

------------------------------------------------------------------------

###### `man/1`

Opens the man page of the given script. On POSIX systems, the page is open inline. On Windows system, the HTML version of the man page is open on the operating-system default browser.

**Compilation flags:**

`static`

**Template:**

`man(Page)`

**Mode and number of proofs:**

`man(+atom)` - `one`

------------------------------------------------------------------------

###### `completion/2`

Provides a completion pair, `Completion-Page`, for a given prefix.

**Compilation flags:**

`static`

**Template:**

`completion(Prefix,Completion)`

**Mode and number of proofs:**

`completion(+atom,-pair)` - `zero_or_more`

------------------------------------------------------------------------

###### `completions/2`

Provides a list of completions pairs, `Completion-Page`, for a given prefix.

**Compilation flags:**

`static`

**Template:**

`completions(Prefix,Completions)`

**Mode and number of proofs:**

`completions(+atom,-lists(pair))` - `zero_or_more`

------------------------------------------------------------------------

###### `built_in_directive/4`

Provides access to the HTML documenting files describing built-in directives.

**Compilation flags:**

`static`

**Template:**

`built_in_directive(Name,Arity,Directory,Basename)`

**Mode and number of proofs:**

`built_in_directive(?atom,?integer,-atom,-atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `built_in_predicate/4`

Provides access to the HTML documenting files describing built-in predicates.

**Compilation flags:**

`static`

**Template:**

`built_in_predicate(Name,Arity,Directory,Basename)`

**Mode and number of proofs:**

`built_in_predicate(?atom,?integer,-atom,-atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `built_in_method/4`

Provides access to the HTML documenting files describing built-in methods.

**Compilation flags:**

`static`

**Template:**

`built_in_method(Name,Arity,Directory,Basename)`

**Mode and number of proofs:**

`built_in_method(?atom,?integer,-atom,-atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `control_construct/4`

Provides access to the HTML documenting files describing built-in control constructs.

**Compilation flags:**

`static`

**Template:**

`control_construct(Name,Arity,Directory,Basename)`

**Mode and number of proofs:**

`control_construct(?atom,?integer,-atom,-atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `built_in_non_terminal/4`

Provides access to the HTML documenting files describing built-in DCG non-terminals.

**Compilation flags:**

`static`

**Template:**

`built_in_non_terminal(Name,Arity,Directory,Basename)`

**Mode and number of proofs:**

`built_in_non_terminal(?atom,?integer,-atom,-atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### hierarchies")

**category**

#### `class_hierarchy`

Class hierarchy predicates.

**Availability:**

`logtalk_load(hierarchies(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2006-02-20

**Compilation flags:**

`static`

**Implements:**

`public` class_hierarchyp

**Remarks:**

(none)

**Inherited public predicates:**

 ancestor/1  ancestors/1  class/1  classes/1  descendant/1  descendant_class/1  descendant_classes/1  descendant_instance/1  descendant_instances/1  descendants/1  instance/1  instances/1  leaf/1  leaf_class/1  leaf_classes/1  leaf_instance/1  leaf_instances/1  leaves/1  subclass/1  subclasses/1  superclass/1  superclasses/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `class_hierarchyp`

Class hierarchy protocol.

**Availability:**

`logtalk_load(hierarchies(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2000-07-24

**Compilation flags:**

`static`

**Extends:**

`public` hierarchyp

**Remarks:**

(none)

**Inherited public predicates:**

 ancestor/1  ancestors/1  descendant/1  descendants/1  leaf/1  leaves/1

- Public predicates

  - `class/1`

  - `classes/1`

  - `instance/1`

  - `instances/1`

  - `subclass/1`

  - `subclasses/1`

  - `superclass/1`

  - `superclasses/1`

  - `leaf_instance/1`

  - `leaf_instances/1`

  - `leaf_class/1`

  - `leaf_classes/1`

  - `descendant_instance/1`

  - `descendant_instances/1`

  - `descendant_class/1`

  - `descendant_classes/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `class/1`

Returns, by backtracking, all object classes.

**Compilation flags:**

`static`

**Template:**

`class(Class)`

**Mode and number of proofs:**

`class(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `classes/1`

List of all object classes.

**Compilation flags:**

`static`

**Template:**

`classes(Classes)`

**Mode and number of proofs:**

`classes(-list)` - `one`

------------------------------------------------------------------------

###### `instance/1`

Returns, by backtracking, all class instances.

**Compilation flags:**

`static`

**Template:**

`instance(Instance)`

**Mode and number of proofs:**

`instance(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `instances/1`

List of all class instances.

**Compilation flags:**

`static`

**Template:**

`instances(Instances)`

**Mode and number of proofs:**

`instances(-list)` - `one`

------------------------------------------------------------------------

###### `subclass/1`

Returns, by backtracking, all class subclasses.

**Compilation flags:**

`static`

**Template:**

`subclass(Subclass)`

**Mode and number of proofs:**

`subclass(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `subclasses/1`

List of all class subclasses.

**Compilation flags:**

`static`

**Template:**

`subclasses(Subclasses)`

**Mode and number of proofs:**

`subclasses(-list)` - `one`

------------------------------------------------------------------------

###### `superclass/1`

Returns, by backtracking, all class superclasses.

**Compilation flags:**

`static`

**Template:**

`superclass(Superclass)`

**Mode and number of proofs:**

`superclass(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `superclasses/1`

List of all class superclasses.

**Compilation flags:**

`static`

**Template:**

`superclasses(Superclasses)`

**Mode and number of proofs:**

`superclasses(-list)` - `one`

------------------------------------------------------------------------

###### `leaf_instance/1`

Returns, by backtracking, all class leaf instances.

**Compilation flags:**

`static`

**Template:**

`leaf_instance(Leaf)`

**Mode and number of proofs:**

`leaf_instance(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `leaf_instances/1`

List of all class leaf instances.

**Compilation flags:**

`static`

**Template:**

`leaf_instances(Leaves)`

**Mode and number of proofs:**

`leaf_instances(-list)` - `one`

------------------------------------------------------------------------

###### `leaf_class/1`

Returns, by backtracking, all class leaf subclasses.

**Compilation flags:**

`static`

**Template:**

`leaf_class(Leaf)`

**Mode and number of proofs:**

`leaf_class(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `leaf_classes/1`

List of all class leaf leaf subclasses.

**Compilation flags:**

`static`

**Template:**

`leaf_classes(Leaves)`

**Mode and number of proofs:**

`leaf_classes(-list)` - `one`

------------------------------------------------------------------------

###### `descendant_instance/1`

Returns, by backtracking, all class descendant instances.

**Compilation flags:**

`static`

**Template:**

`descendant_instance(Descendant)`

**Mode and number of proofs:**

`descendant_instance(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `descendant_instances/1`

List of all class descendant instances.

**Compilation flags:**

`static`

**Template:**

`descendant_instances(Descendants)`

**Mode and number of proofs:**

`descendant_instances(-list)` - `one`

------------------------------------------------------------------------

###### `descendant_class/1`

Returns, by backtracking, all class descendant subclasses.

**Compilation flags:**

`static`

**Template:**

`descendant_class(Descendant)`

**Mode and number of proofs:**

`descendant_class(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `descendant_classes/1`

List of all class descendant subclasses.

**Compilation flags:**

`static`

**Template:**

`descendant_classes(Descendants)`

**Mode and number of proofs:**

`descendant_classes(-list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

class_hierarchy

**protocol**

#### `hierarchyp`

Common hierarchy protocol for prototype and class hierarchies.

**Availability:**

`logtalk_load(hierarchies(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2000-07-24

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `ancestor/1`

  - `ancestors/1`

  - `leaf/1`

  - `leaves/1`

  - `descendant/1`

  - `descendants/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `ancestor/1`

Returns, by backtracking, all object ancestors.

**Compilation flags:**

`static`

**Template:**

`ancestor(Ancestor)`

**Mode and number of proofs:**

`ancestor(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `ancestors/1`

List of all object ancestors.

**Compilation flags:**

`static`

**Template:**

`ancestors(Ancestors)`

**Mode and number of proofs:**

`ancestors(-list)` - `one`

------------------------------------------------------------------------

###### `leaf/1`

Returns, by backtracking, all object leaves.

**Compilation flags:**

`static`

**Template:**

`leaf(Leaf)`

**Mode and number of proofs:**

`leaf(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `leaves/1`

List of all object leaves.

**Compilation flags:**

`static`

**Template:**

`leaves(Leaves)`

**Mode and number of proofs:**

`leaves(-list)` - `one`

------------------------------------------------------------------------

###### `descendant/1`

Returns, by backtracking, all object descendants.

**Compilation flags:**

`static`

**Template:**

`descendant(Descendant)`

**Mode and number of proofs:**

`descendant(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `descendants/1`

List of all object descendants.

**Compilation flags:**

`static`

**Template:**

`descendants(Descendants)`

**Mode and number of proofs:**

`descendants(-list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**category**

#### `proto_hierarchy`

Prototype hierarchy predicates.

**Availability:**

`logtalk_load(hierarchies(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2006-02-20

**Compilation flags:**

`static`

**Implements:**

`public` proto_hierarchyp

**Remarks:**

(none)

**Inherited public predicates:**

 ancestor/1  ancestors/1  descendant/1  descendants/1  extension/1  extensions/1  leaf/1  leaves/1  parent/1  parents/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `proto_hierarchyp`

Prototype hierarchy protocol.

**Availability:**

`logtalk_load(hierarchies(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2006-02-20

**Compilation flags:**

`static`

**Extends:**

`public` hierarchyp

**Remarks:**

(none)

**Inherited public predicates:**

 ancestor/1  ancestors/1  descendant/1  descendants/1  leaf/1  leaves/1

- Public predicates

  - `parent/1`

  - `parents/1`

  - `extension/1`

  - `extensions/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parent/1`

Returns, by backtracking, all object parents.

**Compilation flags:**

`static`

**Template:**

`parent(Parent)`

**Mode and number of proofs:**

`parent(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `parents/1`

List of all object parents.

**Compilation flags:**

`static`

**Template:**

`parents(Parents)`

**Mode and number of proofs:**

`parents(-list)` - `one`

------------------------------------------------------------------------

###### `extension/1`

Returns, by backtracking, all object direct descendants.

**Compilation flags:**

`static`

**Template:**

`extension(Extension)`

**Mode and number of proofs:**

`extension(?object)` - `zero_or_more`

------------------------------------------------------------------------

###### `extensions/1`

List of all object direct descendants.

**Compilation flags:**

`static`

**Template:**

`extensions(Extensions)`

**Mode and number of proofs:**

`extensions(-list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

proto_hierarchy

### hook_flows")

**object**

#### `hook_pipeline(Pipeline)`

- `Pipeline` - List of hook objects.

Use a pipeline (represented using a list) of hook objects to expand terms and goals. The expansion results from a hook object are passed to the next hook object in the pipeline.

**Availability:**

`logtalk_load(hook_flows(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2024-09-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

> - Usage: Compile source files that should be expanded using the pipeline of hook objects using the compiler option `hook(hook_pipeline(Pipeline))`.

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

hook_set(Set)

**object**

#### `hook_set(Set)`

- `Set` - Set (list) of hook objects.

Use a set (represented using a list) of hook objects to expand terms and goals. The hook objects are tried in sequence until one of them succeeds in expanding the current term (goal) into a different term (goal).

**Availability:**

`logtalk_load(hook_flows(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2024-09-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

> - Usage: Compile source files that should be expanded using the set of hook objects using the compiler option `hook(hook_set(Set))`.

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

hook_pipeline(Pipeline)

### hook_objects")

**object**

#### `backend_adapter_hook`

This hook object applies the expansion rules defined in the Prolog backend adapter file.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2020-02-17

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

default_workflow_hook, identity_hook, grammar_rules_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `default_workflow_hook`

Use this object as the default hook object to restore the default expansion pipeline semantics used by the compiler.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:1

**Date:** 2020-03-24

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, identity_hook, grammar_rules_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `grammar_rules_hook`

This hook object expands grammar rules into clauses.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2020-02-14

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, default_workflow_hook, identity_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `identity_hook`

Use this object as a file specific hook object to prevent any (other) user-defined expansion rules to be applied when compiling the file.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2020-02-15

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, default_workflow_hook, grammar_rules_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `object_wrapper_hook`

Use this object to wrap the contents of a plain Prolog file in an object named after the file. The wrapper sets the `context_switching_calls` flag to `allow`, enabling calling of the wrapped predicates using the `<</2` control construct.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2020-10-30

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Uses:**

os

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

object_wrapper_hook(Protocol), object_wrapper_hook(Name,Relations), backend_adapter_hook, default_workflow_hook, grammar_rules_hook, prolog_module_hook(Module), write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `object_wrapper_hook(Protocol)`

Use this object to wrap the contents of a plain Prolog file in an object named after the file that implements the given protocol.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2021-11-24

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Uses:**

os

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

object_wrapper_hook, object_wrapper_hook(Name,Relations), backend_adapter_hook, default_workflow_hook, grammar_rules_hook, prolog_module_hook(Module), write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `object_wrapper_hook(Name,Relations)`

Use this object to wrap the contents of a plain Prolog file in an object with the given name and object entity relations (a list).

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2022-02-03

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

object_wrapper_hook, object_wrapper_hook(Protocol), backend_adapter_hook, default_workflow_hook, grammar_rules_hook, prolog_module_hook(Module), write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `print_goal_hook`

Use this object to easily print entity predicate goals before, after, or before and after calling them.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2020-03-14

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

> - Usage: Mark a goal to be printed by prefixing it with an operator. Printing uses a `comment` message.
>
> - To print goal before calling it: `-`` ``Goal`.
>
> - To print goal after calling it: `+`` ``Goal`.
>
> - To print goal before and after calling it: `*`` ``Goal`.
>
> - Operators: This hook object uses the standard `-` and `+` prefix operators and also defines a global `*` prefix operator with the same type and priority.

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, default_workflow_hook, grammar_rules_hook, identity_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), suppress_goal_hook

**object**

#### `prolog_module_hook(Module)`

This hook object applies the expansion rules defined in a Prolog module (e.g., `user`).

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2020-02-17

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, default_workflow_hook, identity_hook, grammar_rules_hook, object_wrapper_hook, write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `suppress_goal_hook`

Use this object to easily suppress a goal in a clause body.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2020-05-04

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

> - Usage: Mark a goal to be suppressed by prefixing it with the `--` operator.
>
> - Operators: This hook object uses the `--` prefix operator declared by Logtalk for use in `mode/2` directives.

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, default_workflow_hook, grammar_rules_hook, identity_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook

**object**

#### `write_to_file_hook(File)`

This hook object writes term-expansion results to a file in canonical format. The terms are terminated by a period and a new line.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2022-07-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` [write_to_file_hook(File,\[quoted(true),ignore_ops(true)\])](index.html#write-to-file-hook-2)

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, default_workflow_hook, identity_hook, grammar_rules_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_file_hook(File,Options), write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `write_to_file_hook(File,Options)`

This hook object writes term-expansion results to a file using a list of `write_term/3` options. The terms are terminated by a period and a new line.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2022-07-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, default_workflow_hook, identity_hook, grammar_rules_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_file_hook(File), write_to_stream_hook(Stream,Options), write_to_stream_hook(Stream), print_goal_hook, suppress_goal_hook

**object**

#### `write_to_stream_hook(Stream)`

This hook object writes term-expansion results to a stream in canonical format. The terms are terminated by a period and a new line.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2020-02-16

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` [write_to_stream_hook(Stream,\[quoted(true),ignore_ops(true)\])](index.html#write-to-stream-hook-2)

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, default_workflow_hook, identity_hook, grammar_rules_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_stream_hook(Stream,Options), write_to_file_hook(File,Options), write_to_file_hook(File), print_goal_hook, suppress_goal_hook

**object**

#### `write_to_stream_hook(Stream,Options)`

This hook object writes term-expansion results to a stream using a list of `write_term/3` options. The terms are terminated by a period and a new line.

**Availability:**

`logtalk_load(hook_objects(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2020-02-16

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

backend_adapter_hook, default_workflow_hook, identity_hook, grammar_rules_hook, prolog_module_hook(Module), object_wrapper_hook, write_to_stream_hook(Stream), write_to_file_hook(File,Options), write_to_file_hook(File), print_goal_hook, suppress_goal_hook

### html")

**category**

#### `html`

HTML generation.

**Availability:**

`logtalk_load(html(loader))`

**Author:** Paul Brown and Paulo Moura

**Version:** 0:3:0

**Date:** 2021-03-30

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `generate/2`

  - `void_element/1`

  - `normal_element/2`

- Protected predicates

- Private predicates

  - `doctype/1`

- Operators

##### Public predicates

###### `generate/2`

Generates HTML content using the representation specified in the first argument (`stream(Stream)` or `file(Path)`) for the term in the second argument.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Term)`

**Mode and number of proofs:**

`generate(+compound,++term)` - `one_or_error`

------------------------------------------------------------------------

###### `void_element/1`

Enumerates, by backtracking, all void elements.

**Compilation flags:**

`static`

**Template:**

`void_element(Element)`

**Mode and number of proofs:**

`void_element(?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `normal_element/2`

Enumerates, by backtracking, all normal elements. The value of the `Display` argument is either `inline` or `block`.

**Compilation flags:**

`static`

**Template:**

`normal_element(Element,Display)`

**Mode and number of proofs:**

`normal_element(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

###### `doctype/1`

Doctype text.

**Compilation flags:**

`static`

**Template:**

`doctype(DocType)`

**Mode and number of proofs:**

`doctype(?atom)` - `one`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `html5`

HTML content generation using the HTML 5 doctype.

**Availability:**

`logtalk_load(html(loader))`

**Author:** Paul Brown and Paulo Moura

**Version:** 1:0:0

**Date:** 2021-03-29

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` html

**Remarks:**

(none)

**Inherited public predicates:**

 generate/2  normal_element/2  void_element/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `xhtml11`

XHTML content generation using the XHTML 1.1 doctype.

**Availability:**

`logtalk_load(html(loader))`

**Author:** Paul Brown and Paulo Moura

**Version:** 1:0:0

**Date:** 2021-03-29

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` html

**Remarks:**

(none)

**Inherited public predicates:**

 generate/2  normal_element/2  void_element/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### ids")

**object**

#### `ids`

Generator of random identifiers represented as atoms with 160 bits (20 bytes) of randomness.

**Availability:**

`logtalk_load(ids(loader))`

**Author:** Paulo Moura

**Version:** 1:2:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` ids(atom,20)

**Remarks:**

(none)

**Inherited public predicates:**

 generate/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

ids(Representation,Bytes), cuid2, ksuid, nanoid, snowflakeid, uuid, ulid

**object**

#### `ids(Representation,Bytes)`

- `Representation` - Text representation for the identifier. Possible values are `atom`, `chars`, and `codes`.

- `Bytes` - Number of bytes of randomness.

Generator of random identifiers.

**Availability:**

`logtalk_load(ids(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

base64

fast_random

list

os

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `generate/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `generate/1`

Generate a random identifier.

**Compilation flags:**

`static`

**Template:**

`generate(Identifier)`

**Mode and number of proofs:**

`generate(--textids)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

ids, nanoid(Representation,Size,Alphabet), cuid2(Representation,Size,Alphabet), ksuid(Representation,Alphabet), uuid(Representation), snowflakeid(Representation,EpochMilliseconds,TimeUnitMilliseconds,TimestampBits,NodeBits,SequenceBits,Node), ulid(Representation)

### intervals")

**object**

#### `interval`

Basic temporal interval relations. An interval is represented by a compound term, `i/2`, with two ground arguments, the start and end points.

**Availability:**

`logtalk_load(intervals(loader))`

**Author:** Paulo Moura

**Version:** 1:2:1

**Date:** 2022-01-15

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` intervalp

**Aliases:**

`intervalp` `before/2` as `b/2`

`intervalp` `after/2` as `bi/2`

`intervalp` `meets/2` as `m/2`

`intervalp` `met_by/2` as `mi/2`

`intervalp` `overlaps/2` as `o/2`

`intervalp` `overlapped_by/2` as `oi/2`

`intervalp` `starts/2` as `s/2`

`intervalp` `started_by/2` as `si/2`

`intervalp` `during/2` as `d/2`

`intervalp` `contains/2` as `di/2`

`intervalp` `finishes/2` as `f/2`

`intervalp` `finished_by/2` as `fi/2`

`intervalp` `equal/2` as `eq/2`

**Remarks:**

(none)

**Inherited public predicates:**

 after/2  before/2  contains/2  during/2  equal/2  finished_by/2  finishes/2  meets/2  met_by/2  new/3  overlapped_by/2  overlaps/2  started_by/2  starts/2  valid/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `intervalp`

Basic temporal interval relations protocol (based on James F. Allen Interval Algebra work).

**Availability:**

`logtalk_load(intervals(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2014-04-26

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `new/3`

  - `valid/1`

  - `before/2`

  - `after/2`

  - `meets/2`

  - `met_by/2`

  - `overlaps/2`

  - `overlapped_by/2`

  - `starts/2`

  - `started_by/2`

  - `during/2`

  - `contains/2`

  - `finishes/2`

  - `finished_by/2`

  - `equal/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `new/3`

Constructs a new interval given start and end points. The start point must strictly precede the end point.

**Compilation flags:**

`static`

**Template:**

`new(Start,End,Interval)`

**Mode and number of proofs:**

`new(@ground,@ground,-interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `valid/1`

True if Interval is a valid interval.

**Compilation flags:**

`static`

**Template:**

`valid(Interval)`

**Mode and number of proofs:**

`valid(@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `before/2`

True if `Interval1` takes place before `Interval2`.

**Compilation flags:**

`static`

**Template:**

`before(Interval1,Interval2)`

**Mode and number of proofs:**

`before(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `after/2`

True if `Interval1` takes place after `Interval2`.

**Compilation flags:**

`static`

**Template:**

`after(Interval1,Interval2)`

**Mode and number of proofs:**

`after(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `meets/2`

True if `Interval1` meets `Interval2`.

**Compilation flags:**

`static`

**Template:**

`meets(Interval1,Interval2)`

**Mode and number of proofs:**

`meets(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `met_by/2`

True if `Interval1` is met by `Interval2`.

**Compilation flags:**

`static`

**Template:**

`met_by(Interval1,Interval2)`

**Mode and number of proofs:**

`met_by(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `overlaps/2`

True if `Interval1` overlaps with `Interval2`.

**Compilation flags:**

`static`

**Template:**

`overlaps(Interval1,Interval2)`

**Mode and number of proofs:**

`overlaps(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `overlapped_by/2`

True if `Interval1` is overlapped by `Interval2`.

**Compilation flags:**

`static`

**Template:**

`overlapped_by(Interval1,Interval2)`

**Mode and number of proofs:**

`overlapped_by(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `starts/2`

True if `Interval1` starts `Interval2`.

**Compilation flags:**

`static`

**Template:**

`starts(Interval1,Interval2)`

**Mode and number of proofs:**

`starts(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `started_by/2`

True if `Interval1` is started by `Interval2`.

**Compilation flags:**

`static`

**Template:**

`started_by(Interval1,Interval2)`

**Mode and number of proofs:**

`started_by(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `during/2`

True if `Interval1` occurs during `Interval2`.

**Compilation flags:**

`static`

**Template:**

`during(Interval1,Interval2)`

**Mode and number of proofs:**

`during(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `contains/2`

True if `Interval1` contains `Interval2`.

**Compilation flags:**

`static`

**Template:**

`contains(Interval1,Interval2)`

**Mode and number of proofs:**

`contains(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `finishes/2`

True if `Interval1` finishes `Interval2`.

**Compilation flags:**

`static`

**Template:**

`finishes(Interval1,Interval2)`

**Mode and number of proofs:**

`finishes(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `finished_by/2`

True if `Interval1` is finished by `Interval2`.

**Compilation flags:**

`static`

**Template:**

`finished_by(Interval1,Interval2)`

**Mode and number of proofs:**

`finished_by(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

###### `equal/2`

True if `Interval1` is equal to `Interval2`.

**Compilation flags:**

`static`

**Template:**

`equal(Interval1,Interval2)`

**Mode and number of proofs:**

`equal(@interval,@interval)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

interval

### iso8601")

**object**

#### `iso8601`

ISO 8601 (and European civil calendar) compliant library of date predicates.

**Availability:**

`logtalk_load(iso8601(loader))`

**Author:** Daniel L. Dudley and Paulo Moura

**Version:** 1:1:0

**Date:** 2026-02-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

os

**Remarks:**

> - Scope: This object currently provides a powerful, versatile and efficient set of date-handling predicates, which–thanks to Logtalk–may be used as is on a wide range of Prolog compilers. Besides taking time to familiarize oneself with each predicate, the user should take note of the following information.
>
> - Validation of dates: Date parts are not validated–that is the caller’s responsibility! However, not being quite heartless yet, we do provide a predicate for this purpose.
>
> - Date arithmetic: Many of the examples illustrate a simplified method of doing date arithmetic. Note, however, that we do not generally recommend this practice–it is all too easy to make mistakes. The safest way of finding the day difference between two dates is to first convert the dates to their Julian day numbers and then subtract one from the other. Similarly, the safe way to add or subtract a day offset to a particular date is to first convert the date to its Julian day number, add or subtract the day offset, and then convert the result to its corresponding date.
>
> - BC years: ISO 8601 specifies that the Gregorian calendar be used, yet requires that years prior to 1 AD be handled arithmetically, i.e., the year we know as 1 BC is year 0, 2 BC is year -1, 3 BC is year -2 and so on. We do not follow ISO 8601 with regard to the handling of BC years. Our date predicates will accept and interpret an input year 0 as 1 BC; however, a negative year, Year, should always be interpreted as `abs(Year)`` ``=:=`` ``Year`` ``BC`. We believe that the average person will find our handling of BC years more user-friendly than the ISO 8601 one, but we encourage feedback from users with a view to a possible change in future versions.
>
> - Week numbers: It is possible for a day (date) to have a week number that belongs to another year. Up to three of the first days of a calendar year may belong to the last week (number) of the prior calendar year, and up to three days of the last days of a calendar year may belong to the first week (number) of the next calendar year. It for this reason that the Week parameter in `date/6-7` is a compound term, namely `week(WeekNo,ActualYear)`.
>
> - Computation of Gregorian Easter Sunday: The algorithm is based upon the “Gaussian rule”. Proleptic use is limited to years \> 1582 AD, that is, after the introduction of the Gregorian calendar.
>
> - Some Christian feast day offsets from Easter Sunday: Carnival Monday: -48 days, Mardi Gras (Shrove Tuesday): -47 days, Ash Wednesday: -46 days, Palm Sunday: -7 days, Easter Friday: -2 days, Easter Saturday: -1 day, Easter Monday: +1 day, Ascension of Christ: +39 days, Whitsunday: +49 days, Whitmonday: +50 days, Feast of Corpus Christi: +60 days.

**Inherited public predicates:**

(none)

- Public predicates

  - `date/4`

  - `date/5`

  - `date/6`

  - `date/7`

  - `date_string/3`

  - `duration_string/2`

  - `interval_string/2`

  - `valid_date/3`

  - `leap_year/1`

  - `calendar_month/3`

  - `easter_day/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `date/4`

Get the system date and/or its Julian Day \# or convert a Julian Day \# to/from given date parts.

**Compilation flags:**

`static`

**Template:**

`date(JD,Year,Month,Day)`

`JD` - Julian day serial number.

`Year` - 0 or negative if converted BC year, positive otherwise.

`Month` - Normally an integer between 1 and 12 inclusive.

`Day` - Normally an integer between 1 and 31 inclusive depending upon month.

**Mode and number of proofs:**

`date(?integer,?integer,?integer,?integer)` - `zero_or_one`

**Examples:**

Current date (i.e., today)

`date(JD,Year,Month,Day)`

`JD=2453471,Year=2005,Month=4,Day=10`

Convert a date to its Julian day number

`date(JD,2000,2,29)`

`JD=2451604`

Convert a Julian day number to its date

`date(2451604,Year,Month,Day)`

`Year=2000,Month=2,Day=29`

What is the date of day \# 60 in year 2000?

`date(JD,2000,1,60)`

`JD=2451604`

What is the Julian of the 1st day prior to 2000-1-1?

`date(JD,2000,1,0)`

`JD=2451544`

What is the Julian of the 60th day prior to 2000-1-1?

`date(JD,2000,1,-59)`

`JD=2451485`

Illegal date is auto-adjusted (see also next query)

`date(JD,1900,2,29)`

`JD=2415080`

This is the correct date!

`date(2415080,Year,Month,Day)`

`Year=1900,Month=3,Day=1`

------------------------------------------------------------------------

###### `date/5`

Ditto `date/4` + get/check its day-of-week \#.

**Compilation flags:**

`static`

**Template:**

`date(JD,Year,Month,Day,DoW)`

`JD` - Julian day serial number.

`Year` - 0 or negative if converted BC year, positive otherwise.

`Month` - Normally an integer between 1 and 12 inclusive.

`Day` - Normally an integer between 1 and 31 inclusive depending upon month.

`DoW` - Day of week, where Monday=1, Tuesday=2, …, Sunday=7.

**Mode and number of proofs:**

`date(?integer,?integer,?integer,?integer,?integer)` - `zero_or_one`

**Examples:**

Get the Julian and the day-of-week \# of a date

`date(JD,2000,2,29,DoW)`

`JD=2451604,DoW=2`

Check the validity of a given date (day-of-week is 2, not 4)

`date(_,2002,3,5,4)`

`no`

Get the Julian day of a given date if it is a Sunday

`date(JD,2004,2,29,7)`

`JD=2453065`

Get the date and day-of-week \# of a Julian

`date(2451545,Year,Month,Day,DoW)`

`Year=2000,Month=1,Day=1,DoW=6`

------------------------------------------------------------------------

###### `date/6`

Ditto `date/5` + get/check its week \#.

**Compilation flags:**

`static`

**Template:**

`date(JD,Year,Month,Day,DoW,Week)`

`JD` - Julian day serial number.

`Year` - 0 or negative if converted BC year, positive otherwise.

`Month` - Normally an integer between 1 and 12 inclusive.

`Day` - Normally an integer between 1 and 31 inclusive depending upon month.

`DoW` - Day of week, where Monday=1, Tuesday=2, …, Sunday=7.

`Week` - Compound term, `week(WeekNo,ActualYear)`, of a day.

**Mode and number of proofs:**

`date(?integer,?integer,?integer,?integer,?integer,?compound)` - `zero_or_one`

**Examples:**

Get the day-of-week and week number of a date

`date(_,2000,1,1,DoW,Week)`

`DoW=6,Week=week(52,1999)`

Get the week number and year of this week

`date(_,_,_,_,_,Week)`

`Week=week(7,2004)`

Get the Julian number and the week of a date if it is a Sunday

`date(JD,2004,2,29,7,Week)`

`JD=2453065,Week=week(9,2004)`

Get the day-of-week and week of a Julian day number

`date(2453066,_,_,_,DoW,Week)`

`DoW=1,Week=week(10,2004)`

Check that given date data matches

`date(_,2004,3,1,1,week(10,2004))`

`yes`

What is the date of a day of week (default is 1) in given week \# and year?

`date(_,Year,Month,Day,DoW,week(26,2004))`

`Year=2004,Month=6,Day=21,DoW=1`

Ditto for Sunday

`date(_,Year,Month,Day,7,week(1,2005))`

`Year=2005,Month=1,Day=9`

Ditto for Tuesday in following week

`date(_,Year,Month,Day,9,week(1,2005))`

`Year=2005,Month=1,Day=11`

Ditto for Thursday in the prior week

`date(_,Year,Month,Day,4,week(0,2005))`

`Year=2004,Month=12,Day=30`

Ditto for Tuesday two weeks prior

`date(_,Year,Month,Day,2,week(-1,2005))`

`Year=2004,Month=12,Day=21`

Ditto for Saturday

`date(_,Year,Month,Day,6,week(53,2004))`

`Year=2005,Month=1,Day=1`

Ditto for Monday (note automatic compensation of nonexistent week number)

`date(_,Year,Month,Day,1,week(60,2004))`

`Year=2005,Month=2,Day=14`

------------------------------------------------------------------------

###### `date/7`

Ditto `date/6` + get/check its day-of-year \#.

**Compilation flags:**

`static`

**Template:**

`date(JD,Year,Month,Day,DoW,Week,DoY)`

`JD` - Julian day serial number.

`Year` - 0 or negative if converted BC year, positive otherwise.

`Month` - Normally an integer between 1 and 12 inclusive.

`Day` - Normally an integer between 1 and 31 inclusive depending upon month.

`DoW` - Day of week, where Monday=1, Tuesday=2, …, Sunday=7.

`Week` - Compound term, `week(WeekNo,ActualYear)`, of a day.

`DoY` - Day of year (NB! calendar year, not week \# year).

**Mode and number of proofs:**

`date(?integer,?integer,?integer,?integer,?integer,?compound,?integer)` - `zero_or_one`

**Examples:**

Get the date and day-of-year of a Julian number

`date(2451649,Year,Month,Day,_,_,DoY)`

`Year=2000,Month=4,Day=14,DoY=105`

Get the Julian number, week number and day-of-year of a date, confirming that it is a Sunday

`date(JD,2004,2,29,7,Week,DoY)`

`JD=2453065,Week=week(9,2004),DoY=60`

Confirm that a date is, in fact, a specific day-of-year

`date(_,2004,3,1,_,_,61)`

`yes`

Get the Julian number, week day and day-of-year of a date

`date(JD,2004,10,18,DoW,_,DoY)`

`JD=2453297,DoW=1,DoY=292`

Get today’s day-of-year

`date(_,_,_,_,_,_,DoY)`

`DoY=54`

Get all missing date data (excl. Julian number) for the 60th calendar day of 2004

`date(_,2004,Month,Day,DoW,Week,60)`

`Month=2,Day=29,DoW=7,Week=week(9,2004)`

Match given date data and, if true, return the missing data (excl. Julian number)

`date(_,2004,3,Day,DoW,Week,61)`

`Day=1,DoW=1,Week=week(10,2004)`

Ditto (the 61st day-of-year cannot be both day 1 and 2 of the month)

`date(_,2004,_,2,_,_,61)`

`no`

------------------------------------------------------------------------

###### `date_string/3`

Conversion between an ISO 8601 compliant date string and its components (truncated and expanded date representations are currently unsupported). Note that date components are not validated; that is the caller’s responsibility!

**Compilation flags:**

`static`

**Template:**

`date_string(Format,Components,String)`

`Format` - ISO 8601 format.

`Components` - When bound and String is free, either a Julian number or a `[Year,Month,Day]` term; it binds to the system day/date if free When free and String is bound, it binds to an integer list representing the numeric elements of String.

`String` - ISO 8601 formatted string correspondent to Components.

**Mode and number of proofs:**

`date_string(+atom,+integer,?atom)` - `zero_or_one`

`date_string(+atom,?list,?atom)` - `zero_or_one`

**Examples:**

Date, complete, basic (section 5.2.1.1)

`date_string('YYYYMMDD',[2004,2,29],String)`

`String='20040229'`

Date, complete, basic (section 5.2.1.1)

`date_string('YYYYMMDD',Components,'20040229')`

`Components=[2004,2,29]`

Date, complete, extended (section 5.2.1.1)

`date_string('YYYY-MM-DD',[2003,12,16],String)`

`String='2003-12-16'`

Date, complete, extended (section 5.2.1.1)

`date_string('YYYY-MM-DD',Components,'2003-12-16')`

`Components=[2003,12,16]`

Date, complete, extended (section 5.2.1.1)

`date_string('YYYY-MM-DD',_,String)`

`String='2004-02-17'`

Date, complete, extended (section 5.2.1.1)

`date_string('YYYY-MM-DD',Components,'2004-02-17')`

`Components=[2004,2,17]`

Date, reduced, month (section 5.2.1.2 a)

`date_string('YYYY-MM',[2004,9,18],String)`

`String='2004-09'`

Date, reduced, month (section 5.2.1.2 a)

`date_string('YYYY-MM',Components,'2004-09')`

`Components=[2004,9]`

Date, reduced, year (section 5.2.1.2 b)

`date_string('YYYY',[1900,7,24],String)`

`String='1900'`

Date, reduced, year (section 5.2.1.2 b)

`date_string('YYYY',Components,'1900')`

`Components=[1900]`

Date, reduced, century (section 5.2.1.2 c)

`date_string('YY',2456557,String)`

`String='20'`

Date, reduced, century (section 5.2.1.2 c)

`date_string('YY',Components,'20')`

`Components=[20]`

Date, ordinal, complete (section 5.2.2.1)

`date_string('YYYYDDD',[2005,3,25],String)`

`String='2005084'`

Date, ordinal, complete (section 5.2.2.1)

`date_string('YYYYDDD',Components,'2005084')`

`Components=[2005,84]`

Date, ordinal, extended (section 5.2.2.1)

`date_string('YYYY-DDD',[1854,12,4],String)`

`String='1854-338'`

Date, ordinal, extended (section 5.2.2.1)

`date_string('YYYY-DDD',Components,'1854-338')`

`Components=[1854,338]`

Week, complete, basic (section 5.2.3.1)

`date_string('YYYYWwwD',[2000,1,2],String)`

`String='1999W527'`

Week, complete, basic (section 5.2.3.1)

`date_string('YYYYWwwD',Components,'1999W527')`

`Components=[1999,52,7]`

Week, complete, extended (section 5.2.3.1)

`date_string('YYYY-Www-D',[2003,12,29],String)`

`String='2004-W01-1'`

Week, complete, extended (section 5.2.3.1)

`date_string('YYYY-Www-D',Components,'2004-W01-1')`

`Components=[2004,1,1]`

Week, complete, extended (section 5.2.3.1)

`date_string('YYYY-Www-D',2453167,String)`

`String='2004-W24-4'`

Week, complete, extended (section 5.2.3.1)

`date_string('YYYY-Www-D',Components,'2004-W24-4')`

`Components=[2004,24,4]`

Week, reduced, basic (section 5.2.3.2)

`date_string('YYYYWww',[2004,2,29],String)`

`String='2004W09'`

Week, reduced, basic (section 5.2.3.2)

`date_string('YYYYWww',Components,'2004W09')`

`Components=[2004,9]`

Week, reduced, extended (section 5.2.3.2)

`date_string('YYYY-Www',[2004,2,29],String)`

`String='2004-W09'`

Week, reduced, extended (section 5.2.3.2)

`date_string('YYYY-Www',Components,'2004-W09')`

`Components=[2004,9]`

------------------------------------------------------------------------

###### `duration_string/2`

Conversion between an ISO 8601 duration string and a `duration(Years,Months,Days,Hours,Minutes,Seconds)` term.

**Compilation flags:**

`static`

**Template:**

`duration_string(Duration,String)`

**Mode and number of proofs:**

`duration_string(++compound,?atom)` - `zero_or_one`

`duration_string(?compound,+atom)` - `zero_or_one`

**Remarks:**

> - Duration string: An ISO 8601 duration string encodes a length of time (not a calendar date), starting with `P` and optionally using date and time parts such as `P3D` or `P1Y2M3DT4H5M6S`.

**Examples:**

Parse a duration string

`duration_string(Duration,'PT45M')`

`Duration=duration(0,0,0,0,45,0)`

Format a duration term

`duration_string(duration(1,2,3,4,5,6),String)`

`String='P1Y2M3DT4H5M6S'`

------------------------------------------------------------------------

###### `interval_string/2`

Conversion between an ISO 8601 interval string and an `interval(Start,End)`, `interval(Start,Duration)`, or `interval(Duration,End)` term where date endpoints are `[Year,Month,Day]` terms.

**Compilation flags:**

`static`

**Template:**

`interval_string(Interval,String)`

**Mode and number of proofs:**

`interval_string(++compound,?atom)` - `zero_or_one`

`interval_string(?compound,+atom)` - `zero_or_one`

**Remarks:**

> - Interval string: An ISO 8601 interval string encodes a time interval using two parts separated by `/`; each part is a date or a duration, e.g. `2026-02-25/2026-03-01` or `2026-02-25/P3D`.

**Examples:**

Parse a start/date + duration interval

`interval_string(Interval,'2026-02-25/P3D')`

`Interval=interval([2026,2,25],duration(0,0,3,0,0,0))`

Format a date/date interval

`interval_string(interval([2026,2,25],[2026,3,1]),String)`

`String='2026-02-25/2026-03-01'`

------------------------------------------------------------------------

###### `valid_date/3`

Validate a given date in the Gregorian calendar.

**Compilation flags:**

`static`

**Template:**

`valid_date(Year,Month,Day)`

**Mode and number of proofs:**

`valid_date(+integer,+integer,+integer)` - `zero_or_one`

**Examples:**

Yes, the recent millennium was a leap year

`valid_date(2000,2,29)`

`yes`

2004 was also a leap year

`valid_date(2004,2,29)`

`yes`

Only 30 days in April

`valid_date(2004,4,31)`

`no`

1 BC was a leap year

`valid_date(-1,2,29)`

`yes`

------------------------------------------------------------------------

###### `leap_year/1`

Succeed if given year is a leap year in the Gregorian calendar.

**Compilation flags:**

`static`

**Template:**

`leap_year(Year)`

`Year` - The Gregorian calendar year to investigate. If free, it binds to the system year.

**Mode and number of proofs:**

`leap_year(?integer)` - `zero_or_one`

**Examples:**

No, the prior centenary was not a leap year

`leap_year(1900)`

`no`

The recent millennium

`leap_year(2000)`

`yes`

This year

`leap_year(Year)`

`Year=2004`

This year (equivalent to prior query)

`leap_year(_)`

`yes`

Next centennial

`leap_year(2100)`

`no`

Year 0, equivalent to 1 BC

`leap_year(0)`

`yes`

1 BC

`leap_year(-1)`

`yes`

4 BC

`leap_year(-4)`

`no`

5 BC

`leap_year(-5)`

`yes`

------------------------------------------------------------------------

###### `calendar_month/3`

Compute a calendar month.

**Compilation flags:**

`static`

**Template:**

`calendar_month(Year,Month,Calendar)`

`Year` - The calendar year.

`Month` - The calendar month.

`Calendar` - A compound term, `m/3`, composed of three main arguments specifying year, month, and a list of week and week day numbers (calendar body).

**Mode and number of proofs:**

`calendar_month(?integer,?integer,-compound)` - `zero_or_one`

**Examples:**

Compute the calendar of March, 2005

`calendar_month(2005,3,Calendar)`

`Calendar=m(2005,3,[w(9,[0,1,2,3,4,5,6]),w(10,[7,8,9,10,11,12,13]),w(11,[14,15,16,17,18,19,20]),w(12,[21,22,23,24,25,26,27]),w(13,[28,29,30,31,0,0,0]),w(0,[0,0,0,0,0,0,0])])`

------------------------------------------------------------------------

###### `easter_day/3`

Compute a Gregorian Easter Sunday.

**Compilation flags:**

`static`

**Template:**

`easter_day(Year,Month,Day)`

`Year` - Integer specifying the year to be investigated.

`Month` - Month in which Easter Sunday falls for given year.

`Day` - Day of month in which Easter Sunday falls for given year.

**Mode and number of proofs:**

`easter_day(?integer,-integer,-integer)` - `zero_or_one`

**Examples:**

Compute Easter Sunday for a particular year

`easter_day(2006,Month,Day)`

`Month=4,Day=16`

Compute Easter Sunday for the current year

`easter_day(Year,Month,Day)`

`Year=2005,Month=3,Day=27`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### isolation_forest")

**object**

#### `isolation_forest`

Extended Isolation Forest (EIF) algorithm for anomaly detection. Implements the improved version described by Hariri et al. (2019) that uses random hyperplane cuts instead of axis-aligned cuts, eliminating score bias artifacts. Builds an ensemble of isolation trees from a dataset object implementing the `dataset_protocol` protocol. Missing attribute values are represented using anonymous variables.

**Availability:**

`logtalk_load(isolation_forest(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` classifier_protocol

**Imports:**

`public` options

**Uses:**

fast_random(Algorithm)

format

integer

list

numberlist

pairs

type

**Remarks:**

> - Algorithm: The Extended Isolation Forest builds an ensemble of isolation trees (iTrees) by recursively partitioning the data using random hyperplanes. Anomalous points, being few and different, require fewer partitions (shorter path lengths) to be isolated.
>
> - Extended vs Original: The original Isolation Forest uses axis-aligned splits (random attribute + random value), which introduces bias in anomaly scores along coordinate axes. The extended version uses random hyperplane cuts with arbitrary slopes, producing more consistent and reliable anomaly scores.
>
> - Extension level: The extension level controls the dimensionality of the random hyperplane cuts. Level 0 corresponds to the original axis-aligned Isolation Forest. The default level is `d`` ``-`` ``1` (fully extended) where `d` is the number of dimensions.
>
> - Prediction: The `predict/3` predicate returns `anomaly` if the anomaly score is above the threshold (default: 0.5) and `normal` otherwise. The `score_all/3` predicate returns a sorted list of all instances with their corresponding scores and class labels. Predictions use by default the learned model options but can override them using the `anomaly_threshold/1` option.
>
> - Anomaly score: The anomaly score `s(x)` is computed as `s(x)`` ``=`` ``2^(-E(h(x))/c(psi))` where `E(h(x))` is the average path length across all trees, `c(psi)` is the average path length of unsuccessful searches in a BST, and `psi` is the subsample size. Scores close to 1 indicate anomalies; scores below 0.5 indicate normal points.
>
> - Discrete attributes: Discrete (categorical) attributes are mapped to numeric indices based on their position in the attribute value list declared by the dataset. This allows the algorithm to handle datasets with mixed attribute types.
>
> - Missing values: Missing attribute values are represented using anonymous variables. During tree construction, missing values are replaced with random values drawn from the observed range of the corresponding attribute. During scoring, instances with missing values are sent down both branches of the tree and the path length is computed as the weighted average of the two branches.
>
> - Classifier representation: The learned model is represented as an `if_model(Trees,`` ``SubsampleSize,`` ``AttributeNames,`` ``Attributes,`` ``Ranges,`` ``Options)` compound term.

**Inherited public predicates:**

 check_option/1  check_options/1  classifier_to_clauses/4  classifier_to_file/4  default_option/1  default_options/1  learn/2  option/2  option/3  predict/3  print_classifier/1  valid_option/1  valid_options/1

- Public predicates

  - `learn/3`

  - `predict/4`

  - `score/3`

  - `score_all/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `learn/3`

Learns an isolation forest model from the given dataset object using the specified options. Valid options are `number_of_trees/1` (default: `100`), `subsample_size/1` (default: `256` or the number of instances if smaller), `extension_level/1` (default: `d`` ``-`` ``1` where `d` is the number of dimensions), and `anomaly_threshold/1` (default: `0.5`).

**Compilation flags:**

`static`

**Template:**

`learn(Dataset,Model,Options)`

**Mode and number of proofs:**

`learn(+object_identifier,-compound,+list(compound))` - `one`

------------------------------------------------------------------------

###### `predict/4`

Predicts whether an instance is an anomaly or normal using the learned model and the anomaly threshold with the given options. The instance is a list of `Attribute-Value` pairs where missing values are represented using anonymous variables. Returns `anomaly` if the anomaly score is above the threshold, `normal` otherwise.

**Compilation flags:**

`static`

**Template:**

`predict(Model,Instance,Prediction,Options)`

**Mode and number of proofs:**

`predict(+compound,+list,-atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `score/3`

Computes the anomaly score for a given instance using the learned model. The instance is a list of `Attribute-Value` pairs where missing values are represented using anonymous variables. The score is in the range `[0.0,`` ``1.0]`. Scores close to `1.0` indicate anomalies. Scores close to `0.5` or below indicate normal instances.

**Compilation flags:**

`static`

**Template:**

`score(Model,Instance,Score)`

**Mode and number of proofs:**

`score(+compound,+list,-float)` - `one`

------------------------------------------------------------------------

###### `score_all/3`

Computes the anomaly scores for all instances in the dataset. Returns a list of `Id-Class-Score` triples sorted by descending anomaly score.

**Compilation flags:**

`static`

**Template:**

`score_all(Dataset,Model,Scores)`

**Mode and number of proofs:**

`score_all(+object_identifier,+compound,-list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

dataset_protocol, c45, random_forest, ada_boost

### issue_creator")

**object**

#### `issue_creator`

Support for automatically creating bug report issues for failed tests in GitHub or GitLab servers.

**Availability:**

`logtalk_load(issue_creator(loader))`

**Author:** Paulo Moura

**Version:** 0:12:1

**Date:** 2025-03-03

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Uses:**

git

os

term_io

user

**Remarks:**

> - Usage: This tool is automatically loaded and used from the `logtalk_tester` automation script when using its `-b` option. See the script man page for details.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### java")

**object**

#### `java`

Abstract interface to JPL API utility predicates.

**Availability:**

`logtalk_load(java(loader))`

**Author:** Paulo Moura

**Version:** 1:8:0

**Date:** 2023-03-15

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` java_utils_protocol

**Uses:**

user

**Remarks:**

(none)

**Inherited public predicates:**

 array_list/2  array_to_list/2  array_to_terms/2  array_to_terms/3  decode_exception/2  decode_exception/3  false/1  is_false/1  is_null/1  is_object/1  is_true/1  is_void/1  iterator_element/2  list_to_array/2  map_element/2  null/1  set_element/2  terms_to_array/2  true/1  value_reference/2  void/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

java(Reference,ReturnValue), java(Reference), java_hook

**object**

#### `java(Reference)`

- `Reference` - Either a class name or a Java reference to an object.

Minimal abstraction of the JPL API for calling Java from Logtalk using familiar message-sending syntax and a `forward/1` handler to resolve methods.

**Availability:**

`logtalk_load(java(loader))`

**Author:** Paulo Moura and Sergio Castro

**Version:** 1:0:1

**Date:** 2019-06-13

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` java(Reference,\_)

**Remarks:**

> - Usage: Send to this object any valid message as listed in the JavaDocs for the given reference.

**Inherited public predicates:**

 forward/1  get_field/2  invoke/1  invoke/2  new/1  new/2  set_field/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

java(Reference,ReturnValue), java, java_hook

**object**

#### `java(Reference,ReturnValue)`

- `Reference` - Either a class name or a Java reference to an object.

- `ReturnValue` - Value returned by a method call (possibly the Java value void).

Minimal abstraction of the JPL API for calling Java from Logtalk using familiar message-sending syntax and a `forward/1` handler to resolve methods.

**Availability:**

`logtalk_load(java(loader))`

**Author:** Paulo Moura and Sergio Castro

**Version:** 1:4:0

**Date:** 2023-03-13

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` forwarding

`public` java_access_protocol

**Remarks:**

> - Usage: Send to this object any valid message as listed in the JavaDocs for the given reference.

**Inherited public predicates:**

 forward/1  get_field/2  invoke/1  invoke/2  new/1  new/2  set_field/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

java(Reference), java, java_hook

**protocol**

#### `java_access_protocol`

Protocol for a minimal abstraction for calling Java from Logtalk using familiar message-sending syntax.

**Availability:**

`logtalk_load(java(loader))`

**Author:** Paulo Moura and Sergio Castro

**Version:** 1:2:1

**Date:** 2023-03-16

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `get_field/2`

  - `set_field/2`

  - `new/2`

  - `new/1`

  - `invoke/1`

  - `invoke/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `get_field/2`

Gets the value of a class or object field.

**Compilation flags:**

`static`

**Template:**

`get_field(Field,Value)`

**Mode and number of proofs:**

`get_field(+atom,?nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `set_field/2`

Sets the value of a class or object field.

**Compilation flags:**

`static`

**Template:**

`set_field(Field,Value)`

**Mode and number of proofs:**

`set_field(+atom,+nonvar)` - `one`

------------------------------------------------------------------------

###### `new/2`

Creates a new instance using the specified parameter values.

**Compilation flags:**

`static`

**Template:**

`new(Parameters,Instance)`

**Mode and number of proofs:**

`new(+list(nonvar),-reference)` - `one`

------------------------------------------------------------------------

###### `new/1`

Creates a new instance using default parameter values.

**Compilation flags:**

`static`

**Template:**

`new(Instance)`

**Mode and number of proofs:**

`new(-reference)` - `one`

------------------------------------------------------------------------

###### `invoke/1`

Invokes a method. This is a more efficient compared with relying on the `forward/1` handler to resolve methods.

**Compilation flags:**

`static`

**Template:**

`invoke(Method)`

**Mode and number of proofs:**

`invoke(@nonvar)` - `one`

------------------------------------------------------------------------

###### `invoke/2`

Invokes a method. This is a more efficient compared with relying on the `forward/1` handler to resolve methods.

**Compilation flags:**

`static`

**Template:**

`invoke(Functor,Arguments)`

**Mode and number of proofs:**

`invoke(@nonvar,@list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**object**

#### `java_hook`

Hook object to optimize messages to the `java/1-2` objects that otherwise would trigger the `forward/1` handler.

**Availability:**

`logtalk_load(java(loader))`

**Author:** Paulo Moura

**Version:** 1:0:1

**Date:** 2019-06-13

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Remarks:**

> - Usage: Compile source files with messages to the `java/1-2` objects using the compiler option `hook(java_hook)`.

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

java(Reference,ReturnValue), java(Reference)

**protocol**

#### `java_utils_protocol`

Abstract interface to Java utility predicates.

**Availability:**

`logtalk_load(java(loader))`

**Author:** Paulo Moura

**Version:** 1:6:0

**Date:** 2023-03-13

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `value_reference/2`

  - `true/1`

  - `false/1`

  - `void/1`

  - `null/1`

  - `is_true/1`

  - `is_false/1`

  - `is_void/1`

  - `is_null/1`

  - `is_object/1`

  - `terms_to_array/2`

  - `array_to_terms/3`

  - `array_to_terms/2`

  - `array_to_list/2`

  - `list_to_array/2`

  - `array_list/2`

  - `iterator_element/2`

  - `map_element/2`

  - `set_element/2`

  - `decode_exception/2`

  - `decode_exception/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `value_reference/2`

Returns an opaque term that represents the Java value with the given name.

**Compilation flags:**

`static`

**Template:**

`value_reference(Value,Reference)`

**Mode and number of proofs:**

`value_reference(?atom,--ground)` - `one_or_more`

------------------------------------------------------------------------

###### `true/1`

Returns an opaque term that represents the Java value *true*.

**Compilation flags:**

`static`

**Template:**

`true(Reference)`

**Mode and number of proofs:**

`true(--ground)` - `one`

------------------------------------------------------------------------

###### `false/1`

Returns an opaque term that represents the Java value *false*.

**Compilation flags:**

`static`

**Template:**

`false(Reference)`

**Mode and number of proofs:**

`false(--ground)` - `one`

------------------------------------------------------------------------

###### `void/1`

Returns an opaque term that represents the Java value *void*.

**Compilation flags:**

`static`

**Template:**

`void(Reference)`

**Mode and number of proofs:**

`void(--ground)` - `one`

------------------------------------------------------------------------

###### `null/1`

Returns an opaque term that represents the Java value *null*.

**Compilation flags:**

`static`

**Template:**

`null(Reference)`

**Mode and number of proofs:**

`null(--ground)` - `one`

------------------------------------------------------------------------

###### `is_true/1`

True when the argument is the Java value *true*. Fails if the argument is not instantiated.

**Compilation flags:**

`static`

**Template:**

`is_true(Reference)`

**Mode and number of proofs:**

`is_true(@term)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_false/1`

True when the argument is the Java value *false*. Fails if the argument is not instantiated.

**Compilation flags:**

`static`

**Template:**

`is_false(Reference)`

**Mode and number of proofs:**

`is_false(@term)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_void/1`

True when the argument is the Java value *void*. Fails if the argument is not instantiated.

**Compilation flags:**

`static`

**Template:**

`is_void(Reference)`

**Mode and number of proofs:**

`is_void(@term)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_null/1`

True when the argument is the Java value *null*. Fails if the argument is not instantiated.

**Compilation flags:**

`static`

**Template:**

`is_null(Reference)`

**Mode and number of proofs:**

`is_null(@term)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_object/1`

True when the argument is a reference to a Java object. Fails if the argument is not instantiated.

**Compilation flags:**

`static`

**Template:**

`is_object(Reference)`

**Mode and number of proofs:**

`is_object(@term)` - `zero_or_one`

------------------------------------------------------------------------

###### `terms_to_array/2`

Converts a list of ground Prolog terms to an array (a Java reference).

**Compilation flags:**

`static`

**Template:**

`terms_to_array(Terms,Array)`

**Mode and number of proofs:**

`terms_to_array(++list(ground),-array)` - `one`

------------------------------------------------------------------------

###### `array_to_terms/3`

Converts an array (a Java reference) to a list of ground Prolog terms returning also its length. The array elements must be atoms, integers, floats, or compound terms. Fails otherwise.

**Compilation flags:**

`static`

**Template:**

`array_to_terms(Array,Terms,Length)`

**Mode and number of proofs:**

`array_to_terms(+array,-list(ground),-integer)` - `one`

------------------------------------------------------------------------

###### `array_to_terms/2`

Converts an array (a Java reference) to a list of ground Prolog terms. The array elements must be atoms, integers, floats, or ground compound terms. Fails otherwise.

**Compilation flags:**

`static`

**Template:**

`array_to_terms(Array,Terms)`

**Mode and number of proofs:**

`array_to_terms(+array,-list(term))` - `one`

------------------------------------------------------------------------

###### `array_to_list/2`

Converts an array (a Java reference) to a list of Java references or their values.

**Compilation flags:**

`static`

**Template:**

`array_to_list(Array,List)`

**Mode and number of proofs:**

`array_to_list(+array,-list)` - `one`

------------------------------------------------------------------------

###### `list_to_array/2`

Converts a list of Java references or values to an array (a Java reference).

**Compilation flags:**

`static`

**Template:**

`list_to_array(List,Array)`

**Mode and number of proofs:**

`list_to_array(+list,-array)` - `one`

------------------------------------------------------------------------

###### `array_list/2`

Converts between an array (a Java reference) and a list of Java references or their values. Deprecated. Use the `array_to_list/2` and `list_to_array/2` predicates instead.

**Compilation flags:**

`static`

**Template:**

`array_list(Array,List)`

**Mode and number of proofs:**

`array_list(+array,-list)` - `one`

`array_list(-array,+list)` - `one`

------------------------------------------------------------------------

###### `iterator_element/2`

Enumerates, by backtracking, all iterator elements.

**Compilation flags:**

`static`

**Template:**

`iterator_element(Iterator,Element)`

**Mode and number of proofs:**

`iterator_element(+iterator,-element)` - `zero_or_more`

------------------------------------------------------------------------

###### `map_element/2`

Enumerates, by backtracking, all map elements.

**Compilation flags:**

`static`

**Template:**

`map_element(Map,Element)`

**Mode and number of proofs:**

`map_element(+iterator,-element)` - `zero_or_more`

------------------------------------------------------------------------

###### `set_element/2`

Enumerates, by backtracking, all set elements.

**Compilation flags:**

`static`

**Template:**

`set_element(Set,Element)`

**Mode and number of proofs:**

`set_element(+iterator,-element)` - `zero_or_more`

------------------------------------------------------------------------

###### `decode_exception/2`

Decodes an exception into its corresponding cause. Fails if the exception is not a Java exception.

**Compilation flags:**

`static`

**Template:**

`decode_exception(Exception,Cause)`

**Mode and number of proofs:**

`decode_exception(+callable,-atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `decode_exception/3`

Decodes an exception into its corresponding cause and a stack trace. Fails if the exception is not a Java exception.

**Compilation flags:**

`static`

**Template:**

`decode_exception(Exception,Cause,StackTrace)`

**Mode and number of proofs:**

`decode_exception(+callable,-atom,-list(atom))` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### json")

**object**

#### `json`

JSON parser and generator. Uses curly terms for parsed JSON objects, dashes for parsed JSON pairs, and atoms for parsed JSON strings.

**Availability:**

`logtalk_load(json(loader))`

**Author:** Paulo Moura and Jacinto Dávila

**Version:** 1:1:0

**Date:** 2022-11-14

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` json(curly,dash,atom)

**Remarks:**

(none)

**Inherited public predicates:**

 generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `json(StringRepresentation)`

- `StringRepresentation` - Text representation to be used when decoding JSON strings. Possible values are `atom` (default), `chars`, and `codes`.

JSON parser and generator. Uses curly terms for parsed JSON objects and dashes for parsed JSON pairs.

**Availability:**

`logtalk_load(json(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2022-11-14

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` json(curly,dash,StringRepresentation)

**Remarks:**

(none)

**Inherited public predicates:**

 generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `json(ObjectRepresentation,PairRepresentation,StringRepresentation)`

- `ObjectRepresentation` - Object representation to be used when decoding JSON objects. Possible values are `curly` (default) and `list`.

- `PairRepresentation` - Pair representation to be used when decoding JSON objects. Possible values are `dash` (default), `equal`, and `colon`.

- `StringRepresentation` - Text representation to be used when decoding JSON strings. Possible values are `atom` (default), `chars`, and `codes`.

JSON parser and generator.

**Availability:**

`logtalk_load(json(loader))`

**Author:** Paulo Moura and Jacinto Dávila

**Version:** 0:14:0

**Date:** 2026-01-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` json_protocol

**Uses:**

reader

**Remarks:**

(none)

**Inherited public predicates:**

 generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `json_protocol`

JSON parser and generator protocol.

**Availability:**

`logtalk_load(json(loader))`

**Author:** Paulo Moura and Jacinto Dávila

**Version:** 0:11:0

**Date:** 2022-11-09

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses the JSON contents read from the given source (`codes(List)`, `stream(Stream)`, `line(Stream)`, `file(Path)`, `chars(List)`, or `atom(Atom)`) into a term. Fails if the JSON contents cannot be parsed.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Term)`

**Mode and number of proofs:**

`parse(++compound,--term)` - `one_or_error`

------------------------------------------------------------------------

###### `generate/2`

Generates the content using the representation specified in the first argument (`codes(List)`, `stream(Stream)`, `file(Path)`, `chars(List)`, or `atom(Atom)`) for the term in the second argument. Fails if this term cannot be processed.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Term)`

**Mode and number of proofs:**

`generate(+compound,++term)` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### json_ld")

**object**

#### `json_ld`

JSON-LD 1.1 parser, generator, and processor. Uses curly terms for parsed JSON objects, dashes for parsed JSON pairs, and atoms for parsed JSON strings.

**Availability:**

`logtalk_load(json_ld(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-05

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` json_ld(curly,dash,atom)

**Remarks:**

(none)

**Inherited public predicates:**

 compact/3  expand/2  flatten/2  generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `json_ld(StringRepresentation)`

- `StringRepresentation` - Text representation to be used when decoding JSON strings. Possible values are `atom` (default), `chars`, and `codes`.

JSON-LD 1.1 parser, generator, and processor. Uses curly terms for parsed JSON objects and dashes for parsed JSON pairs.

**Availability:**

`logtalk_load(json_ld(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-05

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` json_ld(curly,dash,StringRepresentation)

**Remarks:**

(none)

**Inherited public predicates:**

 compact/3  expand/2  flatten/2  generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `json_ld(ObjectRepresentation,PairRepresentation,StringRepresentation)`

- `ObjectRepresentation` - Object representation to be used when decoding JSON objects. Possible values are `curly` (default) and `list`.

- `PairRepresentation` - Pair representation to be used when decoding JSON objects. Possible values are `dash` (default), `equal`, and `colon`.

- `StringRepresentation` - Text representation to be used when decoding JSON strings. Possible values are `atom` (default), `chars`, and `codes`.

JSON-LD 1.1 parser, generator, and processor. Builds on top of the `json` library for JSON parsing and generation.

**Availability:**

`logtalk_load(json_ld(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-05

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` json_ld_protocol

**Uses:**

json(ObjectRepresentation,PairRepresentation,StringRepresentation)

list

**Remarks:**

(none)

**Inherited public predicates:**

 compact/3  expand/2  flatten/2  generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `json_ld_protocol`

JSON-LD 1.1 parser, generator, and processor protocol.

**Availability:**

`logtalk_load(json_ld(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-05

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

  - `expand/2`

  - `compact/3`

  - `flatten/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses a JSON-LD document from the given source (`file(Path)`, `stream(Stream)`, `codes(List)`, `chars(List)`, or `atom(Atom)`) into a term.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Term)`

**Mode and number of proofs:**

`parse(++compound,--term)` - `one_or_error`

**Exceptions:**

`Source` is a variable:

`instantiation_error`

`Source` is neither a variable nor a valid source:

`domain_error(json_ld_source,Source)`

------------------------------------------------------------------------

###### `generate/2`

Generates the content using the representation specified in the first argument (`file(Path)`, `stream(Stream)`, `codes(List)`, `chars(List)`, or `atom(Atom)`) for the term in the second argument.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Term)`

**Mode and number of proofs:**

`generate(+compound,++term)` - `one_or_error`

**Exceptions:**

`Sink` is a variable:

`instantiation_error`

`Sink` cannot be generated:

`domain_error(json_ld_sink,Sink)`

------------------------------------------------------------------------

###### `expand/2`

Expands a parsed JSON-LD document. Expansion removes the context and represents all properties and types as full IRIs. The result is a list of node objects in expanded document form.

**Compilation flags:**

`static`

**Template:**

`expand(Document,Expanded)`

**Mode and number of proofs:**

`expand(+term,--list)` - `one_or_error`

**Exceptions:**

`Document` is a variable:

`instantiation_error`

------------------------------------------------------------------------

###### `compact/3`

Compacts an expanded JSON-LD document using the given context. Compaction applies the context to shorten IRIs to terms or compact IRIs.

**Compilation flags:**

`static`

**Template:**

`compact(Document,Context,Compacted)`

**Mode and number of proofs:**

`compact(+term,+term,--term)` - `one_or_error`

**Exceptions:**

`Document` is a variable:

`instantiation_error`

`Context` is a variable:

`instantiation_error`

------------------------------------------------------------------------

###### `flatten/2`

Flattens an expanded JSON-LD document. Flattening collects all node objects into a flat `@graph` array, with nested nodes replaced by references. Blank node identifiers are generated for nodes without `@id`.

**Compilation flags:**

`static`

**Template:**

`flatten(Document,Flattened)`

**Mode and number of proofs:**

`flatten(+term,--term)` - `one_or_error`

**Exceptions:**

`Document` is a variable:

`instantiation_error`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### json_lines")

**object**

#### `json_lines`

JSON Lines parser and generator. Uses curly terms for parsed JSON objects, dashes for parsed JSON pairs, and atoms for parsed JSON strings.

**Availability:**

`logtalk_load(json_lines(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2025-05-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` json_lines(curly,dash,atom)

**Remarks:**

(none)

**Inherited public predicates:**

 generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `json_lines(StringRepresentation)`

- `StringRepresentation` - Text representation to be used when decoding JSON strings. Possible values are `atom` (default), `chars`, and `codes`.

JSON Lines parser and generator. Uses curly terms for parsed JSON objects and dashes for parsed JSON pairs.

**Availability:**

`logtalk_load(json_lines(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2025-05-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` json_lines(curly,dash,StringRepresentation)

**Remarks:**

(none)

**Inherited public predicates:**

 generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `json_lines(ObjectRepresentation,PairRepresentation,StringRepresentation)`

- `ObjectRepresentation` - Object representation to be used when decoding JSON objects. Possible values are `curly` (default) and `list`.

- `PairRepresentation` - Pair representation to be used when decoding JSON objects. Possible values are `dash` (default), `equal`, and `colon`.

- `StringRepresentation` - Text representation to be used when decoding JSON strings. Possible values are `atom` (default), `chars`, and `codes`.

JSON Lines parser and generator.

**Availability:**

`logtalk_load(json_lines(loader))`

**Author:** Paulo Moura

**Version:** 1:1:0

**Date:** 2026-01-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` json_lines_protocol

**Uses:**

reader

**Remarks:**

(none)

**Inherited public predicates:**

 generate/2  parse/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `json_lines_protocol`

JSON Lines parser and generator protocol.

**Availability:**

`logtalk_load(json_lines(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2025-05-27

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `generate/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses the JSON Lines contents read from the given source (`file(Path)`, `stream(Stream)`, `line(Stream)`, `codes(Codes)`, `chars(Chars)`, or `atom(Atom)`) into a list of ground terms.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Terms)`

**Mode and number of proofs:**

`parse(++compound,--list(ground))` - `one_or_error`

**Exceptions:**

`Source` is a variable:

`instantiation_error`

`Source` is neither a variable nor a valid source:

`domain_error(json_lines_source,Source)`

------------------------------------------------------------------------

###### `generate/2`

Generates the content using the representation specified in the first argument (`file(Path)`, `stream(Stream)`, `codes(Codes)`, `chars(Chars)`, or `atom(Atom)`) for the list of ground terms in the second argument.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Terms)`

**Mode and number of proofs:**

`generate(+compound,++list(ground))` - `one_or_error`

**Exceptions:**

`Sink` is a variable:

`instantiation_error`

`Terms` is a variable:

`instantiation_error`

`Terms` is neither a variable nor a list:

`type_error(list,Terms)`

`Term` is a non-ground element of the list `Terms`:

`instantiation_error`

`Term` is an element of the list `Terms` but not a valid JSON term:

`domain_error(json_term,Term)`

`Sink` cannot be generated:

`domain_error(json_lines_sink,Sink)`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### json_rpc")

**object**

#### `json_rpc`

JSON-RPC 2.0 protocol encoding and decoding. Provides predicates for constructing and parsing JSON-RPC 2.0 request, notification, response, and error objects. Uses the `json` library for JSON parsing and generation.

**Availability:**

`logtalk_load(json_rpc(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-24

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

json

list

reader

**Remarks:**

> - Specification: Implements the JSON-RPC 2.0 specification: https://www.jsonrpc.org/specification
>
> - JSON representation: Uses the `json` library default representation: curly terms for objects, dashes for pairs, and atoms for strings.
>
> - Request: A JSON-RPC 2.0 request is represented as `{jsonrpc-'2.0',`` ``method-Method,`` ``params-Params,`` ``id-Id}`.
>
> - Notification: A JSON-RPC 2.0 notification is represented as `{jsonrpc-'2.0',`` ``method-Method,`` ``params-Params}`.
>
> - Successful response: A JSON-RPC 2.0 successful response is represented as `{jsonrpc-'2.0',`` ``result-Result,`` ``id-Id}`.
>
> - Error response: A JSON-RPC 2.0 error response is represented as `{jsonrpc-'2.0',`` ``error-{code-Code,`` ``message-Message},`` ``id-Id}` or `{jsonrpc-'2.0',`` ``error-{code-Code,`` ``message-Message,`` ``data-Data},`` ``id-Id}`.
>
> - Batch request: A JSON-RPC 2.0 batch request is represented as a list of request and/or notification terms.
>
> - Error codes: Standard error codes: -32700 (parse error), -32600 (invalid request), -32601 (method not found), -32602 (invalid params), -32603 (internal error). Server errors: -32000 to -32099.

**Inherited public predicates:**

(none)

- Public predicates

  - `request/4`

  - `request/3`

  - `notification/3`

  - `notification/2`

  - `response/3`

  - `error_response/4`

  - `error_response/5`

  - `parse_error/1`

  - `invalid_request/1`

  - `method_not_found/2`

  - `invalid_params/2`

  - `internal_error/2`

  - `encode/2`

  - `decode/2`

  - `is_request/1`

  - `is_notification/1`

  - `is_response/1`

  - `is_error_response/1`

  - `is_batch/1`

  - `id/2`

  - `method/2`

  - `params/2`

  - `result/2`

  - `error/2`

  - `error_code/2`

  - `error_message/2`

  - `error_data/2`

  - `write_message/2`

  - `read_message/2`

  - `write_framed_message/2`

  - `read_framed_message/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `request/4`

Constructs a JSON-RPC 2.0 request term.

**Compilation flags:**

`static`

**Template:**

`request(Method,Params,Id,Request)`

**Mode and number of proofs:**

`request(+atom,+list,+nonvar,--compound)` - `one`

------------------------------------------------------------------------

###### `request/3`

Constructs a JSON-RPC 2.0 request term with no parameters.

**Compilation flags:**

`static`

**Template:**

`request(Method,Id,Request)`

**Mode and number of proofs:**

`request(+atom,+nonvar,--compound)` - `one`

------------------------------------------------------------------------

###### `notification/3`

Constructs a JSON-RPC 2.0 notification term (a request without an id).

**Compilation flags:**

`static`

**Template:**

`notification(Method,Params,Notification)`

**Mode and number of proofs:**

`notification(+atom,+list,--compound)` - `one`

------------------------------------------------------------------------

###### `notification/2`

Constructs a JSON-RPC 2.0 notification term with no parameters.

**Compilation flags:**

`static`

**Template:**

`notification(Method,Notification)`

**Mode and number of proofs:**

`notification(+atom,--compound)` - `one`

------------------------------------------------------------------------

###### `response/3`

Constructs a JSON-RPC 2.0 successful response term.

**Compilation flags:**

`static`

**Template:**

`response(Result,Id,Response)`

**Mode and number of proofs:**

`response(+nonvar,+nonvar,--compound)` - `one`

------------------------------------------------------------------------

###### `error_response/4`

Constructs a JSON-RPC 2.0 error response term with a null id (used when the request id cannot be determined).

**Compilation flags:**

`static`

**Template:**

`error_response(Code,Message,Id,ErrorResponse)`

**Mode and number of proofs:**

`error_response(+integer,+atom,+nonvar,--compound)` - `one`

------------------------------------------------------------------------

###### `error_response/5`

Constructs a JSON-RPC 2.0 error response term with additional error data.

**Compilation flags:**

`static`

**Template:**

`error_response(Code,Message,Data,Id,ErrorResponse)`

**Mode and number of proofs:**

`error_response(+integer,+atom,+nonvar,+nonvar,--compound)` - `one`

------------------------------------------------------------------------

###### `parse_error/1`

Constructs a JSON-RPC 2.0 parse error response (-32700) with a null id.

**Compilation flags:**

`static`

**Template:**

`parse_error(ErrorResponse)`

**Mode and number of proofs:**

`parse_error(--compound)` - `one`

------------------------------------------------------------------------

###### `invalid_request/1`

Constructs a JSON-RPC 2.0 invalid request error response (-32600) with a null id.

**Compilation flags:**

`static`

**Template:**

`invalid_request(ErrorResponse)`

**Mode and number of proofs:**

`invalid_request(--compound)` - `one`

------------------------------------------------------------------------

###### `method_not_found/2`

Constructs a JSON-RPC 2.0 method not found error response (-32601).

**Compilation flags:**

`static`

**Template:**

`method_not_found(Id,ErrorResponse)`

**Mode and number of proofs:**

`method_not_found(+nonvar,--compound)` - `one`

------------------------------------------------------------------------

###### `invalid_params/2`

Constructs a JSON-RPC 2.0 invalid params error response (-32602).

**Compilation flags:**

`static`

**Template:**

`invalid_params(Id,ErrorResponse)`

**Mode and number of proofs:**

`invalid_params(+nonvar,--compound)` - `one`

------------------------------------------------------------------------

###### `internal_error/2`

Constructs a JSON-RPC 2.0 internal error response (-32603).

**Compilation flags:**

`static`

**Template:**

`internal_error(Id,ErrorResponse)`

**Mode and number of proofs:**

`internal_error(+nonvar,--compound)` - `one`

------------------------------------------------------------------------

###### `encode/2`

Encodes a JSON-RPC 2.0 term (request, notification, response, error, or batch) into a JSON atom.

**Compilation flags:**

`static`

**Template:**

`encode(Term,JSON)`

**Mode and number of proofs:**

`encode(+compound,--atom)` - `one`

------------------------------------------------------------------------

###### `decode/2`

Decodes a JSON atom into a JSON-RPC 2.0 term (request, notification, response, error, or batch).

**Compilation flags:**

`static`

**Template:**

`decode(JSON,Term)`

**Mode and number of proofs:**

`decode(+atom,--compound)` - `one_or_error`

------------------------------------------------------------------------

###### `is_request/1`

True if the term is a valid JSON-RPC 2.0 request (has jsonrpc, method, and id fields).

**Compilation flags:**

`static`

**Template:**

`is_request(Term)`

**Mode and number of proofs:**

`is_request(+compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_notification/1`

True if the term is a valid JSON-RPC 2.0 notification (has jsonrpc and method fields but no id field).

**Compilation flags:**

`static`

**Template:**

`is_notification(Term)`

**Mode and number of proofs:**

`is_notification(+compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_response/1`

True if the term is a valid JSON-RPC 2.0 successful response (has jsonrpc, result, and id fields).

**Compilation flags:**

`static`

**Template:**

`is_response(Term)`

**Mode and number of proofs:**

`is_response(+compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_error_response/1`

True if the term is a valid JSON-RPC 2.0 error response (has jsonrpc, error, and id fields).

**Compilation flags:**

`static`

**Template:**

`is_error_response(Term)`

**Mode and number of proofs:**

`is_error_response(+compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_batch/1`

True if the term is a valid JSON-RPC 2.0 batch (a non-empty list).

**Compilation flags:**

`static`

**Template:**

`is_batch(Term)`

**Mode and number of proofs:**

`is_batch(+compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `id/2`

Extracts the id field from a JSON-RPC 2.0 message.

**Compilation flags:**

`static`

**Template:**

`id(Message,Id)`

**Mode and number of proofs:**

`id(+compound,--nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `method/2`

Extracts the method field from a JSON-RPC 2.0 request or notification.

**Compilation flags:**

`static`

**Template:**

`method(Message,Method)`

**Mode and number of proofs:**

`method(+compound,--atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `params/2`

Extracts the params field from a JSON-RPC 2.0 request or notification.

**Compilation flags:**

`static`

**Template:**

`params(Message,Params)`

**Mode and number of proofs:**

`params(+compound,--nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `result/2`

Extracts the result field from a JSON-RPC 2.0 response.

**Compilation flags:**

`static`

**Template:**

`result(Message,Result)`

**Mode and number of proofs:**

`result(+compound,--nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `error/2`

Extracts the error field from a JSON-RPC 2.0 error response.

**Compilation flags:**

`static`

**Template:**

`error(Message,Error)`

**Mode and number of proofs:**

`error(+compound,--compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `error_code/2`

Extracts the error code from a JSON-RPC 2.0 error response.

**Compilation flags:**

`static`

**Template:**

`error_code(Message,Code)`

**Mode and number of proofs:**

`error_code(+compound,--integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `error_message/2`

Extracts the error message from a JSON-RPC 2.0 error response.

**Compilation flags:**

`static`

**Template:**

`error_message(Message,ErrorMessage)`

**Mode and number of proofs:**

`error_message(+compound,--atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `error_data/2`

Extracts the error data from a JSON-RPC 2.0 error response. Fails if no data field is present.

**Compilation flags:**

`static`

**Template:**

`error_data(Message,Data)`

**Mode and number of proofs:**

`error_data(+compound,--nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `write_message/2`

Writes a JSON-RPC 2.0 message to an output stream as a single line of JSON followed by a newline. Flushes the output stream after writing.

**Compilation flags:**

`static`

**Template:**

`write_message(Output,Message)`

**Mode and number of proofs:**

`write_message(+stream,+compound)` - `one`

------------------------------------------------------------------------

###### `read_message/2`

Reads a JSON-RPC 2.0 message from an input stream. Reads a line of JSON text and parses it. Fails at end of stream.

**Compilation flags:**

`static`

**Template:**

`read_message(Input,Message)`

**Mode and number of proofs:**

`read_message(+stream,--compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `write_framed_message/2`

Writes a JSON-RPC 2.0 message to an output stream using Content-Length framing (as used by LSP style protocols). The message is preceded by a `Content-Length:`` ``N\r\n\r\n` header where `N` is the byte length of the JSON body. Flushes the output stream after writing.

**Compilation flags:**

`static`

**Template:**

`write_framed_message(Output,Message)`

**Mode and number of proofs:**

`write_framed_message(+stream,+compound)` - `one`

------------------------------------------------------------------------

###### `read_framed_message/2`

Reads a JSON-RPC 2.0 message from an input stream using Content-Length framing (as used by LSP style protocols). Reads a `Content-Length:`` ``N\r\n\r\n` header followed by exactly `N` bytes of JSON body. Fails at end of stream or if the header is missing or malformed.

**Compilation flags:**

`static`

**Template:**

`read_framed_message(Input,Message)`

**Mode and number of proofs:**

`read_framed_message(+stream,--compound)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### json_schema")

**object**

#### `json_schema`

JSON Schema parser and validator. Uses curly terms for JSON objects, dashes for JSON pairs, and atoms for JSON strings.

**Availability:**

`logtalk_load(json_schema(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-01-29

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` json_schema(curly,dash,atom)

**Remarks:**

(none)

**Inherited public predicates:**

 parse/2  validate/2  validate/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `json_schema(StringRepresentation)`

- `StringRepresentation` - String representation used for JSON strings. Possible values are `atom` (default), `chars`, and `codes`.

JSON Schema parser and validator. Uses curly terms for JSON objects and dashes for JSON pairs.

**Availability:**

`logtalk_load(json_schema(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-01-29

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` json_schema(curly,dash,StringRepresentation)

**Remarks:**

(none)

**Inherited public predicates:**

 parse/2  validate/2  validate/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `json_schema(ObjectRepresentation,PairRepresentation,StringRepresentation)`

- `ObjectRepresentation` - Object representation used for JSON objects. Possible values are `curly` (default) and `list`.

- `PairRepresentation` - Pair representation used for JSON object pairs. Possible values are `dash` (default), `equal`, and `colon`.

- `StringRepresentation` - String representation used for JSON strings. Possible values are `atom` (default), `chars`, and `codes`.

JSON Schema parser and validator supporting JSON Schema draft-07/draft-2019-09/draft-2020-12.

**Availability:**

`logtalk_load(json_schema(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-03

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` json_schema_protocol

**Uses:**

json(ObjectRepresentation,PairRepresentation,StringRepresentation)

list

url(Representation)

**Remarks:**

(none)

**Inherited public predicates:**

 parse/2  validate/2  validate/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `json_schema_protocol`

JSON Schema parser and validator protocol.

**Availability:**

`logtalk_load(json_schema(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-01-29

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `validate/2`

  - `validate/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses a JSON schema from the given source (`file(Path)`, `stream(Stream)`, `codes(List)`, `chars(List)`, or `atom(Atom)`) into a schema term.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Schema)`

**Mode and number of proofs:**

`parse(++compound,--term)` - `one_or_error`

------------------------------------------------------------------------

###### `validate/2`

Validates a JSON term against a parsed schema. Succeeds if the JSON term is valid according to the schema.

**Compilation flags:**

`static`

**Template:**

`validate(Schema,JSON)`

**Mode and number of proofs:**

`validate(+term,+term)` - `zero_or_one`

------------------------------------------------------------------------

###### `validate/3`

Validates a JSON term against a parsed schema. Returns a list of validation errors (empty list if valid).

**Compilation flags:**

`static`

**Template:**

`validate(Schema,JSON,Errors)`

**Mode and number of proofs:**

`validate(+term,+term,--list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### knn")

**object**

#### `knn`

k-Nearest Neighbors classifier with multiple distance metrics and weighting options. Learns from a dataset object implementing the `dataset_protocol` protocol and returns a classifier term that can be used for prediction and exported as predicate clauses.

**Availability:**

`logtalk_load(knn(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` classifier_protocol

**Imports:**

`public` options

**Uses:**

format

list

pairs

type

**Remarks:**

> - Algorithm: k-NN is a lazy learning algorithm that classifies instances based on the majority class among the k nearest training instances.
>
> - Distance metrics: Supports Euclidean, Manhattan, Chebyshev, and Minkowski distance metrics.
>
> - Weighting schemes: Supports uniform, distance-based, and Gaussian weighting of neighbors.
>
> - Feature types: Automatically handles numeric and categorical features.
>
> - Classifier representation: The learned classifier is represented (by default) as a `knn_classifier(AttributeNames,`` ``FeatureTypes,`` ``Instances)` where `Instances` contains the training data.

**Inherited public predicates:**

 check_option/1  check_options/1  classifier_to_clauses/4  classifier_to_file/4  default_option/1  default_options/1  learn/2  option/2  option/3  predict/3  print_classifier/1  valid_option/1  valid_options/1

- Public predicates

  - `predict/4`

  - `predict_probabilities/3`

  - `predict_probabilities/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `predict/4`

Predicts the class label for a new instance using the learned classifier and the given options. The instance is a list of `Attribute-Value` pairs.

**Compilation flags:**

`static`

**Template:**

`predict(Classifier,Instance,Class,Options)`

**Mode and number of proofs:**

`predict(+compound,+list,-atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `predict_probabilities/3`

Predicts class probabilities for a new instance using the learned classifier and default options. Returns a list of `Class-Probability` pairs. The instance is a list of `Attribute-Value` pairs.

**Compilation flags:**

`static`

**Template:**

`predict_probabilities(Classifier,Instance,Probabilities)`

**Mode and number of proofs:**

`predict_probabilities(+compound,+list,-list)` - `one`

------------------------------------------------------------------------

###### `predict_probabilities/4`

Predicts class probabilities for a new instance using the learned classifier and the given options. Returns a list of `Class-Probability` pairs. The instance is a list of `Attribute-Value` pairs.

**Compilation flags:**

`static`

**Template:**

`predict_probabilities(Classifier,Instance,Probabilities,Options)`

**Mode and number of proofs:**

`predict_probabilities(+compound,+list,-list,+list(compound))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

dataset_protocol, c45, isolation_forest, naive_bayes, nearest_centroid, random_forest, ada_boost

### ksuid")

**object**

#### `ksuid`

KSUID generator using atom representation and the canonical Base62 alphabet.

**Availability:**

`logtalk_load(ksuid(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` ksuid(atom,0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz)

**Remarks:**

(none)

**Inherited public predicates:**

 generate/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

ksuid(Representation,Alphabet), cuid2, nanoid, ids, ulid, snowflakeid, uuid

**object**

#### `ksuid(Representation,Alphabet)`

- `Representation` - Text representation for the KSUID. Possible values are `atom`, `chars`, and `codes`.

- `Alphabet` - Base62 alphabet used for encoding KSUIDs represented as an atom, list of characters, or list of character codes.

KSUID generator.

**Availability:**

`logtalk_load(ksuid(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` ksuid_protocol

**Uses:**

fast_random(Algorithm)

iso8601

list

os

**Remarks:**

(none)

**Inherited public predicates:**

 generate/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

ksuid, cuid2(Representation,Size,Alphabet), nanoid(Representation,Size,Alphabet), ids(Representation,Bytes), ulid(Representation), snowflakeid(Representation,EpochMilliseconds,TimeUnitMilliseconds,TimestampBits,NodeBits,SequenceBits,Node), uuid(Representation)

**protocol**

#### `ksuid_protocol`

KSUID generator protocol.

**Availability:**

`logtalk_load(ksuid(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `generate/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `generate/1`

Returns a KSUID.

**Compilation flags:**

`static`

**Template:**

`generate(KSUID)`

**Mode and number of proofs:**

`generate(--ground)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### lgtdoc")

**object**

#### `lgtdoc`

Documenting tool. Generates XML documenting files for loaded entities and for library, directory, entity, and predicate indexes.

**Availability:**

`logtalk_load(lgtdoc(loader))`

**Author:** Paulo Moura

**Version:** 11:2:1

**Date:** 2025-10-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` lgtdocp

**Imports:**

`public` options

**Uses:**

date

list

logtalk

os

type

user

varlist

**Remarks:**

(none)

**Inherited public predicates:**

 all/0  all/1  check_option/1  check_options/1  default_option/1  default_options/1  directories/1  directories/2  directory/1  directory/2  file/1  file/2  files/1  files/2  fix_option/2  fix_options/2  libraries/1  libraries/2  library/1  library/2  merge_options/2  option/2  option/3  rdirectories/1  rdirectories/2  rdirectory/1  rdirectory/2  rlibraries/1  rlibraries/2  rlibrary/1  rlibrary/2  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

  - `library_entity_/4`

  - `directory_entity_/4`

  - `type_entity_/4`

  - `predicate_entity_/4`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `library_entity_/4`

Table of documented entities per library.

**Compilation flags:**

`dynamic`

**Template:**

`library_entity_(Library,PrimarySortKey,SecondarySortKey,Entity)`

**Mode and number of proofs:**

`library_entity_(?atom,?nonvar,?nonvar,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `directory_entity_/4`

Table of documented entities per directory.

**Compilation flags:**

`dynamic`

**Template:**

`directory_entity_(Directory,PrimarySortKey,SecondarySortKey,Entity)`

**Mode and number of proofs:**

`directory_entity_(?atom,?nonvar,?nonvar,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `type_entity_/4`

Table of documented entities per type.

**Compilation flags:**

`dynamic`

**Template:**

`type_entity_(Type,PrimarySortKey,SecondarySortKey,Entity)`

**Mode and number of proofs:**

`type_entity_(?atom,?nonvar,?nonvar,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `predicate_entity_/4`

Table of public predicates for all documented entities.

**Compilation flags:**

`dynamic`

**Template:**

`predicate_entity_(Predicate,PrimarySortKey,SecondarySortKey,Entity)`

**Mode and number of proofs:**

`predicate_entity_(?predicate_indicator,?nonvar,?nonvar,?entity_identifier)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**category**

#### `lgtdoc_messages`

Logtalk documentation tool default message translations.

**Availability:**

`logtalk_load(lgtdoc(loader))`

**Author:** Paulo Moura

**Version:** 4:0:1

**Date:** 2024-12-02

**Compilation flags:**

`static`

**Provides:**

logtalk::message_prefix_stream/4

logtalk::message_tokens//2

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `lgtdocp`

Documenting tool protocol.

**Availability:**

`logtalk_load(lgtdoc(loader))`

**Author:** Paulo Moura

**Version:** 6:0:0

**Date:** 2024-03-08

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

> - Compiling files for generating XML documentation: All source files must be compiled with the `source_data` flag turned on.
>
> - `xml_spec(Specification)` option: XML documenting files specification format. Possible option values are `dtd` (DTD specification; default) and `xsd` (XML Schema specification).
>
> - `xml_spec_reference(Reference)` option: Reference to the XML specification file in XML documenting files. Possible values are `local` (default; DTD/XSD file in same folder as XML files), `web` (logtalk.org website DTD/XSD file), and `standalone` (no reference to specification files).
>
> - `entity_xsl_file(File)` option: XSLT file to use with generated XML documenting files. Default is `logtalk_entity_to_xml.xsl`, allowing the XML files to be viewed by opening them with a browser supporting XSLT (after running the `lgt2xml.sh` script on the output directory).
>
> - `index_xsl_file(File)` option: XSLT file to use with generated XML documenting files. Default is `logtalk_index_to_xml.xsl`, allowing the XML files to be viewed by opening them with a browser supporting XSLT (after running the `lgt2xml.sh` script on the output directory).
>
> - `xml_docs_directory(Directory)` option: Directory where the XML documenting files will be generated. The default value is `./xml_docs`, a sub-directory of the source files directory.
>
> - `bom(Boolean)` option: Defines if a BOM should be added to the generated XML documenting files.
>
> - `encoding(Encoding)` option: Encoding to be used for the generated XML documenting files.
>
> - `omit_path_prefixes(Prefixes)` option: List of path prefixes (atoms) to omit when writing directory paths. The default value is to omit the home directory.
>
> - `exclude_files(List)` option: List of files to exclude when generating the XML documenting files.
>
> - `exclude_paths(List)` option: List of relative library paths to exclude when generating the XML documenting files (default is `[]`). All sub-directories of the excluded directories are also excluded.
>
> - `exclude_prefixes(List)` option: List of path prefixes to exclude when generating the XML documenting files (default is `[]`).
>
> - `exclude_entities(List)` option: List of entities to exclude when generating the XML documenting files (default is `[]`).
>
> - `sort_predicates(Boolean)` option: Sort entity predicates (default is `false`).
>
> - Known issues: Some options may depend on the used XSL processor. Most XSL processors support DTDs but only some of them support XML Schemas. Some processors (e.g., `fop2`) reject reference to a DTD.

**Inherited public predicates:**

(none)

- Public predicates

  - `rlibraries/2`

  - `rlibraries/1`

  - `rlibrary/2`

  - `rlibrary/1`

  - `libraries/2`

  - `libraries/1`

  - `library/2`

  - `library/1`

  - `rdirectories/2`

  - `rdirectories/1`

  - `rdirectory/2`

  - `rdirectory/1`

  - `directories/2`

  - `directories/1`

  - `directory/2`

  - `directory/1`

  - `files/2`

  - `files/1`

  - `file/2`

  - `file/1`

  - `all/1`

  - `all/0`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `rlibraries/2`

Creates XML documenting files for all entities in all given libraries and their sub-libraries using the specified options.

**Compilation flags:**

`static`

**Template:**

`rlibraries(Libraries,Options)`

**Mode and number of proofs:**

`rlibraries(+list(atom),+list)` - `one`

------------------------------------------------------------------------

###### `rlibraries/1`

Creates XML documenting files for all entities in all given libraries and their sub-libraries using default options.

**Compilation flags:**

`static`

**Template:**

`rlibraries(Libraries)`

**Mode and number of proofs:**

`rlibraries(+list(atom))` - `one`

------------------------------------------------------------------------

###### `rlibrary/2`

Creates XML documenting files for all entities in a library and its sub-libraries using the specified options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library,Options)`

**Mode and number of proofs:**

`rlibrary(+atom,+list)` - `one`

**Examples:**

Generate XML documenting files for all tool entities for later conversion to Markdown files

`rlibrary(tools,[xslfile('lgtmd.xsl')])`

`yes`

------------------------------------------------------------------------

###### `rlibrary/1`

Creates XML documenting files for all entities in a library and its sub-libraries using default options.

**Compilation flags:**

`static`

**Template:**

`rlibrary(Library)`

**Mode and number of proofs:**

`rlibrary(+atom)` - `one`

**Examples:**

Generate XML documenting files for all tool entities for direct viewing in a browser (after indexing using the `lgt2xml` script)

`rlibrary(tools)`

`yes`

------------------------------------------------------------------------

###### `libraries/2`

Creates XML documenting files for all entities in all given libraries using the specified options.

**Compilation flags:**

`static`

**Template:**

`libraries(Libraries,Options)`

**Mode and number of proofs:**

`libraries(+list(atom),+list)` - `one`

------------------------------------------------------------------------

###### `libraries/1`

Creates XML documenting files for all entities in all given libraries using default options.

**Compilation flags:**

`static`

**Template:**

`libraries(Libraries)`

**Mode and number of proofs:**

`libraries(+list(atom))` - `one`

------------------------------------------------------------------------

###### `library/2`

Creates XML documenting files for all entities in a library using the specified options.

**Compilation flags:**

`static`

**Template:**

`library(Library,Options)`

**Mode and number of proofs:**

`library(+atom,+list)` - `one`

**Examples:**

Generate XML documenting files for all library entities for later conversion to PDF A4 files

`library(library,[xslfile('logtalk_entity_to_pdf_a4.xsl')])`

`yes`

------------------------------------------------------------------------

###### `library/1`

Creates XML documenting files for all entities in a library using default options.

**Compilation flags:**

`static`

**Template:**

`library(Library)`

**Mode and number of proofs:**

`library(+atom)` - `one`

------------------------------------------------------------------------

###### `rdirectories/2`

Creates XML documenting files for all entities in all given directories and their sub-directories using the specified options.

**Compilation flags:**

`static`

**Template:**

`rdirectories(Directories,Options)`

**Mode and number of proofs:**

`rdirectories(+list(atom),+list)` - `one`

------------------------------------------------------------------------

###### `rdirectories/1`

Creates XML documenting files for all entities in all given directories and their sub-directories using default options.

**Compilation flags:**

`static`

**Template:**

`rdirectories(Directories)`

**Mode and number of proofs:**

`rdirectories(+list(atom))` - `one`

------------------------------------------------------------------------

###### `rdirectory/2`

Creates XML documenting files for all entities in a directory and its sub-directories using the specified options.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Directory,Options)`

**Mode and number of proofs:**

`rdirectory(+atom,+list)` - `one`

**Examples:**

Generate XML documenting files for all entities in the tools directory for later conversion to Markdown files

`rdirectory('./tools',[xslfile('lgtmd.xsl')])`

`yes`

------------------------------------------------------------------------

###### `rdirectory/1`

Creates XML documenting files for all entities in a directory and its sub-directories using default options.

**Compilation flags:**

`static`

**Template:**

`rdirectory(Directory)`

**Mode and number of proofs:**

`rdirectory(+atom)` - `one`

**Examples:**

Generate XML documenting files for all entities in the tools directory for direct viewing in a browser (after indexing using the `lgt2xml` script)

`rdirectory('./tools')`

`yes`

------------------------------------------------------------------------

###### `directories/2`

Creates XML documenting files for all entities in all given directories using the specified options.

**Compilation flags:**

`static`

**Template:**

`directories(Directories,Options)`

**Mode and number of proofs:**

`directories(+list(atom),+list)` - `one`

------------------------------------------------------------------------

###### `directories/1`

Creates XML documenting files for all entities in all given directories using default options.

**Compilation flags:**

`static`

**Template:**

`directories(Directories)`

**Mode and number of proofs:**

`directories(+list(atom))` - `one`

------------------------------------------------------------------------

###### `directory/2`

Creates XML documenting files for all entities in a directory using the specified options.

**Compilation flags:**

`static`

**Template:**

`directory(Directory,Options)`

**Mode and number of proofs:**

`directory(+atom,+list)` - `one`

**Examples:**

Generate XML documenting files for all the entities in the current directory for later conversion to PDF A4 files

`directory('.',[xslfile('logtalk_entity_to_pdf_a4.xsl')])`

`yes`

------------------------------------------------------------------------

###### `directory/1`

Creates XML documenting files for all entities in a directory using default options.

**Compilation flags:**

`static`

**Template:**

`directory(Directory)`

**Mode and number of proofs:**

`directory(+atom)` - `one`

------------------------------------------------------------------------

###### `files/2`

Creates XML documenting files for all entities in loaded source files using the specified options. The files can be given by name, basename, full path, or using library notation.

**Compilation flags:**

`static`

**Template:**

`files(Files,Options)`

**Mode and number of proofs:**

`files(+list(atom),+list)` - `one`

------------------------------------------------------------------------

###### `files/1`

Creates XML documenting files for all entities in loaded source files using default options. The files can be given by name, basename, full path, or using library notation.

**Compilation flags:**

`static`

**Template:**

`files(Files)`

**Mode and number of proofs:**

`files(+list(atom))` - `one`

------------------------------------------------------------------------

###### `file/2`

Creates XML documenting files for all entities in a loaded source file using the specified options. The file can be given by name, basename, full path, or using library notation.

**Compilation flags:**

`static`

**Template:**

`file(File,Options)`

**Mode and number of proofs:**

`file(+atom,+list)` - `one`

------------------------------------------------------------------------

###### `file/1`

Creates XML documenting files for all entities in a loaded source file using default options. The file can be given by name, basename, full path, or using library notation.

**Compilation flags:**

`static`

**Template:**

`file(File)`

**Mode and number of proofs:**

`file(+atom)` - `one`

------------------------------------------------------------------------

###### `all/1`

Creates XML documenting files for all loaded entities using the specified options.

**Compilation flags:**

`static`

**Template:**

`all(Options)`

**Mode and number of proofs:**

`all(+list)` - `one`

------------------------------------------------------------------------

###### `all/0`

Creates XML documenting files for all loaded entities using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`all` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

lgtdoc

### lgtunit")

**object**

#### `automation_report`

Intercepts unit test execution messages and generates a `*.totals` files for parsing by the `logtalk_tester.sh` automation shell script.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 6:0:1

**Date:** 2026-01-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Uses:**

user

**Remarks:**

> - Usage: Automatically loaded by the `logtalk_tester.sh` shell script.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `coverage_report`

Intercepts unit test execution messages and generates a `coverage_report.xml` file with a test suite code coverage results.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 3:2:1

**Date:** 2026-02-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Uses:**

logtalk

user

**Remarks:**

> - Usage: Simply load this object before running your tests using the goal `logtalk_load(lgtunit(coverage_report))`.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

  - `timestamp_/6`

  - `object_file_/2`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `timestamp_/6`

Cache of the starting tests timestamp.

**Compilation flags:**

`dynamic`

**Template:**

`timestamp_(Year,Month,Day,Hours,Minutes,Seconds)`

**Mode and number of proofs:**

`timestamp_(-integer,-integer,-integer,-integer,-integer,-integer)` - `one`

------------------------------------------------------------------------

###### `object_file_/2`

Cache of test object - file pairs.

**Compilation flags:**

`dynamic`

**Template:**

`object_file_(Object,File)`

**Mode and number of proofs:**

`object_file_(?object_identifier,?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `lgtunit`

A unit test framework supporting predicate clause coverage, determinism testing, input/output testing, property-based testing, and multiple test dialects.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 22:4:0

**Date:** 2026-02-11

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Imports:**

`public` lgtunit_messages

**Provides:**

logtalk::trace_event/2

**Uses:**

fast_random

list

logtalk

os

type

user

**Remarks:**

> - Usage: Define test objects as extensions of the `lgtunit` object and compile their source files using the compiler option `hook(lgtunit)`.
>
> - Portability: Deterministic unit tests are currently not available when using Quintus Prolog as the backend compiler.
>
> - Known issues: Parameter variables cannot currently be used in the definition of test options.

**Inherited public predicates:**

 failed_test_reason//1  goal_expansion/2  term_expansion/2

- Public predicates

  - `cover/1`

  - `run/0`

  - `run/1`

  - `run/2`

  - `run_test_sets/1`

  - `test/1`

  - `number_of_tests/1`

  - `deterministic/1`

  - `deterministic/2`

  - `assertion/1`

  - `assertion/2`

  - `quick_check/3`

  - `quick_check/2`

  - `quick_check/1`

  - `benchmark/2`

  - `benchmark_reified/3`

  - `benchmark/3`

  - `benchmark/4`

  - `variant/2`

  - `approximately_equal/2`

  - `approximately_equal/3`

  - `essentially_equal/3`

  - `tolerance_equal/4`

  - `=~=`` ``/`` ``2`

  - `epsilon/1`

- Protected predicates

  - `run_tests/0`

  - `run_tests/1`

  - `run_test_set/0`

  - `run_quick_check_tests/5`

  - `condition/0`

  - `setup/0`

  - `cleanup/0`

  - `make/1`

  - `note/1`

  - `file_path/2`

  - `suppress_text_output/0`

  - `suppress_binary_output/0`

  - `set_text_input/3`

  - `set_text_input/2`

  - `set_text_input/1`

  - `check_text_input/2`

  - `check_text_input/1`

  - `text_input_assertion/3`

  - `text_input_assertion/2`

  - `clean_text_input/0`

  - `set_binary_input/3`

  - `set_binary_input/2`

  - `set_binary_input/1`

  - `check_binary_input/2`

  - `check_binary_input/1`

  - `binary_input_assertion/3`

  - `binary_input_assertion/2`

  - `clean_binary_input/0`

  - `set_text_output/3`

  - `set_text_output/2`

  - `set_text_output/1`

  - `check_text_output/3`

  - `check_text_output/2`

  - `check_text_output/1`

  - `text_output_assertion/4`

  - `text_output_assertion/3`

  - `text_output_assertion/2`

  - `text_output_contents/3`

  - `text_output_contents/2`

  - `text_output_contents/1`

  - `clean_text_output/0`

  - `set_binary_output/3`

  - `set_binary_output/2`

  - `set_binary_output/1`

  - `check_binary_output/2`

  - `check_binary_output/1`

  - `binary_output_assertion/3`

  - `binary_output_assertion/2`

  - `binary_output_contents/2`

  - `binary_output_contents/1`

  - `clean_binary_output/0`

  - `create_text_file/3`

  - `create_text_file/2`

  - `create_binary_file/2`

  - `check_text_file/3`

  - `check_text_file/2`

  - `text_file_assertion/4`

  - `text_file_assertion/3`

  - `check_binary_file/2`

  - `binary_file_assertion/3`

  - `clean_file/1`

  - `clean_directory/1`

  - `closed_input_stream/2`

  - `closed_output_stream/2`

  - `stream_position/1`

  - `test/2`

- Private predicates

  - `running_test_sets_/0`

  - `test/3`

  - `auxiliary_predicate_counter_/1`

  - `test_/2`

  - `selected_test_/1`

  - `skipped_/1`

  - `passed_/3`

  - `failed_/3`

  - `flaky_/1`

  - `fired_/3`

  - `covered_/4`

- Operators

  - `op(700,xfx,=~=)`

##### Public predicates

###### `cover/1`

Declares entities being tested for which code coverage information should be collected.

**Compilation flags:**

`static`

**Template:**

`cover(Entity)`

**Mode and number of proofs:**

`cover(?entity_identifier)` - `zero_or_more`

------------------------------------------------------------------------

###### `run/0`

Runs the unit tests, writing the results to the current output stream.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`run` - `one`

------------------------------------------------------------------------

###### `run/1`

Runs a unit test or a list of unit tests, writing the results to the current output stream. Runs the global setup and cleanup steps when defined. Fails when given a partial list of tests or when one of the test identifiers is not valid.

**Compilation flags:**

`static`

**Template:**

`run(Tests)`

**Mode and number of proofs:**

`run(++callable)` - `zero_or_one`

`run(++list(callable))` - `zero_or_one`

------------------------------------------------------------------------

###### `run/2`

Runs the unit tests, writing the results to the specified file. Mode can be either `write` (to create a new file) or `append` (to add results to an existing file).

**Compilation flags:**

`static`

**Template:**

`run(File,Mode)`

**Mode and number of proofs:**

`run(+atom,+atom)` - `one`

------------------------------------------------------------------------

###### `run_test_sets/1`

Runs two or more test sets as a unified set generating a single code coverage report if one is requested. When there is a single test set, it is equivalent to sending the message `run/0` to the test set. Trivially succeeds when the argument is an empty list.

**Compilation flags:**

`static`

**Template:**

`run_test_sets(TestObjects)`

**Mode and number of proofs:**

`run_test_sets(+list(object))` - `one`

**Exceptions:**

`TestObjects` is a partial list or a list with an element which is a variable:

`instantiation_error`

`TestObjects` is neither a partial list nor a list:

`type_error(list(object),TestObjects)`

An element `TestObject` of the `TestObjects` list is not an existing object:

`existence_error(object,TestObject)`

------------------------------------------------------------------------

###### `test/1`

Enumerates, by backtracking, the identifiers of all defined unit tests.

**Compilation flags:**

`static`

**Template:**

`test(Identifier)`

**Mode and number of proofs:**

`test(?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `number_of_tests/1`

Number of defined unit tests.

**Compilation flags:**

`static`

**Template:**

`number_of_tests(NumerOfTests)`

**Mode and number of proofs:**

`number_of_tests(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `deterministic/1`

True if the goal succeeds once without leaving choice-points.

**Compilation flags:**

`static`

**Template:**

`deterministic(Goal)`

**Meta-predicate template:**

`deterministic(0)`

**Mode and number of proofs:**

`deterministic(+callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `deterministic/2`

Reified version of the `deterministic/1` predicate. True if the goal succeeds. Returns a boolean value (`true` or `false`) indicating if the goal succeeded without leaving choice-points.

**Compilation flags:**

`static`

**Template:**

`deterministic(Goal,Deterministic)`

**Meta-predicate template:**

`deterministic(0,*)`

**Mode and number of proofs:**

`deterministic(+callable,--atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `assertion/1`

True if the assertion goal succeeds. Throws an error using the assertion goal as argument if the assertion goal throws an error or fails.

**Compilation flags:**

`static`

**Template:**

`assertion(Assertion)`

**Meta-predicate template:**

`assertion(::)`

**Mode and number of proofs:**

`assertion(@callable)` - `one`

**Exceptions:**

Assertion goal fails:

`assertion_failure(Assertion)`

Assertion goal throws Error:

`assertion_error(Assertion,Error)`

------------------------------------------------------------------------

###### `assertion/2`

True if the assertion goal succeeds. Throws an error using the description as argument if the assertion goal throws an error or fails. The description argument helps to distinguish between different assertions in the same test body.

**Compilation flags:**

`static`

**Template:**

`assertion(Description,Assertion)`

**Meta-predicate template:**

`assertion(*,0)`

**Mode and number of proofs:**

`assertion(+nonvar,@callable)` - `one`

**Exceptions:**

Assertion goal fails:

`assertion_failure(Description)`

Assertion goal throws Error:

`assertion_error(Description,Error)`

------------------------------------------------------------------------

###### `quick_check/3`

Reified version of the `quick_check/2` predicate. Reports `passed(SequenceSeed,Discarded,Labels)`, `failed(Goal,SequenceSeed,TestSeed)`, `error(Error,Goal,SequenceSeed,TestSeed)`, or `broken(Why,Culprit)`. `Goal` is the failed test.

**Compilation flags:**

`static`

**Template:**

`quick_check(Template,Result,Options)`

**Meta-predicate template:**

`quick_check(::,*,::)`

**Mode and number of proofs:**

`quick_check(@callable,-callable,++list(compound))` - `one`

**Remarks:**

> - `SequenceSeed` argument: Can be used to re-run the same exact sequence of pseudo-random tests by using the `rs/1` option after changes to the code being tested.
>
> - `TestSeed` argument: Can be used to re-run the test that failed by using the `rs/1` option after changes to the code being tested.
>
> - `Discarded` argument: Number of generated tests that were discarded for failing to comply a pre-condition specified using the `pc/1` option.
>
> - `Labels` argument: List of pairs `Label-N` where `N` is the number of generated tests that are classified as `Label` by a closure specified using the `l/1` option.
>
> - `broken(Why,Culprit)` result: This result signals a broken setup. For example, an invalid template, a broken pre-condition or label goal, or broken test generation.

------------------------------------------------------------------------

###### `quick_check/2`

Generates and runs random tests for a predicate given its mode template and a set of options. Fails when a generated test fails printing the test. Also fails on an invalid option, printing the option.

**Compilation flags:**

`static`

**Template:**

`quick_check(Template,Options)`

**Meta-predicate template:**

`quick_check(::,::)`

**Mode and number of proofs:**

`quick_check(@callable,++list(compound))` - `zero_or_one`

**Remarks:**

> - Number of tests: Use the `n(NumberOfTests)` option to specify the number of random tests. Default is 100.
>
> - Maximum number of shrink operations: Use the `s(MaxShrinks)` option to specify the number of shrink operations when a counter example is found. Default is 64.
>
> - Type edge cases: Use the `ec(Boolean)` option to specify if type edge cases are tested (before generating random tests). Default is `true`.
>
> - Starting seed: Use the `rs(Seed)` option to specify the random generator starting seed to be used when generating tests. No default. Seeds should be regarded as opaque terms.
>
> - Test generation filtering: Use the `pc/1` option to specify a pre-condition closure for filtering generated tests (extended with the test arguments; no default).
>
> - Generated tests classification: Use the `l/1` option to specify a label closure for classifying the generated tests (extended with the test arguments plus the labels argument; no default). The labelling predicate can return a single test label or a list of test labels.
>
> - Verbose test generation: Use the `v(Boolean)` option to specify verbose reporting of generated random tests. Default is `false`.
>
> - Progress bar: Use the `pb(Boolean,Tick)` option to print a progress bar for the executed tests, advancing at every `Tick` tests. Default is `false`. Only applies when the verbose option is false.

------------------------------------------------------------------------

###### `quick_check/1`

Generates and runs random tests using default options for a predicate given its mode template. Fails when a generated test fails printing the test.

**Compilation flags:**

`static`

**Template:**

`quick_check(Template)`

**Mode and number of proofs:**

`quick_check(@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `benchmark/2`

Benchmarks a goal and returns the total execution time in seconds. Uses CPU clock. Goals that may throw an exception should be wrapped by the `catch/3` control construct.

**Compilation flags:**

`static`

**Template:**

`benchmark(Goal,Time)`

**Meta-predicate template:**

`benchmark(0,*)`

**Mode and number of proofs:**

`benchmark(+callable,-float)` - `one`

------------------------------------------------------------------------

###### `benchmark_reified/3`

Benchmarks a goal and returns the total execution time in seconds plus its result (`success`, `failure`, or `error(Error))`. Uses CPU clock.

**Compilation flags:**

`static`

**Template:**

`benchmark_reified(Goal,Time,Result)`

**Meta-predicate template:**

`benchmark_reified(0,*,*)`

**Mode and number of proofs:**

`benchmark_reified(+callable,-float,-callable)` - `one`

------------------------------------------------------------------------

###### `benchmark/3`

Benchmarks a goal by repeating it the specified number of times and returning the total execution time in seconds. Uses CPU clock. Goals that may throw an exception should be wrapped by the `catch/3` control construct.

**Compilation flags:**

`static`

**Template:**

`benchmark(Goal,Repetitions,Time)`

**Meta-predicate template:**

`benchmark(0,*,*)`

**Mode and number of proofs:**

`benchmark(@callable,+positive_integer,-float)` - `one`

------------------------------------------------------------------------

###### `benchmark/4`

Benchmarks a goal by repeating it the specified number of times and returning the total execution time in seconds using the given clock (`cpu` or `wall`). Goals that may throw an exception should be wrapped by the `catch/3` control construct.

**Compilation flags:**

`static`

**Template:**

`benchmark(Goal,Repetitions,Clock,Time)`

**Meta-predicate template:**

`benchmark(0,*,*,*)`

**Mode and number of proofs:**

`benchmark(@callable,+positive_integer,+atom,-float)` - `one`

------------------------------------------------------------------------

###### `variant/2`

True when the two arguments are a variant of each other. I.e. if is possible to rename the term variables to make them identical. Useful for checking expected test results that contain variables.

**Compilation flags:**

`static`

**Template:**

`variant(Term1,Term2)`

**Mode and number of proofs:**

`variant(@term,@term)` - `zero_or_one`

------------------------------------------------------------------------

###### `approximately_equal/2`

Compares two numbers for approximate equality given the `epsilon` arithmetic constant value using the de facto standard formula `abs(Number1`` ``-`` ``Number2)`` ``=<`` ``max(abs(Number1),`` ``abs(Number2))`` ``*`` ``epsilon`. Type-checked.

**Compilation flags:**

`static`

**Template:**

`approximately_equal(Number1,Number2)`

**Mode and number of proofs:**

`approximately_equal(+number,+number)` - `zero_or_one`

------------------------------------------------------------------------

###### `approximately_equal/3`

Compares two numbers for approximate equality given a user-defined epsilon value using the de facto standard formula `abs(Number1`` ``-`` ``Number2)`` ``=<`` ``max(abs(Number1),`` ``abs(Number2))`` ``*`` ``Epsilon`. Type-checked.

**Compilation flags:**

`static`

**Template:**

`approximately_equal(Number1,Number2,Epsilon)`

**Mode and number of proofs:**

`approximately_equal(+number,+number,+number)` - `zero_or_one`

**Remarks:**

> - Epsilon range: Epsilon should be the `epsilon` arithmetic constant value or a small multiple of it. Only use a larger value if a greater error is expected.
>
> - Comparison with essential equality: For the same epsilon value, approximate equality is weaker requirement than essential equality.

------------------------------------------------------------------------

###### `essentially_equal/3`

Compares two numbers for essential equality given an epsilon value using the de facto standard formula `abs(Number1`` ``-`` ``Number2)`` ``=<`` ``min(abs(Number1),`` ``abs(Number2))`` ``*`` ``Epsilon`. Type-checked.

**Compilation flags:**

`static`

**Template:**

`essentially_equal(Number1,Number2,Epsilon)`

**Mode and number of proofs:**

`essentially_equal(+number,+number,+number)` - `zero_or_one`

**Remarks:**

> - Comparison with approximate equality: For the same epsilon value, essential equality is a stronger requirement than approximate equality.

------------------------------------------------------------------------

###### `tolerance_equal/4`

Compares two numbers for close equality given relative and absolute tolerances using the de facto standard formula `abs(Number1`` ``-`` ``Number2)`` ``=<`` ``max(RelativeTolerance`` ``*`` ``max(abs(Number1),`` ``abs(Number2)),`` ``AbsoluteTolerance)`. Type-checked.

**Compilation flags:**

`static`

**Template:**

`tolerance_equal(Number1,Number2,RelativeTolerance,AbsoluteTolerance)`

**Mode and number of proofs:**

`tolerance_equal(+number,+number,+number,+number)` - `zero_or_one`

------------------------------------------------------------------------

###### `=~=`` ``/`` ``2`

Compares two numbers (or lists of numbers) for approximate equality using `100*epsilon` for the absolute error and, if that fails, `99.999%` accuracy for the relative error. But these precision values may not be adequate for all cases. Type-checked.

**Compilation flags:**

`static`

**Template:**

`=~=(Number1,Number2)`

**Mode and number of proofs:**

`=~=(+number,+number)` - `zero_or_one`

`=~=(+list(number),+list(number))` - `zero_or_one`

------------------------------------------------------------------------

###### `epsilon/1`

Returns the value of epsilon used in the definition of the `(=~=)/2` predicate.

**Compilation flags:**

`static`

**Template:**

`epsilon(Epsilon)`

**Mode and number of proofs:**

`epsilon(-float)` - `one`

------------------------------------------------------------------------

##### Protected predicates

###### `run_tests/0`

Runs all defined unit tests.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`run_tests` - `one`

------------------------------------------------------------------------

###### `run_tests/1`

Runs all the tests defined in the given file.

**Compilation flags:**

`static`

**Template:**

`run_tests(File)`

**Mode and number of proofs:**

`run_tests(+atom)` - `one`

------------------------------------------------------------------------

###### `run_test_set/0`

Runs a test set as part of running two or more test sets as a unified set.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`run_test_set` - `one`

------------------------------------------------------------------------

###### `run_quick_check_tests/5`

Runs a QuickCheck test using the given options. Returns the starting seed used to generate the random tests, the number of discarded tests, and the test label statistics.

**Compilation flags:**

`static`

**Template:**

`run_quick_check_tests(Template,Options,Seed,Discarded,Labels)`

**Meta-predicate template:**

`run_quick_check_tests(::,::,*,*,*)`

**Mode and number of proofs:**

`run_quick_check_tests(@callable,+list,--nonvar,--number,--list(pair))` - `one_or_error`

------------------------------------------------------------------------

###### `condition/0`

Verifies conditions for running the tests. Defaults to the goal `true`.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`condition` - `zero_or_one`

------------------------------------------------------------------------

###### `setup/0`

Setup environment before running the test set. Defaults to the goal `true`.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`setup` - `zero_or_one`

------------------------------------------------------------------------

###### `cleanup/0`

Cleanup environment after running the test set. Defaults to the goal `true`.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`cleanup` - `zero_or_one`

------------------------------------------------------------------------

###### `make/1`

Make target for automatically running the test set when calling the `logtalk_make/1` built-in predicate. No default. Possible values are `all` and `check`.

**Compilation flags:**

`static`

**Template:**

`make(Target)`

**Mode and number of proofs:**

`make(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `note/1`

Note to be printed after the test results. Defaults to the empty atom.

**Compilation flags:**

`static`

**Template:**

`note(Note)`

**Mode and number of proofs:**

`note(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `file_path/2`

Returns the absolute path for a file path that is relative to the tests object path. When the file path is already an absolute path, it is expanded to resolve any remaining relative file path parts.

**Compilation flags:**

`static`

**Template:**

`file_path(File,Path)`

**Mode and number of proofs:**

`file_path(+atom,-atom)` - `one`

**See also:**

clean_file/1

clean_directory/1

------------------------------------------------------------------------

###### `suppress_text_output/0`

Suppresses text output. Useful to avoid irrelevant text output from predicates being tested to clutter the test logs.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`suppress_text_output` - `one`

------------------------------------------------------------------------

###### `suppress_binary_output/0`

Suppresses binary output. Useful to avoid irrelevant binary output from predicates being tested to clutter the test logs.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`suppress_binary_output` - `one`

------------------------------------------------------------------------

###### `set_text_input/3`

Creates a temporary file, in the same directory as the tests object, with the given text contents, and opens it for reading referenced by the given alias and using the additional options. If no `eof_action/1` option is specified, its value will be the default used by the backend compiler.

**Compilation flags:**

`static`

**Template:**

`set_text_input(Alias,Contents,Options)`

**Mode and number of proofs:**

`set_text_input(+atom,+atom,+list(stream_option))` - `one`

`set_text_input(+atom,+list(atom),+list(stream_option))` - `one`

**See also:**

text_input_assertion/3

check_text_input/2

clean_text_input/0

------------------------------------------------------------------------

###### `set_text_input/2`

Creates a temporary file, in the same directory as the tests object, with the given text contents, and opens it for reading referenced by the given alias and using the default end-of-file action for the used backend compiler.

**Compilation flags:**

`static`

**Template:**

`set_text_input(Alias,Contents)`

**Mode and number of proofs:**

`set_text_input(+atom,+atom)` - `one`

`set_text_input(+atom,+list(atom))` - `one`

**See also:**

text_input_assertion/3

check_text_input/2

clean_text_input/0

------------------------------------------------------------------------

###### `set_text_input/1`

Creates a temporary file, in the same directory as the tests object, with the given text contents, opens it for reading using the default end-of-file action for the used backend compiler, and sets the current input stream to the file.

**Compilation flags:**

`static`

**Template:**

`set_text_input(Contents)`

**Mode and number of proofs:**

`set_text_input(+atom)` - `one`

`set_text_input(+list(atom))` - `one`

**See also:**

text_input_assertion/2

check_text_input/1

clean_text_input/0

------------------------------------------------------------------------

###### `check_text_input/2`

Checks that the temporary file (referenced by the given alias) being read have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`check_text_input(Alias,Contents)`

**Mode and number of proofs:**

`check_text_input(+atom,+atom)` - `zero_or_one`

**See also:**

set_text_input/2

set_text_input/2

text_input_assertion/3

clean_text_input/0

------------------------------------------------------------------------

###### `check_text_input/1`

Checks that the temporary file being read have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`check_text_input(Contents)`

**Mode and number of proofs:**

`check_text_input(+atom)` - `zero_or_one`

**See also:**

set_text_input/1

text_input_assertion/2

clean_text_input/0

------------------------------------------------------------------------

###### `text_input_assertion/3`

Returns an assertion for checking that the temporary file (referenced by the given alias) being read have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`text_input_assertion(Alias,Contents,Assertion)`

**Mode and number of proofs:**

`text_input_assertion(+atom,+atom,--callable)` - `one`

**See also:**

set_text_input/3

check_text_input/2

clean_text_input/0

------------------------------------------------------------------------

###### `text_input_assertion/2`

Returns an assertion for checking that the temporary file being read have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`text_input_assertion(Contents,Assertion)`

**Mode and number of proofs:**

`text_input_assertion(+atom,--callable)` - `one`

**See also:**

set_text_input/1

check_text_input/1

clean_text_input/0

------------------------------------------------------------------------

###### `clean_text_input/0`

Cleans the temporary file used when testing text input.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`clean_text_input` - `one`

**See also:**

set_text_input/3

set_text_input/2

set_text_input/1

------------------------------------------------------------------------

###### `set_binary_input/3`

Creates a temporary file, in the same directory as the tests object, with the given binary contents, and opens it for reading referenced by the given alias and using the additional options. If no `eof_action/1` option is specified, its value will be the default used by the backend compiler.

**Compilation flags:**

`static`

**Template:**

`set_binary_input(Alias,Bytes,Options)`

**Mode and number of proofs:**

`set_binary_input(+atom,+list(byte),+list(stream_option))` - `one`

**See also:**

binary_input_assertion/3

check_binary_input/2

clean_binary_input/0

------------------------------------------------------------------------

###### `set_binary_input/2`

Creates a temporary file, in the same directory as the tests object, with the given binary contents, and opens it for reading referenced by the given alias and using the default end-of-file action for the used backend compiler.

**Compilation flags:**

`static`

**Template:**

`set_binary_input(Alias,Bytes)`

**Mode and number of proofs:**

`set_binary_input(+atom,+list(byte))` - `one`

**See also:**

binary_input_assertion/3

check_binary_input/2

clean_binary_input/0

------------------------------------------------------------------------

###### `set_binary_input/1`

Creates a temporary file, in the same directory as the tests object, with the given binary contents, and opens it for reading using the default end-of-file action for the used backend compiler, and sets the current input stream to the file.

**Compilation flags:**

`static`

**Template:**

`set_binary_input(Bytes)`

**Mode and number of proofs:**

`set_binary_input(+list(byte))` - `one`

**See also:**

binary_input_assertion/2

check_binary_input/1

clean_binary_input/0

------------------------------------------------------------------------

###### `check_binary_input/2`

Checks that the temporary file (referenced by the given alias) being read have the expected binary contents.

**Compilation flags:**

`static`

**Template:**

`check_binary_input(Alias,Bytes)`

**Mode and number of proofs:**

`check_binary_input(+atom,+list(byte))` - `zero_or_one`

**See also:**

set_binary_input/3

set_binary_input/2

binary_input_assertion/3

clean_binary_input/0

------------------------------------------------------------------------

###### `check_binary_input/1`

Checks that the temporary file being read have the expected binary contents.

**Compilation flags:**

`static`

**Template:**

`check_binary_input(Bytes)`

**Mode and number of proofs:**

`check_binary_input(+list(byte))` - `zero_or_one`

**See also:**

binary_input_assertion/2

set_binary_input/1

clean_binary_input/0

------------------------------------------------------------------------

###### `binary_input_assertion/3`

Returns an assertion for checking that the temporary file (referenced by the given alias) being read have the expected binary contents.

**Compilation flags:**

`static`

**Template:**

`binary_input_assertion(Alias,Bytes,Assertion)`

**Mode and number of proofs:**

`binary_input_assertion(+atom,+list(byte),--callable)` - `one`

**See also:**

check_binary_input/2

set_binary_input/3

set_binary_input/2

clean_binary_input/0

------------------------------------------------------------------------

###### `binary_input_assertion/2`

Returns an assertion for checking that the temporary file being read have the expected binary contents.

**Compilation flags:**

`static`

**Template:**

`binary_input_assertion(Bytes,Assertion)`

**Mode and number of proofs:**

`binary_input_assertion(+list(byte),--callable)` - `one`

**See also:**

check_binary_input/1

set_binary_input/1

clean_binary_input/0

------------------------------------------------------------------------

###### `clean_binary_input/0`

Cleans the temporary file used when testing binary input.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`clean_binary_input` - `one`

**See also:**

set_binary_input/3

set_binary_input/2

set_binary_input/1

------------------------------------------------------------------------

###### `set_text_output/3`

Creates a temporary file, in the same directory as the tests object, with the given text contents, and opens it for writing referenced by the given alias and using the additional options.

**Compilation flags:**

`static`

**Template:**

`set_text_output(Alias,Contents,Options)`

**Mode and number of proofs:**

`set_text_output(+atom,+atom,+list(stream_option))` - `one`

`set_text_output(+atom,+list(atom),+list(stream_option))` - `one`

**See also:**

text_output_assertion/4

check_text_output/3

clean_text_output/0

------------------------------------------------------------------------

###### `set_text_output/2`

Creates a temporary file, in the same directory as the tests object, with the given text contents, and referenced by the given alias.

**Compilation flags:**

`static`

**Template:**

`set_text_output(Alias,Contents)`

**Mode and number of proofs:**

`set_text_output(+atom,+atom)` - `one`

`set_text_output(+atom,+list(atom))` - `one`

**See also:**

text_output_assertion/3

check_text_output/2

clean_text_output/0

------------------------------------------------------------------------

###### `set_text_output/1`

Creates a temporary file, in the same directory as the tests object, with the given text contents, and sets the current output stream to the file.

**Compilation flags:**

`static`

**Template:**

`set_text_output(Contents)`

**Mode and number of proofs:**

`set_text_output(+atom)` - `one`

`set_text_output(+list(atom))` - `one`

**See also:**

text_output_assertion/2

check_text_output/1

clean_text_output/0

------------------------------------------------------------------------

###### `check_text_output/3`

Checks that the temporary file (open with the given options and alias in the same directory as the tests object) being written have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`check_text_output(Alias,Contents,Options)`

**Mode and number of proofs:**

`check_text_output(+atom,+atom,+list(stream_option))` - `zero_or_one`

**See also:**

set_text_output/3

text_output_assertion/4

clean_text_output/0

------------------------------------------------------------------------

###### `check_text_output/2`

Checks that the temporary file (open with default options and alias in the same directory as the tests object) being written have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`check_text_output(Alias,Contents)`

**Mode and number of proofs:**

`check_text_output(+atom,+atom)` - `zero_or_one`

**See also:**

set_text_output/2

text_output_assertion/3

clean_text_output/0

------------------------------------------------------------------------

###### `check_text_output/1`

Checks that the temporary file being written have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`check_text_output(Contents)`

**Mode and number of proofs:**

`check_text_output(+atom)` - `zero_or_one`

**See also:**

set_text_output/1

text_output_assertion/2

clean_text_output/0

------------------------------------------------------------------------

###### `text_output_assertion/4`

Returns an assertion for checking that the temporary file (open with the given options and alias in the same directory as the tests object) being written have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`text_output_assertion(Alias,Contents,Options,Assertion)`

**Mode and number of proofs:**

`text_output_assertion(+atom,+atom,+list(stream_option),--callable)` - `one`

**See also:**

set_text_output/3

check_text_output/3

clean_text_output/0

------------------------------------------------------------------------

###### `text_output_assertion/3`

Returns an assertion for checking that the temporary file (open with default options and alias in the same directory as the tests object) being written have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`text_output_assertion(Alias,Contents,Assertion)`

**Mode and number of proofs:**

`text_output_assertion(+atom,+atom,--callable)` - `one`

**See also:**

set_text_output/2

check_text_output/2

clean_text_output/0

------------------------------------------------------------------------

###### `text_output_assertion/2`

Returns an assertion for checking that the temporary file (open with default options in the same directory as the tests object) being written have the expected text contents.

**Compilation flags:**

`static`

**Template:**

`text_output_assertion(Contents,Assertion)`

**Mode and number of proofs:**

`text_output_assertion(+atom,--callable)` - `one`

**See also:**

set_text_output/1

check_text_output/1

clean_text_output/0

------------------------------------------------------------------------

###### `text_output_contents/3`

Returns the contents of the temporary file (open with the given options and alias in the same directory as the tests object) being written.

**Compilation flags:**

`static`

**Template:**

`text_output_contents(Alias,Contents,Options)`

**Mode and number of proofs:**

`text_output_contents(+atom,-list(character),+list(stream_option))` - `one`

------------------------------------------------------------------------

###### `text_output_contents/2`

Returns the contents of the temporary file (open with default options and alias in the same directory as the tests object) being written.

**Compilation flags:**

`static`

**Template:**

`text_output_contents(Alias,Contents)`

**Mode and number of proofs:**

`text_output_contents(+atom,-list(character))` - `one`

------------------------------------------------------------------------

###### `text_output_contents/1`

Returns the contents of the temporary file (open with default options in the same directory as the tests object) being written.

**Compilation flags:**

`static`

**Template:**

`text_output_contents(Contents)`

**Mode and number of proofs:**

`text_output_contents(-list(character))` - `one`

------------------------------------------------------------------------

###### `clean_text_output/0`

Cleans the temporary file used when testing text output.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`clean_text_output` - `one`

**See also:**

set_text_output/3

set_text_output/2

set_text_output/1

------------------------------------------------------------------------

###### `set_binary_output/3`

Creates a temporary file, in the same directory as the tests object, with the given binary contents, and opens it for writing referenced by the given alias and using the additional options.

**Compilation flags:**

`static`

**Template:**

`set_binary_output(Alias,Contents,Options)`

**Mode and number of proofs:**

`set_binary_output(+atom,+list(byte),+list(stream_option))` - `one`

**See also:**

binary_output_assertion/3

check_binary_output/2

clean_binary_output/0

------------------------------------------------------------------------

###### `set_binary_output/2`

Creates a temporary file, in the same directory as the tests object, with the given binary contents, and opens it for writing referenced with the given alias.

**Compilation flags:**

`static`

**Template:**

`set_binary_output(Alias,Bytes)`

**Mode and number of proofs:**

`set_binary_output(+atom,+list(byte))` - `one`

**See also:**

binary_output_assertion/3

check_binary_output/2

clean_binary_output/0

------------------------------------------------------------------------

###### `set_binary_output/1`

Creates a temporary file, in the same directory as the tests object, with the given binary contents, and sets the current output stream to the file.

**Compilation flags:**

`static`

**Template:**

`set_binary_output(Bytes)`

**Mode and number of proofs:**

`set_binary_output(+list(byte))` - `one`

**See also:**

binary_output_assertion/2

check_binary_output/1

clean_binary_output/0

------------------------------------------------------------------------

###### `check_binary_output/2`

Checks that the temporary file (referenced by the given alias) have the expected binary contents.

**Compilation flags:**

`static`

**Template:**

`check_binary_output(Alias,Bytes)`

**Mode and number of proofs:**

`check_binary_output(+atom,+list(byte))` - `zero_or_one`

**See also:**

set_binary_output/3

set_binary_output/2

binary_output_assertion/3

clean_binary_output/0

------------------------------------------------------------------------

###### `check_binary_output/1`

Checks that the temporary file (open in the same directory as the tests object) have the expected binary contents.

**Compilation flags:**

`static`

**Template:**

`check_binary_output(Bytes)`

**Mode and number of proofs:**

`check_binary_output(+list(byte))` - `zero_or_one`

**See also:**

set_binary_output/1

binary_output_assertion/2

clean_binary_output/0

------------------------------------------------------------------------

###### `binary_output_assertion/3`

Returns an assertion for checking that the temporary file (referenced by the given alias) have the expected binary contents.

**Compilation flags:**

`static`

**Template:**

`binary_output_assertion(Alias,Bytes,Assertion)`

**Mode and number of proofs:**

`binary_output_assertion(+atom,+list(byte),--callable)` - `one`

**See also:**

set_binary_output/2

check_binary_output/2

clean_binary_output/0

------------------------------------------------------------------------

###### `binary_output_assertion/2`

Returns an assertion for checking that the temporary file (open in the same directory as the tests object) have the expected binary contents.

**Compilation flags:**

`static`

**Template:**

`binary_output_assertion(Bytes,Assertion)`

**Mode and number of proofs:**

`binary_output_assertion(+list(byte),--callable)` - `one`

**See also:**

set_binary_output/1

check_binary_output/1

clean_binary_output/0

------------------------------------------------------------------------

###### `binary_output_contents/2`

Returns the binary contents of the temporary file (referenced by the given alias) being written.

**Compilation flags:**

`static`

**Template:**

`binary_output_contents(Alias,Bytes)`

**Mode and number of proofs:**

`binary_output_contents(+atom,-list(byte))` - `one`

------------------------------------------------------------------------

###### `binary_output_contents/1`

Returns the binary contents of the temporary file being written.

**Compilation flags:**

`static`

**Template:**

`binary_output_contents(Bytes)`

**Mode and number of proofs:**

`binary_output_contents(-list(byte))` - `one`

------------------------------------------------------------------------

###### `clean_binary_output/0`

Cleans the temporary file used when testing binary output.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`clean_binary_output` - `one`

**See also:**

set_binary_output/3

set_binary_output/2

set_binary_output/1

------------------------------------------------------------------------

###### `create_text_file/3`

Creates a text file with the given contents. The file is open for writing using the given options. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`create_text_file(File,Contents,Options)`

**Mode and number of proofs:**

`create_text_file(+atom,+atom,+list(stream_option))` - `one`

`create_text_file(+atom,+list(atom),+list(stream_option))` - `one`

------------------------------------------------------------------------

###### `create_text_file/2`

Creates a text file with the given contents. The file is open for writing using default options. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`create_text_file(File,Contents)`

**Mode and number of proofs:**

`create_text_file(+atom,+atom)` - `one`

`create_text_file(+atom,+list(atom))` - `one`

------------------------------------------------------------------------

###### `create_binary_file/2`

Creates a binary file with the given contents. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`create_binary_file(File,Bytes)`

**Mode and number of proofs:**

`create_binary_file(+atom,+list(byte))` - `one`

------------------------------------------------------------------------

###### `check_text_file/3`

Checks that the contents of a text file match the expected contents. The file is open for reading using the given options. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`check_text_file(File,Contents,Options)`

**Mode and number of proofs:**

`check_text_file(+atom,+atom,+list(stream_option))` - `zero_or_one`

**See also:**

text_file_assertion/4

------------------------------------------------------------------------

###### `check_text_file/2`

Checks that the contents of a text file (open for reading using default options) match the expected contents. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`check_text_file(File,Contents)`

**Mode and number of proofs:**

`check_text_file(+atom,+atom)` - `zero_or_one`

**See also:**

text_file_assertion/3

------------------------------------------------------------------------

###### `text_file_assertion/4`

Returns an assertion for checking that the given file have the expected text contents. The file is open for reading using the given options. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`text_file_assertion(File,Contents,Options,Assertion)`

**Mode and number of proofs:**

`text_file_assertion(+atom,+atom,+list(stream_option),--callable)` - `one`

**See also:**

check_text_file/3

------------------------------------------------------------------------

###### `text_file_assertion/3`

Returns an assertion for checking that the given file have the expected text contents. The file is open for reading using default options. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`text_file_assertion(File,Contents,Assertion)`

**Mode and number of proofs:**

`text_file_assertion(+atom,+atom,--callable)` - `one`

**See also:**

check_text_file/2

------------------------------------------------------------------------

###### `check_binary_file/2`

Checks the contents of a binary file match the expected contents. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`check_binary_file(File,Bytes)`

**Mode and number of proofs:**

`check_binary_file(+atom,+list(byte))` - `zero_or_one`

**See also:**

binary_file_assertion/3

------------------------------------------------------------------------

###### `binary_file_assertion/3`

Returns an assertion for checking that the given file have the expected binary contents. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`binary_file_assertion(File,Bytes,Assertion)`

**Mode and number of proofs:**

`binary_file_assertion(+atom,+list(byte),--callable)` - `one`

**See also:**

check_binary_file/2

------------------------------------------------------------------------

###### `clean_file/1`

Closes any existing stream associated with the file and deletes the file if it exists. Relative file paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`clean_file(File)`

**Mode and number of proofs:**

`clean_file(+atom)` - `one`

**See also:**

clean_directory/1

file_path/2

------------------------------------------------------------------------

###### `clean_directory/1`

Deletes an empty directory if it exists. Relative directory paths are interpreted as relative to the tests object path.

**Compilation flags:**

`static`

**Template:**

`clean_directory(Directory)`

**Mode and number of proofs:**

`clean_directory(+atom)` - `one`

**See also:**

clean_file/1

file_path/2

------------------------------------------------------------------------

###### `closed_input_stream/2`

Opens a temporary file in the same directory as the tests object with the given options for reading, closes it, and returns its stream handle.

**Compilation flags:**

`static`

**Template:**

`closed_input_stream(Stream,Options)`

**Mode and number of proofs:**

`closed_input_stream(-stream,+list(stream_option))` - `one`

------------------------------------------------------------------------

###### `closed_output_stream/2`

Opens a temporary file in the same directory as the tests object with the given options for writing, closes it, and returns its stream handle.

**Compilation flags:**

`static`

**Template:**

`closed_output_stream(Stream,Options)`

**Mode and number of proofs:**

`closed_output_stream(-stream,+list(stream_option))` - `zero_or_one`

------------------------------------------------------------------------

###### `stream_position/1`

Returns a syntactically valid stream position by opening a temporary file in the same directory as the tests object.

**Compilation flags:**

`static`

**Template:**

`stream_position(Position)`

**Mode and number of proofs:**

`stream_position(-stream_position)` - `one`

------------------------------------------------------------------------

###### `test/2`

Table of defined tests.

**Compilation flags:**

`static`

**Template:**

`test(Identifier,Test)`

**Mode and number of proofs:**

`test(?callable,?compound)` - `zero_or_more`

------------------------------------------------------------------------

##### Private predicates

###### `running_test_sets_/0`

Internal flag used when running two or more test sets as a unified set.

**Compilation flags:**

`dynamic`

**Mode and number of proofs:**

`running_test_sets_` - `zero_or_one`

------------------------------------------------------------------------

###### `test/3`

Compiled unit tests. The list of variables is used to ensure variable sharing between a test with its test options.

**Compilation flags:**

`static`

**Template:**

`test(Identifier,Variables,Outcome)`

**Mode and number of proofs:**

`test(?callable,?list(variable),?nonvar)` - `zero_or_more`

------------------------------------------------------------------------

###### `auxiliary_predicate_counter_/1`

Counter for generating unique auxiliary predicate names.

**Compilation flags:**

`dynamic`

**Template:**

`auxiliary_predicate_counter_(Counter)`

**Mode and number of proofs:**

`auxiliary_predicate_counter_(?integer)` - `one_or_more`

------------------------------------------------------------------------

###### `test_/2`

Table of compiled tests.

**Compilation flags:**

`dynamic`

**Template:**

`test_(Identifier,Test)`

**Mode and number of proofs:**

`test_(?callable,?compound)` - `zero_or_more`

------------------------------------------------------------------------

###### `selected_test_/1`

Table of selected tests for execution.

**Compilation flags:**

`dynamic`

**Template:**

`selected_test_(Identifier)`

**Mode and number of proofs:**

`selected_test_(?callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `skipped_/1`

Counter for skipped tests.

**Compilation flags:**

`dynamic`

**Template:**

`skipped_(Counter)`

**Mode and number of proofs:**

`skipped_(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `passed_/3`

Counter and total time for passed tests.

**Compilation flags:**

`dynamic`

**Template:**

`passed_(Counter,CPUTime,WallTime)`

**Mode and number of proofs:**

`passed_(?integer,-float,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `failed_/3`

Counter and total time for failed tests.

**Compilation flags:**

`dynamic`

**Template:**

`failed_(Counter,CPUTime,WallTime)`

**Mode and number of proofs:**

`failed_(?integer,-float,-float)` - `zero_or_one`

------------------------------------------------------------------------

###### `flaky_/1`

Counter for failed tests that are marked as flaky.

**Compilation flags:**

`dynamic`

**Template:**

`flaky_(Counter)`

**Mode and number of proofs:**

`flaky_(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `fired_/3`

Fired clauses when running the unit tests.

**Compilation flags:**

`dynamic`

**Template:**

`fired_(Entity,Predicate,Clause)`

**Mode and number of proofs:**

`fired_(?entity_identifier,?predicate_indicator,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `covered_/4`

Auxiliary predicate for collecting statistics on clause coverage.

**Compilation flags:**

`dynamic`

**Template:**

`covered_(Entity,Predicate,Covered,Total)`

**Mode and number of proofs:**

`covered_(?entity_identifier,?callable,?integer,?integer)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

###### `op(700,xfx,=~=)`

**Scope:**

`public`

**category**

#### `lgtunit_messages`

Logtalk unit test framework default message translations.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 12:2:0

**Date:** 2025-10-20

**Compilation flags:**

`static`

**Provides:**

logtalk::message_prefix_stream/4

logtalk::message_tokens//2

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `failed_test_reason//1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `failed_test_reason//1`

Used to rewrite a term representing the reason why a term failed into a list of tokens.

**Compilation flags:**

`static`

**Template:**

`failed_test_reason(Reason)`

**Mode and number of proofs:**

`failed_test_reason(@nonvar)` - `one_or_more`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `minimal_output`

Intercepts unit test execution messages and outputs a minimal report.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 3:0:0

**Date:** 2021-05-27

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Remarks:**

> - Usage: Simply load this object before running your tests using the goal `logtalk_load(lgtunit(minimal_output))`.
>
> - Limitations: Cannot be used when the test objects also intercept `lgtunit` messages.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `tap_output`

Intercepts unit test execution messages and outputs a report using the TAP format to the current output stream.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 5:0:0

**Date:** 2025-04-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Remarks:**

> - Usage: Simply load this object before running your tests using the goal `logtalk_load(lgtunit(tap_output))`.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

  - `generating_/0`

  - `partial_/1`

  - `test_count_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `generating_/0`

Flag to detect report in progress when processing two or more test sets as a unified set.

**Compilation flags:**

`dynamic`

**Mode and number of proofs:**

`generating_` - `zero_or_one`

------------------------------------------------------------------------

###### `partial_/1`

Cache of total of tests per test set.

**Compilation flags:**

`dynamic`

**Template:**

`partial_(Count)`

**Mode and number of proofs:**

`partial_(?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `test_count_/1`

Test counter.

**Compilation flags:**

`dynamic`

**Template:**

`test_count_(Count)`

**Mode and number of proofs:**

`test_count_(?integer)` - `zero_or_one`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `tap_report`

Intercepts unit test execution messages and generates a `tap_report.txt` file using the TAP output format in the same directory as the tests object file.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 6:0:0

**Date:** 2025-04-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Uses:**

logtalk

**Remarks:**

> - Usage: Simply load this object before running your tests using the goal `logtalk_load(lgtunit(tap_report))`.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

  - `partial_/1`

  - `test_count_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `partial_/1`

Cache of total of tests per test set.

**Compilation flags:**

`dynamic`

**Template:**

`partial_(Count)`

**Mode and number of proofs:**

`partial_(?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `test_count_/1`

Test counter.

**Compilation flags:**

`dynamic`

**Template:**

`test_count_(Count)`

**Mode and number of proofs:**

`test_count_(?integer)` - `zero_or_one`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `xunit_net_v2_output`

Intercepts unit test execution messages and outputs a report using the xUnit.net v2 XML format to the current output stream.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 5:0:0

**Date:** 2025-04-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Uses:**

user

**Remarks:**

> - Usage: Simply load this object before running your tests using the goal `logtalk_load(lgtunit(xunit_net_v2_output))`.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

  - `message_cache_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `message_cache_/1`

Table of messages emitted by the lgtunit tool when running tests.

**Compilation flags:**

`dynamic`

**Template:**

`message_cache_(Message)`

**Mode and number of proofs:**

`message_cache_(?callable)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `xunit_net_v2_report`

Intercepts unit test execution messages and generates a `xunit_report.xml` file using the xUnit.net v2 XML format in the same directory as the tests object file.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 6:0:0

**Date:** 2025-04-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Uses:**

logtalk

user

**Remarks:**

> - Usage: Simply load this object before running your tests using the goal `logtalk_load(lgtunit(xunit_net_v2_report))`.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

  - `message_cache_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `message_cache_/1`

Table of messages emitted by the lgtunit tool when running tests.

**Compilation flags:**

`dynamic`

**Template:**

`message_cache_(Message)`

**Mode and number of proofs:**

`message_cache_(?callable)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `xunit_output`

Intercepts unit test execution messages and outputs a report using the xUnit XML format to the current output stream.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 5:0:1

**Date:** 2025-04-11

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Uses:**

logtalk

user

**Remarks:**

> - Usage: Simply load this object before running your tests using the goal `logtalk_load(lgtunit(xunit_output))`.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

  - `message_cache_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `message_cache_/1`

Table of messages emitted by the lgtunit tool when running tests.

**Compilation flags:**

`dynamic`

**Template:**

`message_cache_(Message)`

**Mode and number of proofs:**

`message_cache_(?callable)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `xunit_report`

Intercepts unit test execution messages and generates a `xunit_report.xml` file using the xUnit XML format in the same directory as the tests object file.

**Availability:**

`logtalk_load(lgtunit(loader))`

**Author:** Paulo Moura

**Version:** 6:0:0

**Date:** 2025-04-07

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::message_hook/4

**Uses:**

logtalk

user

**Remarks:**

> - Usage: Simply load this object before running your tests using the goal `logtalk_load(lgtunit(xunit_report))`.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

  - `message_cache_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `message_cache_/1`

Table of messages emitted by the lgtunit tool when running tests.

**Compilation flags:**

`dynamic`

**Template:**

`message_cache_(Message)`

**Mode and number of proofs:**

`message_cache_(?callable)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

### library")

**protocol**

#### `cloning`

Object cloning protocol.

**Availability:**

`logtalk_load(library(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2010-09-14

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `clone/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `clone/1`

Clones an object, returning the identifier of the new object if none is given.

**Compilation flags:**

`static`

**Template:**

`clone(Clone)`

**Mode and number of proofs:**

`clone(?object)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**category**

#### `counters`

Named integer counters. Counter names can be any nonvar term.

**Availability:**

`logtalk_load(library(loader))`

**Author:** Paulo Moura

**Version:** 1:0:1

**Date:** 2022-02-11

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `counter/2`

  - `increment_counter/1`

  - `decrement_counter/1`

  - `reset_counter/1`

  - `reset_counters/0`

- Protected predicates

- Private predicates

  - `counter_/2`

- Operators

##### Public predicates

###### `counter/2`

True if `Counter` is a counter with value `Value`.

**Compilation flags:**

`static`

**Template:**

`counter(Counter,Value)`

**Mode and number of proofs:**

`counter(?nonvar,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `increment_counter/1`

Increments the named counter.

**Compilation flags:**

`static`

**Template:**

`increment_counter(Counter)`

**Mode and number of proofs:**

`increment_counter(+nonvar)` - `one`

------------------------------------------------------------------------

###### `decrement_counter/1`

Decrements the named counter.

**Compilation flags:**

`static`

**Template:**

`decrement_counter(Counter)`

**Mode and number of proofs:**

`decrement_counter(+nonvar)` - `one`

------------------------------------------------------------------------

###### `reset_counter/1`

Resets the named counter to zero. Creates the counter if it does not exist.

**Compilation flags:**

`static`

**Template:**

`reset_counter(Counter)`

**Mode and number of proofs:**

`reset_counter(+nonvar)` - `one`

------------------------------------------------------------------------

###### `reset_counters/0`

Resets all existing named counters to zero.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`reset_counters` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

###### `counter_/2`

Table of named counters.

**Compilation flags:**

`dynamic`

**Template:**

`counter_(Counter,Value)`

**Mode and number of proofs:**

`counter_(?nonvar,?integer)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**object**

#### `streamvars`

Stream variables (supporting logical, backtracable, adding and retrieving of terms).

**Availability:**

`logtalk_load(library(loader))`

**Author:** Nobukuni Kino and Paulo Moura

**Version:** 1:3:0

**Date:** 2019-06-15

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `new/1`

  - `new/2`

  - `(<=)/2`

  - `(=>)/2`

- Protected predicates

- Private predicates

- Operators

  - `op(100,xfx,<=)`

  - `op(100,xfx,=>)`

##### Public predicates

###### `new/1`

Makes `Variable` a stream variable. Initial state will be empty.

**Compilation flags:**

`static`

**Template:**

`new(Variable)`

**Mode and number of proofs:**

`new(--streamvar)` - `one`

**Exceptions:**

Variable is not a variable:

`type_error(variable,Variable)`

------------------------------------------------------------------------

###### `new/2`

Makes `Variable` a stream variable and sets its initial state to `Value`.

**Compilation flags:**

`static`

**Template:**

`new(Variable,Value)`

**Mode and number of proofs:**

`new(--streamvar,@nonvar)` - `one`

**Exceptions:**

Variable is not a variable:

`type_error(variable,Variable)`

------------------------------------------------------------------------

###### `(<=)/2`

Sets the state of the stream variable `Variable` to `Value` (initializing the variable if needed).

**Compilation flags:**

`static`

**Template:**

`Variable<=Value`

**Mode and number of proofs:**

`(?streamvar)<=(@nonvar)` - `one`

------------------------------------------------------------------------

###### `(=>)/2`

Unifies `Value` with the current state of the stream variable `Variable`.

**Compilation flags:**

`static`

**Template:**

`Variable=>Value`

**Mode and number of proofs:**

`+streamvar=>`` ``?nonvar` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

###### `op(100,xfx,<=)`

**Scope:**

`public`

###### `op(100,xfx,=>)`

**Scope:**

`public`

### linda")

**object**

#### `linda`

Linda tuple-space implementation for process communication. Provides a server that acts as a shared blackboard where clients can write (`out/1`), read (`rd/1`), and remove (`in/1`) tuples. Uses threaded engines for the server implementation and the sockets library for network communication.

**Availability:**

`logtalk_load(linda(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls,`` ``threaded`

**Provides:**

logtalk::message_prefix_stream/4

**Uses:**

list

logtalk

os

socket

**Remarks:**

> - Supported backends: ECLiPSe, GNU Prolog, SICStus Prolog, SWI-Prolog, and Trealla Prolog (requires both multi-threading and sockets support).
>
> - Linda operations: The basic operations are `out/1` (write tuple), `in/1` (remove tuple, blocking), `rd/1` (read tuple, blocking), `in_noblock/1` (remove tuple, non-blocking), and `rd_noblock/1` (read tuple, non-blocking).
>
> - Tuple matching: Tuples are matched using unification.
>
> - Blocking behavior: The `in/1` and `rd/1` predicates block until a matching tuple is available. The `in_noblock/1` and `rd_noblock/1` predicates fail immediately if no matching tuple is found.
>
> - Multiple clients: Multiple clients can connect to the same server. A tuple removed by `in/1` or `in_noblock/1` is only removed for one client.
>
> - API compatibility: The API is inspired by the SICStus Prolog Linda library.
>
> - Network communication: Uses TCP sockets for client-server communication, allowing processes to run on different machines.

**Inherited public predicates:**

(none)

- Public predicates

  - `linda/0`

  - `linda/1`

  - `linda_client/1`

  - `close_client/0`

  - `shutdown_server/0`

  - `linda_timeout/2`

  - `out/1`

  - `in/1`

  - `in_noblock/1`

  - `in/2`

  - `in_list/2`

  - `rd/1`

  - `rd_noblock/1`

  - `rd/2`

  - `rd_list/2`

  - `findall_rd_noblock/3`

  - `findall_in_noblock/3`

- Protected predicates

- Private predicates

  - `server_socket_/1`

  - `client_connection_/3`

  - `accept_hook_/1`

  - `server_running_/0`

  - `server_shutdown_/0`

  - `tuple_/1`

  - `waiting_/3`

  - `engine_counter_/1`

  - `client_engine_/2`

  - `client_connection_input_/1`

  - `client_connection_output_/1`

  - `client_timeout_/1`

  - `ts_out/1`

  - `ts_in/4`

  - `ts_in_noblock/2`

  - `ts_in_list/4`

  - `ts_rd/4`

  - `ts_rd_noblock/2`

  - `ts_rd_list/4`

  - `ts_findall_rd_noblock/3`

  - `ts_findall_in_noblock/3`

- Operators

##### Public predicates

###### `linda/0`

Starts a Linda server on an automatically assigned port. The server address (`Host:Port`) is written to the current output stream. The predicate succeeds when all clients have disconnected after a shutdown request.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`linda` - `one`

------------------------------------------------------------------------

###### `linda/1`

Starts a Linda server with the given options. The predicate succeeds when all clients have disconnected after a shutdown request.

**Compilation flags:**

`static`

**Template:**

`linda(Options)`

**Meta-predicate template:**

`linda(::)`

**Mode and number of proofs:**

`linda(+list)` - `one`

**Remarks:**

> - Option `port(Port)`: Use `Port` as the server port. Must be an integer and an available port.
>
> - Option `Address-Goal`: `Address` is unified with `Host:Port` and `Goal` is called when the server starts. Useful for saving the address or starting clients.
>
> - Option `accept_hook(Client,Stream,Goal)`: When a client connects, `Client` is unified with the client address, `Stream` with the connection stream, and `Goal` is called. If `Goal` fails, the connection is rejected.

------------------------------------------------------------------------

###### `linda_client/1`

Connects to a Linda server at the given address (`Host:Port`).

**Compilation flags:**

`static`

**Template:**

`linda_client(Address)`

**Mode and number of proofs:**

`linda_client(+compound)` - `one_or_error`

**Exceptions:**

Already connected:

`linda_error(already_connected)`

Connection failed:

`linda_error(connection_failed(Error))`

------------------------------------------------------------------------

###### `close_client/0`

Closes the connection to the Linda server.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`close_client` - `one`

------------------------------------------------------------------------

###### `shutdown_server/0`

Sends a shutdown signal to the server. The server stops accepting new connections but continues serving existing clients until they all disconnect. Call `close_client/0` after this predicate.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`shutdown_server` - `one_or_error`

**Exceptions:**

Not connected:

`linda_error(not_connected)`

------------------------------------------------------------------------

###### `linda_timeout/2`

Gets or sets the client timeout. `OldTime` is unified with the current timeout and the timeout is set to `NewTime`. The timeout value is either `off` (no timeout, wait forever) or `Seconds:Milliseconds`.

**Compilation flags:**

`static`

**Template:**

`linda_timeout(OldTime,NewTime)`

**Mode and number of proofs:**

`linda_timeout(?compound,+compound)` - `one`

------------------------------------------------------------------------

###### `out/1`

Places the tuple `Tuple` in the tuple-space.

**Compilation flags:**

`static`

**Template:**

`out(Tuple)`

**Mode and number of proofs:**

`out(+term)` - `one`

------------------------------------------------------------------------

###### `in/1`

Removes a tuple matching `Tuple` from the tuple-space. Blocks if no matching tuple is available.

**Compilation flags:**

`static`

**Template:**

`in(Tuple)`

**Mode and number of proofs:**

`in(?term)` - `one`

------------------------------------------------------------------------

###### `in_noblock/1`

Removes a tuple matching `Tuple` from the tuple-space. Fails if no matching tuple is available.

**Compilation flags:**

`static`

**Template:**

`in_noblock(Tuple)`

**Mode and number of proofs:**

`in_noblock(?term)` - `zero_or_one`

------------------------------------------------------------------------

###### `in/2`

Removes a tuple matching one of the patterns in `TupleList` from the tuple-space. `Tuple` is unified with the matched tuple. Blocks if no matching tuple is available.

**Compilation flags:**

`static`

**Template:**

`in(TupleList,Tuple)`

**Mode and number of proofs:**

`in(+list,?term)` - `one`

------------------------------------------------------------------------

###### `in_list/2`

Removes a tuple matching one of the patterns in `TupleList` from the tuple-space. `Tuple` is unified with the matched tuple. Blocks if no matching tuple is available.

**Compilation flags:**

`static`

**Template:**

`in_list(TupleList,Tuple)`

**Mode and number of proofs:**

`in_list(+list,?term)` - `one`

------------------------------------------------------------------------

###### `rd/1`

Reads a tuple matching `Tuple` from the tuple-space without removing it. Blocks if no matching tuple is available.

**Compilation flags:**

`static`

**Template:**

`rd(Tuple)`

**Mode and number of proofs:**

`rd(?term)` - `one`

------------------------------------------------------------------------

###### `rd_noblock/1`

Reads a tuple matching `Tuple` from the tuple-space without removing it. Fails if no matching tuple is available.

**Compilation flags:**

`static`

**Template:**

`rd_noblock(Tuple)`

**Mode and number of proofs:**

`rd_noblock(?term)` - `zero_or_one`

------------------------------------------------------------------------

###### `rd/2`

Reads a tuple matching one of the patterns in `TupleList` from the tuple-space without removing it. `Tuple` is unified with the matched tuple. Blocks if no matching tuple is available.

**Compilation flags:**

`static`

**Template:**

`rd(TupleList,Tuple)`

**Mode and number of proofs:**

`rd(+list,?term)` - `one`

------------------------------------------------------------------------

###### `rd_list/2`

Reads a tuple matching one of the patterns in `TupleList` from the tuple-space without removing it. `Tuple` is unified with the matched tuple. Blocks if no matching tuple is available.

**Compilation flags:**

`static`

**Template:**

`rd_list(TupleList,Tuple)`

**Mode and number of proofs:**

`rd_list(+list,?term)` - `one`

------------------------------------------------------------------------

###### `findall_rd_noblock/3`

Returns a list of all instances of `Template` for tuples matching `Tuple` in the tuple-space. The operation is atomic.

**Compilation flags:**

`static`

**Template:**

`findall_rd_noblock(Template,Tuple,List)`

**Mode and number of proofs:**

`findall_rd_noblock(?term,+term,?list)` - `one`

------------------------------------------------------------------------

###### `findall_in_noblock/3`

Removes and returns a list of all instances of `Template` for tuples matching `Tuple` in the tuple-space. The operation is atomic - all matching tuples are removed in one synchronized operation.

**Compilation flags:**

`static`

**Template:**

`findall_in_noblock(Template,Tuple,List)`

**Mode and number of proofs:**

`findall_in_noblock(?term,+term,?list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `server_socket_/1`

Stores the server socket descriptor.

**Compilation flags:**

`dynamic`

**Template:**

`server_socket_(ServerSocket)`

**Mode and number of proofs:**

`server_socket_(?term)` - `zero_or_one`

------------------------------------------------------------------------

###### `client_connection_/3`

Stores active client connections. Each client has an ID, input stream, and output stream.

**Compilation flags:**

`dynamic`

**Template:**

`client_connection_(ClientId,InputStream,OutputStream)`

**Mode and number of proofs:**

`client_connection_(?term,?term,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `accept_hook_/1`

Stores the optional accept hook goal to call when a client connects.

**Compilation flags:**

`dynamic`

**Template:**

`accept_hook_(Hook)`

**Mode and number of proofs:**

`accept_hook_(?callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `server_running_/0`

Flag indicating the server is running.

**Compilation flags:**

`dynamic`

**Mode and number of proofs:**

`server_running_` - `zero_or_one`

------------------------------------------------------------------------

###### `server_shutdown_/0`

Flag indicating the server has received a shutdown request.

**Compilation flags:**

`dynamic`

**Mode and number of proofs:**

`server_shutdown_` - `zero_or_one`

------------------------------------------------------------------------

###### `tuple_/1`

Stores tuples in the Linda tuple space.

**Compilation flags:**

`dynamic`

**Template:**

`tuple_(Tuple)`

**Mode and number of proofs:**

`tuple_(?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `waiting_/3`

Stores blocked clients waiting for tuples. Records the client ID, request pattern, and output stream.

**Compilation flags:**

`dynamic`

**Template:**

`waiting_(ClientId,Request,OutputStream)`

**Mode and number of proofs:**

`waiting_(?term,?term,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `engine_counter_/1`

Counter for generating unique client engine names.

**Compilation flags:**

`dynamic`

**Template:**

`engine_counter_(Counter)`

**Mode and number of proofs:**

`engine_counter_(?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `client_engine_/2`

Maps client IDs to their corresponding threaded engine names.

**Compilation flags:**

`dynamic`

**Template:**

`client_engine_(ClientId,EngineName)`

**Mode and number of proofs:**

`client_engine_(?term,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `client_connection_input_/1`

Stores the input stream for the client connection to the server.

**Compilation flags:**

`dynamic`

**Template:**

`client_connection_input_(InputStream)`

**Mode and number of proofs:**

`client_connection_input_(?term)` - `zero_or_one`

------------------------------------------------------------------------

###### `client_connection_output_/1`

Stores the output stream for the client connection to the server.

**Compilation flags:**

`dynamic`

**Template:**

`client_connection_output_(OutputStream)`

**Mode and number of proofs:**

`client_connection_output_(?term)` - `zero_or_one`

------------------------------------------------------------------------

###### `client_timeout_/1`

Stores the timeout value for blocking client operations. Value is either `off` or `Seconds:Milliseconds`.

**Compilation flags:**

`dynamic`

**Template:**

`client_timeout_(Timeout)`

**Mode and number of proofs:**

`client_timeout_(?compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `ts_out/1`

Synchronized predicate to add a tuple to the tuple space and wake waiting clients.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`ts_out(Tuple)`

**Mode and number of proofs:**

`ts_out(+term)` - `one`

------------------------------------------------------------------------

###### `ts_in/4`

Synchronized predicate to remove a matching tuple or register a waiting client.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`ts_in(Tuple,ClientId,OutputStream,Found)`

**Mode and number of proofs:**

`ts_in(+term,+term,+term,-compound)` - `one`

------------------------------------------------------------------------

###### `ts_in_noblock/2`

Synchronized predicate to try removing a matching tuple without blocking.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`ts_in_noblock(Tuple,Found)`

**Mode and number of proofs:**

`ts_in_noblock(+term,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `ts_in_list/4`

Synchronized predicate to remove a tuple matching one of multiple patterns or register a waiting client.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`ts_in_list(TupleList,ClientId,OutputStream,Found)`

**Mode and number of proofs:**

`ts_in_list(+list,+term,+term,-compound)` - `one`

------------------------------------------------------------------------

###### `ts_rd/4`

Synchronized predicate to read a matching tuple or register a waiting client.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`ts_rd(Tuple,ClientId,OutputStream,Found)`

**Mode and number of proofs:**

`ts_rd(+term,+term,+term,-compound)` - `one`

------------------------------------------------------------------------

###### `ts_rd_noblock/2`

Synchronized predicate to try reading a matching tuple without blocking.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`ts_rd_noblock(Tuple,Found)`

**Mode and number of proofs:**

`ts_rd_noblock(+term,-compound)` - `zero_or_one`

------------------------------------------------------------------------

###### `ts_rd_list/4`

Synchronized predicate to read a tuple matching one of multiple patterns or register a waiting client.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`ts_rd_list(TupleList,ClientId,OutputStream,Found)`

**Mode and number of proofs:**

`ts_rd_list(+list,+term,+term,-compound)` - `one`

------------------------------------------------------------------------

###### `ts_findall_rd_noblock/3`

Synchronized predicate to collect all tuples matching a pattern.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`ts_findall_rd_noblock(Template,Tuple,List)`

**Mode and number of proofs:**

`ts_findall_rd_noblock(+term,+term,-list)` - `zero_or_more`

------------------------------------------------------------------------

###### `ts_findall_in_noblock/3`

Synchronized predicate to collect and remove all tuples matching a pattern.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`ts_findall_in_noblock(Template,Tuple,List)`

**Mode and number of proofs:**

`ts_findall_in_noblock(+term,+term,-list)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

### listing")

**category**

#### `listing`

Listing predicates.

**Availability:**

`logtalk_load(listing(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2024-01-26

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `listing/0`

  - `listing/1`

  - `portray_clause/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `listing/0`

Lists all clauses of all visible dynamic predicates to the current output stream.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`listing` - `one`

------------------------------------------------------------------------

###### `listing/1`

Lists all clauses of a visible dynamic predicate or non-terminal to the current output stream. When the argument is a clause head, lists all matching clauses.

**Compilation flags:**

`static`

**Template:**

`listing(Spec)`

**Mode and number of proofs:**

`listing(+predicate_indicator)` - `one_or_error`

`listing(+non_terminal_indicator)` - `one_or_error`

`listing(+callable)` - `one_or_error`

**Exceptions:**

`Spec` is not ground:

`instantiation_error`

`Spec` is ground but not a valid predicate indicator:

`type_error(predicate_indicator,Spec)`

`Spec` is ground but not a valid non-terminal indicator:

`type_error(non_terminal_indicator,Spec)`

`Spec` is a predicate indicator but not a visible predicate:

`existence_error(predicate,Spec)`

`Spec` is a non-terminal indicator but not a visible non-terminal:

`existence_error(non_terminal,Spec)`

`Spec` is a callable term with a `Functor/Arity` indicator but not a visible predicate:

`existence_error(predicate,Functor/Arity)`

`Spec` is a predicate indicator of a visible predicate but not a dynamic predicate:

`permission_error(access,predicate,Spec)`

`Spec` is a non-terminal indicator of a visible non-terminal but not a dynamic non-terminal:

`permission_error(access,non_terminal,Spec)`

`Spec` is a callable term for a visible predicate with a `Functor/Arity` indicator but not a dynamic predicate:

`permission_error(access,predicate,Functor/Arity)`

------------------------------------------------------------------------

###### `portray_clause/1`

Pretty prints a clause to the current output stream.

**Compilation flags:**

`static`

**Template:**

`portray_clause(Clause)`

**Mode and number of proofs:**

`portray_clause(+clause)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### logging")

**object**

#### `logger`

Global logger object for logging events to files.

**Availability:**

`logtalk_load(logging(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2011-01-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` loggingp

**Remarks:**

(none)

**Inherited public predicates:**

 define_log_file/2  disable_logging/1  enable_logging/1  init_log_file/2  log_event/2  log_file/2  logging/1

- Public predicates

- Protected predicates

- Private predicates

  - `log_file_/2`

  - `logging_to_file_/2`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `log_file_/2`

Table of log files.

**Compilation flags:**

`dynamic`

**Template:**

`log_file_(Alias,File)`

**Mode and number of proofs:**

`log_file_(?atom,?nonvar)` - `zero_or_more`

------------------------------------------------------------------------

###### `logging_to_file_/2`

Table of logging file status for log files.

**Compilation flags:**

`dynamic`

**Template:**

`logging_to_file_(Alias,Status)`

**Mode and number of proofs:**

`logging_to_file_(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**category**

#### `logging`

Logging events to files category.

**Availability:**

`logtalk_load(logging(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2011-01-06

**Compilation flags:**

`static`

**Implements:**

`public` loggingp

**Remarks:**

(none)

**Inherited public predicates:**

 define_log_file/2  disable_logging/1  enable_logging/1  init_log_file/2  log_event/2  log_file/2  logging/1

- Public predicates

- Protected predicates

- Private predicates

  - `log_file_/2`

  - `logging_to_file_/2`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `log_file_/2`

Table of log files.

**Compilation flags:**

`dynamic`

**Template:**

`log_file_(Alias,File)`

**Mode and number of proofs:**

`log_file_(?atom,?nonvar)` - `zero_or_more`

------------------------------------------------------------------------

###### `logging_to_file_/2`

Table of logging file status for log files.

**Compilation flags:**

`dynamic`

**Template:**

`logging_to_file_(Alias,Status)`

**Mode and number of proofs:**

`logging_to_file_(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

**protocol**

#### `loggingp`

Logging events to files protocol.

**Availability:**

`logtalk_load(logging(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2011-01-06

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `log_file/2`

  - `define_log_file/2`

  - `init_log_file/2`

  - `log_event/2`

  - `logging/1`

  - `enable_logging/1`

  - `disable_logging/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `log_file/2`

Access to the table of log files.

**Compilation flags:**

`static`

**Template:**

`log_file(Alias,File)`

**Mode and number of proofs:**

`log_file(?atom,?atom)` - `zero_or_more`

------------------------------------------------------------------------

###### `define_log_file/2`

Defines a log file with alias Alias and file name File. If the log file already exists, its contents are kept. Logging is enabled by default.

**Compilation flags:**

`static`

**Template:**

`define_log_file(Alias,File)`

**Mode and number of proofs:**

`define_log_file(+atom,+atom)` - `one`

------------------------------------------------------------------------

###### `init_log_file/2`

Initializes a new log file with alias Alias and file name File. If the log file already exists, its contents are erased. Logging is enabled by default.

**Compilation flags:**

`static`

**Template:**

`init_log_file(Alias,File)`

**Mode and number of proofs:**

`init_log_file(+atom,+atom)` - `one`

------------------------------------------------------------------------

###### `log_event/2`

Logs an event Event to a log file with alias Alias. Fails if a log file with alias Alias is not defined.

**Compilation flags:**

`static`

**Template:**

`log_event(Alias,Event)`

**Mode and number of proofs:**

`log_event(+atom,+nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `logging/1`

True if logging to file with alias Alias is enabled.

**Compilation flags:**

`static`

**Template:**

`logging(Alias)`

**Mode and number of proofs:**

`logging(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `enable_logging/1`

Enables logging to file with alias Alias. Fails if a log file with alias Alias is not defined.

**Compilation flags:**

`static`

**Template:**

`enable_logging(Alias)`

**Mode and number of proofs:**

`enable_logging(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `disable_logging/1`

Disables logging to file with alias Alias. Fails if a log file with alias Alias is not defined.

**Compilation flags:**

`static`

**Template:**

`disable_logging(Alias)`

**Mode and number of proofs:**

`disable_logging(+atom)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

logging

### loops")

**object**

#### `loop`

Loop control structures predicates.

**Availability:**

`logtalk_load(loops(loader))`

**Author:** Paulo Moura

**Version:** 1:4:1

**Date:** 2020-12-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` loopp

**Remarks:**

(none)

**Inherited public predicates:**

 dowhile/2  fordownto/3  fordownto/4  fordownto/5  foreach/3  foreach/4  forto/3  forto/4  forto/5  whiledo/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `loopp`

Loop control constructs protocol.

**Availability:**

`logtalk_load(loops(loader))`

**Author:** Paulo Moura

**Version:** 1:3:0

**Date:** 2017-03-20

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `whiledo/2`

  - `dowhile/2`

  - `foreach/3`

  - `foreach/4`

  - `forto/3`

  - `forto/4`

  - `forto/5`

  - `fordownto/3`

  - `fordownto/4`

  - `fordownto/5`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `whiledo/2`

While `Condition` is true do `Action`.

**Compilation flags:**

`static`

**Template:**

`whiledo(Condition,Action)`

**Meta-predicate template:**

`whiledo(0,0)`

**Mode and number of proofs:**

`whiledo(+callable,@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `dowhile/2`

Do `Action` while `Condition` is true.

**Compilation flags:**

`static`

**Template:**

`dowhile(Action,Condition)`

**Meta-predicate template:**

`dowhile(0,0)`

**Mode and number of proofs:**

`dowhile(@callable,+callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `foreach/3`

For each `Element` in `List` call `Goal`.

**Compilation flags:**

`static`

**Template:**

`foreach(Element,List,Goal)`

**Meta-predicate template:**

`foreach(*,*,0)`

**Mode and number of proofs:**

`foreach(@var,+list(term),@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `foreach/4`

For each `Element` in `List` at position `Index` call `Goal`. `Index` starts at 1.

**Compilation flags:**

`static`

**Template:**

`foreach(Element,Index,List,Goal)`

**Meta-predicate template:**

`foreach(*,*,*,0)`

**Mode and number of proofs:**

`foreach(@var,@var,+list(term),@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `forto/3`

Calls `Goal` counting up from `First` to `Last`. Increment is 1. For convenience, `First` and `Last` can be arithmetic expressions. Fails iff `Goal` fails.

**Compilation flags:**

`static`

**Template:**

`forto(First,Last,Goal)`

**Meta-predicate template:**

`forto(*,*,0)`

**Mode and number of proofs:**

`forto(+number,+number,@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `forto/4`

Calls `Goal` counting up from `First` to `Last` and binding `Count` to each successive value. Increment is 1. For convenience, `First` and `Last` can be arithmetic expressions. Fails iff `Goal` fails.

**Compilation flags:**

`static`

**Template:**

`forto(Count,First,Last,Goal)`

**Meta-predicate template:**

`forto(*,*,*,0)`

**Mode and number of proofs:**

`forto(@var,+number,+number,@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `forto/5`

Calls `Goal` counting up from `First` to `Last` and binding `Count` to each successive value. For convenience, `First`, `Last`, and `Increment` can be arithmetic expressions (uses `Increment` absolute value). Fails iff `Goal` fails.

**Compilation flags:**

`static`

**Template:**

`forto(Count,First,Last,Increment,Goal)`

**Meta-predicate template:**

`forto(*,*,*,*,0)`

**Mode and number of proofs:**

`forto(@var,+number,+number,+number,@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `fordownto/3`

Calls `Goal` counting down from `First` to `Last`. Decrement is 1. For convenience, `First` and `Last` can be arithmetic expressions. Fails iff `Goal` fails.

**Compilation flags:**

`static`

**Template:**

`fordownto(First,Last,Goal)`

**Meta-predicate template:**

`fordownto(*,*,0)`

**Mode and number of proofs:**

`fordownto(+number,+number,@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `fordownto/4`

Calls `Goal` counting down from `First` to `Last` and binding `Count` to each successive value. Decrement is 1. For convenience, `First` and `Last` can be arithmetic expressions. Fails iff `Goal` fails.

**Compilation flags:**

`static`

**Template:**

`fordownto(Count,First,Last,Goal)`

**Meta-predicate template:**

`fordownto(*,*,*,0)`

**Mode and number of proofs:**

`fordownto(@var,+number,+number,@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `fordownto/5`

Calls `Goal` counting down from `First` to `Last` and binding `Count` to each successive value. For convenience, `First`, `Last`, and `Decrement` can be arithmetic expressions (uses `Decrement` absolute value). Fails iff `Goal` fails.

**Compilation flags:**

`static`

**Template:**

`fordownto(Count,First,Last,Decrement,Goal)`

**Meta-predicate template:**

`fordownto(*,*,*,*,0)`

**Mode and number of proofs:**

`fordownto(@var,+number,+number,+number,@callable)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

loop

### mcp_server")

**protocol**

#### `mcp_prompt_protocol`

Protocol for Logtalk objects that provide prompts to be exposed via an MCP (Model Context Protocol) server. Implements the MCP 2025-06-18 specification. Implementing objects must define the set of prompts available and handle prompt get requests. Prompts are templates for structured LLM interactions that can accept arguments to customize their behavior.

**Availability:**

`logtalk_load(mcp_server(loader))`

**Author:** Paulo Moura

**Version:** 0:2:0

**Date:** 2026-02-24

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

> - Capabilities: Objects providing prompts must declare `prompts` in their `capabilities/1` predicate (from the `mcp_tool_protocol` protocol). The server will then advertise the `prompts` capability and handle `prompts/list` and `prompts/get` requests.
>
> - Prompt descriptors: Each prompt is described by a `prompt(Name,`` ``Description,`` ``Arguments)` or `prompt(Name,`` ``Title,`` ``Description,`` ``Arguments)` term where `Name` is an atom, `Title` is an optional human-friendly display name (an atom), `Description` is a human-readable atom, and `Arguments` is a list of `argument(ArgName,`` ``ArgDescription,`` ``Required)` terms.
>
> - Prompt messages: The `prompt_get/3` predicate must return a result term containing a list of messages. Each message is a `message(Role,`` ``Content)` term where `Role` is `user` or `assistant` and `Content` is `text(Text)` where `Text` is an atom.

**Inherited public predicates:**

(none)

- Public predicates

  - `prompts/1`

  - `prompt_get/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `prompts/1`

Returns a list of prompt descriptors available from this object. Each descriptor is a compound term `prompt(Name,`` ``Description,`` ``Arguments)` or `prompt(Name,`` ``Title,`` ``Description,`` ``Arguments)` where `Name` is the MCP prompt name (an atom), `Title` is an optional human-friendly display name (an atom), `Description` is a human-readable description (an atom), and `Arguments` is a list of `argument(ArgName,`` ``ArgDescription,`` ``Required)` terms describing the prompt arguments. `ArgName` and `ArgDescription` are atoms, and `Required` is the boolean `true` or `false`.

**Compilation flags:**

`static`

**Template:**

`prompts(Prompts)`

**Mode and number of proofs:**

`prompts(-list(compound))` - `one`

------------------------------------------------------------------------

###### `prompt_get/3`

Handles a prompt get request. `Name` is the MCP prompt name (as declared in `prompts/1`), `Arguments` is a list of `ArgumentName-Value` pairs provided by the client, and `Result` is unified with the prompt result. The result must be one of: `messages(MessageList)` for a list of prompt messages, or `messages(Description,`` ``MessageList)` to also include a description. Each message in the list must be a `message(Role,`` ``Content)` term where `Role` is `user` or `assistant` and `Content` is `text(Text)` where `Text` is an atom.

**Compilation flags:**

`static`

**Template:**

`prompt_get(Name,Arguments,Result)`

**Mode and number of proofs:**

`prompt_get(+atom,+list(pair),--compound)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**protocol**

#### `mcp_resource_protocol`

Protocol for Logtalk objects that provide resources to be exposed via an MCP (Model Context Protocol) server. Implements the MCP 2025-06-18 specification. Implementing objects must define the set of resources available and handle resource read requests. Resources expose data and content from the application that MCP clients can access.

**Availability:**

`logtalk_load(mcp_server(loader))`

**Author:** Paulo Moura

**Version:** 0:2:0

**Date:** 2026-02-24

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

> - Capabilities: Objects providing resources must declare `resources` in their `capabilities/1` predicate (from the `mcp_tool_protocol` protocol). The server will then advertise the `resources` capability and handle `resources/list` and `resources/read` requests.
>
> - Resource descriptors: Each resource is described by a `resource(URI,`` ``Name,`` ``Description,`` ``MimeType)` or `resource(URI,`` ``Name,`` ``Title,`` ``Description,`` ``MimeType)` term where `URI` is the resource identifier (an atom), `Name` is a human-readable name (an atom), `Title` is an optional human-friendly display name (an atom), `Description` is a human-readable description (an atom), and `MimeType` is the MIME type of the resource content (an atom, e.g. `'text/plain'`).
>
> - Resource contents: The `resource_read/3` predicate must return a result term. The result must be `contents(ContentList)` where each item is `text_content(URI,`` ``MimeType,`` ``Text)` for text resources or `blob_content(URI,`` ``MimeType,`` ``Base64Data)` for binary resources encoded as base64.

**Inherited public predicates:**

(none)

- Public predicates

  - `resources/1`

  - `resource_read/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `resources/1`

Returns a list of resource descriptors available from this object. Each descriptor is a compound term `resource(URI,`` ``Name,`` ``Description,`` ``MimeType)` or `resource(URI,`` ``Name,`` ``Title,`` ``Description,`` ``MimeType)` where `URI` is the resource identifier (an atom, typically a URI like `logtalk://my-app/data`), `Name` is a human-readable name (an atom), `Title` is an optional human-friendly display name (an atom), `Description` is a human-readable description (an atom), and `MimeType` is the MIME type (an atom, e.g. `'text/plain'`, `'application/json'`).

**Compilation flags:**

`static`

**Template:**

`resources(Resources)`

**Mode and number of proofs:**

`resources(-list(compound))` - `one`

------------------------------------------------------------------------

###### `resource_read/3`

Handles a resource read request. `URI` is the resource identifier (as declared in `resources/1`), `Arguments` is a list of `ArgumentName-Value` pairs (currently unused but reserved for future use), and `Result` is unified with the resource result. The result must be `contents(ContentList)` where each content item is either `text_content(URI,`` ``MimeType,`` ``Text)` for text resources or `blob_content(URI,`` ``MimeType,`` ``Base64Data)` for binary resources encoded as base64. `Text` and `Base64Data` must be atoms.

**Compilation flags:**

`static`

**Template:**

`resource_read(URI,Arguments,Result)`

**Mode and number of proofs:**

`resource_read(+atom,+list(pair),--compound)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**object**

#### `mcp_server`

MCP (Model Context Protocol) server for Logtalk applications. Exposes Logtalk objects implementing the `mcp_tool_protocol` and optionally `mcp_prompt_protocol` and `mcp_resource_protocol` protocols as MCP tool, prompt, and resource providers over stdio transport with Content-Length framing. Implements the MCP 2025-03-26 specification. Uses the `json_rpc` library for JSON-RPC 2.0 message handling.

**Availability:**

`logtalk_load(mcp_server(loader))`

**Author:** Paulo Moura

**Version:** 0:5:0

**Date:** 2026-02-24

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` options

**Uses:**

json_rpc

list

term_io

user

**Remarks:**

> - MCP specification: Implements the Model Context Protocol 2025-03-26: https://spec.modelcontextprotocol.io/specification/2025-03-26/
>
> - Transport: Uses stdio (standard input/output) with Content-Length header framing as defined by the MCP specification.
>
> - Version negotiation: During initialization, the server performs protocol version negotiation. The client sends its highest supported version in the `initialize` request. The server selects the highest version it supports that is compatible (i.e., less than or equal to the client version). If no compatible version exists, the server responds with error `-32602` (“Unsupported protocol version”) including a `data` field with the list of supported versions.
>
> - Capabilities: Supports the tools capability (`tools/list` and `tools/call`). Optionally supports the prompts capability (`prompts/list` and `prompts/get`) when the application declares it via `capabilities/1` and implements `mcp_prompt_protocol`. Optionally supports the resources capability (`resources/list` and `resources/read`) when the application declares it via `capabilities/1` and implements `mcp_resource_protocol`. Optionally supports the elicitation capability (`elicitation/create`) when the application declares it via `capabilities/1`.
>
> - Tool discovery: Tools are discovered from objects implementing the `mcp_tool_protocol`. Tool metadata (descriptions, parameter schemas) is derived from `info/2` and `mode/2` directives.
>
> - Prompt discovery: Prompts are discovered from objects implementing the `mcp_prompt_protocol`. Prompt metadata (names, descriptions, arguments) is declared via the `prompts/1` predicate.
>
> - Resource discovery: Resources are discovered from objects implementing the `mcp_resource_protocol`. Resource metadata (URIs, names, descriptions, MIME types) is declared via the `resources/1` predicate.
>
> - Auto-dispatch: When an object does not define `tool_call/3` or `tool_call/4` for a tool, the server auto-dispatches: it calls the predicate as a message to the object, collects output-mode arguments, and returns them as text content.
>
> - Elicitation: When the application declares `elicitation` in its `capabilities/1`, the server constructs an elicit closure and passes it to `tool_call/4`. The closure sends `elicitation/create` requests to the client and reads back the user response. This enables interactive tools that can ask the user questions during execution.
>
> - Error handling: Predicate failures and exceptions both result in MCP tool-level errors with `isError` set to `true`.

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  option/2  option/3  valid_option/1  valid_options/1

- Public predicates

  - `start/2`

  - `start/3`

  - `start/4`

  - `start/5`

  - `elicit_request/5`

- Protected predicates

- Private predicates

  - `initialized_/0`

  - `application_/1`

  - `server_name_/1`

  - `server_version_/1`

  - `server_title_/1`

  - `elicit_counter_/1`

  - `application_capabilities_/1`

- Operators

##### Public predicates

###### `start/2`

Starts the MCP server with the given server name and application object. The application object must implement the `mcp_tool_protocol` protocol. Reads JSON-RPC messages from standard input and writes responses to standard output using Content-Length framing. Blocks until the client disconnects or an exit signal is received.

**Compilation flags:**

`static`

**Template:**

`start(Name,Application)`

**Mode and number of proofs:**

`start(+atom,+object_identifier)` - `one`

------------------------------------------------------------------------

###### `start/3`

Starts the MCP server with the given server name, application object, and options. Currently supported options: `server_version(Version)` to set the server version (default `'1.0.0'`), `server_title(Title)` to set the server display title (default `''`, omitted when empty).

**Compilation flags:**

`static`

**Template:**

`start(Name,Application,Options)`

**Mode and number of proofs:**

`start(+atom,+object_identifier,+list)` - `one`

------------------------------------------------------------------------

###### `start/4`

Starts the MCP server with custom input and output streams. Useful for testing or non-stdio transports. Uses default options.

**Compilation flags:**

`static`

**Template:**

`start(Name,Application,Input,Output)`

**Mode and number of proofs:**

`start(+atom,+object_identifier,+stream,+stream)` - `one`

------------------------------------------------------------------------

###### `start/5`

Starts the MCP server with custom input and output streams and options.

**Compilation flags:**

`static`

**Template:**

`start(Name,Application,Input,Output,Options)`

**Mode and number of proofs:**

`start(+atom,+object_identifier,+stream,+stream,+list)` - `one`

------------------------------------------------------------------------

###### `elicit_request/5`

Sends an `elicitation/create` request to the MCP client and reads the response. `Input` and `Output` are the I/O streams. `Message` is the prompt text (an atom). `RequestedSchema` is a curly-term JSON Schema describing the input to request from the user (e.g., `{type-object,`` ``properties-{answer-{type-string,`` ``enum-[yes,`` ``no]}},`` ``required-[answer]}`). `Answer` is unified with `accept(Content)` (where `Content` is the user response as a curly-term), `decline`, or `cancel`. This predicate is typically not called directly but through the elicit closure passed to `tool_call/4`.

**Compilation flags:**

`static`

**Template:**

`elicit_request(Input,Output,Message,RequestedSchema,Answer)`

**Mode and number of proofs:**

`elicit_request(+stream,+stream,+atom,+compound,--compound)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `initialized_/0`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `application_/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `server_name_/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `server_version_/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `server_title_/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `elicit_counter_/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `application_capabilities_/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

##### Operators

(none)

**protocol**

#### `mcp_tool_protocol`

Protocol for Logtalk objects that provide tools to be exposed via an MCP (Model Context Protocol) server. Implements the MCP 2025-06-18 specification. Implementing objects must define the set of tools available and handle tool calls. Tool metadata (names, titles, descriptions, parameter schemas) can be derived automatically from `info/2` and `mode/2` directives on the tool predicates, or can be specified explicitly via the `tool/1` predicate.

**Availability:**

`logtalk_load(mcp_server(loader))`

**Author:** Paulo Moura

**Version:** 0:3:0

**Date:** 2026-02-24

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

> - Capabilities: Objects can optionally define `capabilities/1` to declare which MCP capabilities they require. Currently supported: `elicitation` (allows the server to ask the user questions during tool execution via MCP elicitation). If `capabilities/1` is not defined, only the `tools` capability is advertised.
>
> - Tool title: The tool title (human-friendly display name) is derived from a `title` key in the predicate `info/2` directive. If not specified, the predicate name (functor) is used as the title.
>
> - Structured output: Tools can declare an output schema via `output_schema/2` and return `structured(StructuredContent)` or `structured(ContentItems,`` ``StructuredContent)` results. The structured content is included in the `structuredContent` field of the tool call response alongside the `content` array.
>
> - Resource links: Tool results can include `resource_link(URI,`` ``Name)` or `resource_link(URI,`` ``Name,`` ``Description,`` ``MimeType)` content items in `results/1` lists.
>
> - Elicitation: Tools that need user interaction during execution should define `tool_call/4` instead of `tool_call/3`. The extra argument is an elicitation closure that can be called as `call(Elicit,`` ``Message,`` ``Schema,`` ``Answer)` where `Message` is the prompt text (an atom), `Schema` is a JSON Schema curly-term for the requested input, and `Answer` is unified with `accept(Content)`, `decline`, or `cancel`.

**Inherited public predicates:**

(none)

- Public predicates

  - `capabilities/1`

  - `tools/1`

  - `tool_call/3`

  - `tool_call/4`

  - `output_schema/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `capabilities/1`

Returns a list of MCP capabilities required by this tool provider. Currently supported capabilities: `elicitation` (server can ask the user questions during tool execution). If not defined, only the `tools` capability is advertised. The server uses this to build the `capabilities` field in the `initialize` response.

**Compilation flags:**

`static`

**Template:**

`capabilities(Capabilities)`

**Mode and number of proofs:**

`capabilities(-list(atom))` - `one`

------------------------------------------------------------------------

###### `tools/1`

Returns a list of tool descriptors available from this object. Each descriptor is a compound term `tool(Name,`` ``Functor,`` ``Arity)` where `Name` is the MCP tool name (an atom), `Functor` is the predicate functor, and `Arity` is the predicate arity. By default, the tool name is the predicate functor. Tool titles are derived from `info/2` `title` keys (falling back to the predicate name). Tool descriptions and parameter schemas are derived from the `info/2` and `mode/2` directives of the corresponding predicates.

**Compilation flags:**

`static`

**Template:**

`tools(Tools)`

**Mode and number of proofs:**

`tools(-list(compound))` - `one`

------------------------------------------------------------------------

###### `tool_call/3`

Handles a tool call. `Name` is the MCP tool name (as declared in `tools/1`), `Arguments` is a list of `ArgumentName-Value` pairs, and `Result` is unified with the tool result. The result must be one of: `text(Atom)` for a text result, `error(Atom)` for an error result, `results(List)` for a list of content items where each item is `text(Atom)`, `error(Atom)`, `resource_link(URI,`` ``Name)`, or `resource_link(URI,`` ``Name,`` ``Description,`` ``MimeType)`, `structured(StructuredContent)` for structured output with auto-generated text, or `structured(ContentItems,`` ``StructuredContent)` for structured output with explicit content items. If this predicate is not defined for a tool, the MCP server will use auto-dispatch: it calls the tool predicate as a message to the implementing object, collects output arguments, and returns them as a text result.

**Compilation flags:**

`static`

**Template:**

`tool_call(Name,Arguments,Result)`

**Mode and number of proofs:**

`tool_call(+atom,+list(pair),--compound)` - `one`

------------------------------------------------------------------------

###### `tool_call/4`

Handles a tool call with elicitation support. Same as `tool_call/3` but receives an `Elicit` closure as the third argument. The closure can be called as `call(Elicit,`` ``Message,`` ``Schema,`` ``Answer)` where `Message` is a prompt text (an atom), `Schema` is a curly-term JSON Schema describing the requested input (e.g., `{type-object,`` ``properties-{answer-{type-string,`` ``enum-[yes,`` ``no]}},`` ``required-[answer]}`), and `Answer` is unified with `accept(Content)` (where `Content` is the user response as a curly-term), `decline`, or `cancel`. Only available when the application declares `elicitation` in its `capabilities/1`. Falls back to `tool_call/3` and then auto-dispatch if not defined.

**Compilation flags:**

`static`

**Template:**

`tool_call(Name,Arguments,Elicit,Result)`

**Mode and number of proofs:**

`tool_call(+atom,+list(pair),+callable,--compound)` - `one`

------------------------------------------------------------------------

###### `output_schema/2`

Returns the JSON output schema for the given tool name. Optional; when defined, the schema is included in the tool descriptor as `outputSchema` and the tool can return `structured(StructuredContent)` or `structured(ContentItems,`` ``StructuredContent)` results. The schema must be a curly-term following JSON Schema format (e.g. `{type-object,`` ``properties-{temperature-{type-number}},`` ``required-[temperature]}`).

**Compilation flags:**

`static`

**Template:**

`output_schema(Name,Schema)`

**Mode and number of proofs:**

`output_schema(+atom,-compound)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### memcached")

**object**

#### `memcached`

Portable Memcached client implementing the text (ASCII) protocol. Uses the sockets library for TCP communication.

**Availability:**

`logtalk_load(memcached(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-09

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

list

socket

user

**Remarks:**

> - Supported backends: ECLiPSe, GNU Prolog, SICStus Prolog, SWI-Prolog, and Trealla Prolog (same as the sockets library).
>
> - Protocol version: Implements the Memcached text (ASCII) protocol as documented in the official protocol.txt specification.
>
> - Connection: The default Memcached port is 11211. Connections are represented as opaque handles that should be passed to all other predicates.
>
> - Keys: Keys are atoms up to 250 characters. They must not include control characters or whitespace.
>
> - Flags: Flags are 32-bit unsigned integers stored alongside the data, opaque to the server.
>
> - Expiration: Expiration time in seconds. 0 means never expire. Values over 30 days (2592000) are treated as Unix timestamps.
>
> - Storage commands: Supports set, add, replace, append, prepend, and cas (check-and-set).
>
> - Retrieval commands: Supports get, gets (with CAS token), gat, and gats (get-and-touch).
>
> - Other commands: Supports delete, incr/decr, touch, flush_all, version, stats, and quit.

**Inherited public predicates:**

(none)

- Public predicates

  - `connect/3`

  - `connect/2`

  - `disconnect/1`

  - `set/5`

  - `set/3`

  - `add/5`

  - `replace/5`

  - `append/3`

  - `prepend/3`

  - `cas/6`

  - `get/3`

  - `get/4`

  - `gets/4`

  - `gets/5`

  - `mget/3`

  - `delete/2`

  - `incr/4`

  - `decr/4`

  - `touch/3`

  - `gat/4`

  - `gats/5`

  - `flush_all/1`

  - `flush_all/2`

  - `version/2`

  - `stats/2`

  - `stats/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `connect/3`

Connects to a Memcached server at the given host and port. Returns a connection handle for subsequent operations.

**Compilation flags:**

`static`

**Template:**

`connect(Host,Port,Connection)`

**Mode and number of proofs:**

`connect(+atom,+integer,--compound)` - `one_or_error`

**Exceptions:**

Connection refused or network error:

`memcached_error(connection_failed)`

------------------------------------------------------------------------

###### `connect/2`

Connects to a Memcached server at the given host on the default port (11211). Returns a connection handle for subsequent operations.

**Compilation flags:**

`static`

**Template:**

`connect(Host,Connection)`

**Mode and number of proofs:**

`connect(+atom,--compound)` - `one_or_error`

**Exceptions:**

Connection refused or network error:

`memcached_error(connection_failed)`

------------------------------------------------------------------------

###### `disconnect/1`

Disconnects from the Memcached server. Sends a quit command before closing.

**Compilation flags:**

`static`

**Template:**

`disconnect(Connection)`

**Mode and number of proofs:**

`disconnect(+compound)` - `one`

------------------------------------------------------------------------

###### `set/5`

Stores the data unconditionally. Overwrites any existing data for the key.

**Compilation flags:**

`static`

**Template:**

`set(Connection,Key,Value,Flags,ExpTime)`

**Mode and number of proofs:**

`set(+compound,+atom,+atom,+integer,+integer)` - `one_or_error`

**Exceptions:**

Storage failed:

`memcached_error(not_stored)`

Network error:

`memcached_error(Error)`

------------------------------------------------------------------------

###### `set/3`

Stores the data unconditionally with default flags (0) and no expiration (0).

**Compilation flags:**

`static`

**Template:**

`set(Connection,Key,Value)`

**Mode and number of proofs:**

`set(+compound,+atom,+atom)` - `one_or_error`

**Exceptions:**

Storage failed:

`memcached_error(not_stored)`

Network error:

`memcached_error(Error)`

------------------------------------------------------------------------

###### `add/5`

Stores the data only if the key does not already exist.

**Compilation flags:**

`static`

**Template:**

`add(Connection,Key,Value,Flags,ExpTime)`

**Mode and number of proofs:**

`add(+compound,+atom,+atom,+integer,+integer)` - `one_or_error`

**Exceptions:**

Key already exists:

`memcached_error(not_stored)`

Network error:

`memcached_error(Error)`

------------------------------------------------------------------------

###### `replace/5`

Stores the data only if the key already exists.

**Compilation flags:**

`static`

**Template:**

`replace(Connection,Key,Value,Flags,ExpTime)`

**Mode and number of proofs:**

`replace(+compound,+atom,+atom,+integer,+integer)` - `one_or_error`

**Exceptions:**

Key does not exist:

`memcached_error(not_stored)`

Network error:

`memcached_error(Error)`

------------------------------------------------------------------------

###### `append/3`

Appends the data to the end of an existing item’s data.

**Compilation flags:**

`static`

**Template:**

`append(Connection,Key,Value)`

**Mode and number of proofs:**

`append(+compound,+atom,+atom)` - `one_or_error`

**Exceptions:**

Key does not exist:

`memcached_error(not_stored)`

Network error:

`memcached_error(Error)`

------------------------------------------------------------------------

###### `prepend/3`

Prepends the data to the beginning of an existing item’s data.

**Compilation flags:**

`static`

**Template:**

`prepend(Connection,Key,Value)`

**Mode and number of proofs:**

`prepend(+compound,+atom,+atom)` - `one_or_error`

**Exceptions:**

Key does not exist:

`memcached_error(not_stored)`

Network error:

`memcached_error(Error)`

------------------------------------------------------------------------

###### `cas/6`

Stores the data only if no one else has updated it since the given CAS unique value was obtained (via gets/3).

**Compilation flags:**

`static`

**Template:**

`cas(Connection,Key,Value,Flags,ExpTime,CasUnique)`

**Mode and number of proofs:**

`cas(+compound,+atom,+atom,+integer,+integer,+integer)` - `one_or_error`

**Exceptions:**

CAS value mismatch (item modified by another client):

`memcached_error(exists)`

Key does not exist:

`memcached_error(not_found)`

Network error:

`memcached_error(Error)`

------------------------------------------------------------------------

###### `get/3`

Retrieves the value associated with the key. Fails if the key is not found.

**Compilation flags:**

`static`

**Template:**

`get(Connection,Key,Value)`

**Mode and number of proofs:**

`get(+compound,+atom,-atom)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `get/4`

Retrieves the value and flags associated with the key. Fails if the key is not found.

**Compilation flags:**

`static`

**Template:**

`get(Connection,Key,Value,Flags)`

**Mode and number of proofs:**

`get(+compound,+atom,-atom,-integer)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `gets/4`

Retrieves the value and CAS unique token for the key. Fails if the key is not found. The CAS value is used with the cas/6 predicate.

**Compilation flags:**

`static`

**Template:**

`gets(Connection,Key,Value,CasUnique)`

**Mode and number of proofs:**

`gets(+compound,+atom,-atom,-integer)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `gets/5`

Retrieves the value, flags, and CAS unique token for the key. Fails if the key is not found.

**Compilation flags:**

`static`

**Template:**

`gets(Connection,Key,Value,Flags,CasUnique)`

**Mode and number of proofs:**

`gets(+compound,+atom,-atom,-integer,-integer)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `mget/3`

Retrieves multiple keys at once. Returns a list of `item(Key,`` ``Value,`` ``Flags)` terms for found keys.

**Compilation flags:**

`static`

**Template:**

`mget(Connection,Keys,Items)`

**Mode and number of proofs:**

`mget(+compound,+list(atom),-list(compound))` - `one_or_error`

------------------------------------------------------------------------

###### `delete/2`

Deletes the item with the given key. Fails if the key is not found.

**Compilation flags:**

`static`

**Template:**

`delete(Connection,Key)`

**Mode and number of proofs:**

`delete(+compound,+atom)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `incr/4`

Increments the numeric value of the given key by the specified amount. Returns the new value. The item must already exist and contain a decimal representation of a 64-bit unsigned integer. Fails if the key is not found.

**Compilation flags:**

`static`

**Template:**

`incr(Connection,Key,Amount,NewValue)`

**Mode and number of proofs:**

`incr(+compound,+atom,+integer,-integer)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `decr/4`

Decrements the numeric value of the given key by the specified amount. Returns the new value. Underflow is caught: decrementing below 0 yields 0. Fails if the key is not found.

**Compilation flags:**

`static`

**Template:**

`decr(Connection,Key,Amount,NewValue)`

**Mode and number of proofs:**

`decr(+compound,+atom,+integer,-integer)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `touch/3`

Updates the expiration time of the given key without fetching the data. Fails if the key is not found.

**Compilation flags:**

`static`

**Template:**

`touch(Connection,Key,ExpTime)`

**Mode and number of proofs:**

`touch(+compound,+atom,+integer)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `gat/4`

Gets the value of the key and updates its expiration time. Fails if the key is not found.

**Compilation flags:**

`static`

**Template:**

`gat(Connection,Key,ExpTime,Value)`

**Mode and number of proofs:**

`gat(+compound,+atom,+integer,-atom)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `gats/5`

Gets the value and CAS unique token of the key and updates its expiration time. Fails if the key is not found.

**Compilation flags:**

`static`

**Template:**

`gats(Connection,Key,ExpTime,Value,CasUnique)`

**Mode and number of proofs:**

`gats(+compound,+atom,+integer,-atom,-integer)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `flush_all/1`

Invalidates all existing items immediately.

**Compilation flags:**

`static`

**Template:**

`flush_all(Connection)`

**Mode and number of proofs:**

`flush_all(+compound)` - `one_or_error`

------------------------------------------------------------------------

###### `flush_all/2`

Invalidates all existing items after the specified number of seconds.

**Compilation flags:**

`static`

**Template:**

`flush_all(Connection,Delay)`

**Mode and number of proofs:**

`flush_all(+compound,+integer)` - `one_or_error`

------------------------------------------------------------------------

###### `version/2`

Returns the version string of the Memcached server.

**Compilation flags:**

`static`

**Template:**

`version(Connection,Version)`

**Mode and number of proofs:**

`version(+compound,-atom)` - `one_or_error`

------------------------------------------------------------------------

###### `stats/2`

Returns general-purpose statistics as a list of `stat(Name,`` ``Value)` terms.

**Compilation flags:**

`static`

**Template:**

`stats(Connection,Stats)`

**Mode and number of proofs:**

`stats(+compound,-list(compound))` - `one_or_error`

------------------------------------------------------------------------

###### `stats/3`

Returns statistics for the given argument (e.g. `items`, `slabs`, `sizes`) as a list of `stat(Name,`` ``Value)` terms.

**Compilation flags:**

`static`

**Template:**

`stats(Connection,Argument,Stats)`

**Mode and number of proofs:**

`stats(+compound,+atom,-list(compound))` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### meta")

**object**

#### `meta`

Some useful meta-predicates.

**Availability:**

`logtalk_load(meta(loader))`

**Author:** Paulo Moura

**Version:** 5:2:0

**Date:** 2016-10-06

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` metap

**Aliases:**

`metap` `map/2` as `succeeds/2`

`metap` `map/2` as `maplist/2`

`metap` `map/3` as `maplist/3`

`metap` `map/4` as `maplist/4`

`metap` `map/5` as `maplist/5`

`metap` `map/6` as `maplist/6`

`metap` `map/7` as `maplist/7`

`metap` `map/8` as `maplist/8`

`metap` `include/3` as `filter/3`

`metap` `fold_left/4` as `foldl/4`

`metap` `fold_left_1/3` as `foldl1/3`

`metap` `fold_right/4` as `foldr/4`

`metap` `fold_right_1/3` as `foldr1/3`

`metap` `scan_left/4` as `scanl/4`

`metap` `scan_left_1/3` as `scanl1/3`

`metap` `scan_right/4` as `scanr/4`

`metap` `scan_right_1/3` as `scanr1/3`

**Remarks:**

(none)

**Inherited public predicates:**

 exclude/3  findall_member/4  findall_member/5  fold_left/4  fold_left_1/3  fold_right/4  fold_right_1/3  include/3  map/2  map/3  map/4  map/5  map/6  map/7  map/8  map_reduce/5  partition/4  partition/6  scan_left/4  scan_left_1/3  scan_right/4  scan_right_1/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

meta_compiler

**protocol**

#### `metap`

Useful meta-predicates protocol.

**Availability:**

`logtalk_load(meta(loader))`

**Author:** Paulo Moura

**Version:** 6:1:0

**Date:** 2015-12-23

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `include/3`

  - `exclude/3`

  - `findall_member/4`

  - `findall_member/5`

  - `partition/4`

  - `partition/6`

  - `fold_left/4`

  - `fold_left_1/3`

  - `scan_left/4`

  - `scan_left_1/3`

  - `fold_right/4`

  - `fold_right_1/3`

  - `scan_right/4`

  - `scan_right_1/3`

  - `map/2`

  - `map/3`

  - `map/4`

  - `map/5`

  - `map/6`

  - `map/7`

  - `map/8`

  - `map_reduce/5`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `include/3`

Returns a list of all list elements that satisfy a predicate.

**Compilation flags:**

`static`

**Template:**

`include(Closure,List,Included)`

**Meta-predicate template:**

`include(1,*,*)`

**Mode and number of proofs:**

`include(+callable,+list,-list)` - `one`

------------------------------------------------------------------------

###### `exclude/3`

Returns a list of all list elements that fail to satisfy a predicate.

**Compilation flags:**

`static`

**Template:**

`exclude(Closure,List,Excluded)`

**Meta-predicate template:**

`exclude(1,*,*)`

**Mode and number of proofs:**

`exclude(+callable,+list,-list)` - `one`

------------------------------------------------------------------------

###### `findall_member/4`

Finds all members of a list that satisfy a given test.

**Compilation flags:**

`static`

**Template:**

`findall_member(Member,List,Test,Result)`

**Meta-predicate template:**

`findall_member(*,*,0,*)`

**Mode and number of proofs:**

`findall_member(@term,+list,@callable,-list)` - `one`

------------------------------------------------------------------------

###### `findall_member/5`

Finds all members of a list that satisfy a given test appending the given tail to the result.

**Compilation flags:**

`static`

**Template:**

`findall_member(Member,List,Test,Result,Tail)`

**Meta-predicate template:**

`findall_member(*,*,0,*,*)`

**Mode and number of proofs:**

`findall_member(@term,+list,@callable,-list,+list)` - `one`

------------------------------------------------------------------------

###### `partition/4`

Partition a list of elements in two lists using a predicate.

**Compilation flags:**

`static`

**Template:**

`partition(Closure,List,Included,Excluded)`

**Meta-predicate template:**

`partition(1,*,*,*)`

**Mode and number of proofs:**

`partition(+callable,+list,-list,-list)` - `one`

------------------------------------------------------------------------

###### `partition/6`

Partitions a list in lists with values less, equal, and greater than a given value using a comparison predicate with the same argument order as `compare/3`.

**Compilation flags:**

`static`

**Template:**

`partition(Closure,List,Value,Less,Equal,Greater)`

**Meta-predicate template:**

`partition(3,*,*,*,*,*)`

**Mode and number of proofs:**

`partition(+callable,+list,@term,-list,-list,-list)` - `one`

------------------------------------------------------------------------

###### `fold_left/4`

List folding (left associative). Closure is extended with three arguments: accumulator, list element, and updated accumulator.

**Compilation flags:**

`static`

**Template:**

`fold_left(Closure,Accumulator,List,Result)`

**Meta-predicate template:**

`fold_left(3,*,*,*)`

**Mode and number of proofs:**

`fold_left(+callable,?term,+list,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `fold_left_1/3`

List folding (left associative). Closure is extended with three arguments: accumulator, list element, and updated accumulator. The initial value of the accumulator is the list first element. Fails for empty lists.

**Compilation flags:**

`static`

**Template:**

`fold_left_1(Closure,List,Result)`

**Meta-predicate template:**

`fold_left_1(3,*,*)`

**Mode and number of proofs:**

`fold_left_1(+callable,+list,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `scan_left/4`

List scanning (left associative). Closure is extended with three arguments: accumulator, list element, and updated accumulator.

**Compilation flags:**

`static`

**Template:**

`scan_left(Closure,Accumulator,List,Results)`

**Meta-predicate template:**

`scan_left(3,*,*,*)`

**Mode and number of proofs:**

`scan_left(+callable,?term,+list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `scan_left_1/3`

List scanning (left associative). Closure is extended with three arguments: accumulator, list element, and updated accumulator. The accumulator is initialized with the list first element. Fails for empty lists.

**Compilation flags:**

`static`

**Template:**

`scan_left_1(Closure,List,Results)`

**Meta-predicate template:**

`scan_left_1(3,*,*)`

**Mode and number of proofs:**

`scan_left_1(+callable,+list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `fold_right/4`

List folding (right associative). Closure is extended with three arguments: list element, accumulator, and updated accumulator.

**Compilation flags:**

`static`

**Template:**

`fold_right(Closure,Accumulator,List,Result)`

**Meta-predicate template:**

`fold_right(3,*,*,*)`

**Mode and number of proofs:**

`fold_right(+callable,?term,+list,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `fold_right_1/3`

List folding (right associative). Closure is extended with three arguments: list element, accumulator, and updated accumulator. The initial value of the accumulator is the list first element. Fails for empty lists.

**Compilation flags:**

`static`

**Template:**

`fold_right_1(Closure,List,Result)`

**Meta-predicate template:**

`fold_right_1(3,*,*)`

**Mode and number of proofs:**

`fold_right_1(+callable,+list,?term)` - `zero_or_more`

------------------------------------------------------------------------

###### `scan_right/4`

List scanning (right associative). Closure is extended with three arguments: list element, accumulator, and updated accumulator.

**Compilation flags:**

`static`

**Template:**

`scan_right(Closure,Accumulator,List,Results)`

**Meta-predicate template:**

`scan_right(3,*,*,*)`

**Mode and number of proofs:**

`scan_right(+callable,?term,+list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `scan_right_1/3`

List scanning (right associative). Closure is extended with three arguments: list element, accumulator, and updated accumulator. The accumulator is initialized with the list first element. Fails for empty lists.

**Compilation flags:**

`static`

**Template:**

`scan_right_1(Closure,List,Results)`

**Meta-predicate template:**

`scan_right_1(3,*,*)`

**Mode and number of proofs:**

`scan_right_1(+callable,+list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `map/2`

True if the predicate succeeds for each list element.

**Compilation flags:**

`static`

**Template:**

`map(Closure,List)`

**Meta-predicate template:**

`map(1,*)`

**Mode and number of proofs:**

`map(+callable,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `map/3`

List mapping predicate taken arguments from two lists of elements.

**Compilation flags:**

`static`

**Template:**

`map(Closure,List1,List2)`

**Meta-predicate template:**

`map(2,*,*)`

**Mode and number of proofs:**

`map(+callable,?list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `map/4`

List mapping predicate taken arguments from three lists of elements.

**Compilation flags:**

`static`

**Template:**

`map(Closure,List1,List2,List3)`

**Meta-predicate template:**

`map(3,*,*,*)`

**Mode and number of proofs:**

`map(+callable,?list,?list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `map/5`

List mapping predicate taken arguments from four lists of elements.

**Compilation flags:**

`static`

**Template:**

`map(Closure,List1,List2,List3,List4)`

**Meta-predicate template:**

`map(4,*,*,*,*)`

**Mode and number of proofs:**

`map(+callable,?list,?list,?list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `map/6`

List mapping predicate taken arguments from five lists of elements.

**Compilation flags:**

`static`

**Template:**

`map(Closure,List1,List2,List3,List4,List5)`

**Meta-predicate template:**

`map(5,*,*,*,*,*)`

**Mode and number of proofs:**

`map(+callable,?list,?list,?list,?list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `map/7`

List mapping predicate taken arguments from six lists of elements.

**Compilation flags:**

`static`

**Template:**

`map(Closure,List1,List2,List3,List4,List5,List6)`

**Meta-predicate template:**

`map(6,*,*,*,*,*,*)`

**Mode and number of proofs:**

`map(+callable,?list,?list,?list,?list,?list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `map/8`

List mapping predicate taken arguments from seven lists of elements.

**Compilation flags:**

`static`

**Template:**

`map(Closure,List1,List2,List3,List4,List5,List6,List7)`

**Meta-predicate template:**

`map(7,*,*,*,*,*,*,*)`

**Mode and number of proofs:**

`map(+callable,?list,?list,?list,?list,?list,?list,?list)` - `zero_or_more`

------------------------------------------------------------------------

###### `map_reduce/5`

Map a list and apply a fold left (reduce) to the resulting list.

**Compilation flags:**

`static`

**Template:**

`map_reduce(Map,Reduce,Accumulator,List,Result)`

**Meta-predicate template:**

`map_reduce(2,3,*,*,*)`

**Mode and number of proofs:**

`map_reduce(+callable,+callable,+term,?list,?term)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

meta

### meta_compiler")

**object**

#### `meta_compiler`

Compiler for the `meta` object meta-predicates. Generates auxiliary predicates in order to avoid meta-call overheads.

**Availability:**

`logtalk_load(meta_compiler(loader))`

**Author:** Paulo Moura

**Version:** 0:16:0

**Date:** 2024-10-24

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Uses:**

gensym

list

logtalk

user

**Remarks:**

> - Usage: Compile source files with calls to the `meta` object meta-predicates using the compiler option `hook(meta_compiler)`.

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

  - `generated_predicate_/1`

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `generated_predicate_/1`

Table of generated auxiliary predicates.

**Compilation flags:**

`dynamic`

**Template:**

`generated_predicate_(Predicate)`

**Mode and number of proofs:**

`generated_predicate_(?predicate_indicator)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

meta

### metagol")

**object**

#### `metagol`

Inductive logic programming (ILP) system based on meta-interpretive learning.

**Availability:**

`logtalk_load(metagol(loader))`

**Author:** Metagol authors; adapted to Logtalk by Paulo Moura.

**Version:** 0:24:4

**Date:** 2024-03-15

**Copyright:** Copyright 2016 Metagol authors; Copyright 2018-2024 Paulo Moura

**License:** BSD-3-Clause

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Provides:**

logtalk::message_tokens//2

logtalk::message_prefix_stream/4

**Uses:**

coroutining

integer

list

logtalk

meta

timeout

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

  - `learn/3`

  - `learn/2`

  - `learn_seq/2`

  - `learn_with_timeout/4`

  - `program_to_clauses/2`

  - `pprint/1`

  - `metarule/6`

  - `head_pred/1`

  - `body_pred/1`

  - `ibk/3`

  - `func_test/3`

  - `functional/0`

  - `min_clauses/1`

  - `max_clauses/1`

  - `max_inv_preds/1`

  - `metarule_next_id/1`

  - `timeout/1`

- Protected predicates

  - `pprint_clause/1`

  - `pprint_clauses/1`

  - `compiled_pred_call/2`

  - `body_pred_call/2`

  - `type/3`

- Private predicates

- Operators

##### Public predicates

###### `learn/3`

Learns from a set of positive examples and a set of negative examples and returns the learned program.

**Compilation flags:**

`static`

**Template:**

`learn(PositiveExamples,NegativeExamples,Program)`

**Mode and number of proofs:**

`learn(@list(example),@list(example),-list(term))` - `zero_or_more`

------------------------------------------------------------------------

###### `learn/2`

Learns from a set of positive examples and a set of negative examples and pretty prints the learned program.

**Compilation flags:**

`static`

**Template:**

`learn(PositiveExamples,NegativeExamples)`

**Mode and number of proofs:**

`learn(@list(example),@list(example))` - `zero_or_more`

------------------------------------------------------------------------

###### `learn_seq/2`

Learns from a sequence of examples represented as a list of PositiveExamples/NegativeExamples elements and returns the learned program.

**Compilation flags:**

`static`

**Template:**

`learn_seq(Examples,Program)`

**Mode and number of proofs:**

`learn_seq(@list(example),-list(clause))` - `zero_or_one`

------------------------------------------------------------------------

###### `learn_with_timeout/4`

Learns from a set of positive examples and a set of negative examples and returns the learned program constrained by the given timeout or its default value.

**Compilation flags:**

`static`

**Template:**

`learn_with_timeout(PositiveExamples,NegativeExamples,Program,Timeout)`

**Mode and number of proofs:**

`learn_with_timeout(@list(example),@list(example),-list(term),+number)` - `zero_or_one_or_error`

`learn_with_timeout(@list(example),@list(example),-list(term),-number)` - `zero_or_one_or_error`

**Exceptions:**

Learning does not complete in the allowed time:

`timeout(learn(PositiveExamples,NegativeExamples,Program))`

------------------------------------------------------------------------

###### `program_to_clauses/2`

Converts a learned program into a list of clauses.

**Compilation flags:**

`static`

**Template:**

`program_to_clauses(Program,Clauses)`

**Mode and number of proofs:**

`program_to_clauses(@list(term),-list(clause))` - `one`

------------------------------------------------------------------------

###### `pprint/1`

Pretty prints a learned program.

**Compilation flags:**

`static`

**Template:**

`pprint(Program)`

**Mode and number of proofs:**

`pprint(@list(term))` - `one`

------------------------------------------------------------------------

###### `metarule/6`

**Compilation flags:**

`static`

------------------------------------------------------------------------

###### `head_pred/1`

**Compilation flags:**

`static`

------------------------------------------------------------------------

###### `body_pred/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `ibk/3`

**Compilation flags:**

`static`

------------------------------------------------------------------------

###### `func_test/3`

**Compilation flags:**

`static`

------------------------------------------------------------------------

###### `functional/0`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `min_clauses/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `max_clauses/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `max_inv_preds/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `metarule_next_id/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `timeout/1`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

##### Protected predicates

###### `pprint_clause/1`

**Compilation flags:**

`static`

------------------------------------------------------------------------

###### `pprint_clauses/1`

**Compilation flags:**

`static`

------------------------------------------------------------------------

###### `compiled_pred_call/2`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `body_pred_call/2`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

###### `type/3`

**Compilation flags:**

`dynamic`

------------------------------------------------------------------------

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `metagol_example_protocol`

Convenient learning predicates for use in examples and unit tests.

**Availability:**

`logtalk_load(metagol(loader))`

**Author:** Paulo Moura.

**Version:** 0:1:1

**Date:** 2024-03-15

**License:** BSD-3-Clause

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `learn/1`

  - `learn/0`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `learn/1`

Learns and returns set of clauses.

**Compilation flags:**

`static`

**Template:**

`learn(Clauses)`

**Mode and number of proofs:**

`learn(-list(clause))` - `zero_or_more`

------------------------------------------------------------------------

###### `learn/0`

Learns and prints a set of clauses.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`learn` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### mutations")

**object**

#### `default_atom_mutations`

Default atom mutations.

**Availability:**

`logtalk_load(mutations(loader))`

**Author:** Paulo Moura

**Version:** 0:1:0

**Date:** 2023-11-24

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

mutations_store::mutation/4

**Uses:**

fast_random

list

type

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

type

**object**

#### `default_compound_mutations`

Default compound mutations.

**Availability:**

`logtalk_load(mutations(loader))`

**Author:** Paulo Moura

**Version:** 0:1:0

**Date:** 2023-11-23

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

mutations_store::mutation/4

**Uses:**

mutations_store

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

type

**object**

#### `default_float_mutations`

Default float mutations.

**Availability:**

`logtalk_load(mutations(loader))`

**Author:** Paulo Moura

**Version:** 0:1:0

**Date:** 2023-11-23

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

mutations_store::mutation/4

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

type

**object**

#### `default_integer_mutations`

Default integer mutations.

**Availability:**

`logtalk_load(mutations(loader))`

**Author:** Paulo Moura

**Version:** 0:1:0

**Date:** 2023-11-24

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

mutations_store::mutation/4

**Uses:**

fast_random

list

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

type

**object**

#### `default_list_mutations`

Default list mutations.

**Availability:**

`logtalk_load(mutations(loader))`

**Author:** Paulo Moura

**Version:** 0:1:0

**Date:** 2023-11-24

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

mutations_store::mutation/4

**Uses:**

fast_random

list

mutations_store

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

type

**category**

#### `mutations`

Adds mutations support to the library `type` object.

**Availability:**

`logtalk_load(mutations(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2023-11-23

**Compilation flags:**

`static`

**Complements:**

type

**Uses:**

mutations_store

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `mutation/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `mutation/3`

Returns a random mutation of a term into another term of the same type. The input `Term` is assume to be valid for the given `Type`.

**Compilation flags:**

`static`

**Template:**

`mutation(Type,Term,Mutation)`

**Mode and number of proofs:**

`mutation(@callable,@term,-term)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `mutations_store`

Stores mutation definitions for selected types. User extensible by defining objects or categories defining clauses for the `mutation/3` predicate and using this object as a hook object for their compilation.

**Availability:**

`logtalk_load(mutations(loader))`

**Author:** Paulo Moura

**Version:** 0:1:0

**Date:** 2023-11-23

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Uses:**

fast_random

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

  - `mutation/3`

  - `counter/2`

- Protected predicates

- Private predicates

  - `mutation/4`

  - `counter_/2`

- Operators

##### Public predicates

###### `mutation/3`

Returns a random mutation of a term into another term of the same type. The input `Term` is assumed to be valid for the given `Type`.

**Compilation flags:**

`static`

**Template:**

`mutation(Type,Term,Mutation)`

**Mode and number of proofs:**

`mutation(@callable,@term,-term)` - `one`

------------------------------------------------------------------------

###### `counter/2`

Table of the number of mutations available per type.

**Compilation flags:**

`static`

**Template:**

`counter(Type,N)`

**Mode and number of proofs:**

`counter(?callable,?positive_integer)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `mutation/4`

Returns a random mutation of a term into another term of the same type using mutator `N`. The input `Term` is assume to be valid for the given `Type`.

**Compilation flags:**

`static,`` ``multifile`

**Template:**

`mutation(Type,N,Term,Mutation)`

**Mode and number of proofs:**

`mutation(?callable,?positive_integer,@term,-term)` - `zero_or_more`

------------------------------------------------------------------------

###### `counter_/2`

Internal counter for the number of mutations available for a given type.

**Compilation flags:**

`dynamic`

**Template:**

`counter_(Type,N)`

**Mode and number of proofs:**

`counter_(?callable,?positive_integer)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

See also

type

### naive_bayes")

**object**

#### `naive_bayes`

Naive Bayes classifier with Laplace smoothing and Gaussian distribution support. Learns from a dataset object implementing the `dataset_protocol` protocol and returns a classifier term that can be used for prediction and exported as predicate clauses.

**Availability:**

`logtalk_load(naive_bayes(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` classifier_protocol

**Uses:**

format

list

pairs

population

**Remarks:**

> - Algorithm: Naive Bayes is a probabilistic classifier based on Bayes theorem with strong (naive) independence assumptions between features.
>
> - Categorical features: Uses Laplace smoothing to handle unseen feature values.
>
> - Continuous features: Uses Gaussian (normal) distribution to model numeric features.
>
> - Classifier representation: The learned classifier is represented by default as `nb_classifier(Classes,`` ``ClassPriors,`` ``AttributeNames,`` ``FeatureTypes,`` ``FeatureParams)` where `FeatureParams` contains the learned probabilities or statistics for each feature.

**Inherited public predicates:**

 classifier_to_clauses/4  classifier_to_file/4  learn/2  predict/3  print_classifier/1

- Public predicates

  - `predict_probabilities/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `predict_probabilities/3`

Predicts class probabilities for a new instance using the learned classifier. Returns a list of `Class-Probability` pairs. The instance is a list of `Attribute-Value` pairs.

**Compilation flags:**

`static`

**Template:**

`predict_probabilities(Classifier,Instance,Probabilities)`

**Mode and number of proofs:**

`predict_probabilities(+compound,+list,-list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

dataset_protocol, isolation_forest, c45, knn, nearest_centroid, random_forest, ada_boost

### nanoid")

**object**

#### `nanoid`

NanoID generator using atom representation, 21 symbols, and the standard URL alphabet.

**Availability:**

`logtalk_load(nanoid(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` nanoid(atom,21,\_-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ)

**Remarks:**

(none)

**Inherited public predicates:**

 generate/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

nanoid(Representation,Size,Alphabet), ids, ulid, uuid

**object**

#### `nanoid(Representation,Size,Alphabet)`

- `Representation` - Text representation for the NanoID. Possible values are `atom`, `chars`, and `codes`.

- `Size` - Number of symbols in the NanoID.

- `Alphabet` - Alphabet used for generating NanoIDs represented as an atom, list of characters, or list of character codes.

NanoID generator.

**Availability:**

`logtalk_load(nanoid(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` nanoid_protocol

**Uses:**

fast_random(Algorithm)

list

os

**Remarks:**

(none)

**Inherited public predicates:**

 generate/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

nanoid, ids(Representation,Bytes), ulid(Representation), uuid(Representation)

**protocol**

#### `nanoid_protocol`

NanoID generator protocol.

**Availability:**

`logtalk_load(nanoid(loader))`

**Author:** Paulo Moura

**Version:** 0:1:0

**Date:** 2026-02-26

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `generate/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `generate/1`

Returns a NanoID.

**Compilation flags:**

`static`

**Template:**

`generate(NanoID)`

**Mode and number of proofs:**

`generate(--ground)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### nearest_centroid")

**object**

#### `nearest_centroid`

Nearest Centroid classifier with multiple distance metrics. Learns from a dataset object implementing the `dataset_protocol` protocol and returns a classifier term that can be used for prediction and exported as predicate clauses.

**Availability:**

`logtalk_load(nearest_centroid(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` classifier_protocol

**Imports:**

`public` options

**Uses:**

format

list

numberlist

pairs

type

**Remarks:**

> - Algorithm: Assign to an instance the the class of the training samples whose mean (centroid) is closest to the instance.
>
> - Distance metrics: Supports Euclidean, Manhattan, and cosine distance metrics.
>
> - Feature types: Automatically handles numeric and categorical features.
>
> - Classifier representation: The learned classifier is represented by default as a `nc_classifier(AttributeNames,`` ``FeatureTypes,`` ``Centroids)` term.

**Inherited public predicates:**

 check_option/1  check_options/1  classifier_to_clauses/4  classifier_to_file/4  default_option/1  default_options/1  learn/2  option/2  option/3  predict/3  print_classifier/1  valid_option/1  valid_options/1

- Public predicates

  - `predict/4`

  - `predict_probabilities/3`

  - `predict_probabilities/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `predict/4`

Predicts the class label for a new instance using the learned classifier and the given options. The instance is a list of `Attribute-Value` pairs.

**Compilation flags:**

`static`

**Template:**

`predict(Classifier,Instance,Class,Options)`

**Mode and number of proofs:**

`predict(+compound,+list,-atom,+list(compound))` - `one`

------------------------------------------------------------------------

###### `predict_probabilities/3`

Predicts class probabilities for a new instance using the learned classifier and default options. Returns a list of `Class-Probability` pairs. The instance is a list of `Attribute-Value` pairs.

**Compilation flags:**

`static`

**Template:**

`predict_probabilities(Classifier,Instance,Probabilities)`

**Mode and number of proofs:**

`predict_probabilities(+compound,+list,-list)` - `one`

------------------------------------------------------------------------

###### `predict_probabilities/4`

Predicts class probabilities for a new instance using the learned classifier and the given options. Returns a list of `Class-Probability` pairs. The instance is a list of `Attribute-Value` pairs.

**Compilation flags:**

`static`

**Template:**

`predict_probabilities(Classifier,Instance,Probabilities,Options)`

**Mode and number of proofs:**

`predict_probabilities(+compound,+list,-list,+list(compound))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

dataset_protocol, isolation_forest, c45, knn, naive_bayes, random_forest, ada_boost

### nested_dictionaries")

**object**

#### `navltree`

Nested dictionary implementation based on the AVL tree implementation. Uses standard order to compare keys.

**Availability:**

`logtalk_load(nested_dictionaries(loader))`

**Author:** Paul Brown and Paulo Moura.

**Version:** 0:1:0

**Date:** 2021-04-09

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` nested_dictionary_protocol

**Extends:**

`private` avltree

**Remarks:**

(none)

**Inherited public predicates:**

 as_curly_bracketed/2  as_nested_dictionary/2  delete_in/4  empty/1  insert_in/4  lookup_in/3  new/1  update_in/4  update_in/5

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

nrbtree, nbintree

**object**

#### `nbintree`

Nested dictionary implementation based on the simple binary tree implementation. Uses standard order to compare keys.

**Availability:**

`logtalk_load(nested_dictionaries(loader))`

**Author:** Paul Brown and Paulo Moura.

**Version:** 0:1:0

**Date:** 2021-04-09

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` nested_dictionary_protocol

**Extends:**

`private` bintree

**Remarks:**

(none)

**Inherited public predicates:**

 as_curly_bracketed/2  as_nested_dictionary/2  delete_in/4  empty/1  insert_in/4  lookup_in/3  new/1  update_in/4  update_in/5

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

nrbtree, navltree

**protocol**

#### `nested_dictionary_protocol`

Nested dictionary protocol.

**Availability:**

`logtalk_load(nested_dictionaries(loader))`

**Author:** Paul Brown and Paulo Moura

**Version:** 0:1:0

**Date:** 2021-04-07

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `new/1`

  - `empty/1`

  - `as_nested_dictionary/2`

  - `as_curly_bracketed/2`

  - `lookup_in/3`

  - `update_in/4`

  - `update_in/5`

  - `insert_in/4`

  - `delete_in/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `new/1`

Create an empty (nested) dictionary.

**Compilation flags:**

`static`

**Template:**

`new(Dictionary)`

**Mode and number of proofs:**

`new(--dictionary)` - `one`

------------------------------------------------------------------------

###### `empty/1`

True iff the dictionary is empty.

**Compilation flags:**

`static`

**Template:**

`empty(Dictionary)`

**Mode and number of proofs:**

`empty(@dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `as_nested_dictionary/2`

Creates a (nested) dictionary term from a curly-brackted term representation.

**Compilation flags:**

`static`

**Template:**

`as_nested_dictionary(Term,Dictionary)`

**Mode and number of proofs:**

`as_nested_dictionary(++term,--dictionary)` - `one_or_error`

------------------------------------------------------------------------

###### `as_curly_bracketed/2`

Creates a a curly-brackted term representation from a (nested) dictionary.

**Compilation flags:**

`static`

**Template:**

`as_curly_bracketed(Dictionary,Term)`

**Mode and number of proofs:**

`as_curly_bracketed(+dictionary,--term)` - `one_or_error`

------------------------------------------------------------------------

###### `lookup_in/3`

Lookup a chain of keys in a nested dictionary. Unifies `Value` with `Dictionary` when `Keys` is the empty list.

**Compilation flags:**

`static`

**Template:**

`lookup_in(Keys,Value,Dictionary)`

**Mode and number of proofs:**

`lookup_in(++list(ground),?term,+dictionary)` - `zero_or_more`

------------------------------------------------------------------------

###### `update_in/4`

Updates the value found by traversing through the nested keys.

**Compilation flags:**

`static`

**Template:**

`update_in(OldDictionary,Keys,Value,NewDictionary)`

**Mode and number of proofs:**

`update_in(+dictionary,++list(ground),++term,--dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `update_in/5`

Updates the value found by traversing through the nested keys, only succeeding if the value found after traversal matches the old value.

**Compilation flags:**

`static`

**Template:**

`update_in(OldDictionary,Keys,OldValue,NewValue,NewDictionary)`

**Mode and number of proofs:**

`update_in(+dictionary,++list(ground),?term,++term,--dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `insert_in/4`

Inserts a key-value pair into a dictionary by traversing through the nested keys. When the key already exists, the associated value is updated.

**Compilation flags:**

`static`

**Template:**

`insert_in(OldDictionary,Keys,Value,NewDictionary)`

**Mode and number of proofs:**

`insert_in(+dictionary,++list(ground),++term,--dictionary)` - `zero_or_one`

------------------------------------------------------------------------

###### `delete_in/4`

Deletes a matching key-value pair from a dictionary by traversing through the nested keys, returning the updated dictionary.

**Compilation flags:**

`static`

**Template:**

`delete_in(OldDictionary,Keys,Value,NewDictionary)`

**Mode and number of proofs:**

`delete_in(+dictionary,++list(ground),?term,--dictionary)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

navltree, nbintree, nrbtree

**object**

#### `nrbtree`

Nested dictionary implementation based on the red-black tree implementation. Uses standard order to compare keys.

**Availability:**

`logtalk_load(nested_dictionaries(loader))`

**Author:** Paul Brown and Paulo Moura.

**Version:** 0:1:0

**Date:** 2021-04-09

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` nested_dictionary_protocol

**Extends:**

`private` rbtree

**Remarks:**

(none)

**Inherited public predicates:**

 as_curly_bracketed/2  as_nested_dictionary/2  delete_in/4  empty/1  insert_in/4  lookup_in/3  new/1  update_in/4  update_in/5

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

navltree, nbintree

### optionals")

**object**

#### `maybe`

Types and predicates for type-checking and handling optional terms. Inspired by Haskell.

**Availability:**

`logtalk_load(optionals(loader))`

**Author:** Paulo Moura

**Version:** 0:9:0

**Date:** 2025-06-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

type::type/1

type::check/2

arbitrary::arbitrary/1

arbitrary::arbitrary/2

arbitrary::shrinker/1

arbitrary::shrink/3

arbitrary::edge_case/2

**Uses:**

optional

optional(Optional)

random

type

**Remarks:**

> - Type-checking support: Defines type `maybe(Type)` for checking optional terms where the value hold by the optional term must be of the given type.
>
> - QuickCheck support: Defines clauses for the `arbitrary::arbitrary/1-2`, `arbitrary::shrinker/1`, `arbitrary::shrink/3`, and `arbitrary::edge_case/2` predicates to allow generating random values for the `maybe(Type)` type.

**Inherited public predicates:**

(none)

- Public predicates

  - `cat/2`

  - `sequence/2`

  - `traverse/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `cat/2`

Returns the values stored in the non-empty optional terms.

**Compilation flags:**

`static`

**Template:**

`cat(Optionals,Values)`

**Mode and number of proofs:**

`cat(+list(optional),-list)` - `one`

------------------------------------------------------------------------

###### `sequence/2`

Returns an optional term with a list of all values when all optional terms are not empty. Otherwise returns an empty optional term.

**Compilation flags:**

`static`

**Template:**

`sequence(Optionals,Optional)`

**Mode and number of proofs:**

`sequence(+list(optional),--nonvar)` - `one`

------------------------------------------------------------------------

###### `traverse/3`

Applies a closure to each list element to generate optional terms and then sequences them into a single optional term holding all values or an empty optional term.

**Compilation flags:**

`static`

**Template:**

`traverse(Closure,Terms,Optional)`

**Meta-predicate template:**

`traverse(2,*,*)`

**Mode and number of proofs:**

`traverse(+callable,+list,--nonvar)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

optional, optional(Optional), type, arbitrary

**object**

#### `optional`

Constructors for optional terms. An optional term is either empty or holds a value. Optional terms should be regarded as opaque terms and always used with the `optional/1` object by passing the optional term as a parameter.

**Availability:**

`logtalk_load(optionals(loader))`

**Author:** Paulo Moura

**Version:** 2:2:0

**Date:** 2026-02-21

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

type::type/1

type::check/2

**Remarks:**

> - Type-checking support: This object also defines a type `optional` for use with the `type` library object.

**Inherited public predicates:**

(none)

- Public predicates

  - `empty/1`

  - `of/2`

  - `from_goal/3`

  - `from_goal/2`

  - `from_generator/3`

  - `from_generator/2`

  - `from_goal_or_throw/3`

  - `from_goal_or_throw/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `empty/1`

Constructs an empty optional term.

**Compilation flags:**

`static`

**Template:**

`empty(Optional)`

**Mode and number of proofs:**

`empty(--nonvar)` - `one`

------------------------------------------------------------------------

###### `of/2`

Constructs an optional term holding the given value.

**Compilation flags:**

`static`

**Template:**

`of(Value,Optional)`

**Mode and number of proofs:**

`of(@term,--nonvar)` - `one`

------------------------------------------------------------------------

###### `from_goal/3`

Constructs an optional term holding a value bound by calling the given goal. Returns an empty optional term if the goal fails. Also returns an empty optional term if the goal throws an error, silently discarding the error information. Use `from_goal_or_throw/3` if exceptions should be propagated or the `expected` library `from_goal/3` predicate if error information should be preserved.

**Compilation flags:**

`static`

**Template:**

`from_goal(Goal,Value,Optional)`

**Meta-predicate template:**

`from_goal(0,*,*)`

**Mode and number of proofs:**

`from_goal(+callable,--term,--nonvar)` - `one`

------------------------------------------------------------------------

###### `from_goal/2`

Constructs an optional term holding a value bound by calling the given closure. Returns an empty optional term if the closure fails. Also returns an empty optional term if the closure throws an error, silently discarding the error information. Use `from_goal_or_throw/2` if exceptions should be propagated or the `expected` library `from_goal/2` predicate if error information should be preserved.

**Compilation flags:**

`static`

**Template:**

`from_goal(Closure,Optional)`

**Meta-predicate template:**

`from_goal(1,*)`

**Mode and number of proofs:**

`from_goal(+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `from_generator/3`

Constructs optional terms with the values generated by calling the given goal. On goal failure, returns an empty optional. On goal error, also returns an empty optional, silently discarding the error information.

**Compilation flags:**

`static`

**Template:**

`from_generator(Goal,Value,Optional)`

**Meta-predicate template:**

`from_generator(0,*,*)`

**Mode and number of proofs:**

`from_generator(+callable,--term,--nonvar)` - `one_or_more`

------------------------------------------------------------------------

###### `from_generator/2`

Constructs optional terms with the values generated by calling the given closure. On closure failure, returns an empty optional. On closure error, also returns an empty optional, silently discarding the error information.

**Compilation flags:**

`static`

**Template:**

`from_generator(Closure,Optional)`

**Meta-predicate template:**

`from_generator(1,*)`

**Mode and number of proofs:**

`from_generator(+from_generator,--nonvar)` - `one_or_more`

------------------------------------------------------------------------

###### `from_goal_or_throw/3`

Constructs an optional term holding a value bound by calling the given goal. Returns an empty optional term if the goal fails. Propagates any exception thrown by the goal.

**Compilation flags:**

`static`

**Template:**

`from_goal_or_throw(Goal,Value,Optional)`

**Meta-predicate template:**

`from_goal_or_throw(0,*,*)`

**Mode and number of proofs:**

`from_goal_or_throw(+callable,--term,--nonvar)` - `one_or_error`

------------------------------------------------------------------------

###### `from_goal_or_throw/2`

Constructs an optional term holding a value bound by calling the given closure. Returns an empty optional term if the closure fails. Propagates any exception thrown by the closure.

**Compilation flags:**

`static`

**Template:**

`from_goal_or_throw(Closure,Optional)`

**Meta-predicate template:**

`from_goal_or_throw(1,*)`

**Mode and number of proofs:**

`from_goal_or_throw(+callable,--nonvar)` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

optional(Optional), type

**object**

#### `optional(Optional)`

Optional term handling predicates. Requires passing an optional term (constructed using the `optional` object predicates) as a parameter.

**Availability:**

`logtalk_load(optionals(loader))`

**Author:** Paulo Moura

**Version:** 1:9:0

**Date:** 2025-06-19

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `is_empty/0`

  - `is_present/0`

  - `if_empty/1`

  - `if_present/1`

  - `if_present_or_else/2`

  - `filter/2`

  - `map/2`

  - `flat_map/2`

  - `or/2`

  - `get/1`

  - `or_else/2`

  - `or_else_get/2`

  - `or_else_call/2`

  - `or_else_fail/1`

  - `or_else_throw/2`

  - `map_or_else/3`

  - `zip/3`

  - `flatten/1`

  - `to_expected/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `is_empty/0`

True if the optional term is empty. See also the `if_empty/1` predicate.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`is_empty` - `zero_or_one`

------------------------------------------------------------------------

###### `is_present/0`

True if the optional term holds a value. See also the `if_present/1` predicate.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`is_present` - `zero_or_one`

------------------------------------------------------------------------

###### `if_empty/1`

Calls a goal if the optional term is empty. Succeeds otherwise.

**Compilation flags:**

`static`

**Template:**

`if_empty(Goal)`

**Meta-predicate template:**

`if_empty(0)`

**Mode and number of proofs:**

`if_empty(+callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `if_present/1`

Applies a closure to the value hold by the optional term if not empty. Succeeds otherwise.

**Compilation flags:**

`static`

**Template:**

`if_present(Closure)`

**Meta-predicate template:**

`if_present(1)`

**Mode and number of proofs:**

`if_present(+callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `if_present_or_else/2`

Applies a closure to the value hold by the optional term if not empty. Otherwise calls the given goal.

**Compilation flags:**

`static`

**Template:**

`if_present_or_else(Closure,Goal)`

**Meta-predicate template:**

`if_present_or_else(1,0)`

**Mode and number of proofs:**

`if_present_or_else(+callable,+callable)` - `zero_or_more`

------------------------------------------------------------------------

###### `filter/2`

Returns the optional term when it is not empty and the value it holds satisfies a closure. Otherwise returns an empty optional term.

**Compilation flags:**

`static`

**Template:**

`filter(Closure,NewOptional)`

**Meta-predicate template:**

`filter(1,*)`

**Mode and number of proofs:**

`filter(+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `map/2`

When the optional term is not empty and mapping a closure with the value it holds and the new value as additional arguments is successful, returns an optional term with the new value. Otherwise returns an empty optional term.

**Compilation flags:**

`static`

**Template:**

`map(Closure,NewOptional)`

**Meta-predicate template:**

`map(2,*)`

**Mode and number of proofs:**

`map(+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `flat_map/2`

When the optional term is not empty and mapping a closure with the value it holds and the new optional term as additional arguments is successful, returns the new optional term. Otherwise returns an empty optional term.

**Compilation flags:**

`static`

**Template:**

`flat_map(Closure,NewOptional)`

**Meta-predicate template:**

`flat_map(2,*)`

**Mode and number of proofs:**

`flat_map(+callable,--nonvar)` - `one`

------------------------------------------------------------------------

###### `or/2`

Returns the same optional term if not empty. Otherwise calls closure to generate a new optional term. Fails if optional term is empty and calling the closure fails or throws an error.

**Compilation flags:**

`static`

**Template:**

`or(NewOptional,Closure)`

**Meta-predicate template:**

`or(*,1)`

**Mode and number of proofs:**

`or(--term,@callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `get/1`

Returns the value hold by the optional term if not empty. Throws an error otherwise.

**Compilation flags:**

`static`

**Template:**

`get(Value)`

**Mode and number of proofs:**

`get(--term)` - `one_or_error`

**Exceptions:**

Optional is empty:

`existence_error(optional_term,Optional)`

------------------------------------------------------------------------

###### `or_else/2`

Returns the value hold by the optional term if not empty or the given default value if the optional term is empty.

**Compilation flags:**

`static`

**Template:**

`or_else(Value,Default)`

**Mode and number of proofs:**

`or_else(--term,@term)` - `one`

------------------------------------------------------------------------

###### `or_else_get/2`

Returns the value hold by the optional term if not empty. Applies a closure to compute the value otherwise. Throws an error when the optional term is empty and the value cannot be computed.

**Compilation flags:**

`static`

**Template:**

`or_else_get(Value,Closure)`

**Meta-predicate template:**

`or_else_get(*,1)`

**Mode and number of proofs:**

`or_else_get(--term,+callable)` - `one_or_error`

**Exceptions:**

Optional is empty and the term cannot be computed:

`existence_error(optional_term,Optional)`

------------------------------------------------------------------------

###### `or_else_call/2`

Returns the value hold by the optional term if not empty or calls a goal deterministically if the optional term is empty.

**Compilation flags:**

`static`

**Template:**

`or_else_call(Value,Goal)`

**Meta-predicate template:**

`or_else_call(*,0)`

**Mode and number of proofs:**

`or_else_call(--term,+callable)` - `zero_or_one`

------------------------------------------------------------------------

###### `or_else_fail/1`

Returns the value hold by the optional term if not empty. Fails otherwise. Usually called to skip over empty optional terms.

**Compilation flags:**

`static`

**Template:**

`or_else_fail(Value)`

**Mode and number of proofs:**

`or_else_fail(--term)` - `zero_or_one`

------------------------------------------------------------------------

###### `or_else_throw/2`

Returns the value hold by the optional term if not empty. Throws the given error otherwise.

**Compilation flags:**

`static`

**Template:**

`or_else_throw(Value,Error)`

**Mode and number of proofs:**

`or_else_throw(--term,@nonvar)` - `one_or_error`

------------------------------------------------------------------------

###### `map_or_else/3`

When the optional term is not empty and mapping a closure with the value it holds and the new value as additional arguments is successful, returns the new value. Otherwise returns the given default value.

**Compilation flags:**

`static`

**Template:**

`map_or_else(Closure,Default,Value)`

**Meta-predicate template:**

`map_or_else(2,*,*)`

**Mode and number of proofs:**

`map_or_else(+callable,@term,--term)` - `one`

------------------------------------------------------------------------

###### `zip/3`

When both this optional and the other optional hold values and applying a closure with both values and the new value as additional arguments is successful, returns an optional term with the new value. Otherwise returns an empty optional term.

**Compilation flags:**

`static`

**Template:**

`zip(Closure,OtherOptional,NewOptional)`

**Meta-predicate template:**

`zip(3,*,*)`

**Mode and number of proofs:**

`zip(+callable,+nonvar,--nonvar)` - `one`

------------------------------------------------------------------------

###### `flatten/1`

Flattens a nested optional term. When the optional term holds a value that is itself an optional term, returns the inner optional term. When the optional term holds a non-optional value, returns the same optional term. When the optional term is empty, returns an empty optional term.

**Compilation flags:**

`static`

**Template:**

`flatten(NewOptional)`

**Mode and number of proofs:**

`flatten(--nonvar)` - `one`

------------------------------------------------------------------------

###### `to_expected/2`

Converts the optional term to an expected term. Returns an expected term holding the value if the optional term is not empty. Returns an expected term with the given error otherwise.

**Compilation flags:**

`static`

**Template:**

`to_expected(Error,Expected)`

**Mode and number of proofs:**

`to_expected(@term,--nonvar)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

optional

### options")

**category**

#### `options`

Options processing predicates. Options are represented by compound terms where the functor is the option name.

**Availability:**

`logtalk_load(options(loader))`

**Author:** Paulo Moura

**Version:** 1:2:0

**Date:** 2022-01-03

**Compilation flags:**

`static`

**Implements:**

`public` options_protocol

**Uses:**

list

**Remarks:**

(none)

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  option/2  option/3  valid_option/1  valid_options/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `options_protocol`

Options protocol.

**Availability:**

`logtalk_load(options(loader))`

**Author:** Paulo Moura

**Version:** 1:2:0

**Date:** 2022-01-03

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `check_option/1`

  - `check_options/1`

  - `valid_option/1`

  - `valid_options/1`

  - `default_option/1`

  - `default_options/1`

  - `option/2`

  - `option/3`

- Protected predicates

  - `merge_options/2`

  - `fix_options/2`

  - `fix_option/2`

- Private predicates

- Operators

##### Public predicates

###### `check_option/1`

Succeeds if the option is valid. Throws an error otherwise.

**Compilation flags:**

`static`

**Template:**

`check_option(Option)`

**Mode and number of proofs:**

`check_option(@term)` - `one_or_error`

**Exceptions:**

`Option` is a variable:

`instantiation_error`

`Option` is neither a variable nor a compound term:

`type_error(compound,Option)`

`Option` is a compound term but not a valid option:

`domain_error(option,Option)`

------------------------------------------------------------------------

###### `check_options/1`

Succeeds if all the options in a list are valid. Throws an error otherwise.

**Compilation flags:**

`static`

**Template:**

`check_options(Options)`

**Mode and number of proofs:**

`check_options(@term)` - `one_or_error`

**Exceptions:**

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

------------------------------------------------------------------------

###### `valid_option/1`

Succeeds if the option is valid.

**Compilation flags:**

`static`

**Template:**

`valid_option(Option)`

**Mode and number of proofs:**

`valid_option(@term)` - `zero_or_one`

------------------------------------------------------------------------

###### `valid_options/1`

Succeeds if all the options in a list are valid.

**Compilation flags:**

`static`

**Template:**

`valid_options(Options)`

**Mode and number of proofs:**

`valid_options(@term)` - `one`

------------------------------------------------------------------------

###### `default_option/1`

Enumerates, by backtracking, the default options.

**Compilation flags:**

`static`

**Template:**

`default_option(Option)`

**Mode and number of proofs:**

`default_option(?compound)` - `zero_or_more`

------------------------------------------------------------------------

###### `default_options/1`

Returns a list of the default options.

**Compilation flags:**

`static`

**Template:**

`default_options(Options)`

**Mode and number of proofs:**

`default_options(-list(compound))` - `one`

------------------------------------------------------------------------

###### `option/2`

True iff `Option` unifies with the first occurrence of the same option in the `Options` list.

**Compilation flags:**

`static`

**Template:**

`option(Option,Options)`

**Mode and number of proofs:**

`option(+compound,+list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `option/3`

True iff `Option` unifies with the first occurrence of the same option in the `Options` list or, when that is not the case, if `Option` unifies with `Default`.

**Compilation flags:**

`static`

**Template:**

`option(Option,Options,Default)`

**Mode and number of proofs:**

`option(+compound,+list(compound),+compound)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

###### `merge_options/2`

Merges the user options with the default options, returning the final list of options. Calls the `fix_options/2` predicate to preprocess the options after merging. Callers must ensure, if required, that the user options are valid.

**Compilation flags:**

`static`

**Template:**

`merge_options(UserOptions,Options)`

**Mode and number of proofs:**

`merge_options(+list(compound),-list(compound))` - `one`

------------------------------------------------------------------------

###### `fix_options/2`

Fixes a list of options, returning the list of options.

**Compilation flags:**

`static`

**Template:**

`fix_options(Options,FixedOptions)`

**Mode and number of proofs:**

`fix_options(+list(compound),-list(compound))` - `one`

------------------------------------------------------------------------

###### `fix_option/2`

Fixes an option.

**Compilation flags:**

`static`

**Template:**

`fix_option(Option,FixedOption)`

**Mode and number of proofs:**

`fix_option(+compound,-compound)` - `zero_or_one`

------------------------------------------------------------------------

##### Private predicates

(none)

##### Operators

(none)

See also

options

### os")

**object**

#### `os`

Portable operating-system access predicates.

**Availability:**

`logtalk_load(os(loader))`

**Author:** Paulo Moura

**Version:** 1:102:0

**Date:** 2025-11-15

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` osp

**Uses:**

list

**Aliases:**

`osp` `absolute_file_name/2` as `expand_path/2`

**Remarks:**

> - File path expansion: To ensure portability, all file paths are expanded before being handed to the backend Prolog system.
>
> - Exception terms: Currently, there is no standardization of the exception terms thrown by the different backend Prolog systems.
>
> - B-Prolog portability: The `wall_time/1` predicate is not supported.
>
> - CxProlog portability: The `date_time/7` predicate returns zeros for all arguments.
>
> - JIProlog portability: The `file_permission/2` and `command_line_arguments/1` predicates are not supported.
>
> - Quintus Prolog: The `pid/1` and `shell/2` predicates are not supported.
>
> - XSB portability: The `command_line_arguments/1` predicate is not supported.

**Inherited public predicates:**

 absolute_file_name/2  change_directory/1  command_line_arguments/1  copy_file/2  cpu_time/1  date_time/7  decompose_file_name/3  decompose_file_name/4  delete_directory/1  delete_directory_and_contents/1  delete_directory_contents/1  delete_file/1  directory_exists/1  directory_files/2  directory_files/3  ensure_directory/1  ensure_file/1  environment_variable/2  file_exists/1  file_modification_time/2  file_permission/2  file_size/2  full_device_path/1  internal_os_path/2  is_absolute_file_name/1  make_directory/1  make_directory_path/1  null_device_path/1  operating_system_machine/1  operating_system_name/1  operating_system_release/1  operating_system_type/1  path_concat/3  pid/1  read_only_device_path/1  rename_file/2  shell/1  shell/2  sleep/1  temporary_directory/1  time_stamp/1  wall_time/1  working_directory/1

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

os_types

**category**

#### `os_types`

A set of operating-system related types.

**Availability:**

`logtalk_load(os(loader))`

**Author:** Paulo Moura

**Version:** 1:4:0

**Date:** 2021-02-12

**Compilation flags:**

`static`

**Provides:**

type::type/1

type::check/2

**Uses:**

list

os

**Remarks:**

> - Provided types: This category adds `file`, `file(Extensions)`, `file(Extensions,Permissions)`, `directory`, `directory(Permissions)`, and `environment_variable` types for type-checking when using the `type` library object.
>
> - Type `file`: For checking if a term is an atom and an existing file.
>
> - Type `file(Extensions)`: For checking if a term is an atom and an existing file with one of the listed extensions (specified as `'.ext'`).
>
> - Type `file(Extensions,Permissions)`: For checking if a term is an atom and an existing file with one of the listed extensions (specified as `'.ext'`) and listed permissions ({`read`, `write`, `execute`}).
>
> - Type `directory`: For checking if a term is an atom and an existing directory.
>
> - Type `directory(Permissions)`: For checking if a term is an atom and an existing directory with the listed permissions ({`read`, `write`, `execute`}).
>
> - Type `environment_variable`: For checking if a term is an atom and an existing environment variable.

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

osp, os, type

**protocol**

#### `osp`

Portable operating-system access protocol.

**Availability:**

`logtalk_load(os(loader))`

**Author:** Paulo Moura

**Version:** 1:41:0

**Date:** 2025-05-19

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

> - Error handling: Predicates that require a file or directory to exist throw an error when that is not the case. But the exact exception term is currently backend Prolog compiler dependent.
>
> - CPU and wall time accuracy: Depends on the backend and can be different between CPU and wall time (e.g. CPU time can have nanosecond accuracy with wall time only having millisecond accuracy).

**Inherited public predicates:**

(none)

- Public predicates

  - `pid/1`

  - `shell/2`

  - `shell/1`

  - `is_absolute_file_name/1`

  - `absolute_file_name/2`

  - `decompose_file_name/3`

  - `decompose_file_name/4`

  - `path_concat/3`

  - `internal_os_path/2`

  - `make_directory/1`

  - `make_directory_path/1`

  - `delete_directory/1`

  - `delete_directory_contents/1`

  - `delete_directory_and_contents/1`

  - `change_directory/1`

  - `working_directory/1`

  - `temporary_directory/1`

  - `null_device_path/1`

  - `full_device_path/1`

  - `read_only_device_path/1`

  - `directory_files/2`

  - `directory_files/3`

  - `directory_exists/1`

  - `ensure_directory/1`

  - `file_exists/1`

  - `file_modification_time/2`

  - `file_size/2`

  - `file_permission/2`

  - `copy_file/2`

  - `rename_file/2`

  - `delete_file/1`

  - `ensure_file/1`

  - `environment_variable/2`

  - `time_stamp/1`

  - `date_time/7`

  - `cpu_time/1`

  - `wall_time/1`

  - `operating_system_type/1`

  - `operating_system_name/1`

  - `operating_system_machine/1`

  - `operating_system_release/1`

  - `command_line_arguments/1`

  - `sleep/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `pid/1`

Returns the process identifier of the running process.

**Compilation flags:**

`static`

**Template:**

`pid(PID)`

**Mode and number of proofs:**

`pid(-integer)` - `one`

------------------------------------------------------------------------

###### `shell/2`

Runs an operating-system shell command and returns its exit status.

**Compilation flags:**

`static`

**Template:**

`shell(Command,Status)`

**Mode and number of proofs:**

`shell(+atom,-integer)` - `one`

------------------------------------------------------------------------

###### `shell/1`

Runs an operating-system shell command.

**Compilation flags:**

`static`

**Template:**

`shell(Command)`

**Mode and number of proofs:**

`shell(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `is_absolute_file_name/1`

True iff the argument is an absolute file path. On POSIX systems, this predicate is true if `File` starts with a `/`. On Windows systems, this predicate is true if `File` starts with a drive letter. No attempt is made to expand `File` as a path.

**Compilation flags:**

`static`

**Template:**

`is_absolute_file_name(File)`

**Mode and number of proofs:**

`is_absolute_file_name(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `absolute_file_name/2`

Expands a file name to an absolute file path. An environment variable at the beginning of the file name is also expanded.

**Compilation flags:**

`static`

**Template:**

`absolute_file_name(File,Path)`

**Mode and number of proofs:**

`absolute_file_name(+atom,-atom)` - `one`

------------------------------------------------------------------------

###### `decompose_file_name/3`

Decomposes a file name into its directory (which always ends with a slash; `./` is returned if absent) and its basename (which can be the empty atom).

**Compilation flags:**

`static`

**Template:**

`decompose_file_name(File,Directory,Basename)`

**Mode and number of proofs:**

`decompose_file_name(+atom,?atom,?atom)` - `one`

------------------------------------------------------------------------

###### `decompose_file_name/4`

Decomposes a file name into its directory (which always ends with a slash; `./` is returned if absent), name (that can be the empty atom), and extension (which starts with a `.` when defined; the empty atom otherwise).

**Compilation flags:**

`static`

**Template:**

`decompose_file_name(File,Directory,Name,Extension)`

**Mode and number of proofs:**

`decompose_file_name(+atom,?atom,?atom,?atom)` - `one`

------------------------------------------------------------------------

###### `path_concat/3`

Concatenates a path prefix and a path suffix, adding a `/` separator if required. Returns `Suffix` when it is an absolute path. Returns `Prefix` with a trailing `/` appended if missing when `Suffix` is the empty atom.

**Compilation flags:**

`static`

**Template:**

`path_concat(Prefix,Suffix,Path)`

**Mode and number of proofs:**

`path_concat(+atom,+atom,--atom)` - `one`

------------------------------------------------------------------------

###### `internal_os_path/2`

Converts between the internal path representation (which is backend dependent) and the operating-system native path representation.

**Compilation flags:**

`static`

**Template:**

`internal_os_path(InternalPath,OSPath)`

**Mode and number of proofs:**

`internal_os_path(+atom,-atom)` - `one`

`internal_os_path(-atom,+atom)` - `one`

------------------------------------------------------------------------

###### `make_directory/1`

Makes a new directory. Succeeds if the directory already exists.

**Compilation flags:**

`static`

**Template:**

`make_directory(Directory)`

**Mode and number of proofs:**

`make_directory(+atom)` - `one`

------------------------------------------------------------------------

###### `make_directory_path/1`

Makes a new directory creating all the intermediate directories if necessary. Succeeds if the directory already exists.

**Compilation flags:**

`static`

**Template:**

`make_directory_path(Directory)`

**Mode and number of proofs:**

`make_directory_path(+atom)` - `one`

------------------------------------------------------------------------

###### `delete_directory/1`

Deletes an empty directory. Throws an error if the directory does not exist.

**Compilation flags:**

`static`

**Template:**

`delete_directory(Directory)`

**Mode and number of proofs:**

`delete_directory(+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `delete_directory_contents/1`

Deletes directory contents. Throws an error if the directory does not exist.

**Compilation flags:**

`static`

**Template:**

`delete_directory_contents(Directory)`

**Mode and number of proofs:**

`delete_directory_contents(+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `delete_directory_and_contents/1`

Deletes directory and its contents. Throws an error if the directory does not exist.

**Compilation flags:**

`static`

**Template:**

`delete_directory_and_contents(Directory)`

**Mode and number of proofs:**

`delete_directory_and_contents(+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `change_directory/1`

Changes current working directory. Throws an error if the directory does not exist.

**Compilation flags:**

`static`

**Template:**

`change_directory(Directory)`

**Mode and number of proofs:**

`change_directory(+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `working_directory/1`

Current working directory.

**Compilation flags:**

`static`

**Template:**

`working_directory(Directory)`

**Mode and number of proofs:**

`working_directory(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `temporary_directory/1`

Temporary directory. Tries first environment variables: `TEMP` and `TMP` on Windows systems; `TMPDIR`, `TMP`, `TEMP`, and `TEMPDIR` on POSIX systems. When not defined, tries default locations. Returns the working directory as last resort.

**Compilation flags:**

`static`

**Template:**

`temporary_directory(Directory)`

**Mode and number of proofs:**

`temporary_directory(?atom)` - `one`

------------------------------------------------------------------------

###### `null_device_path/1`

Null device path: `nul` on Windows systems and `/dev/null` on POSIX systems.

**Compilation flags:**

`static`

**Template:**

`null_device_path(Path)`

**Mode and number of proofs:**

`null_device_path(?atom)` - `one`

------------------------------------------------------------------------

###### `full_device_path/1`

Full device path: `/dev/full` on Linux and BSD systems. Fails on other systems. Experimental.

**Compilation flags:**

`static`

**Template:**

`full_device_path(Path)`

**Mode and number of proofs:**

`full_device_path(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `read_only_device_path/1`

Read-only device path: `/dev/urandom` on macOS. Fails on other systems. Experimental.

**Compilation flags:**

`static`

**Template:**

`read_only_device_path(Path)`

**Mode and number of proofs:**

`read_only_device_path(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `directory_files/2`

Returns a list of all files (including directories, regular files, and hidden directories and files) in a directory. File paths are relative to the directory. Throws an error if the directory does not exist.

**Compilation flags:**

`static`

**Template:**

`directory_files(Directory,Files)`

**Mode and number of proofs:**

`directory_files(+atom,-list(atom))` - `one_or_error`

------------------------------------------------------------------------

###### `directory_files/3`

Returns a list of files filtered using the given list of options. Invalid options are ignored. Default option values are equivalent to `directory_files/2`. Throws an error if the directory does not exist.

**Compilation flags:**

`static`

**Template:**

`directory_files(Directory,Files,Options)`

**Mode and number of proofs:**

`directory_files(+atom,-list(atom),+list(compound))` - `one_or_error`

**Remarks:**

> - Option `paths/1`: Possible values are `relative` and `absolute`. Default is `relative`.
>
> - Option `type/1`: Possible values are `all`, `regular`, `directory`. Default is `all`.
>
> - Option `extensions/1`: Argument is a list of required extensions (using the format `'.ext'`). Default is the empty list.
>
> - Option `prefixes/1`: Argument is a list of required file prefixes (atoms). Default is the empty list.
>
> - Option `suffixes/1`: Argument is a list of required file suffixes (atoms). Default is the empty list.
>
> - Option `dot_files/1`: Possible values are `true` and `false`. Default is `true`.

------------------------------------------------------------------------

###### `directory_exists/1`

True if the specified directory exists (irrespective of directory permissions).

**Compilation flags:**

`static`

**Template:**

`directory_exists(Directory)`

**Mode and number of proofs:**

`directory_exists(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `ensure_directory/1`

Ensures that a directory exists, creating it if necessary.

**Compilation flags:**

`static`

**Template:**

`ensure_directory(Directory)`

**Mode and number of proofs:**

`ensure_directory(+atom)` - `one`

------------------------------------------------------------------------

###### `file_exists/1`

True if the specified file exists and is a regular file (irrespective of file permissions).

**Compilation flags:**

`static`

**Template:**

`file_exists(File)`

**Mode and number of proofs:**

`file_exists(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `file_modification_time/2`

File modification time (which can be used for comparison). Throws an error if the file does not exist.

**Compilation flags:**

`static`

**Template:**

`file_modification_time(File,Time)`

**Mode and number of proofs:**

`file_modification_time(+atom,-integer)` - `one_or_error`

------------------------------------------------------------------------

###### `file_size/2`

File size (in bytes). Throws an error if the file does not exist.

**Compilation flags:**

`static`

**Template:**

`file_size(File,Size)`

**Mode and number of proofs:**

`file_size(+atom,-integer)` - `one_or_error`

------------------------------------------------------------------------

###### `file_permission/2`

True iff the specified file has the specified permission (`read`, `write`, or `execute`). Throws an error if the file does not exist.

**Compilation flags:**

`static`

**Template:**

`file_permission(File,Permission)`

**Mode and number of proofs:**

`file_permission(+atom,+atom)` - `zero_or_one_or_error`

------------------------------------------------------------------------

###### `copy_file/2`

Copies a file. Throws an error if the original file does not exist or if the copy cannot be created.

**Compilation flags:**

`static`

**Template:**

`copy_file(File,Copy)`

**Mode and number of proofs:**

`copy_file(+atom,+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `rename_file/2`

Renames a file or a directory. Throws an error if the file or directory does not exist.

**Compilation flags:**

`static`

**Template:**

`rename_file(Old,New)`

**Mode and number of proofs:**

`rename_file(+atom,+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `delete_file/1`

Deletes a file. Throws an error if the file does not exist.

**Compilation flags:**

`static`

**Template:**

`delete_file(File)`

**Mode and number of proofs:**

`delete_file(+atom)` - `one_or_error`

------------------------------------------------------------------------

###### `ensure_file/1`

Ensures that a file exists, creating it if necessary.

**Compilation flags:**

`static`

**Template:**

`ensure_file(File)`

**Mode and number of proofs:**

`ensure_file(+atom)` - `one`

------------------------------------------------------------------------

###### `environment_variable/2`

Returns an environment variable value. Fails if the variable does not exists.

**Compilation flags:**

`static`

**Template:**

`environment_variable(Variable,Value)`

**Mode and number of proofs:**

`environment_variable(+atom,?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `time_stamp/1`

Returns a system-dependent time stamp, which can be used for sorting, but should be regarded otherwise as an opaque term.

**Compilation flags:**

`static`

**Template:**

`time_stamp(Time)`

**Mode and number of proofs:**

`time_stamp(-ground)` - `one`

------------------------------------------------------------------------

###### `date_time/7`

Returns the current date and time. Note that most backends do not provide sub-second accuracy and in those cases the value of the `Milliseconds` argument is always zero.

**Compilation flags:**

`static`

**Template:**

`date_time(Year,Month,Day,Hours,Minutes,Seconds,Milliseconds)`

**Mode and number of proofs:**

`date_time(-integer,-integer,-integer,-integer,-integer,-integer,-integer)` - `one`

------------------------------------------------------------------------

###### `cpu_time/1`

System cpu time in seconds. Accuracy depends on the backend.

**Compilation flags:**

`static`

**Template:**

`cpu_time(Seconds)`

**Mode and number of proofs:**

`cpu_time(-number)` - `one`

------------------------------------------------------------------------

###### `wall_time/1`

Wall time in seconds. Accuracy depends on the backend.

**Compilation flags:**

`static`

**Template:**

`wall_time(Seconds)`

**Mode and number of proofs:**

`wall_time(-number)` - `one`

------------------------------------------------------------------------

###### `operating_system_type/1`

Operating system type. Possible values are `unix`, `windows`, and `unknown`.

**Compilation flags:**

`static`

**Template:**

`operating_system_type(Type)`

**Mode and number of proofs:**

`operating_system_type(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `operating_system_name/1`

Operating system name. On POSIX systems, it returns the value of `uname`` ``-s`. On macOS systems, it returns `'Darwin'`. On Windows systems, it returns `'Windows'`.

**Compilation flags:**

`static`

**Template:**

`operating_system_name(Name)`

**Mode and number of proofs:**

`operating_system_name(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `operating_system_machine/1`

Operating system hardware platform. On POSIX systems, it returns the value of `uname`` ``-m`. On Windows systems, it returns the value of the `PROCESSOR_ARCHITECTURE` environment variable.

**Compilation flags:**

`static`

**Template:**

`operating_system_machine(Machine)`

**Mode and number of proofs:**

`operating_system_machine(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `operating_system_release/1`

Operating system release. On POSIX systems, it returns the value of `uname`` ``-r`. On Windows systems, it uses `WMI` code.

**Compilation flags:**

`static`

**Template:**

`operating_system_release(Release)`

**Mode and number of proofs:**

`operating_system_release(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `command_line_arguments/1`

Returns a list with the command line arguments that occur after `--`.

**Compilation flags:**

`static`

**Template:**

`command_line_arguments(Arguments)`

**Mode and number of proofs:**

`command_line_arguments(-list(atom))` - `one`

------------------------------------------------------------------------

###### `sleep/1`

Suspends execution the given number of seconds.

**Compilation flags:**

`static`

**Template:**

`sleep(Seconds)`

**Mode and number of proofs:**

`sleep(+number)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

os, os_types

### packs")

**protocol**

#### `pack_protocol`

Pack specification protocol. Objects implementing this protocol should be named after the pack with a `_pack` suffix and saved in a file with the same name as the object.

**Availability:**

`logtalk_load(packs(loader))`

**Author:** Paulo Moura

**Version:** 0:18:0

**Date:** 2025-05-21

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `name/1`

  - `description/1`

  - `license/1`

  - `home/1`

  - `version/6`

  - `note/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `name/1`

Pack name.

**Compilation flags:**

`static`

**Template:**

`name(Name)`

**Mode and number of proofs:**

`name(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `description/1`

Pack one line description.

**Compilation flags:**

`static`

**Template:**

`description(Description)`

**Mode and number of proofs:**

`description(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `license/1`

Pack license. Specified using the identifier from the SPDX License List (https://spdx.org/licenses/) when possible.

**Compilation flags:**

`static`

**Template:**

`license(License)`

**Mode and number of proofs:**

`license(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `home/1`

Pack home HTTPS or file URL.

**Compilation flags:**

`static`

**Template:**

`home(Home)`

**Mode and number of proofs:**

`home(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `version/6`

Table of available versions.

**Compilation flags:**

`static`

**Template:**

`version(Version,Status,URL,Checksum,Dependencies,Portability)`

**Mode and number of proofs:**

`version(?compound,?atom,-atom,-pair(atom,atom),-list(pair(atom,callable)),?atom)` - `zero_or_more`

`version(?compound,?atom,-atom,-pair(atom,atom),-list(pair(atom,callable)),-list(atom))` - `zero_or_more`

**Remarks:**

> - Version: This argument uses the same format as entity versions: `Major:Minor:Patch`. Semantic versioning should be used.
>
> - Status: Version development status: `stable`, `rc`, `beta`, `alpha`, `experimental`, or `deprecated`.
>
> - URL: File URL for a local directory, file URL for a local archive, download HTTPS URL for the pack archive, or download git archive URL for the pack archive.
>
> - Checksum: A pair where the key is the hash algorithm and the value is the checksum. Currently, the hash algorithm must be `sha256`. For `file://` URLs of local directories, use `none` instead of a pair.
>
> - Dependencies: Pack dependencies list. Each dependency is a `Dependency`` ``Operator`` ``Version` term. `Operator` is a term comparison operator. Valid `Dependency` values are `Registry::Pack`, `os(Name,Machine)`, `logtalk`, and a backend identifier atom.
>
> - Portability: Either the atom `all` or a list of the supported backend Prolog compilers (using the identifier atoms used by the `prolog_dialect` flag).
>
> - Clause order: Versions must be listed ordered from newest to oldest.

------------------------------------------------------------------------

###### `note/3`

Table of notes per action and version.

**Compilation flags:**

`static`

**Template:**

`note(Action,Version,Note)`

**Mode and number of proofs:**

`note(?atom,?term,-atom)` - `zero_or_more`

**Remarks:**

> - Action: Possible values are `install`, `update`, and `uninstall`. When unbound, the note apply to all actions.
>
> - Version: Version being installed, updated, or uninstalled. When unbound, the note apply to all versions.
>
> - Note: Note to print when performing an action on a pack version.

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

**object**

#### `packs`

Pack handling predicates.

**Availability:**

`logtalk_load(packs(loader))`

**Author:** Paulo Moura

**Version:** 0:87:1

**Date:** 2025-08-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` packs_common

`public` options

**Uses:**

list

logtalk

os

registries

type

user

**Remarks:**

(none)

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  help/0  logtalk_packs/0  logtalk_packs/1  option/2  option/3  pin/0  pin/1  pinned/1  prefix/0  prefix/1  readme/1  readme/2  reset/0  setup/0  unpin/0  unpin/1  valid_option/1  valid_options/1  verify_commands_availability/0

- Public predicates

  - `available/2`

  - `available/1`

  - `available/0`

  - `installed/4`

  - `installed/3`

  - `installed/1`

  - `installed/0`

  - `outdated/5`

  - `outdated/4`

  - `outdated/2`

  - `outdated/1`

  - `outdated/0`

  - `orphaned/2`

  - `orphaned/0`

  - `versions/3`

  - `describe/2`

  - `describe/1`

  - `search/1`

  - `install/4`

  - `install/3`

  - `install/2`

  - `install/1`

  - `update/3`

  - `update/2`

  - `update/1`

  - `update/0`

  - `uninstall/2`

  - `uninstall/1`

  - `uninstall/0`

  - `clean/2`

  - `clean/1`

  - `clean/0`

  - `save/2`

  - `save/1`

  - `restore/2`

  - `restore/1`

  - `dependents/3`

  - `dependents/2`

  - `dependents/1`

  - `lint/2`

  - `lint/1`

  - `lint/0`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `available/2`

Enumerates, by backtracking, all available packs.

**Compilation flags:**

`static`

**Template:**

`available(Registry,Pack)`

**Mode and number of proofs:**

`available(?atom,?atom)` - `zero_or_more`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `available/1`

Lists all the packs that are available for installation from the given registry.

**Compilation flags:**

`static`

**Template:**

`available(Registry)`

**Mode and number of proofs:**

`available(+atom)` - `one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

------------------------------------------------------------------------

###### `available/0`

Lists all the packs that are available for installation from all defined registries.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`available` - `one`

------------------------------------------------------------------------

###### `installed/4`

Enumerates by backtracking all installed packs.

**Compilation flags:**

`static`

**Template:**

`installed(Registry,Pack,Version,Pinned)`

**Mode and number of proofs:**

`installed(?atom,?atom,?compound,?boolean)` - `zero_or_more`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

`Version` is neither a variable nor a compound term:

`type_error(compound,Version)`

`Pinned` is neither a variable nor a boolean:

`type_error(boolean,Pinned)`

------------------------------------------------------------------------

###### `installed/3`

Enumerates by backtracking all installed packs.

**Compilation flags:**

`static`

**Template:**

`installed(Registry,Pack,Version)`

**Mode and number of proofs:**

`installed(?atom,?atom,?compound)` - `zero_or_more`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

`Version` is neither a variable nor a compound term:

`type_error(compound,Version)`

------------------------------------------------------------------------

###### `installed/1`

Lists all the packs that are installed from the given registry. Fails if the registry is unknown.

**Compilation flags:**

`static`

**Template:**

`installed(Registry)`

**Mode and number of proofs:**

`installed(+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

------------------------------------------------------------------------

###### `installed/0`

Lists all the packs that are installed.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`installed` - `one`

------------------------------------------------------------------------

###### `outdated/5`

Enumerates by backtracking all installed but outdated packs (together with the current version installed and the latest version available) using the given options.

**Compilation flags:**

`static`

**Template:**

`outdated(Registry,Pack,Version,LatestVersion,Options)`

**Mode and number of proofs:**

`outdated(?atom,?atom,?compound,?compound,++list(compound))` - `zero_or_more`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

`Version` is neither a variable nor a compound term:

`type_error(compound,Version)`

`LatestVersion` is neither a variable nor a compound term:

`type_error(compound,LatestVersion)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - `compatible(Boolean)` option: Restrict listing to compatible packs. Default is `true`.
>
> - `status(Status)` option: Restrict listing to updates with the given status. Default is `[stable,rc,beta,alpha]`. Set to `all` to also list `experimental` and `deprecated` updates.

------------------------------------------------------------------------

###### `outdated/4`

Enumerates by backtracking all installed but outdated packs (together with the current version installed and the latest version available) using default options.

**Compilation flags:**

`static`

**Template:**

`outdated(Registry,Pack,Version,LatestVersion)`

**Mode and number of proofs:**

`outdated(?atom,?atom,?compound,?compound)` - `zero_or_more`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

`Version` is neither a variable nor a compound term:

`type_error(compound,Version)`

`LatestVersion` is neither a variable nor a compound term:

`type_error(compound,LatestVersion)`

**See also:**

outdated/5

------------------------------------------------------------------------

###### `outdated/2`

Lists all the packs from the given registry that are installed but outdated using the given options.

**Compilation flags:**

`static`

**Template:**

`outdated(Registry,Options)`

**Mode and number of proofs:**

`outdated(+atom,++list(compound))` - `one`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - `compatible(Boolean)` option: Restrict installation to compatible packs. Default is `true`.
>
> - `status(Status)` option: Restrict listing to updates with the given status. Default is `[stable,rc,beta,alpha]`. Set to `all` to also list `experimental` and `deprecated` updates.

------------------------------------------------------------------------

###### `outdated/1`

Lists all the packs from the given registry that are installed but outdated using default options.

**Compilation flags:**

`static`

**Template:**

`outdated(Registry)`

**Mode and number of proofs:**

`outdated(+atom)` - `one`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

**See also:**

outdated/2

------------------------------------------------------------------------

###### `outdated/0`

Lists all the packs that are installed but outdated using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`outdated` - `one`

**See also:**

outdated/1

------------------------------------------------------------------------

###### `orphaned/2`

Lists all the packs that are installed but whose registry is no longer defined.

**Compilation flags:**

`static`

**Template:**

`orphaned(Registry,Pack)`

**Mode and number of proofs:**

`orphaned(?atom,?atom)` - `zero_or_more`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `orphaned/0`

Lists all the packs that are installed but whose registry is no longer defined.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`orphaned` - `one`

------------------------------------------------------------------------

###### `versions/3`

Returns a list of all available pack versions. Fails if the pack is unknown.

**Compilation flags:**

`static`

**Template:**

`versions(Registry,Pack,Versions)`

**Mode and number of proofs:**

`versions(+atom,+atom,-list)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `describe/2`

Describes a registered pack, including installed version if applicable. Fails if the pack is unknown.

**Compilation flags:**

`static`

**Template:**

`describe(Registry,Pack)`

**Mode and number of proofs:**

`describe(+atom,+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `describe/1`

Describes a registered pack, including installed version if applicable. Fails if the pack is unknown.

**Compilation flags:**

`static`

**Template:**

`describe(Pack)`

**Mode and number of proofs:**

`describe(+atom)` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `search/1`

Searches packs whose name or description includes the search term (case sensitive).

**Compilation flags:**

`static`

**Template:**

`search(Term)`

**Mode and number of proofs:**

`search(+atom)` - `one`

**Exceptions:**

`Term` is a variable:

`instantiation_error`

`Term` is neither a variable nor an atom:

`type_error(atom,Term)`

------------------------------------------------------------------------

###### `install/4`

Installs a new pack using the specified options. Fails if the pack is unknown or already installed but not using `update(true)` or `force(true)` options. Fails also if the pack version is unknown.

**Compilation flags:**

`static`

**Template:**

`install(Registry,Pack,Version,Options)`

**Mode and number of proofs:**

`install(+atom,+atom,++compound,++list(compound))` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

`Version` is a variable:

`instantiation_error`

`Version` is neither a variable nor a valid version:

`type_error(pack_version,Version)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - `update(Boolean)` option: Update pack if already installed. Default is `false`. Overrides the `force/1` option.
>
> - `force(Boolean)` option: Force pack re-installation if already installed. Default is `false`.
>
> - `compatible(Boolean)` option: Restrict installation to compatible packs. Default is `true`.
>
> - `clean(Boolean)` option: Clean pack archive after installation. Default is `false`.
>
> - `verbose(Boolean)` option: Verbose installing steps. Default is `false`.
>
> - `checksum(Boolean)` option: Verify pack archive checksum. Default is `true`.
>
> - `checksig(Boolean)` option: Verify pack archive signature. Default is `false`.
>
> - `git(Atom)` option: Extra command-line options. Default is `''`.
>
> - `downloader(Atom)` option: Downloader utility. Either `curl` or `wget`. Default is `curl`.
>
> - `curl(Atom)` option: Extra command-line options. Default is `''`.
>
> - `wget(Atom)` option: Extra command-line options. Default is `''`.
>
> - `gpg(Atom)` option: Extra command-line options. Default is `''`.
>
> - `tar(Atom)` option: Extra command-line options. Default is `''`.

------------------------------------------------------------------------

###### `install/3`

Installs the specified version of a pack from the given registry using default options. Fails if the pack is already installed or unknown. Fails also if the pack version is unknown.

**Compilation flags:**

`static`

**Template:**

`install(Registry,Pack,Version)`

**Mode and number of proofs:**

`install(+atom,+atom,?compound)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

`Version` is a variable:

`instantiation_error`

`Version` is neither a variable nor a valid version:

`type_error(pack_version,Version)`

**See also:**

install/4

------------------------------------------------------------------------

###### `install/2`

Installs the latest version of a pack from the given registry using default options. Fails if the pack is already installed or unknown.

**Compilation flags:**

`static`

**Template:**

`install(Registry,Pack)`

**Mode and number of proofs:**

`install(+atom,+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

**See also:**

install/3

------------------------------------------------------------------------

###### `install/1`

Installs a pack (if its name is unique among all registries) using default options. Fails if the pack is already installed or unknown. Fails also if the pack is available from multiple registries.

**Compilation flags:**

`static`

**Template:**

`install(Pack)`

**Mode and number of proofs:**

`install(+atom)` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is not an atom:

`type_error(atom,Pack)`

**See also:**

install/2

------------------------------------------------------------------------

###### `update/3`

Updates an outdated pack to the specified version using the specified options. Fails if the pack or the pack version is unknown or if the pack is not installed. Fails also if the pack is orphaned or pinned and not using a `force(true)` option.

**Compilation flags:**

`static`

**Template:**

`update(Pack,Version,Options)`

**Mode and number of proofs:**

`update(+atom,++callable,++list(callable))` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

`Version` is a variable:

`instantiation_error`

`Version` is neither a variable nor a valid version:

`type_error(pack_version,Version)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - `install(Boolean)` option: Install pack latest version if not already installed. Default is `false`.
>
> - `force(Boolean)` option: Force update if the pack is pinned or breaks installed packs. Default is `false`.
>
> - `compatible(Boolean)` option: Restrict updating to compatible packs. Default is `true`.
>
> - `status(Status)` option: Specify allowed pack status. Default is `[stable,rc,beta,alpha]`. Set to `all` to also allow `experimental` and `deprecated`.
>
> - `clean(Boolean)` option: Clean pack archive after updating. Default is `false`.
>
> - `verbose(Boolean)` option: Verbose updating steps. Default is `false`.
>
> - `checksum(Boolean)` option: Verify pack archive checksum. Default is `true`.
>
> - `checksig(Boolean)` option: Verify pack archive signature. Default is `false`.
>
> - `git(Atom)` option: Extra command-line options. Default is `''`.
>
> - `downloader(Atom)` option: Downloader utility. Either `curl` or `wget`. Default is `curl`.
>
> - `curl(Atom)` option: Extra command-line options. Default is `''`.
>
> - `wget(Atom)` option: Extra command-line options. Default is `''`.
>
> - `gpg(Atom)` option: Extra command-line options. Default is `''`.
>
> - `tar(Atom)` option: Extra command-line options. Default is `''`.

------------------------------------------------------------------------

###### `update/2`

Updates an outdated pack to its latest version using the specified options. Fails if the pack is orphaned, unknown, or not installed. Fails also if the pack is pinned and not using a `force(true)` option.

**Compilation flags:**

`static`

**Template:**

`update(Pack,Options)`

**Mode and number of proofs:**

`update(+atom,++list(callable))` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - `install(Boolean)` option: Install pack latest version if not already installed. Default is `false`.
>
> - `force(Boolean)` option: Force update if the pack is pinned or breaks installed packs. Default is `false`.
>
> - `compatible(Boolean)` option: Restrict updating to compatible packs. Default is `true`.
>
> - `status(Status)` option: Specify allowed pack update status. Default is `[stable,rc,beta,alpha]`. Set to `all` to also allow `experimental` and `deprecated`.
>
> - `clean(Boolean)` option: Clean pack archive after updating. Default is `false`.
>
> - `verbose(Boolean)` option: Verbose updating steps. Default is `false`.
>
> - `checksum(Boolean)` option: Verify pack archive checksum. Default is `true`.
>
> - `checksig(Boolean)` option: Verify pack archive signature. Default is `false`.
>
> - `git(Atom)` option: Extra command-line options. Default is `''`.
>
> - `downloader(Atom)` option: Downloader utility. Either `curl` or `wget`. Default is `curl`.
>
> - `curl(Atom)` option: Extra command-line options. Default is `''`.
>
> - `wget(Atom)` option: Extra command-line options. Default is `''`.
>
> - `gpg(Atom)` option: Extra command-line options. Default is `''`.
>
> - `tar(Atom)` option: Extra command-line options. Default is `''`.

------------------------------------------------------------------------

###### `update/1`

Updates an outdated pack to its latest version using default options. Fails if the pack is pinned, orphaned, not installed, unknown, or breaks installed packs.

**Compilation flags:**

`static`

**Template:**

`update(Pack)`

**Mode and number of proofs:**

`update(+atom)` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

**See also:**

update/2

update/3

------------------------------------------------------------------------

###### `update/0`

Updates all outdated packs (that are not pinned) using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`update` - `zero_or_one`

------------------------------------------------------------------------

###### `uninstall/2`

Uninstalls a pack using the specified options. Fails if the pack is unknown or not installed. Fails also if the pack is pinned or have dependents and not using a `force(true)` option.

**Compilation flags:**

`static`

**Template:**

`uninstall(Pack,Options)`

**Mode and number of proofs:**

`uninstall(+atom,++list(compound))` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - `force(Boolean)` option: Force deletion if the pack is pinned. Default is `false`.
>
> - `clean(Boolean)` option: Clean pack archive after deleting. Default is `false`.
>
> - `verbose(Boolean)` option: Verbose uninstalling steps. Default is `false`.

------------------------------------------------------------------------

###### `uninstall/1`

Uninstalls a pack using default options. Fails if the pack is pinned, have dependents, not installed, or unknown.

**Compilation flags:**

`static`

**Template:**

`uninstall(Pack)`

**Mode and number of proofs:**

`uninstall(+atom)` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

**See also:**

uninstall/2

------------------------------------------------------------------------

###### `uninstall/0`

Uninstalls all packs using the `force(true)` option.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`uninstall` - `zero_or_one`

------------------------------------------------------------------------

###### `clean/2`

Cleans all pack archives. Fails if the the pack is unknown.

**Compilation flags:**

`static`

**Template:**

`clean(Registry,Pack)`

**Mode and number of proofs:**

`clean(+atom,+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `clean/1`

Cleans all pack archives. Fails if the pack is unknown.

**Compilation flags:**

`static`

**Template:**

`clean(Pack)`

**Mode and number of proofs:**

`clean(+atom)` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

**See also:**

clean/2

------------------------------------------------------------------------

###### `clean/0`

Cleans all archives for all packs.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`clean` - `one`

------------------------------------------------------------------------

###### `save/2`

Saves a list of all installed packs and registries plus pinning status to a file using the given options. Registries without installed packs are saved when using the option `save(all)` and skipped when using the option `save(installed)` (default).

**Compilation flags:**

`static`

**Template:**

`save(File,Options)`

**Mode and number of proofs:**

`save(+atom,++list(compound))` - `one_or_error`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an existing file but cannot be written:

`permission_error(open,source_sink,File)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

------------------------------------------------------------------------

###### `save/1`

Saves a list of all installed packs and their registries plus pinning status to a file using default options.

**Compilation flags:**

`static`

**Template:**

`save(File)`

**Mode and number of proofs:**

`save(+atom)` - `one_or_error`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an existing file but cannot be written:

`permission_error(open,source_sink,File)`

**See also:**

save/2

------------------------------------------------------------------------

###### `restore/2`

Restores a list of registries and packs plus their pinning status from a file using the given options. Fails if restoring is not possible.

**Compilation flags:**

`static`

**Template:**

`restore(File,Options)`

**Mode and number of proofs:**

`restore(+atom,++list(compound))` - `zero_or_one_or_error`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an atom but not an existing file:

`existence_error(file,File)`

`File` is an existing file but cannot be read:

`permission_error(open,source_sink,File)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - `force(Boolean)` option: Force restoring if a registry is already defined or a pack is already installed. Default is `true`.
>
> - `compatible(Boolean)` option: Restrict installation to compatible packs. Default is `true`.
>
> - `clean(Boolean)` option: Clean registry and pack archives after restoring. Default is `false`.
>
> - `verbose(Boolean)` option: Verbose restoring steps. Default is `false`.
>
> - `checksum(Boolean)` option: Verify pack archive checksums. Default is `true`.
>
> - `checksig(Boolean)` option: Verify pack archive signatures. Default is `false`.
>
> - `git(Atom)` option: Extra command-line options. Default is `''`.
>
> - `downloader(Atom)` option: Downloader utility. Either `curl` or `wget`. Default is `curl`.
>
> - `curl(Atom)` option: Extra command-line options. Default is `''`.
>
> - `wget(Atom)` option: Extra command-line options. Default is `''`.
>
> - `gpg(Atom)` option: Extra command-line options. Default is `''`.
>
> - `tar(Atom)` option: Extra command-line options. Default is `''`.

------------------------------------------------------------------------

###### `restore/1`

Restores a list of registries and packs plus their pinning status from a file using default options. Fails if restoring is not possible.

**Compilation flags:**

`static`

**Template:**

`restore(File)`

**Mode and number of proofs:**

`restore(+atom)` - `zero_or_one_or_error`

**Exceptions:**

`File` is a variable:

`instantiation_error`

`File` is neither a variable nor an atom:

`type_error(atom,File)`

`File` is an atom but not an existing file:

`existence_error(file,File)`

`File` is an existing file but cannot be read:

`permission_error(open,source_sink,File)`

**See also:**

restore/2

------------------------------------------------------------------------

###### `dependents/3`

Returns a list of all installed packs that depend on the given pack from the given registry. Fails if the pack is unknown.

**Compilation flags:**

`static`

**Template:**

`dependents(Registry,Pack,Dependents)`

**Mode and number of proofs:**

`dependents(+atom,+atom,-list(atom))` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `dependents/2`

Prints a list of all installed packs that depend on the given pack from the given registry. Fails if the pack is unknown.

**Compilation flags:**

`static`

**Template:**

`dependents(Registry,Pack)`

**Mode and number of proofs:**

`dependents(+atom,+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `dependents/1`

Prints a list of all installed packs that depend on the given pack if unique from all defined registries. Fails if the pack is unknown or available from multiple registries.

**Compilation flags:**

`static`

**Template:**

`dependents(Pack)`

**Mode and number of proofs:**

`dependents(+atom)` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `lint/2`

Checks the pack specification. Fails if the pack is unknown or if linting detects errors.

**Compilation flags:**

`static`

**Template:**

`lint(Registry,Pack)`

**Mode and number of proofs:**

`lint(+atom,+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `lint/1`

Checks the pack specification. Fails if the pack is unknown, or available from multiple registries, or if linting detects errors.

**Compilation flags:**

`static`

**Template:**

`lint(Pack)`

**Mode and number of proofs:**

`lint(+atom)` - `zero_or_one`

**Exceptions:**

`Pack` is a variable:

`instantiation_error`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `lint/0`

Checks all pack specifications.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`lint` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `packs_common`

Common predicates for the packs tool objects.

**Availability:**

`logtalk_load(packs(loader))`

**Author:** Paulo Moura

**Version:** 0:33:0

**Date:** 2025-01-23

**Compilation flags:**

`static`

**Provides:**

type::type/1

type::check/2

**Uses:**

list

logtalk

os

type

user

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `setup/0`

  - `reset/0`

  - `verify_commands_availability/0`

  - `help/0`

  - `pin/1`

  - `pin/0`

  - `unpin/1`

  - `unpin/0`

  - `pinned/1`

  - `directory/2`

  - `directory/1`

  - `readme/2`

  - `readme/1`

  - `logtalk_packs/1`

  - `logtalk_packs/0`

  - `prefix/1`

  - `prefix/0`

- Protected predicates

  - `readme_file_path/2`

  - `print_readme_file_path/1`

  - `command/2`

  - `load_registry/1`

  - `sha256sum_command/1`

  - `tar_command/1`

  - `supported_archive/1`

  - `supported_url_archive/1`

  - `decode_url_spaces/2`

- Private predicates

- Operators

##### Public predicates

###### `setup/0`

Ensures that registries and packs directory structure exists. Preserves any defined registries and installed packs.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`setup` - `one`

------------------------------------------------------------------------

###### `reset/0`

Resets registries and packs directory structure. Deletes any defined registries and installed packs.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`reset` - `one`

------------------------------------------------------------------------

###### `verify_commands_availability/0`

Verifies required shell commands availability. Fails printing an error message if a command is missing.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`verify_commands_availability` - `zero_or_one`

------------------------------------------------------------------------

###### `help/0`

Provides help about the main predicates.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`help` - `one`

------------------------------------------------------------------------

###### `pin/1`

Pins a resource (pack or registry) preventing it from being updated, uninstalled, or deleted. Fails if the resource is not found.

**Compilation flags:**

`static`

**Template:**

`pin(Resource)`

**Mode and number of proofs:**

`pin(+atom)` - `zero_or_one`

**Exceptions:**

`Resource` is a variable:

`instantiation_error`

`Resource` is neither a variable nor an atom:

`type_error(atom,Resource)`

------------------------------------------------------------------------

###### `pin/0`

Pins all resource (packs or registries) preventing them from being updated, uninstalled, or deleted. Note that resources added after calling this predicate will not be pinned.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`pin` - `one`

------------------------------------------------------------------------

###### `unpin/1`

Unpins a resource (pack or registry), allowing it to be updated, uninstalled, or deleted. Fails if the resource is not found.

**Compilation flags:**

`static`

**Template:**

`unpin(Resource)`

**Mode and number of proofs:**

`unpin(+atom)` - `zero_or_one`

**Exceptions:**

`Resource` is a variable:

`instantiation_error`

`Resource` is neither a variable nor an atom:

`type_error(atom,Resource)`

------------------------------------------------------------------------

###### `unpin/0`

Unpins all resources (packs or registries), allowing them to be updated, uninstalled, or deleted.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`unpin` - `one`

------------------------------------------------------------------------

###### `pinned/1`

True iff the resource (pack or registry) is defined or installed and if it is pinned.

**Compilation flags:**

`static`

**Template:**

`pinned(Resource)`

**Mode and number of proofs:**

`pinned(+atom)` - `zero_or_one`

**Exceptions:**

`Resource` is a variable:

`instantiation_error`

`Resource` is neither a variable nor an atom:

`type_error(atom,Resource)`

------------------------------------------------------------------------

###### `directory/2`

Enumerates by backtracking all packs or registries and respective installation or definition directories (using the internal backend format).

**Compilation flags:**

`static`

**Template:**

`directory(Resource,Directory)`

**Mode and number of proofs:**

`directory(?atom,?atom)` - `zero_or_more`

**Exceptions:**

`Resource` is neither a variable nor an atom:

`type_error(atom,Resource)`

`Directory` is neither a variable nor an atom:

`type_error(atom,Directory)`

------------------------------------------------------------------------

###### `directory/1`

Prints the directory where the registry or the pack is installed (using the native operating-system format).

**Compilation flags:**

`static`

**Template:**

`directory(Resource)`

**Mode and number of proofs:**

`directory(+atom)` - `zero_or_one`

**Exceptions:**

`Resource` is a variable:

`instantiation_error`

`Resource` is neither a variable nor an atom:

`type_error(atom,Resource)`

------------------------------------------------------------------------

###### `readme/2`

Returns the path to the resource (pack or registry) readme file (using the internal backend format). Fails if the resource is not defined or installed or if no readme file is found for it.

**Compilation flags:**

`static`

**Template:**

`readme(Resource,ReadMeFile)`

**Mode and number of proofs:**

`readme(+atom,-atom)` - `zero_or_one`

**Exceptions:**

`Resource` is a variable:

`instantiation_error`

`Resource` is neither a variable nor an atom:

`type_error(atom,Resource)`

`ReadMeFile` is neither a variable nor an atom:

`type_error(atom,ReadMeFile)`

------------------------------------------------------------------------

###### `readme/1`

Prints the path to the resource (pack or registry) readme file (using the native operating-system format). Fails if the resource is not defined or installed or if no readme file is found for it.

**Compilation flags:**

`static`

**Template:**

`readme(Resource)`

**Mode and number of proofs:**

`readme(+atom)` - `zero_or_one`

**Exceptions:**

`Resource` is a variable:

`instantiation_error`

`Resource` is neither a variable nor an atom:

`type_error(atom,Resource)`

------------------------------------------------------------------------

###### `logtalk_packs/1`

Returns the directory prefix (using the internal backend format) where the registries, packs, and archives are installed.

**Compilation flags:**

`static`

**Template:**

`logtalk_packs(LogtalkPacks)`

**Mode and number of proofs:**

`logtalk_packs(-atom)` - `one`

**Exceptions:**

`LogtalkPacks` is neither a variable nor an atom:

`type_error(atom,LogtalkPacks)`

------------------------------------------------------------------------

###### `logtalk_packs/0`

Prints the directory prefix (using the native operating-system format) where the registries, packs, and archives are installed.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`logtalk_packs` - `one`

------------------------------------------------------------------------

###### `prefix/1`

Returns the directory prefix (using the internal backend format) where the registries or packs are installed.

**Compilation flags:**

`static`

**Template:**

`prefix(Prefix)`

**Mode and number of proofs:**

`prefix(-atom)` - `one`

**Exceptions:**

`Prefix` is neither a variable nor an atom:

`type_error(atom,Prefix)`

------------------------------------------------------------------------

###### `prefix/0`

Prints the directory prefix (using the native operating-system format) where the registries or packs are installed.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`prefix` - `one`

------------------------------------------------------------------------

##### Protected predicates

###### `readme_file_path/2`

Returns the absolute path for the given directory readme file if it exists.

**Compilation flags:**

`static`

**Template:**

`readme_file_path(Directory,ReadMeFile)`

**Mode and number of proofs:**

`readme_file_path(+atom,-atom)` - `zero_or_one`

**Remarks:**

> - Valid file names: Case variations of `README` and `NOTES` with or without a `.md` or `.txt` extension. The recommended file name is `README.md`.

------------------------------------------------------------------------

###### `print_readme_file_path/1`

Prints the absolute path for the given directory readme file if it exists. Succeeds otherwise.

**Compilation flags:**

`static`

**Template:**

`print_readme_file_path(Directory)`

**Mode and number of proofs:**

`print_readme_file_path(+atom)` - `one`

------------------------------------------------------------------------

###### `command/2`

Executes a shell command. Prints an error message and fails if the command fails.

**Compilation flags:**

`static`

**Template:**

`command(Command,FailureMessage)`

**Mode and number of proofs:**

`command(+atom,@nonvar)` - `zero_or_one`

------------------------------------------------------------------------

###### `load_registry/1`

Loads all registry files from the given directory.

**Compilation flags:**

`static`

**Template:**

`load_registry(Directory)`

**Mode and number of proofs:**

`load_registry(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `sha256sum_command/1`

Returns the name of the sha256sum command to be used on POSIX systems. Fails if neither gsha256sum or sha256sum commands are found.

**Compilation flags:**

`static`

**Template:**

`sha256sum_command(Command)`

**Mode and number of proofs:**

`sha256sum_command(-atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `tar_command/1`

Returns the name of the tar command to be used depending on the operating-system.

**Compilation flags:**

`static`

**Template:**

`tar_command(Command)`

**Mode and number of proofs:**

`tar_command(-atom)` - `one`

------------------------------------------------------------------------

###### `supported_archive/1`

True iff the archive format is supported.

**Compilation flags:**

`static`

**Template:**

`supported_archive(Extension)`

**Mode and number of proofs:**

`supported_archive(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `supported_url_archive/1`

True iff the URL archive is supported.

**Compilation flags:**

`static`

**Template:**

`supported_url_archive(URL)`

**Mode and number of proofs:**

`supported_url_archive(+atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `decode_url_spaces/2`

Decodes encoded spaces (%20) in URLs to spaces.

**Compilation flags:**

`static`

**Template:**

`decode_url_spaces(URL,Decoded)`

**Mode and number of proofs:**

`decode_url_spaces(+atom,-atom)` - `one`

------------------------------------------------------------------------

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `packs_messages`

Packs default message translations.

**Availability:**

`logtalk_load(packs(loader))`

**Author:** Paulo Moura

**Version:** 0:41:0

**Date:** 2025-05-23

**Compilation flags:**

`static`

**Provides:**

logtalk::message_prefix_stream/4

logtalk::message_tokens//2

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `packs_specs_hook`

Hook object for filtering registry and pack specification file contents.

**Availability:**

`logtalk_load(packs(loader))`

**Author:** Paulo Moura

**Version:** 0:13:0

**Date:** 2022-06-28

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Uses:**

character

logtalk

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `registries`

Registry handling predicates.

**Availability:**

`logtalk_load(packs(loader))`

**Author:** Paulo Moura

**Version:** 0:62:0

**Date:** 2025-08-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` packs_common

`public` options

**Uses:**

list

logtalk

os

type

user

**Remarks:**

(none)

**Inherited public predicates:**

 check_option/1  check_options/1  default_option/1  default_options/1  directory/1  directory/2  help/0  logtalk_packs/0  logtalk_packs/1  option/2  option/3  pin/0  pin/1  pinned/1  prefix/0  prefix/1  readme/1  readme/2  reset/0  setup/0  unpin/0  unpin/1  valid_option/1  valid_options/1  verify_commands_availability/0

- Public predicates

  - `list/0`

  - `describe/1`

  - `defined/4`

  - `add/3`

  - `add/2`

  - `add/1`

  - `update/2`

  - `update/1`

  - `update/0`

  - `delete/2`

  - `delete/1`

  - `delete/0`

  - `clean/1`

  - `clean/0`

  - `provides/2`

  - `lint/1`

  - `lint/0`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `list/0`

Prints a list of all defined registries, including how defined (`git`, `archive`, or `directory`) and if they are pinned.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`list` - `one`

------------------------------------------------------------------------

###### `describe/1`

Prints all registry entries.

**Compilation flags:**

`static`

**Template:**

`describe(Registry)`

**Mode and number of proofs:**

`describe(+atom)` - `one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

------------------------------------------------------------------------

###### `defined/4`

Enumerates by backtracking all defined registries, their definition URL, how they are defined (`git`, `archive`, or `directory`), and if they are pinned.

**Compilation flags:**

`static`

**Template:**

`defined(Registry,URL,HowDefined,Pinned)`

**Mode and number of proofs:**

`defined(?atom,?atom,?atom,?boolean)` - `zero_or_more`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`URL` is neither a variable nor an atom:

`type_error(atom,URL)`

`HowDefined` is neither a variable nor an atom:

`type_error(atom,HowDefined)`

`Pinned` is neither a variable nor a boolean:

`type_error(boolean,Pinned)`

------------------------------------------------------------------------

###### `add/3`

Adds a new registry using the given options. Fails if the registry cannot be added or if it is already defined but not using `update(true)` or `force(true)` options. A `file://` URL can be used for a local directory or archive.

**Compilation flags:**

`static`

**Template:**

`add(Registry,URL,Options)`

**Mode and number of proofs:**

`add(+atom,+atom,++list(compound))` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`URL` is a variable:

`instantiation_error`

`URL` is neither a variable nor an atom:

`type_error(atom,URL)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - Registry name: Must be the URL basename when using a git URL or a local directory URL. Must also be the declared registry name in the registry specification object.
>
> - HTTPS URLs: Must end with either a `.git` extension or an archive extension.
>
> - `update(Boolean)` option: Update registry if already defined. Default is `false`. Overrides the `force/1` option.
>
> - `force(Boolean)` option: Force registry re-installation if already defined by first deleting the previous installation. Default is `false`.
>
> - `clean(Boolean)` option: Clean registry archive after updating. Default is `false`.
>
> - `verbose(Boolean)` option: Verbose adding steps. Default is `false`.
>
> - `downloader(Atom)` option: Downloader utility. Either `curl` or `wget`. Default is `curl`.
>
> - `curl(Atom)` option: Extra command-line options. Default is `''`.
>
> - `wget(Atom)` option: Extra command-line options. Default is `''`.
>
> - `gpg(Atom)` option: Extra command-line options. Default is `''`.
>
> - `tar(Atom)` option: Extra command-line options. Default is `''`.

------------------------------------------------------------------------

###### `add/2`

Adds a new registry using default options. Fails if the registry cannot be added or if it is already defined. HTTPS URLs must end with either a `.git` extension or an archive extension. A `file://` URL can be used for a local directory or archive.

**Compilation flags:**

`static`

**Template:**

`add(Registry,URL)`

**Mode and number of proofs:**

`add(+atom,+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`URL` is a variable:

`instantiation_error`

`URL` is neither a variable nor an atom:

`type_error(atom,URL)`

**Remarks:**

> - Registry name: Must be the URL basename when using a git URL or a local directory URL. Must also be the declared registry name in the registry specification object.

**See also:**

add/3

------------------------------------------------------------------------

###### `add/1`

Adds a new registry using default options. Fails if the registry cannot be added or if it is already defined. HTTPS URLs must end with a `.git` extension or an archive extension. A `file://` URL can be used for a local directory or archive.

**Compilation flags:**

`static`

**Template:**

`add(URL)`

**Mode and number of proofs:**

`add(+atom)` - `zero_or_one`

**Exceptions:**

`URL` is a variable:

`instantiation_error`

`URL` is neither a variable nor an atom:

`type_error(atom,URL)`

**Remarks:**

> - Registry name: Taken from the URL basename.

**See also:**

add/2

------------------------------------------------------------------------

###### `update/2`

Updates a defined registry using the specified options. Fails if the registry is not defined.

**Compilation flags:**

`static`

**Template:**

`update(Registry,Options)`

**Mode and number of proofs:**

`update(+atom,++list(compound))` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - `force(Boolean)` option: Force update if the registry is pinned. Default is `false`.
>
> - `clean(Boolean)` option: Clean registry archive after updating. Default is `false`.
>
> - `verbose(Boolean)` option: Verbose updating steps. Default is `false`.
>
> - `downloader(Atom)` option: Downloader utility. Either `curl` or `wget`. Default is `curl`.
>
> - `curl(Atom)` option: Extra command-line options. Default is `''`.
>
> - `wget(Atom)` option: Extra command-line options. Default is `''`.
>
> - `gpg(Atom)` option: Extra command-line options. Default is `''`.
>
> - `tar(Atom)` option: Extra command-line options. Default is `''`.

------------------------------------------------------------------------

###### `update/1`

Updates a defined registry using default options. Fails if the registry is not defined.

**Compilation flags:**

`static`

**Template:**

`update(Registry)`

**Mode and number of proofs:**

`update(+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

**See also:**

update/2

------------------------------------------------------------------------

###### `update/0`

Updates all defined registries using default options.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`update` - `zero_or_one`

------------------------------------------------------------------------

###### `delete/2`

Deletes a registry using the specified options (if not pinned).

**Compilation flags:**

`static`

**Template:**

`delete(Registry,Options)`

**Mode and number of proofs:**

`delete(+atom,++list(compound))` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Options` is a variable:

`instantiation_error`

`Options` is neither a variable nor a list:

`type_error(list,Options)`

An element `Option` of the list `Options` is a variable:

`instantiation_error`

An element `Option` of the list `Options` is neither a variable nor a compound term:

`type_error(compound,Option)`

An element `Option` of the list `Options` is a compound term but not a valid option:

`domain_error(option,Option)`

**Remarks:**

> - `force(Boolean)` option: Force deletion if the registry is pinned or there are installed registry packs. Default is `false`.
>
> - `clean(Boolean)` option: Clean registry archive after deleting. Default is `false`.
>
> - `verbose(Boolean)` option: Verbose deleting steps. Default is `false`.
>
> - `downloader(Atom)` option: Downloader utility. Either `curl` or `wget`. Default is `curl`.
>
> - `curl(Atom)` option: Extra command-line options. Default is `''`.
>
> - `wget(Atom)` option: Extra command-line options. Default is `''`.
>
> - `gpg(Atom)` option: Extra command-line options. Default is `''`.
>
> - `tar(Atom)` option: Extra command-line options. Default is `''`.

------------------------------------------------------------------------

###### `delete/1`

Deletes a registry using default options.

**Compilation flags:**

`static`

**Template:**

`delete(Registry)`

**Mode and number of proofs:**

`delete(+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

**See also:**

delete/2

------------------------------------------------------------------------

###### `delete/0`

Deletes all registries using the `force(true)` option.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`delete` - `zero_or_one`

------------------------------------------------------------------------

###### `clean/1`

Cleans all registry archives. Fails if the registry is not defined.

**Compilation flags:**

`static`

**Template:**

`clean(Registry)`

**Mode and number of proofs:**

`clean(+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

------------------------------------------------------------------------

###### `clean/0`

Cleans all archives for all registries.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`clean` - `one`

------------------------------------------------------------------------

###### `provides/2`

Enumerates by backtracking all packs provided by a registry.

**Compilation flags:**

`static`

**Template:**

`provides(Registry,Pack)`

**Mode and number of proofs:**

`provides(?atom,?atom)` - `zero_or_more`

**Exceptions:**

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

`Pack` is neither a variable nor an atom:

`type_error(atom,Pack)`

------------------------------------------------------------------------

###### `lint/1`

Checks the registry specification. Fails if the registry is not defined or if linting detects errors.

**Compilation flags:**

`static`

**Template:**

`lint(Registry)`

**Mode and number of proofs:**

`lint(+atom)` - `zero_or_one`

**Exceptions:**

`Registry` is a variable:

`instantiation_error`

`Registry` is neither a variable nor an atom:

`type_error(atom,Registry)`

------------------------------------------------------------------------

###### `lint/0`

Checks all registry specifications.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`lint` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**object**

#### `registry_loader_hook`

Hook object for filtering registry loader file contents.

**Availability:**

`logtalk_load(packs(loader))`

**Author:** Paulo Moura

**Version:** 0:13:0

**Date:** 2022-11-20

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` expanding

**Uses:**

character

logtalk

**Remarks:**

(none)

**Inherited public predicates:**

 goal_expansion/2  term_expansion/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `registry_protocol`

Registry specification protocol. Objects implementing this protocol should be named after the pack with a `_registry` suffix and saved in a file with the same name as the object.

**Availability:**

`logtalk_load(packs(loader))`

**Author:** Paulo Moura

**Version:** 0:12:0

**Date:** 2022-06-28

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `name/1`

  - `description/1`

  - `home/1`

  - `clone/1`

  - `archive/1`

  - `note/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `name/1`

Registry name. Preferably a valid unquoted atom.

**Compilation flags:**

`static`

**Template:**

`name(Name)`

**Mode and number of proofs:**

`name(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `description/1`

Registry one line description.

**Compilation flags:**

`static`

**Template:**

`description(Description)`

**Mode and number of proofs:**

`description(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `home/1`

Registry home HTTPS or file URL.

**Compilation flags:**

`static`

**Template:**

`home(Home)`

**Mode and number of proofs:**

`home(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `clone/1`

Registry git clone HTTPS URL (must end with the `.git` extension). Git repos should have the same name as the registry.

**Compilation flags:**

`static`

**Template:**

`clone(URL)`

**Mode and number of proofs:**

`clone(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `archive/1`

Registry archive download HTTPS URL.

**Compilation flags:**

`static`

**Template:**

`archive(URL)`

**Mode and number of proofs:**

`archive(?atom)` - `zero_or_one`

------------------------------------------------------------------------

###### `note/2`

Table of notes per action.

**Compilation flags:**

`static`

**Template:**

`note(Action,Note)`

**Mode and number of proofs:**

`note(?atom,-atom)` - `zero_or_more`

**Remarks:**

> - Action: Possible values are `add`, `update`, and `delete`. When unbound, the note apply to all actions.
>
> - Note: Note to print when performing an action on a registry.

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### pddl_parser")

**object**

#### `pddl`

Simple parser of PDDL 3.0 files.

**Availability:**

`logtalk_load(pddl_parser(loader))`

**Author:** Robert Sasak, Charles University in Prague. Adapted to Logtalk by Paulo Moura.

**Version:** 1:2:2

**Date:** 2024-03-14

**Compilation flags:**

`static,`` ``context_switching_calls`

**Imports:**

`public` read_file

**Uses:**

user

**Remarks:**

(none)

**Inherited public predicates:**

 read_file/2

- Public predicates

  - `parse_domain/3`

  - `parse_domain/2`

  - `parse_problem/2`

  - `parse_problem/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse_domain/3`

Parses a PDDL 3.0 domain file, returning a compound term representing its contents and rest of the file. Useful when domain and problem are in one file.

**Compilation flags:**

`static`

**Template:**

`parse_domain(File,Output,RestOfFile)`

**Mode and number of proofs:**

`parse_domain(+atom,-compound,-list(atom))` - `one`

------------------------------------------------------------------------

###### `parse_domain/2`

Parses a PDDL 3.0 domain file, returning a compound term representing its contents.

**Compilation flags:**

`static`

**Template:**

`parse_domain(File,Output)`

**Mode and number of proofs:**

`parse_domain(+atom,-compound)` - `one`

------------------------------------------------------------------------

###### `parse_problem/2`

Parses a PDDL 3.0 problem file, returning a compound term representing its contents.

**Compilation flags:**

`static`

**Template:**

`parse_problem(File,Output)`

**Mode and number of proofs:**

`parse_problem(+atom,-compound)` - `one`

------------------------------------------------------------------------

###### `parse_problem/3`

Parses a PDDL 3.0 problem file, returning a compound term representing its contents and rest of the file. Useful when domain and problem are in one file.

**Compilation flags:**

`static`

**Template:**

`parse_problem(File,Output,RestOfFile)`

**Mode and number of proofs:**

`parse_problem(+atom,-compound,-list(atom))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**category**

#### `read_file`

Utility predicates for parsing a file as a list of atoms.

**Availability:**

`logtalk_load(pddl_parser(loader))`

**Author:** Robert Sasak, Charles University in Prague. Adapted to Logtalk by Paulo Moura.

**Version:** 1:0:0

**Date:** 2011-08-04

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `read_file/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `read_file/2`

Reads a file character by character, parsing it into a list of atoms.

**Compilation flags:**

`static`

**Template:**

`read_file(File,List)`

**Mode and number of proofs:**

`read_file(+atom,-list(atom))` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### permutations")

**object**

#### `permutations`

Implementation of permutations operations over lists.

**Availability:**

`logtalk_load(permutations(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` permutations_protocol

**Uses:**

fast_random(Algorithm)

list

natural

**Remarks:**

(none)

**Inherited public predicates:**

 cartesian_product/3  count_permutations/2  derangement/2  derangements/2  distinct_permutation/2  distinct_permutation/3  distinct_permutations/2  distinct_permutations/3  k_permutation/3  k_permutation/4  k_permutations/3  k_permutations/4  next_permutation/2  nth_permutation/3  permutation/2  permutation/3  permutation_index/3  permutations/2  permutations/3  previous_permutation/2  random_permutation/2

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `permutations_protocol`

Protocol for permutations operations over lists.

**Availability:**

`logtalk_load(permutations(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-26

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `permutations/2`

  - `permutation/2`

  - `permutations/3`

  - `permutation/3`

  - `distinct_permutations/2`

  - `distinct_permutation/2`

  - `distinct_permutations/3`

  - `distinct_permutation/3`

  - `k_permutations/3`

  - `k_permutation/3`

  - `k_permutations/4`

  - `k_permutation/4`

  - `cartesian_product/3`

  - `derangements/2`

  - `derangement/2`

  - `next_permutation/2`

  - `previous_permutation/2`

  - `nth_permutation/3`

  - `permutation_index/3`

  - `count_permutations/2`

  - `random_permutation/2`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `permutations/2`

Generates all permutations of a list.

**Compilation flags:**

`static`

**Template:**

`permutations(List,Permutations)`

**Mode and number of proofs:**

`permutations(+list,-list)` - `one`

------------------------------------------------------------------------

###### `permutation/2`

True iff the second argument is a permutation of the first argument.

**Compilation flags:**

`static`

**Template:**

`permutation(List,Permutation)`

**Mode and number of proofs:**

`permutation(+list,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `permutations/3`

Generates all permutations with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`permutations(List,Order,Permutations)`

**Mode and number of proofs:**

`permutations(+list,+atom,-list)` - `one`

------------------------------------------------------------------------

###### `permutation/3`

True iff the third argument is a permutation with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`permutation(List,Order,Permutation)`

**Mode and number of proofs:**

`permutation(+list,+atom,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `distinct_permutations/2`

Generates all distinct permutations of a list (deduplicating repeated values in the input list).

**Compilation flags:**

`static`

**Template:**

`distinct_permutations(List,Permutations)`

**Mode and number of proofs:**

`distinct_permutations(+list,-list)` - `one`

------------------------------------------------------------------------

###### `distinct_permutation/2`

True iff the second argument is a distinct permutation of the first argument.

**Compilation flags:**

`static`

**Template:**

`distinct_permutation(List,Permutation)`

**Mode and number of proofs:**

`distinct_permutation(+list,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `distinct_permutations/3`

Generates all distinct permutations with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`distinct_permutations(List,Order,Permutations)`

**Mode and number of proofs:**

`distinct_permutations(+list,+atom,-list)` - `one`

------------------------------------------------------------------------

###### `distinct_permutation/3`

True iff the third argument is a distinct permutation with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`distinct_permutation(List,Order,Permutation)`

**Mode and number of proofs:**

`distinct_permutation(+list,+atom,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `k_permutations/3`

Generates all K-permutations (ordered selections) of a list.

**Compilation flags:**

`static`

**Template:**

`k_permutations(K,List,Permutations)`

**Mode and number of proofs:**

`k_permutations(+integer,+list,-list)` - `one`

------------------------------------------------------------------------

###### `k_permutation/3`

True iff the third argument is a K-permutation (ordered selection) of a list.

**Compilation flags:**

`static`

**Template:**

`k_permutation(K,List,Permutation)`

**Mode and number of proofs:**

`k_permutation(+integer,+list,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `k_permutations/4`

Generates all K-permutations with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`k_permutations(K,List,Order,Permutations)`

**Mode and number of proofs:**

`k_permutations(+integer,+list,+atom,-list)` - `one`

------------------------------------------------------------------------

###### `k_permutation/4`

True iff the fourth argument is a K-permutation with the given order: `default`, `lexicographic`, or `shortlex`.

**Compilation flags:**

`static`

**Template:**

`k_permutation(K,List,Order,Permutation)`

**Mode and number of proofs:**

`k_permutation(+integer,+list,+atom,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `cartesian_product/3`

Generates all K-element tuples from a list with replacement where order matters.

**Compilation flags:**

`static`

**Template:**

`cartesian_product(K,List,Tuples)`

**Mode and number of proofs:**

`cartesian_product(+integer,+list,-list)` - `one`

------------------------------------------------------------------------

###### `derangements/2`

Generates all derangements of a list.

**Compilation flags:**

`static`

**Template:**

`derangements(List,Derangements)`

**Mode and number of proofs:**

`derangements(+list,-list)` - `one`

------------------------------------------------------------------------

###### `derangement/2`

True iff the second argument is a derangement of the first argument.

**Compilation flags:**

`static`

**Template:**

`derangement(List,Derangement)`

**Mode and number of proofs:**

`derangement(+list,-list)` - `one_or_more`

------------------------------------------------------------------------

###### `next_permutation/2`

Returns the next permutation in lexicographic order.

**Compilation flags:**

`static`

**Template:**

`next_permutation(Permutation,Next)`

**Mode and number of proofs:**

`next_permutation(+list,-list)` - `zero_or_one`

------------------------------------------------------------------------

###### `previous_permutation/2`

Returns the previous permutation in lexicographic order.

**Compilation flags:**

`static`

**Template:**

`previous_permutation(Permutation,Previous)`

**Mode and number of proofs:**

`previous_permutation(+list,-list)` - `zero_or_one`

------------------------------------------------------------------------

###### `nth_permutation/3`

Returns the permutation at a given zero-based index.

**Compilation flags:**

`static`

**Template:**

`nth_permutation(List,Index,Permutation)`

**Mode and number of proofs:**

`nth_permutation(+list,+integer,-list)` - `zero_or_one`

------------------------------------------------------------------------

###### `permutation_index/3`

Returns the zero-based index of a permutation.

**Compilation flags:**

`static`

**Template:**

`permutation_index(List,Permutation,Index)`

**Mode and number of proofs:**

`permutation_index(+list,+list,-integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `count_permutations/2`

Counts the number of permutations of a list.

**Compilation flags:**

`static`

**Template:**

`count_permutations(List,Count)`

**Mode and number of proofs:**

`count_permutations(+list,-integer)` - `one`

------------------------------------------------------------------------

###### `random_permutation/2`

Returns a random permutation of a list.

**Compilation flags:**

`static`

**Template:**

`random_permutation(List,Permutation)`

**Mode and number of proofs:**

`random_permutation(+list,-list)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

### ports_profiler")

**object**

#### `ports_profiler`

Predicate execution box model port profiler.

**Availability:**

`logtalk_load(ports_profiler(loader))`

**Author:** Paulo Moura

**Version:** 2:0:0

**Date:** 2024-05-18

**Compilation flags:**

`static,`` ``context_switching_calls`

**Provides:**

logtalk::debug_handler/1

logtalk::debug_handler/3

**Uses:**

logtalk

user

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `start/0`

  - `stop/0`

  - `data/0`

  - `data/1`

  - `data/2`

  - `reset/0`

  - `reset/1`

  - `port/5`

  - `clause_location/6`

  - `clause/5`

- Protected predicates

- Private predicates

  - `clause_location_/6`

  - `port_/5`

  - `clause_/5`

  - `entity_defines_/2`

- Operators

##### Public predicates

###### `start/0`

Activates the ports profiler for followup goals.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`start` - `one`

------------------------------------------------------------------------

###### `stop/0`

Deactivates the ports profiler.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`stop` - `one`

------------------------------------------------------------------------

###### `data/0`

Prints a table with all port profiling data.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`data` - `one`

------------------------------------------------------------------------

###### `data/1`

Prints a table with all port profiling data for the specified entity.

**Compilation flags:**

`static`

**Template:**

`data(Entity)`

**Mode and number of proofs:**

`data(+entity_identifier)` - `one`

------------------------------------------------------------------------

###### `data/2`

Prints a table with all port profiling data for the specified entity predicate (or non-terminal).

**Compilation flags:**

`static`

**Template:**

`data(Entity,Predicate)`

**Mode and number of proofs:**

`data(+entity_identifier,+predicate_indicator)` - `one`

`data(+entity_identifier,+non_terminal_indicator)` - `one`

------------------------------------------------------------------------

###### `reset/0`

Resets all port profiling data.

**Compilation flags:**

`static`

**Mode and number of proofs:**

`reset` - `one`

------------------------------------------------------------------------

###### `reset/1`

Resets all port profiling data for the specified entity.

**Compilation flags:**

`static`

**Template:**

`reset(Entity)`

**Mode and number of proofs:**

`reset(+entity_identifier)` - `one`

------------------------------------------------------------------------

###### `port/5`

Enumerates, by backtracking, all collected port profiling data.

**Compilation flags:**

`static`

**Template:**

`port(Port,Entity,Functor,Arity,Count)`

**Mode and number of proofs:**

`port(?atom,?entity_identifier,?atom,?integer,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `clause_location/6`

Enumerates, by backtracking, all collected profiled clause location data.

**Compilation flags:**

`static`

**Template:**

`clause_location(Entity,Functor,Arity,ClauseNumber,File,BeginLine)`

**Mode and number of proofs:**

`clause_location(?entity_identifier,?atom,?integer,?integer,?atom,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `clause/5`

Enumerates, by backtracking, all collected clause profiling data.

**Compilation flags:**

`dynamic`

**Template:**

`clause(Entity,Functor,Arity,ClauseNumber,Count)`

**Mode and number of proofs:**

`clause(?entity_identifier,?atom,?integer,?integer,?integer)` - `zero_or_more`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `clause_location_/6`

Internal table of collected profiled clause location data.

**Compilation flags:**

`dynamic`

**Template:**

`clause_location_(Entity,Functor,Arity,ClauseNumber,File,BeginLine)`

**Mode and number of proofs:**

`clause_location_(?entity_identifier,?atom,?integer,?integer,?atom,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `port_/5`

Internal table of collected port profiling data.

**Compilation flags:**

`dynamic`

**Template:**

`port_(Port,Entity,Functor,Arity,Count)`

**Mode and number of proofs:**

`port_(?atom,?entity_identifier,?atom,?integer,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `clause_/5`

Internal table of collected clause profiling data.

**Compilation flags:**

`dynamic`

**Template:**

`clause_(Entity,Functor,Arity,ClauseNumber,Count)`

**Mode and number of proofs:**

`clause_(?entity_identifier,?atom,?integer,?integer,?integer)` - `zero_or_more`

------------------------------------------------------------------------

###### `entity_defines_/2`

Internal cache for profiled predicates.

**Compilation flags:**

`dynamic`

**Template:**

`entity_defines_(Entity,Predicate)`

**Mode and number of proofs:**

`entity_defines_(?entity_identifier,?predicate_indicator)` - `zero_or_more`

------------------------------------------------------------------------

##### Operators

(none)

### process")

**object**

#### `process`

Portable process handling predicates.

**Availability:**

`logtalk_load(process(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-04

**Compilation flags:**

`static,`` ``context_switching_calls`

**Dependencies:**

(none)

**Remarks:**

> - Supported backend Prolog systems: ECLiPSe, GNU Prolog, SICStus Prolog, SWI-Prolog, Trealla Prolog, and XVM.

**Inherited public predicates:**

(none)

- Public predicates

  - `create/3`

  - `wait/2`

  - `kill/2`

  - `kill/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `create/3`

Creates a new process from the given executable and list of arguments. Supported options are `process(Pid)`, `stdin(Stream)`, `stdout(Stream)`, and `stderr(Stream)`.

**Compilation flags:**

`static`

**Template:**

`create(Executable,Arguments,Options)`

**Mode and number of proofs:**

`create(+atom,+list(atom),+list(compound))` - `zero_or_one`

------------------------------------------------------------------------

###### `wait/2`

Waits for a process to terminate and retrieves its exit status.

**Compilation flags:**

`static`

**Template:**

`wait(Process,Status)`

**Mode and number of proofs:**

`wait(+process_or_pid,-integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `kill/2`

Kills the given process with the specified signal (an integer or one of the following atoms: `sighup`, `sigint`, `sigkill`, or `sigterm`).

**Compilation flags:**

`static`

**Template:**

`kill(Process,Signal)`

**Mode and number of proofs:**

`kill(+process_or_pid,+atom_or_integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `kill/1`

Kills the given process using the default signal (`sigkill`).

**Compilation flags:**

`static`

**Template:**

`kill(Process)`

**Mode and number of proofs:**

`kill(+process_or_pid)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

os

### protobuf")

**object**

#### `protobuf`

Google Protocol Buffers binary format parser and generator.

**Availability:**

`logtalk_load(protobuf(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2026-02-04

**Compilation flags:**

`static,`` ``context_switching_calls`

**Uses:**

json(ObjectRepresentation,PairRepresentation,StringRepresentation)

list

reader

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `parse/2`

  - `parse/3`

  - `generate/3`

  - `generate/4`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `parse/2`

Parses Protocol Buffers binary data from the given source (`bytes(List)`, `stream(Stream)`, or `file(Path)`) returning a `Schema-Data` pair. When the schema is not present in the file, `Schema` is unified with `false`.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Schema-Data)`

**Mode and number of proofs:**

`parse(++compound,--pair)` - `one_or_error`

------------------------------------------------------------------------

###### `parse/3`

Parses Protocol Buffers binary data from the given source using the provided schema, returning the decoded data.

**Compilation flags:**

`static`

**Template:**

`parse(Source,Schema,Data)`

**Mode and number of proofs:**

`parse(++compound,++term,--term)` - `one_or_error`

------------------------------------------------------------------------

###### `generate/3`

Generates Protocol Buffers binary data to the given sink (`bytes(List)`, `stream(Stream)`, or `file(Path)`) from the given schema and data. The schema is not included in the output.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,Schema,Data)`

**Mode and number of proofs:**

`generate(++compound,++term,++term)` - `one_or_error`

------------------------------------------------------------------------

###### `generate/4`

Generates Protocol Buffers binary data to the given sink from the given schema and data. When `IncludeSchema` is `true`, the schema is embedded in a wrapper message.

**Compilation flags:**

`static`

**Template:**

`generate(Sink,IncludeSchema,Schema,Data)`

**Mode and number of proofs:**

`generate(++compound,++boolean,++term,++term)` - `one_or_error`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

### queues")

**object**

#### `queue`

Queue predicates implemented using difference lists.

**Availability:**

`logtalk_load(queues(loader))`

**Author:** Paulo Moura

**Version:** 1:3:0

**Date:** 2020-12-09

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` queuep

**Extends:**

`public` compound

**Remarks:**

(none)

**Inherited public predicates:**

 (\<)/2  (=:=)/2  (=\<)/2  (=\\)/2  (\>)/2  (\>=)/2  append/3  as_list/2  check/1  depth/2  empty/1  ground/1  head/2  join/3  join_all/3  jump/3  jump_all/3  jump_all_block/3  length/2  map/2  map/3  new/1  numbervars/1  numbervars/3  occurs/2  serve/3  singletons/2  subsumes/2  subterm/2  valid/1  variables/2  variant/2  varnumbers/2  varnumbers/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

**protocol**

#### `queuep`

Queue protocol.

**Availability:**

`logtalk_load(queues(loader))`

**Author:** Paulo Moura

**Version:** 1:3:0

**Date:** 2020-12-09

**Compilation flags:**

`static`

**Dependencies:**

(none)

**Remarks:**

(none)

**Inherited public predicates:**

(none)

- Public predicates

  - `empty/1`

  - `head/2`

  - `join/3`

  - `join_all/3`

  - `jump/3`

  - `jump_all/3`

  - `jump_all_block/3`

  - `append/3`

  - `length/2`

  - `serve/3`

  - `as_list/2`

  - `map/2`

  - `map/3`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `empty/1`

True if the queue is empty.

**Compilation flags:**

`static`

**Template:**

`empty(Queue)`

**Mode and number of proofs:**

`empty(@queue)` - `zero_or_one`

------------------------------------------------------------------------

###### `head/2`

Unifies `Head` with the first element of the queue.

**Compilation flags:**

`static`

**Template:**

`head(Queue,Head)`

**Mode and number of proofs:**

`head(+queue,?term)` - `zero_or_one`

------------------------------------------------------------------------

###### `join/3`

Adds the new element at the end of the queue.

**Compilation flags:**

`static`

**Template:**

`join(Element,Queue,NewQueue)`

**Mode and number of proofs:**

`join(@term,+queue,-queue)` - `zero_or_one`

------------------------------------------------------------------------

###### `join_all/3`

Adds the new elements at the end of the queue. The elements are added in the same order that they appear in the list.

**Compilation flags:**

`static`

**Template:**

`join_all(List,Queue,NewQueue)`

**Mode and number of proofs:**

`join_all(+list,+queue,-queue)` - `zero_or_one`

------------------------------------------------------------------------

###### `jump/3`

Adds the new element at the front of the queue.

**Compilation flags:**

`static`

**Template:**

`jump(Element,Queue,NewQueue)`

**Mode and number of proofs:**

`jump(@term,+queue,-queue)` - `zero_or_one`

------------------------------------------------------------------------

###### `jump_all/3`

Adds the new elements at the front of the queue. The last element in the list will be at the front of the queue.

**Compilation flags:**

`static`

**Template:**

`jump_all(Elements,Queue,NewQueue)`

**Mode and number of proofs:**

`jump_all(+list,+queue,-queue)` - `zero_or_one`

------------------------------------------------------------------------

###### `jump_all_block/3`

Adds the new elements as a block at the front of the queue. The first element in the list will be at the front of the queue.

**Compilation flags:**

`static`

**Template:**

`jump_all_block(Elements,Queue,NewQueue)`

**Mode and number of proofs:**

`jump_all_block(+list,+queue,-queue)` - `zero_or_one`

------------------------------------------------------------------------

###### `append/3`

Appends two queues. The new queue will have the elements of the first queue followed by the elements of the second queue.

**Compilation flags:**

`static`

**Template:**

`append(Queue1,Queue2,NewQueue)`

**Mode and number of proofs:**

`append(+queue,+queue,-queue)` - `one`

------------------------------------------------------------------------

###### `length/2`

Queue length.

**Compilation flags:**

`static`

**Template:**

`length(Queue,Length)`

**Mode and number of proofs:**

`length(+heap,?integer)` - `zero_or_one`

------------------------------------------------------------------------

###### `serve/3`

Removes the first element of the queue for service.

**Compilation flags:**

`static`

**Template:**

`serve(Queue,Head,NewQueue)`

**Mode and number of proofs:**

`serve(+queue,?term,-queue)` - `zero_or_one`

------------------------------------------------------------------------

###### `as_list/2`

Converts a queue to a list.

**Compilation flags:**

`static`

**Template:**

`as_list(Queue,List)`

**Mode and number of proofs:**

`as_list(+queue,-list)` - `one`

------------------------------------------------------------------------

###### `map/2`

Applies a closure to all elements of a queue.

**Compilation flags:**

`static`

**Template:**

`map(Closure,Queue)`

**Meta-predicate template:**

`map(1,*)`

**Mode and number of proofs:**

`map(+callable,+queue)` - `zero_or_one`

------------------------------------------------------------------------

###### `map/3`

Applies a closure to all elements of a queue constructing a new queue.

**Compilation flags:**

`static`

**Template:**

`map(Closure,Queue,NewQueue)`

**Meta-predicate template:**

`map(2,*,*)`

**Mode and number of proofs:**

`map(+callable,+queue,?queue)` - `zero_or_one`

------------------------------------------------------------------------

##### Protected predicates

(none)

##### Private predicates

(none)

##### Operators

(none)

See also

queue

### random")

**object**

#### `backend_random`

Random number generator predicates using the backend Prolog compiler built-in random generator.

**Availability:**

`logtalk_load(random(loader))`

**Author:** Paulo Moura

**Version:** 1:22:0

**Date:** 2026-02-11

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` pseudo_random_protocol

`public` sampling_protocol

**Uses:**

list

**Remarks:**

> - Implementation: The backend Prolog compiler built-in random generator is only used for the basic `random/1`, `get_seed/1`, and `set_seed/1` predicates.
>
> - Portability: B-Prolog, CxProlog, ECLiPSe, JIProlog, Qu-Prolog, and Quintus Prolog do not provide implementations for the `get_seed/1` and `set_seed/1` predicates and calling these predicates simply succeed without performing any action.

**Inherited public predicates:**

 bernoulli/2  beta/3  between/3  binomial/3  chi_squared/2  circular_uniform_cartesian/3  circular_uniform_polar/3  dirichlet/2  enumerate/2  exponential/2  fisher/3  gamma/3  geometric/2  get_seed/1  gumbel/3  hypergeometric/4  logistic/3  lognormal/3  logseries/2  maybe/0  maybe/1  maybe/2  maybe_call/1  maybe_call/2  member/2  normal/3  permutation/2  poisson/2  power/2  random/1  random/3  randseq/4  randset/4  select/3  select/4  sequence/4  set/4  set_seed/1  standard_cauchy/3  standard_exponential/1  standard_gamma/2  standard_normal/1  standard_t/2  swap/2  swap_consecutive/2  triangular/4  uniform/1  uniform/3  von_mises/3  wald/3  weibull/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

random, fast_random

**object**

#### `fast_random`

Portable random number generator predicates. Core predicates originally written by Richard O’Keefe. Based on algorithm AS 183 from Applied Statistics.

**Availability:**

`logtalk_load(random(loader))`

**Author:** Paulo Moura

**Version:** 3:0:0

**Date:** 2026-01-25

**Compilation flags:**

`static,`` ``context_switching_calls`

**Extends:**

`public` fast_random(as183)

**Remarks:**

> - Single random number generator: This object provides a faster version of the `random` library object but does not support being extended to define multiple random number generators.
>
> - Randomness: Loading this object always initializes the random generator seed to the same value, thus providing a pseudo random number generator. The `randomize/1` predicate can be used to initialize the seed with a random value.

**Inherited public predicates:**

 bernoulli/2  beta/3  between/3  binomial/3  chi_squared/2  circular_uniform_cartesian/3  circular_uniform_polar/3  dirichlet/2  enumerate/2  exponential/2  fisher/3  gamma/3  geometric/2  get_seed/1  gumbel/3  hypergeometric/4  logistic/3  lognormal/3  logseries/2  maybe/0  maybe/1  maybe/2  maybe_call/1  maybe_call/2  member/2  normal/3  permutation/2  poisson/2  power/2  random/1  random/3  randomize/1  randseq/4  randset/4  reset_seed/0  select/3  select/4  sequence/4  set/4  set_seed/1  standard_cauchy/3  standard_exponential/1  standard_gamma/2  standard_normal/1  standard_t/2  swap/2  swap_consecutive/2  triangular/4  uniform/1  uniform/3  von_mises/3  wald/3  weibull/3

- Public predicates

- Protected predicates

- Private predicates

- Operators

##### Public predicates

(no local declarations; see entity ancestors if any)

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

(no local declarations; see entity ancestors if any)

##### Operators

(none)

See also

fast_random, random, random(Algorithm), backend_random

**object**

#### `fast_random(Algorithm)`

- `Algorithm` - Random number generator algorithm. One of `as183`, `splitmix64`, `xoshiro128pp`, `xoshiro128ss`, `xoshiro256pp`, `xoshiro256ss`, `well512a`.

Fast portable random number generator predicates.

**Availability:**

`logtalk_load(random(loader))`

**Author:** Paulo Moura

**Version:** 3:0:0

**Date:** 2026-02-23

**Compilation flags:**

`static,`` ``context_switching_calls`

**Implements:**

`public` pseudo_random_protocol

`public` sampling_protocol

**Uses:**

list

**Remarks:**

> - Single random number generator: This object provides a faster version of the `random` library object but does not support being extended to define multiple random number generators.
>
> - Randomness: Loading this object always initializes the random generator seed to the same value, thus providing a pseudo random number generator. The `randomize/1` predicate can be used to initialize the seed with a random value.
>
> - `as183`: Algorithm AS 183 from Applied Statistics. 32-bit PRNG with period 2^60. Not cryptographically secure.
>
> - `xoshiro128pp`: Xoshiro128++ random number generator. 32-bit state-of-the-art PRNG with period 2^128-1. Algorithm by David Blackman and Sebastiano Vigna.
>
> - `xoshiro128ss`: Xoshiro128\*\* random number generator. 32-bit PRNG with period 2^128-1. Algorithm by David Blackman and Sebastiano Vigna.
>
> - `xoshiro256pp`: Xoshiro256++ random number generator. 64-bit state-of-the-art PRNG with period 2^256-1. Algorithm by David Blackman and Sebastiano Vigna.
>
> - `xoshiro256ss`: Xoshiro256\*\* random number generator. 64-bit PRNG with period 2^256-1. Algorithm by David Blackman and Sebastiano Vigna.
>
> - `splitmix64`: SplitMix64 random number generator. 64-bit PRNG primarily used for seeding other generators. Algorithm by Guy L. Steele Jr. et al.
>
> - `well512a`: WELL512a 16x32-bit state-of-the-art PRNG with period 2^512-1. Algorithm by by François Panneton, Pierre L’Ecuyer, and Makoto Matsumoto.
>
> - Algorithms backend compatibility: The SplitMix64, Xoshiro256++, and Xoshiro256\*\* algorithms require support for unbound integer arithmetic.

**Inherited public predicates:**

 bernoulli/2  beta/3  between/3  binomial/3  chi_squared/2  circular_uniform_cartesian/3  circular_uniform_polar/3  dirichlet/2  enumerate/2  exponential/2  fisher/3  gamma/3  geometric/2  get_seed/1  gumbel/3  hypergeometric/4  logistic/3  lognormal/3  logseries/2  maybe/0  maybe/1  maybe/2  maybe_call/1  maybe_call/2  member/2  normal/3  permutation/2  poisson/2  power/2  random/1  random/3  randseq/4  randset/4  select/3  select/4  sequence/4  set/4  set_seed/1  standard_cauchy/3  standard_exponential/1  standard_gamma/2  standard_normal/1  standard_t/2  swap/2  swap_consecutive/2  triangular/4  uniform/1  uniform/3  von_mises/3  wald/3  weibull/3

- Public predicates

  - `reset_seed/0`

  - `randomize/1`

- Protected predicates

- Private predicates

  - `seed_/2`

- Operators

##### Public predicates

###### `reset_seed/0`

Resets the random generator seed to its default value. Use `get_seed/1` and `set_seed/1` instead if you need reproducibility.

**Compilation flags:**

`static,`` ``synchronized`

**Mode and number of proofs:**

`reset_seed` - `one`

------------------------------------------------------------------------

###### `randomize/1`

Randomizes the random generator using a positive integer to compute a new seed. Use of a large integer is recommended. In alternative, when using a small integer argument, discard the first dozen random values.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`randomize(Seed)`

**Mode and number of proofs:**

`randomize(+positive_integer)` - `one`

------------------------------------------------------------------------

##### Protected predicates

(no local declarations; see entity ancestors if any)

##### Private predicates

###### `seed_/2`

Stores the current random generator seed values (a ground but otherwise opaque term).

**Compilation flags:**

`dynamic`

**Template:**

`seed_(Algorithm,Seed)`

**Mode and number of proofs:**

`seed_(+atom,-ground)` - `one`

------------------------------------------------------------------------

##### Operators

(none)

See also

fast_random, random(Algorithm), random, backend_random

**protocol**

#### `pseudo_random_protocol`

Pseudo-random number generator protocol for seed handling predicates. These predicates are declared as synchronized when the library is compiled using a backend supporting threads.

**Availability:**

`logtalk_load(random(loader))`

**Author:** Paulo Moura

**Version:** 1:0:0

**Date:** 2021-02-21

**Compilation flags:**

`static`

**Extends:**

`public` random_protocol

**Remarks:**

(none)

**Inherited public predicates:**

 between/3  enumerate/2  maybe/0  maybe/1  maybe/2  maybe_call/1  maybe_call/2  member/2  permutation/2  random/1  random/3  randseq/4  randset/4  select/3  select/4  sequence/4  set/4  swap/2  swap_consecutive/2

- Public predicates

  - `get_seed/1`

  - `set_seed/1`

- Protected predicates

- Private predicates

- Operators

##### Public predicates

###### `get_seed/1`

Gets the current random generator seed. Seed should be regarded as an opaque ground term.

**Compilation flags:**

`static,`` ``synchronized`

**Template:**

`get_seed(Seed)`

**Mode and number of proofs:**

`get_seed(-ground)` - `one`

------------------------------------------------------------------------

###### `set_seed/1`

Sets the random generator seed to a given value returned by calling the `get_seed/1` predicate.

**Compilation flags:**

`static,`` 