#
# Copyright (c) 2020 SUSE LLC, 2022 Stephan Jauernick
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via https://bugs.opensuse.org/
#

%define version_archive _VERSION_ARCHIVE_

Name:           mingw64-libigloo
Version:        0.9.5
Release:        0
Summary:        MinGW Windows port of libigloo. Which is a generic C framework. It is developed and used by the Icecast project.
License:        LGPL-2.0
Group:          System/Libraries
URL:            https://icecast.org
Source:         libigloo_%{version}.orig.tar.gz
BuildRequires:  libtool
BuildRequires:  automake
BuildRequires:  xz
BuildRequires:  mingw64-cross-binutils
BuildRequires:  mingw64-cross-gcc
BuildRequires:  mingw64-cross-pkg-config
BuildRequires:  mingw64-filesystem >= 35
BuildRequires:  mingw64-librhash-devel
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
%_mingw64_package_header_debug
BuildArch:      noarch

%description
MinGW Windows port of libigloo. Which is a generic C framework. It is developed and used by the Icecast project.

%_mingw64_debug_package

%package -n mingw64-libigloo0
Summary:        MinGW Windows port of libigloo. Which is a generic C framework. It is developed and used by the Icecast project.
Group:          System/Libraries
Provides:       %{name} = %{version}
Obsoletes:      %{name} < 0.9.2


%description -n mingw64-libigloo0
MinGW Windows port of libigloo. Which is a generic C framework. It is developed and used by the Icecast project.

%package devel
Summary:        Include Files and Libraries mandatory for libigloo Development
Group:          Development/Libraries/C and C++
Requires:       glibc-devel
Requires:       %{name} = %{version}

%description devel
This package contains all necessary include files and libraries needed
to compile and develop applications that use libigloo.


%prep
%setup -q -n libigloo-%{version_archive} 

%build
autoreconf -fiv
  
echo "lt_cv_deplibs_check_method='pass_all'" >>%{_mingw64_cache}
PATH="%{_mingw64_bindir}:$PATH"; export PATH; \
mingw64_LDFLAGS="%{_mingw64_ldflags}"; export mingw64_LDFLAGS; \
mingw64_CFLAGS="%{_mingw64_cflags}"; export mingw64_CFLAGS; \
AM_LDFLAGS="-no-undefined"; export AM_LDFLAGS; \
%{_mingw64_configure} --enable-shared --disable-static

%{_mingw64_make} %{?_smp_mflags}

%install
make DESTDIR=%{buildroot} install
# docs are built in a separate spec file
#rm -rf %{buildroot}%{_datadir}/doc/*
# remove unneeded files
find %{buildroot} -type f -name "*.la" -delete -print

%check
echo disabled1
echo disabled2

%post -n mingw64-libigloo0 -p /sbin/ldconfig

%postun -n mingw64-libigloo0 -p /sbin/ldconfig

%files -n mingw64-libigloo0
%{_mingw64_bindir}/libigloo*.dll

%files devel
%defattr(-,root,root)
%doc README NEWS
%license COPYING
%{_mingw64_includedir}/igloo
%{_mingw64_libdir}/lib*
%{_mingw64_libdir}/pkgconfig/*.pc

%changelog
* Wed Dec 31 2025 Philipp Schafft <lion@lion.leolix.org> - 0.9.5-1
- New upstream version 0.9.5


* Sun Jul 13 2025 Philipp Schafft <phschafft@de.loewenfelsen.net> - 0.9.4-1
- New upstream version 0.9.4
