#! /bin/sh

cat <<EOF
/* This file was generated by "$0". DO NOT EDIT! */
EOF

for x in \
    uint8_t/uint8 \
    uint16_t/uint16 \
    uint32_t/uint32 \
    unsigned\ short/short \
    bytecode_t/code \
    bc_offset_t/bc_offset \
    bc_shortoffset_t/bc_shortoffset \
    double/double
do
    type=$(echo $x | sed -e 's/\/.*//')
    suffix=$(echo $x | sed -e 's/.*\///')
    cat <<EOF

/* Bytecode access functions for $type */
static INLINE $type get_$suffix(bytecode_p p)
{
    $type c;
    c = *($type *)p; /* or: memcpy(&c, p, sizeof(c)); */
    return c;
}

static INLINE $type put_$suffix(bytecode_p p, $type c)
{
    *($type *)p = c; /* or: memcpy(p, &c, sizeof(c)); */
    return c;
}

static INLINE $type load_$suffix(bytecode_p *p)
{
    $type c = get_$suffix(*p);
    *p += sizeof(c);
    return c;
}

static INLINE $type store_$suffix(bytecode_p *p, $type c)
{
    put_$suffix(*p, c);
    *p += sizeof(c);
    return c;
}

static INLINE $type rstore_$suffix(bytecode_p *p, $type c)
{
    *p -= sizeof(c);
    put_$suffix(*p, c);
    return c;
}

EOF
done
