// Copyright 2024-2025 Andres Morey
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v5.29.3
// source: cluster_agent.proto

package clusteragentpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	LogMetadataService_List_FullMethodName  = "/cluster_agent.LogMetadataService/List"
	LogMetadataService_Watch_FullMethodName = "/cluster_agent.LogMetadataService/Watch"
)

// LogMetadataServiceClient is the client API for LogMetadataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LogMetadataServiceClient interface {
	List(ctx context.Context, in *LogMetadataListRequest, opts ...grpc.CallOption) (*LogMetadataList, error)
	Watch(ctx context.Context, in *LogMetadataWatchRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LogMetadataWatchEvent], error)
}

type logMetadataServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLogMetadataServiceClient(cc grpc.ClientConnInterface) LogMetadataServiceClient {
	return &logMetadataServiceClient{cc}
}

func (c *logMetadataServiceClient) List(ctx context.Context, in *LogMetadataListRequest, opts ...grpc.CallOption) (*LogMetadataList, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LogMetadataList)
	err := c.cc.Invoke(ctx, LogMetadataService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *logMetadataServiceClient) Watch(ctx context.Context, in *LogMetadataWatchRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LogMetadataWatchEvent], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &LogMetadataService_ServiceDesc.Streams[0], LogMetadataService_Watch_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[LogMetadataWatchRequest, LogMetadataWatchEvent]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type LogMetadataService_WatchClient = grpc.ServerStreamingClient[LogMetadataWatchEvent]

// LogMetadataServiceServer is the server API for LogMetadataService service.
// All implementations must embed UnimplementedLogMetadataServiceServer
// for forward compatibility.
type LogMetadataServiceServer interface {
	List(context.Context, *LogMetadataListRequest) (*LogMetadataList, error)
	Watch(*LogMetadataWatchRequest, grpc.ServerStreamingServer[LogMetadataWatchEvent]) error
	mustEmbedUnimplementedLogMetadataServiceServer()
}

// UnimplementedLogMetadataServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedLogMetadataServiceServer struct{}

func (UnimplementedLogMetadataServiceServer) List(context.Context, *LogMetadataListRequest) (*LogMetadataList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedLogMetadataServiceServer) Watch(*LogMetadataWatchRequest, grpc.ServerStreamingServer[LogMetadataWatchEvent]) error {
	return status.Errorf(codes.Unimplemented, "method Watch not implemented")
}
func (UnimplementedLogMetadataServiceServer) mustEmbedUnimplementedLogMetadataServiceServer() {}
func (UnimplementedLogMetadataServiceServer) testEmbeddedByValue()                            {}

// UnsafeLogMetadataServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LogMetadataServiceServer will
// result in compilation errors.
type UnsafeLogMetadataServiceServer interface {
	mustEmbedUnimplementedLogMetadataServiceServer()
}

func RegisterLogMetadataServiceServer(s grpc.ServiceRegistrar, srv LogMetadataServiceServer) {
	// If the following call pancis, it indicates UnimplementedLogMetadataServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&LogMetadataService_ServiceDesc, srv)
}

func _LogMetadataService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LogMetadataListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LogMetadataServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LogMetadataService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LogMetadataServiceServer).List(ctx, req.(*LogMetadataListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LogMetadataService_Watch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LogMetadataWatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LogMetadataServiceServer).Watch(m, &grpc.GenericServerStream[LogMetadataWatchRequest, LogMetadataWatchEvent]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type LogMetadataService_WatchServer = grpc.ServerStreamingServer[LogMetadataWatchEvent]

// LogMetadataService_ServiceDesc is the grpc.ServiceDesc for LogMetadataService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LogMetadataService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "cluster_agent.LogMetadataService",
	HandlerType: (*LogMetadataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _LogMetadataService_List_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Watch",
			Handler:       _LogMetadataService_Watch_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "cluster_agent.proto",
}

const (
	LogRecordsService_StreamForward_FullMethodName  = "/cluster_agent.LogRecordsService/StreamForward"
	LogRecordsService_StreamBackward_FullMethodName = "/cluster_agent.LogRecordsService/StreamBackward"
)

// LogRecordsServiceClient is the client API for LogRecordsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LogRecordsServiceClient interface {
	StreamForward(ctx context.Context, in *LogRecordsStreamRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LogRecord], error)
	StreamBackward(ctx context.Context, in *LogRecordsStreamRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LogRecord], error)
}

type logRecordsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLogRecordsServiceClient(cc grpc.ClientConnInterface) LogRecordsServiceClient {
	return &logRecordsServiceClient{cc}
}

func (c *logRecordsServiceClient) StreamForward(ctx context.Context, in *LogRecordsStreamRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LogRecord], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &LogRecordsService_ServiceDesc.Streams[0], LogRecordsService_StreamForward_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[LogRecordsStreamRequest, LogRecord]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type LogRecordsService_StreamForwardClient = grpc.ServerStreamingClient[LogRecord]

func (c *logRecordsServiceClient) StreamBackward(ctx context.Context, in *LogRecordsStreamRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[LogRecord], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &LogRecordsService_ServiceDesc.Streams[1], LogRecordsService_StreamBackward_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[LogRecordsStreamRequest, LogRecord]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type LogRecordsService_StreamBackwardClient = grpc.ServerStreamingClient[LogRecord]

// LogRecordsServiceServer is the server API for LogRecordsService service.
// All implementations must embed UnimplementedLogRecordsServiceServer
// for forward compatibility.
type LogRecordsServiceServer interface {
	StreamForward(*LogRecordsStreamRequest, grpc.ServerStreamingServer[LogRecord]) error
	StreamBackward(*LogRecordsStreamRequest, grpc.ServerStreamingServer[LogRecord]) error
	mustEmbedUnimplementedLogRecordsServiceServer()
}

// UnimplementedLogRecordsServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedLogRecordsServiceServer struct{}

func (UnimplementedLogRecordsServiceServer) StreamForward(*LogRecordsStreamRequest, grpc.ServerStreamingServer[LogRecord]) error {
	return status.Errorf(codes.Unimplemented, "method StreamForward not implemented")
}
func (UnimplementedLogRecordsServiceServer) StreamBackward(*LogRecordsStreamRequest, grpc.ServerStreamingServer[LogRecord]) error {
	return status.Errorf(codes.Unimplemented, "method StreamBackward not implemented")
}
func (UnimplementedLogRecordsServiceServer) mustEmbedUnimplementedLogRecordsServiceServer() {}
func (UnimplementedLogRecordsServiceServer) testEmbeddedByValue()                           {}

// UnsafeLogRecordsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LogRecordsServiceServer will
// result in compilation errors.
type UnsafeLogRecordsServiceServer interface {
	mustEmbedUnimplementedLogRecordsServiceServer()
}

func RegisterLogRecordsServiceServer(s grpc.ServiceRegistrar, srv LogRecordsServiceServer) {
	// If the following call pancis, it indicates UnimplementedLogRecordsServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&LogRecordsService_ServiceDesc, srv)
}

func _LogRecordsService_StreamForward_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LogRecordsStreamRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LogRecordsServiceServer).StreamForward(m, &grpc.GenericServerStream[LogRecordsStreamRequest, LogRecord]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type LogRecordsService_StreamForwardServer = grpc.ServerStreamingServer[LogRecord]

func _LogRecordsService_StreamBackward_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(LogRecordsStreamRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(LogRecordsServiceServer).StreamBackward(m, &grpc.GenericServerStream[LogRecordsStreamRequest, LogRecord]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type LogRecordsService_StreamBackwardServer = grpc.ServerStreamingServer[LogRecord]

// LogRecordsService_ServiceDesc is the grpc.ServiceDesc for LogRecordsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LogRecordsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "cluster_agent.LogRecordsService",
	HandlerType: (*LogRecordsServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamForward",
			Handler:       _LogRecordsService_StreamForward_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamBackward",
			Handler:       _LogRecordsService_StreamBackward_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "cluster_agent.proto",
}
