/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.http;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.download.Downloader;
import org.jreleaser.model.internal.download.HttpDownloader;
import org.jreleaser.model.spi.download.DownloadException;
import org.jreleaser.sdk.commons.AbstractArtifactDownloader;
import org.jreleaser.util.StringUtils;

public class HttpArtifactDownloader
extends AbstractArtifactDownloader<org.jreleaser.model.api.download.HttpDownloader, HttpDownloader> {
    private HttpDownloader downloader;

    public HttpArtifactDownloader(JReleaserContext context) {
        super(context);
    }

    public HttpDownloader getDownloader() {
        return this.downloader;
    }

    public void setDownloader(HttpDownloader downloader) {
        this.downloader = downloader;
    }

    public String getType() {
        return "http";
    }

    public void download(String name) throws DownloadException {
        for (Downloader.Asset asset : this.downloader.getAssets()) {
            this.downloadAsset(name, asset);
        }
    }

    private void downloadAsset(String name, Downloader.Asset asset) throws DownloadException {
        String input = asset.getResolvedInput(this.context, (Downloader)this.downloader);
        String output = asset.getResolvedOutput(this.context, (Downloader)this.downloader, this.getFilename(input));
        if (StringUtils.isBlank((String)output)) {
            output = this.getFilename(input);
        }
        Path outputPath = this.context.getDownloadDirectory().resolve(name).resolve(output);
        this.context.getLogger().info("{} -> {}", new Object[]{input, this.context.relativizeToBasedir(outputPath)});
        if (!this.context.isDryrun()) {
            try {
                FileUtils.copyURLToFile((URL)new URI(input).toURL(), (File)outputPath.toFile(), (int)(this.downloader.getConnectTimeout() * 1000), (int)(this.downloader.getReadTimeout() * 1000));
            }
            catch (IOException | URISyntaxException e) {
                throw new DownloadException(RB.$((String)"ERROR_unexpected_download", (Object[])new Object[]{input}), (Throwable)e);
            }
        }
        this.unpack(asset.getUnpack(), outputPath);
    }

    private String getFilename(String name) {
        return name.substring(name.lastIndexOf(47) + 1);
    }
}

