/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.extensions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Locale;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.extensions.Extension;
import org.jreleaser.model.internal.tools.Jbang;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class ExtensionsValidator {
    private ExtensionsValidator() {
    }

    public static void validateExtensions(JReleaserContext context, Errors errors) {
        Map<String, Extension> extensions = context.getModel().getExtensions();
        if (!extensions.isEmpty()) {
            context.getLogger().debug("extensions");
        }
        for (Map.Entry<String, Extension> e : extensions.entrySet()) {
            Extension extension = e.getValue();
            if (StringUtils.isBlank((String)extension.getName())) {
                extension.setName(e.getKey());
            }
            ExtensionsValidator.validateExtension(context, extension, errors);
        }
    }

    private static void validateExtension(JReleaserContext context, Extension extension, Errors errors) {
        context.getLogger().debug("extension.{}", new Object[]{extension.getName()});
        String value = context.getModel().getEnvironment().resolve("extension." + extension.getName() + ".enabled", "");
        if (StringUtils.isNotBlank((String)value)) {
            extension.setEnabled(Boolean.parseBoolean(value.toLowerCase(Locale.ENGLISH)));
        }
        if (!extension.isEnabledSet()) {
            extension.setEnabled(true);
        }
        if (!extension.isEnabled()) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isNotBlank((String)extension.getDirectory()) && !Files.exists(context.getBasedir().resolve(extension.getDirectory().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"extension." + extension.getName() + ".directory", extension.getDirectory()}));
        }
        ExtensionsValidator.validateJbang(context, extension, extension.getJbang(), errors);
        int count = 0;
        count += StringUtils.isNotBlank((String)extension.getGav()) ? 1 : 0;
        count += StringUtils.isNotBlank((String)extension.getDirectory()) ? 1 : 0;
        if ((count += extension.getJbang().isSet() ? 1 : 0) == 0) {
            errors.configuration(RB.$((String)"validation_extension_inputs", (Object[])new Object[]{"extension." + extension.getName()}));
            extension.setEnabled(false);
        } else if (count > 1) {
            errors.configuration(RB.$((String)"validation_extension_gav_directory_jbang", (Object[])new Object[]{"extension." + extension.getName()}));
            extension.setEnabled(false);
        }
        for (int i = 0; i < extension.getProviders().size(); ++i) {
            ExtensionsValidator.validateExtensionProvider(context, extension, extension.getProviders().get(i), i, errors);
        }
    }

    private static void validateJbang(JReleaserContext context, Extension extension, Jbang jbang, Errors errors) {
        context.getLogger().debug("extension.{}.jbang", new Object[]{extension.getName()});
        if (StringUtils.isBlank((String)jbang.getScript())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"extensions.{}.jbang.script", extension.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            extension.setEnabled(false);
        }
    }

    private static void validateExtensionProvider(JReleaserContext context, Extension extension, Extension.Provider provider, int index, Errors errors) {
        if (StringUtils.isBlank((String)provider.getType())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"extensions.{}.providers[{}]", extension.getName(), index}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            extension.setEnabled(false);
        }
    }
}

