/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.deploy.maven;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.deploy.maven.MavenDeployer;
import org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.AbstractMavenDeployer;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public final class Nexus2MavenDeployer
extends AbstractMavenDeployer<Nexus2MavenDeployer, org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer> {
    private static final long serialVersionUID = 9077911047137402294L;
    private String snapshotUrl;
    private String verifyUrl;
    private Boolean closeRepository;
    private Boolean releaseRepository;
    private int transitionDelay;
    private int transitionMaxRetries;
    private String stagingProfileId;
    private String stagingRepositoryId;
    private Nexus2MavenDeployer.Stage startStage;
    private Nexus2MavenDeployer.Stage endStage;
    @JsonIgnore
    private final org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer immutable = new org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer(){
        private static final long serialVersionUID = -2516726037520331601L;
        private Set<? extends MavenDeployer.ArtifactOverride> artifactOverrides;

        public String getGroup() {
            return "maven";
        }

        public String getSnapshotUrl() {
            return Nexus2MavenDeployer.this.snapshotUrl;
        }

        public String getVerifyUrl() {
            return Nexus2MavenDeployer.this.verifyUrl;
        }

        public String getUrl() {
            return Nexus2MavenDeployer.this.getUrl();
        }

        public String getUsername() {
            return Nexus2MavenDeployer.this.getUsername();
        }

        public String getPassword() {
            return Nexus2MavenDeployer.this.getPassword();
        }

        public Http.Authorization getAuthorization() {
            return Nexus2MavenDeployer.this.getAuthorization();
        }

        public boolean isCloseRepository() {
            return Nexus2MavenDeployer.this.isCloseRepository();
        }

        public boolean isReleaseRepository() {
            return Nexus2MavenDeployer.this.isReleaseRepository();
        }

        public String getStagingProfileId() {
            return Nexus2MavenDeployer.this.getStagingProfileId();
        }

        public String getStagingRepositoryId() {
            return Nexus2MavenDeployer.this.getStagingRepositoryId();
        }

        public Nexus2MavenDeployer.Stage getStartStage() {
            return Nexus2MavenDeployer.this.getStartStage();
        }

        public Nexus2MavenDeployer.Stage getEndStage() {
            return Nexus2MavenDeployer.this.getEndStage();
        }

        public boolean isSign() {
            return Nexus2MavenDeployer.this.isSign();
        }

        public boolean isChecksums() {
            return Nexus2MavenDeployer.this.isChecksums();
        }

        public boolean isSourceJar() {
            return Nexus2MavenDeployer.this.isSourceJar();
        }

        public boolean isJavadocJar() {
            return Nexus2MavenDeployer.this.isJavadocJar();
        }

        public boolean isVerifyPom() {
            return Nexus2MavenDeployer.this.isVerifyPom();
        }

        public boolean isApplyMavenCentralRules() {
            return Nexus2MavenDeployer.this.isApplyMavenCentralRules();
        }

        public List<String> getStagingRepositories() {
            return Collections.unmodifiableList(Nexus2MavenDeployer.this.getStagingRepositories());
        }

        public Set<? extends MavenDeployer.ArtifactOverride> getArtifactOverrides() {
            if (null == this.artifactOverrides) {
                this.artifactOverrides = Nexus2MavenDeployer.this.getArtifactOverrides().stream().map(MavenDeployer.ArtifactOverride::asImmutable).collect(Collectors.toSet());
            }
            return this.artifactOverrides;
        }

        public String getType() {
            return Nexus2MavenDeployer.this.getType();
        }

        public String getName() {
            return Nexus2MavenDeployer.this.getName();
        }

        public Active getActive() {
            return Nexus2MavenDeployer.this.getActive();
        }

        public boolean isEnabled() {
            return Nexus2MavenDeployer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Nexus2MavenDeployer.this.asMap(full));
        }

        public String getPrefix() {
            return Nexus2MavenDeployer.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(Nexus2MavenDeployer.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return Nexus2MavenDeployer.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return Nexus2MavenDeployer.this.getReadTimeout();
        }

        public Integer getTransitionDelay() {
            return Nexus2MavenDeployer.this.transitionDelay;
        }

        public Integer getTransitionMaxRetries() {
            return Nexus2MavenDeployer.this.transitionMaxRetries;
        }
    };

    public Nexus2MavenDeployer() {
        super("nexus2", true);
    }

    @Override
    public org.jreleaser.model.api.deploy.maven.Nexus2MavenDeployer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Nexus2MavenDeployer source) {
        super.merge(source);
        this.verifyUrl = this.merge(this.verifyUrl, source.verifyUrl);
        this.snapshotUrl = this.merge(this.snapshotUrl, source.snapshotUrl);
        this.closeRepository = this.merge(this.closeRepository, source.closeRepository);
        this.releaseRepository = this.merge(this.releaseRepository, source.releaseRepository);
        this.transitionDelay = this.merge(this.transitionDelay, source.transitionDelay);
        this.transitionMaxRetries = this.merge(this.transitionMaxRetries, source.transitionMaxRetries);
    }

    public String getVerifyUrl() {
        return this.verifyUrl;
    }

    public void setVerifyUrl(String verifyUrl) {
        this.verifyUrl = verifyUrl;
    }

    public String getSnapshotUrl() {
        return this.snapshotUrl;
    }

    public void setSnapshotUrl(String snapshotUrl) {
        this.snapshotUrl = snapshotUrl;
    }

    public boolean isCloseRepository() {
        return null != this.closeRepository && this.closeRepository != false;
    }

    public void setCloseRepository(Boolean closeRepository) {
        this.closeRepository = closeRepository;
    }

    public boolean isCloseRepositorySet() {
        return null != this.closeRepository;
    }

    public boolean isReleaseRepository() {
        return null != this.releaseRepository && this.releaseRepository != false;
    }

    public void setReleaseRepository(Boolean releaseRepository) {
        this.releaseRepository = releaseRepository;
    }

    public boolean isReleaseRepositorySet() {
        return null != this.releaseRepository;
    }

    public Integer getTransitionDelay() {
        return this.transitionDelay;
    }

    public void setTransitionDelay(Integer transitionDelay) {
        this.transitionDelay = transitionDelay;
    }

    public Integer getTransitionMaxRetries() {
        return this.transitionMaxRetries;
    }

    public void setTransitionMaxRetries(Integer transitionMaxRetries) {
        this.transitionMaxRetries = transitionMaxRetries;
    }

    public String getStagingProfileId() {
        return this.stagingProfileId;
    }

    public void setStagingProfileId(String stagingProfileId) {
        this.stagingProfileId = stagingProfileId;
    }

    public String getStagingRepositoryId() {
        return this.stagingRepositoryId;
    }

    public void setStagingRepositoryId(String stagingRepositoryId) {
        this.stagingRepositoryId = stagingRepositoryId;
    }

    public Nexus2MavenDeployer.Stage getStartStage() {
        return this.startStage;
    }

    public void setStartStage(Nexus2MavenDeployer.Stage startStage) {
        this.startStage = startStage;
    }

    public Nexus2MavenDeployer.Stage getEndStage() {
        return this.endStage;
    }

    public void setEndStage(Nexus2MavenDeployer.Stage endStage) {
        this.endStage = endStage;
    }

    public String getResolvedSnapshotUrl(JReleaserContext context, TemplateContext props) {
        props.set("username", (Object)this.getUsername());
        props.set("owner", (Object)this.getUsername());
        props.setAll(this.getExtraProperties());
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.snapshotUrl, (TemplateContext)props);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("verifyUrl", this.verifyUrl);
        props.put("snapshotUrl", this.snapshotUrl);
        props.put("closeRepository", this.isCloseRepository());
        props.put("releaseRepository", this.isReleaseRepository());
        props.put("transitionDelay", this.transitionDelay);
        props.put("transitionMaxRetries", this.transitionMaxRetries);
        props.put("stagingProfileId", this.stagingProfileId);
        props.put("stagingRepositoryId", this.stagingRepositoryId);
        props.put("startStage", this.startStage);
        props.put("endStage", this.endStage);
    }
}

