/*
 * Decompiled with CFR 0.152.
 */
package feign.codec;

import feign.FeignException;
import feign.Response;
import feign.RetryableException;
import feign.codec.ErrorDecoder;
import java.util.Collection;
import java.util.Map;

public class DefaultErrorDecoder
implements ErrorDecoder {
    private final ErrorDecoder.RetryAfterDecoder retryAfterDecoder = new ErrorDecoder.RetryAfterDecoder();
    private Integer maxBodyBytesLength;
    private Integer maxBodyCharsLength;

    public DefaultErrorDecoder() {
        this.maxBodyBytesLength = null;
        this.maxBodyCharsLength = null;
    }

    public DefaultErrorDecoder(Integer maxBodyBytesLength, Integer maxBodyCharsLength) {
        this.maxBodyBytesLength = maxBodyBytesLength;
        this.maxBodyCharsLength = maxBodyCharsLength;
    }

    @Override
    public Exception decode(String methodKey, Response response) {
        FeignException exception = FeignException.errorStatus(methodKey, response, this.maxBodyBytesLength, this.maxBodyCharsLength);
        Long retryAfter = this.retryAfterDecoder.apply((String)this.firstOrNull(response.headers(), "Retry-After"));
        if (retryAfter != null) {
            return new RetryableException(response.status(), exception.getMessage(), response.request().httpMethod(), exception, retryAfter, response.request(), methodKey);
        }
        return exception;
    }

    private <T> T firstOrNull(Map<String, Collection<T>> map, String key) {
        if (map.containsKey(key) && !map.get(key).isEmpty()) {
            return map.get(key).iterator().next();
        }
        return null;
    }
}

