/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.bluesky;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.List;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.bluesky.BlueskyException;
import org.jreleaser.sdk.bluesky.BlueskyRecordFactory;
import org.jreleaser.sdk.bluesky.api.BlueskyAPI;
import org.jreleaser.sdk.bluesky.api.CreateRecordResponse;
import org.jreleaser.sdk.bluesky.api.CreateSessionRequest;
import org.jreleaser.sdk.bluesky.api.CreateSessionResponse;
import org.jreleaser.sdk.bluesky.api.CreateTextRecordRequest;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.util.StringUtils;

public class BlueskySdk {
    private final JReleaserContext context;
    private final BlueskyAPI api;
    private final boolean dryrun;
    private final String handle;
    private final String password;
    private final BlueskyRecordFactory factory;

    private BlueskySdk(JReleaserContext context, boolean dryrun, String host, String handle, String password, int connectTimeout, int readTimeout) {
        this.context = Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank");
        this.handle = StringUtils.requireNonBlank((String)handle, (String)"'handle' must not be blank");
        this.password = StringUtils.requireNonBlank((String)password, (String)"'password' must not be blank");
        this.dryrun = dryrun;
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.api = (BlueskyAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new JacksonDecoder(objectMapper)).target(BlueskyAPI.class, host);
        this.factory = new BlueskyRecordFactory(this.api);
        context.getLogger().debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void skeet(List<String> statuses) throws BlueskyException {
        this.wrap(() -> {
            CreateRecordResponse firstStatus;
            CreateSessionResponse session = this.createSession();
            String identifier = session.getDid();
            CreateTextRecordRequest firstStatusRequest = this.factory.textRecord(identifier, (String)statuses.get(0));
            CreateRecordResponse previousStatus = firstStatus = this.api.createRecord(firstStatusRequest, session.getAccessJwt());
            for (int i = 1; i < statuses.size(); ++i) {
                String status = (String)statuses.get(i);
                CreateTextRecordRequest nextStatusRequest = this.factory.textRecord(identifier, status, firstStatus, previousStatus);
                previousStatus = this.api.createRecord(nextStatusRequest, session.getAccessJwt());
            }
        });
    }

    private CreateSessionResponse createSession() {
        CreateSessionRequest sessionRequest = CreateSessionRequest.of(this.handle, this.password);
        return this.api.createSession(sessionRequest);
    }

    private void wrap(Runnable runnable) throws BlueskyException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new BlueskyException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Bluesky"}), e);
        }
    }

    public static Builder builder(JReleaserContext context) {
        return new Builder(context);
    }

    public static class Builder {
        private final JReleaserContext context;
        private boolean dryrun;
        private String host;
        private String handle;
        private String password;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder handle(String handle) {
            this.handle = Objects.requireNonNull(handle, "'handle' must not be null");
            return this;
        }

        public Builder password(String password) {
            this.password = Objects.requireNonNull(password, "'password' must not be null");
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.host, (String)"'host' must not be blank");
            StringUtils.requireNonBlank((String)this.handle, (String)"'handle' must not be blank");
            StringUtils.requireNonBlank((String)this.password, (String)"'password' must not be blank");
        }

        public BlueskySdk build() {
            this.validate();
            return new BlueskySdk(this.context, this.dryrun, this.host, this.handle, this.password, this.connectTimeout, this.readTimeout);
        }
    }
}

