/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.tool;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.command.CommandExecutor;
import org.jreleaser.sdk.tool.AbstractTool;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public class Cosign
extends AbstractTool {
    private static final String COSIGN_PASSWORD = "COSIGN_PASSWORD";

    public Cosign(JReleaserContext context, String version) {
        super(context, "cosign", version, true);
    }

    public boolean checkPassword(Path keyFile, String password) {
        Command command = this.tool.asCommand().arg("public-key").arg("--key").arg(keyFile.toAbsolutePath().toString());
        try {
            Command.Result result = this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), CommandExecutor.Output.QUIET).environment(COSIGN_PASSWORD, password).executeCommand(command));
            if (result.getExitValue() != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
            }
            return true;
        }
        catch (CommandException e) {
            this.context.getLogger().debug(RB.$((String)"ERROR_password_incorrect", (Object[])new Object[0]));
            return false;
        }
    }

    public Path generateKeyPair(String password) throws SigningException {
        Command command = this.tool.asCommand().arg("generate-key-pair");
        Path homeDir = this.resolveJReleaserHomeDir();
        try {
            Command.Result result = this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), CommandExecutor.Output.QUIET).environment(COSIGN_PASSWORD, password).executeCommand(homeDir, command));
            if (result.getExitValue() != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
            }
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_generate_key_pair", (Object[])new Object[0]), (Throwable)e);
        }
        this.context.getLogger().info(RB.$((String)"cosign.generated.keys.at", (Object[])new Object[0]), new Object[]{homeDir.toAbsolutePath()});
        return homeDir.resolve("cosign.key");
    }

    public void signBlob(Path keyFile, String password, Path input, Path destinationDir) throws SigningException {
        block7: {
            this.context.getLogger().info("{}", new Object[]{this.context.relativizeToBasedir(input)});
            boolean cosign3 = SemanticVersion.of((String)this.context.getModel().getSigning().getCosign().getVersion()).getMajor() >= 3;
            ArrayList<String> extraArgs = new ArrayList<String>();
            if (cosign3) {
                extraArgs.add("--use-signing-config=true");
                extraArgs.add("--bundle");
                extraArgs.add(destinationDir.resolve(input.getFileName() + ".cosign").toAbsolutePath().toString());
            } else {
                extraArgs.add(input.toAbsolutePath().toString());
            }
            Command command = this.tool.asCommand().arg("sign-blob").arg("--yes").arg("--key").arg(keyFile.toAbsolutePath().toString()).arg(input.toAbsolutePath().toString()).args(extraArgs);
            try {
                Command.Result result = this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), CommandExecutor.Output.QUIET).environment(COSIGN_PASSWORD, password).executeCommand(command));
                if (result.getExitValue() != 0) {
                    throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
                }
                if (cosign3) break block7;
                try {
                    Path signature = destinationDir.resolve(input.getFileName() + ".cosign");
                    Files.write(signature, result.getOut().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input}), (Throwable)e);
                }
            }
            catch (CommandException e) {
                throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input.toAbsolutePath()}), (Throwable)e);
            }
        }
    }

    public void verifyBlob(Path keyFile, Path signature, Path input) throws SigningException {
        this.context.getLogger().debug("{}", new Object[]{this.context.relativizeToBasedir(signature)});
        boolean cosign3 = SemanticVersion.of((String)this.context.getModel().getSigning().getCosign().getVersion()).getMajor() >= 3;
        Command command = this.tool.asCommand().arg("verify-blob").arg("--key").arg(keyFile.toAbsolutePath().toString()).arg(cosign3 ? "--bundle" : "--signature").arg(signature.toAbsolutePath().toString()).arg(input.toAbsolutePath().toString());
        try {
            Command.Result result = this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), CommandExecutor.Output.QUIET).executeCommand(command));
            if (result.getExitValue() != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
            }
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{this.context.relativizeToBasedir(signature)}), (Throwable)e);
        }
    }

    private Path resolveJReleaserHomeDir() {
        String home = System.getenv("JRELEASER_USER_HOME");
        if (StringUtils.isBlank((String)home)) {
            home = System.getProperty("user.home") + File.separator + ".jreleaser";
        }
        return Paths.get(home, new String[0]);
    }
}

