/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.common.Icon;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Screenshot;
import org.jreleaser.model.internal.packagers.AbstractAppdataPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class AppImagePackager
extends AbstractAppdataPackager<org.jreleaser.model.api.packagers.AppImagePackager, AppImagePackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private static final long serialVersionUID = -5619053700424178633L;
    private final AppImageRepository repository = new AppImageRepository();
    private Boolean requiresTerminal;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.AppImagePackager immutable = new org.jreleaser.model.api.packagers.AppImagePackager(){
        private static final long serialVersionUID = 6612331654842386512L;
        private List<? extends org.jreleaser.model.api.common.Screenshot> screenshots;
        private List<? extends Icon> icons;

        public String getComponentId() {
            return AppImagePackager.this.getComponentId();
        }

        public List<String> getCategories() {
            return Collections.unmodifiableList(AppImagePackager.this.getCategories());
        }

        public String getDeveloperId() {
            return AppImagePackager.this.getDeveloperId();
        }

        public String getDeveloperName() {
            return AppImagePackager.this.getDeveloperName();
        }

        public boolean isRequiresTerminal() {
            return AppImagePackager.this.isRequiresTerminal();
        }

        public List<? extends org.jreleaser.model.api.common.Screenshot> getScreenshots() {
            if (null == this.screenshots) {
                this.screenshots = AppImagePackager.this.getScreenshots().stream().map(Screenshot::asImmutable).collect(Collectors.toList());
            }
            return this.screenshots;
        }

        public List<? extends Icon> getIcons() {
            if (null == this.icons) {
                this.icons = AppImagePackager.this.getIcons().stream().map(org.jreleaser.model.internal.common.Icon::asImmutable).collect(Collectors.toList());
            }
            return this.icons;
        }

        public Set<String> getSkipReleases() {
            return Collections.unmodifiableSet(AppImagePackager.this.getSkipReleases());
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return AppImagePackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return AppImagePackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return AppImagePackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(AppImagePackager.this.getSkipTemplates());
        }

        public String getType() {
            return AppImagePackager.this.getType();
        }

        public String getDownloadUrl() {
            return AppImagePackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return AppImagePackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return AppImagePackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return AppImagePackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return AppImagePackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return AppImagePackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return AppImagePackager.this.isContinueOnError();
        }

        public boolean isSkipPublishing() {
            return AppImagePackager.this.isSkipPublishing();
        }

        public Active getActive() {
            return AppImagePackager.this.getActive();
        }

        public boolean isEnabled() {
            return AppImagePackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(AppImagePackager.this.asMap(full));
        }

        public String getPrefix() {
            return AppImagePackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(AppImagePackager.this.getExtraProperties());
        }
    };

    public AppImagePackager() {
        super("appimage");
    }

    @Override
    public org.jreleaser.model.api.packagers.AppImagePackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(AppImagePackager source) {
        super.merge(source);
        this.requiresTerminal = this.merge(this.requiresTerminal, source.requiresTerminal);
        this.setRepository(source.repository);
    }

    @Override
    public Set<Stereotype> getSupportedStereotypes() {
        return CollectionUtils.setOf((Object[])new Stereotype[]{Stereotype.CLI, Stereotype.DESKTOP});
    }

    public boolean isRequiresTerminal() {
        return null != this.requiresTerminal && this.requiresTerminal != false;
    }

    public void setRequiresTerminal(Boolean requiresTerminal) {
        this.requiresTerminal = requiresTerminal;
    }

    public boolean isRequiresTerminalSet() {
        return null != this.requiresTerminal;
    }

    public AppImageRepository getRepository() {
        return this.repository;
    }

    public void setRepository(AppImageRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> map) {
        super.asMap(full, map);
        map.put("requiresTerminal", this.isRequiresTerminal());
        map.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getRepository();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel64((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipAppImage"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.setOf((Object[])new String[]{FileType.JAR.extension()}));
        SUPPORTED.put(Distribution.DistributionType.FLAT_BINARY, Collections.emptySet());
    }

    public static final class AppImageRepository
    extends PackagerRepository {
        private static final long serialVersionUID = -2610749875787410531L;

        public AppImageRepository() {
            super("appimage", "appimage");
        }
    }
}

