/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api.catalog.sbom;

import java.util.Locale;
import java.util.Set;
import org.jreleaser.model.api.catalog.sbom.SbomCataloger;
import org.jreleaser.util.StringUtils;

public interface SyftSbomCataloger
extends SbomCataloger {
    public static final String TYPE = "syft";

    public String getVersion();

    public Set<Format> getFormats();

    public static enum Format {
        SYFT_JSON("syft.json"),
        CYCLONEDX_XML("cyclonedx.xml"),
        CYCLONEDX_JSON("cyclonedx.json"),
        GITHUB_JSON("github.json"),
        SPDX_JSON("spdx.json"),
        TABLE("table"),
        TEXT("txt");

        private final String alias;

        private Format(String alias) {
            this.alias = alias;
        }

        public String extension() {
            return "." + this.alias.replace(".", "-") + ".sbom";
        }

        public String formatted() {
            return this.name().replace("_", "-").toLowerCase(Locale.ROOT);
        }

        public static Format of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            String value = str.replace(" ", "").replace("-", ".").replace("_", ".").toUpperCase(Locale.ENGLISH).trim();
            for (Format type : Format.values()) {
                if (!type.alias.toLowerCase(Locale.ENGLISH).equals(value)) continue;
                return type;
            }
            return Format.valueOf(value.replace(".", "_").toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

