# Changelog

This file is generated by `./changelog.sh`

## [0.5.9] - 2025-07-16

### Bug Fixes

- Remove warning message which appears incorrectly on init

## [0.5.8] - 2025-07-16

### Contributions

- Merge pull request [#169](https://github.com/jenv/jenv/issues/169) from [dkowis](https://github.com/dkowis)/fix_rehash_for_fish
- Merge pull request [#350](https://github.com/jenv/jenv/issues/350) from [fwcd](https://github.com/fwcd)/skip-javahome-system-jdk
- Merge pull request [#404](https://github.com/jenv/jenv/issues/404) from [jsoref](https://github.com/jsoref)/issue-403
- Merge pull request [#413](https://github.com/jenv/jenv/issues/413) from [mrmeszaros](https://github.com/mrmeszaros)/docker-test-update
- Merge pull request [#424](https://github.com/jenv/jenv/issues/424) from [andrewflbarnes](https://github.com/andrewflbarnes)/docs/installation-steps
- Merge pull request [#425](https://github.com/jenv/jenv/issues/425) from [andrewflbarnes](https://github.com/andrewflbarnes)/bugfix/doctor-suggestion
- Merge pull request [#428](https://github.com/jenv/jenv/issues/428) from [andrewflbarnes](https://github.com/andrewflbarnes)/feature/changelog
- Merge pull request [#429](https://github.com/jenv/jenv/issues/429) from [breun](https://github.com/breun)/patch-1
- Merge pull request [#431](https://github.com/jenv/jenv/issues/431) from [andrewflbarnes](https://github.com/andrewflbarnes)/bugfix/doctor-plugins
- Merge pull request [#432](https://github.com/jenv/jenv/issues/432) from [andrewflbarnes](https://github.com/andrewflbarnes)/docs/brew-java-install
- Merge pull request [#433](https://github.com/jenv/jenv/issues/433) from [andrewflbarnes](https://github.com/andrewflbarnes)/feature/uninitialised-warnings
- Merge pull request [#434](https://github.com/jenv/jenv/issues/434) from [andrewflbarnes](https://github.com/andrewflbarnes)/bugfix/export-variables
- Merge pull request [#435](https://github.com/jenv/jenv/issues/435) from [andrewflbarnes](https://github.com/andrewflbarnes)/bugfix/fish-var-unset
- Merge pull request [#436](https://github.com/jenv/jenv/issues/436) from [aldoKelvianto](https://github.com/aldoKelvianto)/patch-1
- Merge pull request [#445](https://github.com/jenv/jenv/issues/445) from [gouvinb](https://github.com/gouvinb)/master
- Merge pull request [#449](https://github.com/jenv/jenv/issues/449) from [itsamanvishwakarma](https://github.com/itsamanvishwakarma)/patch-1
- Merge pull request [#450](https://github.com/jenv/jenv/issues/450) from [andrewflbarnes](https://github.com/andrewflbarnes)/docker-test-update-2
- Merge pull request [#451](https://github.com/jenv/jenv/issues/451) from [andrewflbarnes](https://github.com/andrewflbarnes)/bugfix/javahome-system-hook

### Features

- Add changelog and script for generating using git-cliff

### Bug Fixes

- Adding_jdks.bats tests
- Bug in export variables appending unnecessary args and spaces
- Doctor resolves plugin paths correctly
- Erroneous output in jenv jenv doctor
- Fish use set -e instead of unset
- Jenv-add with missing versions directory
- Setting_versions.bats tests
- Typo in docker tag: rename to jenv:test
- When version is system don't emit error text on export hook

### Documentation

- Add command for Fish shell README.md
- Add installation instructions for MacPorts
- Correct install steps so shell config is separate from source install
- Fix Dockerfile graalvm install step
- Reorder installation steps so fully setup before running jenv doctor
- Update README.md
- Update brew installation information

### Miscellaneous Tasks

- Copying rbenv's way of handling rehash for fish
- Emit warning on commands if jenv not initialised/loaded
- Extend tests: more jdks and version-name asserts
- Quote all references to `JENV_ROOT` variables (and variables that use it) to avoid word splitting.
- Refactor setting versions test case
- Refactor tests setup and teardown
- Remove openjdk 1.6 and its test
- Remove volatile build and patch numbers
- Skip setting JAVA_HOME when using system JDK

### Chore

- Centos and openjdk 1.7 are both EOL, use ubi8 and openjdk 17, 21
- Fix changelog script
- Remove jenv.be which no longer exists
- Update usage for changelog.sh

## [0.5.7] - 2024-03-12

### Contributions

- Merge pull request [#349](https://github.com/jenv/jenv/issues/349) from [stirlingcarter](https://github.com/stirlingcarter)/master
- Merge pull request [#391](https://github.com/jenv/jenv/issues/391) from [andrewflbarnes](https://github.com/andrewflbarnes)/bugfix/doctor-no-plugin-exit-code
- Merge pull request [#393](https://github.com/jenv/jenv/issues/393) from [andrewflbarnes](https://github.com/andrewflbarnes)/bugfix/sh-command-eval
- Merge pull request [#405](https://github.com/jenv/jenv/issues/405) from [jsoref](https://github.com/jsoref)/add-no-args
- Merge pull request [#406](https://github.com/jenv/jenv/issues/406) from [jsoref](https://github.com/jsoref)/spelling
- Merge pull request [#414](https://github.com/jenv/jenv/issues/414) from [nfawcett](https://github.com/nfawcett)/issue-328-show-remove-in-useful-command-list
- Merge pull request [#417](https://github.com/jenv/jenv/issues/417) from [JacksonBailey](https://github.com/JacksonBailey)/master
- Merge pull request [#421](https://github.com/jenv/jenv/issues/421) from [Friendseeker](https://github.com/Friendseeker)/fix-jenv-doctor-interpolation

### Bug Fixes

- Interpolation adding extra eval
- Jenv doctor exit code when no plugins are enabled
- Jenv doctor plugin checks
- Jenv init so sh-* commands are correctly evaluated
- Jenv versions command
- Jenv-add shortest version for posix and osx

### Documentation

- Update readme to use cask-versions

### Miscellaneous Tasks

- Gracefully handle `jenv add`
- Improve phrasing for initial doctor check and export plugin
- Update libexec/jenv-add
- Show remove in useful command list
- Spelling deactivate
- Spelling macos
- Spelling options

## [0.5.6] - 2023-02-14

### Miscellaneous Tasks

- Use a silent way in fish to check if jenv exists for #321

## [0.5.5] - 2022-06-04

### Contributions

- Merge pull request [#269](https://github.com/jenv/jenv/issues/269) from [emcrisostomo](https://github.com/emcrisostomo)/remove-accept-multiple-args
- Merge pull request [#288](https://github.com/jenv/jenv/issues/288) from [lawalib](https://github.com/lawalib)/sync-JDK_HOME-with-JAVA_HOME
- Merge pull request [#313](https://github.com/jenv/jenv/issues/313) from [isomarcte](https://github.com/isomarcte)/fix-single-digit-version-parsing
- Merge pull request [#321](https://github.com/jenv/jenv/issues/321) from [0az](https://github.com/0az)/fish-hook
- Merge pull request [#327](https://github.com/jenv/jenv/issues/327) from [RayBB](https://github.com/RayBB)/patch-1
- Merge pull request [#330](https://github.com/jenv/jenv/issues/330) from [creasty](https://github.com/creasty)/patch-1
- Merge pull request [#346](https://github.com/jenv/jenv/issues/346) from [combscCode](https://github.com/combscCode)/patch-1
- Merge pull request [#353](https://github.com/jenv/jenv/issues/353) from [kwon37xi](https://github.com/kwon37xi)/master
- Merge pull request [#355](https://github.com/jenv/jenv/issues/355) from [marquiswang](https://github.com/marquiswang)/default_shell

### Revert

- "Assume unknown shells are bash-compatible"

### Bug Fixes

- Jenv-init for shells without typeset

### Documentation

- Add quotes around command substitution

### Miscellaneous Tasks

- Add some unit tests usings docker and bats
- Assume unknown shells are bash-compatible
- Don't run jenv javahome twice in zsh
- Improve shell detection code
- Remove obsolete export.fish
- Replace source+psub
- Silence fish export hook if jenv not in path
- Update jenv-add To Handle Versions With No '.'
- Update jenv-remove to accept multiple arguments
- Add JDK providers - zulu, zulu_primetemurin, jetbrains, kona, openlogic, semeru, semeru_certified, dragonwell.
- Sync JDK_HOME with JAVA_HOME
- Update brew install commands
- Update shell detection to use more reliable current default shell rather than shell version environment variables

## [0.5.4] - 2020-08-22

### Contributions

- Merge pull request [#287](https://github.com/jenv/jenv/issues/287) from [pthariensflame](https://github.com/pthariensflame)/fix/sapmachine-15-ea
- Merge pull request [#306](https://github.com/jenv/jenv/issues/306) from [voronaam](https://github.com/voronaam)/master
- Merge pull request [#307](https://github.com/jenv/jenv/issues/307) from [roryokane](https://github.com/roryokane)/patch-3

### Bug Fixes

- [#188](https://github.com/jenv/jenv/issues/188) Add fish hook for prompt
- The custom alias functionality

### Documentation

- Fix wrong paths in Fish install instructions

### Miscellaneous Tasks

- Account for changed capitalization in newest SapMachine 15 EA
- Add fish hook for prompt
- Refresh plugin on update

## [0.5.3] - 2020-05-25

### Contributions

- Merge pull request [#241](https://github.com/jenv/jenv/issues/241) from [claui](https://github.com/claui)/fix-regression-in-jenv-add
- Merge pull request [#243](https://github.com/jenv/jenv/issues/243) from [juliodias](https://github.com/juliodias)/typo
- Merge pull request [#244](https://github.com/jenv/jenv/issues/244) from [pmairif](https://github.com/pmairif)/master
- Merge pull request [#245](https://github.com/jenv/jenv/issues/245) from [mcsnolte](https://github.com/mcsnolte)/include_add_command_in_help
- Merge pull request [#249](https://github.com/jenv/jenv/issues/249) from [clintropolis](https://github.com/clintropolis)/patch-1
- Merge pull request [#255](https://github.com/jenv/jenv/issues/255) from [JenoDK](https://github.com/JenoDK)/patch-1
- Merge pull request [#256](https://github.com/jenv/jenv/issues/256) from [smarkwell](https://github.com/smarkwell)/patch-1
- Merge pull request [#257](https://github.com/jenv/jenv/issues/257) from [bric3](https://github.com/bric3)/fix-zsh-completions-adds-space
- Merge pull request [#262](https://github.com/jenv/jenv/issues/262) from [danovia](https://github.com/danovia)/danovia-readme-patch
- Merge pull request [#265](https://github.com/jenv/jenv/issues/265) from [pengisgood](https://github.com/pengisgood)/master
- Merge pull request [#270](https://github.com/jenv/jenv/issues/270) from [tomasaschan](https://github.com/tomasaschan)/patch-1
- Merge pull request [#271](https://github.com/jenv/jenv/issues/271) from [emcrisostomo](https://github.com/emcrisostomo)/use-precmd-hook-in-zsh-export
- Merge pull request [#280](https://github.com/jenv/jenv/issues/280) from [pthariensflame](https://github.com/pthariensflame)/patch-1

### Bug Fixes

- [#193](https://github.com/jenv/jenv/issues/193) ZSH completion do not add the space anymore
- SapMachine detection for new output style.
- Graalvm JAVA_PROVIDER detection for jenv-add
- Regression in `jenv add` introduced in 0617e57
- The warn msg
- Typo

### Documentation

- Correcting Github link to current README.md
- Update README.md
- Update README.md for fish shell

### Miscellaneous Tasks

- Add --verbose flag to docs
- Add GH actions for release
- Add Github action for release
- Add the add command to help
- Delete on-release.yml
- Update jenv-add
- Use the precmd hook instead of the chpwd hook
- Add shortest version

## [0.5.2] - 2019-02-08

### Contributions

- Merge pull request [#235](https://github.com/jenv/jenv/issues/235) from [bric3](https://github.com/bric3)/patch-1
- Merge pull request [#236](https://github.com/jenv/jenv/issues/236) from [rstein66](https://github.com/rstein66)/master

### Bug Fixes

- [#234](https://github.com/jenv/jenv/issues/234) : install the hook within a local function

### Documentation

- Correct Java install command (brew -> brew cask)

### Miscellaneous Tasks

- Jenv doctor detect missconfigured plugin ( [#232](https://github.com/jenv/jenv/issues/232) )

## [0.5.1] - 2019-01-22

### Bug Fixes

- [#230](https://github.com/jenv/jenv/issues/230) - jenv global regression

### Miscellaneous Tasks

- Avoid call on java-macos-home by default

<!-- generated by git-cliff -->
