/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.model;

public class ModuleName {
    public static final String EXPLICIT = "explicit";
    public static final String FILENAME = "filename";
    public static final String MANIFEST = "manifest";
    private final String moduleName;
    private final boolean automaticByManifest;
    private final boolean automaticByFilename;
    private final boolean valid;
    private final String reason;

    private ModuleName(String moduleName, boolean automaticByManifest, boolean automaticByFilename, String reason) {
        this.moduleName = moduleName;
        this.automaticByManifest = automaticByManifest;
        this.automaticByFilename = automaticByFilename;
        this.valid = null == reason;
        this.reason = reason;
    }

    public String resolveSource() {
        if (this.isAutomaticByManifest()) {
            return MANIFEST;
        }
        if (this.isAutomaticByFilename()) {
            return FILENAME;
        }
        return EXPLICIT;
    }

    public boolean isAutomatic() {
        return this.automaticByManifest || this.automaticByFilename;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public boolean isAutomaticByManifest() {
        return this.automaticByManifest;
    }

    public boolean isAutomaticByFilename() {
        return this.automaticByFilename;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isNotValid() {
        return !this.valid;
    }

    public String getReason() {
        return this.reason;
    }

    public String asError() {
        return this.moduleName + " (" + this.resolveSource() + ") is not valid because " + this.reason;
    }

    public static ModuleName fromAutomaticByManifest(String moduleName, String reason) {
        return new ModuleName(moduleName, true, false, reason);
    }

    public static ModuleName fromAutomaticByFilename(String moduleName, String reason) {
        return new ModuleName(moduleName, false, true, reason);
    }

    public static ModuleName fromModuleDescriptor(String moduleName, String reason) {
        return ModuleName.fromModuleDescriptor(moduleName, false, false, reason);
    }

    public static ModuleName fromModuleDescriptor(String moduleName, boolean automaticByManifest, boolean automaticByFilename, String reason) {
        return new ModuleName(moduleName, automaticByManifest, automaticByFilename, reason);
    }
}

