/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "diagnosticKind", "Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;", "reason", "", "callableCopyTypeCalculator", "Lorg/jetbrains/kotlin/fir/scopes/CallableCopyTypeCalculator$DeferredCallableCopyTypeCalculator;", "<init>", "(Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;Ljava/lang/String;Lorg/jetbrains/kotlin/fir/scopes/CallableCopyTypeCalculator$DeferredCallableCopyTypeCalculator;)V", "getCallableCopyTypeCalculator", "()Lorg/jetbrains/kotlin/fir/scopes/CallableCopyTypeCalculator$DeferredCallableCopyTypeCalculator;", "tryCalculateReturnTypeOrNull", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Companion", "providers"})
@SourceDebugExtension(value={"SMAP\nReturnTypeCalculatorForFullBodyResolve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturnTypeCalculatorForFullBodyResolve.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve\n+ 2 FirErrorTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirErrorTypeRefBuilderKt\n*L\n1#1,58:1\n47#2:59\n*S KotlinDebug\n*F\n+ 1 ReturnTypeCalculatorForFullBodyResolve.kt\norg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve\n*L\n55#1:59\n*E\n"})
public final class ReturnTypeCalculatorForFullBodyResolve
extends ReturnTypeCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticKind diagnosticKind;
    @NotNull
    private final String reason;
    @NotNull
    private final CallableCopyTypeCalculator.DeferredCallableCopyTypeCalculator callableCopyTypeCalculator;
    @NotNull
    private static final ReturnTypeCalculatorForFullBodyResolve Default = new ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind.RecursionInImplicitTypes, "Recursion with local function", CallableCopyTypeCalculator.CalculateDeferredForceLazyResolution.INSTANCE);
    @NotNull
    private static final ReturnTypeCalculatorForFullBodyResolve Status = new ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind.RecursionInImplicitTypes, "Recursion with local function", CallableCopyTypeCalculator.CalculateDeferredWhenPossible.INSTANCE);
    @NotNull
    private static final ReturnTypeCalculatorForFullBodyResolve Contract = new ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind.InferenceError, "Cannot calculate return type during full-body resolution (local class/object?)", CallableCopyTypeCalculator.CalculateDeferredForceLazyResolution.INSTANCE);

    private ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind diagnosticKind, String reason, CallableCopyTypeCalculator.DeferredCallableCopyTypeCalculator callableCopyTypeCalculator) {
        this.diagnosticKind = diagnosticKind;
        this.reason = reason;
        this.callableCopyTypeCalculator = callableCopyTypeCalculator;
    }

    @Override
    @NotNull
    public CallableCopyTypeCalculator.DeferredCallableCopyTypeCalculator getCallableCopyTypeCalculator() {
        return this.callableCopyTypeCalculator;
    }

    @Override
    @Nullable
    public FirResolvedTypeRef tryCalculateReturnTypeOrNull(@NotNull FirCallableDeclaration declaration) {
        FirErrorTypeRefBuilder firErrorTypeRefBuilder;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirTypeRef returnTypeRef = declaration.getReturnTypeRef();
        if (returnTypeRef instanceof FirResolvedTypeRef) {
            return (FirResolvedTypeRef)returnTypeRef;
        }
        if (ClassMembersKt.getCanHaveDeferredReturnTypeCalculation(declaration)) {
            return this.getCallableCopyTypeCalculator().computeReturnType(declaration);
        }
        boolean $i$f$buildErrorTypeRef = false;
        FirErrorTypeRefBuilder $this$tryCalculateReturnTypeOrNull_u24lambda_u240 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
        boolean bl = false;
        $this$tryCalculateReturnTypeOrNull_u24lambda_u240.setDiagnostic(new ConeSimpleDiagnostic(this.reason + ": " + UtilsKt.render(declaration), this.diagnosticKind));
        return firErrorTypeRefBuilder.build();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve$Companion;", "", "<init>", "()V", "Default", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "getDefault", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "Status", "getStatus", "Contract", "getContract", "providers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReturnTypeCalculatorForFullBodyResolve getDefault() {
            return Default;
        }

        @NotNull
        public final ReturnTypeCalculatorForFullBodyResolve getStatus() {
            return Status;
        }

        @NotNull
        public final ReturnTypeCalculatorForFullBodyResolve getContract() {
            return Contract;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

