"""Generated client library for vectorsearch version v1beta."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.vectorsearch.v1beta import vectorsearch_v1beta_messages as messages


class VectorsearchV1beta(base_api.BaseApiClient):
  """Generated client library for service vectorsearch version v1beta."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://vectorsearch.googleapis.com/'
  MTLS_BASE_URL = 'https://vectorsearch.mtls.googleapis.com/'

  _PACKAGE = 'vectorsearch'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1beta'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'VectorsearchV1beta'
  _URL_VERSION = 'v1beta'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new vectorsearch handle."""
    url = url or self.BASE_URL
    super(VectorsearchV1beta, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_collections_dataObjects = self.ProjectsLocationsCollectionsDataObjectsService(self)
    self.projects_locations_collections_indexes = self.ProjectsLocationsCollectionsIndexesService(self)
    self.projects_locations_collections = self.ProjectsLocationsCollectionsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsCollectionsDataObjectsService(base_api.BaseApiService):
    """Service class for the projects_locations_collections_dataObjects resource."""

    _NAME = 'projects_locations_collections_dataObjects'

    def __init__(self, client):
      super(VectorsearchV1beta.ProjectsLocationsCollectionsDataObjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def Aggregate(self, request, global_params=None):
      r"""Aggregates data objects.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsAggregateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaAggregateDataObjectsResponse) The response message.
      """
      config = self.GetMethodConfig('Aggregate')
      return self._RunMethod(
          config, request, global_params=global_params)

    Aggregate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects:aggregate',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.dataObjects.aggregate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1beta/{+parent}/dataObjects:aggregate',
        request_field='googleCloudVectorsearchV1betaAggregateDataObjectsRequest',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsAggregateRequest',
        response_type_name='GoogleCloudVectorsearchV1betaAggregateDataObjectsResponse',
        supports_download=False,
    )

    def BatchCreate(self, request, global_params=None):
      r"""Creates a batch of dataObjects.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsBatchCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaBatchCreateDataObjectsResponse) The response message.
      """
      config = self.GetMethodConfig('BatchCreate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchCreate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects:batchCreate',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.dataObjects.batchCreate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1beta/{+parent}/dataObjects:batchCreate',
        request_field='googleCloudVectorsearchV1betaBatchCreateDataObjectsRequest',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsBatchCreateRequest',
        response_type_name='GoogleCloudVectorsearchV1betaBatchCreateDataObjectsResponse',
        supports_download=False,
    )

    def BatchDelete(self, request, global_params=None):
      r"""Deletes dataObjects in a batch.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsBatchDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('BatchDelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchDelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects:batchDelete',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.dataObjects.batchDelete',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1beta/{+parent}/dataObjects:batchDelete',
        request_field='googleCloudVectorsearchV1betaBatchDeleteDataObjectsRequest',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsBatchDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def BatchSearch(self, request, global_params=None):
      r"""Batch searches data objects.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsBatchSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaBatchSearchDataObjectsResponse) The response message.
      """
      config = self.GetMethodConfig('BatchSearch')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchSearch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects:batchSearch',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.dataObjects.batchSearch',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1beta/{+parent}/dataObjects:batchSearch',
        request_field='googleCloudVectorsearchV1betaBatchSearchDataObjectsRequest',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsBatchSearchRequest',
        response_type_name='GoogleCloudVectorsearchV1betaBatchSearchDataObjectsResponse',
        supports_download=False,
    )

    def BatchUpdate(self, request, global_params=None):
      r"""Updates dataObjects in a batch.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsBatchUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaBatchUpdateDataObjectsResponse) The response message.
      """
      config = self.GetMethodConfig('BatchUpdate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchUpdate.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects:batchUpdate',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.dataObjects.batchUpdate',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1beta/{+parent}/dataObjects:batchUpdate',
        request_field='googleCloudVectorsearchV1betaBatchUpdateDataObjectsRequest',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsBatchUpdateRequest',
        response_type_name='GoogleCloudVectorsearchV1betaBatchUpdateDataObjectsResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a dataObject.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaDataObject) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.dataObjects.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['dataObjectId'],
        relative_path='v1beta/{+parent}/dataObjects',
        request_field='googleCloudVectorsearchV1betaDataObject',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsCreateRequest',
        response_type_name='GoogleCloudVectorsearchV1betaDataObject',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a dataObject.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects/{dataObjectsId}',
        http_method='DELETE',
        method_id='vectorsearch.projects.locations.collections.dataObjects.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['etag'],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a data object.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaDataObject) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects/{dataObjectsId}',
        http_method='GET',
        method_id='vectorsearch.projects.locations.collections.dataObjects.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsGetRequest',
        response_type_name='GoogleCloudVectorsearchV1betaDataObject',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a dataObject.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaDataObject) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects/{dataObjectsId}',
        http_method='PATCH',
        method_id='vectorsearch.projects.locations.collections.dataObjects.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1beta/{+name}',
        request_field='googleCloudVectorsearchV1betaDataObject',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsPatchRequest',
        response_type_name='GoogleCloudVectorsearchV1betaDataObject',
        supports_download=False,
    )

    def Query(self, request, global_params=None):
      r"""Queries data objects.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsQueryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaQueryDataObjectsResponse) The response message.
      """
      config = self.GetMethodConfig('Query')
      return self._RunMethod(
          config, request, global_params=global_params)

    Query.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects:query',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.dataObjects.query',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1beta/{+parent}/dataObjects:query',
        request_field='googleCloudVectorsearchV1betaQueryDataObjectsRequest',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsQueryRequest',
        response_type_name='GoogleCloudVectorsearchV1betaQueryDataObjectsResponse',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches data objects.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDataObjectsSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaSearchDataObjectsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/dataObjects:search',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.dataObjects.search',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1beta/{+parent}/dataObjects:search',
        request_field='googleCloudVectorsearchV1betaSearchDataObjectsRequest',
        request_type_name='VectorsearchProjectsLocationsCollectionsDataObjectsSearchRequest',
        response_type_name='GoogleCloudVectorsearchV1betaSearchDataObjectsResponse',
        supports_download=False,
    )

  class ProjectsLocationsCollectionsIndexesService(base_api.BaseApiService):
    """Service class for the projects_locations_collections_indexes resource."""

    _NAME = 'projects_locations_collections_indexes'

    def __init__(self, client):
      super(VectorsearchV1beta.ProjectsLocationsCollectionsIndexesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Index in a given project and location.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsIndexesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/indexes',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.indexes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['indexId', 'requestId'],
        relative_path='v1beta/{+parent}/indexes',
        request_field='googleCloudVectorsearchV1betaIndex',
        request_type_name='VectorsearchProjectsLocationsCollectionsIndexesCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Index.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsIndexesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/indexes/{indexesId}',
        http_method='DELETE',
        method_id='vectorsearch.projects.locations.collections.indexes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsCollectionsIndexesDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Index.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsIndexesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaIndex) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/indexes/{indexesId}',
        http_method='GET',
        method_id='vectorsearch.projects.locations.collections.indexes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsCollectionsIndexesGetRequest',
        response_type_name='GoogleCloudVectorsearchV1betaIndex',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Indexes in a given project and location.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsIndexesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaListIndexesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}/indexes',
        http_method='GET',
        method_id='vectorsearch.projects.locations.collections.indexes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta/{+parent}/indexes',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsCollectionsIndexesListRequest',
        response_type_name='GoogleCloudVectorsearchV1betaListIndexesResponse',
        supports_download=False,
    )

  class ProjectsLocationsCollectionsService(base_api.BaseApiService):
    """Service class for the projects_locations_collections resource."""

    _NAME = 'projects_locations_collections'

    def __init__(self, client):
      super(VectorsearchV1beta.ProjectsLocationsCollectionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Collection in a given project and location.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['collectionId', 'requestId'],
        relative_path='v1beta/{+parent}/collections',
        request_field='googleCloudVectorsearchV1betaCollection',
        request_type_name='VectorsearchProjectsLocationsCollectionsCreateRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Collection.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}',
        http_method='DELETE',
        method_id='vectorsearch.projects.locations.collections.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsCollectionsDeleteRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def ExportDataObjects(self, request, global_params=None):
      r"""Initiates a Long-Running Operation to export DataObjects from a Collection.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsExportDataObjectsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('ExportDataObjects')
      return self._RunMethod(
          config, request, global_params=global_params)

    ExportDataObjects.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}:exportDataObjects',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.exportDataObjects',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}:exportDataObjects',
        request_field='googleCloudVectorsearchV1betaExportDataObjectsRequest',
        request_type_name='VectorsearchProjectsLocationsCollectionsExportDataObjectsRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Collection.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaCollection) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}',
        http_method='GET',
        method_id='vectorsearch.projects.locations.collections.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsCollectionsGetRequest',
        response_type_name='GoogleCloudVectorsearchV1betaCollection',
        supports_download=False,
    )

    def ImportDataObjects(self, request, global_params=None):
      r"""Initiates a Long-Running Operation to import DataObjects into a Collection.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsImportDataObjectsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('ImportDataObjects')
      return self._RunMethod(
          config, request, global_params=global_params)

    ImportDataObjects.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}:importDataObjects',
        http_method='POST',
        method_id='vectorsearch.projects.locations.collections.importDataObjects',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}:importDataObjects',
        request_field='googleCloudVectorsearchV1betaImportDataObjectsRequest',
        request_type_name='VectorsearchProjectsLocationsCollectionsImportDataObjectsRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Collections in a given project and location.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudVectorsearchV1betaListCollectionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections',
        http_method='GET',
        method_id='vectorsearch.projects.locations.collections.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1beta/{+parent}/collections',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsCollectionsListRequest',
        response_type_name='GoogleCloudVectorsearchV1betaListCollectionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Collection.

      Args:
        request: (VectorsearchProjectsLocationsCollectionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/collections/{collectionsId}',
        http_method='PATCH',
        method_id='vectorsearch.projects.locations.collections.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1beta/{+name}',
        request_field='googleCloudVectorsearchV1betaCollection',
        request_type_name='VectorsearchProjectsLocationsCollectionsPatchRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(VectorsearchV1beta.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (VectorsearchProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='vectorsearch.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}:cancel',
        request_field='googleLongrunningCancelOperationRequest',
        request_type_name='VectorsearchProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (VectorsearchProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='vectorsearch.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (VectorsearchProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningOperation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='vectorsearch.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsOperationsGetRequest',
        response_type_name='GoogleLongrunningOperation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (VectorsearchProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleLongrunningListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='vectorsearch.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1beta/{+name}/operations',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsOperationsListRequest',
        response_type_name='GoogleLongrunningListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(VectorsearchV1beta.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (VectorsearchProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudLocationLocation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='vectorsearch.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1beta/{+name}',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsGetRequest',
        response_type_name='GoogleCloudLocationLocation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service. This method can be called in two ways: * **List all public locations:** Use the path `GET /v1/locations`. * **List project-visible locations:** Use the path `GET /v1/projects/{project_id}/locations`. This may include public locations as well as private or other locations specifically visible to the project.

      Args:
        request: (VectorsearchProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleCloudLocationListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1beta/projects/{projectsId}/locations',
        http_method='GET',
        method_id='vectorsearch.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1beta/{+name}/locations',
        request_field='',
        request_type_name='VectorsearchProjectsLocationsListRequest',
        response_type_name='GoogleCloudLocationListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(VectorsearchV1beta.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
