# -*- coding: utf-8 -*- #
# Copyright 2021 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Utilities for Policy Analyzer API."""


from googlecloudsdk.api_lib.util import apis

_API_NAME = 'policyanalyzer'

_API_VERSION_V1BETA1 = 'v1beta1'
_API_VERSION_V1 = 'v1'


def GetClientAndMessages():
  # All release tracks map to v1
  return apis.GetClientInstance(_API_NAME,
                                _API_VERSION_V1), apis.GetMessagesModule(
                                    _API_NAME, _API_VERSION_V1)
