"""Generated message classes for hypercomputecluster version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'hypercomputecluster'


class Artifacts(_messages.Message):
  r"""Represents information about the artifacts of the Machine Learning Run.

  Fields:
    gcsPath: Required. The Cloud Storage path where the artifacts of the run
      are stored. Example: `gs://my-bucket/my-run-directory`.
  """

  gcsPath = _messages.StringField(1)


class AtmTag(_messages.Message):
  r"""Message describing ATM Tag object

  Fields:
    key: Required. Key of the ATM tag
    value: Required. Value of the ATM tag
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class BucketReference(_messages.Message):
  r"""BucketReference describes the underlying bucket resource.

  Fields:
    bucket: Output only. Name of the bucket
  """

  bucket = _messages.StringField(1)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Cluster(_messages.Message):
  r"""Message describing Cluster object

  Messages:
    ComputeResourcesValue: Optional. Compute resources. where key is string ID
      of the compute resource.
    LabelsValue: Optional. Labels as key value pairs
    NetworkResourcesValue: Optional. Network resources. where key is string ID
      of the network resource.
    StorageResourcesValue: Optional. Storage resources. where key is string ID
      of the storage resource.

  Fields:
    compute: Optional. Compute Engine instances
    computeResources: Optional. Compute resources. where key is string ID of
      the compute resource.
    createTime: Output only. Creation time of the cluster
    description: Optional. Description of the cluster
    labels: Optional. Labels as key value pairs
    name: Identifier. Name of the cluster
    networkResources: Optional. Network resources. where key is string ID of
      the network resource.
    networks: Optional. List of networks
    orchestrator: Optional. Orchestrator of the cluster
    reconciling: Output only. Whether the cluster is being reconciled.
    storageResources: Optional. Storage resources. where key is string ID of
      the storage resource.
    storages: Optional. List of storages
    updateTime: Output only. Update time of the cluster
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ComputeResourcesValue(_messages.Message):
    r"""Optional. Compute resources. where key is string ID of the compute
    resource.

    Messages:
      AdditionalProperty: An additional property for a ComputeResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        ComputeResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ComputeResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A ComputeResource attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ComputeResource', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class NetworkResourcesValue(_messages.Message):
    r"""Optional. Network resources. where key is string ID of the network
    resource.

    Messages:
      AdditionalProperty: An additional property for a NetworkResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        NetworkResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a NetworkResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A NetworkResource attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('NetworkResource', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StorageResourcesValue(_messages.Message):
    r"""Optional. Storage resources. where key is string ID of the storage
    resource.

    Messages:
      AdditionalProperty: An additional property for a StorageResourcesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        StorageResourcesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a StorageResourcesValue object.

      Fields:
        key: Name of the additional property.
        value: A StorageResource attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('StorageResource', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  compute = _messages.MessageField('Compute', 1)
  computeResources = _messages.MessageField('ComputeResourcesValue', 2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  networkResources = _messages.MessageField('NetworkResourcesValue', 7)
  networks = _messages.MessageField('Network', 8, repeated=True)
  orchestrator = _messages.MessageField('Orchestrator', 9)
  reconciling = _messages.BooleanField(10)
  storageResources = _messages.MessageField('StorageResourcesValue', 11)
  storages = _messages.MessageField('Storage', 12, repeated=True)
  updateTime = _messages.StringField(13)


class Compute(_messages.Message):
  r"""Message describing Compute object

  Fields:
    atmTags: Optional. ATM Tags to attach to compute VM instances
    resourceRequests: Required. Source of compute resource
  """

  atmTags = _messages.MessageField('AtmTag', 1, repeated=True)
  resourceRequests = _messages.MessageField('ResourceRequest', 2, repeated=True)


class ComputeInstance(_messages.Message):
  r"""Compute instance details.

  Fields:
    instance: Output only. Name of the instance.
  """

  instance = _messages.StringField(1)


class ComputeInstanceSlurmNodeSet(_messages.Message):
  r"""Message describing Compute Instance Slurm NodeSet object

  Messages:
    LabelsValue: Optional. Labels for the nodeset

  Fields:
    labels: Optional. Labels for the nodeset
    startupScript: Optional. Startup script for the nodeset
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels for the nodeset

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  startupScript = _messages.StringField(2)


class ComputeNetworkReference(_messages.Message):
  r"""ComputeNetworkReference describes which underlying Compute Engine's
  resource being represented.

  Fields:
    network: Output only. The name of the network.
    subnetwork: Output only. Subnetwork of the network.
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class ComputeResource(_messages.Message):
  r"""ComputeResource represents a compute resource of a cluster.

  Fields:
    newDwsFlexInstances: New dws flex instance config
    newOnDemandInstances: New on demand instance config
    newReservedInstances: New reserved instance config
    newSpotInstances: New spot instance config
  """

  newDwsFlexInstances = _messages.MessageField('NewDWSFlexInstancesConfig', 1)
  newOnDemandInstances = _messages.MessageField('NewOnDemandInstancesConfig', 2)
  newReservedInstances = _messages.MessageField('NewReservedInstancesConfig', 3)
  newSpotInstances = _messages.MessageField('NewSpotInstancesConfig', 4)


class Configs(_messages.Message):
  r"""Configuration for a Machine Learning run.

  Messages:
    HardwareConfigsValue: Optional. Hardware configs.
    SoftwareConfigsValue: Optional. Software configs.
    UserConfigsValue: Optional. User defined configs.

  Fields:
    hardwareConfigs: Optional. Hardware configs.
    softwareConfigs: Optional. Software configs.
    userConfigs: Optional. User defined configs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HardwareConfigsValue(_messages.Message):
    r"""Optional. Hardware configs.

    Messages:
      AdditionalProperty: An additional property for a HardwareConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type HardwareConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HardwareConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SoftwareConfigsValue(_messages.Message):
    r"""Optional. Software configs.

    Messages:
      AdditionalProperty: An additional property for a SoftwareConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SoftwareConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SoftwareConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserConfigsValue(_messages.Message):
    r"""Optional. User defined configs.

    Messages:
      AdditionalProperty: An additional property for a UserConfigsValue
        object.

    Fields:
      additionalProperties: Additional properties of type UserConfigsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UserConfigsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  hardwareConfigs = _messages.MessageField('HardwareConfigsValue', 1)
  softwareConfigs = _messages.MessageField('SoftwareConfigsValue', 2)
  userConfigs = _messages.MessageField('UserConfigsValue', 3)


class ContainerNodePoolSlurmNodeSet(_messages.Message):
  r"""Message describing Container NodePool Slurm NodeSet object"""


class Disk(_messages.Message):
  r"""Message describing Disk object

  Fields:
    boot: Optional. Whether the disk is a boot disk
    sizeGb: Required. Size of the disk
    sourceImage: Optional. Source image for the disk
    type: Required. Type of the disk
  """

  boot = _messages.BooleanField(1)
  sizeGb = _messages.IntegerField(2)
  sourceImage = _messages.StringField(3)
  type = _messages.StringField(4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ExistingBucketConfig(_messages.Message):
  r"""ExistingBucketConfig describes the config to use an existing bucket.

  Fields:
    bucket: Immutable. Name of the bucket
  """

  bucket = _messages.StringField(1)


class ExistingComputeNetworkConfig(_messages.Message):
  r"""ExistingComputeNetworkConfig represents the configuration of an existing
  compute network which will be used by the cluster.

  Fields:
    network: Immutable. The name of the network.
    subnetwork: Immutable. Subnetwork of the network.
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class ExistingFilestoreConfig(_messages.Message):
  r"""ExistingFilestoreConfig describes the config to use an existing
  filestore.

  Fields:
    filestore: Immutable. Name of the filestore
  """

  filestore = _messages.StringField(1)


class ExistingLustreConfig(_messages.Message):
  r"""ExistingLustreConfig describes the config to use an existing lustre.

  Fields:
    lustre: Immutable. Name of the lustre
  """

  lustre = _messages.StringField(1)


class ExistingNetworkConfig(_messages.Message):
  r"""ExistingNetworkConfig represents the configuration of an existing
  network which will be used by the cluster.

  Fields:
    network: Immutable. The name of the network.
    subnetwork: Immutable. Subnetwork of the network.
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class FileShareConfig(_messages.Message):
  r"""Message describing filestore configuration

  Fields:
    capacityGb: Required. Size of the filestore in GB
    fileShare: Required. Filestore share location
  """

  capacityGb = _messages.IntegerField(1)
  fileShare = _messages.StringField(2)


class FilestoreInitializeParams(_messages.Message):
  r"""Message describing initialize params for filestore

  Enums:
    ProtocolValueValuesEnum: Optional. The protocol of the filestore
    TierValueValuesEnum: Required. The service tier of the filestore

  Fields:
    description: Optional. Description of the filestore
    fileShares: Required. File share configuration
    filestore: Required. Name of the filestore
    protocol: Optional. The protocol of the filestore
    tier: Required. The service tier of the filestore
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. The protocol of the filestore

    Values:
      PROTOCOL_UNSPECIFIED: Unspecified filestore protocol
      PROTOCOL_NFSV3: NFSv3
      PROTOCOL_NFSV41: NFSv4.1
    """
    PROTOCOL_UNSPECIFIED = 0
    PROTOCOL_NFSV3 = 1
    PROTOCOL_NFSV41 = 2

  class TierValueValuesEnum(_messages.Enum):
    r"""Required. The service tier of the filestore

    Values:
      TIER_UNSPECIFIED: Unspecified filestore tier
      TIER_BASIC_HDD: Basic HDD filestore tier
      TIER_BASIC_SSD: Basic SSD filestore tier
      TIER_HIGH_SCALE_SSD: High scale SSD filestore tier
      TIER_ZONAL: Zonal filestore tier
      TIER_ENTERPRISE: Enterprise filestore tier
      TIER_REGIONAL: Regional filestore tier
    """
    TIER_UNSPECIFIED = 0
    TIER_BASIC_HDD = 1
    TIER_BASIC_SSD = 2
    TIER_HIGH_SCALE_SSD = 3
    TIER_ZONAL = 4
    TIER_ENTERPRISE = 5
    TIER_REGIONAL = 6

  description = _messages.StringField(1)
  fileShares = _messages.MessageField('FileShareConfig', 2, repeated=True)
  filestore = _messages.StringField(3)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 4)
  tier = _messages.EnumField('TierValueValuesEnum', 5)


class FilestoreReference(_messages.Message):
  r"""FilestoreReference describes the underlying filestore resource.

  Fields:
    filestore: Output only. Name of the filestore
  """

  filestore = _messages.StringField(1)


class GcsAutoclassConfig(_messages.Message):
  r"""Message describing Google Cloud Storage autoclass configuration

  Enums:
    TerminalStorageClassValueValuesEnum: Optional. Terminal storage class of
      the autoclass bucket

  Fields:
    enabled: Required. Enables Auto-class feature.
    terminalStorageClass: Optional. Terminal storage class of the autoclass
      bucket
  """

  class TerminalStorageClassValueValuesEnum(_messages.Enum):
    r"""Optional. Terminal storage class of the autoclass bucket

    Values:
      TERMINAL_STORAGE_CLASS_UNSPECIFIED: Unspecified terminal storage class
      TERMINAL_STORAGE_CLASS_NEARLINE: Nearline terminal storage class
      TERMINAL_STORAGE_CLASS_ARCHIVE: Archive terminal storage class
    """
    TERMINAL_STORAGE_CLASS_UNSPECIFIED = 0
    TERMINAL_STORAGE_CLASS_NEARLINE = 1
    TERMINAL_STORAGE_CLASS_ARCHIVE = 2

  enabled = _messages.BooleanField(1)
  terminalStorageClass = _messages.EnumField('TerminalStorageClassValueValuesEnum', 2)


class GcsHierarchicalNamespaceConfig(_messages.Message):
  r"""Message describing Google Cloud Storage hierarchical namespace
  configuration

  Fields:
    enabled: Required. Enables hierarchical namespace setup for the bucket.
  """

  enabled = _messages.BooleanField(1)


class GcsInitializeParams(_messages.Message):
  r"""Message describing initialize params for Google Cloud Storage

  Enums:
    StorageClassValueValuesEnum: Default storage class for objects in the
      bucket.

  Fields:
    autoclass: Autoclass configuration for objects in the bucket.
    bucket: Required. Name of the bucket
    hierarchicalNamespace: Optional. The hierarchical namespace configuration
      of the bucket
    storageClass: Default storage class for objects in the bucket.
  """

  class StorageClassValueValuesEnum(_messages.Enum):
    r"""Default storage class for objects in the bucket.

    Values:
      STORAGE_CLASS_UNSPECIFIED: Unspecified storage class
      STORAGE_CLASS_STANDARD: Standard storage class
      STORAGE_CLASS_NEARLINE: Nearline storage class
      STORAGE_CLASS_COLDLINE: Coldline storage class
      STORAGE_CLASS_ARCHIVE: Archive storage class
    """
    STORAGE_CLASS_UNSPECIFIED = 0
    STORAGE_CLASS_STANDARD = 1
    STORAGE_CLASS_NEARLINE = 2
    STORAGE_CLASS_COLDLINE = 3
    STORAGE_CLASS_ARCHIVE = 4

  autoclass = _messages.MessageField('GcsAutoclassConfig', 1)
  bucket = _messages.StringField(2)
  hierarchicalNamespace = _messages.MessageField('GcsHierarchicalNamespaceConfig', 3)
  storageClass = _messages.EnumField('StorageClassValueValuesEnum', 4)


class GuestAccelerator(_messages.Message):
  r"""Message describing GuestAccelerator object

  Fields:
    acceleratorType: Optional. Accelerator type resource to attach to this
      instance
    count: Optional. Number of the guest accelerator cards exposed to this
      instance
  """

  acceleratorType = _messages.StringField(1)
  count = _messages.IntegerField(2)


class HypercomputeclusterProjectsLocationsClustersCreateRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: Required. Id of the requesting object
    parent: Required. Parent collection in which cluster is created Format:
      projects/{project}/locations/{locations}
    requestId: Optional. A unique identifier for this request
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class HypercomputeclusterProjectsLocationsClustersDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersDeleteRequest object.

  Fields:
    name: Required. Name of the cluster to delete. Format:
      projects/{project}/locations/{locations}/clusters/{cluster}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class HypercomputeclusterProjectsLocationsClustersGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersGetRequest object.

  Fields:
    name: Required. Name of the cluster to retrieve. Format:
      projects/{project}/locations/{location}/clusters/{cluster}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsClustersListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent collection which own list of clusters. Format:
      projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class HypercomputeclusterProjectsLocationsClustersPatchRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsClustersPatchRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    name: Identifier. Name of the cluster
    requestId: Optional. A unique identifier for this request
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Cluster resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields present in the request will be
      overwritten.
  """

  cluster = _messages.MessageField('Cluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class HypercomputeclusterProjectsLocationsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class HypercomputeclusterProjectsLocationsMachineLearningRunsCreateRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsCreateRequest
  object.

  Fields:
    machineLearningRun: A MachineLearningRun resource to be passed as the
      request body.
    machineLearningRunId: Optional. The ID of the Machine Learning Run to
      create.
    parent: Required. Parent format: projects/{project}/locations/{location}
  """

  machineLearningRun = _messages.MessageField('MachineLearningRun', 1)
  machineLearningRunId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsDeleteRequest
  object.

  Fields:
    etag: Optional. Etag for the run. Etag gets updated with every
      update/create operation. If provided, it must match the server's etag.
    name: Required. projects/{project}/locations/{location}/machineLearningRun
      s/{machineLearningRun}
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsGetRequest
  object.

  Fields:
    name: Required. projects/{project}/locations/{location}/machineLearningRun
      s/{machineLearningRun}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsListRequest
  object.

  Fields:
    filter: Optional. An expression for filtering the results of the request.
      Supported filter fields are: - run_id (string): The ID of the run (e.g.,
      "run-1"). - run_set (string): The run set (e.g., "run-set-1"). -
      display_name (string): The display name of the run (e.g., "display-
      name-1"). - state (enum): The state of the run (e.g.,
      "STATE_COMPLETED"). - region (string): The region of the run (e.g., "us-
      central1"). - orchestrator (enum): The orchestrator used for the run
      (e.g., "ORCHESTRATOR_GKE"). - create_time (timestamp): The creation
      timestamp of the run. - update_time (timestamp): The last update
      timestamp of the run. - etag (string): The ETag of the run. Filter
      expressions can be combined using "AND" and "OR" operators. Examples: To
      filter by a single field: `run_set = "run-set-1"` `state =
      "STATE_ACTIVE"` To filter by multiple fields: `run_set = "run-set-1" AND
      state = "STATE_ACTIVE"` `region = "us-central1" AND orchestrator =
      "ORCHESTRATOR_GKE"` To filter by timestamp: `create_time >
      "2025-05-26T10:00:00Z"`
    orderBy: Optional. A comma-separated list of fields to order by, sorted in
      ascending order. Use "desc" after a field name for descending. Supported
      fields: * `run_id` * `run_set` * `display_name` * `region` *
      `orchestrator` * `state` * `create_time` * `update_time` Example:
      `update_time desc, create_time`.
    pageSize: Optional. The maximum number of Machine Learning Runs to return.
      The service may return fewer than this value. If unspecified, at most 10
      Machine Learning Runs will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000. Please refer to
      https://google.aip.dev/158 for more details.
    pageToken: Optional. A page token, received from a previous
      `ListMachineLearningRuns` call. Provide this to retrieve the subsequent
      page. Please refer to https://google.aip.dev/158 for more details.
    parent: Required. projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsPatchRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsPatchRequest
  object.

  Fields:
    machineLearningRun: A MachineLearningRun resource to be passed as the
      request body.
    name: Identifier. The name of the Machine Learning run.
    updateMask: Optional. Used to identify fields to be updated. Allowed
      fields is *, we don't support partial updates.
  """

  machineLearningRun = _messages.MessageField('MachineLearningRun', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfileSessionsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfileSessions
  GetRequest object.

  Fields:
    name: Required. projects/{project}/locations/{location}/machineLearningRun
      s/{machineLearningRun}/profileSessions/{profileSession}
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsMachineLearningRunsProfileSessionsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsMachineLearningRunsProfileSessions
  ListRequest object.

  Fields:
    pageSize: Optional. The maximum number of Profile Sessions to return. The
      service may return fewer than this value. If unspecified, at most 50
      Profile Sessions will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListProfileSessions` call. Provide this to retrieve the subsequent
      page.
    parent: Required. Parent format: projects/{project}/locations/{location}/m
      achineLearningRuns/{machineLearningRun}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HypercomputeclusterProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class HypercomputeclusterProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class HypercomputeclusterProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A HypercomputeclusterProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ListClustersResponse(_messages.Message):
  r"""Message for response to listing Clusters

  Fields:
    clusters: The list of Cluster
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Locations that could not be reached.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMachineLearningRunsResponse(_messages.Message):
  r"""Response message for MachineLearningRuns.ListMachineLearningRuns.

  Fields:
    machineLearningRuns: The Machine Learning Runs.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  machineLearningRuns = _messages.MessageField('MachineLearningRun', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListProfileSessionsResponse(_messages.Message):
  r"""Response message for MachineLearningRuns.ListProfileSessions.

  Fields:
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
    profileSessions: A list of profile sessions.
  """

  nextPageToken = _messages.StringField(1)
  profileSessions = _messages.MessageField('ProfileSession', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LustreInitializeParams(_messages.Message):
  r"""Message describing initialize params for lustre

  Fields:
    capacityGb: Required. Size of the lustre instance in GB
    description: Optional. Description of the lustre instance
    filesystem: Required. Immutable. Filesystem of the lustre instance
    lustre: Required. Name of the lustre instance
  """

  capacityGb = _messages.IntegerField(1)
  description = _messages.StringField(2)
  filesystem = _messages.StringField(3)
  lustre = _messages.StringField(4)


class LustreReference(_messages.Message):
  r"""LustreReference describes the underlying lustre resource.

  Fields:
    lustre: Output only. Name of the lustre
  """

  lustre = _messages.StringField(1)


class MachineLearningRun(_messages.Message):
  r"""A Machine Learning run.

  Enums:
    OrchestratorValueValuesEnum: Required. The orchestrator used for the run.
    StateValueValuesEnum: Output only. State of the run.

  Messages:
    LabelsValue: Optional. Any custom labels for this run Example:
      type:workload, type:simulation etc.

  Fields:
    artifacts: Optional. Artifacts for the run.
    configs: Optional. Tracks configuration for this run, example: batch_size,
      jax_version, tpu_generation etc.
    createTime: Output only. Time when the run was created.
    displayName: Optional. Display name for the run.
    etag: Optional. ETag for the run. It must be provided for update/delete
      operations and must match the server's etag.
    labels: Optional. Any custom labels for this run Example: type:workload,
      type:simulation etc.
    metrics: Optional. Metrics for the run.
    name: Identifier. The name of the Machine Learning run.
    orchestrator: Required. The orchestrator used for the run.
    runSet: Required. Allows grouping of similar runs. * Helps improving UI
      rendering performance. * Allows comparing similar runs via fast filters.
    state: Output only. State of the run.
    tools: Required. List of tools enabled for this run example: XProf, NSys
    updateTime: Output only. Time when the run was last updated.
  """

  class OrchestratorValueValuesEnum(_messages.Enum):
    r"""Required. The orchestrator used for the run.

    Values:
      ORCHESTRATOR_UNSPECIFIED: Orchestrator type is not specified.
      GCE: Google Compute Engine orchestrator.
      GKE: Google Kubernetes Engine orchestrator.
      SLURM: Slurm cluster orchestrator.
    """
    ORCHESTRATOR_UNSPECIFIED = 0
    GCE = 1
    GKE = 2
    SLURM = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the run.

    Values:
      STATE_UNSPECIFIED: State is not specified.
      STATE_ACTIVE: Run is active.
      STATE_COMPLETED: Run is completed.
      STATE_FAILED: Run is failed.
    """
    STATE_UNSPECIFIED = 0
    STATE_ACTIVE = 1
    STATE_COMPLETED = 2
    STATE_FAILED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Any custom labels for this run Example: type:workload,
    type:simulation etc.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifacts = _messages.MessageField('Artifacts', 1)
  configs = _messages.MessageField('Configs', 2)
  createTime = _messages.StringField(3)
  displayName = _messages.StringField(4)
  etag = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  metrics = _messages.MessageField('Metrics', 7)
  name = _messages.StringField(8)
  orchestrator = _messages.EnumField('OrchestratorValueValuesEnum', 9)
  runSet = _messages.StringField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  tools = _messages.MessageField('Tool', 12, repeated=True)
  updateTime = _messages.StringField(13)


class Metrics(_messages.Message):
  r"""Metrics for a Machine Learning run.

  Fields:
    avgLatency: Output only. Average latency.
    avgMfu: Output only. Average Model Flops Utilization (MFU).
    avgStep: Output only. Average step time.
    avgThroughput: Output only. Average throughput. Value depends on the kind
      of workload ran on TPU.
  """

  avgLatency = _messages.StringField(1)
  avgMfu = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  avgStep = _messages.StringField(3)
  avgThroughput = _messages.FloatField(4, variant=_messages.Variant.FLOAT)


class Network(_messages.Message):
  r"""Message describing Network object

  Fields:
    initializeParams: Immutable. Parameters to initialize the network
    network: Output only. Name of the network
    networkSource: Immutable. Reference of existing network resource name
    subnetwork: Output only. Name of the subnetwork
  """

  initializeParams = _messages.MessageField('NetworkInitializeParams', 1)
  network = _messages.StringField(2)
  networkSource = _messages.MessageField('NetworkSource', 3)
  subnetwork = _messages.StringField(4)


class NetworkInitializeParams(_messages.Message):
  r"""Message describing initialize params for network object

  Fields:
    description: Optional. Description of the network
    network: Required. Name of the network
  """

  description = _messages.StringField(1)
  network = _messages.StringField(2)


class NetworkResource(_messages.Message):
  r"""NetworkResource represents a network resource of a cluster.

  Fields:
    computeNetwork: Compute network reference.
    config: Immutable. Configuration to initialize the network resource.
  """

  computeNetwork = _messages.MessageField('ComputeNetworkReference', 1)
  config = _messages.MessageField('NetworkResourceConfig', 2)


class NetworkResourceConfig(_messages.Message):
  r"""NetworkResourceConfig describe how the network resource is initialized.

  Fields:
    existingComputeNetwork: Immutable. ExistingComputeNetworkConfig represents
      the configuration of an existing compute network which will be used by
      the cluster.
    existingNetwork: Immutable. ExistingNetworkConfig represents the
      configuration of an existing network which will be used by the cluster.
    newComputeNetwork: Immutable. NewComputeNetworkConfig represents the
      configuration to create a new compute network for the cluster.
    newNetwork: Immutable. NewNetworkConfig represents the configuration to
      create a new network for the cluster.
  """

  existingComputeNetwork = _messages.MessageField('ExistingComputeNetworkConfig', 1)
  existingNetwork = _messages.MessageField('ExistingNetworkConfig', 2)
  newComputeNetwork = _messages.MessageField('NewComputeNetworkConfig', 3)
  newNetwork = _messages.MessageField('NewNetworkConfig', 4)


class NetworkSource(_messages.Message):
  r"""Message describing network source for network object

  Fields:
    network: Required. Immutable. Name of the network
    subnetwork: Required. Subnetwork of the network
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class NewBucketConfig(_messages.Message):
  r"""NewBucketConfig describes the config to initialize a new bucket.

  Enums:
    StorageClassValueValuesEnum: Default storage class for objects in the
      bucket.

  Fields:
    autoclass: Autoclass configuration for objects in the bucket.
    bucket: Immutable. Name of the bucket
    hierarchicalNamespace: Optional. Immutable. The hierarchical namespace
      configuration of the bucket
    storageClass: Default storage class for objects in the bucket.
  """

  class StorageClassValueValuesEnum(_messages.Enum):
    r"""Default storage class for objects in the bucket.

    Values:
      STORAGE_CLASS_UNSPECIFIED: Unspecified storage class
      STANDARD: Standard storage class
      NEARLINE: Nearline storage class
      COLDLINE: Coldline storage class
      ARCHIVE: Archive storage class
    """
    STORAGE_CLASS_UNSPECIFIED = 0
    STANDARD = 1
    NEARLINE = 2
    COLDLINE = 3
    ARCHIVE = 4

  autoclass = _messages.MessageField('GcsAutoclassConfig', 1)
  bucket = _messages.StringField(2)
  hierarchicalNamespace = _messages.MessageField('GcsHierarchicalNamespaceConfig', 3)
  storageClass = _messages.EnumField('StorageClassValueValuesEnum', 4)


class NewComputeNetworkConfig(_messages.Message):
  r"""NewComputeNetworkConfig represents the configuration to create a new
  compute network for the cluster.

  Fields:
    description: Immutable. Description of the network.
    network: Immutable. The name of the network.
  """

  description = _messages.StringField(1)
  network = _messages.StringField(2)


class NewDWSFlexInstancesConfig(_messages.Message):
  r"""NewDWSFlexInstancesConfig describes the config to create new dws flex
  instances.

  Messages:
    AtmTagsValue: Immutable. Map atm tags to attach to the instance

  Fields:
    atmTags: Immutable. Map atm tags to attach to the instance
    machineType: Immutable. Machine type of the instance
    maxDuration: Immutable. Max duration of the instance
    zone: Immutable. Zone of the instance
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AtmTagsValue(_messages.Message):
    r"""Immutable. Map atm tags to attach to the instance

    Messages:
      AdditionalProperty: An additional property for a AtmTagsValue object.

    Fields:
      additionalProperties: Additional properties of type AtmTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AtmTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  atmTags = _messages.MessageField('AtmTagsValue', 1)
  machineType = _messages.StringField(2)
  maxDuration = _messages.StringField(3)
  zone = _messages.StringField(4)


class NewFilestoreConfig(_messages.Message):
  r"""NewFilestoreConfig describes the config to initialize a new filestore.

  Enums:
    ProtocolValueValuesEnum: Optional. Immutable. The protocol of the
      filestore
    TierValueValuesEnum: Required. Immutable. The service tier of the
      filestore

  Fields:
    description: Optional. Immutable. Description of the filestore
    fileShares: Required. Immutable. File share configuration
    filestore: Immutable. Name of the filestore
    protocol: Optional. Immutable. The protocol of the filestore
    tier: Required. Immutable. The service tier of the filestore
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Optional. Immutable. The protocol of the filestore

    Values:
      PROTOCOL_UNSPECIFIED: Unspecified filestore protocol
      NFSV3: NFSv3
      NFSV41: NFSv4.1
    """
    PROTOCOL_UNSPECIFIED = 0
    NFSV3 = 1
    NFSV41 = 2

  class TierValueValuesEnum(_messages.Enum):
    r"""Required. Immutable. The service tier of the filestore

    Values:
      TIER_UNSPECIFIED: Unspecified filestore tier
      BASIC_HDD: Basic HDD filestore tier
      BASIC_SSD: Basic SSD filestore tier
      HIGH_SCALE_SSD: High scale SSD filestore tier
      ZONAL: Zonal filestore tier
      ENTERPRISE: Enterprise filestore tier
      REGIONAL: Regional filestore tier
    """
    TIER_UNSPECIFIED = 0
    BASIC_HDD = 1
    BASIC_SSD = 2
    HIGH_SCALE_SSD = 3
    ZONAL = 4
    ENTERPRISE = 5
    REGIONAL = 6

  description = _messages.StringField(1)
  fileShares = _messages.MessageField('FileShareConfig', 2, repeated=True)
  filestore = _messages.StringField(3)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 4)
  tier = _messages.EnumField('TierValueValuesEnum', 5)


class NewLustreConfig(_messages.Message):
  r"""NewLustreConfig describes the config to initialize a new lustre.

  Fields:
    capacityGb: Required. Immutable. Size of the lustre instance in GB
    description: Optional. Immutable. Description of the lustre instance
    filesystem: Required. Immutable. Filesystem of the lustre instance
    lustre: Immutable. Name of the lustre
  """

  capacityGb = _messages.IntegerField(1)
  description = _messages.StringField(2)
  filesystem = _messages.StringField(3)
  lustre = _messages.StringField(4)


class NewNetworkConfig(_messages.Message):
  r"""NewNetworkConfig represents the configuration to create a new network
  for the cluster.

  Fields:
    description: Immutable. Description of the network.
    network: Immutable. The name of the network.
  """

  description = _messages.StringField(1)
  network = _messages.StringField(2)


class NewOnDemandInstancesConfig(_messages.Message):
  r"""NewOnDemandInstancesConfig describes the config to create new on demand
  instances.

  Messages:
    AtmTagsValue: Immutable. Map atm tags to attach to the instance

  Fields:
    atmTags: Immutable. Map atm tags to attach to the instance
    machineType: Immutable. Machine type of the instance
    zone: Immutable. Zone of the instance
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AtmTagsValue(_messages.Message):
    r"""Immutable. Map atm tags to attach to the instance

    Messages:
      AdditionalProperty: An additional property for a AtmTagsValue object.

    Fields:
      additionalProperties: Additional properties of type AtmTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AtmTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  atmTags = _messages.MessageField('AtmTagsValue', 1)
  machineType = _messages.StringField(2)
  zone = _messages.StringField(3)


class NewReservedInstancesConfig(_messages.Message):
  r"""NewReservedInstancesConfig describes the config to create new reserved
  instances.

  Messages:
    AtmTagsValue: Immutable. Map atm tags to attach to the instance

  Fields:
    atmTags: Immutable. Map atm tags to attach to the instance
    reservation: Immutable. Reservation name of the instance
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AtmTagsValue(_messages.Message):
    r"""Immutable. Map atm tags to attach to the instance

    Messages:
      AdditionalProperty: An additional property for a AtmTagsValue object.

    Fields:
      additionalProperties: Additional properties of type AtmTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AtmTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  atmTags = _messages.MessageField('AtmTagsValue', 1)
  reservation = _messages.StringField(2)


class NewSpotInstancesConfig(_messages.Message):
  r"""NewSpotInstancesConfig describes the config to create new spot
  instances.

  Messages:
    AtmTagsValue: Immutable. Map atm tags to attach to the instance

  Fields:
    atmTags: Immutable. Map atm tags to attach to the instance
    machineType: Immutable. Machine type of the instance
    zone: Immutable. Zone of the instance
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AtmTagsValue(_messages.Message):
    r"""Immutable. Map atm tags to attach to the instance

    Messages:
      AdditionalProperty: An additional property for a AtmTagsValue object.

    Fields:
      additionalProperties: Additional properties of type AtmTagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AtmTagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  atmTags = _messages.MessageField('AtmTagsValue', 1)
  machineType = _messages.StringField(2)
  zone = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have google.longrunning.Operation.error value
      with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  target = _messages.StringField(5)
  verb = _messages.StringField(6)


class Orchestrator(_messages.Message):
  r"""Message describing Orchestrator object

  Fields:
    slurm: Simple Linux Utility for Resource Management
  """

  slurm = _messages.MessageField('SlurmOrchestrator', 1)


class ProfileSession(_messages.Message):
  r"""Represents a single profiling session.

  Fields:
    createTime: Output only. The creation time of the session.
    gcsPath: Output only. The cloud storage path of the session. Example:
      `gs://my-bucket/my-run-directory/session-1`.
    name: Identifier. The name of the profile session. Format: projects/{proje
      ct}/locations/{location}/machineLearningRuns/{machine_learning_run}/prof
      ileSessions/{profile_session}
  """

  createTime = _messages.StringField(1)
  gcsPath = _messages.StringField(2)
  name = _messages.StringField(3)


class ReservationAffinity(_messages.Message):
  r"""Message describing ReservationAffinity object

  Enums:
    TypeValueValuesEnum: Required. Specifies the type of reservation instance
      can consume resources

  Fields:
    key: Optional. Label key of a reservation resource
    type: Required. Specifies the type of reservation instance can consume
      resources
    values: Optional. Label values of a reservation resource
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Specifies the type of reservation instance can consume
    resources

    Values:
      RESERVATION_TYPE_UNSPECIFIED: Unspecified reservation type
      RESERVATION_TYPE_NO_RESERVATION: No reservation type
      RESERVATION_TYPE_ANY_RESERVATION: Any reservation type
      RESERVATION_TYPE_SPECIFIC_RESERVATION: Specific reservation type
    """
    RESERVATION_TYPE_UNSPECIFIED = 0
    RESERVATION_TYPE_NO_RESERVATION = 1
    RESERVATION_TYPE_ANY_RESERVATION = 2
    RESERVATION_TYPE_SPECIFIC_RESERVATION = 3

  key = _messages.StringField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)
  values = _messages.StringField(3, repeated=True)


class ResourceRequest(_messages.Message):
  r"""Message describing resource request object

  Enums:
    ProvisioningModelValueValuesEnum: Optional. Specifies the provisioning
      model of the instance
    TerminationActionValueValuesEnum: Optional. Specifies the termination
      action of the instance

  Fields:
    disks: Optional. Array of disks associated with this instance
    guestAccelerators: Optional. Type and count of accelerator cards attached
      to the instance
    id: Required. Id of resource request
    machineType: Required. Type of the machine e.g. c2-standard-60
    maxRunDuration: Optional. Max amount of time instance is allowed to run
    provisioningModel: Optional. Specifies the provisioning model of the
      instance
    reservationAffinity: Optional. Reservations this instance can consume from
    terminationAction: Optional. Specifies the termination action of the
      instance
    zone: Required. Zone of the selected locations
  """

  class ProvisioningModelValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the provisioning model of the instance

    Values:
      PROVISIONING_MODEL_UNSPECIFIED: Unspecified provisioning model
      PROVISIONING_MODEL_STANDARD: Standard provisioning model
      PROVISIONING_MODEL_SPOT: Spot provisioning model
      PROVISIONING_MODEL_FLEX_START: Flex Start provisioning model
      PROVISIONING_MODEL_RESERVATION_BOUND: Reservation Bound provisioning
        model
    """
    PROVISIONING_MODEL_UNSPECIFIED = 0
    PROVISIONING_MODEL_STANDARD = 1
    PROVISIONING_MODEL_SPOT = 2
    PROVISIONING_MODEL_FLEX_START = 3
    PROVISIONING_MODEL_RESERVATION_BOUND = 4

  class TerminationActionValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the termination action of the instance

    Values:
      TERMINATION_ACTION_UNSPECIFIED: Unspecified termination action
      TERMINATION_ACTION_STOP: Stop the instance
      TERMINATION_ACTION_DELETE: Delete the instance
    """
    TERMINATION_ACTION_UNSPECIFIED = 0
    TERMINATION_ACTION_STOP = 1
    TERMINATION_ACTION_DELETE = 2

  disks = _messages.MessageField('Disk', 1, repeated=True)
  guestAccelerators = _messages.MessageField('GuestAccelerator', 2, repeated=True)
  id = _messages.StringField(3)
  machineType = _messages.StringField(4)
  maxRunDuration = _messages.IntegerField(5)
  provisioningModel = _messages.EnumField('ProvisioningModelValueValuesEnum', 6)
  reservationAffinity = _messages.MessageField('ReservationAffinity', 7)
  terminationAction = _messages.EnumField('TerminationActionValueValuesEnum', 8)
  zone = _messages.StringField(9)


class ServiceAccount(_messages.Message):
  r"""Service account email and scopes

  Fields:
    email: Optional. Service account email
    scopes: Optional. Service account scopes
  """

  email = _messages.StringField(1)
  scopes = _messages.StringField(2, repeated=True)


class SlurmConfig(_messages.Message):
  r"""Slurm orchestrator configuration. Values correspond to a subset of those
  found in https://slurm.schedmd.com/slurm.conf.html.

  Enums:
    AccountingStorageEnforceFlagsValueListEntryValuesEnum:
    PreemptModeValueListEntryValuesEnum:
    PreemptTypeValueValuesEnum: Optional. Specifies the plugin used to
      identify which jobs can be preempted in order to start a pending job.
    PriorityTypeValueValuesEnum: Optional. Specifies the plugin to be used in
      establishing a job's scheduling priority. Set this value to
      "priority/multifactor" to enable the Multifactor Job Priority Plugin.
    PrologFlagsValueListEntryValuesEnum:

  Fields:
    accountingStorageEnforceFlags: Optional. Flags to control the level of
      association-based enforcement to impose on job submissions. By default
      no flags are set. Corresponds to AccountingStorageEnforce.
    preemptExemptTime: Optional. Specifies minimum run time of jobs before
      they are considered for preemption.
    preemptMode: Optional. Specifies the mechanism used to preempt jobs or
      enable gang scheduling.
    preemptType: Optional. Specifies the plugin used to identify which jobs
      can be preempted in order to start a pending job.
    priorityType: Optional. Specifies the plugin to be used in establishing a
      job's scheduling priority. Set this value to "priority/multifactor" to
      enable the Multifactor Job Priority Plugin.
    priorityWeightAge: Optional. An unsigned integer that scales the
      contribution of the age factor.
    priorityWeightAssoc: Optional. An unsigned integer that scales the
      contribution of the association factor.
    priorityWeightFairshare: Optional. An unsigned integer that scales the
      contribution of the fair-share factor.
    priorityWeightJobSize: Optional. An unsigned integer that scales the
      contribution of the job size factor.
    priorityWeightPartition: Optional. An unsigned integer that scales the
      contribution of the partition factor.
    priorityWeightQos: Optional. An unsigned integer that scales the
      contribution of the quality of service factor.
    priorityWeightTres: Optional. A comma-separated list of TRES Types and
      weights that sets the degree that each TRES Type contributes to the
      job's priority.
    prologEpilogTimeout: Optional. The interval Slurm waits for Prolog and
      Epilog before terminating them. Default is 65534 seconds. Corresponds to
      PrologEpilogTimeout.
    prologFlags: Optional. Flags to control the Prolog behavior. By default no
      flags are set. Corresponds to PrologFlags.
    requeueExitCodes: Optional. Enables automatic requeue for batch jobs which
      exit with the specified values. Default is empty. Corresponds to
      RequeueExit.
    requeueHoldExitCodes: Optional. Enables automatic requeue for batch jobs
      which exit with the specified values, with these jobs being held until
      released manually by the user. Default is empty. Corresponds to
      RequeueExitHold.
  """

  class AccountingStorageEnforceFlagsValueListEntryValuesEnum(_messages.Enum):
    r"""AccountingStorageEnforceFlagsValueListEntryValuesEnum enum type.

    Values:
      ACCOUNTING_STORAGE_ENFORCE_FLAG_UNSPECIFIED: Unspecified accounting
        storage enforce flag.
      ALL: Implies all other available options except nojobs and nosteps.
      ASSOCIATIONS: No new job will be allowed to run unless a corresponding
        association exists in the system.
      LIMITS: Users will be limited by association to whatever job size or run
        time limits are defined. Implies associations.
      NOJOBS: Slurm will not account for any jobs or steps on the system.
        Implies nosteps.
      NOSTEPS: Slurm will not account for any steps that have run.
      QOS: Jobs will not be scheduled unless a valid qos is specified. Implies
        associations.
      SAFE: A job will only be launched against an association or qos that has
        a TRES-minutes limit set if the job will be able to run to completion.
        Without this option set, jobs will be launched as long as their usage
        hasn't reached the TRES-minutes limit. This can lead to jobs being
        launched but then killed when the limit is reached. With this option,
        a job won't be killed due to limits, even if the limits are changed
        after the job was started and the association or qos violates the
        updated limits. Implies limits and associations.
      WCKEYS: Jobs will not be scheduled unless a valid workload
        characterization key is specified. Implies associations and TrackWCKey
        (a separate configuration option).
    """
    ACCOUNTING_STORAGE_ENFORCE_FLAG_UNSPECIFIED = 0
    ALL = 1
    ASSOCIATIONS = 2
    LIMITS = 3
    NOJOBS = 4
    NOSTEPS = 5
    QOS = 6
    SAFE = 7
    WCKEYS = 8

  class PreemptModeValueListEntryValuesEnum(_messages.Enum):
    r"""PreemptModeValueListEntryValuesEnum enum type.

    Values:
      PREEMPT_MODE_UNSPECIFIED: Unspecified preempt mode.
      OFF: Is the default value and disables job preemption and gang
        scheduling.
      CANCEL: The preempted job will be cancelled
      GANG: Enables gang scheduling (time slicing) of jobs in the same
        partition, and allows the resuming of suspended jobs.
      REQUEUE: Preempts jobs by requeuing them (if possible) or canceling
        them.
      SUSPEND: The preempted jobs will be suspended, and later the Gang
        scheduler will resume them.
      PRIORITY: Allow preemption only if the preemptor's job priority is
        higher than the preemptee's job priority.
      WITHIN: Allow jobs within the same qos to preempt one another.
    """
    PREEMPT_MODE_UNSPECIFIED = 0
    OFF = 1
    CANCEL = 2
    GANG = 3
    REQUEUE = 4
    SUSPEND = 5
    PRIORITY = 6
    WITHIN = 7

  class PreemptTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the plugin used to identify which jobs can be
    preempted in order to start a pending job.

    Values:
      PREEMPT_TYPE_UNSPECIFIED: Unspecified preempt type.
      PREEMPT_NONE: Job preemption is disabled (default).
      PREEMPT_PARTITION_PRIO: Job preemption is based upon partition
        PriorityTier.
      PREEMPT_QOS: Job preemption rules are specified by Quality Of Service
        (QOS) specifications in the Slurm database.
    """
    PREEMPT_TYPE_UNSPECIFIED = 0
    PREEMPT_NONE = 1
    PREEMPT_PARTITION_PRIO = 2
    PREEMPT_QOS = 3

  class PriorityTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the plugin to be used in establishing a job's
    scheduling priority. Set this value to "priority/multifactor" to enable
    the Multifactor Job Priority Plugin.

    Values:
      PRIORITY_TYPE_UNSPECIFIED: Unspecified priority type.
      PRIORITY_BASIC: Jobs are evaluated in a First In, First Out (FIFO)
        manner.
      PRIORITY_MULTIFACTOR: Jobs are assigned a priority based upon a variety
        of factors that include size, age, Fairshare, etc.
    """
    PRIORITY_TYPE_UNSPECIFIED = 0
    PRIORITY_BASIC = 1
    PRIORITY_MULTIFACTOR = 2

  class PrologFlagsValueListEntryValuesEnum(_messages.Enum):
    r"""PrologFlagsValueListEntryValuesEnum enum type.

    Values:
      PROLOG_FLAG_UNSPECIFIED: Unspecified prolog flag.
      ALLOC: Prolog script will be executed at job allocation. NOTE: increases
        the time required to start jobs. Corresponds to Alloc.
      CONTAIN: Use the ProcTrack plugin to create a job container on all
        allocated compute nodes. Corresponds to Contain.
      DEFER_BATCH: Slurmctld will wait until the prolog completes on all
        allocated nodes before sending the batch job launch request.
        Corresponds to DeferBatch.
      NO_HOLD: If set, the ALLOC flag should also be set. This will allow for
        salloc to not block until the prolog is finished on each node.
        Corresponds to NoHold.
      FORCE_REQUEUE_ON_FAIL: Always requeue it automatically even if the job
        requested no requeues. NOTE: Setting this flag implicitly sets the
        ALLOC flag. Corresponds to ForceRequeueOnFail.
      RUN_IN_JOB: Make the Prolog/Epilog run in the extern slurmstepd.
        Corresponds to RunInJob.
      SERIAL: Force prolog and epilog scripts to run serially within each
        node. NOTE: This is incompatible with Serial.
      X11: Enable Slurm's built-in X11 forwarding capabilities. Corresponds to
        X11.
    """
    PROLOG_FLAG_UNSPECIFIED = 0
    ALLOC = 1
    CONTAIN = 2
    DEFER_BATCH = 3
    NO_HOLD = 4
    FORCE_REQUEUE_ON_FAIL = 5
    RUN_IN_JOB = 6
    SERIAL = 7
    X11 = 8

  accountingStorageEnforceFlags = _messages.EnumField('AccountingStorageEnforceFlagsValueListEntryValuesEnum', 1, repeated=True)
  preemptExemptTime = _messages.StringField(2)
  preemptMode = _messages.EnumField('PreemptModeValueListEntryValuesEnum', 3, repeated=True)
  preemptType = _messages.EnumField('PreemptTypeValueValuesEnum', 4)
  priorityType = _messages.EnumField('PriorityTypeValueValuesEnum', 5)
  priorityWeightAge = _messages.IntegerField(6)
  priorityWeightAssoc = _messages.IntegerField(7)
  priorityWeightFairshare = _messages.IntegerField(8)
  priorityWeightJobSize = _messages.IntegerField(9)
  priorityWeightPartition = _messages.IntegerField(10)
  priorityWeightQos = _messages.IntegerField(11)
  priorityWeightTres = _messages.StringField(12)
  prologEpilogTimeout = _messages.StringField(13)
  prologFlags = _messages.EnumField('PrologFlagsValueListEntryValuesEnum', 14, repeated=True)
  requeueExitCodes = _messages.IntegerField(15, repeated=True)
  requeueHoldExitCodes = _messages.IntegerField(16, repeated=True)


class SlurmLoginNodes(_messages.Message):
  r"""Message describing set of Slurm Login Node object

  Messages:
    LabelsValue: Optional. Labels for the login node

  Fields:
    count: Required. Number of login nodes to create
    disks: Required. Array of disks associated with the login node
    enableOsLogin: Optional. Whether to enable OS login for the login node
    enablePublicIps: Optional. Whether to enable public IPs for the login node
    instances: Output only. Compute instance details of the login nodes.
    labels: Optional. Labels for the login node
    machineType: Required. Type of the machine
    serviceAccount: Optional. Service account to be used by the nodes in the
      login nodeset.
    startupScript: Optional. Startup script for the login node
    storageConfigs: Optional. Storage configs
    zone: Required. Zone of the login node
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels for the login node

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  count = _messages.IntegerField(1)
  disks = _messages.MessageField('Disk', 2, repeated=True)
  enableOsLogin = _messages.BooleanField(3)
  enablePublicIps = _messages.BooleanField(4)
  instances = _messages.MessageField('ComputeInstance', 5, repeated=True)
  labels = _messages.MessageField('LabelsValue', 6)
  machineType = _messages.StringField(7)
  serviceAccount = _messages.MessageField('ServiceAccount', 8)
  startupScript = _messages.StringField(9)
  storageConfigs = _messages.MessageField('StorageConfig', 10, repeated=True)
  zone = _messages.StringField(11)


class SlurmNodeSet(_messages.Message):
  r"""Message describing Slurm NodeSet object

  Messages:
    LabelsValue: Optional. Labels for the nodeset

  Fields:
    bootDisk: Optional. Boot disk for the nodeset
    canIpForward: Optional. Whether login node can forward IP packets
    computeId: Optional. Compute id of the nodeset
    computeInstance: Optional. Compute instance details of the nodes.
    containerNodePool: Optional. Container node pool details of the nodes.
    enableOsLogin: Optional. Whether to enable OS login for the nodeset
    enablePublicIps: Optional. Whether to enable public IPs for the nodeset
    id: Required. Id of the nodeset
    labels: Optional. Labels for the nodeset
    maxDynamicNodeCount: Optional. Maximum number of auto-scaling nodes
      allowed in the nodeset
    resourceRequestId: Optional. Resource request id for the nodeset
    serviceAccount: Optional. Service account to be used by the nodes in the
      nodeset.
    startupScript: Optional. Startup script for the nodeset
    staticNodeCount: Optional. Number of nodes to be statically created
    storageConfigs: Optional. Storage configs
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels for the nodeset

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  bootDisk = _messages.MessageField('Disk', 1)
  canIpForward = _messages.BooleanField(2)
  computeId = _messages.StringField(3)
  computeInstance = _messages.MessageField('ComputeInstanceSlurmNodeSet', 4)
  containerNodePool = _messages.MessageField('ContainerNodePoolSlurmNodeSet', 5)
  enableOsLogin = _messages.BooleanField(6)
  enablePublicIps = _messages.BooleanField(7)
  id = _messages.StringField(8)
  labels = _messages.MessageField('LabelsValue', 9)
  maxDynamicNodeCount = _messages.IntegerField(10)
  resourceRequestId = _messages.StringField(11)
  serviceAccount = _messages.MessageField('ServiceAccount', 12)
  startupScript = _messages.StringField(13)
  staticNodeCount = _messages.IntegerField(14)
  storageConfigs = _messages.MessageField('StorageConfig', 15, repeated=True)


class SlurmOrchestrator(_messages.Message):
  r"""Message describing Slurm Orchestrator object

  Fields:
    config: Optional. Optional Slurm configuration available only in v1alpha.
    defaultPartition: Optional. Default partition
    epilogBashScripts: Optional. Custom bash scripts executed after each slurm
      job on every allocated node. Scripts will be copied to
      /slurm/custom_scripts/epilog.d/.
    loginNodes: Optional. Set of slurm login nodes
    nodeSets: Required. List of slurm nodesets
    partitions: Required. List of slurm partition
    prologBashScripts: Optional. Custom bash scripts executed before each
      slurm job on every allocated node. Scripts will be copied to
      /slurm/custom_scripts/prolog.d/.
    taskEpilogBashScripts: Optional. Custom bash scripts executed after each
      slurm task on every allocated node. Scripts will be copied to
      /slurm/custom_scripts/task_epilog.d/.
    taskPrologBashScripts: Optional. Custom bash scripts executed before each
      slurm task on every allocated node. Scripts will be copied to
      /slurm/custom_scripts/task_prolog.d/.
  """

  config = _messages.MessageField('SlurmConfig', 1)
  defaultPartition = _messages.StringField(2)
  epilogBashScripts = _messages.StringField(3, repeated=True)
  loginNodes = _messages.MessageField('SlurmLoginNodes', 4)
  nodeSets = _messages.MessageField('SlurmNodeSet', 5, repeated=True)
  partitions = _messages.MessageField('SlurmPartition', 6, repeated=True)
  prologBashScripts = _messages.StringField(7, repeated=True)
  taskEpilogBashScripts = _messages.StringField(8, repeated=True)
  taskPrologBashScripts = _messages.StringField(9, repeated=True)


class SlurmPartition(_messages.Message):
  r"""Message describing Slurm Partition object

  Fields:
    exclusive: Optional. Exclusive job access to nodes True: nodes execute
      single job and are deleted after job exits False: nodes can execute
      multiple jobs
    id: Required. Id of the slurm partiton
    nodeSetIds: Required. Nodeset for the slurm partition
  """

  exclusive = _messages.BooleanField(1)
  id = _messages.StringField(2)
  nodeSetIds = _messages.StringField(3, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Storage(_messages.Message):
  r"""Message describing Storage object

  Fields:
    id: Required. Storage id
    initializeParams: Immutable. Parameters to initialize the storage
    storage: Output only. Storage name
    storageSource: Immutable. Reference of existing storage
  """

  id = _messages.StringField(1)
  initializeParams = _messages.MessageField('StorageInitializeParams', 2)
  storage = _messages.StringField(3)
  storageSource = _messages.MessageField('StorageSource', 4)


class StorageConfig(_messages.Message):
  r"""Message describing StorageConfig object

  Fields:
    id: Required. Id of the storage
    localMount: Optional. Mountpoint for the storage
  """

  id = _messages.StringField(1)
  localMount = _messages.StringField(2)


class StorageInitializeParams(_messages.Message):
  r"""Message describing initialize params for storage object

  Fields:
    filestore: FileStore initialize params
    gcs: Google Cloud Storage initialize params
    lustre: Lustre initialize params
  """

  filestore = _messages.MessageField('FilestoreInitializeParams', 1)
  gcs = _messages.MessageField('GcsInitializeParams', 2)
  lustre = _messages.MessageField('LustreInitializeParams', 3)


class StorageResource(_messages.Message):
  r"""StorageResource represents a storage resource of a cluster.

  Fields:
    bucket: Bucket reference
    config: Optional. Describes config to initialize the storage resource.
    filestore: Filestore reference
    lustre: Lustre reference
  """

  bucket = _messages.MessageField('BucketReference', 1)
  config = _messages.MessageField('StorageResourceConfig', 2)
  filestore = _messages.MessageField('FilestoreReference', 3)
  lustre = _messages.MessageField('LustreReference', 4)


class StorageResourceConfig(_messages.Message):
  r"""StorageResourceConfig describes the config to initialize the storage
  resource.

  Fields:
    existingBucket: Existing bucket config
    existingFilestore: Existing filestore config
    existingLustre: Existing lustre config
    newBucket: New bucket config
    newFilestore: New filestore config
    newLustre: New lustre config
  """

  existingBucket = _messages.MessageField('ExistingBucketConfig', 1)
  existingFilestore = _messages.MessageField('ExistingFilestoreConfig', 2)
  existingLustre = _messages.MessageField('ExistingLustreConfig', 3)
  newBucket = _messages.MessageField('NewBucketConfig', 4)
  newFilestore = _messages.MessageField('NewFilestoreConfig', 5)
  newLustre = _messages.MessageField('NewLustreConfig', 6)


class StorageSource(_messages.Message):
  r"""Message describing source of storage

  Fields:
    bucket: Name of the existing Google Cloud Storage bucket
    filestore: Name of the existing filestore
    lustre: Name of the existing Lustre instance
  """

  bucket = _messages.StringField(1)
  filestore = _messages.StringField(2)
  lustre = _messages.StringField(3)


class Tool(_messages.Message):
  r"""A tool for a Machine Learning run.

  Fields:
    xprof: Required. XProf related metadata
  """

  xprof = _messages.MessageField('Xprof', 1)


class Xprof(_messages.Message):
  r"""XProf related metadata TODO(b/419397021) - Define or link XProf tool
  proto for run tools.

  Fields:
    sessionId: Required. TODO(b/419397021) - Add XProf related metadata.
  """

  sessionId = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
