// Code generated by go generate; DO NOT EDIT.
package sourcegraph

import "errors"

type Permission int

const (
    NoAccess Permission = iota
    UserRead Permission = iota
    SiteAdminFull Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        UserRead: "user:read",
        SiteAdminFull: "site_admin:full",
    }

    StringToPermission = map[string]Permission{
        "user:read": UserRead,
        "site_admin:full": SiteAdminFull,
    }

    PermissionIDs = map[Permission]int{
        UserRead: 0,
        SiteAdminFull: 1,
    }

    IdToPermission = map[int]Permission{
        0: UserRead,
        1: SiteAdminFull,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
