// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package mocks

import (
	"context"
	"sync"

	"github.com/umputun/spot/pkg/executor"
)

// InterfaceMock is a mock implementation of executor.Interface.
//
//	func TestSomethingThatUsesInterface(t *testing.T) {
//
//		// make and configure a mocked executor.Interface
//		mockedInterface := &InterfaceMock{
//			CloseFunc: func() error {
//				panic("mock out the Close method")
//			},
//			DeleteFunc: func(ctx context.Context, remoteFile string, opts *executor.DeleteOpts) error {
//				panic("mock out the Delete method")
//			},
//			DownloadFunc: func(ctx context.Context, remote string, local string, opts *executor.UpDownOpts) error {
//				panic("mock out the Download method")
//			},
//			RunFunc: func(ctx context.Context, c string, opts *executor.RunOpts) ([]string, error) {
//				panic("mock out the Run method")
//			},
//			SyncFunc: func(ctx context.Context, localDir string, remoteDir string, opts *executor.SyncOpts) ([]string, error) {
//				panic("mock out the Sync method")
//			},
//			UploadFunc: func(ctx context.Context, local string, remote string, opts *executor.UpDownOpts) error {
//				panic("mock out the Upload method")
//			},
//		}
//
//		// use mockedInterface in code that requires executor.Interface
//		// and then make assertions.
//
//	}
type InterfaceMock struct {
	// CloseFunc mocks the Close method.
	CloseFunc func() error

	// DeleteFunc mocks the Delete method.
	DeleteFunc func(ctx context.Context, remoteFile string, opts *executor.DeleteOpts) error

	// DownloadFunc mocks the Download method.
	DownloadFunc func(ctx context.Context, remote string, local string, opts *executor.UpDownOpts) error

	// RunFunc mocks the Run method.
	RunFunc func(ctx context.Context, c string, opts *executor.RunOpts) ([]string, error)

	// SyncFunc mocks the Sync method.
	SyncFunc func(ctx context.Context, localDir string, remoteDir string, opts *executor.SyncOpts) ([]string, error)

	// UploadFunc mocks the Upload method.
	UploadFunc func(ctx context.Context, local string, remote string, opts *executor.UpDownOpts) error

	// calls tracks calls to the methods.
	calls struct {
		// Close holds details about calls to the Close method.
		Close []struct {
		}
		// Delete holds details about calls to the Delete method.
		Delete []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// RemoteFile is the remoteFile argument value.
			RemoteFile string
			// Opts is the opts argument value.
			Opts *executor.DeleteOpts
		}
		// Download holds details about calls to the Download method.
		Download []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Remote is the remote argument value.
			Remote string
			// Local is the local argument value.
			Local string
			// Opts is the opts argument value.
			Opts *executor.UpDownOpts
		}
		// Run holds details about calls to the Run method.
		Run []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// C is the c argument value.
			C string
			// Opts is the opts argument value.
			Opts *executor.RunOpts
		}
		// Sync holds details about calls to the Sync method.
		Sync []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// LocalDir is the localDir argument value.
			LocalDir string
			// RemoteDir is the remoteDir argument value.
			RemoteDir string
			// Opts is the opts argument value.
			Opts *executor.SyncOpts
		}
		// Upload holds details about calls to the Upload method.
		Upload []struct {
			// Ctx is the ctx argument value.
			Ctx context.Context
			// Local is the local argument value.
			Local string
			// Remote is the remote argument value.
			Remote string
			// Opts is the opts argument value.
			Opts *executor.UpDownOpts
		}
	}
	lockClose    sync.RWMutex
	lockDelete   sync.RWMutex
	lockDownload sync.RWMutex
	lockRun      sync.RWMutex
	lockSync     sync.RWMutex
	lockUpload   sync.RWMutex
}

// Close calls CloseFunc.
func (mock *InterfaceMock) Close() error {
	if mock.CloseFunc == nil {
		panic("InterfaceMock.CloseFunc: method is nil but Interface.Close was just called")
	}
	callInfo := struct {
	}{}
	mock.lockClose.Lock()
	mock.calls.Close = append(mock.calls.Close, callInfo)
	mock.lockClose.Unlock()
	return mock.CloseFunc()
}

// CloseCalls gets all the calls that were made to Close.
// Check the length with:
//
//	len(mockedInterface.CloseCalls())
func (mock *InterfaceMock) CloseCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockClose.RLock()
	calls = mock.calls.Close
	mock.lockClose.RUnlock()
	return calls
}

// Delete calls DeleteFunc.
func (mock *InterfaceMock) Delete(ctx context.Context, remoteFile string, opts *executor.DeleteOpts) error {
	if mock.DeleteFunc == nil {
		panic("InterfaceMock.DeleteFunc: method is nil but Interface.Delete was just called")
	}
	callInfo := struct {
		Ctx        context.Context
		RemoteFile string
		Opts       *executor.DeleteOpts
	}{
		Ctx:        ctx,
		RemoteFile: remoteFile,
		Opts:       opts,
	}
	mock.lockDelete.Lock()
	mock.calls.Delete = append(mock.calls.Delete, callInfo)
	mock.lockDelete.Unlock()
	return mock.DeleteFunc(ctx, remoteFile, opts)
}

// DeleteCalls gets all the calls that were made to Delete.
// Check the length with:
//
//	len(mockedInterface.DeleteCalls())
func (mock *InterfaceMock) DeleteCalls() []struct {
	Ctx        context.Context
	RemoteFile string
	Opts       *executor.DeleteOpts
} {
	var calls []struct {
		Ctx        context.Context
		RemoteFile string
		Opts       *executor.DeleteOpts
	}
	mock.lockDelete.RLock()
	calls = mock.calls.Delete
	mock.lockDelete.RUnlock()
	return calls
}

// Download calls DownloadFunc.
func (mock *InterfaceMock) Download(ctx context.Context, remote string, local string, opts *executor.UpDownOpts) error {
	if mock.DownloadFunc == nil {
		panic("InterfaceMock.DownloadFunc: method is nil but Interface.Download was just called")
	}
	callInfo := struct {
		Ctx    context.Context
		Remote string
		Local  string
		Opts   *executor.UpDownOpts
	}{
		Ctx:    ctx,
		Remote: remote,
		Local:  local,
		Opts:   opts,
	}
	mock.lockDownload.Lock()
	mock.calls.Download = append(mock.calls.Download, callInfo)
	mock.lockDownload.Unlock()
	return mock.DownloadFunc(ctx, remote, local, opts)
}

// DownloadCalls gets all the calls that were made to Download.
// Check the length with:
//
//	len(mockedInterface.DownloadCalls())
func (mock *InterfaceMock) DownloadCalls() []struct {
	Ctx    context.Context
	Remote string
	Local  string
	Opts   *executor.UpDownOpts
} {
	var calls []struct {
		Ctx    context.Context
		Remote string
		Local  string
		Opts   *executor.UpDownOpts
	}
	mock.lockDownload.RLock()
	calls = mock.calls.Download
	mock.lockDownload.RUnlock()
	return calls
}

// Run calls RunFunc.
func (mock *InterfaceMock) Run(ctx context.Context, c string, opts *executor.RunOpts) ([]string, error) {
	if mock.RunFunc == nil {
		panic("InterfaceMock.RunFunc: method is nil but Interface.Run was just called")
	}
	callInfo := struct {
		Ctx  context.Context
		C    string
		Opts *executor.RunOpts
	}{
		Ctx:  ctx,
		C:    c,
		Opts: opts,
	}
	mock.lockRun.Lock()
	mock.calls.Run = append(mock.calls.Run, callInfo)
	mock.lockRun.Unlock()
	return mock.RunFunc(ctx, c, opts)
}

// RunCalls gets all the calls that were made to Run.
// Check the length with:
//
//	len(mockedInterface.RunCalls())
func (mock *InterfaceMock) RunCalls() []struct {
	Ctx  context.Context
	C    string
	Opts *executor.RunOpts
} {
	var calls []struct {
		Ctx  context.Context
		C    string
		Opts *executor.RunOpts
	}
	mock.lockRun.RLock()
	calls = mock.calls.Run
	mock.lockRun.RUnlock()
	return calls
}

// Sync calls SyncFunc.
func (mock *InterfaceMock) Sync(ctx context.Context, localDir string, remoteDir string, opts *executor.SyncOpts) ([]string, error) {
	if mock.SyncFunc == nil {
		panic("InterfaceMock.SyncFunc: method is nil but Interface.Sync was just called")
	}
	callInfo := struct {
		Ctx       context.Context
		LocalDir  string
		RemoteDir string
		Opts      *executor.SyncOpts
	}{
		Ctx:       ctx,
		LocalDir:  localDir,
		RemoteDir: remoteDir,
		Opts:      opts,
	}
	mock.lockSync.Lock()
	mock.calls.Sync = append(mock.calls.Sync, callInfo)
	mock.lockSync.Unlock()
	return mock.SyncFunc(ctx, localDir, remoteDir, opts)
}

// SyncCalls gets all the calls that were made to Sync.
// Check the length with:
//
//	len(mockedInterface.SyncCalls())
func (mock *InterfaceMock) SyncCalls() []struct {
	Ctx       context.Context
	LocalDir  string
	RemoteDir string
	Opts      *executor.SyncOpts
} {
	var calls []struct {
		Ctx       context.Context
		LocalDir  string
		RemoteDir string
		Opts      *executor.SyncOpts
	}
	mock.lockSync.RLock()
	calls = mock.calls.Sync
	mock.lockSync.RUnlock()
	return calls
}

// Upload calls UploadFunc.
func (mock *InterfaceMock) Upload(ctx context.Context, local string, remote string, opts *executor.UpDownOpts) error {
	if mock.UploadFunc == nil {
		panic("InterfaceMock.UploadFunc: method is nil but Interface.Upload was just called")
	}
	callInfo := struct {
		Ctx    context.Context
		Local  string
		Remote string
		Opts   *executor.UpDownOpts
	}{
		Ctx:    ctx,
		Local:  local,
		Remote: remote,
		Opts:   opts,
	}
	mock.lockUpload.Lock()
	mock.calls.Upload = append(mock.calls.Upload, callInfo)
	mock.lockUpload.Unlock()
	return mock.UploadFunc(ctx, local, remote, opts)
}

// UploadCalls gets all the calls that were made to Upload.
// Check the length with:
//
//	len(mockedInterface.UploadCalls())
func (mock *InterfaceMock) UploadCalls() []struct {
	Ctx    context.Context
	Local  string
	Remote string
	Opts   *executor.UpDownOpts
} {
	var calls []struct {
		Ctx    context.Context
		Local  string
		Remote string
		Opts   *executor.UpDownOpts
	}
	mock.lockUpload.RLock()
	calls = mock.calls.Upload
	mock.lockUpload.RUnlock()
	return calls
}
