// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	templatev1 "github.com/openshift/api/template/v1"
	internal "github.com/openshift/client-go/template/applyconfigurations/internal"
	apismetav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// TemplateApplyConfiguration represents a declarative configuration of the Template type for use
// with apply.
type TemplateApplyConfiguration struct {
	metav1.TypeMetaApplyConfiguration    `json:",inline"`
	*metav1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	Message                              *string                       `json:"message,omitempty"`
	Objects                              []runtime.RawExtension        `json:"objects,omitempty"`
	Parameters                           []ParameterApplyConfiguration `json:"parameters,omitempty"`
	ObjectLabels                         map[string]string             `json:"labels,omitempty"`
}

// Template constructs a declarative configuration of the Template type for use with
// apply.
func Template(name, namespace string) *TemplateApplyConfiguration {
	b := &TemplateApplyConfiguration{}
	b.WithName(name)
	b.WithNamespace(namespace)
	b.WithKind("Template")
	b.WithAPIVersion("template.openshift.io/v1")
	return b
}

// ExtractTemplate extracts the applied configuration owned by fieldManager from
// template. If no managedFields are found in template for fieldManager, a
// TemplateApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// template must be a unmodified Template API object that was retrieved from the Kubernetes API.
// ExtractTemplate provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
// Experimental!
func ExtractTemplate(template *templatev1.Template, fieldManager string) (*TemplateApplyConfiguration, error) {
	return extractTemplate(template, fieldManager, "")
}

// ExtractTemplateStatus is the same as ExtractTemplate except
// that it extracts the status subresource applied configuration.
// Experimental!
func ExtractTemplateStatus(template *templatev1.Template, fieldManager string) (*TemplateApplyConfiguration, error) {
	return extractTemplate(template, fieldManager, "status")
}

func extractTemplate(template *templatev1.Template, fieldManager string, subresource string) (*TemplateApplyConfiguration, error) {
	b := &TemplateApplyConfiguration{}
	err := managedfields.ExtractInto(template, internal.Parser().Type("com.github.openshift.api.template.v1.Template"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(template.Name)
	b.WithNamespace(template.Namespace)

	b.WithKind("Template")
	b.WithAPIVersion("template.openshift.io/v1")
	return b, nil
}
func (b TemplateApplyConfiguration) IsApplyConfiguration() {}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithKind(value string) *TemplateApplyConfiguration {
	b.TypeMetaApplyConfiguration.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithAPIVersion(value string) *TemplateApplyConfiguration {
	b.TypeMetaApplyConfiguration.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithName(value string) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithGenerateName(value string) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithNamespace(value string) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithUID(value types.UID) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithResourceVersion(value string) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithGeneration(value int64) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithCreationTimestamp(value apismetav1.Time) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithDeletionTimestamp(value apismetav1.Time) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *TemplateApplyConfiguration) WithLabels(entries map[string]string) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Labels == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *TemplateApplyConfiguration) WithAnnotations(entries map[string]string) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Annotations == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *TemplateApplyConfiguration) WithOwnerReferences(values ...*metav1.OwnerReferenceApplyConfiguration) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.ObjectMetaApplyConfiguration.OwnerReferences = append(b.ObjectMetaApplyConfiguration.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *TemplateApplyConfiguration) WithFinalizers(values ...string) *TemplateApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.ObjectMetaApplyConfiguration.Finalizers = append(b.ObjectMetaApplyConfiguration.Finalizers, values[i])
	}
	return b
}

func (b *TemplateApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &metav1.ObjectMetaApplyConfiguration{}
	}
}

// WithMessage sets the Message field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Message field is set to the value of the last call.
func (b *TemplateApplyConfiguration) WithMessage(value string) *TemplateApplyConfiguration {
	b.Message = &value
	return b
}

// WithObjects adds the given value to the Objects field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Objects field.
func (b *TemplateApplyConfiguration) WithObjects(values ...runtime.RawExtension) *TemplateApplyConfiguration {
	for i := range values {
		b.Objects = append(b.Objects, values[i])
	}
	return b
}

// WithParameters adds the given value to the Parameters field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Parameters field.
func (b *TemplateApplyConfiguration) WithParameters(values ...*ParameterApplyConfiguration) *TemplateApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithParameters")
		}
		b.Parameters = append(b.Parameters, *values[i])
	}
	return b
}

// WithObjectLabels puts the entries into the ObjectLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the ObjectLabels field,
// overwriting an existing map entries in ObjectLabels field with the same key.
func (b *TemplateApplyConfiguration) WithObjectLabels(entries map[string]string) *TemplateApplyConfiguration {
	if b.ObjectLabels == nil && len(entries) > 0 {
		b.ObjectLabels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectLabels[k] = v
	}
	return b
}

// GetKind retrieves the value of the Kind field in the declarative configuration.
func (b *TemplateApplyConfiguration) GetKind() *string {
	return b.TypeMetaApplyConfiguration.Kind
}

// GetAPIVersion retrieves the value of the APIVersion field in the declarative configuration.
func (b *TemplateApplyConfiguration) GetAPIVersion() *string {
	return b.TypeMetaApplyConfiguration.APIVersion
}

// GetName retrieves the value of the Name field in the declarative configuration.
func (b *TemplateApplyConfiguration) GetName() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Name
}

// GetNamespace retrieves the value of the Namespace field in the declarative configuration.
func (b *TemplateApplyConfiguration) GetNamespace() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Namespace
}
