// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	http "net/http"

	networkv1 "github.com/openshift/api/network/v1"
	scheme "github.com/openshift/client-go/network/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type NetworkV1Interface interface {
	RESTClient() rest.Interface
	ClusterNetworksGetter
	EgressNetworkPoliciesGetter
	HostSubnetsGetter
	NetNamespacesGetter
}

// NetworkV1Client is used to interact with features provided by the network.openshift.io group.
type NetworkV1Client struct {
	restClient rest.Interface
}

func (c *NetworkV1Client) ClusterNetworks() ClusterNetworkInterface {
	return newClusterNetworks(c)
}

func (c *NetworkV1Client) EgressNetworkPolicies(namespace string) EgressNetworkPolicyInterface {
	return newEgressNetworkPolicies(c, namespace)
}

func (c *NetworkV1Client) HostSubnets() HostSubnetInterface {
	return newHostSubnets(c)
}

func (c *NetworkV1Client) NetNamespaces() NetNamespaceInterface {
	return newNetNamespaces(c)
}

// NewForConfig creates a new NetworkV1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*NetworkV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new NetworkV1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*NetworkV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &NetworkV1Client{client}, nil
}

// NewForConfigOrDie creates a new NetworkV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *NetworkV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new NetworkV1Client for the given RESTClient.
func New(c rest.Interface) *NetworkV1Client {
	return &NetworkV1Client{c}
}

func setConfigDefaults(config *rest.Config) {
	gv := networkv1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = rest.CodecFactoryForGeneratedClient(scheme.Scheme, scheme.Codecs).WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *NetworkV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
