// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	http "net/http"

	machineconfigurationv1alpha1 "github.com/openshift/api/machineconfiguration/v1alpha1"
	scheme "github.com/openshift/client-go/machineconfiguration/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type MachineconfigurationV1alpha1Interface interface {
	RESTClient() rest.Interface
	MachineConfigNodesGetter
	PinnedImageSetsGetter
}

// MachineconfigurationV1alpha1Client is used to interact with features provided by the machineconfiguration.openshift.io group.
type MachineconfigurationV1alpha1Client struct {
	restClient rest.Interface
}

func (c *MachineconfigurationV1alpha1Client) MachineConfigNodes() MachineConfigNodeInterface {
	return newMachineConfigNodes(c)
}

func (c *MachineconfigurationV1alpha1Client) PinnedImageSets() PinnedImageSetInterface {
	return newPinnedImageSets(c)
}

// NewForConfig creates a new MachineconfigurationV1alpha1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*MachineconfigurationV1alpha1Client, error) {
	config := *c
	setConfigDefaults(&config)
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new MachineconfigurationV1alpha1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*MachineconfigurationV1alpha1Client, error) {
	config := *c
	setConfigDefaults(&config)
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &MachineconfigurationV1alpha1Client{client}, nil
}

// NewForConfigOrDie creates a new MachineconfigurationV1alpha1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *MachineconfigurationV1alpha1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new MachineconfigurationV1alpha1Client for the given RESTClient.
func New(c rest.Interface) *MachineconfigurationV1alpha1Client {
	return &MachineconfigurationV1alpha1Client{c}
}

func setConfigDefaults(config *rest.Config) {
	gv := machineconfigurationv1alpha1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = rest.CodecFactoryForGeneratedClient(scheme.Scheme, scheme.Codecs).WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *MachineconfigurationV1alpha1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
