// Code generated by applyconfiguration-gen. DO NOT EDIT.

package internal

import (
	fmt "fmt"
	sync "sync"

	typed "sigs.k8s.io/structured-merge-diff/v6/typed"
)

func Parser() *typed.Parser {
	parserOnce.Do(func() {
		var err error
		parser, err = typed.NewParser(schemaYAML)
		if err != nil {
			panic(fmt.Sprintf("Failed to parse schema: %v", err))
		}
	})
	return parser
}

var parserOnce sync.Once
var parser *typed.Parser
var schemaYAML = typed.YAMLObject(`types:
- name: com.github.openshift.api.config.v1.APIServer
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.APIServerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.APIServerStatus
      default: {}
- name: com.github.openshift.api.config.v1.APIServerEncryption
  map:
    fields:
    - name: kms
      type:
        namedType: com.github.openshift.api.config.v1.KMSConfig
    - name: type
      type:
        scalar: string
    unions:
    - discriminator: type
      fields:
      - fieldName: kms
        discriminatorValue: KMS
- name: com.github.openshift.api.config.v1.APIServerNamedServingCert
  map:
    fields:
    - name: names
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: servingCertificate
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.APIServerServingCerts
  map:
    fields:
    - name: namedCertificates
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.APIServerNamedServingCert
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.APIServerSpec
  map:
    fields:
    - name: additionalCORSAllowedOrigins
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: audit
      type:
        namedType: com.github.openshift.api.config.v1.Audit
      default: {}
    - name: clientCA
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: encryption
      type:
        namedType: com.github.openshift.api.config.v1.APIServerEncryption
      default: {}
    - name: servingCerts
      type:
        namedType: com.github.openshift.api.config.v1.APIServerServingCerts
      default: {}
    - name: tlsSecurityProfile
      type:
        namedType: com.github.openshift.api.config.v1.TLSSecurityProfile
- name: com.github.openshift.api.config.v1.APIServerStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.AWSDNSSpec
  map:
    fields:
    - name: privateZoneIAMRole
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.AWSIngressSpec
  map:
    fields:
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
- name: com.github.openshift.api.config.v1.AWSKMSConfig
  map:
    fields:
    - name: keyARN
      type:
        scalar: string
      default: ""
    - name: region
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.AWSPlatformSpec
  map:
    fields:
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AWSServiceEndpoint
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.AWSPlatformStatus
  map:
    fields:
    - name: cloudLoadBalancerConfig
      type:
        namedType: com.github.openshift.api.config.v1.CloudLoadBalancerConfig
      default:
        dnsType: PlatformDefault
    - name: region
      type:
        scalar: string
      default: ""
    - name: resourceTags
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AWSResourceTag
          elementRelationship: atomic
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AWSServiceEndpoint
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.AWSResourceTag
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.AWSServiceEndpoint
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.AlibabaCloudPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.AlibabaCloudPlatformStatus
  map:
    fields:
    - name: region
      type:
        scalar: string
      default: ""
    - name: resourceGroupID
      type:
        scalar: string
    - name: resourceTags
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AlibabaCloudResourceTag
          elementRelationship: associative
          keys:
          - key
- name: com.github.openshift.api.config.v1.AlibabaCloudResourceTag
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Audit
  map:
    fields:
    - name: customRules
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AuditCustomRule
          elementRelationship: associative
          keys:
          - group
    - name: profile
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.AuditCustomRule
  map:
    fields:
    - name: group
      type:
        scalar: string
      default: ""
    - name: profile
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Authentication
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.AuthenticationSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.AuthenticationStatus
      default: {}
- name: com.github.openshift.api.config.v1.AuthenticationSpec
  map:
    fields:
    - name: oauthMetadata
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: oidcProviders
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.OIDCProvider
          elementRelationship: associative
          keys:
          - name
    - name: serviceAccountIssuer
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
    - name: webhookTokenAuthenticator
      type:
        namedType: com.github.openshift.api.config.v1.WebhookTokenAuthenticator
    - name: webhookTokenAuthenticators
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.DeprecatedWebhookTokenAuthenticator
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.AuthenticationStatus
  map:
    fields:
    - name: integratedOAuthMetadata
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: oidcClients
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.OIDCClientStatus
          elementRelationship: associative
          keys:
          - componentNamespace
          - componentName
- name: com.github.openshift.api.config.v1.AzurePlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.AzurePlatformStatus
  map:
    fields:
    - name: armEndpoint
      type:
        scalar: string
    - name: cloudLoadBalancerConfig
      type:
        namedType: com.github.openshift.api.config.v1.CloudLoadBalancerConfig
      default:
        dnsType: PlatformDefault
    - name: cloudName
      type:
        scalar: string
    - name: networkResourceGroupName
      type:
        scalar: string
    - name: resourceGroupName
      type:
        scalar: string
      default: ""
    - name: resourceTags
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AzureResourceTag
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.AzureResourceTag
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.BareMetalPlatformLoadBalancer
  map:
    fields:
    - name: type
      type:
        scalar: string
      default: OpenShiftManagedDefault
    unions:
    - discriminator: type
- name: com.github.openshift.api.config.v1.BareMetalPlatformSpec
  map:
    fields:
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: machineNetworks
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.BareMetalPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: loadBalancer
      type:
        namedType: com.github.openshift.api.config.v1.BareMetalPlatformLoadBalancer
      default:
        type: OpenShiftManagedDefault
    - name: machineNetworks
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: nodeDNSIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.BasicAuthIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: tlsClientCert
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: tlsClientKey
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Build
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.BuildSpec
      default: {}
- name: com.github.openshift.api.config.v1.BuildDefaults
  map:
    fields:
    - name: defaultProxy
      type:
        namedType: com.github.openshift.api.config.v1.ProxySpec
    - name: env
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.EnvVar
          elementRelationship: atomic
    - name: gitProxy
      type:
        namedType: com.github.openshift.api.config.v1.ProxySpec
    - name: imageLabels
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ImageLabel
          elementRelationship: atomic
    - name: resources
      type:
        namedType: io.k8s.api.core.v1.ResourceRequirements
      default: {}
- name: com.github.openshift.api.config.v1.BuildOverrides
  map:
    fields:
    - name: forcePull
      type:
        scalar: boolean
    - name: imageLabels
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ImageLabel
          elementRelationship: atomic
    - name: nodeSelector
      type:
        map:
          elementType:
            scalar: string
    - name: tolerations
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Toleration
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.BuildSpec
  map:
    fields:
    - name: additionalTrustedCA
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: buildDefaults
      type:
        namedType: com.github.openshift.api.config.v1.BuildDefaults
      default: {}
    - name: buildOverrides
      type:
        namedType: com.github.openshift.api.config.v1.BuildOverrides
      default: {}
- name: com.github.openshift.api.config.v1.CloudControllerManagerStatus
  map:
    fields:
    - name: state
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.CloudLoadBalancerConfig
  map:
    fields:
    - name: clusterHosted
      type:
        namedType: com.github.openshift.api.config.v1.CloudLoadBalancerIPs
    - name: dnsType
      type:
        scalar: string
      default: PlatformDefault
    unions:
    - discriminator: dnsType
      fields:
      - fieldName: clusterHosted
        discriminatorValue: ClusterHosted
- name: com.github.openshift.api.config.v1.CloudLoadBalancerIPs
  map:
    fields:
    - name: apiIntLoadBalancerIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: apiLoadBalancerIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: ingressLoadBalancerIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
- name: com.github.openshift.api.config.v1.ClusterCondition
  map:
    fields:
    - name: promql
      type:
        namedType: com.github.openshift.api.config.v1.PromQLClusterCondition
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ClusterImagePolicy
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ClusterImagePolicySpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ClusterImagePolicyStatus
      default: {}
- name: com.github.openshift.api.config.v1.ClusterImagePolicySpec
  map:
    fields:
    - name: policy
      type:
        namedType: com.github.openshift.api.config.v1.Policy
      default: {}
    - name: scopes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
- name: com.github.openshift.api.config.v1.ClusterImagePolicyStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
- name: com.github.openshift.api.config.v1.ClusterNetworkEntry
  map:
    fields:
    - name: cidr
      type:
        scalar: string
      default: ""
    - name: hostPrefix
      type:
        scalar: numeric
- name: com.github.openshift.api.config.v1.ClusterOperator
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ClusterOperatorSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ClusterOperatorStatus
      default: {}
- name: com.github.openshift.api.config.v1.ClusterOperatorSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.ClusterOperatorStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterOperatorStatusCondition
          elementRelationship: associative
          keys:
          - type
    - name: extension
      type:
        namedType: __untyped_atomic_
    - name: relatedObjects
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ObjectReference
          elementRelationship: atomic
    - name: versions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.OperandVersion
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ClusterOperatorStatusCondition
  map:
    fields:
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: message
      type:
        scalar: string
    - name: reason
      type:
        scalar: string
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ClusterVersion
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ClusterVersionSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ClusterVersionStatus
      default: {}
- name: com.github.openshift.api.config.v1.ClusterVersionCapabilitiesSpec
  map:
    fields:
    - name: additionalEnabledCapabilities
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: baselineCapabilitySet
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ClusterVersionCapabilitiesStatus
  map:
    fields:
    - name: enabledCapabilities
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: knownCapabilities
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ClusterVersionSpec
  map:
    fields:
    - name: capabilities
      type:
        namedType: com.github.openshift.api.config.v1.ClusterVersionCapabilitiesSpec
    - name: channel
      type:
        scalar: string
    - name: clusterID
      type:
        scalar: string
      default: ""
    - name: desiredUpdate
      type:
        namedType: com.github.openshift.api.config.v1.Update
    - name: overrides
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ComponentOverride
          elementRelationship: associative
          keys:
          - kind
          - group
          - namespace
          - name
    - name: signatureStores
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.SignatureStore
          elementRelationship: associative
          keys:
          - url
    - name: upstream
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ClusterVersionStatus
  map:
    fields:
    - name: availableUpdates
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.Release
          elementRelationship: atomic
    - name: capabilities
      type:
        namedType: com.github.openshift.api.config.v1.ClusterVersionCapabilitiesStatus
      default: {}
    - name: conditionalUpdates
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ConditionalUpdate
          elementRelationship: atomic
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterOperatorStatusCondition
          elementRelationship: associative
          keys:
          - type
    - name: desired
      type:
        namedType: com.github.openshift.api.config.v1.Release
      default: {}
    - name: history
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.UpdateHistory
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
      default: 0
    - name: versionHash
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ComponentOverride
  map:
    fields:
    - name: group
      type:
        scalar: string
      default: ""
    - name: kind
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
      default: ""
    - name: unmanaged
      type:
        scalar: boolean
      default: false
- name: com.github.openshift.api.config.v1.ComponentRouteSpec
  map:
    fields:
    - name: hostname
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
      default: ""
    - name: servingCertKeyPairSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.ComponentRouteStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
    - name: consumingUsers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: currentHostnames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: defaultHostname
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
      default: ""
    - name: relatedObjects
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ObjectReference
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ConditionalUpdate
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
    - name: release
      type:
        namedType: com.github.openshift.api.config.v1.Release
      default: {}
    - name: risks
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ConditionalUpdateRisk
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.ConditionalUpdateRisk
  map:
    fields:
    - name: matchingRules
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterCondition
          elementRelationship: atomic
    - name: message
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ConfigMapFileReference
  map:
    fields:
    - name: key
      type:
        scalar: string
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ConfigMapNameReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Console
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ConsoleSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ConsoleStatus
      default: {}
- name: com.github.openshift.api.config.v1.ConsoleAuthentication
  map:
    fields:
    - name: logoutRedirect
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ConsoleSpec
  map:
    fields:
    - name: authentication
      type:
        namedType: com.github.openshift.api.config.v1.ConsoleAuthentication
      default: {}
- name: com.github.openshift.api.config.v1.ConsoleStatus
  map:
    fields:
    - name: consoleURL
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Custom
  map:
    fields:
    - name: configs
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.GathererConfig
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.CustomFeatureGates
  map:
    fields:
    - name: disabled
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: enabled
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.CustomTLSProfile
  map:
    fields:
    - name: ciphers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: minTLSVersion
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.DNS
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.DNSSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.DNSStatus
      default: {}
- name: com.github.openshift.api.config.v1.DNSPlatformSpec
  map:
    fields:
    - name: aws
      type:
        namedType: com.github.openshift.api.config.v1.AWSDNSSpec
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: aws
        discriminatorValue: AWS
- name: com.github.openshift.api.config.v1.DNSSpec
  map:
    fields:
    - name: baseDomain
      type:
        scalar: string
      default: ""
    - name: platform
      type:
        namedType: com.github.openshift.api.config.v1.DNSPlatformSpec
      default: {}
    - name: privateZone
      type:
        namedType: com.github.openshift.api.config.v1.DNSZone
    - name: publicZone
      type:
        namedType: com.github.openshift.api.config.v1.DNSZone
- name: com.github.openshift.api.config.v1.DNSStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.DNSZone
  map:
    fields:
    - name: id
      type:
        scalar: string
    - name: tags
      type:
        map:
          elementType:
            scalar: string
- name: com.github.openshift.api.config.v1.DeprecatedWebhookTokenAuthenticator
  map:
    fields:
    - name: kubeConfig
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.EquinixMetalPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.EquinixMetalPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: ingressIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ExternalIPConfig
  map:
    fields:
    - name: autoAssignCIDRs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: policy
      type:
        namedType: com.github.openshift.api.config.v1.ExternalIPPolicy
- name: com.github.openshift.api.config.v1.ExternalIPPolicy
  map:
    fields:
    - name: allowedCIDRs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: rejectedCIDRs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ExternalPlatformSpec
  map:
    fields:
    - name: platformName
      type:
        scalar: string
      default: Unknown
- name: com.github.openshift.api.config.v1.ExternalPlatformStatus
  map:
    fields:
    - name: cloudControllerManager
      type:
        namedType: com.github.openshift.api.config.v1.CloudControllerManagerStatus
      default: {}
- name: com.github.openshift.api.config.v1.ExtraMapping
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: valueExpression
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.FeatureGate
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.FeatureGateSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.FeatureGateStatus
      default: {}
- name: com.github.openshift.api.config.v1.FeatureGateAttributes
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.FeatureGateDetails
  map:
    fields:
    - name: disabled
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.FeatureGateAttributes
          elementRelationship: atomic
    - name: enabled
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.FeatureGateAttributes
          elementRelationship: atomic
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.FeatureGateSpec
  map:
    fields:
    - name: customNoUpgrade
      type:
        namedType: com.github.openshift.api.config.v1.CustomFeatureGates
    - name: featureSet
      type:
        scalar: string
    unions:
    - discriminator: featureSet
      fields:
      - fieldName: customNoUpgrade
        discriminatorValue: CustomNoUpgrade
- name: com.github.openshift.api.config.v1.FeatureGateStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
    - name: featureGates
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.FeatureGateDetails
          elementRelationship: associative
          keys:
          - version
- name: com.github.openshift.api.config.v1.FulcioCAWithRekor
  map:
    fields:
    - name: fulcioCAData
      type:
        scalar: string
    - name: fulcioSubject
      type:
        namedType: com.github.openshift.api.config.v1.PolicyFulcioSubject
      default: {}
    - name: rekorKeyData
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.GCPPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.GCPPlatformStatus
  map:
    fields:
    - name: cloudLoadBalancerConfig
      type:
        namedType: com.github.openshift.api.config.v1.CloudLoadBalancerConfig
      default:
        dnsType: PlatformDefault
    - name: projectID
      type:
        scalar: string
      default: ""
    - name: region
      type:
        scalar: string
      default: ""
    - name: resourceLabels
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.GCPResourceLabel
          elementRelationship: associative
          keys:
          - key
    - name: resourceTags
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.GCPResourceTag
          elementRelationship: associative
          keys:
          - key
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.GCPServiceEndpoint
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.GCPResourceLabel
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.GCPResourceTag
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: parentID
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.GCPServiceEndpoint
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.GatherConfig
  map:
    fields:
    - name: dataPolicy
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: gatherers
      type:
        namedType: com.github.openshift.api.config.v1.Gatherers
      default: {}
    - name: storage
      type:
        namedType: com.github.openshift.api.config.v1.Storage
      default: {}
- name: com.github.openshift.api.config.v1.GathererConfig
  map:
    fields:
    - name: name
      type:
        scalar: string
    - name: state
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.Gatherers
  map:
    fields:
    - name: custom
      type:
        namedType: com.github.openshift.api.config.v1.Custom
      default: {}
    - name: mode
      type:
        scalar: string
    unions:
    - discriminator: mode
      fields:
      - fieldName: custom
        discriminatorValue: Custom
- name: com.github.openshift.api.config.v1.GitHubIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: clientSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: hostname
      type:
        scalar: string
      default: ""
    - name: organizations
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: teams
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.GitLabIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: clientSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.GoogleIdentityProvider
  map:
    fields:
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: clientSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: hostedDomain
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.HTPasswdIdentityProvider
  map:
    fields:
    - name: fileData
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.HubSource
  map:
    fields:
    - name: disabled
      type:
        scalar: boolean
      default: false
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.HubSourceStatus
  map:
    fields:
    - name: message
      type:
        scalar: string
    - name: status
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.IBMCloudPlatformSpec
  map:
    fields:
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.IBMCloudServiceEndpoint
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.IBMCloudPlatformStatus
  map:
    fields:
    - name: cisInstanceCRN
      type:
        scalar: string
    - name: dnsInstanceCRN
      type:
        scalar: string
    - name: location
      type:
        scalar: string
    - name: providerType
      type:
        scalar: string
    - name: resourceGroupName
      type:
        scalar: string
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.IBMCloudServiceEndpoint
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.IBMCloudServiceEndpoint
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.IdentityProvider
  map:
    fields:
    - name: basicAuth
      type:
        namedType: com.github.openshift.api.config.v1.BasicAuthIdentityProvider
    - name: github
      type:
        namedType: com.github.openshift.api.config.v1.GitHubIdentityProvider
    - name: gitlab
      type:
        namedType: com.github.openshift.api.config.v1.GitLabIdentityProvider
    - name: google
      type:
        namedType: com.github.openshift.api.config.v1.GoogleIdentityProvider
    - name: htpasswd
      type:
        namedType: com.github.openshift.api.config.v1.HTPasswdIdentityProvider
    - name: keystone
      type:
        namedType: com.github.openshift.api.config.v1.KeystoneIdentityProvider
    - name: ldap
      type:
        namedType: com.github.openshift.api.config.v1.LDAPIdentityProvider
    - name: mappingMethod
      type:
        scalar: string
    - name: name
      type:
        scalar: string
      default: ""
    - name: openID
      type:
        namedType: com.github.openshift.api.config.v1.OpenIDIdentityProvider
    - name: requestHeader
      type:
        namedType: com.github.openshift.api.config.v1.RequestHeaderIdentityProvider
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Image
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ImageSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ImageStatus
      default: {}
- name: com.github.openshift.api.config.v1.ImageContentPolicy
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ImageContentPolicySpec
      default: {}
- name: com.github.openshift.api.config.v1.ImageContentPolicySpec
  map:
    fields:
    - name: repositoryDigestMirrors
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.RepositoryDigestMirrors
          elementRelationship: associative
          keys:
          - source
- name: com.github.openshift.api.config.v1.ImageDigestMirrorSet
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ImageDigestMirrorSetSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ImageDigestMirrorSetStatus
      default: {}
- name: com.github.openshift.api.config.v1.ImageDigestMirrorSetSpec
  map:
    fields:
    - name: imageDigestMirrors
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ImageDigestMirrors
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ImageDigestMirrorSetStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.ImageDigestMirrors
  map:
    fields:
    - name: mirrorSourcePolicy
      type:
        scalar: string
    - name: mirrors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: source
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ImageLabel
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ImagePolicy
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ImagePolicySpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ImagePolicyStatus
      default: {}
- name: com.github.openshift.api.config.v1.ImagePolicySpec
  map:
    fields:
    - name: policy
      type:
        namedType: com.github.openshift.api.config.v1.Policy
      default: {}
    - name: scopes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
- name: com.github.openshift.api.config.v1.ImagePolicyStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
- name: com.github.openshift.api.config.v1.ImageSpec
  map:
    fields:
    - name: additionalTrustedCA
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: allowedRegistriesForImport
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.RegistryLocation
          elementRelationship: atomic
    - name: externalRegistryHostnames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: imageStreamImportMode
      type:
        scalar: string
      default: ""
    - name: registrySources
      type:
        namedType: com.github.openshift.api.config.v1.RegistrySources
      default: {}
- name: com.github.openshift.api.config.v1.ImageStatus
  map:
    fields:
    - name: externalRegistryHostnames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: imageStreamImportMode
      type:
        scalar: string
    - name: internalRegistryHostname
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ImageTagMirrorSet
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ImageTagMirrorSetSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ImageTagMirrorSetStatus
      default: {}
- name: com.github.openshift.api.config.v1.ImageTagMirrorSetSpec
  map:
    fields:
    - name: imageTagMirrors
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ImageTagMirrors
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ImageTagMirrorSetStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.ImageTagMirrors
  map:
    fields:
    - name: mirrorSourcePolicy
      type:
        scalar: string
    - name: mirrors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: source
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Infrastructure
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.InfrastructureSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.InfrastructureStatus
      default: {}
- name: com.github.openshift.api.config.v1.InfrastructureSpec
  map:
    fields:
    - name: cloudConfig
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapFileReference
      default: {}
    - name: platformSpec
      type:
        namedType: com.github.openshift.api.config.v1.PlatformSpec
      default: {}
- name: com.github.openshift.api.config.v1.InfrastructureStatus
  map:
    fields:
    - name: apiServerInternalURI
      type:
        scalar: string
      default: ""
    - name: apiServerURL
      type:
        scalar: string
      default: ""
    - name: controlPlaneTopology
      type:
        scalar: string
      default: ""
    - name: cpuPartitioning
      type:
        scalar: string
      default: None
    - name: etcdDiscoveryDomain
      type:
        scalar: string
      default: ""
    - name: infrastructureName
      type:
        scalar: string
      default: ""
    - name: infrastructureTopology
      type:
        scalar: string
    - name: platform
      type:
        scalar: string
    - name: platformStatus
      type:
        namedType: com.github.openshift.api.config.v1.PlatformStatus
- name: com.github.openshift.api.config.v1.Ingress
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.IngressSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.IngressStatus
      default: {}
- name: com.github.openshift.api.config.v1.IngressPlatformSpec
  map:
    fields:
    - name: aws
      type:
        namedType: com.github.openshift.api.config.v1.AWSIngressSpec
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: aws
        discriminatorValue: AWS
- name: com.github.openshift.api.config.v1.IngressSpec
  map:
    fields:
    - name: appsDomain
      type:
        scalar: string
    - name: componentRoutes
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ComponentRouteSpec
          elementRelationship: associative
          keys:
          - namespace
          - name
    - name: domain
      type:
        scalar: string
      default: ""
    - name: loadBalancer
      type:
        namedType: com.github.openshift.api.config.v1.LoadBalancer
      default: {}
    - name: requiredHSTSPolicies
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.RequiredHSTSPolicy
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.IngressStatus
  map:
    fields:
    - name: componentRoutes
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ComponentRouteStatus
          elementRelationship: associative
          keys:
          - namespace
          - name
    - name: defaultPlacement
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.InsightsDataGather
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.InsightsDataGatherSpec
      default: {}
- name: com.github.openshift.api.config.v1.InsightsDataGatherSpec
  map:
    fields:
    - name: gatherConfig
      type:
        namedType: com.github.openshift.api.config.v1.GatherConfig
      default: {}
- name: com.github.openshift.api.config.v1.IntermediateTLSProfile
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.KMSConfig
  map:
    fields:
    - name: aws
      type:
        namedType: com.github.openshift.api.config.v1.AWSKMSConfig
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: aws
        discriminatorValue: AWS
- name: com.github.openshift.api.config.v1.KeystoneIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: domainName
      type:
        scalar: string
      default: ""
    - name: tlsClientCert
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: tlsClientKey
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.KubevirtPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.KubevirtPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: ingressIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.LDAPAttributeMapping
  map:
    fields:
    - name: email
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: id
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: name
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: preferredUsername
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.LDAPIdentityProvider
  map:
    fields:
    - name: attributes
      type:
        namedType: com.github.openshift.api.config.v1.LDAPAttributeMapping
      default: {}
    - name: bindDN
      type:
        scalar: string
      default: ""
    - name: bindPassword
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: insecure
      type:
        scalar: boolean
      default: false
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.LoadBalancer
  map:
    fields:
    - name: platform
      type:
        namedType: com.github.openshift.api.config.v1.IngressPlatformSpec
      default: {}
- name: com.github.openshift.api.config.v1.MTUMigration
  map:
    fields:
    - name: machine
      type:
        namedType: com.github.openshift.api.config.v1.MTUMigrationValues
    - name: network
      type:
        namedType: com.github.openshift.api.config.v1.MTUMigrationValues
- name: com.github.openshift.api.config.v1.MTUMigrationValues
  map:
    fields:
    - name: from
      type:
        scalar: numeric
    - name: to
      type:
        scalar: numeric
- name: com.github.openshift.api.config.v1.MaxAgePolicy
  map:
    fields:
    - name: largestMaxAge
      type:
        scalar: numeric
    - name: smallestMaxAge
      type:
        scalar: numeric
- name: com.github.openshift.api.config.v1.ModernTLSProfile
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.Network
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.NetworkSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.NetworkStatus
      default: {}
- name: com.github.openshift.api.config.v1.NetworkDiagnostics
  map:
    fields:
    - name: mode
      type:
        scalar: string
      default: ""
    - name: sourcePlacement
      type:
        namedType: com.github.openshift.api.config.v1.NetworkDiagnosticsSourcePlacement
      default: {}
    - name: targetPlacement
      type:
        namedType: com.github.openshift.api.config.v1.NetworkDiagnosticsTargetPlacement
      default: {}
- name: com.github.openshift.api.config.v1.NetworkDiagnosticsSourcePlacement
  map:
    fields:
    - name: nodeSelector
      type:
        map:
          elementType:
            scalar: string
    - name: tolerations
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Toleration
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.NetworkDiagnosticsTargetPlacement
  map:
    fields:
    - name: nodeSelector
      type:
        map:
          elementType:
            scalar: string
    - name: tolerations
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Toleration
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.NetworkMigration
  map:
    fields:
    - name: mtu
      type:
        namedType: com.github.openshift.api.config.v1.MTUMigration
    - name: networkType
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.NetworkSpec
  map:
    fields:
    - name: clusterNetwork
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterNetworkEntry
          elementRelationship: atomic
    - name: externalIP
      type:
        namedType: com.github.openshift.api.config.v1.ExternalIPConfig
    - name: networkDiagnostics
      type:
        namedType: com.github.openshift.api.config.v1.NetworkDiagnostics
      default: {}
    - name: networkType
      type:
        scalar: string
      default: ""
    - name: serviceNetwork
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: serviceNodePortRange
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.NetworkStatus
  map:
    fields:
    - name: clusterNetwork
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterNetworkEntry
          elementRelationship: atomic
    - name: clusterNetworkMTU
      type:
        scalar: numeric
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
    - name: migration
      type:
        namedType: com.github.openshift.api.config.v1.NetworkMigration
    - name: networkType
      type:
        scalar: string
    - name: serviceNetwork
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.Node
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.NodeSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.NodeStatus
      default: {}
- name: com.github.openshift.api.config.v1.NodeSpec
  map:
    fields:
    - name: cgroupMode
      type:
        scalar: string
    - name: minimumKubeletVersion
      type:
        scalar: string
      default: ""
    - name: workerLatencyProfile
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.NodeStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
- name: com.github.openshift.api.config.v1.NutanixFailureDomain
  map:
    fields:
    - name: cluster
      type:
        namedType: com.github.openshift.api.config.v1.NutanixResourceIdentifier
      default: {}
    - name: name
      type:
        scalar: string
      default: ""
    - name: subnets
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.NutanixResourceIdentifier
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.NutanixPlatformLoadBalancer
  map:
    fields:
    - name: type
      type:
        scalar: string
      default: OpenShiftManagedDefault
    unions:
    - discriminator: type
- name: com.github.openshift.api.config.v1.NutanixPlatformSpec
  map:
    fields:
    - name: failureDomains
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.NutanixFailureDomain
          elementRelationship: associative
          keys:
          - name
    - name: prismCentral
      type:
        namedType: com.github.openshift.api.config.v1.NutanixPrismEndpoint
      default: {}
    - name: prismElements
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.NutanixPrismElementEndpoint
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.NutanixPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: loadBalancer
      type:
        namedType: com.github.openshift.api.config.v1.NutanixPlatformLoadBalancer
      default:
        type: OpenShiftManagedDefault
- name: com.github.openshift.api.config.v1.NutanixPrismElementEndpoint
  map:
    fields:
    - name: endpoint
      type:
        namedType: com.github.openshift.api.config.v1.NutanixPrismEndpoint
      default: {}
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.NutanixPrismEndpoint
  map:
    fields:
    - name: address
      type:
        scalar: string
      default: ""
    - name: port
      type:
        scalar: numeric
      default: 0
- name: com.github.openshift.api.config.v1.NutanixResourceIdentifier
  map:
    fields:
    - name: name
      type:
        scalar: string
    - name: type
      type:
        scalar: string
      default: ""
    - name: uuid
      type:
        scalar: string
    unions:
    - discriminator: type
      fields:
      - fieldName: name
        discriminatorValue: Name
      - fieldName: uuid
        discriminatorValue: UUID
- name: com.github.openshift.api.config.v1.OAuth
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.OAuthSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.OAuthStatus
      default: {}
- name: com.github.openshift.api.config.v1.OAuthSpec
  map:
    fields:
    - name: identityProviders
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.IdentityProvider
          elementRelationship: atomic
    - name: templates
      type:
        namedType: com.github.openshift.api.config.v1.OAuthTemplates
      default: {}
    - name: tokenConfig
      type:
        namedType: com.github.openshift.api.config.v1.TokenConfig
      default: {}
- name: com.github.openshift.api.config.v1.OAuthStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.OAuthTemplates
  map:
    fields:
    - name: error
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: login
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: providerSelection
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.OIDCClientConfig
  map:
    fields:
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: clientSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: componentName
      type:
        scalar: string
      default: ""
    - name: componentNamespace
      type:
        scalar: string
      default: ""
    - name: extraScopes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
- name: com.github.openshift.api.config.v1.OIDCClientReference
  map:
    fields:
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: issuerURL
      type:
        scalar: string
      default: ""
    - name: oidcProviderName
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.OIDCClientStatus
  map:
    fields:
    - name: componentName
      type:
        scalar: string
      default: ""
    - name: componentNamespace
      type:
        scalar: string
      default: ""
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
    - name: consumingUsers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: currentOIDCClients
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.OIDCClientReference
          elementRelationship: associative
          keys:
          - issuerURL
          - clientID
- name: com.github.openshift.api.config.v1.OIDCProvider
  map:
    fields:
    - name: claimMappings
      type:
        namedType: com.github.openshift.api.config.v1.TokenClaimMappings
      default: {}
    - name: claimValidationRules
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.TokenClaimValidationRule
          elementRelationship: atomic
    - name: issuer
      type:
        namedType: com.github.openshift.api.config.v1.TokenIssuer
      default: {}
    - name: name
      type:
        scalar: string
      default: ""
    - name: oidcClients
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.OIDCClientConfig
          elementRelationship: associative
          keys:
          - componentNamespace
          - componentName
- name: com.github.openshift.api.config.v1.ObjectReference
  map:
    fields:
    - name: group
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
    - name: resource
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.OldTLSProfile
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.OpenIDClaims
  map:
    fields:
    - name: email
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: groups
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: name
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: preferredUsername
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.OpenIDIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: claims
      type:
        namedType: com.github.openshift.api.config.v1.OpenIDClaims
      default: {}
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: clientSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: extraAuthorizeParameters
      type:
        map:
          elementType:
            scalar: string
    - name: extraScopes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: issuer
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.OpenStackPlatformLoadBalancer
  map:
    fields:
    - name: type
      type:
        scalar: string
      default: OpenShiftManagedDefault
    unions:
    - discriminator: type
- name: com.github.openshift.api.config.v1.OpenStackPlatformSpec
  map:
    fields:
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: machineNetworks
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.OpenStackPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: cloudName
      type:
        scalar: string
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: loadBalancer
      type:
        namedType: com.github.openshift.api.config.v1.OpenStackPlatformLoadBalancer
      default:
        type: OpenShiftManagedDefault
    - name: machineNetworks
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: nodeDNSIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.OperandVersion
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.OperatorHub
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.OperatorHubSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.OperatorHubStatus
      default: {}
- name: com.github.openshift.api.config.v1.OperatorHubSpec
  map:
    fields:
    - name: disableAllDefaultSources
      type:
        scalar: boolean
    - name: sources
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.HubSource
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.OperatorHubStatus
  map:
    fields:
    - name: sources
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.HubSourceStatus
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.OvirtPlatformLoadBalancer
  map:
    fields:
    - name: type
      type:
        scalar: string
      default: OpenShiftManagedDefault
    unions:
    - discriminator: type
- name: com.github.openshift.api.config.v1.OvirtPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.OvirtPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: loadBalancer
      type:
        namedType: com.github.openshift.api.config.v1.OvirtPlatformLoadBalancer
      default:
        type: OpenShiftManagedDefault
    - name: nodeDNSIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.PKI
  map:
    fields:
    - name: caIntermediatesData
      type:
        scalar: string
    - name: caRootsData
      type:
        scalar: string
    - name: pkiCertificateSubject
      type:
        namedType: com.github.openshift.api.config.v1.PKICertificateSubject
      default: {}
- name: com.github.openshift.api.config.v1.PKICertificateSubject
  map:
    fields:
    - name: email
      type:
        scalar: string
    - name: hostname
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.PersistentVolumeClaimReference
  map:
    fields:
    - name: name
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.PersistentVolumeConfig
  map:
    fields:
    - name: claim
      type:
        namedType: com.github.openshift.api.config.v1.PersistentVolumeClaimReference
      default: {}
    - name: mountPath
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.PlatformSpec
  map:
    fields:
    - name: alibabaCloud
      type:
        namedType: com.github.openshift.api.config.v1.AlibabaCloudPlatformSpec
    - name: aws
      type:
        namedType: com.github.openshift.api.config.v1.AWSPlatformSpec
    - name: azure
      type:
        namedType: com.github.openshift.api.config.v1.AzurePlatformSpec
    - name: baremetal
      type:
        namedType: com.github.openshift.api.config.v1.BareMetalPlatformSpec
    - name: equinixMetal
      type:
        namedType: com.github.openshift.api.config.v1.EquinixMetalPlatformSpec
    - name: external
      type:
        namedType: com.github.openshift.api.config.v1.ExternalPlatformSpec
    - name: gcp
      type:
        namedType: com.github.openshift.api.config.v1.GCPPlatformSpec
    - name: ibmcloud
      type:
        namedType: com.github.openshift.api.config.v1.IBMCloudPlatformSpec
    - name: kubevirt
      type:
        namedType: com.github.openshift.api.config.v1.KubevirtPlatformSpec
    - name: nutanix
      type:
        namedType: com.github.openshift.api.config.v1.NutanixPlatformSpec
    - name: openstack
      type:
        namedType: com.github.openshift.api.config.v1.OpenStackPlatformSpec
    - name: ovirt
      type:
        namedType: com.github.openshift.api.config.v1.OvirtPlatformSpec
    - name: powervs
      type:
        namedType: com.github.openshift.api.config.v1.PowerVSPlatformSpec
    - name: type
      type:
        scalar: string
      default: ""
    - name: vsphere
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformSpec
- name: com.github.openshift.api.config.v1.PlatformStatus
  map:
    fields:
    - name: alibabaCloud
      type:
        namedType: com.github.openshift.api.config.v1.AlibabaCloudPlatformStatus
    - name: aws
      type:
        namedType: com.github.openshift.api.config.v1.AWSPlatformStatus
    - name: azure
      type:
        namedType: com.github.openshift.api.config.v1.AzurePlatformStatus
    - name: baremetal
      type:
        namedType: com.github.openshift.api.config.v1.BareMetalPlatformStatus
    - name: equinixMetal
      type:
        namedType: com.github.openshift.api.config.v1.EquinixMetalPlatformStatus
    - name: external
      type:
        namedType: com.github.openshift.api.config.v1.ExternalPlatformStatus
    - name: gcp
      type:
        namedType: com.github.openshift.api.config.v1.GCPPlatformStatus
    - name: ibmcloud
      type:
        namedType: com.github.openshift.api.config.v1.IBMCloudPlatformStatus
    - name: kubevirt
      type:
        namedType: com.github.openshift.api.config.v1.KubevirtPlatformStatus
    - name: nutanix
      type:
        namedType: com.github.openshift.api.config.v1.NutanixPlatformStatus
    - name: openstack
      type:
        namedType: com.github.openshift.api.config.v1.OpenStackPlatformStatus
    - name: ovirt
      type:
        namedType: com.github.openshift.api.config.v1.OvirtPlatformStatus
    - name: powervs
      type:
        namedType: com.github.openshift.api.config.v1.PowerVSPlatformStatus
    - name: type
      type:
        scalar: string
      default: ""
    - name: vsphere
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformStatus
- name: com.github.openshift.api.config.v1.Policy
  map:
    fields:
    - name: rootOfTrust
      type:
        namedType: com.github.openshift.api.config.v1.PolicyRootOfTrust
      default: {}
    - name: signedIdentity
      type:
        namedType: com.github.openshift.api.config.v1.PolicyIdentity
- name: com.github.openshift.api.config.v1.PolicyFulcioSubject
  map:
    fields:
    - name: oidcIssuer
      type:
        scalar: string
      default: ""
    - name: signedEmail
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.PolicyIdentity
  map:
    fields:
    - name: exactRepository
      type:
        namedType: com.github.openshift.api.config.v1.PolicyMatchExactRepository
    - name: matchPolicy
      type:
        scalar: string
      default: ""
    - name: remapIdentity
      type:
        namedType: com.github.openshift.api.config.v1.PolicyMatchRemapIdentity
    unions:
    - discriminator: matchPolicy
      fields:
      - fieldName: exactRepository
        discriminatorValue: PolicyMatchExactRepository
      - fieldName: remapIdentity
        discriminatorValue: PolicyMatchRemapIdentity
- name: com.github.openshift.api.config.v1.PolicyMatchExactRepository
  map:
    fields:
    - name: repository
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.PolicyMatchRemapIdentity
  map:
    fields:
    - name: prefix
      type:
        scalar: string
      default: ""
    - name: signedPrefix
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.PolicyRootOfTrust
  map:
    fields:
    - name: fulcioCAWithRekor
      type:
        namedType: com.github.openshift.api.config.v1.FulcioCAWithRekor
    - name: pki
      type:
        namedType: com.github.openshift.api.config.v1.PKI
    - name: policyType
      type:
        scalar: string
      default: ""
    - name: publicKey
      type:
        namedType: com.github.openshift.api.config.v1.PublicKey
    unions:
    - discriminator: policyType
      fields:
      - fieldName: fulcioCAWithRekor
        discriminatorValue: FulcioCAWithRekor
      - fieldName: pki
        discriminatorValue: PKI
      - fieldName: publicKey
        discriminatorValue: PublicKey
- name: com.github.openshift.api.config.v1.PowerVSPlatformSpec
  map:
    fields:
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.PowerVSServiceEndpoint
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.PowerVSPlatformStatus
  map:
    fields:
    - name: cisInstanceCRN
      type:
        scalar: string
    - name: dnsInstanceCRN
      type:
        scalar: string
    - name: region
      type:
        scalar: string
      default: ""
    - name: resourceGroup
      type:
        scalar: string
      default: ""
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.PowerVSServiceEndpoint
          elementRelationship: associative
          keys:
          - name
    - name: zone
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.PowerVSServiceEndpoint
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.PrefixedClaimMapping
  map:
    fields:
    - name: claim
      type:
        scalar: string
      default: ""
    - name: prefix
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ProfileCustomizations
  map:
    fields:
    - name: dynamicResourceAllocation
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Project
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ProjectSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ProjectStatus
      default: {}
- name: com.github.openshift.api.config.v1.ProjectSpec
  map:
    fields:
    - name: projectRequestMessage
      type:
        scalar: string
      default: ""
    - name: projectRequestTemplate
      type:
        namedType: com.github.openshift.api.config.v1.TemplateReference
      default: {}
- name: com.github.openshift.api.config.v1.ProjectStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.PromQLClusterCondition
  map:
    fields:
    - name: promql
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Proxy
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ProxySpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ProxyStatus
      default: {}
- name: com.github.openshift.api.config.v1.ProxySpec
  map:
    fields:
    - name: httpProxy
      type:
        scalar: string
    - name: httpsProxy
      type:
        scalar: string
    - name: noProxy
      type:
        scalar: string
    - name: readinessEndpoints
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: trustedCA
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
- name: com.github.openshift.api.config.v1.ProxyStatus
  map:
    fields:
    - name: httpProxy
      type:
        scalar: string
    - name: httpsProxy
      type:
        scalar: string
    - name: noProxy
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.PublicKey
  map:
    fields:
    - name: keyData
      type:
        scalar: string
    - name: rekorKeyData
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.RegistryLocation
  map:
    fields:
    - name: domainName
      type:
        scalar: string
      default: ""
    - name: insecure
      type:
        scalar: boolean
- name: com.github.openshift.api.config.v1.RegistrySources
  map:
    fields:
    - name: allowedRegistries
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: blockedRegistries
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: containerRuntimeSearchRegistries
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: insecureRegistries
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.Release
  map:
    fields:
    - name: architecture
      type:
        scalar: string
    - name: channels
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: image
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.RepositoryDigestMirrors
  map:
    fields:
    - name: allowMirrorByTags
      type:
        scalar: boolean
    - name: mirrors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: source
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.RequestHeaderIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: challengeURL
      type:
        scalar: string
      default: ""
    - name: clientCommonNames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: emailHeaders
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: headers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: loginURL
      type:
        scalar: string
      default: ""
    - name: nameHeaders
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: preferredUsernameHeaders
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.RequiredHSTSPolicy
  map:
    fields:
    - name: domainPatterns
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: includeSubDomainsPolicy
      type:
        scalar: string
    - name: maxAge
      type:
        namedType: com.github.openshift.api.config.v1.MaxAgePolicy
      default: {}
    - name: namespaceSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: preloadPolicy
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.Scheduler
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.SchedulerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.SchedulerStatus
      default: {}
- name: com.github.openshift.api.config.v1.SchedulerSpec
  map:
    fields:
    - name: defaultNodeSelector
      type:
        scalar: string
    - name: mastersSchedulable
      type:
        scalar: boolean
      default: false
    - name: policy
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: profile
      type:
        scalar: string
    - name: profileCustomizations
      type:
        namedType: com.github.openshift.api.config.v1.ProfileCustomizations
      default: {}
- name: com.github.openshift.api.config.v1.SchedulerStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.SecretNameReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.SignatureStore
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Storage
  map:
    fields:
    - name: persistentVolume
      type:
        namedType: com.github.openshift.api.config.v1.PersistentVolumeConfig
      default: {}
    - name: type
      type:
        scalar: string
    unions:
    - discriminator: type
      fields:
      - fieldName: persistentVolume
        discriminatorValue: PersistentVolume
- name: com.github.openshift.api.config.v1.TLSSecurityProfile
  map:
    fields:
    - name: custom
      type:
        namedType: com.github.openshift.api.config.v1.CustomTLSProfile
    - name: intermediate
      type:
        namedType: com.github.openshift.api.config.v1.IntermediateTLSProfile
    - name: modern
      type:
        namedType: com.github.openshift.api.config.v1.ModernTLSProfile
    - name: old
      type:
        namedType: com.github.openshift.api.config.v1.OldTLSProfile
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: custom
        discriminatorValue: Custom
      - fieldName: intermediate
        discriminatorValue: Intermediate
      - fieldName: modern
        discriminatorValue: Modern
      - fieldName: old
        discriminatorValue: Old
- name: com.github.openshift.api.config.v1.TemplateReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.TokenClaimMappings
  map:
    fields:
    - name: extra
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ExtraMapping
          elementRelationship: associative
          keys:
          - key
    - name: groups
      type:
        namedType: com.github.openshift.api.config.v1.PrefixedClaimMapping
      default: {}
    - name: uid
      type:
        namedType: com.github.openshift.api.config.v1.TokenClaimOrExpressionMapping
    - name: username
      type:
        namedType: com.github.openshift.api.config.v1.UsernameClaimMapping
      default: {}
- name: com.github.openshift.api.config.v1.TokenClaimOrExpressionMapping
  map:
    fields:
    - name: claim
      type:
        scalar: string
    - name: expression
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.TokenClaimValidationRule
  map:
    fields:
    - name: requiredClaim
      type:
        namedType: com.github.openshift.api.config.v1.TokenRequiredClaim
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.TokenConfig
  map:
    fields:
    - name: accessTokenInactivityTimeout
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: accessTokenInactivityTimeoutSeconds
      type:
        scalar: numeric
    - name: accessTokenMaxAgeSeconds
      type:
        scalar: numeric
- name: com.github.openshift.api.config.v1.TokenIssuer
  map:
    fields:
    - name: audiences
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: issuerCertificateAuthority
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: issuerURL
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.TokenRequiredClaim
  map:
    fields:
    - name: claim
      type:
        scalar: string
      default: ""
    - name: requiredValue
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Update
  map:
    fields:
    - name: architecture
      type:
        scalar: string
      default: ""
    - name: force
      type:
        scalar: boolean
      default: false
    - name: image
      type:
        scalar: string
      default: ""
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.UpdateHistory
  map:
    fields:
    - name: acceptedRisks
      type:
        scalar: string
    - name: completionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: image
      type:
        scalar: string
      default: ""
    - name: startedTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: state
      type:
        scalar: string
      default: ""
    - name: verified
      type:
        scalar: boolean
      default: false
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.UsernameClaimMapping
  map:
    fields:
    - name: claim
      type:
        scalar: string
      default: ""
    - name: prefix
      type:
        namedType: com.github.openshift.api.config.v1.UsernamePrefix
    - name: prefixPolicy
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: prefixPolicy
      fields:
      - fieldName: claim
        discriminatorValue: Claim
      - fieldName: prefix
        discriminatorValue: Prefix
- name: com.github.openshift.api.config.v1.UsernamePrefix
  map:
    fields:
    - name: prefixString
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.VSphereFailureDomainHostGroup
  map:
    fields:
    - name: hostGroup
      type:
        scalar: string
      default: ""
    - name: vmGroup
      type:
        scalar: string
      default: ""
    - name: vmHostRule
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.VSphereFailureDomainRegionAffinity
  map:
    fields:
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
- name: com.github.openshift.api.config.v1.VSphereFailureDomainZoneAffinity
  map:
    fields:
    - name: hostGroup
      type:
        namedType: com.github.openshift.api.config.v1.VSphereFailureDomainHostGroup
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: hostGroup
        discriminatorValue: HostGroup
- name: com.github.openshift.api.config.v1.VSpherePlatformFailureDomainSpec
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: region
      type:
        scalar: string
      default: ""
    - name: regionAffinity
      type:
        namedType: com.github.openshift.api.config.v1.VSphereFailureDomainRegionAffinity
    - name: server
      type:
        scalar: string
      default: ""
    - name: topology
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformTopology
      default: {}
    - name: zone
      type:
        scalar: string
      default: ""
    - name: zoneAffinity
      type:
        namedType: com.github.openshift.api.config.v1.VSphereFailureDomainZoneAffinity
- name: com.github.openshift.api.config.v1.VSpherePlatformLoadBalancer
  map:
    fields:
    - name: type
      type:
        scalar: string
      default: OpenShiftManagedDefault
    unions:
    - discriminator: type
- name: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworking
  map:
    fields:
    - name: external
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworkingSpec
      default: {}
    - name: internal
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworkingSpec
      default: {}
- name: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworkingSpec
  map:
    fields:
    - name: excludeNetworkSubnetCidr
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: network
      type:
        scalar: string
    - name: networkSubnetCidr
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
- name: com.github.openshift.api.config.v1.VSpherePlatformSpec
  map:
    fields:
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: failureDomains
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.VSpherePlatformFailureDomainSpec
          elementRelationship: associative
          keys:
          - name
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: machineNetworks
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: nodeNetworking
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworking
      default: {}
    - name: vcenters
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.VSpherePlatformVCenterSpec
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.VSpherePlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: loadBalancer
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformLoadBalancer
      default:
        type: OpenShiftManagedDefault
    - name: machineNetworks
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: nodeDNSIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.VSpherePlatformTopology
  map:
    fields:
    - name: computeCluster
      type:
        scalar: string
      default: ""
    - name: datacenter
      type:
        scalar: string
      default: ""
    - name: datastore
      type:
        scalar: string
      default: ""
    - name: folder
      type:
        scalar: string
    - name: networks
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: resourcePool
      type:
        scalar: string
    - name: template
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.VSpherePlatformVCenterSpec
  map:
    fields:
    - name: datacenters
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: port
      type:
        scalar: numeric
    - name: server
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.WebhookTokenAuthenticator
  map:
    fields:
    - name: kubeConfig
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1alpha1.AlertmanagerConfig
  map:
    fields:
    - name: customConfig
      type:
        namedType: com.github.openshift.api.config.v1alpha1.AlertmanagerCustomConfig
      default: {}
    - name: deploymentMode
      type:
        scalar: string
- name: com.github.openshift.api.config.v1alpha1.AlertmanagerCustomConfig
  map:
    fields:
    - name: logLevel
      type:
        scalar: string
    - name: nodeSelector
      type:
        map:
          elementType:
            scalar: string
    - name: resources
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1alpha1.ContainerResource
          elementRelationship: associative
          keys:
          - name
    - name: secrets
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: tolerations
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Toleration
          elementRelationship: atomic
    - name: topologySpreadConstraints
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.TopologySpreadConstraint
          elementRelationship: associative
          keys:
          - topologyKey
          - whenUnsatisfiable
    - name: volumeClaimTemplate
      type:
        namedType: io.k8s.api.core.v1.PersistentVolumeClaim
- name: com.github.openshift.api.config.v1alpha1.Audit
  map:
    fields:
    - name: profile
      type:
        scalar: string
- name: com.github.openshift.api.config.v1alpha1.Backup
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1alpha1.BackupSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1alpha1.BackupStatus
      default: {}
- name: com.github.openshift.api.config.v1alpha1.BackupSpec
  map:
    fields:
    - name: etcd
      type:
        namedType: com.github.openshift.api.config.v1alpha1.EtcdBackupSpec
      default: {}
- name: com.github.openshift.api.config.v1alpha1.BackupStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1alpha1.ClusterImagePolicy
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1alpha1.ClusterImagePolicySpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1alpha1.ClusterImagePolicyStatus
      default: {}
- name: com.github.openshift.api.config.v1alpha1.ClusterImagePolicySpec
  map:
    fields:
    - name: policy
      type:
        namedType: com.github.openshift.api.config.v1alpha1.Policy
      default: {}
    - name: scopes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
- name: com.github.openshift.api.config.v1alpha1.ClusterImagePolicyStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
- name: com.github.openshift.api.config.v1alpha1.ClusterMonitoring
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1alpha1.ClusterMonitoringSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1alpha1.ClusterMonitoringStatus
      default: {}
- name: com.github.openshift.api.config.v1alpha1.ClusterMonitoringSpec
  map:
    fields:
    - name: alertmanagerConfig
      type:
        namedType: com.github.openshift.api.config.v1alpha1.AlertmanagerConfig
      default: {}
    - name: metricsServerConfig
      type:
        namedType: com.github.openshift.api.config.v1alpha1.MetricsServerConfig
      default: {}
    - name: userDefined
      type:
        namedType: com.github.openshift.api.config.v1alpha1.UserDefinedMonitoring
      default: {}
- name: com.github.openshift.api.config.v1alpha1.ClusterMonitoringStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1alpha1.ContainerResource
  map:
    fields:
    - name: limit
      type:
        namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
    - name: name
      type:
        scalar: string
    - name: request
      type:
        namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
- name: com.github.openshift.api.config.v1alpha1.EtcdBackupSpec
  map:
    fields:
    - name: pvcName
      type:
        scalar: string
      default: ""
    - name: retentionPolicy
      type:
        namedType: com.github.openshift.api.config.v1alpha1.RetentionPolicy
      default: {}
    - name: schedule
      type:
        scalar: string
      default: ""
    - name: timeZone
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha1.FulcioCAWithRekor
  map:
    fields:
    - name: fulcioCAData
      type:
        scalar: string
    - name: fulcioSubject
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PolicyFulcioSubject
      default: {}
    - name: rekorKeyData
      type:
        scalar: string
- name: com.github.openshift.api.config.v1alpha1.GatherConfig
  map:
    fields:
    - name: dataPolicy
      type:
        scalar: string
    - name: disabledGatherers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: storage
      type:
        namedType: com.github.openshift.api.config.v1alpha1.Storage
- name: com.github.openshift.api.config.v1alpha1.ImagePolicy
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1alpha1.ImagePolicySpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1alpha1.ImagePolicyStatus
      default: {}
- name: com.github.openshift.api.config.v1alpha1.ImagePolicySpec
  map:
    fields:
    - name: policy
      type:
        namedType: com.github.openshift.api.config.v1alpha1.Policy
      default: {}
    - name: scopes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
- name: com.github.openshift.api.config.v1alpha1.ImagePolicyStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
- name: com.github.openshift.api.config.v1alpha1.InsightsDataGather
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1alpha1.InsightsDataGatherSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1alpha1.InsightsDataGatherStatus
      default: {}
- name: com.github.openshift.api.config.v1alpha1.InsightsDataGatherSpec
  map:
    fields:
    - name: gatherConfig
      type:
        namedType: com.github.openshift.api.config.v1alpha1.GatherConfig
      default: {}
- name: com.github.openshift.api.config.v1alpha1.InsightsDataGatherStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1alpha1.MetricsServerConfig
  map:
    fields:
    - name: audit
      type:
        namedType: com.github.openshift.api.config.v1alpha1.Audit
      default: {}
    - name: nodeSelector
      type:
        map:
          elementType:
            scalar: string
    - name: resources
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1alpha1.ContainerResource
          elementRelationship: associative
          keys:
          - name
    - name: tolerations
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Toleration
          elementRelationship: atomic
    - name: topologySpreadConstraints
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.TopologySpreadConstraint
          elementRelationship: associative
          keys:
          - topologyKey
          - whenUnsatisfiable
    - name: verbosity
      type:
        scalar: string
- name: com.github.openshift.api.config.v1alpha1.PKI
  map:
    fields:
    - name: caIntermediatesData
      type:
        scalar: string
    - name: caRootsData
      type:
        scalar: string
    - name: pkiCertificateSubject
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PKICertificateSubject
      default: {}
- name: com.github.openshift.api.config.v1alpha1.PKICertificateSubject
  map:
    fields:
    - name: email
      type:
        scalar: string
    - name: hostname
      type:
        scalar: string
- name: com.github.openshift.api.config.v1alpha1.PersistentVolumeClaimReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha1.PersistentVolumeConfig
  map:
    fields:
    - name: claim
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PersistentVolumeClaimReference
      default: {}
    - name: mountPath
      type:
        scalar: string
- name: com.github.openshift.api.config.v1alpha1.Policy
  map:
    fields:
    - name: rootOfTrust
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PolicyRootOfTrust
      default: {}
    - name: signedIdentity
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PolicyIdentity
      default: {}
- name: com.github.openshift.api.config.v1alpha1.PolicyFulcioSubject
  map:
    fields:
    - name: oidcIssuer
      type:
        scalar: string
      default: ""
    - name: signedEmail
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha1.PolicyIdentity
  map:
    fields:
    - name: exactRepository
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PolicyMatchExactRepository
    - name: matchPolicy
      type:
        scalar: string
      default: ""
    - name: remapIdentity
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PolicyMatchRemapIdentity
    unions:
    - discriminator: matchPolicy
      fields:
      - fieldName: exactRepository
        discriminatorValue: PolicyMatchExactRepository
      - fieldName: remapIdentity
        discriminatorValue: PolicyMatchRemapIdentity
- name: com.github.openshift.api.config.v1alpha1.PolicyMatchExactRepository
  map:
    fields:
    - name: repository
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha1.PolicyMatchRemapIdentity
  map:
    fields:
    - name: prefix
      type:
        scalar: string
      default: ""
    - name: signedPrefix
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha1.PolicyRootOfTrust
  map:
    fields:
    - name: fulcioCAWithRekor
      type:
        namedType: com.github.openshift.api.config.v1alpha1.FulcioCAWithRekor
    - name: pki
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PKI
    - name: policyType
      type:
        scalar: string
      default: ""
    - name: publicKey
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PublicKey
    unions:
    - discriminator: policyType
      fields:
      - fieldName: fulcioCAWithRekor
        discriminatorValue: FulcioCAWithRekor
      - fieldName: pki
        discriminatorValue: PKI
      - fieldName: publicKey
        discriminatorValue: PublicKey
- name: com.github.openshift.api.config.v1alpha1.PublicKey
  map:
    fields:
    - name: keyData
      type:
        scalar: string
    - name: rekorKeyData
      type:
        scalar: string
- name: com.github.openshift.api.config.v1alpha1.RetentionNumberConfig
  map:
    fields:
    - name: maxNumberOfBackups
      type:
        scalar: numeric
      default: 0
- name: com.github.openshift.api.config.v1alpha1.RetentionPolicy
  map:
    fields:
    - name: retentionNumber
      type:
        namedType: com.github.openshift.api.config.v1alpha1.RetentionNumberConfig
    - name: retentionSize
      type:
        namedType: com.github.openshift.api.config.v1alpha1.RetentionSizeConfig
    - name: retentionType
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: retentionType
      fields:
      - fieldName: retentionNumber
        discriminatorValue: RetentionNumber
      - fieldName: retentionSize
        discriminatorValue: RetentionSize
- name: com.github.openshift.api.config.v1alpha1.RetentionSizeConfig
  map:
    fields:
    - name: maxSizeOfBackupsGb
      type:
        scalar: numeric
      default: 0
- name: com.github.openshift.api.config.v1alpha1.Storage
  map:
    fields:
    - name: persistentVolume
      type:
        namedType: com.github.openshift.api.config.v1alpha1.PersistentVolumeConfig
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha1.UserDefinedMonitoring
  map:
    fields:
    - name: mode
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha2.Custom
  map:
    fields:
    - name: configs
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1alpha2.GathererConfig
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1alpha2.GatherConfig
  map:
    fields:
    - name: dataPolicy
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: gatherers
      type:
        namedType: com.github.openshift.api.config.v1alpha2.Gatherers
      default: {}
    - name: storage
      type:
        namedType: com.github.openshift.api.config.v1alpha2.Storage
- name: com.github.openshift.api.config.v1alpha2.GathererConfig
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: state
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha2.Gatherers
  map:
    fields:
    - name: custom
      type:
        namedType: com.github.openshift.api.config.v1alpha2.Custom
    - name: mode
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha2.InsightsDataGather
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1alpha2.InsightsDataGatherSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1alpha2.InsightsDataGatherStatus
      default: {}
- name: com.github.openshift.api.config.v1alpha2.InsightsDataGatherSpec
  map:
    fields:
    - name: gatherConfig
      type:
        namedType: com.github.openshift.api.config.v1alpha2.GatherConfig
      default: {}
- name: com.github.openshift.api.config.v1alpha2.InsightsDataGatherStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1alpha2.PersistentVolumeClaimReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1alpha2.PersistentVolumeConfig
  map:
    fields:
    - name: claim
      type:
        namedType: com.github.openshift.api.config.v1alpha2.PersistentVolumeClaimReference
      default: {}
    - name: mountPath
      type:
        scalar: string
- name: com.github.openshift.api.config.v1alpha2.Storage
  map:
    fields:
    - name: persistentVolume
      type:
        namedType: com.github.openshift.api.config.v1alpha2.PersistentVolumeConfig
    - name: type
      type:
        scalar: string
      default: ""
- name: io.k8s.api.core.v1.ConfigMapKeySelector
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: optional
      type:
        scalar: boolean
    elementRelationship: atomic
- name: io.k8s.api.core.v1.EnvVar
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
    - name: valueFrom
      type:
        namedType: io.k8s.api.core.v1.EnvVarSource
- name: io.k8s.api.core.v1.EnvVarSource
  map:
    fields:
    - name: configMapKeyRef
      type:
        namedType: io.k8s.api.core.v1.ConfigMapKeySelector
    - name: fieldRef
      type:
        namedType: io.k8s.api.core.v1.ObjectFieldSelector
    - name: fileKeyRef
      type:
        namedType: io.k8s.api.core.v1.FileKeySelector
    - name: resourceFieldRef
      type:
        namedType: io.k8s.api.core.v1.ResourceFieldSelector
    - name: secretKeyRef
      type:
        namedType: io.k8s.api.core.v1.SecretKeySelector
- name: io.k8s.api.core.v1.FileKeySelector
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: optional
      type:
        scalar: boolean
      default: false
    - name: path
      type:
        scalar: string
      default: ""
    - name: volumeName
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.api.core.v1.ModifyVolumeStatus
  map:
    fields:
    - name: status
      type:
        scalar: string
      default: ""
    - name: targetVolumeAttributesClassName
      type:
        scalar: string
- name: io.k8s.api.core.v1.ObjectFieldSelector
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: fieldPath
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.api.core.v1.PersistentVolumeClaim
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: io.k8s.api.core.v1.PersistentVolumeClaimSpec
      default: {}
    - name: status
      type:
        namedType: io.k8s.api.core.v1.PersistentVolumeClaimStatus
      default: {}
- name: io.k8s.api.core.v1.PersistentVolumeClaimCondition
  map:
    fields:
    - name: lastProbeTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: message
      type:
        scalar: string
    - name: reason
      type:
        scalar: string
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: io.k8s.api.core.v1.PersistentVolumeClaimSpec
  map:
    fields:
    - name: accessModes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: dataSource
      type:
        namedType: io.k8s.api.core.v1.TypedLocalObjectReference
    - name: dataSourceRef
      type:
        namedType: io.k8s.api.core.v1.TypedObjectReference
    - name: resources
      type:
        namedType: io.k8s.api.core.v1.VolumeResourceRequirements
      default: {}
    - name: selector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: storageClassName
      type:
        scalar: string
    - name: volumeAttributesClassName
      type:
        scalar: string
    - name: volumeMode
      type:
        scalar: string
    - name: volumeName
      type:
        scalar: string
- name: io.k8s.api.core.v1.PersistentVolumeClaimStatus
  map:
    fields:
    - name: accessModes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: allocatedResourceStatuses
      type:
        map:
          elementType:
            scalar: string
          elementRelationship: separable
    - name: allocatedResources
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
    - name: capacity
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.PersistentVolumeClaimCondition
          elementRelationship: associative
          keys:
          - type
    - name: currentVolumeAttributesClassName
      type:
        scalar: string
    - name: modifyVolumeStatus
      type:
        namedType: io.k8s.api.core.v1.ModifyVolumeStatus
    - name: phase
      type:
        scalar: string
- name: io.k8s.api.core.v1.ResourceClaim
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: request
      type:
        scalar: string
- name: io.k8s.api.core.v1.ResourceFieldSelector
  map:
    fields:
    - name: containerName
      type:
        scalar: string
    - name: divisor
      type:
        namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
    - name: resource
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.api.core.v1.ResourceRequirements
  map:
    fields:
    - name: claims
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.ResourceClaim
          elementRelationship: associative
          keys:
          - name
    - name: limits
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
    - name: requests
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
- name: io.k8s.api.core.v1.SecretKeySelector
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: optional
      type:
        scalar: boolean
    elementRelationship: atomic
- name: io.k8s.api.core.v1.Toleration
  map:
    fields:
    - name: effect
      type:
        scalar: string
    - name: key
      type:
        scalar: string
    - name: operator
      type:
        scalar: string
    - name: tolerationSeconds
      type:
        scalar: numeric
    - name: value
      type:
        scalar: string
- name: io.k8s.api.core.v1.TopologySpreadConstraint
  map:
    fields:
    - name: labelSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: matchLabelKeys
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: maxSkew
      type:
        scalar: numeric
      default: 0
    - name: minDomains
      type:
        scalar: numeric
    - name: nodeAffinityPolicy
      type:
        scalar: string
    - name: nodeTaintsPolicy
      type:
        scalar: string
    - name: topologyKey
      type:
        scalar: string
      default: ""
    - name: whenUnsatisfiable
      type:
        scalar: string
      default: ""
- name: io.k8s.api.core.v1.TypedLocalObjectReference
  map:
    fields:
    - name: apiGroup
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.api.core.v1.TypedObjectReference
  map:
    fields:
    - name: apiGroup
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
- name: io.k8s.api.core.v1.VolumeResourceRequirements
  map:
    fields:
    - name: limits
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
    - name: requests
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
- name: io.k8s.apimachinery.pkg.api.resource.Quantity
  scalar: untyped
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
  map:
    fields:
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: message
      type:
        scalar: string
      default: ""
    - name: observedGeneration
      type:
        scalar: numeric
    - name: reason
      type:
        scalar: string
      default: ""
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
  scalar: string
- name: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
  map:
    fields:
    - name: matchExpressions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
          elementRelationship: atomic
    - name: matchLabels
      type:
        map:
          elementType:
            scalar: string
    elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: operator
      type:
        scalar: string
      default: ""
    - name: values
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: fieldsType
      type:
        scalar: string
    - name: fieldsV1
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1
    - name: manager
      type:
        scalar: string
    - name: operation
      type:
        scalar: string
    - name: subresource
      type:
        scalar: string
    - name: time
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
- name: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
  map:
    fields:
    - name: annotations
      type:
        map:
          elementType:
            scalar: string
    - name: creationTimestamp
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: deletionGracePeriodSeconds
      type:
        scalar: numeric
    - name: deletionTimestamp
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: finalizers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: generateName
      type:
        scalar: string
    - name: generation
      type:
        scalar: numeric
    - name: labels
      type:
        map:
          elementType:
            scalar: string
    - name: managedFields
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
          elementRelationship: atomic
    - name: name
      type:
        scalar: string
    - name: namespace
      type:
        scalar: string
    - name: ownerReferences
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference
          elementRelationship: associative
          keys:
          - uid
    - name: resourceVersion
      type:
        scalar: string
    - name: selfLink
      type:
        scalar: string
    - name: uid
      type:
        scalar: string
- name: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
      default: ""
    - name: blockOwnerDeletion
      type:
        scalar: boolean
    - name: controller
      type:
        scalar: boolean
    - name: kind
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: uid
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Time
  scalar: untyped
- name: io.k8s.apimachinery.pkg.runtime.RawExtension
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: __untyped_atomic_
  scalar: untyped
  list:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
  map:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
- name: __untyped_deduced_
  scalar: untyped
  list:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
  map:
    elementType:
      namedType: __untyped_deduced_
    elementRelationship: separable
`)
