## nsc list keys

List operator, account and user keys in the current operator and account context

### Synopsis

List operator, account and user keys in the current operator and account context.
Additional flags allow you to specify which types of keys to display. For example
the --operator shows the operator key, the --accounts show account keys, etc.

You can further limit the account and user displayed by specifying the 
--account and --user flags respectively. To list all keys specify 
the --all flag.

The --not-referenced flag displays all keys not relevant to the current 
operator, accounts and users. These keys may be referenced in a different 
operator context.

The --filter flag allows you to specify a few letters in a public key
and display only those keys that match provided the --operator, 
--accounts, and --user or --all flags match the key type.


```
nsc list keys [flags]
```

### Examples

```
nsc list keys
nsc list keys --all (same as specifying --operator --accounts --users)
nsc list keys --operator --not-referenced (shows all other operator keys)
nsc list keys --all --filter VSVMGA (shows all keys containing the filter)
nsc list keys --account A (changes the account context to the specified account)

```

### Options

```
      --account string   show specified account keys
  -a, --accounts         show account keys
  -A, --all              show operator, accounts and users
  -x, --curve            show curve keys
  -f, --filter string    filter keys containing string
  -h, --help             help for keys
      --not-referenced   shows keys that are not referenced in the current operator context
  -o, --operator         show operator keys
  -S, --show-seeds       shows seed keys value
      --user string      show specified user key
  -u, --users            show user keys
```

### Options inherited from parent commands

```
  -H, --all-dirs string       sets --config-dir, --data-dir, and --keystore-dir to the same value
      --config-dir string     nsc config directory
      --data-dir string       nsc data store directory
  -i, --interactive           ask questions for various settings
      --keystore-dir string   nsc keystore directory
  -K, --private-key string    Key used to sign. Can be specified as role (where applicable),
                              public key (private portion is retrieved)
                              or file path to a private key or private key 
```

### SEE ALSO

* [nsc list](nsc_list.md)	 - List assets such as accounts, imports, users

###### Auto generated by spf13/cobra on 2-Jan-2025
