Configuration
==============

`mockery init`
--------------

`mockery init [module_name]` is a useful command that can bootstrap you with a fully-functioning configuration set. For example, if we run:

``` title=""
$ mockery init github.com/vektra/mockery/v3/internal/fixtures
2025-03-14T23:06:12.535709000-05:00 INF writing to file file=.mockery.yml version=v0.0.0-dev
2025-03-14T23:06:12.536493000-05:00 INF done version=v0.0.0-dev
```
<div class="result">
```yaml title=".mockery.yml"
all: false
dir: '{{.InterfaceDir}}'
filename: mocks_test.go
force-file-write: false
formatter: goimports
log-level: info
structname: {{.Mock}}{{.InterfaceName}}
pkgname: '{{.SrcPackageName}}'
recursive: false
template: testify
packages:
  github.com/vektra/mockery/v3/internal/fixtures:
    config:
      all: true
```
</div>

We can then run mockery against this config to generate the code:

``` title=""
$ mockery
2025-03-14T23:42:17.014113000-05:00 INF Starting mockery config-file=/Users/landon/git/LandonTClipp/mockery/.mockery.yaml version=v0.0.0-dev
2025-03-14T23:42:17.014258000-05:00 INF Parsing configured packages... version=v0.0.0-dev
2025-03-14T23:42:17.527483000-05:00 INF Done parsing configured packages. version=v0.0.0-dev
[...]
2025-03-14T23:42:17.531239000-05:00 INF Executing template file=/Users/landon/git/LandonTClipp/mockery/internal/fixtures/mocks_test.go version=v0.0.0-dev
2025-03-14T23:42:17.690601000-05:00 INF Writing template to file file=/Users/landon/git/LandonTClipp/mockery/internal/fixtures/mocks_test.go version=v0.0.0-dev
```
<div class="result">

```title=""
$ head -n 17 /Users/landon/git/LandonTClipp/mockery/internal/fixtures/mocks_test.go
// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery

package test

import (
        "encoding/json"
        "io"
        "net/http"
        "unsafe"

        mock "github.com/stretchr/testify/mock"
        http1 "github.com/vektra/mockery/v3/internal/fixtures/12345678/http"
        "github.com/vektra/mockery/v3/internal/fixtures/constraints"
        http0 "github.com/vektra/mockery/v3/internal/fixtures/http"
        test "github.com/vektra/mockery/v3/internal/fixtures/redefined_type_b"
)
```

</div>

??? tip "Extended Example"

    A more complex configuration example can be seen below:

    ```yaml
    all: False
    template-data:
      boilerplate-file: ./path/to/boilerplate.txt
    template: testify
    packages:
      github.com/vektra/example:
        config:
          # Make use of the template variables to place the mock in the same
          # directory as the original interface.
          dir: "{{.InterfaceDir}}"
          filename: "mocks_test.go"
          outpkg: "{{.PackageName}}_test"
          structname: "{{.Mock}}{{.InterfaceName}}"
        interfaces:
          Foo:
          Bar:
            config:
              # Make it unexported instead
              structname: "mock{{.InterfaceName}}"
          Baz:
            # Create two mock implementations of Baz with different names.
            configs:
              - filename: "mocks_baz_one_test.go"
                structname: "MockBazOne"
              - filename: "mocks_baz_two_test.go"
                structname: "MockBazTwo"
      io:
        config:
          dir: path/to/io/mocks
          filename: "mocks_io.go"
    ```

    These are the highlights of the config scheme:

    1. The parameters are merged hierarchically
    2. There are a number of template variables available to generalize config values.
    3. The style of mock to be generated is specified using the [`template`](template/index.md) parameter.

Parameter Descriptions
-----------------------

[![go.dev reference](https://img.shields.io/badge/go.dev-reference-007d9c?logo=go&logoColor=white&style=flat-square)](https://pkg.go.dev/github.com/vektra/mockery/v3/config#Config)

| name                                                   | templated                 | default                               | description                                                                                                                                                                                                                                          |
|--------------------------------------------------------|---------------------------|---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `all`                                                  | :fontawesome-solid-x:     | `#!yaml false`                        | Generate all interfaces for the specified packages.                                                                                                                                                                                                  |
| `_anchors`                                             | :fontawesome-solid-x:     | `#!yaml {}`                           | Unused by mockery, but allowed in the config schema so that you may define arbitrary yaml anchors.                                                                                                                                                   |
| `config`                                               | :fontawesome-solid-x:     | `#!yaml ""`                           | Set the location of the mockery config file.                                                                                                                                                                                                         |
| `dir`                                                  | :fontawesome-solid-check: | `#!yaml "{{.InterfaceDir}}"`  | The directory where the mock file will be outputted to.                                                                                                                                                                                              |
| `exclude-subpkg-regex`                                 | :fontawesome-solid-x:     | `#!yaml []`                           | A list of regular expressions that denote which subpackages should be excluded when `#!yaml recursive: true` |
| `exclude-interface-regex`                              | :fontawesome-solid-x:     | `#!yaml ""`                           | When set along with `include-interface-regex`, then interfaces which match `include-interface-regex` but also match `exclude-interface-regex` will not be generated. If `all` is set, or if `include-interface-regex` is not set, then `exclude-interface-regex` has no effect.                        |
| `filename`                                             | :fontawesome-solid-check: | `#!yaml "mocks_test.go"` | The name of the file the mock will reside in.                                                                                                                                                                                                        |
| `force-file-write`                                     | :fontawesome-solid-x:     | `#!yaml true`                        | When set to `#!yaml force-file-write: true`, mockery will forcibly overwrite any existing files. Otherwise, it will fail if the output file already exists. |
| `formatter`                                            | :fontawesome-solid-x:     | `#!yaml "goimports"`                  | The formatter to use on the rendered template. Choices are: `gofmt`, `goimports`, `noop`.                                                                                                                                                            |
| `include-interface-regex`                              | :fontawesome-solid-x:     | `#!yaml ""`                           | When set, only interface names that match the expression will be generated. This setting is ignored if `all: True` is specified in the configuration. To further refine the interfaces generated, use `exclude-interface-regex`.                               |
| `log-level`                                            | :fontawesome-solid-x:     | `#!yaml "info"`                       | Set the level of the logger                                                                                                                                                                                                                          |
| `structname`                                           | :fontawesome-solid-check: | `#!yaml "{{.Mock}}{{.InterfaceName}}"` | The name of the generated interface implementation.                                                                                                                                                                                                                      |
| `packages`                                             | :fontawesome-solid-x:     | `#!yaml null`                         | A dictionary containing configuration describing the packages and interfaces to generate mocks for.                                                                                                                                                  |
| `pkgname`                                              | :fontawesome-solid-check: | `#!yaml "{{.SrcPackageName}}"`        | The `#!go package name` given to the generated mock files.                                                                                                                                                                                           |
| `recursive`                                            | :fontawesome-solid-x:     | `#!yaml false`                        | When set to `true` on a particular package, mockery will recursively search for all sub-packages and inject those packages into the config map.                                                                                                      |
| [`replace-type`](replace-type.md){ data-preview }      | :fontawesome-solid-x:     | `#!yaml {}`                           | Use this parameter to specify type replacements.                                 |
| `build-tags`                                           | :fontawesome-solid-x:     | `#!yaml ""`                           | A space-separated list of additional build tags to load packages.                                                                                                                                                                                    |
| `require-template-schema-exists`                       | :fontawesome-solid-x:     | `#!yaml true`                         | If set to `#!yaml true` and the schema failed to download, mockery will fail. Otherwise, mockery will not attempt to download the file nor do any schema validation.                                                |
| `template`                                             | :fontawesome-solid-x:     | `#!yaml ""`                           | The template to use. The choices are defined in the [Templates](../template/) section.                                                                                                                                        |
| `template-data`                                        | :fontawesome-solid-x:     | `#!yaml {}`                           | A `map[string]any` that provides arbitrary options to the template. Each template will have a different set of accepted keys. Refer to each template's documentation for more details.                                                               |
| `template-schema`                                      | :fontawesome-solid-check: | `#!yaml "{{.Template}}.schema.json"`  | The URL of the JSON schema to apply to the `template-data` parameter. See the [template docs](./template/index.md#schemas){ data-preview } for more details. |

Templates
---------

Parameters marked as being templated have access to a number of template variables and functions through the Go [`text/template`](https://pkg.go.dev/text/template#hdr-Examples) system.

### Variables

The variables provided are specified in the [`config.Data`](https://pkg.go.dev/github.com/vektra/mockery/v3/config#Data) struct.

### Functions

All of the functions defined in [`StringManipulationFuncs`](https://pkg.go.dev/github.com/vektra/mockery/v3/shared#pkg-variables) are available to templated parameters.

Config sources
--------------

Config can not only be specified from the `.yml` file, but also from CLI parameters (where available) and environment variables. For example, specifying a boolean value for a particular parameter called `enable-feature` from each config source would look like this:

| source               | value                        |
|----------------------|------------------------------|
| command line         | `--enable-feature=true`       |
| Environment variable | `MOCKERY_ENABLE_FEATURE=True` |
| yaml                 | `#!yaml enable-feature: True` |

Config is loaded from each source in the following order:

1. Default values
2. Environment variables
3. Config file
4. CLI Parameters
