//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by openapi-gen. DO NOT EDIT.

package openapi

import (
	v1 "k8s.io/api/core/v1"
	apiextensionsv1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1"
	v1beta1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1"
	resource "k8s.io/apimachinery/pkg/api/resource"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
	common "k8s.io/kube-openapi/pkg/common"
	spec "k8s.io/kube-openapi/pkg/validation/spec"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"k8s.io/api/admissionregistration/v1.AuditAnnotation":                                                   schema_k8sio_api_admissionregistration_v1_AuditAnnotation(ref),
		"k8s.io/api/admissionregistration/v1.ExpressionWarning":                                                 schema_k8sio_api_admissionregistration_v1_ExpressionWarning(ref),
		"k8s.io/api/admissionregistration/v1.MatchCondition":                                                    schema_k8sio_api_admissionregistration_v1_MatchCondition(ref),
		"k8s.io/api/admissionregistration/v1.MatchResources":                                                    schema_k8sio_api_admissionregistration_v1_MatchResources(ref),
		"k8s.io/api/admissionregistration/v1.MutatingWebhook":                                                   schema_k8sio_api_admissionregistration_v1_MutatingWebhook(ref),
		"k8s.io/api/admissionregistration/v1.MutatingWebhookConfiguration":                                      schema_k8sio_api_admissionregistration_v1_MutatingWebhookConfiguration(ref),
		"k8s.io/api/admissionregistration/v1.MutatingWebhookConfigurationList":                                  schema_k8sio_api_admissionregistration_v1_MutatingWebhookConfigurationList(ref),
		"k8s.io/api/admissionregistration/v1.NamedRuleWithOperations":                                           schema_k8sio_api_admissionregistration_v1_NamedRuleWithOperations(ref),
		"k8s.io/api/admissionregistration/v1.ParamKind":                                                         schema_k8sio_api_admissionregistration_v1_ParamKind(ref),
		"k8s.io/api/admissionregistration/v1.ParamRef":                                                          schema_k8sio_api_admissionregistration_v1_ParamRef(ref),
		"k8s.io/api/admissionregistration/v1.Rule":                                                              schema_k8sio_api_admissionregistration_v1_Rule(ref),
		"k8s.io/api/admissionregistration/v1.RuleWithOperations":                                                schema_k8sio_api_admissionregistration_v1_RuleWithOperations(ref),
		"k8s.io/api/admissionregistration/v1.ServiceReference":                                                  schema_k8sio_api_admissionregistration_v1_ServiceReference(ref),
		"k8s.io/api/admissionregistration/v1.TypeChecking":                                                      schema_k8sio_api_admissionregistration_v1_TypeChecking(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicy":                                         schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicy(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyBinding":                                  schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBinding(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyBindingList":                              schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBindingList(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyBindingSpec":                              schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBindingSpec(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyList":                                     schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyList(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicySpec":                                     schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicySpec(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyStatus":                                   schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyStatus(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingWebhook":                                                 schema_k8sio_api_admissionregistration_v1_ValidatingWebhook(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingWebhookConfiguration":                                    schema_k8sio_api_admissionregistration_v1_ValidatingWebhookConfiguration(ref),
		"k8s.io/api/admissionregistration/v1.ValidatingWebhookConfigurationList":                                schema_k8sio_api_admissionregistration_v1_ValidatingWebhookConfigurationList(ref),
		"k8s.io/api/admissionregistration/v1.Validation":                                                        schema_k8sio_api_admissionregistration_v1_Validation(ref),
		"k8s.io/api/admissionregistration/v1.Variable":                                                          schema_k8sio_api_admissionregistration_v1_Variable(ref),
		"k8s.io/api/admissionregistration/v1.WebhookClientConfig":                                               schema_k8sio_api_admissionregistration_v1_WebhookClientConfig(ref),
		"k8s.io/api/admissionregistration/v1alpha1.AuditAnnotation":                                             schema_k8sio_api_admissionregistration_v1alpha1_AuditAnnotation(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ExpressionWarning":                                           schema_k8sio_api_admissionregistration_v1alpha1_ExpressionWarning(ref),
		"k8s.io/api/admissionregistration/v1alpha1.MatchCondition":                                              schema_k8sio_api_admissionregistration_v1alpha1_MatchCondition(ref),
		"k8s.io/api/admissionregistration/v1alpha1.MatchResources":                                              schema_k8sio_api_admissionregistration_v1alpha1_MatchResources(ref),
		"k8s.io/api/admissionregistration/v1alpha1.NamedRuleWithOperations":                                     schema_k8sio_api_admissionregistration_v1alpha1_NamedRuleWithOperations(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ParamKind":                                                   schema_k8sio_api_admissionregistration_v1alpha1_ParamKind(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ParamRef":                                                    schema_k8sio_api_admissionregistration_v1alpha1_ParamRef(ref),
		"k8s.io/api/admissionregistration/v1alpha1.TypeChecking":                                                schema_k8sio_api_admissionregistration_v1alpha1_TypeChecking(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicy":                                   schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicy(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyBinding":                            schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBinding(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyBindingList":                        schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBindingList(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyBindingSpec":                        schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBindingSpec(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyList":                               schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyList(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicySpec":                               schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicySpec(ref),
		"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyStatus":                             schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyStatus(ref),
		"k8s.io/api/admissionregistration/v1alpha1.Validation":                                                  schema_k8sio_api_admissionregistration_v1alpha1_Validation(ref),
		"k8s.io/api/admissionregistration/v1alpha1.Variable":                                                    schema_k8sio_api_admissionregistration_v1alpha1_Variable(ref),
		"k8s.io/api/admissionregistration/v1beta1.AuditAnnotation":                                              schema_k8sio_api_admissionregistration_v1beta1_AuditAnnotation(ref),
		"k8s.io/api/admissionregistration/v1beta1.ExpressionWarning":                                            schema_k8sio_api_admissionregistration_v1beta1_ExpressionWarning(ref),
		"k8s.io/api/admissionregistration/v1beta1.MatchCondition":                                               schema_k8sio_api_admissionregistration_v1beta1_MatchCondition(ref),
		"k8s.io/api/admissionregistration/v1beta1.MatchResources":                                               schema_k8sio_api_admissionregistration_v1beta1_MatchResources(ref),
		"k8s.io/api/admissionregistration/v1beta1.MutatingWebhook":                                              schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhook(ref),
		"k8s.io/api/admissionregistration/v1beta1.MutatingWebhookConfiguration":                                 schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhookConfiguration(ref),
		"k8s.io/api/admissionregistration/v1beta1.MutatingWebhookConfigurationList":                             schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhookConfigurationList(ref),
		"k8s.io/api/admissionregistration/v1beta1.NamedRuleWithOperations":                                      schema_k8sio_api_admissionregistration_v1beta1_NamedRuleWithOperations(ref),
		"k8s.io/api/admissionregistration/v1beta1.ParamKind":                                                    schema_k8sio_api_admissionregistration_v1beta1_ParamKind(ref),
		"k8s.io/api/admissionregistration/v1beta1.ParamRef":                                                     schema_k8sio_api_admissionregistration_v1beta1_ParamRef(ref),
		"k8s.io/api/admissionregistration/v1beta1.ServiceReference":                                             schema_k8sio_api_admissionregistration_v1beta1_ServiceReference(ref),
		"k8s.io/api/admissionregistration/v1beta1.TypeChecking":                                                 schema_k8sio_api_admissionregistration_v1beta1_TypeChecking(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicy":                                    schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicy(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyBinding":                             schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBinding(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyBindingList":                         schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBindingList(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyBindingSpec":                         schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBindingSpec(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyList":                                schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyList(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicySpec":                                schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicySpec(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyStatus":                              schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyStatus(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingWebhook":                                            schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhook(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingWebhookConfiguration":                               schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhookConfiguration(ref),
		"k8s.io/api/admissionregistration/v1beta1.ValidatingWebhookConfigurationList":                           schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhookConfigurationList(ref),
		"k8s.io/api/admissionregistration/v1beta1.Validation":                                                   schema_k8sio_api_admissionregistration_v1beta1_Validation(ref),
		"k8s.io/api/admissionregistration/v1beta1.Variable":                                                     schema_k8sio_api_admissionregistration_v1beta1_Variable(ref),
		"k8s.io/api/admissionregistration/v1beta1.WebhookClientConfig":                                          schema_k8sio_api_admissionregistration_v1beta1_WebhookClientConfig(ref),
		"k8s.io/api/apidiscovery/v2.APIGroupDiscovery":                                                          schema_k8sio_api_apidiscovery_v2_APIGroupDiscovery(ref),
		"k8s.io/api/apidiscovery/v2.APIGroupDiscoveryList":                                                      schema_k8sio_api_apidiscovery_v2_APIGroupDiscoveryList(ref),
		"k8s.io/api/apidiscovery/v2.APIResourceDiscovery":                                                       schema_k8sio_api_apidiscovery_v2_APIResourceDiscovery(ref),
		"k8s.io/api/apidiscovery/v2.APISubresourceDiscovery":                                                    schema_k8sio_api_apidiscovery_v2_APISubresourceDiscovery(ref),
		"k8s.io/api/apidiscovery/v2.APIVersionDiscovery":                                                        schema_k8sio_api_apidiscovery_v2_APIVersionDiscovery(ref),
		"k8s.io/api/apidiscovery/v2beta1.APIGroupDiscovery":                                                     schema_k8sio_api_apidiscovery_v2beta1_APIGroupDiscovery(ref),
		"k8s.io/api/apidiscovery/v2beta1.APIGroupDiscoveryList":                                                 schema_k8sio_api_apidiscovery_v2beta1_APIGroupDiscoveryList(ref),
		"k8s.io/api/apidiscovery/v2beta1.APIResourceDiscovery":                                                  schema_k8sio_api_apidiscovery_v2beta1_APIResourceDiscovery(ref),
		"k8s.io/api/apidiscovery/v2beta1.APISubresourceDiscovery":                                               schema_k8sio_api_apidiscovery_v2beta1_APISubresourceDiscovery(ref),
		"k8s.io/api/apidiscovery/v2beta1.APIVersionDiscovery":                                                   schema_k8sio_api_apidiscovery_v2beta1_APIVersionDiscovery(ref),
		"k8s.io/api/apiserverinternal/v1alpha1.ServerStorageVersion":                                            schema_k8sio_api_apiserverinternal_v1alpha1_ServerStorageVersion(ref),
		"k8s.io/api/apiserverinternal/v1alpha1.StorageVersion":                                                  schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersion(ref),
		"k8s.io/api/apiserverinternal/v1alpha1.StorageVersionCondition":                                         schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionCondition(ref),
		"k8s.io/api/apiserverinternal/v1alpha1.StorageVersionList":                                              schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionList(ref),
		"k8s.io/api/apiserverinternal/v1alpha1.StorageVersionSpec":                                              schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionSpec(ref),
		"k8s.io/api/apiserverinternal/v1alpha1.StorageVersionStatus":                                            schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionStatus(ref),
		"k8s.io/api/apps/v1.ControllerRevision":                                                                 schema_k8sio_api_apps_v1_ControllerRevision(ref),
		"k8s.io/api/apps/v1.ControllerRevisionList":                                                             schema_k8sio_api_apps_v1_ControllerRevisionList(ref),
		"k8s.io/api/apps/v1.DaemonSet":                                                                          schema_k8sio_api_apps_v1_DaemonSet(ref),
		"k8s.io/api/apps/v1.DaemonSetCondition":                                                                 schema_k8sio_api_apps_v1_DaemonSetCondition(ref),
		"k8s.io/api/apps/v1.DaemonSetList":                                                                      schema_k8sio_api_apps_v1_DaemonSetList(ref),
		"k8s.io/api/apps/v1.DaemonSetSpec":                                                                      schema_k8sio_api_apps_v1_DaemonSetSpec(ref),
		"k8s.io/api/apps/v1.DaemonSetStatus":                                                                    schema_k8sio_api_apps_v1_DaemonSetStatus(ref),
		"k8s.io/api/apps/v1.DaemonSetUpdateStrategy":                                                            schema_k8sio_api_apps_v1_DaemonSetUpdateStrategy(ref),
		"k8s.io/api/apps/v1.Deployment":                                                                         schema_k8sio_api_apps_v1_Deployment(ref),
		"k8s.io/api/apps/v1.DeploymentCondition":                                                                schema_k8sio_api_apps_v1_DeploymentCondition(ref),
		"k8s.io/api/apps/v1.DeploymentList":                                                                     schema_k8sio_api_apps_v1_DeploymentList(ref),
		"k8s.io/api/apps/v1.DeploymentSpec":                                                                     schema_k8sio_api_apps_v1_DeploymentSpec(ref),
		"k8s.io/api/apps/v1.DeploymentStatus":                                                                   schema_k8sio_api_apps_v1_DeploymentStatus(ref),
		"k8s.io/api/apps/v1.DeploymentStrategy":                                                                 schema_k8sio_api_apps_v1_DeploymentStrategy(ref),
		"k8s.io/api/apps/v1.ReplicaSet":                                                                         schema_k8sio_api_apps_v1_ReplicaSet(ref),
		"k8s.io/api/apps/v1.ReplicaSetCondition":                                                                schema_k8sio_api_apps_v1_ReplicaSetCondition(ref),
		"k8s.io/api/apps/v1.ReplicaSetList":                                                                     schema_k8sio_api_apps_v1_ReplicaSetList(ref),
		"k8s.io/api/apps/v1.ReplicaSetSpec":                                                                     schema_k8sio_api_apps_v1_ReplicaSetSpec(ref),
		"k8s.io/api/apps/v1.ReplicaSetStatus":                                                                   schema_k8sio_api_apps_v1_ReplicaSetStatus(ref),
		"k8s.io/api/apps/v1.RollingUpdateDaemonSet":                                                             schema_k8sio_api_apps_v1_RollingUpdateDaemonSet(ref),
		"k8s.io/api/apps/v1.RollingUpdateDeployment":                                                            schema_k8sio_api_apps_v1_RollingUpdateDeployment(ref),
		"k8s.io/api/apps/v1.RollingUpdateStatefulSetStrategy":                                                   schema_k8sio_api_apps_v1_RollingUpdateStatefulSetStrategy(ref),
		"k8s.io/api/apps/v1.StatefulSet":                                                                        schema_k8sio_api_apps_v1_StatefulSet(ref),
		"k8s.io/api/apps/v1.StatefulSetCondition":                                                               schema_k8sio_api_apps_v1_StatefulSetCondition(ref),
		"k8s.io/api/apps/v1.StatefulSetList":                                                                    schema_k8sio_api_apps_v1_StatefulSetList(ref),
		"k8s.io/api/apps/v1.StatefulSetOrdinals":                                                                schema_k8sio_api_apps_v1_StatefulSetOrdinals(ref),
		"k8s.io/api/apps/v1.StatefulSetPersistentVolumeClaimRetentionPolicy":                                    schema_k8sio_api_apps_v1_StatefulSetPersistentVolumeClaimRetentionPolicy(ref),
		"k8s.io/api/apps/v1.StatefulSetSpec":                                                                    schema_k8sio_api_apps_v1_StatefulSetSpec(ref),
		"k8s.io/api/apps/v1.StatefulSetStatus":                                                                  schema_k8sio_api_apps_v1_StatefulSetStatus(ref),
		"k8s.io/api/apps/v1.StatefulSetUpdateStrategy":                                                          schema_k8sio_api_apps_v1_StatefulSetUpdateStrategy(ref),
		"k8s.io/api/apps/v1beta1.ControllerRevision":                                                            schema_k8sio_api_apps_v1beta1_ControllerRevision(ref),
		"k8s.io/api/apps/v1beta1.ControllerRevisionList":                                                        schema_k8sio_api_apps_v1beta1_ControllerRevisionList(ref),
		"k8s.io/api/apps/v1beta1.Deployment":                                                                    schema_k8sio_api_apps_v1beta1_Deployment(ref),
		"k8s.io/api/apps/v1beta1.DeploymentCondition":                                                           schema_k8sio_api_apps_v1beta1_DeploymentCondition(ref),
		"k8s.io/api/apps/v1beta1.DeploymentList":                                                                schema_k8sio_api_apps_v1beta1_DeploymentList(ref),
		"k8s.io/api/apps/v1beta1.DeploymentRollback":                                                            schema_k8sio_api_apps_v1beta1_DeploymentRollback(ref),
		"k8s.io/api/apps/v1beta1.DeploymentSpec":                                                                schema_k8sio_api_apps_v1beta1_DeploymentSpec(ref),
		"k8s.io/api/apps/v1beta1.DeploymentStatus":                                                              schema_k8sio_api_apps_v1beta1_DeploymentStatus(ref),
		"k8s.io/api/apps/v1beta1.DeploymentStrategy":                                                            schema_k8sio_api_apps_v1beta1_DeploymentStrategy(ref),
		"k8s.io/api/apps/v1beta1.RollbackConfig":                                                                schema_k8sio_api_apps_v1beta1_RollbackConfig(ref),
		"k8s.io/api/apps/v1beta1.RollingUpdateDeployment":                                                       schema_k8sio_api_apps_v1beta1_RollingUpdateDeployment(ref),
		"k8s.io/api/apps/v1beta1.RollingUpdateStatefulSetStrategy":                                              schema_k8sio_api_apps_v1beta1_RollingUpdateStatefulSetStrategy(ref),
		"k8s.io/api/apps/v1beta1.Scale":                                                                         schema_k8sio_api_apps_v1beta1_Scale(ref),
		"k8s.io/api/apps/v1beta1.ScaleSpec":                                                                     schema_k8sio_api_apps_v1beta1_ScaleSpec(ref),
		"k8s.io/api/apps/v1beta1.ScaleStatus":                                                                   schema_k8sio_api_apps_v1beta1_ScaleStatus(ref),
		"k8s.io/api/apps/v1beta1.StatefulSet":                                                                   schema_k8sio_api_apps_v1beta1_StatefulSet(ref),
		"k8s.io/api/apps/v1beta1.StatefulSetCondition":                                                          schema_k8sio_api_apps_v1beta1_StatefulSetCondition(ref),
		"k8s.io/api/apps/v1beta1.StatefulSetList":                                                               schema_k8sio_api_apps_v1beta1_StatefulSetList(ref),
		"k8s.io/api/apps/v1beta1.StatefulSetOrdinals":                                                           schema_k8sio_api_apps_v1beta1_StatefulSetOrdinals(ref),
		"k8s.io/api/apps/v1beta1.StatefulSetPersistentVolumeClaimRetentionPolicy":                               schema_k8sio_api_apps_v1beta1_StatefulSetPersistentVolumeClaimRetentionPolicy(ref),
		"k8s.io/api/apps/v1beta1.StatefulSetSpec":                                                               schema_k8sio_api_apps_v1beta1_StatefulSetSpec(ref),
		"k8s.io/api/apps/v1beta1.StatefulSetStatus":                                                             schema_k8sio_api_apps_v1beta1_StatefulSetStatus(ref),
		"k8s.io/api/apps/v1beta1.StatefulSetUpdateStrategy":                                                     schema_k8sio_api_apps_v1beta1_StatefulSetUpdateStrategy(ref),
		"k8s.io/api/apps/v1beta2.ControllerRevision":                                                            schema_k8sio_api_apps_v1beta2_ControllerRevision(ref),
		"k8s.io/api/apps/v1beta2.ControllerRevisionList":                                                        schema_k8sio_api_apps_v1beta2_ControllerRevisionList(ref),
		"k8s.io/api/apps/v1beta2.DaemonSet":                                                                     schema_k8sio_api_apps_v1beta2_DaemonSet(ref),
		"k8s.io/api/apps/v1beta2.DaemonSetCondition":                                                            schema_k8sio_api_apps_v1beta2_DaemonSetCondition(ref),
		"k8s.io/api/apps/v1beta2.DaemonSetList":                                                                 schema_k8sio_api_apps_v1beta2_DaemonSetList(ref),
		"k8s.io/api/apps/v1beta2.DaemonSetSpec":                                                                 schema_k8sio_api_apps_v1beta2_DaemonSetSpec(ref),
		"k8s.io/api/apps/v1beta2.DaemonSetStatus":                                                               schema_k8sio_api_apps_v1beta2_DaemonSetStatus(ref),
		"k8s.io/api/apps/v1beta2.DaemonSetUpdateStrategy":                                                       schema_k8sio_api_apps_v1beta2_DaemonSetUpdateStrategy(ref),
		"k8s.io/api/apps/v1beta2.Deployment":                                                                    schema_k8sio_api_apps_v1beta2_Deployment(ref),
		"k8s.io/api/apps/v1beta2.DeploymentCondition":                                                           schema_k8sio_api_apps_v1beta2_DeploymentCondition(ref),
		"k8s.io/api/apps/v1beta2.DeploymentList":                                                                schema_k8sio_api_apps_v1beta2_DeploymentList(ref),
		"k8s.io/api/apps/v1beta2.DeploymentSpec":                                                                schema_k8sio_api_apps_v1beta2_DeploymentSpec(ref),
		"k8s.io/api/apps/v1beta2.DeploymentStatus":                                                              schema_k8sio_api_apps_v1beta2_DeploymentStatus(ref),
		"k8s.io/api/apps/v1beta2.DeploymentStrategy":                                                            schema_k8sio_api_apps_v1beta2_DeploymentStrategy(ref),
		"k8s.io/api/apps/v1beta2.ReplicaSet":                                                                    schema_k8sio_api_apps_v1beta2_ReplicaSet(ref),
		"k8s.io/api/apps/v1beta2.ReplicaSetCondition":                                                           schema_k8sio_api_apps_v1beta2_ReplicaSetCondition(ref),
		"k8s.io/api/apps/v1beta2.ReplicaSetList":                                                                schema_k8sio_api_apps_v1beta2_ReplicaSetList(ref),
		"k8s.io/api/apps/v1beta2.ReplicaSetSpec":                                                                schema_k8sio_api_apps_v1beta2_ReplicaSetSpec(ref),
		"k8s.io/api/apps/v1beta2.ReplicaSetStatus":                                                              schema_k8sio_api_apps_v1beta2_ReplicaSetStatus(ref),
		"k8s.io/api/apps/v1beta2.RollingUpdateDaemonSet":                                                        schema_k8sio_api_apps_v1beta2_RollingUpdateDaemonSet(ref),
		"k8s.io/api/apps/v1beta2.RollingUpdateDeployment":                                                       schema_k8sio_api_apps_v1beta2_RollingUpdateDeployment(ref),
		"k8s.io/api/apps/v1beta2.RollingUpdateStatefulSetStrategy":                                              schema_k8sio_api_apps_v1beta2_RollingUpdateStatefulSetStrategy(ref),
		"k8s.io/api/apps/v1beta2.Scale":                                                                         schema_k8sio_api_apps_v1beta2_Scale(ref),
		"k8s.io/api/apps/v1beta2.ScaleSpec":                                                                     schema_k8sio_api_apps_v1beta2_ScaleSpec(ref),
		"k8s.io/api/apps/v1beta2.ScaleStatus":                                                                   schema_k8sio_api_apps_v1beta2_ScaleStatus(ref),
		"k8s.io/api/apps/v1beta2.StatefulSet":                                                                   schema_k8sio_api_apps_v1beta2_StatefulSet(ref),
		"k8s.io/api/apps/v1beta2.StatefulSetCondition":                                                          schema_k8sio_api_apps_v1beta2_StatefulSetCondition(ref),
		"k8s.io/api/apps/v1beta2.StatefulSetList":                                                               schema_k8sio_api_apps_v1beta2_StatefulSetList(ref),
		"k8s.io/api/apps/v1beta2.StatefulSetOrdinals":                                                           schema_k8sio_api_apps_v1beta2_StatefulSetOrdinals(ref),
		"k8s.io/api/apps/v1beta2.StatefulSetPersistentVolumeClaimRetentionPolicy":                               schema_k8sio_api_apps_v1beta2_StatefulSetPersistentVolumeClaimRetentionPolicy(ref),
		"k8s.io/api/apps/v1beta2.StatefulSetSpec":                                                               schema_k8sio_api_apps_v1beta2_StatefulSetSpec(ref),
		"k8s.io/api/apps/v1beta2.StatefulSetStatus":                                                             schema_k8sio_api_apps_v1beta2_StatefulSetStatus(ref),
		"k8s.io/api/apps/v1beta2.StatefulSetUpdateStrategy":                                                     schema_k8sio_api_apps_v1beta2_StatefulSetUpdateStrategy(ref),
		"k8s.io/api/authentication/v1.BoundObjectReference":                                                     schema_k8sio_api_authentication_v1_BoundObjectReference(ref),
		"k8s.io/api/authentication/v1.SelfSubjectReview":                                                        schema_k8sio_api_authentication_v1_SelfSubjectReview(ref),
		"k8s.io/api/authentication/v1.SelfSubjectReviewStatus":                                                  schema_k8sio_api_authentication_v1_SelfSubjectReviewStatus(ref),
		"k8s.io/api/authentication/v1.TokenRequest":                                                             schema_k8sio_api_authentication_v1_TokenRequest(ref),
		"k8s.io/api/authentication/v1.TokenRequestSpec":                                                         schema_k8sio_api_authentication_v1_TokenRequestSpec(ref),
		"k8s.io/api/authentication/v1.TokenRequestStatus":                                                       schema_k8sio_api_authentication_v1_TokenRequestStatus(ref),
		"k8s.io/api/authentication/v1.TokenReview":                                                              schema_k8sio_api_authentication_v1_TokenReview(ref),
		"k8s.io/api/authentication/v1.TokenReviewSpec":                                                          schema_k8sio_api_authentication_v1_TokenReviewSpec(ref),
		"k8s.io/api/authentication/v1.TokenReviewStatus":                                                        schema_k8sio_api_authentication_v1_TokenReviewStatus(ref),
		"k8s.io/api/authentication/v1.UserInfo":                                                                 schema_k8sio_api_authentication_v1_UserInfo(ref),
		"k8s.io/api/authentication/v1alpha1.SelfSubjectReview":                                                  schema_k8sio_api_authentication_v1alpha1_SelfSubjectReview(ref),
		"k8s.io/api/authentication/v1alpha1.SelfSubjectReviewStatus":                                            schema_k8sio_api_authentication_v1alpha1_SelfSubjectReviewStatus(ref),
		"k8s.io/api/authentication/v1beta1.SelfSubjectReview":                                                   schema_k8sio_api_authentication_v1beta1_SelfSubjectReview(ref),
		"k8s.io/api/authentication/v1beta1.SelfSubjectReviewStatus":                                             schema_k8sio_api_authentication_v1beta1_SelfSubjectReviewStatus(ref),
		"k8s.io/api/authentication/v1beta1.TokenReview":                                                         schema_k8sio_api_authentication_v1beta1_TokenReview(ref),
		"k8s.io/api/authentication/v1beta1.TokenReviewSpec":                                                     schema_k8sio_api_authentication_v1beta1_TokenReviewSpec(ref),
		"k8s.io/api/authentication/v1beta1.TokenReviewStatus":                                                   schema_k8sio_api_authentication_v1beta1_TokenReviewStatus(ref),
		"k8s.io/api/authentication/v1beta1.UserInfo":                                                            schema_k8sio_api_authentication_v1beta1_UserInfo(ref),
		"k8s.io/api/authorization/v1.FieldSelectorAttributes":                                                   schema_k8sio_api_authorization_v1_FieldSelectorAttributes(ref),
		"k8s.io/api/authorization/v1.LabelSelectorAttributes":                                                   schema_k8sio_api_authorization_v1_LabelSelectorAttributes(ref),
		"k8s.io/api/authorization/v1.LocalSubjectAccessReview":                                                  schema_k8sio_api_authorization_v1_LocalSubjectAccessReview(ref),
		"k8s.io/api/authorization/v1.NonResourceAttributes":                                                     schema_k8sio_api_authorization_v1_NonResourceAttributes(ref),
		"k8s.io/api/authorization/v1.NonResourceRule":                                                           schema_k8sio_api_authorization_v1_NonResourceRule(ref),
		"k8s.io/api/authorization/v1.ResourceAttributes":                                                        schema_k8sio_api_authorization_v1_ResourceAttributes(ref),
		"k8s.io/api/authorization/v1.ResourceRule":                                                              schema_k8sio_api_authorization_v1_ResourceRule(ref),
		"k8s.io/api/authorization/v1.SelfSubjectAccessReview":                                                   schema_k8sio_api_authorization_v1_SelfSubjectAccessReview(ref),
		"k8s.io/api/authorization/v1.SelfSubjectAccessReviewSpec":                                               schema_k8sio_api_authorization_v1_SelfSubjectAccessReviewSpec(ref),
		"k8s.io/api/authorization/v1.SelfSubjectRulesReview":                                                    schema_k8sio_api_authorization_v1_SelfSubjectRulesReview(ref),
		"k8s.io/api/authorization/v1.SelfSubjectRulesReviewSpec":                                                schema_k8sio_api_authorization_v1_SelfSubjectRulesReviewSpec(ref),
		"k8s.io/api/authorization/v1.SubjectAccessReview":                                                       schema_k8sio_api_authorization_v1_SubjectAccessReview(ref),
		"k8s.io/api/authorization/v1.SubjectAccessReviewSpec":                                                   schema_k8sio_api_authorization_v1_SubjectAccessReviewSpec(ref),
		"k8s.io/api/authorization/v1.SubjectAccessReviewStatus":                                                 schema_k8sio_api_authorization_v1_SubjectAccessReviewStatus(ref),
		"k8s.io/api/authorization/v1.SubjectRulesReviewStatus":                                                  schema_k8sio_api_authorization_v1_SubjectRulesReviewStatus(ref),
		"k8s.io/api/authorization/v1beta1.LocalSubjectAccessReview":                                             schema_k8sio_api_authorization_v1beta1_LocalSubjectAccessReview(ref),
		"k8s.io/api/authorization/v1beta1.NonResourceAttributes":                                                schema_k8sio_api_authorization_v1beta1_NonResourceAttributes(ref),
		"k8s.io/api/authorization/v1beta1.NonResourceRule":                                                      schema_k8sio_api_authorization_v1beta1_NonResourceRule(ref),
		"k8s.io/api/authorization/v1beta1.ResourceAttributes":                                                   schema_k8sio_api_authorization_v1beta1_ResourceAttributes(ref),
		"k8s.io/api/authorization/v1beta1.ResourceRule":                                                         schema_k8sio_api_authorization_v1beta1_ResourceRule(ref),
		"k8s.io/api/authorization/v1beta1.SelfSubjectAccessReview":                                              schema_k8sio_api_authorization_v1beta1_SelfSubjectAccessReview(ref),
		"k8s.io/api/authorization/v1beta1.SelfSubjectAccessReviewSpec":                                          schema_k8sio_api_authorization_v1beta1_SelfSubjectAccessReviewSpec(ref),
		"k8s.io/api/authorization/v1beta1.SelfSubjectRulesReview":                                               schema_k8sio_api_authorization_v1beta1_SelfSubjectRulesReview(ref),
		"k8s.io/api/authorization/v1beta1.SelfSubjectRulesReviewSpec":                                           schema_k8sio_api_authorization_v1beta1_SelfSubjectRulesReviewSpec(ref),
		"k8s.io/api/authorization/v1beta1.SubjectAccessReview":                                                  schema_k8sio_api_authorization_v1beta1_SubjectAccessReview(ref),
		"k8s.io/api/authorization/v1beta1.SubjectAccessReviewSpec":                                              schema_k8sio_api_authorization_v1beta1_SubjectAccessReviewSpec(ref),
		"k8s.io/api/authorization/v1beta1.SubjectAccessReviewStatus":                                            schema_k8sio_api_authorization_v1beta1_SubjectAccessReviewStatus(ref),
		"k8s.io/api/authorization/v1beta1.SubjectRulesReviewStatus":                                             schema_k8sio_api_authorization_v1beta1_SubjectRulesReviewStatus(ref),
		"k8s.io/api/autoscaling/v1.ContainerResourceMetricSource":                                               schema_k8sio_api_autoscaling_v1_ContainerResourceMetricSource(ref),
		"k8s.io/api/autoscaling/v1.ContainerResourceMetricStatus":                                               schema_k8sio_api_autoscaling_v1_ContainerResourceMetricStatus(ref),
		"k8s.io/api/autoscaling/v1.CrossVersionObjectReference":                                                 schema_k8sio_api_autoscaling_v1_CrossVersionObjectReference(ref),
		"k8s.io/api/autoscaling/v1.ExternalMetricSource":                                                        schema_k8sio_api_autoscaling_v1_ExternalMetricSource(ref),
		"k8s.io/api/autoscaling/v1.ExternalMetricStatus":                                                        schema_k8sio_api_autoscaling_v1_ExternalMetricStatus(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscaler":                                                     schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscaler(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerCondition":                                            schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerCondition(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerList":                                                 schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerList(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerSpec":                                                 schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerSpec(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerStatus":                                               schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerStatus(ref),
		"k8s.io/api/autoscaling/v1.MetricSpec":                                                                  schema_k8sio_api_autoscaling_v1_MetricSpec(ref),
		"k8s.io/api/autoscaling/v1.MetricStatus":                                                                schema_k8sio_api_autoscaling_v1_MetricStatus(ref),
		"k8s.io/api/autoscaling/v1.ObjectMetricSource":                                                          schema_k8sio_api_autoscaling_v1_ObjectMetricSource(ref),
		"k8s.io/api/autoscaling/v1.ObjectMetricStatus":                                                          schema_k8sio_api_autoscaling_v1_ObjectMetricStatus(ref),
		"k8s.io/api/autoscaling/v1.PodsMetricSource":                                                            schema_k8sio_api_autoscaling_v1_PodsMetricSource(ref),
		"k8s.io/api/autoscaling/v1.PodsMetricStatus":                                                            schema_k8sio_api_autoscaling_v1_PodsMetricStatus(ref),
		"k8s.io/api/autoscaling/v1.ResourceMetricSource":                                                        schema_k8sio_api_autoscaling_v1_ResourceMetricSource(ref),
		"k8s.io/api/autoscaling/v1.ResourceMetricStatus":                                                        schema_k8sio_api_autoscaling_v1_ResourceMetricStatus(ref),
		"k8s.io/api/autoscaling/v1.Scale":                                                                       schema_k8sio_api_autoscaling_v1_Scale(ref),
		"k8s.io/api/autoscaling/v1.ScaleSpec":                                                                   schema_k8sio_api_autoscaling_v1_ScaleSpec(ref),
		"k8s.io/api/autoscaling/v1.ScaleStatus":                                                                 schema_k8sio_api_autoscaling_v1_ScaleStatus(ref),
		"k8s.io/api/autoscaling/v2.ContainerResourceMetricSource":                                               schema_k8sio_api_autoscaling_v2_ContainerResourceMetricSource(ref),
		"k8s.io/api/autoscaling/v2.ContainerResourceMetricStatus":                                               schema_k8sio_api_autoscaling_v2_ContainerResourceMetricStatus(ref),
		"k8s.io/api/autoscaling/v2.CrossVersionObjectReference":                                                 schema_k8sio_api_autoscaling_v2_CrossVersionObjectReference(ref),
		"k8s.io/api/autoscaling/v2.ExternalMetricSource":                                                        schema_k8sio_api_autoscaling_v2_ExternalMetricSource(ref),
		"k8s.io/api/autoscaling/v2.ExternalMetricStatus":                                                        schema_k8sio_api_autoscaling_v2_ExternalMetricStatus(ref),
		"k8s.io/api/autoscaling/v2.HPAScalingPolicy":                                                            schema_k8sio_api_autoscaling_v2_HPAScalingPolicy(ref),
		"k8s.io/api/autoscaling/v2.HPAScalingRules":                                                             schema_k8sio_api_autoscaling_v2_HPAScalingRules(ref),
		"k8s.io/api/autoscaling/v2.HorizontalPodAutoscaler":                                                     schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscaler(ref),
		"k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerBehavior":                                             schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerBehavior(ref),
		"k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerCondition":                                            schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerCondition(ref),
		"k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerList":                                                 schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerList(ref),
		"k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerSpec":                                                 schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerSpec(ref),
		"k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerStatus":                                               schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerStatus(ref),
		"k8s.io/api/autoscaling/v2.MetricIdentifier":                                                            schema_k8sio_api_autoscaling_v2_MetricIdentifier(ref),
		"k8s.io/api/autoscaling/v2.MetricSpec":                                                                  schema_k8sio_api_autoscaling_v2_MetricSpec(ref),
		"k8s.io/api/autoscaling/v2.MetricStatus":                                                                schema_k8sio_api_autoscaling_v2_MetricStatus(ref),
		"k8s.io/api/autoscaling/v2.MetricTarget":                                                                schema_k8sio_api_autoscaling_v2_MetricTarget(ref),
		"k8s.io/api/autoscaling/v2.MetricValueStatus":                                                           schema_k8sio_api_autoscaling_v2_MetricValueStatus(ref),
		"k8s.io/api/autoscaling/v2.ObjectMetricSource":                                                          schema_k8sio_api_autoscaling_v2_ObjectMetricSource(ref),
		"k8s.io/api/autoscaling/v2.ObjectMetricStatus":                                                          schema_k8sio_api_autoscaling_v2_ObjectMetricStatus(ref),
		"k8s.io/api/autoscaling/v2.PodsMetricSource":                                                            schema_k8sio_api_autoscaling_v2_PodsMetricSource(ref),
		"k8s.io/api/autoscaling/v2.PodsMetricStatus":                                                            schema_k8sio_api_autoscaling_v2_PodsMetricStatus(ref),
		"k8s.io/api/autoscaling/v2.ResourceMetricSource":                                                        schema_k8sio_api_autoscaling_v2_ResourceMetricSource(ref),
		"k8s.io/api/autoscaling/v2.ResourceMetricStatus":                                                        schema_k8sio_api_autoscaling_v2_ResourceMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta1.ContainerResourceMetricSource":                                          schema_k8sio_api_autoscaling_v2beta1_ContainerResourceMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta1.ContainerResourceMetricStatus":                                          schema_k8sio_api_autoscaling_v2beta1_ContainerResourceMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta1.CrossVersionObjectReference":                                            schema_k8sio_api_autoscaling_v2beta1_CrossVersionObjectReference(ref),
		"k8s.io/api/autoscaling/v2beta1.ExternalMetricSource":                                                   schema_k8sio_api_autoscaling_v2beta1_ExternalMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta1.ExternalMetricStatus":                                                   schema_k8sio_api_autoscaling_v2beta1_ExternalMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscaler":                                                schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscaler(ref),
		"k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerCondition":                                       schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerCondition(ref),
		"k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerList":                                            schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerList(ref),
		"k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerSpec":                                            schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerSpec(ref),
		"k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerStatus":                                          schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerStatus(ref),
		"k8s.io/api/autoscaling/v2beta1.MetricSpec":                                                             schema_k8sio_api_autoscaling_v2beta1_MetricSpec(ref),
		"k8s.io/api/autoscaling/v2beta1.MetricStatus":                                                           schema_k8sio_api_autoscaling_v2beta1_MetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta1.ObjectMetricSource":                                                     schema_k8sio_api_autoscaling_v2beta1_ObjectMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta1.ObjectMetricStatus":                                                     schema_k8sio_api_autoscaling_v2beta1_ObjectMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta1.PodsMetricSource":                                                       schema_k8sio_api_autoscaling_v2beta1_PodsMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta1.PodsMetricStatus":                                                       schema_k8sio_api_autoscaling_v2beta1_PodsMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta1.ResourceMetricSource":                                                   schema_k8sio_api_autoscaling_v2beta1_ResourceMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta1.ResourceMetricStatus":                                                   schema_k8sio_api_autoscaling_v2beta1_ResourceMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta2.ContainerResourceMetricSource":                                          schema_k8sio_api_autoscaling_v2beta2_ContainerResourceMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta2.ContainerResourceMetricStatus":                                          schema_k8sio_api_autoscaling_v2beta2_ContainerResourceMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta2.CrossVersionObjectReference":                                            schema_k8sio_api_autoscaling_v2beta2_CrossVersionObjectReference(ref),
		"k8s.io/api/autoscaling/v2beta2.ExternalMetricSource":                                                   schema_k8sio_api_autoscaling_v2beta2_ExternalMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta2.ExternalMetricStatus":                                                   schema_k8sio_api_autoscaling_v2beta2_ExternalMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta2.HPAScalingPolicy":                                                       schema_k8sio_api_autoscaling_v2beta2_HPAScalingPolicy(ref),
		"k8s.io/api/autoscaling/v2beta2.HPAScalingRules":                                                        schema_k8sio_api_autoscaling_v2beta2_HPAScalingRules(ref),
		"k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscaler":                                                schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscaler(ref),
		"k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerBehavior":                                        schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerBehavior(ref),
		"k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerCondition":                                       schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerCondition(ref),
		"k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerList":                                            schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerList(ref),
		"k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerSpec":                                            schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerSpec(ref),
		"k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerStatus":                                          schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerStatus(ref),
		"k8s.io/api/autoscaling/v2beta2.MetricIdentifier":                                                       schema_k8sio_api_autoscaling_v2beta2_MetricIdentifier(ref),
		"k8s.io/api/autoscaling/v2beta2.MetricSpec":                                                             schema_k8sio_api_autoscaling_v2beta2_MetricSpec(ref),
		"k8s.io/api/autoscaling/v2beta2.MetricStatus":                                                           schema_k8sio_api_autoscaling_v2beta2_MetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta2.MetricTarget":                                                           schema_k8sio_api_autoscaling_v2beta2_MetricTarget(ref),
		"k8s.io/api/autoscaling/v2beta2.MetricValueStatus":                                                      schema_k8sio_api_autoscaling_v2beta2_MetricValueStatus(ref),
		"k8s.io/api/autoscaling/v2beta2.ObjectMetricSource":                                                     schema_k8sio_api_autoscaling_v2beta2_ObjectMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta2.ObjectMetricStatus":                                                     schema_k8sio_api_autoscaling_v2beta2_ObjectMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta2.PodsMetricSource":                                                       schema_k8sio_api_autoscaling_v2beta2_PodsMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta2.PodsMetricStatus":                                                       schema_k8sio_api_autoscaling_v2beta2_PodsMetricStatus(ref),
		"k8s.io/api/autoscaling/v2beta2.ResourceMetricSource":                                                   schema_k8sio_api_autoscaling_v2beta2_ResourceMetricSource(ref),
		"k8s.io/api/autoscaling/v2beta2.ResourceMetricStatus":                                                   schema_k8sio_api_autoscaling_v2beta2_ResourceMetricStatus(ref),
		"k8s.io/api/batch/v1.CronJob":                                                                           schema_k8sio_api_batch_v1_CronJob(ref),
		"k8s.io/api/batch/v1.CronJobList":                                                                       schema_k8sio_api_batch_v1_CronJobList(ref),
		"k8s.io/api/batch/v1.CronJobSpec":                                                                       schema_k8sio_api_batch_v1_CronJobSpec(ref),
		"k8s.io/api/batch/v1.CronJobStatus":                                                                     schema_k8sio_api_batch_v1_CronJobStatus(ref),
		"k8s.io/api/batch/v1.Job":                                                                               schema_k8sio_api_batch_v1_Job(ref),
		"k8s.io/api/batch/v1.JobCondition":                                                                      schema_k8sio_api_batch_v1_JobCondition(ref),
		"k8s.io/api/batch/v1.JobList":                                                                           schema_k8sio_api_batch_v1_JobList(ref),
		"k8s.io/api/batch/v1.JobSpec":                                                                           schema_k8sio_api_batch_v1_JobSpec(ref),
		"k8s.io/api/batch/v1.JobStatus":                                                                         schema_k8sio_api_batch_v1_JobStatus(ref),
		"k8s.io/api/batch/v1.JobTemplateSpec":                                                                   schema_k8sio_api_batch_v1_JobTemplateSpec(ref),
		"k8s.io/api/batch/v1.PodFailurePolicy":                                                                  schema_k8sio_api_batch_v1_PodFailurePolicy(ref),
		"k8s.io/api/batch/v1.PodFailurePolicyOnExitCodesRequirement":                                            schema_k8sio_api_batch_v1_PodFailurePolicyOnExitCodesRequirement(ref),
		"k8s.io/api/batch/v1.PodFailurePolicyOnPodConditionsPattern":                                            schema_k8sio_api_batch_v1_PodFailurePolicyOnPodConditionsPattern(ref),
		"k8s.io/api/batch/v1.PodFailurePolicyRule":                                                              schema_k8sio_api_batch_v1_PodFailurePolicyRule(ref),
		"k8s.io/api/batch/v1.SuccessPolicy":                                                                     schema_k8sio_api_batch_v1_SuccessPolicy(ref),
		"k8s.io/api/batch/v1.SuccessPolicyRule":                                                                 schema_k8sio_api_batch_v1_SuccessPolicyRule(ref),
		"k8s.io/api/batch/v1.UncountedTerminatedPods":                                                           schema_k8sio_api_batch_v1_UncountedTerminatedPods(ref),
		"k8s.io/api/batch/v1beta1.CronJob":                                                                      schema_k8sio_api_batch_v1beta1_CronJob(ref),
		"k8s.io/api/batch/v1beta1.CronJobList":                                                                  schema_k8sio_api_batch_v1beta1_CronJobList(ref),
		"k8s.io/api/batch/v1beta1.CronJobSpec":                                                                  schema_k8sio_api_batch_v1beta1_CronJobSpec(ref),
		"k8s.io/api/batch/v1beta1.CronJobStatus":                                                                schema_k8sio_api_batch_v1beta1_CronJobStatus(ref),
		"k8s.io/api/batch/v1beta1.JobTemplateSpec":                                                              schema_k8sio_api_batch_v1beta1_JobTemplateSpec(ref),
		"k8s.io/api/certificates/v1.CertificateSigningRequest":                                                  schema_k8sio_api_certificates_v1_CertificateSigningRequest(ref),
		"k8s.io/api/certificates/v1.CertificateSigningRequestCondition":                                         schema_k8sio_api_certificates_v1_CertificateSigningRequestCondition(ref),
		"k8s.io/api/certificates/v1.CertificateSigningRequestList":                                              schema_k8sio_api_certificates_v1_CertificateSigningRequestList(ref),
		"k8s.io/api/certificates/v1.CertificateSigningRequestSpec":                                              schema_k8sio_api_certificates_v1_CertificateSigningRequestSpec(ref),
		"k8s.io/api/certificates/v1.CertificateSigningRequestStatus":                                            schema_k8sio_api_certificates_v1_CertificateSigningRequestStatus(ref),
		"k8s.io/api/certificates/v1alpha1.ClusterTrustBundle":                                                   schema_k8sio_api_certificates_v1alpha1_ClusterTrustBundle(ref),
		"k8s.io/api/certificates/v1alpha1.ClusterTrustBundleList":                                               schema_k8sio_api_certificates_v1alpha1_ClusterTrustBundleList(ref),
		"k8s.io/api/certificates/v1alpha1.ClusterTrustBundleSpec":                                               schema_k8sio_api_certificates_v1alpha1_ClusterTrustBundleSpec(ref),
		"k8s.io/api/certificates/v1beta1.CertificateSigningRequest":                                             schema_k8sio_api_certificates_v1beta1_CertificateSigningRequest(ref),
		"k8s.io/api/certificates/v1beta1.CertificateSigningRequestCondition":                                    schema_k8sio_api_certificates_v1beta1_CertificateSigningRequestCondition(ref),
		"k8s.io/api/certificates/v1beta1.CertificateSigningRequestList":                                         schema_k8sio_api_certificates_v1beta1_CertificateSigningRequestList(ref),
		"k8s.io/api/certificates/v1beta1.CertificateSigningRequestSpec":                                         schema_k8sio_api_certificates_v1beta1_CertificateSigningRequestSpec(ref),
		"k8s.io/api/certificates/v1beta1.CertificateSigningRequestStatus":                                       schema_k8sio_api_certificates_v1beta1_CertificateSigningRequestStatus(ref),
		"k8s.io/api/coordination/v1.Lease":                                                                      schema_k8sio_api_coordination_v1_Lease(ref),
		"k8s.io/api/coordination/v1.LeaseList":                                                                  schema_k8sio_api_coordination_v1_LeaseList(ref),
		"k8s.io/api/coordination/v1.LeaseSpec":                                                                  schema_k8sio_api_coordination_v1_LeaseSpec(ref),
		"k8s.io/api/coordination/v1alpha1.LeaseCandidate":                                                       schema_k8sio_api_coordination_v1alpha1_LeaseCandidate(ref),
		"k8s.io/api/coordination/v1alpha1.LeaseCandidateList":                                                   schema_k8sio_api_coordination_v1alpha1_LeaseCandidateList(ref),
		"k8s.io/api/coordination/v1alpha1.LeaseCandidateSpec":                                                   schema_k8sio_api_coordination_v1alpha1_LeaseCandidateSpec(ref),
		"k8s.io/api/coordination/v1beta1.Lease":                                                                 schema_k8sio_api_coordination_v1beta1_Lease(ref),
		"k8s.io/api/coordination/v1beta1.LeaseList":                                                             schema_k8sio_api_coordination_v1beta1_LeaseList(ref),
		"k8s.io/api/coordination/v1beta1.LeaseSpec":                                                             schema_k8sio_api_coordination_v1beta1_LeaseSpec(ref),
		"k8s.io/api/core/v1.AWSElasticBlockStoreVolumeSource":                                                   schema_k8sio_api_core_v1_AWSElasticBlockStoreVolumeSource(ref),
		"k8s.io/api/core/v1.Affinity":                                                                           schema_k8sio_api_core_v1_Affinity(ref),
		"k8s.io/api/core/v1.AppArmorProfile":                                                                    schema_k8sio_api_core_v1_AppArmorProfile(ref),
		"k8s.io/api/core/v1.AttachedVolume":                                                                     schema_k8sio_api_core_v1_AttachedVolume(ref),
		"k8s.io/api/core/v1.AvoidPods":                                                                          schema_k8sio_api_core_v1_AvoidPods(ref),
		"k8s.io/api/core/v1.AzureDiskVolumeSource":                                                              schema_k8sio_api_core_v1_AzureDiskVolumeSource(ref),
		"k8s.io/api/core/v1.AzureFilePersistentVolumeSource":                                                    schema_k8sio_api_core_v1_AzureFilePersistentVolumeSource(ref),
		"k8s.io/api/core/v1.AzureFileVolumeSource":                                                              schema_k8sio_api_core_v1_AzureFileVolumeSource(ref),
		"k8s.io/api/core/v1.Binding":                                                                            schema_k8sio_api_core_v1_Binding(ref),
		"k8s.io/api/core/v1.CSIPersistentVolumeSource":                                                          schema_k8sio_api_core_v1_CSIPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.CSIVolumeSource":                                                                    schema_k8sio_api_core_v1_CSIVolumeSource(ref),
		"k8s.io/api/core/v1.Capabilities":                                                                       schema_k8sio_api_core_v1_Capabilities(ref),
		"k8s.io/api/core/v1.CephFSPersistentVolumeSource":                                                       schema_k8sio_api_core_v1_CephFSPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.CephFSVolumeSource":                                                                 schema_k8sio_api_core_v1_CephFSVolumeSource(ref),
		"k8s.io/api/core/v1.CinderPersistentVolumeSource":                                                       schema_k8sio_api_core_v1_CinderPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.CinderVolumeSource":                                                                 schema_k8sio_api_core_v1_CinderVolumeSource(ref),
		"k8s.io/api/core/v1.ClientIPConfig":                                                                     schema_k8sio_api_core_v1_ClientIPConfig(ref),
		"k8s.io/api/core/v1.ClusterTrustBundleProjection":                                                       schema_k8sio_api_core_v1_ClusterTrustBundleProjection(ref),
		"k8s.io/api/core/v1.ComponentCondition":                                                                 schema_k8sio_api_core_v1_ComponentCondition(ref),
		"k8s.io/api/core/v1.ComponentStatus":                                                                    schema_k8sio_api_core_v1_ComponentStatus(ref),
		"k8s.io/api/core/v1.ComponentStatusList":                                                                schema_k8sio_api_core_v1_ComponentStatusList(ref),
		"k8s.io/api/core/v1.ConfigMap":                                                                          schema_k8sio_api_core_v1_ConfigMap(ref),
		"k8s.io/api/core/v1.ConfigMapEnvSource":                                                                 schema_k8sio_api_core_v1_ConfigMapEnvSource(ref),
		"k8s.io/api/core/v1.ConfigMapKeySelector":                                                               schema_k8sio_api_core_v1_ConfigMapKeySelector(ref),
		"k8s.io/api/core/v1.ConfigMapList":                                                                      schema_k8sio_api_core_v1_ConfigMapList(ref),
		"k8s.io/api/core/v1.ConfigMapNodeConfigSource":                                                          schema_k8sio_api_core_v1_ConfigMapNodeConfigSource(ref),
		"k8s.io/api/core/v1.ConfigMapProjection":                                                                schema_k8sio_api_core_v1_ConfigMapProjection(ref),
		"k8s.io/api/core/v1.ConfigMapVolumeSource":                                                              schema_k8sio_api_core_v1_ConfigMapVolumeSource(ref),
		"k8s.io/api/core/v1.Container":                                                                          schema_k8sio_api_core_v1_Container(ref),
		"k8s.io/api/core/v1.ContainerImage":                                                                     schema_k8sio_api_core_v1_ContainerImage(ref),
		"k8s.io/api/core/v1.ContainerPort":                                                                      schema_k8sio_api_core_v1_ContainerPort(ref),
		"k8s.io/api/core/v1.ContainerResizePolicy":                                                              schema_k8sio_api_core_v1_ContainerResizePolicy(ref),
		"k8s.io/api/core/v1.ContainerState":                                                                     schema_k8sio_api_core_v1_ContainerState(ref),
		"k8s.io/api/core/v1.ContainerStateRunning":                                                              schema_k8sio_api_core_v1_ContainerStateRunning(ref),
		"k8s.io/api/core/v1.ContainerStateTerminated":                                                           schema_k8sio_api_core_v1_ContainerStateTerminated(ref),
		"k8s.io/api/core/v1.ContainerStateWaiting":                                                              schema_k8sio_api_core_v1_ContainerStateWaiting(ref),
		"k8s.io/api/core/v1.ContainerStatus":                                                                    schema_k8sio_api_core_v1_ContainerStatus(ref),
		"k8s.io/api/core/v1.ContainerUser":                                                                      schema_k8sio_api_core_v1_ContainerUser(ref),
		"k8s.io/api/core/v1.DaemonEndpoint":                                                                     schema_k8sio_api_core_v1_DaemonEndpoint(ref),
		"k8s.io/api/core/v1.DownwardAPIProjection":                                                              schema_k8sio_api_core_v1_DownwardAPIProjection(ref),
		"k8s.io/api/core/v1.DownwardAPIVolumeFile":                                                              schema_k8sio_api_core_v1_DownwardAPIVolumeFile(ref),
		"k8s.io/api/core/v1.DownwardAPIVolumeSource":                                                            schema_k8sio_api_core_v1_DownwardAPIVolumeSource(ref),
		"k8s.io/api/core/v1.EmptyDirVolumeSource":                                                               schema_k8sio_api_core_v1_EmptyDirVolumeSource(ref),
		"k8s.io/api/core/v1.EndpointAddress":                                                                    schema_k8sio_api_core_v1_EndpointAddress(ref),
		"k8s.io/api/core/v1.EndpointPort":                                                                       schema_k8sio_api_core_v1_EndpointPort(ref),
		"k8s.io/api/core/v1.EndpointSubset":                                                                     schema_k8sio_api_core_v1_EndpointSubset(ref),
		"k8s.io/api/core/v1.Endpoints":                                                                          schema_k8sio_api_core_v1_Endpoints(ref),
		"k8s.io/api/core/v1.EndpointsList":                                                                      schema_k8sio_api_core_v1_EndpointsList(ref),
		"k8s.io/api/core/v1.EnvFromSource":                                                                      schema_k8sio_api_core_v1_EnvFromSource(ref),
		"k8s.io/api/core/v1.EnvVar":                                                                             schema_k8sio_api_core_v1_EnvVar(ref),
		"k8s.io/api/core/v1.EnvVarSource":                                                                       schema_k8sio_api_core_v1_EnvVarSource(ref),
		"k8s.io/api/core/v1.EphemeralContainer":                                                                 schema_k8sio_api_core_v1_EphemeralContainer(ref),
		"k8s.io/api/core/v1.EphemeralContainerCommon":                                                           schema_k8sio_api_core_v1_EphemeralContainerCommon(ref),
		"k8s.io/api/core/v1.EphemeralVolumeSource":                                                              schema_k8sio_api_core_v1_EphemeralVolumeSource(ref),
		"k8s.io/api/core/v1.Event":                                                                              schema_k8sio_api_core_v1_Event(ref),
		"k8s.io/api/core/v1.EventList":                                                                          schema_k8sio_api_core_v1_EventList(ref),
		"k8s.io/api/core/v1.EventSeries":                                                                        schema_k8sio_api_core_v1_EventSeries(ref),
		"k8s.io/api/core/v1.EventSource":                                                                        schema_k8sio_api_core_v1_EventSource(ref),
		"k8s.io/api/core/v1.ExecAction":                                                                         schema_k8sio_api_core_v1_ExecAction(ref),
		"k8s.io/api/core/v1.FCVolumeSource":                                                                     schema_k8sio_api_core_v1_FCVolumeSource(ref),
		"k8s.io/api/core/v1.FlexPersistentVolumeSource":                                                         schema_k8sio_api_core_v1_FlexPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.FlexVolumeSource":                                                                   schema_k8sio_api_core_v1_FlexVolumeSource(ref),
		"k8s.io/api/core/v1.FlockerVolumeSource":                                                                schema_k8sio_api_core_v1_FlockerVolumeSource(ref),
		"k8s.io/api/core/v1.GCEPersistentDiskVolumeSource":                                                      schema_k8sio_api_core_v1_GCEPersistentDiskVolumeSource(ref),
		"k8s.io/api/core/v1.GRPCAction":                                                                         schema_k8sio_api_core_v1_GRPCAction(ref),
		"k8s.io/api/core/v1.GitRepoVolumeSource":                                                                schema_k8sio_api_core_v1_GitRepoVolumeSource(ref),
		"k8s.io/api/core/v1.GlusterfsPersistentVolumeSource":                                                    schema_k8sio_api_core_v1_GlusterfsPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.GlusterfsVolumeSource":                                                              schema_k8sio_api_core_v1_GlusterfsVolumeSource(ref),
		"k8s.io/api/core/v1.HTTPGetAction":                                                                      schema_k8sio_api_core_v1_HTTPGetAction(ref),
		"k8s.io/api/core/v1.HTTPHeader":                                                                         schema_k8sio_api_core_v1_HTTPHeader(ref),
		"k8s.io/api/core/v1.HostAlias":                                                                          schema_k8sio_api_core_v1_HostAlias(ref),
		"k8s.io/api/core/v1.HostIP":                                                                             schema_k8sio_api_core_v1_HostIP(ref),
		"k8s.io/api/core/v1.HostPathVolumeSource":                                                               schema_k8sio_api_core_v1_HostPathVolumeSource(ref),
		"k8s.io/api/core/v1.ISCSIPersistentVolumeSource":                                                        schema_k8sio_api_core_v1_ISCSIPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.ISCSIVolumeSource":                                                                  schema_k8sio_api_core_v1_ISCSIVolumeSource(ref),
		"k8s.io/api/core/v1.ImageVolumeSource":                                                                  schema_k8sio_api_core_v1_ImageVolumeSource(ref),
		"k8s.io/api/core/v1.KeyToPath":                                                                          schema_k8sio_api_core_v1_KeyToPath(ref),
		"k8s.io/api/core/v1.Lifecycle":                                                                          schema_k8sio_api_core_v1_Lifecycle(ref),
		"k8s.io/api/core/v1.LifecycleHandler":                                                                   schema_k8sio_api_core_v1_LifecycleHandler(ref),
		"k8s.io/api/core/v1.LimitRange":                                                                         schema_k8sio_api_core_v1_LimitRange(ref),
		"k8s.io/api/core/v1.LimitRangeItem":                                                                     schema_k8sio_api_core_v1_LimitRangeItem(ref),
		"k8s.io/api/core/v1.LimitRangeList":                                                                     schema_k8sio_api_core_v1_LimitRangeList(ref),
		"k8s.io/api/core/v1.LimitRangeSpec":                                                                     schema_k8sio_api_core_v1_LimitRangeSpec(ref),
		"k8s.io/api/core/v1.LinuxContainerUser":                                                                 schema_k8sio_api_core_v1_LinuxContainerUser(ref),
		"k8s.io/api/core/v1.List":                                                                               schema_k8sio_api_core_v1_List(ref),
		"k8s.io/api/core/v1.LoadBalancerIngress":                                                                schema_k8sio_api_core_v1_LoadBalancerIngress(ref),
		"k8s.io/api/core/v1.LoadBalancerStatus":                                                                 schema_k8sio_api_core_v1_LoadBalancerStatus(ref),
		"k8s.io/api/core/v1.LocalObjectReference":                                                               schema_k8sio_api_core_v1_LocalObjectReference(ref),
		"k8s.io/api/core/v1.LocalVolumeSource":                                                                  schema_k8sio_api_core_v1_LocalVolumeSource(ref),
		"k8s.io/api/core/v1.ModifyVolumeStatus":                                                                 schema_k8sio_api_core_v1_ModifyVolumeStatus(ref),
		"k8s.io/api/core/v1.NFSVolumeSource":                                                                    schema_k8sio_api_core_v1_NFSVolumeSource(ref),
		"k8s.io/api/core/v1.Namespace":                                                                          schema_k8sio_api_core_v1_Namespace(ref),
		"k8s.io/api/core/v1.NamespaceCondition":                                                                 schema_k8sio_api_core_v1_NamespaceCondition(ref),
		"k8s.io/api/core/v1.NamespaceList":                                                                      schema_k8sio_api_core_v1_NamespaceList(ref),
		"k8s.io/api/core/v1.NamespaceSpec":                                                                      schema_k8sio_api_core_v1_NamespaceSpec(ref),
		"k8s.io/api/core/v1.NamespaceStatus":                                                                    schema_k8sio_api_core_v1_NamespaceStatus(ref),
		"k8s.io/api/core/v1.Node":                                                                               schema_k8sio_api_core_v1_Node(ref),
		"k8s.io/api/core/v1.NodeAddress":                                                                        schema_k8sio_api_core_v1_NodeAddress(ref),
		"k8s.io/api/core/v1.NodeAffinity":                                                                       schema_k8sio_api_core_v1_NodeAffinity(ref),
		"k8s.io/api/core/v1.NodeCondition":                                                                      schema_k8sio_api_core_v1_NodeCondition(ref),
		"k8s.io/api/core/v1.NodeConfigSource":                                                                   schema_k8sio_api_core_v1_NodeConfigSource(ref),
		"k8s.io/api/core/v1.NodeConfigStatus":                                                                   schema_k8sio_api_core_v1_NodeConfigStatus(ref),
		"k8s.io/api/core/v1.NodeDaemonEndpoints":                                                                schema_k8sio_api_core_v1_NodeDaemonEndpoints(ref),
		"k8s.io/api/core/v1.NodeFeatures":                                                                       schema_k8sio_api_core_v1_NodeFeatures(ref),
		"k8s.io/api/core/v1.NodeList":                                                                           schema_k8sio_api_core_v1_NodeList(ref),
		"k8s.io/api/core/v1.NodeProxyOptions":                                                                   schema_k8sio_api_core_v1_NodeProxyOptions(ref),
		"k8s.io/api/core/v1.NodeRuntimeHandler":                                                                 schema_k8sio_api_core_v1_NodeRuntimeHandler(ref),
		"k8s.io/api/core/v1.NodeRuntimeHandlerFeatures":                                                         schema_k8sio_api_core_v1_NodeRuntimeHandlerFeatures(ref),
		"k8s.io/api/core/v1.NodeSelector":                                                                       schema_k8sio_api_core_v1_NodeSelector(ref),
		"k8s.io/api/core/v1.NodeSelectorRequirement":                                                            schema_k8sio_api_core_v1_NodeSelectorRequirement(ref),
		"k8s.io/api/core/v1.NodeSelectorTerm":                                                                   schema_k8sio_api_core_v1_NodeSelectorTerm(ref),
		"k8s.io/api/core/v1.NodeSpec":                                                                           schema_k8sio_api_core_v1_NodeSpec(ref),
		"k8s.io/api/core/v1.NodeStatus":                                                                         schema_k8sio_api_core_v1_NodeStatus(ref),
		"k8s.io/api/core/v1.NodeSystemInfo":                                                                     schema_k8sio_api_core_v1_NodeSystemInfo(ref),
		"k8s.io/api/core/v1.ObjectFieldSelector":                                                                schema_k8sio_api_core_v1_ObjectFieldSelector(ref),
		"k8s.io/api/core/v1.ObjectReference":                                                                    schema_k8sio_api_core_v1_ObjectReference(ref),
		"k8s.io/api/core/v1.PersistentVolume":                                                                   schema_k8sio_api_core_v1_PersistentVolume(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaim":                                                              schema_k8sio_api_core_v1_PersistentVolumeClaim(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimCondition":                                                     schema_k8sio_api_core_v1_PersistentVolumeClaimCondition(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimList":                                                          schema_k8sio_api_core_v1_PersistentVolumeClaimList(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimSpec":                                                          schema_k8sio_api_core_v1_PersistentVolumeClaimSpec(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimStatus":                                                        schema_k8sio_api_core_v1_PersistentVolumeClaimStatus(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimTemplate":                                                      schema_k8sio_api_core_v1_PersistentVolumeClaimTemplate(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimVolumeSource":                                                  schema_k8sio_api_core_v1_PersistentVolumeClaimVolumeSource(ref),
		"k8s.io/api/core/v1.PersistentVolumeList":                                                               schema_k8sio_api_core_v1_PersistentVolumeList(ref),
		"k8s.io/api/core/v1.PersistentVolumeSource":                                                             schema_k8sio_api_core_v1_PersistentVolumeSource(ref),
		"k8s.io/api/core/v1.PersistentVolumeSpec":                                                               schema_k8sio_api_core_v1_PersistentVolumeSpec(ref),
		"k8s.io/api/core/v1.PersistentVolumeStatus":                                                             schema_k8sio_api_core_v1_PersistentVolumeStatus(ref),
		"k8s.io/api/core/v1.PhotonPersistentDiskVolumeSource":                                                   schema_k8sio_api_core_v1_PhotonPersistentDiskVolumeSource(ref),
		"k8s.io/api/core/v1.Pod":                                                                                schema_k8sio_api_core_v1_Pod(ref),
		"k8s.io/api/core/v1.PodAffinity":                                                                        schema_k8sio_api_core_v1_PodAffinity(ref),
		"k8s.io/api/core/v1.PodAffinityTerm":                                                                    schema_k8sio_api_core_v1_PodAffinityTerm(ref),
		"k8s.io/api/core/v1.PodAntiAffinity":                                                                    schema_k8sio_api_core_v1_PodAntiAffinity(ref),
		"k8s.io/api/core/v1.PodAttachOptions":                                                                   schema_k8sio_api_core_v1_PodAttachOptions(ref),
		"k8s.io/api/core/v1.PodCondition":                                                                       schema_k8sio_api_core_v1_PodCondition(ref),
		"k8s.io/api/core/v1.PodDNSConfig":                                                                       schema_k8sio_api_core_v1_PodDNSConfig(ref),
		"k8s.io/api/core/v1.PodDNSConfigOption":                                                                 schema_k8sio_api_core_v1_PodDNSConfigOption(ref),
		"k8s.io/api/core/v1.PodExecOptions":                                                                     schema_k8sio_api_core_v1_PodExecOptions(ref),
		"k8s.io/api/core/v1.PodIP":                                                                              schema_k8sio_api_core_v1_PodIP(ref),
		"k8s.io/api/core/v1.PodList":                                                                            schema_k8sio_api_core_v1_PodList(ref),
		"k8s.io/api/core/v1.PodLogOptions":                                                                      schema_k8sio_api_core_v1_PodLogOptions(ref),
		"k8s.io/api/core/v1.PodOS":                                                                              schema_k8sio_api_core_v1_PodOS(ref),
		"k8s.io/api/core/v1.PodPortForwardOptions":                                                              schema_k8sio_api_core_v1_PodPortForwardOptions(ref),
		"k8s.io/api/core/v1.PodProxyOptions":                                                                    schema_k8sio_api_core_v1_PodProxyOptions(ref),
		"k8s.io/api/core/v1.PodReadinessGate":                                                                   schema_k8sio_api_core_v1_PodReadinessGate(ref),
		"k8s.io/api/core/v1.PodResourceClaim":                                                                   schema_k8sio_api_core_v1_PodResourceClaim(ref),
		"k8s.io/api/core/v1.PodResourceClaimStatus":                                                             schema_k8sio_api_core_v1_PodResourceClaimStatus(ref),
		"k8s.io/api/core/v1.PodSchedulingGate":                                                                  schema_k8sio_api_core_v1_PodSchedulingGate(ref),
		"k8s.io/api/core/v1.PodSecurityContext":                                                                 schema_k8sio_api_core_v1_PodSecurityContext(ref),
		"k8s.io/api/core/v1.PodSignature":                                                                       schema_k8sio_api_core_v1_PodSignature(ref),
		"k8s.io/api/core/v1.PodSpec":                                                                            schema_k8sio_api_core_v1_PodSpec(ref),
		"k8s.io/api/core/v1.PodStatus":                                                                          schema_k8sio_api_core_v1_PodStatus(ref),
		"k8s.io/api/core/v1.PodStatusResult":                                                                    schema_k8sio_api_core_v1_PodStatusResult(ref),
		"k8s.io/api/core/v1.PodTemplate":                                                                        schema_k8sio_api_core_v1_PodTemplate(ref),
		"k8s.io/api/core/v1.PodTemplateList":                                                                    schema_k8sio_api_core_v1_PodTemplateList(ref),
		"k8s.io/api/core/v1.PodTemplateSpec":                                                                    schema_k8sio_api_core_v1_PodTemplateSpec(ref),
		"k8s.io/api/core/v1.PortStatus":                                                                         schema_k8sio_api_core_v1_PortStatus(ref),
		"k8s.io/api/core/v1.PortworxVolumeSource":                                                               schema_k8sio_api_core_v1_PortworxVolumeSource(ref),
		"k8s.io/api/core/v1.PreferAvoidPodsEntry":                                                               schema_k8sio_api_core_v1_PreferAvoidPodsEntry(ref),
		"k8s.io/api/core/v1.PreferredSchedulingTerm":                                                            schema_k8sio_api_core_v1_PreferredSchedulingTerm(ref),
		"k8s.io/api/core/v1.Probe":                                                                              schema_k8sio_api_core_v1_Probe(ref),
		"k8s.io/api/core/v1.ProbeHandler":                                                                       schema_k8sio_api_core_v1_ProbeHandler(ref),
		"k8s.io/api/core/v1.ProjectedVolumeSource":                                                              schema_k8sio_api_core_v1_ProjectedVolumeSource(ref),
		"k8s.io/api/core/v1.QuobyteVolumeSource":                                                                schema_k8sio_api_core_v1_QuobyteVolumeSource(ref),
		"k8s.io/api/core/v1.RBDPersistentVolumeSource":                                                          schema_k8sio_api_core_v1_RBDPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.RBDVolumeSource":                                                                    schema_k8sio_api_core_v1_RBDVolumeSource(ref),
		"k8s.io/api/core/v1.RangeAllocation":                                                                    schema_k8sio_api_core_v1_RangeAllocation(ref),
		"k8s.io/api/core/v1.ReplicationController":                                                              schema_k8sio_api_core_v1_ReplicationController(ref),
		"k8s.io/api/core/v1.ReplicationControllerCondition":                                                     schema_k8sio_api_core_v1_ReplicationControllerCondition(ref),
		"k8s.io/api/core/v1.ReplicationControllerList":                                                          schema_k8sio_api_core_v1_ReplicationControllerList(ref),
		"k8s.io/api/core/v1.ReplicationControllerSpec":                                                          schema_k8sio_api_core_v1_ReplicationControllerSpec(ref),
		"k8s.io/api/core/v1.ReplicationControllerStatus":                                                        schema_k8sio_api_core_v1_ReplicationControllerStatus(ref),
		"k8s.io/api/core/v1.ResourceClaim":                                                                      schema_k8sio_api_core_v1_ResourceClaim(ref),
		"k8s.io/api/core/v1.ResourceFieldSelector":                                                              schema_k8sio_api_core_v1_ResourceFieldSelector(ref),
		"k8s.io/api/core/v1.ResourceHealth":                                                                     schema_k8sio_api_core_v1_ResourceHealth(ref),
		"k8s.io/api/core/v1.ResourceQuota":                                                                      schema_k8sio_api_core_v1_ResourceQuota(ref),
		"k8s.io/api/core/v1.ResourceQuotaList":                                                                  schema_k8sio_api_core_v1_ResourceQuotaList(ref),
		"k8s.io/api/core/v1.ResourceQuotaSpec":                                                                  schema_k8sio_api_core_v1_ResourceQuotaSpec(ref),
		"k8s.io/api/core/v1.ResourceQuotaStatus":                                                                schema_k8sio_api_core_v1_ResourceQuotaStatus(ref),
		"k8s.io/api/core/v1.ResourceRequirements":                                                               schema_k8sio_api_core_v1_ResourceRequirements(ref),
		"k8s.io/api/core/v1.ResourceStatus":                                                                     schema_k8sio_api_core_v1_ResourceStatus(ref),
		"k8s.io/api/core/v1.SELinuxOptions":                                                                     schema_k8sio_api_core_v1_SELinuxOptions(ref),
		"k8s.io/api/core/v1.ScaleIOPersistentVolumeSource":                                                      schema_k8sio_api_core_v1_ScaleIOPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.ScaleIOVolumeSource":                                                                schema_k8sio_api_core_v1_ScaleIOVolumeSource(ref),
		"k8s.io/api/core/v1.ScopeSelector":                                                                      schema_k8sio_api_core_v1_ScopeSelector(ref),
		"k8s.io/api/core/v1.ScopedResourceSelectorRequirement":                                                  schema_k8sio_api_core_v1_ScopedResourceSelectorRequirement(ref),
		"k8s.io/api/core/v1.SeccompProfile":                                                                     schema_k8sio_api_core_v1_SeccompProfile(ref),
		"k8s.io/api/core/v1.Secret":                                                                             schema_k8sio_api_core_v1_Secret(ref),
		"k8s.io/api/core/v1.SecretEnvSource":                                                                    schema_k8sio_api_core_v1_SecretEnvSource(ref),
		"k8s.io/api/core/v1.SecretKeySelector":                                                                  schema_k8sio_api_core_v1_SecretKeySelector(ref),
		"k8s.io/api/core/v1.SecretList":                                                                         schema_k8sio_api_core_v1_SecretList(ref),
		"k8s.io/api/core/v1.SecretProjection":                                                                   schema_k8sio_api_core_v1_SecretProjection(ref),
		"k8s.io/api/core/v1.SecretReference":                                                                    schema_k8sio_api_core_v1_SecretReference(ref),
		"k8s.io/api/core/v1.SecretVolumeSource":                                                                 schema_k8sio_api_core_v1_SecretVolumeSource(ref),
		"k8s.io/api/core/v1.SecurityContext":                                                                    schema_k8sio_api_core_v1_SecurityContext(ref),
		"k8s.io/api/core/v1.SerializedReference":                                                                schema_k8sio_api_core_v1_SerializedReference(ref),
		"k8s.io/api/core/v1.Service":                                                                            schema_k8sio_api_core_v1_Service(ref),
		"k8s.io/api/core/v1.ServiceAccount":                                                                     schema_k8sio_api_core_v1_ServiceAccount(ref),
		"k8s.io/api/core/v1.ServiceAccountList":                                                                 schema_k8sio_api_core_v1_ServiceAccountList(ref),
		"k8s.io/api/core/v1.ServiceAccountTokenProjection":                                                      schema_k8sio_api_core_v1_ServiceAccountTokenProjection(ref),
		"k8s.io/api/core/v1.ServiceList":                                                                        schema_k8sio_api_core_v1_ServiceList(ref),
		"k8s.io/api/core/v1.ServicePort":                                                                        schema_k8sio_api_core_v1_ServicePort(ref),
		"k8s.io/api/core/v1.ServiceProxyOptions":                                                                schema_k8sio_api_core_v1_ServiceProxyOptions(ref),
		"k8s.io/api/core/v1.ServiceSpec":                                                                        schema_k8sio_api_core_v1_ServiceSpec(ref),
		"k8s.io/api/core/v1.ServiceStatus":                                                                      schema_k8sio_api_core_v1_ServiceStatus(ref),
		"k8s.io/api/core/v1.SessionAffinityConfig":                                                              schema_k8sio_api_core_v1_SessionAffinityConfig(ref),
		"k8s.io/api/core/v1.SleepAction":                                                                        schema_k8sio_api_core_v1_SleepAction(ref),
		"k8s.io/api/core/v1.StorageOSPersistentVolumeSource":                                                    schema_k8sio_api_core_v1_StorageOSPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.StorageOSVolumeSource":                                                              schema_k8sio_api_core_v1_StorageOSVolumeSource(ref),
		"k8s.io/api/core/v1.Sysctl":                                                                             schema_k8sio_api_core_v1_Sysctl(ref),
		"k8s.io/api/core/v1.TCPSocketAction":                                                                    schema_k8sio_api_core_v1_TCPSocketAction(ref),
		"k8s.io/api/core/v1.Taint":                                                                              schema_k8sio_api_core_v1_Taint(ref),
		"k8s.io/api/core/v1.Toleration":                                                                         schema_k8sio_api_core_v1_Toleration(ref),
		"k8s.io/api/core/v1.TopologySelectorLabelRequirement":                                                   schema_k8sio_api_core_v1_TopologySelectorLabelRequirement(ref),
		"k8s.io/api/core/v1.TopologySelectorTerm":                                                               schema_k8sio_api_core_v1_TopologySelectorTerm(ref),
		"k8s.io/api/core/v1.TopologySpreadConstraint":                                                           schema_k8sio_api_core_v1_TopologySpreadConstraint(ref),
		"k8s.io/api/core/v1.TypedLocalObjectReference":                                                          schema_k8sio_api_core_v1_TypedLocalObjectReference(ref),
		"k8s.io/api/core/v1.TypedObjectReference":                                                               schema_k8sio_api_core_v1_TypedObjectReference(ref),
		"k8s.io/api/core/v1.Volume":                                                                             schema_k8sio_api_core_v1_Volume(ref),
		"k8s.io/api/core/v1.VolumeDevice":                                                                       schema_k8sio_api_core_v1_VolumeDevice(ref),
		"k8s.io/api/core/v1.VolumeMount":                                                                        schema_k8sio_api_core_v1_VolumeMount(ref),
		"k8s.io/api/core/v1.VolumeMountStatus":                                                                  schema_k8sio_api_core_v1_VolumeMountStatus(ref),
		"k8s.io/api/core/v1.VolumeNodeAffinity":                                                                 schema_k8sio_api_core_v1_VolumeNodeAffinity(ref),
		"k8s.io/api/core/v1.VolumeProjection":                                                                   schema_k8sio_api_core_v1_VolumeProjection(ref),
		"k8s.io/api/core/v1.VolumeResourceRequirements":                                                         schema_k8sio_api_core_v1_VolumeResourceRequirements(ref),
		"k8s.io/api/core/v1.VolumeSource":                                                                       schema_k8sio_api_core_v1_VolumeSource(ref),
		"k8s.io/api/core/v1.VsphereVirtualDiskVolumeSource":                                                     schema_k8sio_api_core_v1_VsphereVirtualDiskVolumeSource(ref),
		"k8s.io/api/core/v1.WeightedPodAffinityTerm":                                                            schema_k8sio_api_core_v1_WeightedPodAffinityTerm(ref),
		"k8s.io/api/core/v1.WindowsSecurityContextOptions":                                                      schema_k8sio_api_core_v1_WindowsSecurityContextOptions(ref),
		"k8s.io/api/discovery/v1.Endpoint":                                                                      schema_k8sio_api_discovery_v1_Endpoint(ref),
		"k8s.io/api/discovery/v1.EndpointConditions":                                                            schema_k8sio_api_discovery_v1_EndpointConditions(ref),
		"k8s.io/api/discovery/v1.EndpointHints":                                                                 schema_k8sio_api_discovery_v1_EndpointHints(ref),
		"k8s.io/api/discovery/v1.EndpointPort":                                                                  schema_k8sio_api_discovery_v1_EndpointPort(ref),
		"k8s.io/api/discovery/v1.EndpointSlice":                                                                 schema_k8sio_api_discovery_v1_EndpointSlice(ref),
		"k8s.io/api/discovery/v1.EndpointSliceList":                                                             schema_k8sio_api_discovery_v1_EndpointSliceList(ref),
		"k8s.io/api/discovery/v1.ForZone":                                                                       schema_k8sio_api_discovery_v1_ForZone(ref),
		"k8s.io/api/discovery/v1beta1.Endpoint":                                                                 schema_k8sio_api_discovery_v1beta1_Endpoint(ref),
		"k8s.io/api/discovery/v1beta1.EndpointConditions":                                                       schema_k8sio_api_discovery_v1beta1_EndpointConditions(ref),
		"k8s.io/api/discovery/v1beta1.EndpointHints":                                                            schema_k8sio_api_discovery_v1beta1_EndpointHints(ref),
		"k8s.io/api/discovery/v1beta1.EndpointPort":                                                             schema_k8sio_api_discovery_v1beta1_EndpointPort(ref),
		"k8s.io/api/discovery/v1beta1.EndpointSlice":                                                            schema_k8sio_api_discovery_v1beta1_EndpointSlice(ref),
		"k8s.io/api/discovery/v1beta1.EndpointSliceList":                                                        schema_k8sio_api_discovery_v1beta1_EndpointSliceList(ref),
		"k8s.io/api/discovery/v1beta1.ForZone":                                                                  schema_k8sio_api_discovery_v1beta1_ForZone(ref),
		"k8s.io/api/events/v1.Event":                                                                            schema_k8sio_api_events_v1_Event(ref),
		"k8s.io/api/events/v1.EventList":                                                                        schema_k8sio_api_events_v1_EventList(ref),
		"k8s.io/api/events/v1.EventSeries":                                                                      schema_k8sio_api_events_v1_EventSeries(ref),
		"k8s.io/api/events/v1beta1.Event":                                                                       schema_k8sio_api_events_v1beta1_Event(ref),
		"k8s.io/api/events/v1beta1.EventList":                                                                   schema_k8sio_api_events_v1beta1_EventList(ref),
		"k8s.io/api/events/v1beta1.EventSeries":                                                                 schema_k8sio_api_events_v1beta1_EventSeries(ref),
		"k8s.io/api/extensions/v1beta1.DaemonSet":                                                               schema_k8sio_api_extensions_v1beta1_DaemonSet(ref),
		"k8s.io/api/extensions/v1beta1.DaemonSetCondition":                                                      schema_k8sio_api_extensions_v1beta1_DaemonSetCondition(ref),
		"k8s.io/api/extensions/v1beta1.DaemonSetList":                                                           schema_k8sio_api_extensions_v1beta1_DaemonSetList(ref),
		"k8s.io/api/extensions/v1beta1.DaemonSetSpec":                                                           schema_k8sio_api_extensions_v1beta1_DaemonSetSpec(ref),
		"k8s.io/api/extensions/v1beta1.DaemonSetStatus":                                                         schema_k8sio_api_extensions_v1beta1_DaemonSetStatus(ref),
		"k8s.io/api/extensions/v1beta1.DaemonSetUpdateStrategy":                                                 schema_k8sio_api_extensions_v1beta1_DaemonSetUpdateStrategy(ref),
		"k8s.io/api/extensions/v1beta1.Deployment":                                                              schema_k8sio_api_extensions_v1beta1_Deployment(ref),
		"k8s.io/api/extensions/v1beta1.DeploymentCondition":                                                     schema_k8sio_api_extensions_v1beta1_DeploymentCondition(ref),
		"k8s.io/api/extensions/v1beta1.DeploymentList":                                                          schema_k8sio_api_extensions_v1beta1_DeploymentList(ref),
		"k8s.io/api/extensions/v1beta1.DeploymentRollback":                                                      schema_k8sio_api_extensions_v1beta1_DeploymentRollback(ref),
		"k8s.io/api/extensions/v1beta1.DeploymentSpec":                                                          schema_k8sio_api_extensions_v1beta1_DeploymentSpec(ref),
		"k8s.io/api/extensions/v1beta1.DeploymentStatus":                                                        schema_k8sio_api_extensions_v1beta1_DeploymentStatus(ref),
		"k8s.io/api/extensions/v1beta1.DeploymentStrategy":                                                      schema_k8sio_api_extensions_v1beta1_DeploymentStrategy(ref),
		"k8s.io/api/extensions/v1beta1.HTTPIngressPath":                                                         schema_k8sio_api_extensions_v1beta1_HTTPIngressPath(ref),
		"k8s.io/api/extensions/v1beta1.HTTPIngressRuleValue":                                                    schema_k8sio_api_extensions_v1beta1_HTTPIngressRuleValue(ref),
		"k8s.io/api/extensions/v1beta1.IPBlock":                                                                 schema_k8sio_api_extensions_v1beta1_IPBlock(ref),
		"k8s.io/api/extensions/v1beta1.Ingress":                                                                 schema_k8sio_api_extensions_v1beta1_Ingress(ref),
		"k8s.io/api/extensions/v1beta1.IngressBackend":                                                          schema_k8sio_api_extensions_v1beta1_IngressBackend(ref),
		"k8s.io/api/extensions/v1beta1.IngressList":                                                             schema_k8sio_api_extensions_v1beta1_IngressList(ref),
		"k8s.io/api/extensions/v1beta1.IngressLoadBalancerIngress":                                              schema_k8sio_api_extensions_v1beta1_IngressLoadBalancerIngress(ref),
		"k8s.io/api/extensions/v1beta1.IngressLoadBalancerStatus":                                               schema_k8sio_api_extensions_v1beta1_IngressLoadBalancerStatus(ref),
		"k8s.io/api/extensions/v1beta1.IngressPortStatus":                                                       schema_k8sio_api_extensions_v1beta1_IngressPortStatus(ref),
		"k8s.io/api/extensions/v1beta1.IngressRule":                                                             schema_k8sio_api_extensions_v1beta1_IngressRule(ref),
		"k8s.io/api/extensions/v1beta1.IngressRuleValue":                                                        schema_k8sio_api_extensions_v1beta1_IngressRuleValue(ref),
		"k8s.io/api/extensions/v1beta1.IngressSpec":                                                             schema_k8sio_api_extensions_v1beta1_IngressSpec(ref),
		"k8s.io/api/extensions/v1beta1.IngressStatus":                                                           schema_k8sio_api_extensions_v1beta1_IngressStatus(ref),
		"k8s.io/api/extensions/v1beta1.IngressTLS":                                                              schema_k8sio_api_extensions_v1beta1_IngressTLS(ref),
		"k8s.io/api/extensions/v1beta1.NetworkPolicy":                                                           schema_k8sio_api_extensions_v1beta1_NetworkPolicy(ref),
		"k8s.io/api/extensions/v1beta1.NetworkPolicyEgressRule":                                                 schema_k8sio_api_extensions_v1beta1_NetworkPolicyEgressRule(ref),
		"k8s.io/api/extensions/v1beta1.NetworkPolicyIngressRule":                                                schema_k8sio_api_extensions_v1beta1_NetworkPolicyIngressRule(ref),
		"k8s.io/api/extensions/v1beta1.NetworkPolicyList":                                                       schema_k8sio_api_extensions_v1beta1_NetworkPolicyList(ref),
		"k8s.io/api/extensions/v1beta1.NetworkPolicyPeer":                                                       schema_k8sio_api_extensions_v1beta1_NetworkPolicyPeer(ref),
		"k8s.io/api/extensions/v1beta1.NetworkPolicyPort":                                                       schema_k8sio_api_extensions_v1beta1_NetworkPolicyPort(ref),
		"k8s.io/api/extensions/v1beta1.NetworkPolicySpec":                                                       schema_k8sio_api_extensions_v1beta1_NetworkPolicySpec(ref),
		"k8s.io/api/extensions/v1beta1.ReplicaSet":                                                              schema_k8sio_api_extensions_v1beta1_ReplicaSet(ref),
		"k8s.io/api/extensions/v1beta1.ReplicaSetCondition":                                                     schema_k8sio_api_extensions_v1beta1_ReplicaSetCondition(ref),
		"k8s.io/api/extensions/v1beta1.ReplicaSetList":                                                          schema_k8sio_api_extensions_v1beta1_ReplicaSetList(ref),
		"k8s.io/api/extensions/v1beta1.ReplicaSetSpec":                                                          schema_k8sio_api_extensions_v1beta1_ReplicaSetSpec(ref),
		"k8s.io/api/extensions/v1beta1.ReplicaSetStatus":                                                        schema_k8sio_api_extensions_v1beta1_ReplicaSetStatus(ref),
		"k8s.io/api/extensions/v1beta1.RollbackConfig":                                                          schema_k8sio_api_extensions_v1beta1_RollbackConfig(ref),
		"k8s.io/api/extensions/v1beta1.RollingUpdateDaemonSet":                                                  schema_k8sio_api_extensions_v1beta1_RollingUpdateDaemonSet(ref),
		"k8s.io/api/extensions/v1beta1.RollingUpdateDeployment":                                                 schema_k8sio_api_extensions_v1beta1_RollingUpdateDeployment(ref),
		"k8s.io/api/extensions/v1beta1.Scale":                                                                   schema_k8sio_api_extensions_v1beta1_Scale(ref),
		"k8s.io/api/extensions/v1beta1.ScaleSpec":                                                               schema_k8sio_api_extensions_v1beta1_ScaleSpec(ref),
		"k8s.io/api/extensions/v1beta1.ScaleStatus":                                                             schema_k8sio_api_extensions_v1beta1_ScaleStatus(ref),
		"k8s.io/api/flowcontrol/v1.ExemptPriorityLevelConfiguration":                                            schema_k8sio_api_flowcontrol_v1_ExemptPriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1.FlowDistinguisherMethod":                                                     schema_k8sio_api_flowcontrol_v1_FlowDistinguisherMethod(ref),
		"k8s.io/api/flowcontrol/v1.FlowSchema":                                                                  schema_k8sio_api_flowcontrol_v1_FlowSchema(ref),
		"k8s.io/api/flowcontrol/v1.FlowSchemaCondition":                                                         schema_k8sio_api_flowcontrol_v1_FlowSchemaCondition(ref),
		"k8s.io/api/flowcontrol/v1.FlowSchemaList":                                                              schema_k8sio_api_flowcontrol_v1_FlowSchemaList(ref),
		"k8s.io/api/flowcontrol/v1.FlowSchemaSpec":                                                              schema_k8sio_api_flowcontrol_v1_FlowSchemaSpec(ref),
		"k8s.io/api/flowcontrol/v1.FlowSchemaStatus":                                                            schema_k8sio_api_flowcontrol_v1_FlowSchemaStatus(ref),
		"k8s.io/api/flowcontrol/v1.GroupSubject":                                                                schema_k8sio_api_flowcontrol_v1_GroupSubject(ref),
		"k8s.io/api/flowcontrol/v1.LimitResponse":                                                               schema_k8sio_api_flowcontrol_v1_LimitResponse(ref),
		"k8s.io/api/flowcontrol/v1.LimitedPriorityLevelConfiguration":                                           schema_k8sio_api_flowcontrol_v1_LimitedPriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1.NonResourcePolicyRule":                                                       schema_k8sio_api_flowcontrol_v1_NonResourcePolicyRule(ref),
		"k8s.io/api/flowcontrol/v1.PolicyRulesWithSubjects":                                                     schema_k8sio_api_flowcontrol_v1_PolicyRulesWithSubjects(ref),
		"k8s.io/api/flowcontrol/v1.PriorityLevelConfiguration":                                                  schema_k8sio_api_flowcontrol_v1_PriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1.PriorityLevelConfigurationCondition":                                         schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationCondition(ref),
		"k8s.io/api/flowcontrol/v1.PriorityLevelConfigurationList":                                              schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationList(ref),
		"k8s.io/api/flowcontrol/v1.PriorityLevelConfigurationReference":                                         schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationReference(ref),
		"k8s.io/api/flowcontrol/v1.PriorityLevelConfigurationSpec":                                              schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationSpec(ref),
		"k8s.io/api/flowcontrol/v1.PriorityLevelConfigurationStatus":                                            schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationStatus(ref),
		"k8s.io/api/flowcontrol/v1.QueuingConfiguration":                                                        schema_k8sio_api_flowcontrol_v1_QueuingConfiguration(ref),
		"k8s.io/api/flowcontrol/v1.ResourcePolicyRule":                                                          schema_k8sio_api_flowcontrol_v1_ResourcePolicyRule(ref),
		"k8s.io/api/flowcontrol/v1.ServiceAccountSubject":                                                       schema_k8sio_api_flowcontrol_v1_ServiceAccountSubject(ref),
		"k8s.io/api/flowcontrol/v1.Subject":                                                                     schema_k8sio_api_flowcontrol_v1_Subject(ref),
		"k8s.io/api/flowcontrol/v1.UserSubject":                                                                 schema_k8sio_api_flowcontrol_v1_UserSubject(ref),
		"k8s.io/api/flowcontrol/v1beta1.ExemptPriorityLevelConfiguration":                                       schema_k8sio_api_flowcontrol_v1beta1_ExemptPriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta1.FlowDistinguisherMethod":                                                schema_k8sio_api_flowcontrol_v1beta1_FlowDistinguisherMethod(ref),
		"k8s.io/api/flowcontrol/v1beta1.FlowSchema":                                                             schema_k8sio_api_flowcontrol_v1beta1_FlowSchema(ref),
		"k8s.io/api/flowcontrol/v1beta1.FlowSchemaCondition":                                                    schema_k8sio_api_flowcontrol_v1beta1_FlowSchemaCondition(ref),
		"k8s.io/api/flowcontrol/v1beta1.FlowSchemaList":                                                         schema_k8sio_api_flowcontrol_v1beta1_FlowSchemaList(ref),
		"k8s.io/api/flowcontrol/v1beta1.FlowSchemaSpec":                                                         schema_k8sio_api_flowcontrol_v1beta1_FlowSchemaSpec(ref),
		"k8s.io/api/flowcontrol/v1beta1.FlowSchemaStatus":                                                       schema_k8sio_api_flowcontrol_v1beta1_FlowSchemaStatus(ref),
		"k8s.io/api/flowcontrol/v1beta1.GroupSubject":                                                           schema_k8sio_api_flowcontrol_v1beta1_GroupSubject(ref),
		"k8s.io/api/flowcontrol/v1beta1.LimitResponse":                                                          schema_k8sio_api_flowcontrol_v1beta1_LimitResponse(ref),
		"k8s.io/api/flowcontrol/v1beta1.LimitedPriorityLevelConfiguration":                                      schema_k8sio_api_flowcontrol_v1beta1_LimitedPriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta1.NonResourcePolicyRule":                                                  schema_k8sio_api_flowcontrol_v1beta1_NonResourcePolicyRule(ref),
		"k8s.io/api/flowcontrol/v1beta1.PolicyRulesWithSubjects":                                                schema_k8sio_api_flowcontrol_v1beta1_PolicyRulesWithSubjects(ref),
		"k8s.io/api/flowcontrol/v1beta1.PriorityLevelConfiguration":                                             schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta1.PriorityLevelConfigurationCondition":                                    schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationCondition(ref),
		"k8s.io/api/flowcontrol/v1beta1.PriorityLevelConfigurationList":                                         schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationList(ref),
		"k8s.io/api/flowcontrol/v1beta1.PriorityLevelConfigurationReference":                                    schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationReference(ref),
		"k8s.io/api/flowcontrol/v1beta1.PriorityLevelConfigurationSpec":                                         schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationSpec(ref),
		"k8s.io/api/flowcontrol/v1beta1.PriorityLevelConfigurationStatus":                                       schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationStatus(ref),
		"k8s.io/api/flowcontrol/v1beta1.QueuingConfiguration":                                                   schema_k8sio_api_flowcontrol_v1beta1_QueuingConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta1.ResourcePolicyRule":                                                     schema_k8sio_api_flowcontrol_v1beta1_ResourcePolicyRule(ref),
		"k8s.io/api/flowcontrol/v1beta1.ServiceAccountSubject":                                                  schema_k8sio_api_flowcontrol_v1beta1_ServiceAccountSubject(ref),
		"k8s.io/api/flowcontrol/v1beta1.Subject":                                                                schema_k8sio_api_flowcontrol_v1beta1_Subject(ref),
		"k8s.io/api/flowcontrol/v1beta1.UserSubject":                                                            schema_k8sio_api_flowcontrol_v1beta1_UserSubject(ref),
		"k8s.io/api/flowcontrol/v1beta2.ExemptPriorityLevelConfiguration":                                       schema_k8sio_api_flowcontrol_v1beta2_ExemptPriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta2.FlowDistinguisherMethod":                                                schema_k8sio_api_flowcontrol_v1beta2_FlowDistinguisherMethod(ref),
		"k8s.io/api/flowcontrol/v1beta2.FlowSchema":                                                             schema_k8sio_api_flowcontrol_v1beta2_FlowSchema(ref),
		"k8s.io/api/flowcontrol/v1beta2.FlowSchemaCondition":                                                    schema_k8sio_api_flowcontrol_v1beta2_FlowSchemaCondition(ref),
		"k8s.io/api/flowcontrol/v1beta2.FlowSchemaList":                                                         schema_k8sio_api_flowcontrol_v1beta2_FlowSchemaList(ref),
		"k8s.io/api/flowcontrol/v1beta2.FlowSchemaSpec":                                                         schema_k8sio_api_flowcontrol_v1beta2_FlowSchemaSpec(ref),
		"k8s.io/api/flowcontrol/v1beta2.FlowSchemaStatus":                                                       schema_k8sio_api_flowcontrol_v1beta2_FlowSchemaStatus(ref),
		"k8s.io/api/flowcontrol/v1beta2.GroupSubject":                                                           schema_k8sio_api_flowcontrol_v1beta2_GroupSubject(ref),
		"k8s.io/api/flowcontrol/v1beta2.LimitResponse":                                                          schema_k8sio_api_flowcontrol_v1beta2_LimitResponse(ref),
		"k8s.io/api/flowcontrol/v1beta2.LimitedPriorityLevelConfiguration":                                      schema_k8sio_api_flowcontrol_v1beta2_LimitedPriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta2.NonResourcePolicyRule":                                                  schema_k8sio_api_flowcontrol_v1beta2_NonResourcePolicyRule(ref),
		"k8s.io/api/flowcontrol/v1beta2.PolicyRulesWithSubjects":                                                schema_k8sio_api_flowcontrol_v1beta2_PolicyRulesWithSubjects(ref),
		"k8s.io/api/flowcontrol/v1beta2.PriorityLevelConfiguration":                                             schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta2.PriorityLevelConfigurationCondition":                                    schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationCondition(ref),
		"k8s.io/api/flowcontrol/v1beta2.PriorityLevelConfigurationList":                                         schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationList(ref),
		"k8s.io/api/flowcontrol/v1beta2.PriorityLevelConfigurationReference":                                    schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationReference(ref),
		"k8s.io/api/flowcontrol/v1beta2.PriorityLevelConfigurationSpec":                                         schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationSpec(ref),
		"k8s.io/api/flowcontrol/v1beta2.PriorityLevelConfigurationStatus":                                       schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationStatus(ref),
		"k8s.io/api/flowcontrol/v1beta2.QueuingConfiguration":                                                   schema_k8sio_api_flowcontrol_v1beta2_QueuingConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta2.ResourcePolicyRule":                                                     schema_k8sio_api_flowcontrol_v1beta2_ResourcePolicyRule(ref),
		"k8s.io/api/flowcontrol/v1beta2.ServiceAccountSubject":                                                  schema_k8sio_api_flowcontrol_v1beta2_ServiceAccountSubject(ref),
		"k8s.io/api/flowcontrol/v1beta2.Subject":                                                                schema_k8sio_api_flowcontrol_v1beta2_Subject(ref),
		"k8s.io/api/flowcontrol/v1beta2.UserSubject":                                                            schema_k8sio_api_flowcontrol_v1beta2_UserSubject(ref),
		"k8s.io/api/flowcontrol/v1beta3.ExemptPriorityLevelConfiguration":                                       schema_k8sio_api_flowcontrol_v1beta3_ExemptPriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta3.FlowDistinguisherMethod":                                                schema_k8sio_api_flowcontrol_v1beta3_FlowDistinguisherMethod(ref),
		"k8s.io/api/flowcontrol/v1beta3.FlowSchema":                                                             schema_k8sio_api_flowcontrol_v1beta3_FlowSchema(ref),
		"k8s.io/api/flowcontrol/v1beta3.FlowSchemaCondition":                                                    schema_k8sio_api_flowcontrol_v1beta3_FlowSchemaCondition(ref),
		"k8s.io/api/flowcontrol/v1beta3.FlowSchemaList":                                                         schema_k8sio_api_flowcontrol_v1beta3_FlowSchemaList(ref),
		"k8s.io/api/flowcontrol/v1beta3.FlowSchemaSpec":                                                         schema_k8sio_api_flowcontrol_v1beta3_FlowSchemaSpec(ref),
		"k8s.io/api/flowcontrol/v1beta3.FlowSchemaStatus":                                                       schema_k8sio_api_flowcontrol_v1beta3_FlowSchemaStatus(ref),
		"k8s.io/api/flowcontrol/v1beta3.GroupSubject":                                                           schema_k8sio_api_flowcontrol_v1beta3_GroupSubject(ref),
		"k8s.io/api/flowcontrol/v1beta3.LimitResponse":                                                          schema_k8sio_api_flowcontrol_v1beta3_LimitResponse(ref),
		"k8s.io/api/flowcontrol/v1beta3.LimitedPriorityLevelConfiguration":                                      schema_k8sio_api_flowcontrol_v1beta3_LimitedPriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta3.NonResourcePolicyRule":                                                  schema_k8sio_api_flowcontrol_v1beta3_NonResourcePolicyRule(ref),
		"k8s.io/api/flowcontrol/v1beta3.PolicyRulesWithSubjects":                                                schema_k8sio_api_flowcontrol_v1beta3_PolicyRulesWithSubjects(ref),
		"k8s.io/api/flowcontrol/v1beta3.PriorityLevelConfiguration":                                             schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta3.PriorityLevelConfigurationCondition":                                    schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationCondition(ref),
		"k8s.io/api/flowcontrol/v1beta3.PriorityLevelConfigurationList":                                         schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationList(ref),
		"k8s.io/api/flowcontrol/v1beta3.PriorityLevelConfigurationReference":                                    schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationReference(ref),
		"k8s.io/api/flowcontrol/v1beta3.PriorityLevelConfigurationSpec":                                         schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationSpec(ref),
		"k8s.io/api/flowcontrol/v1beta3.PriorityLevelConfigurationStatus":                                       schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationStatus(ref),
		"k8s.io/api/flowcontrol/v1beta3.QueuingConfiguration":                                                   schema_k8sio_api_flowcontrol_v1beta3_QueuingConfiguration(ref),
		"k8s.io/api/flowcontrol/v1beta3.ResourcePolicyRule":                                                     schema_k8sio_api_flowcontrol_v1beta3_ResourcePolicyRule(ref),
		"k8s.io/api/flowcontrol/v1beta3.ServiceAccountSubject":                                                  schema_k8sio_api_flowcontrol_v1beta3_ServiceAccountSubject(ref),
		"k8s.io/api/flowcontrol/v1beta3.Subject":                                                                schema_k8sio_api_flowcontrol_v1beta3_Subject(ref),
		"k8s.io/api/flowcontrol/v1beta3.UserSubject":                                                            schema_k8sio_api_flowcontrol_v1beta3_UserSubject(ref),
		"k8s.io/api/imagepolicy/v1alpha1.ImageReview":                                                           schema_k8sio_api_imagepolicy_v1alpha1_ImageReview(ref),
		"k8s.io/api/imagepolicy/v1alpha1.ImageReviewContainerSpec":                                              schema_k8sio_api_imagepolicy_v1alpha1_ImageReviewContainerSpec(ref),
		"k8s.io/api/imagepolicy/v1alpha1.ImageReviewSpec":                                                       schema_k8sio_api_imagepolicy_v1alpha1_ImageReviewSpec(ref),
		"k8s.io/api/imagepolicy/v1alpha1.ImageReviewStatus":                                                     schema_k8sio_api_imagepolicy_v1alpha1_ImageReviewStatus(ref),
		"k8s.io/api/networking/v1.HTTPIngressPath":                                                              schema_k8sio_api_networking_v1_HTTPIngressPath(ref),
		"k8s.io/api/networking/v1.HTTPIngressRuleValue":                                                         schema_k8sio_api_networking_v1_HTTPIngressRuleValue(ref),
		"k8s.io/api/networking/v1.IPBlock":                                                                      schema_k8sio_api_networking_v1_IPBlock(ref),
		"k8s.io/api/networking/v1.Ingress":                                                                      schema_k8sio_api_networking_v1_Ingress(ref),
		"k8s.io/api/networking/v1.IngressBackend":                                                               schema_k8sio_api_networking_v1_IngressBackend(ref),
		"k8s.io/api/networking/v1.IngressClass":                                                                 schema_k8sio_api_networking_v1_IngressClass(ref),
		"k8s.io/api/networking/v1.IngressClassList":                                                             schema_k8sio_api_networking_v1_IngressClassList(ref),
		"k8s.io/api/networking/v1.IngressClassParametersReference":                                              schema_k8sio_api_networking_v1_IngressClassParametersReference(ref),
		"k8s.io/api/networking/v1.IngressClassSpec":                                                             schema_k8sio_api_networking_v1_IngressClassSpec(ref),
		"k8s.io/api/networking/v1.IngressList":                                                                  schema_k8sio_api_networking_v1_IngressList(ref),
		"k8s.io/api/networking/v1.IngressLoadBalancerIngress":                                                   schema_k8sio_api_networking_v1_IngressLoadBalancerIngress(ref),
		"k8s.io/api/networking/v1.IngressLoadBalancerStatus":                                                    schema_k8sio_api_networking_v1_IngressLoadBalancerStatus(ref),
		"k8s.io/api/networking/v1.IngressPortStatus":                                                            schema_k8sio_api_networking_v1_IngressPortStatus(ref),
		"k8s.io/api/networking/v1.IngressRule":                                                                  schema_k8sio_api_networking_v1_IngressRule(ref),
		"k8s.io/api/networking/v1.IngressRuleValue":                                                             schema_k8sio_api_networking_v1_IngressRuleValue(ref),
		"k8s.io/api/networking/v1.IngressServiceBackend":                                                        schema_k8sio_api_networking_v1_IngressServiceBackend(ref),
		"k8s.io/api/networking/v1.IngressSpec":                                                                  schema_k8sio_api_networking_v1_IngressSpec(ref),
		"k8s.io/api/networking/v1.IngressStatus":                                                                schema_k8sio_api_networking_v1_IngressStatus(ref),
		"k8s.io/api/networking/v1.IngressTLS":                                                                   schema_k8sio_api_networking_v1_IngressTLS(ref),
		"k8s.io/api/networking/v1.NetworkPolicy":                                                                schema_k8sio_api_networking_v1_NetworkPolicy(ref),
		"k8s.io/api/networking/v1.NetworkPolicyEgressRule":                                                      schema_k8sio_api_networking_v1_NetworkPolicyEgressRule(ref),
		"k8s.io/api/networking/v1.NetworkPolicyIngressRule":                                                     schema_k8sio_api_networking_v1_NetworkPolicyIngressRule(ref),
		"k8s.io/api/networking/v1.NetworkPolicyList":                                                            schema_k8sio_api_networking_v1_NetworkPolicyList(ref),
		"k8s.io/api/networking/v1.NetworkPolicyPeer":                                                            schema_k8sio_api_networking_v1_NetworkPolicyPeer(ref),
		"k8s.io/api/networking/v1.NetworkPolicyPort":                                                            schema_k8sio_api_networking_v1_NetworkPolicyPort(ref),
		"k8s.io/api/networking/v1.NetworkPolicySpec":                                                            schema_k8sio_api_networking_v1_NetworkPolicySpec(ref),
		"k8s.io/api/networking/v1.ServiceBackendPort":                                                           schema_k8sio_api_networking_v1_ServiceBackendPort(ref),
		"k8s.io/api/networking/v1alpha1.IPAddress":                                                              schema_k8sio_api_networking_v1alpha1_IPAddress(ref),
		"k8s.io/api/networking/v1alpha1.IPAddressList":                                                          schema_k8sio_api_networking_v1alpha1_IPAddressList(ref),
		"k8s.io/api/networking/v1alpha1.IPAddressSpec":                                                          schema_k8sio_api_networking_v1alpha1_IPAddressSpec(ref),
		"k8s.io/api/networking/v1alpha1.ParentReference":                                                        schema_k8sio_api_networking_v1alpha1_ParentReference(ref),
		"k8s.io/api/networking/v1alpha1.ServiceCIDR":                                                            schema_k8sio_api_networking_v1alpha1_ServiceCIDR(ref),
		"k8s.io/api/networking/v1alpha1.ServiceCIDRList":                                                        schema_k8sio_api_networking_v1alpha1_ServiceCIDRList(ref),
		"k8s.io/api/networking/v1alpha1.ServiceCIDRSpec":                                                        schema_k8sio_api_networking_v1alpha1_ServiceCIDRSpec(ref),
		"k8s.io/api/networking/v1alpha1.ServiceCIDRStatus":                                                      schema_k8sio_api_networking_v1alpha1_ServiceCIDRStatus(ref),
		"k8s.io/api/networking/v1beta1.HTTPIngressPath":                                                         schema_k8sio_api_networking_v1beta1_HTTPIngressPath(ref),
		"k8s.io/api/networking/v1beta1.HTTPIngressRuleValue":                                                    schema_k8sio_api_networking_v1beta1_HTTPIngressRuleValue(ref),
		"k8s.io/api/networking/v1beta1.IPAddress":                                                               schema_k8sio_api_networking_v1beta1_IPAddress(ref),
		"k8s.io/api/networking/v1beta1.IPAddressList":                                                           schema_k8sio_api_networking_v1beta1_IPAddressList(ref),
		"k8s.io/api/networking/v1beta1.IPAddressSpec":                                                           schema_k8sio_api_networking_v1beta1_IPAddressSpec(ref),
		"k8s.io/api/networking/v1beta1.Ingress":                                                                 schema_k8sio_api_networking_v1beta1_Ingress(ref),
		"k8s.io/api/networking/v1beta1.IngressBackend":                                                          schema_k8sio_api_networking_v1beta1_IngressBackend(ref),
		"k8s.io/api/networking/v1beta1.IngressClass":                                                            schema_k8sio_api_networking_v1beta1_IngressClass(ref),
		"k8s.io/api/networking/v1beta1.IngressClassList":                                                        schema_k8sio_api_networking_v1beta1_IngressClassList(ref),
		"k8s.io/api/networking/v1beta1.IngressClassParametersReference":                                         schema_k8sio_api_networking_v1beta1_IngressClassParametersReference(ref),
		"k8s.io/api/networking/v1beta1.IngressClassSpec":                                                        schema_k8sio_api_networking_v1beta1_IngressClassSpec(ref),
		"k8s.io/api/networking/v1beta1.IngressList":                                                             schema_k8sio_api_networking_v1beta1_IngressList(ref),
		"k8s.io/api/networking/v1beta1.IngressLoadBalancerIngress":                                              schema_k8sio_api_networking_v1beta1_IngressLoadBalancerIngress(ref),
		"k8s.io/api/networking/v1beta1.IngressLoadBalancerStatus":                                               schema_k8sio_api_networking_v1beta1_IngressLoadBalancerStatus(ref),
		"k8s.io/api/networking/v1beta1.IngressPortStatus":                                                       schema_k8sio_api_networking_v1beta1_IngressPortStatus(ref),
		"k8s.io/api/networking/v1beta1.IngressRule":                                                             schema_k8sio_api_networking_v1beta1_IngressRule(ref),
		"k8s.io/api/networking/v1beta1.IngressRuleValue":                                                        schema_k8sio_api_networking_v1beta1_IngressRuleValue(ref),
		"k8s.io/api/networking/v1beta1.IngressSpec":                                                             schema_k8sio_api_networking_v1beta1_IngressSpec(ref),
		"k8s.io/api/networking/v1beta1.IngressStatus":                                                           schema_k8sio_api_networking_v1beta1_IngressStatus(ref),
		"k8s.io/api/networking/v1beta1.IngressTLS":                                                              schema_k8sio_api_networking_v1beta1_IngressTLS(ref),
		"k8s.io/api/networking/v1beta1.ParentReference":                                                         schema_k8sio_api_networking_v1beta1_ParentReference(ref),
		"k8s.io/api/networking/v1beta1.ServiceCIDR":                                                             schema_k8sio_api_networking_v1beta1_ServiceCIDR(ref),
		"k8s.io/api/networking/v1beta1.ServiceCIDRList":                                                         schema_k8sio_api_networking_v1beta1_ServiceCIDRList(ref),
		"k8s.io/api/networking/v1beta1.ServiceCIDRSpec":                                                         schema_k8sio_api_networking_v1beta1_ServiceCIDRSpec(ref),
		"k8s.io/api/networking/v1beta1.ServiceCIDRStatus":                                                       schema_k8sio_api_networking_v1beta1_ServiceCIDRStatus(ref),
		"k8s.io/api/node/v1.Overhead":                                                                           schema_k8sio_api_node_v1_Overhead(ref),
		"k8s.io/api/node/v1.RuntimeClass":                                                                       schema_k8sio_api_node_v1_RuntimeClass(ref),
		"k8s.io/api/node/v1.RuntimeClassList":                                                                   schema_k8sio_api_node_v1_RuntimeClassList(ref),
		"k8s.io/api/node/v1.Scheduling":                                                                         schema_k8sio_api_node_v1_Scheduling(ref),
		"k8s.io/api/node/v1alpha1.Overhead":                                                                     schema_k8sio_api_node_v1alpha1_Overhead(ref),
		"k8s.io/api/node/v1alpha1.RuntimeClass":                                                                 schema_k8sio_api_node_v1alpha1_RuntimeClass(ref),
		"k8s.io/api/node/v1alpha1.RuntimeClassList":                                                             schema_k8sio_api_node_v1alpha1_RuntimeClassList(ref),
		"k8s.io/api/node/v1alpha1.RuntimeClassSpec":                                                             schema_k8sio_api_node_v1alpha1_RuntimeClassSpec(ref),
		"k8s.io/api/node/v1alpha1.Scheduling":                                                                   schema_k8sio_api_node_v1alpha1_Scheduling(ref),
		"k8s.io/api/node/v1beta1.Overhead":                                                                      schema_k8sio_api_node_v1beta1_Overhead(ref),
		"k8s.io/api/node/v1beta1.RuntimeClass":                                                                  schema_k8sio_api_node_v1beta1_RuntimeClass(ref),
		"k8s.io/api/node/v1beta1.RuntimeClassList":                                                              schema_k8sio_api_node_v1beta1_RuntimeClassList(ref),
		"k8s.io/api/node/v1beta1.Scheduling":                                                                    schema_k8sio_api_node_v1beta1_Scheduling(ref),
		"k8s.io/api/policy/v1.Eviction":                                                                         schema_k8sio_api_policy_v1_Eviction(ref),
		"k8s.io/api/policy/v1.PodDisruptionBudget":                                                              schema_k8sio_api_policy_v1_PodDisruptionBudget(ref),
		"k8s.io/api/policy/v1.PodDisruptionBudgetList":                                                          schema_k8sio_api_policy_v1_PodDisruptionBudgetList(ref),
		"k8s.io/api/policy/v1.PodDisruptionBudgetSpec":                                                          schema_k8sio_api_policy_v1_PodDisruptionBudgetSpec(ref),
		"k8s.io/api/policy/v1.PodDisruptionBudgetStatus":                                                        schema_k8sio_api_policy_v1_PodDisruptionBudgetStatus(ref),
		"k8s.io/api/policy/v1beta1.Eviction":                                                                    schema_k8sio_api_policy_v1beta1_Eviction(ref),
		"k8s.io/api/policy/v1beta1.PodDisruptionBudget":                                                         schema_k8sio_api_policy_v1beta1_PodDisruptionBudget(ref),
		"k8s.io/api/policy/v1beta1.PodDisruptionBudgetList":                                                     schema_k8sio_api_policy_v1beta1_PodDisruptionBudgetList(ref),
		"k8s.io/api/policy/v1beta1.PodDisruptionBudgetSpec":                                                     schema_k8sio_api_policy_v1beta1_PodDisruptionBudgetSpec(ref),
		"k8s.io/api/policy/v1beta1.PodDisruptionBudgetStatus":                                                   schema_k8sio_api_policy_v1beta1_PodDisruptionBudgetStatus(ref),
		"k8s.io/api/rbac/v1.AggregationRule":                                                                    schema_k8sio_api_rbac_v1_AggregationRule(ref),
		"k8s.io/api/rbac/v1.ClusterRole":                                                                        schema_k8sio_api_rbac_v1_ClusterRole(ref),
		"k8s.io/api/rbac/v1.ClusterRoleBinding":                                                                 schema_k8sio_api_rbac_v1_ClusterRoleBinding(ref),
		"k8s.io/api/rbac/v1.ClusterRoleBindingList":                                                             schema_k8sio_api_rbac_v1_ClusterRoleBindingList(ref),
		"k8s.io/api/rbac/v1.ClusterRoleList":                                                                    schema_k8sio_api_rbac_v1_ClusterRoleList(ref),
		"k8s.io/api/rbac/v1.PolicyRule":                                                                         schema_k8sio_api_rbac_v1_PolicyRule(ref),
		"k8s.io/api/rbac/v1.Role":                                                                               schema_k8sio_api_rbac_v1_Role(ref),
		"k8s.io/api/rbac/v1.RoleBinding":                                                                        schema_k8sio_api_rbac_v1_RoleBinding(ref),
		"k8s.io/api/rbac/v1.RoleBindingList":                                                                    schema_k8sio_api_rbac_v1_RoleBindingList(ref),
		"k8s.io/api/rbac/v1.RoleList":                                                                           schema_k8sio_api_rbac_v1_RoleList(ref),
		"k8s.io/api/rbac/v1.RoleRef":                                                                            schema_k8sio_api_rbac_v1_RoleRef(ref),
		"k8s.io/api/rbac/v1.Subject":                                                                            schema_k8sio_api_rbac_v1_Subject(ref),
		"k8s.io/api/rbac/v1alpha1.AggregationRule":                                                              schema_k8sio_api_rbac_v1alpha1_AggregationRule(ref),
		"k8s.io/api/rbac/v1alpha1.ClusterRole":                                                                  schema_k8sio_api_rbac_v1alpha1_ClusterRole(ref),
		"k8s.io/api/rbac/v1alpha1.ClusterRoleBinding":                                                           schema_k8sio_api_rbac_v1alpha1_ClusterRoleBinding(ref),
		"k8s.io/api/rbac/v1alpha1.ClusterRoleBindingList":                                                       schema_k8sio_api_rbac_v1alpha1_ClusterRoleBindingList(ref),
		"k8s.io/api/rbac/v1alpha1.ClusterRoleList":                                                              schema_k8sio_api_rbac_v1alpha1_ClusterRoleList(ref),
		"k8s.io/api/rbac/v1alpha1.PolicyRule":                                                                   schema_k8sio_api_rbac_v1alpha1_PolicyRule(ref),
		"k8s.io/api/rbac/v1alpha1.Role":                                                                         schema_k8sio_api_rbac_v1alpha1_Role(ref),
		"k8s.io/api/rbac/v1alpha1.RoleBinding":                                                                  schema_k8sio_api_rbac_v1alpha1_RoleBinding(ref),
		"k8s.io/api/rbac/v1alpha1.RoleBindingList":                                                              schema_k8sio_api_rbac_v1alpha1_RoleBindingList(ref),
		"k8s.io/api/rbac/v1alpha1.RoleList":                                                                     schema_k8sio_api_rbac_v1alpha1_RoleList(ref),
		"k8s.io/api/rbac/v1alpha1.RoleRef":                                                                      schema_k8sio_api_rbac_v1alpha1_RoleRef(ref),
		"k8s.io/api/rbac/v1alpha1.Subject":                                                                      schema_k8sio_api_rbac_v1alpha1_Subject(ref),
		"k8s.io/api/rbac/v1beta1.AggregationRule":                                                               schema_k8sio_api_rbac_v1beta1_AggregationRule(ref),
		"k8s.io/api/rbac/v1beta1.ClusterRole":                                                                   schema_k8sio_api_rbac_v1beta1_ClusterRole(ref),
		"k8s.io/api/rbac/v1beta1.ClusterRoleBinding":                                                            schema_k8sio_api_rbac_v1beta1_ClusterRoleBinding(ref),
		"k8s.io/api/rbac/v1beta1.ClusterRoleBindingList":                                                        schema_k8sio_api_rbac_v1beta1_ClusterRoleBindingList(ref),
		"k8s.io/api/rbac/v1beta1.ClusterRoleList":                                                               schema_k8sio_api_rbac_v1beta1_ClusterRoleList(ref),
		"k8s.io/api/rbac/v1beta1.PolicyRule":                                                                    schema_k8sio_api_rbac_v1beta1_PolicyRule(ref),
		"k8s.io/api/rbac/v1beta1.Role":                                                                          schema_k8sio_api_rbac_v1beta1_Role(ref),
		"k8s.io/api/rbac/v1beta1.RoleBinding":                                                                   schema_k8sio_api_rbac_v1beta1_RoleBinding(ref),
		"k8s.io/api/rbac/v1beta1.RoleBindingList":                                                               schema_k8sio_api_rbac_v1beta1_RoleBindingList(ref),
		"k8s.io/api/rbac/v1beta1.RoleList":                                                                      schema_k8sio_api_rbac_v1beta1_RoleList(ref),
		"k8s.io/api/rbac/v1beta1.RoleRef":                                                                       schema_k8sio_api_rbac_v1beta1_RoleRef(ref),
		"k8s.io/api/rbac/v1beta1.Subject":                                                                       schema_k8sio_api_rbac_v1beta1_Subject(ref),
		"k8s.io/api/resource/v1alpha3.AllocationResult":                                                         schema_k8sio_api_resource_v1alpha3_AllocationResult(ref),
		"k8s.io/api/resource/v1alpha3.BasicDevice":                                                              schema_k8sio_api_resource_v1alpha3_BasicDevice(ref),
		"k8s.io/api/resource/v1alpha3.CELDeviceSelector":                                                        schema_k8sio_api_resource_v1alpha3_CELDeviceSelector(ref),
		"k8s.io/api/resource/v1alpha3.Device":                                                                   schema_k8sio_api_resource_v1alpha3_Device(ref),
		"k8s.io/api/resource/v1alpha3.DeviceAllocationConfiguration":                                            schema_k8sio_api_resource_v1alpha3_DeviceAllocationConfiguration(ref),
		"k8s.io/api/resource/v1alpha3.DeviceAllocationResult":                                                   schema_k8sio_api_resource_v1alpha3_DeviceAllocationResult(ref),
		"k8s.io/api/resource/v1alpha3.DeviceAttribute":                                                          schema_k8sio_api_resource_v1alpha3_DeviceAttribute(ref),
		"k8s.io/api/resource/v1alpha3.DeviceClaim":                                                              schema_k8sio_api_resource_v1alpha3_DeviceClaim(ref),
		"k8s.io/api/resource/v1alpha3.DeviceClaimConfiguration":                                                 schema_k8sio_api_resource_v1alpha3_DeviceClaimConfiguration(ref),
		"k8s.io/api/resource/v1alpha3.DeviceClass":                                                              schema_k8sio_api_resource_v1alpha3_DeviceClass(ref),
		"k8s.io/api/resource/v1alpha3.DeviceClassConfiguration":                                                 schema_k8sio_api_resource_v1alpha3_DeviceClassConfiguration(ref),
		"k8s.io/api/resource/v1alpha3.DeviceClassList":                                                          schema_k8sio_api_resource_v1alpha3_DeviceClassList(ref),
		"k8s.io/api/resource/v1alpha3.DeviceClassSpec":                                                          schema_k8sio_api_resource_v1alpha3_DeviceClassSpec(ref),
		"k8s.io/api/resource/v1alpha3.DeviceConfiguration":                                                      schema_k8sio_api_resource_v1alpha3_DeviceConfiguration(ref),
		"k8s.io/api/resource/v1alpha3.DeviceConstraint":                                                         schema_k8sio_api_resource_v1alpha3_DeviceConstraint(ref),
		"k8s.io/api/resource/v1alpha3.DeviceRequest":                                                            schema_k8sio_api_resource_v1alpha3_DeviceRequest(ref),
		"k8s.io/api/resource/v1alpha3.DeviceRequestAllocationResult":                                            schema_k8sio_api_resource_v1alpha3_DeviceRequestAllocationResult(ref),
		"k8s.io/api/resource/v1alpha3.DeviceSelector":                                                           schema_k8sio_api_resource_v1alpha3_DeviceSelector(ref),
		"k8s.io/api/resource/v1alpha3.OpaqueDeviceConfiguration":                                                schema_k8sio_api_resource_v1alpha3_OpaqueDeviceConfiguration(ref),
		"k8s.io/api/resource/v1alpha3.PodSchedulingContext":                                                     schema_k8sio_api_resource_v1alpha3_PodSchedulingContext(ref),
		"k8s.io/api/resource/v1alpha3.PodSchedulingContextList":                                                 schema_k8sio_api_resource_v1alpha3_PodSchedulingContextList(ref),
		"k8s.io/api/resource/v1alpha3.PodSchedulingContextSpec":                                                 schema_k8sio_api_resource_v1alpha3_PodSchedulingContextSpec(ref),
		"k8s.io/api/resource/v1alpha3.PodSchedulingContextStatus":                                               schema_k8sio_api_resource_v1alpha3_PodSchedulingContextStatus(ref),
		"k8s.io/api/resource/v1alpha3.ResourceClaim":                                                            schema_k8sio_api_resource_v1alpha3_ResourceClaim(ref),
		"k8s.io/api/resource/v1alpha3.ResourceClaimConsumerReference":                                           schema_k8sio_api_resource_v1alpha3_ResourceClaimConsumerReference(ref),
		"k8s.io/api/resource/v1alpha3.ResourceClaimList":                                                        schema_k8sio_api_resource_v1alpha3_ResourceClaimList(ref),
		"k8s.io/api/resource/v1alpha3.ResourceClaimSchedulingStatus":                                            schema_k8sio_api_resource_v1alpha3_ResourceClaimSchedulingStatus(ref),
		"k8s.io/api/resource/v1alpha3.ResourceClaimSpec":                                                        schema_k8sio_api_resource_v1alpha3_ResourceClaimSpec(ref),
		"k8s.io/api/resource/v1alpha3.ResourceClaimStatus":                                                      schema_k8sio_api_resource_v1alpha3_ResourceClaimStatus(ref),
		"k8s.io/api/resource/v1alpha3.ResourceClaimTemplate":                                                    schema_k8sio_api_resource_v1alpha3_ResourceClaimTemplate(ref),
		"k8s.io/api/resource/v1alpha3.ResourceClaimTemplateList":                                                schema_k8sio_api_resource_v1alpha3_ResourceClaimTemplateList(ref),
		"k8s.io/api/resource/v1alpha3.ResourceClaimTemplateSpec":                                                schema_k8sio_api_resource_v1alpha3_ResourceClaimTemplateSpec(ref),
		"k8s.io/api/resource/v1alpha3.ResourcePool":                                                             schema_k8sio_api_resource_v1alpha3_ResourcePool(ref),
		"k8s.io/api/resource/v1alpha3.ResourceSlice":                                                            schema_k8sio_api_resource_v1alpha3_ResourceSlice(ref),
		"k8s.io/api/resource/v1alpha3.ResourceSliceList":                                                        schema_k8sio_api_resource_v1alpha3_ResourceSliceList(ref),
		"k8s.io/api/resource/v1alpha3.ResourceSliceSpec":                                                        schema_k8sio_api_resource_v1alpha3_ResourceSliceSpec(ref),
		"k8s.io/api/scheduling/v1.PriorityClass":                                                                schema_k8sio_api_scheduling_v1_PriorityClass(ref),
		"k8s.io/api/scheduling/v1.PriorityClassList":                                                            schema_k8sio_api_scheduling_v1_PriorityClassList(ref),
		"k8s.io/api/scheduling/v1alpha1.PriorityClass":                                                          schema_k8sio_api_scheduling_v1alpha1_PriorityClass(ref),
		"k8s.io/api/scheduling/v1alpha1.PriorityClassList":                                                      schema_k8sio_api_scheduling_v1alpha1_PriorityClassList(ref),
		"k8s.io/api/scheduling/v1beta1.PriorityClass":                                                           schema_k8sio_api_scheduling_v1beta1_PriorityClass(ref),
		"k8s.io/api/scheduling/v1beta1.PriorityClassList":                                                       schema_k8sio_api_scheduling_v1beta1_PriorityClassList(ref),
		"k8s.io/api/storage/v1.CSIDriver":                                                                       schema_k8sio_api_storage_v1_CSIDriver(ref),
		"k8s.io/api/storage/v1.CSIDriverList":                                                                   schema_k8sio_api_storage_v1_CSIDriverList(ref),
		"k8s.io/api/storage/v1.CSIDriverSpec":                                                                   schema_k8sio_api_storage_v1_CSIDriverSpec(ref),
		"k8s.io/api/storage/v1.CSINode":                                                                         schema_k8sio_api_storage_v1_CSINode(ref),
		"k8s.io/api/storage/v1.CSINodeDriver":                                                                   schema_k8sio_api_storage_v1_CSINodeDriver(ref),
		"k8s.io/api/storage/v1.CSINodeList":                                                                     schema_k8sio_api_storage_v1_CSINodeList(ref),
		"k8s.io/api/storage/v1.CSINodeSpec":                                                                     schema_k8sio_api_storage_v1_CSINodeSpec(ref),
		"k8s.io/api/storage/v1.CSIStorageCapacity":                                                              schema_k8sio_api_storage_v1_CSIStorageCapacity(ref),
		"k8s.io/api/storage/v1.CSIStorageCapacityList":                                                          schema_k8sio_api_storage_v1_CSIStorageCapacityList(ref),
		"k8s.io/api/storage/v1.StorageClass":                                                                    schema_k8sio_api_storage_v1_StorageClass(ref),
		"k8s.io/api/storage/v1.StorageClassList":                                                                schema_k8sio_api_storage_v1_StorageClassList(ref),
		"k8s.io/api/storage/v1.TokenRequest":                                                                    schema_k8sio_api_storage_v1_TokenRequest(ref),
		"k8s.io/api/storage/v1.VolumeAttachment":                                                                schema_k8sio_api_storage_v1_VolumeAttachment(ref),
		"k8s.io/api/storage/v1.VolumeAttachmentList":                                                            schema_k8sio_api_storage_v1_VolumeAttachmentList(ref),
		"k8s.io/api/storage/v1.VolumeAttachmentSource":                                                          schema_k8sio_api_storage_v1_VolumeAttachmentSource(ref),
		"k8s.io/api/storage/v1.VolumeAttachmentSpec":                                                            schema_k8sio_api_storage_v1_VolumeAttachmentSpec(ref),
		"k8s.io/api/storage/v1.VolumeAttachmentStatus":                                                          schema_k8sio_api_storage_v1_VolumeAttachmentStatus(ref),
		"k8s.io/api/storage/v1.VolumeError":                                                                     schema_k8sio_api_storage_v1_VolumeError(ref),
		"k8s.io/api/storage/v1.VolumeNodeResources":                                                             schema_k8sio_api_storage_v1_VolumeNodeResources(ref),
		"k8s.io/api/storage/v1alpha1.CSIStorageCapacity":                                                        schema_k8sio_api_storage_v1alpha1_CSIStorageCapacity(ref),
		"k8s.io/api/storage/v1alpha1.CSIStorageCapacityList":                                                    schema_k8sio_api_storage_v1alpha1_CSIStorageCapacityList(ref),
		"k8s.io/api/storage/v1alpha1.VolumeAttachment":                                                          schema_k8sio_api_storage_v1alpha1_VolumeAttachment(ref),
		"k8s.io/api/storage/v1alpha1.VolumeAttachmentList":                                                      schema_k8sio_api_storage_v1alpha1_VolumeAttachmentList(ref),
		"k8s.io/api/storage/v1alpha1.VolumeAttachmentSource":                                                    schema_k8sio_api_storage_v1alpha1_VolumeAttachmentSource(ref),
		"k8s.io/api/storage/v1alpha1.VolumeAttachmentSpec":                                                      schema_k8sio_api_storage_v1alpha1_VolumeAttachmentSpec(ref),
		"k8s.io/api/storage/v1alpha1.VolumeAttachmentStatus":                                                    schema_k8sio_api_storage_v1alpha1_VolumeAttachmentStatus(ref),
		"k8s.io/api/storage/v1alpha1.VolumeAttributesClass":                                                     schema_k8sio_api_storage_v1alpha1_VolumeAttributesClass(ref),
		"k8s.io/api/storage/v1alpha1.VolumeAttributesClassList":                                                 schema_k8sio_api_storage_v1alpha1_VolumeAttributesClassList(ref),
		"k8s.io/api/storage/v1alpha1.VolumeError":                                                               schema_k8sio_api_storage_v1alpha1_VolumeError(ref),
		"k8s.io/api/storage/v1beta1.CSIDriver":                                                                  schema_k8sio_api_storage_v1beta1_CSIDriver(ref),
		"k8s.io/api/storage/v1beta1.CSIDriverList":                                                              schema_k8sio_api_storage_v1beta1_CSIDriverList(ref),
		"k8s.io/api/storage/v1beta1.CSIDriverSpec":                                                              schema_k8sio_api_storage_v1beta1_CSIDriverSpec(ref),
		"k8s.io/api/storage/v1beta1.CSINode":                                                                    schema_k8sio_api_storage_v1beta1_CSINode(ref),
		"k8s.io/api/storage/v1beta1.CSINodeDriver":                                                              schema_k8sio_api_storage_v1beta1_CSINodeDriver(ref),
		"k8s.io/api/storage/v1beta1.CSINodeList":                                                                schema_k8sio_api_storage_v1beta1_CSINodeList(ref),
		"k8s.io/api/storage/v1beta1.CSINodeSpec":                                                                schema_k8sio_api_storage_v1beta1_CSINodeSpec(ref),
		"k8s.io/api/storage/v1beta1.CSIStorageCapacity":                                                         schema_k8sio_api_storage_v1beta1_CSIStorageCapacity(ref),
		"k8s.io/api/storage/v1beta1.CSIStorageCapacityList":                                                     schema_k8sio_api_storage_v1beta1_CSIStorageCapacityList(ref),
		"k8s.io/api/storage/v1beta1.StorageClass":                                                               schema_k8sio_api_storage_v1beta1_StorageClass(ref),
		"k8s.io/api/storage/v1beta1.StorageClassList":                                                           schema_k8sio_api_storage_v1beta1_StorageClassList(ref),
		"k8s.io/api/storage/v1beta1.TokenRequest":                                                               schema_k8sio_api_storage_v1beta1_TokenRequest(ref),
		"k8s.io/api/storage/v1beta1.VolumeAttachment":                                                           schema_k8sio_api_storage_v1beta1_VolumeAttachment(ref),
		"k8s.io/api/storage/v1beta1.VolumeAttachmentList":                                                       schema_k8sio_api_storage_v1beta1_VolumeAttachmentList(ref),
		"k8s.io/api/storage/v1beta1.VolumeAttachmentSource":                                                     schema_k8sio_api_storage_v1beta1_VolumeAttachmentSource(ref),
		"k8s.io/api/storage/v1beta1.VolumeAttachmentSpec":                                                       schema_k8sio_api_storage_v1beta1_VolumeAttachmentSpec(ref),
		"k8s.io/api/storage/v1beta1.VolumeAttachmentStatus":                                                     schema_k8sio_api_storage_v1beta1_VolumeAttachmentStatus(ref),
		"k8s.io/api/storage/v1beta1.VolumeAttributesClass":                                                      schema_k8sio_api_storage_v1beta1_VolumeAttributesClass(ref),
		"k8s.io/api/storage/v1beta1.VolumeAttributesClassList":                                                  schema_k8sio_api_storage_v1beta1_VolumeAttributesClassList(ref),
		"k8s.io/api/storage/v1beta1.VolumeError":                                                                schema_k8sio_api_storage_v1beta1_VolumeError(ref),
		"k8s.io/api/storage/v1beta1.VolumeNodeResources":                                                        schema_k8sio_api_storage_v1beta1_VolumeNodeResources(ref),
		"k8s.io/api/storagemigration/v1alpha1.GroupVersionResource":                                             schema_k8sio_api_storagemigration_v1alpha1_GroupVersionResource(ref),
		"k8s.io/api/storagemigration/v1alpha1.MigrationCondition":                                               schema_k8sio_api_storagemigration_v1alpha1_MigrationCondition(ref),
		"k8s.io/api/storagemigration/v1alpha1.StorageVersionMigration":                                          schema_k8sio_api_storagemigration_v1alpha1_StorageVersionMigration(ref),
		"k8s.io/api/storagemigration/v1alpha1.StorageVersionMigrationList":                                      schema_k8sio_api_storagemigration_v1alpha1_StorageVersionMigrationList(ref),
		"k8s.io/api/storagemigration/v1alpha1.StorageVersionMigrationSpec":                                      schema_k8sio_api_storagemigration_v1alpha1_StorageVersionMigrationSpec(ref),
		"k8s.io/api/storagemigration/v1alpha1.StorageVersionMigrationStatus":                                    schema_k8sio_api_storagemigration_v1alpha1_StorageVersionMigrationStatus(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.ConversionRequest":                            schema_pkg_apis_apiextensions_v1_ConversionRequest(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.ConversionResponse":                           schema_pkg_apis_apiextensions_v1_ConversionResponse(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.ConversionReview":                             schema_pkg_apis_apiextensions_v1_ConversionReview(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceColumnDefinition":               schema_pkg_apis_apiextensions_v1_CustomResourceColumnDefinition(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceConversion":                     schema_pkg_apis_apiextensions_v1_CustomResourceConversion(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceDefinition":                     schema_pkg_apis_apiextensions_v1_CustomResourceDefinition(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceDefinitionCondition":            schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionCondition(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceDefinitionList":                 schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionList(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceDefinitionNames":                schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionNames(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceDefinitionSpec":                 schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionSpec(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceDefinitionStatus":               schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionStatus(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceDefinitionVersion":              schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionVersion(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceSubresourceScale":               schema_pkg_apis_apiextensions_v1_CustomResourceSubresourceScale(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceSubresourceStatus":              schema_pkg_apis_apiextensions_v1_CustomResourceSubresourceStatus(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceSubresources":                   schema_pkg_apis_apiextensions_v1_CustomResourceSubresources(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.CustomResourceValidation":                     schema_pkg_apis_apiextensions_v1_CustomResourceValidation(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.ExternalDocumentation":                        schema_pkg_apis_apiextensions_v1_ExternalDocumentation(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON":                                         schema_pkg_apis_apiextensions_v1_JSON(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSONSchemaProps":                              schema_pkg_apis_apiextensions_v1_JSONSchemaProps(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSONSchemaPropsOrArray":                       schema_pkg_apis_apiextensions_v1_JSONSchemaPropsOrArray(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSONSchemaPropsOrBool":                        schema_pkg_apis_apiextensions_v1_JSONSchemaPropsOrBool(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSONSchemaPropsOrStringArray":                 schema_pkg_apis_apiextensions_v1_JSONSchemaPropsOrStringArray(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.SelectableField":                              schema_pkg_apis_apiextensions_v1_SelectableField(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.ServiceReference":                             schema_pkg_apis_apiextensions_v1_ServiceReference(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.ValidationRule":                               schema_pkg_apis_apiextensions_v1_ValidationRule(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.WebhookClientConfig":                          schema_pkg_apis_apiextensions_v1_WebhookClientConfig(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.WebhookConversion":                            schema_pkg_apis_apiextensions_v1_WebhookConversion(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.ConversionRequest":                       schema_pkg_apis_apiextensions_v1beta1_ConversionRequest(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.ConversionResponse":                      schema_pkg_apis_apiextensions_v1beta1_ConversionResponse(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.ConversionReview":                        schema_pkg_apis_apiextensions_v1beta1_ConversionReview(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceColumnDefinition":          schema_pkg_apis_apiextensions_v1beta1_CustomResourceColumnDefinition(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceConversion":                schema_pkg_apis_apiextensions_v1beta1_CustomResourceConversion(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceDefinition":                schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinition(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceDefinitionCondition":       schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionCondition(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceDefinitionList":            schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionList(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceDefinitionNames":           schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionNames(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceDefinitionSpec":            schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionSpec(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceDefinitionStatus":          schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionStatus(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceDefinitionVersion":         schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionVersion(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceSubresourceScale":          schema_pkg_apis_apiextensions_v1beta1_CustomResourceSubresourceScale(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceSubresourceStatus":         schema_pkg_apis_apiextensions_v1beta1_CustomResourceSubresourceStatus(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceSubresources":              schema_pkg_apis_apiextensions_v1beta1_CustomResourceSubresources(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.CustomResourceValidation":                schema_pkg_apis_apiextensions_v1beta1_CustomResourceValidation(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.ExternalDocumentation":                   schema_pkg_apis_apiextensions_v1beta1_ExternalDocumentation(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.JSON":                                    schema_pkg_apis_apiextensions_v1beta1_JSON(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.JSONSchemaProps":                         schema_pkg_apis_apiextensions_v1beta1_JSONSchemaProps(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.JSONSchemaPropsOrArray":                  schema_pkg_apis_apiextensions_v1beta1_JSONSchemaPropsOrArray(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.JSONSchemaPropsOrBool":                   schema_pkg_apis_apiextensions_v1beta1_JSONSchemaPropsOrBool(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.JSONSchemaPropsOrStringArray":            schema_pkg_apis_apiextensions_v1beta1_JSONSchemaPropsOrStringArray(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.SelectableField":                         schema_pkg_apis_apiextensions_v1beta1_SelectableField(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.ServiceReference":                        schema_pkg_apis_apiextensions_v1beta1_ServiceReference(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.ValidationRule":                          schema_pkg_apis_apiextensions_v1beta1_ValidationRule(ref),
		"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1.WebhookClientConfig":                     schema_pkg_apis_apiextensions_v1beta1_WebhookClientConfig(ref),
		"k8s.io/apimachinery/pkg/api/resource.Quantity":                                                         schema_apimachinery_pkg_api_resource_Quantity(ref),
		"k8s.io/apimachinery/pkg/api/resource.int64Amount":                                                      schema_apimachinery_pkg_api_resource_int64Amount(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup":                                                         schema_pkg_apis_meta_v1_APIGroup(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroupList":                                                     schema_pkg_apis_meta_v1_APIGroupList(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResource":                                                      schema_pkg_apis_meta_v1_APIResource(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResourceList":                                                  schema_pkg_apis_meta_v1_APIResourceList(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIVersions":                                                      schema_pkg_apis_meta_v1_APIVersions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ApplyOptions":                                                     schema_pkg_apis_meta_v1_ApplyOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Condition":                                                        schema_pkg_apis_meta_v1_Condition(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.CreateOptions":                                                    schema_pkg_apis_meta_v1_CreateOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.DeleteOptions":                                                    schema_pkg_apis_meta_v1_DeleteOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Duration":                                                         schema_pkg_apis_meta_v1_Duration(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.FieldSelectorRequirement":                                         schema_pkg_apis_meta_v1_FieldSelectorRequirement(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.FieldsV1":                                                         schema_pkg_apis_meta_v1_FieldsV1(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GetOptions":                                                       schema_pkg_apis_meta_v1_GetOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupKind":                                                        schema_pkg_apis_meta_v1_GroupKind(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupResource":                                                    schema_pkg_apis_meta_v1_GroupResource(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersion":                                                     schema_pkg_apis_meta_v1_GroupVersion(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery":                                         schema_pkg_apis_meta_v1_GroupVersionForDiscovery(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind":                                                 schema_pkg_apis_meta_v1_GroupVersionKind(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionResource":                                             schema_pkg_apis_meta_v1_GroupVersionResource(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.InternalEvent":                                                    schema_pkg_apis_meta_v1_InternalEvent(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector":                                                    schema_pkg_apis_meta_v1_LabelSelector(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement":                                         schema_pkg_apis_meta_v1_LabelSelectorRequirement(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.List":                                                             schema_pkg_apis_meta_v1_List(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta":                                                         schema_pkg_apis_meta_v1_ListMeta(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListOptions":                                                      schema_pkg_apis_meta_v1_ListOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ManagedFieldsEntry":                                               schema_pkg_apis_meta_v1_ManagedFieldsEntry(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime":                                                        schema_pkg_apis_meta_v1_MicroTime(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta":                                                       schema_pkg_apis_meta_v1_ObjectMeta(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference":                                                   schema_pkg_apis_meta_v1_OwnerReference(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.PartialObjectMetadata":                                            schema_pkg_apis_meta_v1_PartialObjectMetadata(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.PartialObjectMetadataList":                                        schema_pkg_apis_meta_v1_PartialObjectMetadataList(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Patch":                                                            schema_pkg_apis_meta_v1_Patch(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.PatchOptions":                                                     schema_pkg_apis_meta_v1_PatchOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions":                                                    schema_pkg_apis_meta_v1_Preconditions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.RootPaths":                                                        schema_pkg_apis_meta_v1_RootPaths(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR":                                        schema_pkg_apis_meta_v1_ServerAddressByClientCIDR(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Status":                                                           schema_pkg_apis_meta_v1_Status(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause":                                                      schema_pkg_apis_meta_v1_StatusCause(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails":                                                    schema_pkg_apis_meta_v1_StatusDetails(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Table":                                                            schema_pkg_apis_meta_v1_Table(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableColumnDefinition":                                            schema_pkg_apis_meta_v1_TableColumnDefinition(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableOptions":                                                     schema_pkg_apis_meta_v1_TableOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableRow":                                                         schema_pkg_apis_meta_v1_TableRow(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableRowCondition":                                                schema_pkg_apis_meta_v1_TableRowCondition(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Time":                                                             schema_pkg_apis_meta_v1_Time(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Timestamp":                                                        schema_pkg_apis_meta_v1_Timestamp(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta":                                                         schema_pkg_apis_meta_v1_TypeMeta(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.UpdateOptions":                                                    schema_pkg_apis_meta_v1_UpdateOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.WatchEvent":                                                       schema_pkg_apis_meta_v1_WatchEvent(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1beta1.PartialObjectMetadataList":                                   schema_pkg_apis_meta_v1beta1_PartialObjectMetadataList(ref),
		"k8s.io/apimachinery/pkg/runtime.RawExtension":                                                          schema_k8sio_apimachinery_pkg_runtime_RawExtension(ref),
		"k8s.io/apimachinery/pkg/runtime.TypeMeta":                                                              schema_k8sio_apimachinery_pkg_runtime_TypeMeta(ref),
		"k8s.io/apimachinery/pkg/runtime.Unknown":                                                               schema_k8sio_apimachinery_pkg_runtime_Unknown(ref),
		"k8s.io/apimachinery/pkg/util/intstr.IntOrString":                                                       schema_apimachinery_pkg_util_intstr_IntOrString(ref),
		"k8s.io/apimachinery/pkg/version.Info":                                                                  schema_k8sio_apimachinery_pkg_version_Info(ref),
		"k8s.io/apiserver/pkg/apis/audit/v1.Event":                                                              schema_pkg_apis_audit_v1_Event(ref),
		"k8s.io/apiserver/pkg/apis/audit/v1.EventList":                                                          schema_pkg_apis_audit_v1_EventList(ref),
		"k8s.io/apiserver/pkg/apis/audit/v1.GroupResources":                                                     schema_pkg_apis_audit_v1_GroupResources(ref),
		"k8s.io/apiserver/pkg/apis/audit/v1.ObjectReference":                                                    schema_pkg_apis_audit_v1_ObjectReference(ref),
		"k8s.io/apiserver/pkg/apis/audit/v1.Policy":                                                             schema_pkg_apis_audit_v1_Policy(ref),
		"k8s.io/apiserver/pkg/apis/audit/v1.PolicyList":                                                         schema_pkg_apis_audit_v1_PolicyList(ref),
		"k8s.io/apiserver/pkg/apis/audit/v1.PolicyRule":                                                         schema_pkg_apis_audit_v1_PolicyRule(ref),
		"k8s.io/client-go/pkg/apis/clientauthentication/v1.Cluster":                                             schema_pkg_apis_clientauthentication_v1_Cluster(ref),
		"k8s.io/client-go/pkg/apis/clientauthentication/v1.ExecCredential":                                      schema_pkg_apis_clientauthentication_v1_ExecCredential(ref),
		"k8s.io/client-go/pkg/apis/clientauthentication/v1.ExecCredentialSpec":                                  schema_pkg_apis_clientauthentication_v1_ExecCredentialSpec(ref),
		"k8s.io/client-go/pkg/apis/clientauthentication/v1.ExecCredentialStatus":                                schema_pkg_apis_clientauthentication_v1_ExecCredentialStatus(ref),
		"k8s.io/client-go/pkg/apis/clientauthentication/v1beta1.Cluster":                                        schema_pkg_apis_clientauthentication_v1beta1_Cluster(ref),
		"k8s.io/client-go/pkg/apis/clientauthentication/v1beta1.ExecCredential":                                 schema_pkg_apis_clientauthentication_v1beta1_ExecCredential(ref),
		"k8s.io/client-go/pkg/apis/clientauthentication/v1beta1.ExecCredentialSpec":                             schema_pkg_apis_clientauthentication_v1beta1_ExecCredentialSpec(ref),
		"k8s.io/client-go/pkg/apis/clientauthentication/v1beta1.ExecCredentialStatus":                           schema_pkg_apis_clientauthentication_v1beta1_ExecCredentialStatus(ref),
		"k8s.io/cloud-provider/config/v1alpha1.CloudControllerManagerConfiguration":                             schema_k8sio_cloud_provider_config_v1alpha1_CloudControllerManagerConfiguration(ref),
		"k8s.io/cloud-provider/config/v1alpha1.CloudProviderConfiguration":                                      schema_k8sio_cloud_provider_config_v1alpha1_CloudProviderConfiguration(ref),
		"k8s.io/cloud-provider/config/v1alpha1.KubeCloudSharedConfiguration":                                    schema_k8sio_cloud_provider_config_v1alpha1_KubeCloudSharedConfiguration(ref),
		"k8s.io/cloud-provider/config/v1alpha1.WebhookConfiguration":                                            schema_k8sio_cloud_provider_config_v1alpha1_WebhookConfiguration(ref),
		"k8s.io/controller-manager/config/v1alpha1.ControllerLeaderConfiguration":                               schema_k8sio_controller_manager_config_v1alpha1_ControllerLeaderConfiguration(ref),
		"k8s.io/controller-manager/config/v1alpha1.GenericControllerManagerConfiguration":                       schema_k8sio_controller_manager_config_v1alpha1_GenericControllerManagerConfiguration(ref),
		"k8s.io/controller-manager/config/v1alpha1.LeaderMigrationConfiguration":                                schema_k8sio_controller_manager_config_v1alpha1_LeaderMigrationConfiguration(ref),
		"k8s.io/controller-manager/config/v1beta1.ControllerLeaderConfiguration":                                schema_k8sio_controller_manager_config_v1beta1_ControllerLeaderConfiguration(ref),
		"k8s.io/controller-manager/config/v1beta1.LeaderMigrationConfiguration":                                 schema_k8sio_controller_manager_config_v1beta1_LeaderMigrationConfiguration(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1.APIService":                                         schema_pkg_apis_apiregistration_v1_APIService(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1.APIServiceCondition":                                schema_pkg_apis_apiregistration_v1_APIServiceCondition(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1.APIServiceList":                                     schema_pkg_apis_apiregistration_v1_APIServiceList(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1.APIServiceSpec":                                     schema_pkg_apis_apiregistration_v1_APIServiceSpec(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1.APIServiceStatus":                                   schema_pkg_apis_apiregistration_v1_APIServiceStatus(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1.ServiceReference":                                   schema_pkg_apis_apiregistration_v1_ServiceReference(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIService":                                    schema_pkg_apis_apiregistration_v1beta1_APIService(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceCondition":                           schema_pkg_apis_apiregistration_v1beta1_APIServiceCondition(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceList":                                schema_pkg_apis_apiregistration_v1beta1_APIServiceList(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceSpec":                                schema_pkg_apis_apiregistration_v1beta1_APIServiceSpec(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.APIServiceStatus":                              schema_pkg_apis_apiregistration_v1beta1_APIServiceStatus(ref),
		"k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1.ServiceReference":                              schema_pkg_apis_apiregistration_v1beta1_ServiceReference(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.AttachDetachControllerConfiguration":                    schema_k8sio_kube_controller_manager_config_v1alpha1_AttachDetachControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.CSRSigningConfiguration":                                schema_k8sio_kube_controller_manager_config_v1alpha1_CSRSigningConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.CSRSigningControllerConfiguration":                      schema_k8sio_kube_controller_manager_config_v1alpha1_CSRSigningControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.CronJobControllerConfiguration":                         schema_k8sio_kube_controller_manager_config_v1alpha1_CronJobControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.DaemonSetControllerConfiguration":                       schema_k8sio_kube_controller_manager_config_v1alpha1_DaemonSetControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.DeploymentControllerConfiguration":                      schema_k8sio_kube_controller_manager_config_v1alpha1_DeploymentControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.DeprecatedControllerConfiguration":                      schema_k8sio_kube_controller_manager_config_v1alpha1_DeprecatedControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.EndpointControllerConfiguration":                        schema_k8sio_kube_controller_manager_config_v1alpha1_EndpointControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.EndpointSliceControllerConfiguration":                   schema_k8sio_kube_controller_manager_config_v1alpha1_EndpointSliceControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.EndpointSliceMirroringControllerConfiguration":          schema_k8sio_kube_controller_manager_config_v1alpha1_EndpointSliceMirroringControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.EphemeralVolumeControllerConfiguration":                 schema_k8sio_kube_controller_manager_config_v1alpha1_EphemeralVolumeControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.GarbageCollectorControllerConfiguration":                schema_k8sio_kube_controller_manager_config_v1alpha1_GarbageCollectorControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.GroupResource":                                          schema_k8sio_kube_controller_manager_config_v1alpha1_GroupResource(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.HPAControllerConfiguration":                             schema_k8sio_kube_controller_manager_config_v1alpha1_HPAControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.JobControllerConfiguration":                             schema_k8sio_kube_controller_manager_config_v1alpha1_JobControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.KubeControllerManagerConfiguration":                     schema_k8sio_kube_controller_manager_config_v1alpha1_KubeControllerManagerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.LegacySATokenCleanerConfiguration":                      schema_k8sio_kube_controller_manager_config_v1alpha1_LegacySATokenCleanerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.NamespaceControllerConfiguration":                       schema_k8sio_kube_controller_manager_config_v1alpha1_NamespaceControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.NodeIPAMControllerConfiguration":                        schema_k8sio_kube_controller_manager_config_v1alpha1_NodeIPAMControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.NodeLifecycleControllerConfiguration":                   schema_k8sio_kube_controller_manager_config_v1alpha1_NodeLifecycleControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.PersistentVolumeBinderControllerConfiguration":          schema_k8sio_kube_controller_manager_config_v1alpha1_PersistentVolumeBinderControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.PersistentVolumeRecyclerConfiguration":                  schema_k8sio_kube_controller_manager_config_v1alpha1_PersistentVolumeRecyclerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.PodGCControllerConfiguration":                           schema_k8sio_kube_controller_manager_config_v1alpha1_PodGCControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.ReplicaSetControllerConfiguration":                      schema_k8sio_kube_controller_manager_config_v1alpha1_ReplicaSetControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.ReplicationControllerConfiguration":                     schema_k8sio_kube_controller_manager_config_v1alpha1_ReplicationControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.ResourceQuotaControllerConfiguration":                   schema_k8sio_kube_controller_manager_config_v1alpha1_ResourceQuotaControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.SAControllerConfiguration":                              schema_k8sio_kube_controller_manager_config_v1alpha1_SAControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.StatefulSetControllerConfiguration":                     schema_k8sio_kube_controller_manager_config_v1alpha1_StatefulSetControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.TTLAfterFinishedControllerConfiguration":                schema_k8sio_kube_controller_manager_config_v1alpha1_TTLAfterFinishedControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.ValidatingAdmissionPolicyStatusControllerConfiguration": schema_k8sio_kube_controller_manager_config_v1alpha1_ValidatingAdmissionPolicyStatusControllerConfiguration(ref),
		"k8s.io/kube-controller-manager/config/v1alpha1.VolumeConfiguration":                                    schema_k8sio_kube_controller_manager_config_v1alpha1_VolumeConfiguration(ref),
		"k8s.io/kube-proxy/config/v1alpha1.DetectLocalConfiguration":                                            schema_k8sio_kube_proxy_config_v1alpha1_DetectLocalConfiguration(ref),
		"k8s.io/kube-proxy/config/v1alpha1.KubeProxyConfiguration":                                              schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyConfiguration(ref),
		"k8s.io/kube-proxy/config/v1alpha1.KubeProxyConntrackConfiguration":                                     schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyConntrackConfiguration(ref),
		"k8s.io/kube-proxy/config/v1alpha1.KubeProxyIPTablesConfiguration":                                      schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyIPTablesConfiguration(ref),
		"k8s.io/kube-proxy/config/v1alpha1.KubeProxyIPVSConfiguration":                                          schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyIPVSConfiguration(ref),
		"k8s.io/kube-proxy/config/v1alpha1.KubeProxyNFTablesConfiguration":                                      schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyNFTablesConfiguration(ref),
		"k8s.io/kube-proxy/config/v1alpha1.KubeProxyWinkernelConfiguration":                                     schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyWinkernelConfiguration(ref),
		"k8s.io/kube-scheduler/config/v1.DefaultPreemptionArgs":                                                 schema_k8sio_kube_scheduler_config_v1_DefaultPreemptionArgs(ref),
		"k8s.io/kube-scheduler/config/v1.Extender":                                                              schema_k8sio_kube_scheduler_config_v1_Extender(ref),
		"k8s.io/kube-scheduler/config/v1.ExtenderManagedResource":                                               schema_k8sio_kube_scheduler_config_v1_ExtenderManagedResource(ref),
		"k8s.io/kube-scheduler/config/v1.ExtenderTLSConfig":                                                     schema_k8sio_kube_scheduler_config_v1_ExtenderTLSConfig(ref),
		"k8s.io/kube-scheduler/config/v1.InterPodAffinityArgs":                                                  schema_k8sio_kube_scheduler_config_v1_InterPodAffinityArgs(ref),
		"k8s.io/kube-scheduler/config/v1.KubeSchedulerConfiguration":                                            schema_k8sio_kube_scheduler_config_v1_KubeSchedulerConfiguration(ref),
		"k8s.io/kube-scheduler/config/v1.KubeSchedulerProfile":                                                  schema_k8sio_kube_scheduler_config_v1_KubeSchedulerProfile(ref),
		"k8s.io/kube-scheduler/config/v1.NodeAffinityArgs":                                                      schema_k8sio_kube_scheduler_config_v1_NodeAffinityArgs(ref),
		"k8s.io/kube-scheduler/config/v1.NodeResourcesBalancedAllocationArgs":                                   schema_k8sio_kube_scheduler_config_v1_NodeResourcesBalancedAllocationArgs(ref),
		"k8s.io/kube-scheduler/config/v1.NodeResourcesFitArgs":                                                  schema_k8sio_kube_scheduler_config_v1_NodeResourcesFitArgs(ref),
		"k8s.io/kube-scheduler/config/v1.Plugin":                                                                schema_k8sio_kube_scheduler_config_v1_Plugin(ref),
		"k8s.io/kube-scheduler/config/v1.PluginConfig":                                                          schema_k8sio_kube_scheduler_config_v1_PluginConfig(ref),
		"k8s.io/kube-scheduler/config/v1.PluginSet":                                                             schema_k8sio_kube_scheduler_config_v1_PluginSet(ref),
		"k8s.io/kube-scheduler/config/v1.Plugins":                                                               schema_k8sio_kube_scheduler_config_v1_Plugins(ref),
		"k8s.io/kube-scheduler/config/v1.PodTopologySpreadArgs":                                                 schema_k8sio_kube_scheduler_config_v1_PodTopologySpreadArgs(ref),
		"k8s.io/kube-scheduler/config/v1.RequestedToCapacityRatioParam":                                         schema_k8sio_kube_scheduler_config_v1_RequestedToCapacityRatioParam(ref),
		"k8s.io/kube-scheduler/config/v1.ResourceSpec":                                                          schema_k8sio_kube_scheduler_config_v1_ResourceSpec(ref),
		"k8s.io/kube-scheduler/config/v1.ScoringStrategy":                                                       schema_k8sio_kube_scheduler_config_v1_ScoringStrategy(ref),
		"k8s.io/kube-scheduler/config/v1.UtilizationShapePoint":                                                 schema_k8sio_kube_scheduler_config_v1_UtilizationShapePoint(ref),
		"k8s.io/kube-scheduler/config/v1.VolumeBindingArgs":                                                     schema_k8sio_kube_scheduler_config_v1_VolumeBindingArgs(ref),
		"k8s.io/kubelet/config/v1.CredentialProvider":                                                           schema_k8sio_kubelet_config_v1_CredentialProvider(ref),
		"k8s.io/kubelet/config/v1.CredentialProviderConfig":                                                     schema_k8sio_kubelet_config_v1_CredentialProviderConfig(ref),
		"k8s.io/kubelet/config/v1.ExecEnvVar":                                                                   schema_k8sio_kubelet_config_v1_ExecEnvVar(ref),
		"k8s.io/kubelet/config/v1alpha1.CredentialProvider":                                                     schema_k8sio_kubelet_config_v1alpha1_CredentialProvider(ref),
		"k8s.io/kubelet/config/v1alpha1.CredentialProviderConfig":                                               schema_k8sio_kubelet_config_v1alpha1_CredentialProviderConfig(ref),
		"k8s.io/kubelet/config/v1alpha1.ExecEnvVar":                                                             schema_k8sio_kubelet_config_v1alpha1_ExecEnvVar(ref),
		"k8s.io/kubelet/config/v1beta1.CredentialProvider":                                                      schema_k8sio_kubelet_config_v1beta1_CredentialProvider(ref),
		"k8s.io/kubelet/config/v1beta1.CredentialProviderConfig":                                                schema_k8sio_kubelet_config_v1beta1_CredentialProviderConfig(ref),
		"k8s.io/kubelet/config/v1beta1.ExecEnvVar":                                                              schema_k8sio_kubelet_config_v1beta1_ExecEnvVar(ref),
		"k8s.io/kubelet/config/v1beta1.KubeletAnonymousAuthentication":                                          schema_k8sio_kubelet_config_v1beta1_KubeletAnonymousAuthentication(ref),
		"k8s.io/kubelet/config/v1beta1.KubeletAuthentication":                                                   schema_k8sio_kubelet_config_v1beta1_KubeletAuthentication(ref),
		"k8s.io/kubelet/config/v1beta1.KubeletAuthorization":                                                    schema_k8sio_kubelet_config_v1beta1_KubeletAuthorization(ref),
		"k8s.io/kubelet/config/v1beta1.KubeletConfiguration":                                                    schema_k8sio_kubelet_config_v1beta1_KubeletConfiguration(ref),
		"k8s.io/kubelet/config/v1beta1.KubeletWebhookAuthentication":                                            schema_k8sio_kubelet_config_v1beta1_KubeletWebhookAuthentication(ref),
		"k8s.io/kubelet/config/v1beta1.KubeletWebhookAuthorization":                                             schema_k8sio_kubelet_config_v1beta1_KubeletWebhookAuthorization(ref),
		"k8s.io/kubelet/config/v1beta1.KubeletX509Authentication":                                               schema_k8sio_kubelet_config_v1beta1_KubeletX509Authentication(ref),
		"k8s.io/kubelet/config/v1beta1.MemoryReservation":                                                       schema_k8sio_kubelet_config_v1beta1_MemoryReservation(ref),
		"k8s.io/kubelet/config/v1beta1.MemorySwapConfiguration":                                                 schema_k8sio_kubelet_config_v1beta1_MemorySwapConfiguration(ref),
		"k8s.io/kubelet/config/v1beta1.SerializedNodeConfigSource":                                              schema_k8sio_kubelet_config_v1beta1_SerializedNodeConfigSource(ref),
		"k8s.io/kubelet/config/v1beta1.ShutdownGracePeriodByPodPriority":                                        schema_k8sio_kubelet_config_v1beta1_ShutdownGracePeriodByPodPriority(ref),
		"k8s.io/kubernetes/pkg/apis/abac/v1beta1.Policy":                                                        schema_pkg_apis_abac_v1beta1_Policy(ref),
		"k8s.io/kubernetes/pkg/apis/abac/v1beta1.PolicySpec":                                                    schema_pkg_apis_abac_v1beta1_PolicySpec(ref),
		"k8s.io/metrics/pkg/apis/custom_metrics/v1beta1.MetricListOptions":                                      schema_pkg_apis_custom_metrics_v1beta1_MetricListOptions(ref),
		"k8s.io/metrics/pkg/apis/custom_metrics/v1beta1.MetricValue":                                            schema_pkg_apis_custom_metrics_v1beta1_MetricValue(ref),
		"k8s.io/metrics/pkg/apis/custom_metrics/v1beta1.MetricValueList":                                        schema_pkg_apis_custom_metrics_v1beta1_MetricValueList(ref),
		"k8s.io/metrics/pkg/apis/custom_metrics/v1beta2.MetricIdentifier":                                       schema_pkg_apis_custom_metrics_v1beta2_MetricIdentifier(ref),
		"k8s.io/metrics/pkg/apis/custom_metrics/v1beta2.MetricListOptions":                                      schema_pkg_apis_custom_metrics_v1beta2_MetricListOptions(ref),
		"k8s.io/metrics/pkg/apis/custom_metrics/v1beta2.MetricValue":                                            schema_pkg_apis_custom_metrics_v1beta2_MetricValue(ref),
		"k8s.io/metrics/pkg/apis/custom_metrics/v1beta2.MetricValueList":                                        schema_pkg_apis_custom_metrics_v1beta2_MetricValueList(ref),
		"k8s.io/metrics/pkg/apis/external_metrics/v1beta1.ExternalMetricValue":                                  schema_pkg_apis_external_metrics_v1beta1_ExternalMetricValue(ref),
		"k8s.io/metrics/pkg/apis/external_metrics/v1beta1.ExternalMetricValueList":                              schema_pkg_apis_external_metrics_v1beta1_ExternalMetricValueList(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1alpha1.ContainerMetrics":                                             schema_pkg_apis_metrics_v1alpha1_ContainerMetrics(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1alpha1.NodeMetrics":                                                  schema_pkg_apis_metrics_v1alpha1_NodeMetrics(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1alpha1.NodeMetricsList":                                              schema_pkg_apis_metrics_v1alpha1_NodeMetricsList(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1alpha1.PodMetrics":                                                   schema_pkg_apis_metrics_v1alpha1_PodMetrics(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1alpha1.PodMetricsList":                                               schema_pkg_apis_metrics_v1alpha1_PodMetricsList(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1beta1.ContainerMetrics":                                              schema_pkg_apis_metrics_v1beta1_ContainerMetrics(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1beta1.NodeMetrics":                                                   schema_pkg_apis_metrics_v1beta1_NodeMetrics(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1beta1.NodeMetricsList":                                               schema_pkg_apis_metrics_v1beta1_NodeMetricsList(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1beta1.PodMetrics":                                                    schema_pkg_apis_metrics_v1beta1_PodMetrics(ref),
		"k8s.io/metrics/pkg/apis/metrics/v1beta1.PodMetricsList":                                                schema_pkg_apis_metrics_v1beta1_PodMetricsList(ref),
	}
}

func schema_k8sio_api_admissionregistration_v1_AuditAnnotation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditAnnotation describes how to produce an audit annotation for an API request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.\n\nThe key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: \"{ValidatingAdmissionPolicy name}/{key}\".\n\nIf an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"valueExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.\n\nIf multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key", "valueExpression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_ExpressionWarning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExpressionWarning is a warning information that targets a specific expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is \"spec.validations[0].expression\"",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"warning": {
						SchemaProps: spec.SchemaProps{
							Description: "The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"fieldRef", "warning"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_MatchCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchCondition represents a condition which must by fulfilled for a request to be sent to a webhook.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:\n\n'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\nDocumentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_MatchResources(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the policy on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.NamedRuleWithOperations"),
									},
								},
							},
						},
					},
					"excludeResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.NamedRuleWithOperations"),
									},
								},
							},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"MatchResources\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.\n\nDefaults to \"Equivalent\"\n\nPossible enum values:\n - `\"Equivalent\"` means requests should be sent to the webhook if they modify a resource listed in rules via another API group or version.\n - `\"Exact\"` means requests should only be sent to the webhook if they exactly match a given rule.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Equivalent", "Exact"},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.NamedRuleWithOperations", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1_MutatingWebhook(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhook describes an admission webhook and the resources and operations it applies to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientConfig defines how to communicate with the hook. Required",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1.WebhookClientConfig"),
						},
					},
					"rules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.RuleWithOperations"),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Fail.\n\nPossible enum values:\n - `\"Fail\"` means that an error calling the webhook causes the admission to fail.\n - `\"Ignore\"` means that an error calling the webhook is ignored.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Fail", "Ignore"},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"rules\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.\n\nDefaults to \"Equivalent\"\n\nPossible enum values:\n - `\"Equivalent\"` means requests should be sent to the webhook if they modify a resource listed in rules via another API group or version.\n - `\"Exact\"` means requests should only be sent to the webhook if they exactly match a given rule.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Equivalent", "Exact"},
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the webhook on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"sideEffects": {
						SchemaProps: spec.SchemaProps{
							Description: "SideEffects states whether this webhook has side effects. Acceptable values are: None, NoneOnDryRun (webhooks created via v1beta1 may also specify Some or Unknown). Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some.\n\nPossible enum values:\n - `\"None\"` means that calling the webhook will have no side effects.\n - `\"NoneOnDryRun\"` means that calling the webhook will possibly have side effects, but if the request being reviewed has the dry-run attribute, the side effects will be suppressed.\n - `\"Some\"` means that calling the webhook will possibly have side effects. If a request with the dry-run attribute would trigger a call to this webhook, the request will instead fail.\n - `\"Unknown\"` means that no information is known about the side effects of calling the webhook. If a request with the dry-run attribute would trigger a call to this webhook, the request will instead fail.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"None", "NoneOnDryRun", "Some", "Unknown"},
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 10 seconds.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"admissionReviewVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"reinvocationPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation. Allowed values are \"Never\" and \"IfNeeded\".\n\nNever: the webhook will not be called more than once in a single admission evaluation.\n\nIfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.\n\nDefaults to \"Never\".\n\nPossible enum values:\n - `\"IfNeeded\"` indicates that the webhook may be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call.\n - `\"Never\"` indicates that the webhook must not be called more than once in a single admission evaluation.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"IfNeeded", "Never"},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be sent to this webhook. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the webhook is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the webhook is called.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the error is ignored and the webhook is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.MatchCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "clientConfig", "sideEffects", "admissionReviewVersions"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.MatchCondition", "k8s.io/api/admissionregistration/v1.RuleWithOperations", "k8s.io/api/admissionregistration/v1.WebhookClientConfig", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1_MutatingWebhookConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"webhooks": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Webhooks is a list of webhooks and the affected resources and operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.MutatingWebhook"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.MutatingWebhook", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1_MutatingWebhookConfigurationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of MutatingWebhookConfiguration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.MutatingWebhookConfiguration"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.MutatingWebhookConfiguration", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1_NamedRuleWithOperations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"operations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"*", "CONNECT", "CREATE", "DELETE", "UPDATE"},
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_ParamKind(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamKind is a tuple of Group Kind and Version.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion is the API group version the resources belong to. In format of \"group/version\". Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the API kind the resources belong to. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_ParamRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource being referenced.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.\n\nA single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.\n\nA per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.\n\n- If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.\n\n- If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.\n\nIf multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"parameterNotFoundAction": {
						SchemaProps: spec.SchemaProps{
							Description: "`parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.\n\nAllowed values are `Allow` or `Deny`\n\nRequired",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1_Rule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Rule is a tuple of APIGroups, APIVersion, and Resources.It is recommended to make sure that all the tuple expansions are valid.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_RuleWithOperations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"operations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"*", "CONNECT", "CREATE", "DELETE", "UPDATE"},
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_ServiceReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceReference holds a reference to Service.legacy.k8s.io",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "`namespace` is the namespace of the service. Required",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "`name` is the name of the service. Required",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "`path` is an optional URL path which will be sent in any request to this service.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"namespace", "name"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_TypeChecking(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expressionWarnings": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The type checking warnings for each expression.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.ExpressionWarning"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.ExpressionWarning"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicy.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicySpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicySpec", "k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.\n\nFor a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding.\n\nThe CEL expressions of a policy must have a computed CEL cost below the maximum CEL budget. Each evaluation of the policy is given an independent CEL cost budget. Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyBindingSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyBindingSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingList is a list of ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of PolicyBinding.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicyBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBindingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"policyName": {
						SchemaProps: spec.SchemaProps{
							Description: "PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"paramRef": {
						SchemaProps: spec.SchemaProps{
							Description: "paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.",
							Ref:         ref("k8s.io/api/admissionregistration/v1.ParamRef"),
						},
					},
					"matchResources": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.",
							Ref:         ref("k8s.io/api/admissionregistration/v1.MatchResources"),
						},
					},
					"validationActions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.\n\nFailures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.\n\nvalidationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.\n\nThe supported actions values are:\n\n\"Deny\" specifies that a validation failure results in a denied request.\n\n\"Warn\" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.\n\n\"Audit\" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `\"validation.policy.admission.k8s.io/validation_failure\": \"[{\"message\": \"Invalid value\", {\"policy\": \"policy.example.com\", {\"binding\": \"policybinding.example.com\", {\"expressionIndex\": \"1\", {\"validationActions\": [\"Audit\"]}]\"`\n\nClients should expect to handle additional values by ignoring any values not recognized.\n\n\"Deny\" and \"Warn\" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.\n\nRequired.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"Audit", "Deny", "Warn"},
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.MatchResources", "k8s.io/api/admissionregistration/v1.ParamRef"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyList is a list of ValidatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingAdmissionPolicy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicy"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.ValidatingAdmissionPolicy", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paramKind": {
						SchemaProps: spec.SchemaProps{
							Description: "ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.",
							Ref:         ref("k8s.io/api/admissionregistration/v1.ParamKind"),
						},
					},
					"matchConstraints": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.",
							Ref:         ref("k8s.io/api/admissionregistration/v1.MatchResources"),
						},
					},
					"validations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.Validation"),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.\n\nA policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.\n\nfailurePolicy does not define how validations that evaluate to false are handled.\n\nWhen failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.\n\nAllowed values are Ignore or Fail. Defaults to Fail.\n\nPossible enum values:\n - `\"Fail\"` means that an error calling the webhook causes the admission to fail.\n - `\"Ignore\"` means that an error calling the webhook is ignored.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Fail", "Ignore"},
						},
					},
					"auditAnnotations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.AuditAnnotation"),
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the policy is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.MatchCondition"),
									},
								},
							},
						},
					},
					"variables": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.\n\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.Variable"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.AuditAnnotation", "k8s.io/api/admissionregistration/v1.MatchCondition", "k8s.io/api/admissionregistration/v1.MatchResources", "k8s.io/api/admissionregistration/v1.ParamKind", "k8s.io/api/admissionregistration/v1.Validation", "k8s.io/api/admissionregistration/v1.Variable"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyStatus represents the status of an admission validation policy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"typeChecking": {
						SchemaProps: spec.SchemaProps{
							Description: "The results of type checking for each expression. Presence of this field indicates the completion of the type checking.",
							Ref:         ref("k8s.io/api/admissionregistration/v1.TypeChecking"),
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The conditions represent the latest available observations of a policy's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.Condition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.TypeChecking", "k8s.io/apimachinery/pkg/apis/meta/v1.Condition"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingWebhook(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhook describes an admission webhook and the resources and operations it applies to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientConfig defines how to communicate with the hook. Required",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1.WebhookClientConfig"),
						},
					},
					"rules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.RuleWithOperations"),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Fail.\n\nPossible enum values:\n - `\"Fail\"` means that an error calling the webhook causes the admission to fail.\n - `\"Ignore\"` means that an error calling the webhook is ignored.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Fail", "Ignore"},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"rules\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.\n\nDefaults to \"Equivalent\"\n\nPossible enum values:\n - `\"Equivalent\"` means requests should be sent to the webhook if they modify a resource listed in rules via another API group or version.\n - `\"Exact\"` means requests should only be sent to the webhook if they exactly match a given rule.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Equivalent", "Exact"},
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the webhook on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"sideEffects": {
						SchemaProps: spec.SchemaProps{
							Description: "SideEffects states whether this webhook has side effects. Acceptable values are: None, NoneOnDryRun (webhooks created via v1beta1 may also specify Some or Unknown). Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some.\n\nPossible enum values:\n - `\"None\"` means that calling the webhook will have no side effects.\n - `\"NoneOnDryRun\"` means that calling the webhook will possibly have side effects, but if the request being reviewed has the dry-run attribute, the side effects will be suppressed.\n - `\"Some\"` means that calling the webhook will possibly have side effects. If a request with the dry-run attribute would trigger a call to this webhook, the request will instead fail.\n - `\"Unknown\"` means that no information is known about the side effects of calling the webhook. If a request with the dry-run attribute would trigger a call to this webhook, the request will instead fail.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"None", "NoneOnDryRun", "Some", "Unknown"},
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 10 seconds.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"admissionReviewVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be sent to this webhook. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the webhook is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the webhook is called.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the error is ignored and the webhook is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.MatchCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "clientConfig", "sideEffects", "admissionReviewVersions"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.MatchCondition", "k8s.io/api/admissionregistration/v1.RuleWithOperations", "k8s.io/api/admissionregistration/v1.WebhookClientConfig", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingWebhookConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"webhooks": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Webhooks is a list of webhooks and the affected resources and operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.ValidatingWebhook"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.ValidatingWebhook", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingWebhookConfigurationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingWebhookConfiguration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.ValidatingWebhookConfiguration"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.ValidatingWebhookConfiguration", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1_Validation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Validation specifies the CEL expression which is used to apply the validation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nThe `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:\n\t  \"true\", \"false\", \"null\", \"in\", \"as\", \"break\", \"const\", \"continue\", \"else\", \"for\", \"function\", \"if\",\n\t  \"import\", \"let\", \"loop\", \"package\", \"namespace\", \"return\".\nExamples:\n  - Expression accessing a property named \"namespace\": {\"Expression\": \"object.__namespace__ > 0\"}\n  - Expression accessing a property named \"x-prop\": {\"Expression\": \"object.x__dash__prop > 0\"}\n  - Expression accessing a property named \"redact__d\": {\"Expression\": \"object.redact__underscores__d > 0\"}\n\nEquality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:\n  - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and\n    non-intersecting elements in `Y` are appended, retaining their partial order.\n  - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values\n    are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with\n    non-intersecting keys are appended, retaining their partial order.\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is \"failed rule: {Rule}\". e.g. \"must be a URL with the host matching spec.host\" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is \"failed Expression: {Expression}\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: \"Unauthorized\", \"Forbidden\", \"Invalid\", \"RequestEntityTooLarge\". If not set, StatusReasonInvalid is used in the response to the client.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"messageExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: \"object.x must be less than max (\"+string(params.max)+\")\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_Variable(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Variable is the definition of a variable that is used for composition. A variable is defined as a named expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is \"foo\", the variable will be available as `variables.foo`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_WebhookClientConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WebhookClientConfig contains the information to make a TLS connection with the webhook",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"url": {
						SchemaProps: spec.SchemaProps{
							Description: "`url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.\n\nThe `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.\n\nPlease note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.\n\nThe scheme must be \"https\"; the URL must begin with \"https://\".\n\nA path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.\n\nAttempting to use a user or basic auth e.g. \"user:password@\" is not allowed. Fragments (\"#...\") and query parameters (\"?...\") are not allowed, either.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"service": {
						SchemaProps: spec.SchemaProps{
							Description: "`service` is a reference to the service for this webhook. Either `service` or `url` must be specified.\n\nIf the webhook is running within the cluster, then you should use `service`.",
							Ref:         ref("k8s.io/api/admissionregistration/v1.ServiceReference"),
						},
					},
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "`caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.ServiceReference"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_AuditAnnotation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditAnnotation describes how to produce an audit annotation for an API request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.\n\nThe key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: \"{ValidatingAdmissionPolicy name}/{key}\".\n\nIf an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"valueExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.\n\nIf multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key", "valueExpression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ExpressionWarning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExpressionWarning is a warning information that targets a specific expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is \"spec.validations[0].expression\"",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"warning": {
						SchemaProps: spec.SchemaProps{
							Description: "The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"fieldRef", "warning"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MatchCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:\n\n'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\nDocumentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MatchResources(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the policy on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1alpha1.NamedRuleWithOperations"),
									},
								},
							},
						},
					},
					"excludeResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1alpha1.NamedRuleWithOperations"),
									},
								},
							},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"MatchResources\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.\n\nDefaults to \"Equivalent\"\n\nPossible enum values:\n - `\"Equivalent\"` means requests should be sent to the webhook if they modify a resource listed in rules via another API group or version.\n - `\"Exact\"` means requests should only be sent to the webhook if they exactly match a given rule.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Equivalent", "Exact"},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1alpha1.NamedRuleWithOperations", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_NamedRuleWithOperations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"operations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"*", "CONNECT", "CREATE", "DELETE", "UPDATE"},
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ParamKind(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamKind is a tuple of Group Kind and Version.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion is the API group version the resources belong to. In format of \"group/version\". Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the API kind the resources belong to. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ParamRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "`name` is the name of the resource being referenced.\n\n`name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.\n\nA per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.\n\n- If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.\n\n- If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.\n\nIf multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"parameterNotFoundAction": {
						SchemaProps: spec.SchemaProps{
							Description: "`parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.\n\nAllowed values are `Allow` or `Deny` Default to `Deny`\n\nPossible enum values:\n - `\"Allow\"` Ignore means that an error finding params for a binding is ignored\n - `\"Deny\"` Fail means that an error finding params for a binding is ignored",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Allow", "Deny"},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_TypeChecking(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expressionWarnings": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The type checking warnings for each expression.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1alpha1.ExpressionWarning"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1alpha1.ExpressionWarning"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicy.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicySpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicySpec", "k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.\n\nFor a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding.\n\nThe CEL expressions of a policy must have a computed CEL cost below the maximum CEL budget. Each evaluation of the policy is given an independent CEL cost budget. Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyBindingSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyBindingSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingList is a list of ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of PolicyBinding.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicyBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBindingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"policyName": {
						SchemaProps: spec.SchemaProps{
							Description: "PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"paramRef": {
						SchemaProps: spec.SchemaProps{
							Description: "paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.",
							Ref:         ref("k8s.io/api/admissionregistration/v1alpha1.ParamRef"),
						},
					},
					"matchResources": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.",
							Ref:         ref("k8s.io/api/admissionregistration/v1alpha1.MatchResources"),
						},
					},
					"validationActions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.\n\nFailures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.\n\nvalidationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.\n\nThe supported actions values are:\n\n\"Deny\" specifies that a validation failure results in a denied request.\n\n\"Warn\" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.\n\n\"Audit\" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `\"validation.policy.admission.k8s.io/validation_failure\": \"[{\"message\": \"Invalid value\", {\"policy\": \"policy.example.com\", {\"binding\": \"policybinding.example.com\", {\"expressionIndex\": \"1\", {\"validationActions\": [\"Audit\"]}]\"`\n\nClients should expect to handle additional values by ignoring any values not recognized.\n\n\"Deny\" and \"Warn\" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.\n\nRequired.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"Audit", "Deny", "Warn"},
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1alpha1.MatchResources", "k8s.io/api/admissionregistration/v1alpha1.ParamRef"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyList is a list of ValidatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingAdmissionPolicy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicy"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1alpha1.ValidatingAdmissionPolicy", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paramKind": {
						SchemaProps: spec.SchemaProps{
							Description: "ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.",
							Ref:         ref("k8s.io/api/admissionregistration/v1alpha1.ParamKind"),
						},
					},
					"matchConstraints": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.",
							Ref:         ref("k8s.io/api/admissionregistration/v1alpha1.MatchResources"),
						},
					},
					"validations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1alpha1.Validation"),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.\n\nA policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.\n\nfailurePolicy does not define how validations that evaluate to false are handled.\n\nWhen failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.\n\nAllowed values are Ignore or Fail. Defaults to Fail.\n\nPossible enum values:\n - `\"Fail\"` means that an error calling the webhook causes the admission to fail.\n - `\"Ignore\"` means that an error calling the webhook is ignored.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Fail", "Ignore"},
						},
					},
					"auditAnnotations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1alpha1.AuditAnnotation"),
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the policy is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1alpha1.MatchCondition"),
									},
								},
							},
						},
					},
					"variables": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.\n\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1alpha1.Variable"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1alpha1.AuditAnnotation", "k8s.io/api/admissionregistration/v1alpha1.MatchCondition", "k8s.io/api/admissionregistration/v1alpha1.MatchResources", "k8s.io/api/admissionregistration/v1alpha1.ParamKind", "k8s.io/api/admissionregistration/v1alpha1.Validation", "k8s.io/api/admissionregistration/v1alpha1.Variable"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyStatus represents the status of a ValidatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"typeChecking": {
						SchemaProps: spec.SchemaProps{
							Description: "The results of type checking for each expression. Presence of this field indicates the completion of the type checking.",
							Ref:         ref("k8s.io/api/admissionregistration/v1alpha1.TypeChecking"),
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The conditions represent the latest available observations of a policy's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.Condition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1alpha1.TypeChecking", "k8s.io/apimachinery/pkg/apis/meta/v1.Condition"},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_Validation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Validation specifies the CEL expression which is used to apply the validation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nThe `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:\n\t  \"true\", \"false\", \"null\", \"in\", \"as\", \"break\", \"const\", \"continue\", \"else\", \"for\", \"function\", \"if\",\n\t  \"import\", \"let\", \"loop\", \"package\", \"namespace\", \"return\".\nExamples:\n  - Expression accessing a property named \"namespace\": {\"Expression\": \"object.__namespace__ > 0\"}\n  - Expression accessing a property named \"x-prop\": {\"Expression\": \"object.x__dash__prop > 0\"}\n  - Expression accessing a property named \"redact__d\": {\"Expression\": \"object.redact__underscores__d > 0\"}\n\nEquality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:\n  - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and\n    non-intersecting elements in `Y` are appended, retaining their partial order.\n  - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values\n    are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with\n    non-intersecting keys are appended, retaining their partial order.\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is \"failed rule: {Rule}\". e.g. \"must be a URL with the host matching spec.host\" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is \"failed Expression: {Expression}\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: \"Unauthorized\", \"Forbidden\", \"Invalid\", \"RequestEntityTooLarge\". If not set, StatusReasonInvalid is used in the response to the client.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"messageExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: \"object.x must be less than max (\"+string(params.max)+\")\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_Variable(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Variable is the definition of a variable that is used for composition.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is \"foo\", the variable will be available as `variables.foo`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_AuditAnnotation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditAnnotation describes how to produce an audit annotation for an API request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.\n\nThe key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: \"{ValidatingAdmissionPolicy name}/{key}\".\n\nIf an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"valueExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.\n\nIf multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key", "valueExpression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ExpressionWarning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExpressionWarning is a warning information that targets a specific expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is \"spec.validations[0].expression\"",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"warning": {
						SchemaProps: spec.SchemaProps{
							Description: "The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"fieldRef", "warning"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MatchCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchCondition represents a condition which must be fulfilled for a request to be sent to a webhook.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:\n\n'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\nDocumentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MatchResources(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the policy on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.NamedRuleWithOperations"),
									},
								},
							},
						},
					},
					"excludeResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.NamedRuleWithOperations"),
									},
								},
							},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"MatchResources\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.\n\nDefaults to \"Equivalent\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.NamedRuleWithOperations", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhook(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhook describes an admission webhook and the resources and operations it applies to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientConfig defines how to communicate with the hook. Required",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.WebhookClientConfig"),
						},
					},
					"rules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.RuleWithOperations"),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"rules\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.\n\nDefaults to \"Exact\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the webhook on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"sideEffects": {
						SchemaProps: spec.SchemaProps{
							Description: "SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"admissionReviewVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"reinvocationPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation. Allowed values are \"Never\" and \"IfNeeded\".\n\nNever: the webhook will not be called more than once in a single admission evaluation.\n\nIfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.\n\nDefaults to \"Never\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be sent to this webhook. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the webhook is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the webhook is called.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the error is ignored and the webhook is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.MatchCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "clientConfig"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.RuleWithOperations", "k8s.io/api/admissionregistration/v1beta1.MatchCondition", "k8s.io/api/admissionregistration/v1beta1.WebhookClientConfig", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhookConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object. Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 MutatingWebhookConfiguration instead.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"webhooks": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Webhooks is a list of webhooks and the affected resources and operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.MutatingWebhook"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.MutatingWebhook", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhookConfigurationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of MutatingWebhookConfiguration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.MutatingWebhookConfiguration"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.MutatingWebhookConfiguration", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_NamedRuleWithOperations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"operations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"*", "CONNECT", "CREATE", "DELETE", "UPDATE"},
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ParamKind(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamKind is a tuple of Group Kind and Version.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion is the API group version the resources belong to. In format of \"group/version\". Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the API kind the resources belong to. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ParamRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource being referenced.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.\n\nA single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.\n\nA per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.\n\n- If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.\n\n- If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.\n\nIf multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"parameterNotFoundAction": {
						SchemaProps: spec.SchemaProps{
							Description: "`parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.\n\nAllowed values are `Allow` or `Deny`\n\nRequired",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ServiceReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceReference holds a reference to Service.legacy.k8s.io",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "`namespace` is the namespace of the service. Required",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "`name` is the name of the service. Required",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "`path` is an optional URL path which will be sent in any request to this service.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"namespace", "name"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_TypeChecking(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expressionWarnings": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The type checking warnings for each expression.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.ExpressionWarning"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.ExpressionWarning"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicy.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicySpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicySpec", "k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.\n\nFor a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding.\n\nThe CEL expressions of a policy must have a computed CEL cost below the maximum CEL budget. Each evaluation of the policy is given an independent CEL cost budget. Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyBindingSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyBindingSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingList is a list of ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of PolicyBinding.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicyBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBindingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"policyName": {
						SchemaProps: spec.SchemaProps{
							Description: "PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"paramRef": {
						SchemaProps: spec.SchemaProps{
							Description: "paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.",
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.ParamRef"),
						},
					},
					"matchResources": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.",
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.MatchResources"),
						},
					},
					"validationActions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.\n\nFailures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.\n\nvalidationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.\n\nThe supported actions values are:\n\n\"Deny\" specifies that a validation failure results in a denied request.\n\n\"Warn\" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.\n\n\"Audit\" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `\"validation.policy.admission.k8s.io/validation_failure\": \"[{\"message\": \"Invalid value\", {\"policy\": \"policy.example.com\", {\"binding\": \"policybinding.example.com\", {\"expressionIndex\": \"1\", {\"validationActions\": [\"Audit\"]}]\"`\n\nClients should expect to handle additional values by ignoring any values not recognized.\n\n\"Deny\" and \"Warn\" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.\n\nRequired.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"Audit", "Deny", "Warn"},
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.MatchResources", "k8s.io/api/admissionregistration/v1beta1.ParamRef"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyList is a list of ValidatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingAdmissionPolicy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicy"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.ValidatingAdmissionPolicy", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paramKind": {
						SchemaProps: spec.SchemaProps{
							Description: "ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.",
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.ParamKind"),
						},
					},
					"matchConstraints": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.",
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.MatchResources"),
						},
					},
					"validations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.Validation"),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.\n\nA policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.\n\nfailurePolicy does not define how validations that evaluate to false are handled.\n\nWhen failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.\n\nAllowed values are Ignore or Fail. Defaults to Fail.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"auditAnnotations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.AuditAnnotation"),
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the policy is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.MatchCondition"),
									},
								},
							},
						},
					},
					"variables": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.\n\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.Variable"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.AuditAnnotation", "k8s.io/api/admissionregistration/v1beta1.MatchCondition", "k8s.io/api/admissionregistration/v1beta1.MatchResources", "k8s.io/api/admissionregistration/v1beta1.ParamKind", "k8s.io/api/admissionregistration/v1beta1.Validation", "k8s.io/api/admissionregistration/v1beta1.Variable"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyStatus represents the status of an admission validation policy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"typeChecking": {
						SchemaProps: spec.SchemaProps{
							Description: "The results of type checking for each expression. Presence of this field indicates the completion of the type checking.",
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.TypeChecking"),
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The conditions represent the latest available observations of a policy's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.Condition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.TypeChecking", "k8s.io/apimachinery/pkg/apis/meta/v1.Condition"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhook(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhook describes an admission webhook and the resources and operations it applies to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientConfig defines how to communicate with the hook. Required",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.WebhookClientConfig"),
						},
					},
					"rules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1.RuleWithOperations"),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"rules\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.\n\nDefaults to \"Exact\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the webhook on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"sideEffects": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"admissionReviewVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be sent to this webhook. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the webhook is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the webhook is called.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the error is ignored and the webhook is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.MatchCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "clientConfig"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1.RuleWithOperations", "k8s.io/api/admissionregistration/v1beta1.MatchCondition", "k8s.io/api/admissionregistration/v1beta1.WebhookClientConfig", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhookConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it. Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 ValidatingWebhookConfiguration instead.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"webhooks": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Webhooks is a list of webhooks and the affected resources and operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.ValidatingWebhook"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.ValidatingWebhook", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhookConfigurationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingWebhookConfiguration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/admissionregistration/v1beta1.ValidatingWebhookConfiguration"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.ValidatingWebhookConfiguration", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_Validation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Validation specifies the CEL expression which is used to apply the validation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nThe `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:\n\t  \"true\", \"false\", \"null\", \"in\", \"as\", \"break\", \"const\", \"continue\", \"else\", \"for\", \"function\", \"if\",\n\t  \"import\", \"let\", \"loop\", \"package\", \"namespace\", \"return\".\nExamples:\n  - Expression accessing a property named \"namespace\": {\"Expression\": \"object.__namespace__ > 0\"}\n  - Expression accessing a property named \"x-prop\": {\"Expression\": \"object.x__dash__prop > 0\"}\n  - Expression accessing a property named \"redact__d\": {\"Expression\": \"object.redact__underscores__d > 0\"}\n\nEquality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:\n  - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and\n    non-intersecting elements in `Y` are appended, retaining their partial order.\n  - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values\n    are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with\n    non-intersecting keys are appended, retaining their partial order.\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is \"failed rule: {Rule}\". e.g. \"must be a URL with the host matching spec.host\" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is \"failed Expression: {Expression}\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: \"Unauthorized\", \"Forbidden\", \"Invalid\", \"RequestEntityTooLarge\". If not set, StatusReasonInvalid is used in the response to the client.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"messageExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: \"object.x must be less than max (\"+string(params.max)+\")\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_Variable(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Variable is the definition of a variable that is used for composition. A variable is defined as a named expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is \"foo\", the variable will be available as `variables.foo`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_WebhookClientConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WebhookClientConfig contains the information to make a TLS connection with the webhook",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"url": {
						SchemaProps: spec.SchemaProps{
							Description: "`url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.\n\nThe `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.\n\nPlease note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.\n\nThe scheme must be \"https\"; the URL must begin with \"https://\".\n\nA path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.\n\nAttempting to use a user or basic auth e.g. \"user:password@\" is not allowed. Fragments (\"#...\") and query parameters (\"?...\") are not allowed, either.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"service": {
						SchemaProps: spec.SchemaProps{
							Description: "`service` is a reference to the service for this webhook. Either `service` or `url` must be specified.\n\nIf the webhook is running within the cluster, then you should use `service`.",
							Ref:         ref("k8s.io/api/admissionregistration/v1beta1.ServiceReference"),
						},
					},
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "`caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/admissionregistration/v1beta1.ServiceReference"},
	}
}

func schema_k8sio_api_apidiscovery_v2_APIGroupDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupDiscovery holds information about which resources are being served for all version of the API Group. It contains a list of APIVersionDiscovery that holds a list of APIResourceDiscovery types served for a version. Versions are in descending order of preference, with the first version being the preferred entry.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. The only field completed will be name. For instance, resourceVersion will be empty. name is the name of the API group whose discovery information is presented here. name is allowed to be \"\" to represent the legacy, ungroupified resources. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"versions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"version",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "versions are the versions supported in this group. They are sorted in descending order of preference, with the preferred version being the first entry.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apidiscovery/v2.APIVersionDiscovery"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apidiscovery/v2.APIVersionDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apidiscovery_v2_APIGroupDiscoveryList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupDiscoveryList is a resource containing a list of APIGroupDiscovery. This is one of the types able to be returned from the /api and /apis endpoint and contains an aggregated list of API resources (built-ins, Custom Resource Definitions, resources from aggregated servers) that a cluster supports.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceVersion will not be set, because this does not have a replayable ordering among multiple apiservers. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of groups for discovery. The groups are listed in priority order.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apidiscovery/v2.APIGroupDiscovery"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apidiscovery/v2.APIGroupDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apidiscovery_v2_APIResourceDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIResourceDiscovery provides information about an API resource for discovery.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource is the plural name of the resource.  This is used in the URL path and is the unique identifier for this resource across all versions in the API group. Resources with non-empty groups are located at /apis/<APIGroupDiscovery.objectMeta.name>/<APIVersionDiscovery.version>/<APIResourceDiscovery.Resource> Resources with empty groups are located at /api/v1/<APIResourceDiscovery.Resource>",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"responseKind": {
						SchemaProps: spec.SchemaProps{
							Description: "responseKind describes the group, version, and kind of the serialization schema for the object type this endpoint typically returns. APIs may return other objects types at their discretion, such as error conditions, requests for alternate representations, or other operation specific behavior. This value will be null or empty if an APIService reports subresources but supports no operations on the parent resource",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"),
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope indicates the scope of a resource, either Cluster or Namespaced",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"singularResource": {
						SchemaProps: spec.SchemaProps{
							Description: "singularResource is the singular name of the resource.  This allows clients to handle plural and singular opaquely. For many clients the singular form of the resource will be more understandable to users reading messages and should be used when integrating the name of the resource into a sentence. The command line tool kubectl, for example, allows use of the singular resource name in place of plurals. The singular form of a resource should always be an optional element - when in doubt use the canonical resource name.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "verbs is a list of supported API operation types (this includes but is not limited to get, list, watch, create, update, patch, delete, deletecollection, and proxy).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"shortNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "shortNames is a list of suggested short names of the resource.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"categories": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "categories is a list of the grouped resources this resource belongs to (e.g. 'all'). Clients may use this to simplify acting on multiple resource types at once.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"subresources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"subresource",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "subresources is a list of subresources provided by this resource. Subresources are located at /apis/<APIGroupDiscovery.objectMeta.name>/<APIVersionDiscovery.version>/<APIResourceDiscovery.Resource>/name-of-instance/<APIResourceDiscovery.subresources[i].subresource>",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apidiscovery/v2.APISubresourceDiscovery"),
									},
								},
							},
						},
					},
				},
				Required: []string{"resource", "scope", "singularResource", "verbs"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apidiscovery/v2.APISubresourceDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"},
	}
}

func schema_k8sio_api_apidiscovery_v2_APISubresourceDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APISubresourceDiscovery provides information about an API subresource for discovery.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "subresource is the name of the subresource.  This is used in the URL path and is the unique identifier for this resource across all versions.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"responseKind": {
						SchemaProps: spec.SchemaProps{
							Description: "responseKind describes the group, version, and kind of the serialization schema for the object type this endpoint typically returns. Some subresources do not return normal resources, these will have null or empty return types.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"),
						},
					},
					"acceptedTypes": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"group",
									"version",
									"kind",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "acceptedTypes describes the kinds that this endpoint accepts. Subresources may accept the standard content types or define custom negotiation schemes. The list may not be exhaustive for all operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"),
									},
								},
							},
						},
					},
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "verbs is a list of supported API operation types (this includes but is not limited to get, list, watch, create, update, patch, delete, deletecollection, and proxy). Subresources may define custom verbs outside the standard Kubernetes verb set. Clients should expect the behavior of standard verbs to align with Kubernetes interaction conventions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"subresource", "verbs"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"},
	}
}

func schema_k8sio_api_apidiscovery_v2_APIVersionDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIVersionDiscovery holds a list of APIResourceDiscovery types that are served for a particular version within an API Group.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "version is the name of the version within a group version.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"resource",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "resources is a list of APIResourceDiscovery objects for the corresponding group version.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apidiscovery/v2.APIResourceDiscovery"),
									},
								},
							},
						},
					},
					"freshness": {
						SchemaProps: spec.SchemaProps{
							Description: "freshness marks whether a group version's discovery document is up to date. \"Current\" indicates the discovery document was recently refreshed. \"Stale\" indicates the discovery document could not be retrieved and the returned discovery document may be significantly out of date. Clients that require the latest version of the discovery information be retrieved before performing an operation should not use the aggregated document",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apidiscovery/v2.APIResourceDiscovery"},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APIGroupDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupDiscovery holds information about which resources are being served for all version of the API Group. It contains a list of APIVersionDiscovery that holds a list of APIResourceDiscovery types served for a version. Versions are in descending order of preference, with the first version being the preferred entry.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. The only field completed will be name. For instance, resourceVersion will be empty. name is the name of the API group whose discovery information is presented here. name is allowed to be \"\" to represent the legacy, ungroupified resources. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"versions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"version",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "versions are the versions supported in this group. They are sorted in descending order of preference, with the preferred version being the first entry.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apidiscovery/v2beta1.APIVersionDiscovery"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apidiscovery/v2beta1.APIVersionDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APIGroupDiscoveryList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupDiscoveryList is a resource containing a list of APIGroupDiscovery. This is one of the types able to be returned from the /api and /apis endpoint and contains an aggregated list of API resources (built-ins, Custom Resource Definitions, resources from aggregated servers) that a cluster supports.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceVersion will not be set, because this does not have a replayable ordering among multiple apiservers. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of groups for discovery. The groups are listed in priority order.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apidiscovery/v2beta1.APIGroupDiscovery"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apidiscovery/v2beta1.APIGroupDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APIResourceDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIResourceDiscovery provides information about an API resource for discovery.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource is the plural name of the resource.  This is used in the URL path and is the unique identifier for this resource across all versions in the API group. Resources with non-empty groups are located at /apis/<APIGroupDiscovery.objectMeta.name>/<APIVersionDiscovery.version>/<APIResourceDiscovery.Resource> Resources with empty groups are located at /api/v1/<APIResourceDiscovery.Resource>",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"responseKind": {
						SchemaProps: spec.SchemaProps{
							Description: "responseKind describes the group, version, and kind of the serialization schema for the object type this endpoint typically returns. APIs may return other objects types at their discretion, such as error conditions, requests for alternate representations, or other operation specific behavior. This value will be null or empty if an APIService reports subresources but supports no operations on the parent resource",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"),
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope indicates the scope of a resource, either Cluster or Namespaced",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"singularResource": {
						SchemaProps: spec.SchemaProps{
							Description: "singularResource is the singular name of the resource.  This allows clients to handle plural and singular opaquely. For many clients the singular form of the resource will be more understandable to users reading messages and should be used when integrating the name of the resource into a sentence. The command line tool kubectl, for example, allows use of the singular resource name in place of plurals. The singular form of a resource should always be an optional element - when in doubt use the canonical resource name.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "verbs is a list of supported API operation types (this includes but is not limited to get, list, watch, create, update, patch, delete, deletecollection, and proxy).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"shortNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "shortNames is a list of suggested short names of the resource.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"categories": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "categories is a list of the grouped resources this resource belongs to (e.g. 'all'). Clients may use this to simplify acting on multiple resource types at once.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"subresources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"subresource",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "subresources is a list of subresources provided by this resource. Subresources are located at /apis/<APIGroupDiscovery.objectMeta.name>/<APIVersionDiscovery.version>/<APIResourceDiscovery.Resource>/name-of-instance/<APIResourceDiscovery.subresources[i].subresource>",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apidiscovery/v2beta1.APISubresourceDiscovery"),
									},
								},
							},
						},
					},
				},
				Required: []string{"resource", "scope", "singularResource", "verbs"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apidiscovery/v2beta1.APISubresourceDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APISubresourceDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APISubresourceDiscovery provides information about an API subresource for discovery.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "subresource is the name of the subresource.  This is used in the URL path and is the unique identifier for this resource across all versions.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"responseKind": {
						SchemaProps: spec.SchemaProps{
							Description: "responseKind describes the group, version, and kind of the serialization schema for the object type this endpoint typically returns. Some subresources do not return normal resources, these will have null or empty return types.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"),
						},
					},
					"acceptedTypes": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"group",
									"version",
									"kind",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "acceptedTypes describes the kinds that this endpoint accepts. Subresources may accept the standard content types or define custom negotiation schemes. The list may not be exhaustive for all operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"),
									},
								},
							},
						},
					},
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "verbs is a list of supported API operation types (this includes but is not limited to get, list, watch, create, update, patch, delete, deletecollection, and proxy). Subresources may define custom verbs outside the standard Kubernetes verb set. Clients should expect the behavior of standard verbs to align with Kubernetes interaction conventions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"subresource", "verbs"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind"},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APIVersionDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIVersionDiscovery holds a list of APIResourceDiscovery types that are served for a particular version within an API Group.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "version is the name of the version within a group version.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"resource",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "resources is a list of APIResourceDiscovery objects for the corresponding group version.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apidiscovery/v2beta1.APIResourceDiscovery"),
									},
								},
							},
						},
					},
					"freshness": {
						SchemaProps: spec.SchemaProps{
							Description: "freshness marks whether a group version's discovery document is up to date. \"Current\" indicates the discovery document was recently refreshed. \"Stale\" indicates the discovery document could not be retrieved and the returned discovery document may be significantly out of date. Clients that require the latest version of the discovery information be retrieved before performing an operation should not use the aggregated document",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apidiscovery/v2beta1.APIResourceDiscovery"},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_ServerStorageVersion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An API server instance reports the version it can decode and the version it encodes objects to when persisting objects in the backend.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiServerID": {
						SchemaProps: spec.SchemaProps{
							Description: "The ID of the reporting API server.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"encodingVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "The API server encodes the object to this version when persisting it in the backend (e.g., etcd).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"decodableVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The API server can decode objects encoded in these versions. The encodingVersion must be included in the decodableVersions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"servedVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The API server can serve these versions. DecodableVersions must include all ServedVersions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Storage version of a specific resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "The name is <group>.<resource>.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is an empty spec. It is here to comply with Kubernetes API style.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apiserverinternal/v1alpha1.StorageVersionSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "API server instances report the version they can decode and the version they encode objects to when persisting objects in the backend.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apiserverinternal/v1alpha1.StorageVersionStatus"),
						},
					},
				},
				Required: []string{"spec", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apiserverinternal/v1alpha1.StorageVersionSpec", "k8s.io/api/apiserverinternal/v1alpha1.StorageVersionStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes the state of the storageVersion at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of the condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, this represents the .metadata.generation that the condition was set based upon.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status", "reason", "message"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A list of StorageVersions.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items holds a list of StorageVersion",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apiserverinternal/v1alpha1.StorageVersion"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apiserverinternal/v1alpha1.StorageVersion", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StorageVersionSpec is an empty spec.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "API server instances report the versions they can decode and the version they encode objects to when persisting objects in the backend.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"storageVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"apiServerID",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The reported versions per API server instance.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apiserverinternal/v1alpha1.ServerStorageVersion"),
									},
								},
							},
						},
					},
					"commonEncodingVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "If all API server instances agree on the same encoding storage version, then this field is set to that version. Otherwise this field is left empty. API servers should finish updating its storageVersionStatus entry before serving write operations, so that this field will be in sync with the reality.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The latest available observations of the storageVersion's state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apiserverinternal/v1alpha1.StorageVersionCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apiserverinternal/v1alpha1.ServerStorageVersion", "k8s.io/api/apiserverinternal/v1alpha1.StorageVersionCondition"},
	}
}

func schema_k8sio_api_apps_v1_ControllerRevision(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data is the serialized representation of the state.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "Revision indicates the revision of the state represented by Data.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"revision"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_k8sio_api_apps_v1_ControllerRevisionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRevisionList is a resource containing a list of ControllerRevision objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerRevisions",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1.ControllerRevision"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.ControllerRevision", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1_DaemonSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSet represents the configuration of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.DaemonSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.DaemonSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.DaemonSetSpec", "k8s.io/api/apps/v1.DaemonSetStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetCondition describes the state of a DaemonSet at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of DaemonSet condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetList is a collection of daemon sets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of daemon sets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1.DaemonSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.DaemonSet", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetSpec is the specification of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is \"Always\". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "An update strategy to replace existing DaemonSet pods with new pods.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.DaemonSetUpdateStrategy"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.DaemonSetUpdateStrategy", "k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetStatus represents the current status of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"currentNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberMisscheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberReady": {
						SchemaProps: spec.SchemaProps{
							Description: "numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The most recent generation observed by the daemon set controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"updatedNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The total number of nodes that are running updated daemon pod",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a DaemonSet's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1.DaemonSetCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"currentNumberScheduled", "numberMisscheduled", "desiredNumberScheduled", "numberReady"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.DaemonSetCondition"},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of daemon set update. Can be \"RollingUpdate\" or \"OnDelete\". Default is RollingUpdate.\n\nPossible enum values:\n - `\"OnDelete\"` Replace the old daemons only when it's killed\n - `\"RollingUpdate\"` Replace the old daemons by new ones using rolling update i.e replace them on each node one after the other.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"OnDelete", "RollingUpdate"},
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if type = \"RollingUpdate\".",
							Ref:         ref("k8s.io/api/apps/v1.RollingUpdateDaemonSet"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.RollingUpdateDaemonSet"},
	}
}

func schema_k8sio_api_apps_v1_Deployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Deployment enables declarative updates for Pods and ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.DeploymentSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.DeploymentStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.DeploymentSpec", "k8s.io/api/apps/v1.DeploymentStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1_DeploymentCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentCondition describes the state of a deployment at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1_DeploymentList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentList is a list of Deployments.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Deployments.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1.Deployment"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.Deployment", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1_DeploymentSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentSpec is the specification of the desired behavior of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
					"strategy": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-strategy": "retainKeys",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing pods with new ones.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.DeploymentStrategy"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the deployment is paused.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"progressDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.DeploymentStrategy", "k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1_DeploymentStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStatus is the most recently observed status of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the deployment controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated pods targeted by this deployment (their labels match the selector).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated pods targeted by this deployment that have the desired template spec.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods targeted by this Deployment with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unavailableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a deployment's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1.DeploymentCondition"),
									},
								},
							},
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.DeploymentCondition"},
	}
}

func schema_k8sio_api_apps_v1_DeploymentStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStrategy describes how to replace existing pods with new ones.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment. Can be \"Recreate\" or \"RollingUpdate\". Default is RollingUpdate.\n\nPossible enum values:\n - `\"Recreate\"` Kill all existing pods before creating new ones.\n - `\"RollingUpdate\"` Replace the old ReplicaSets by new one using rolling update i.e gradually scale down the old ReplicaSets and scale up the new one.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Recreate", "RollingUpdate"},
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.",
							Ref:         ref("k8s.io/api/apps/v1.RollingUpdateDeployment"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.RollingUpdateDeployment"},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSet ensures that a specified number of pod replicas are running at any given time.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.ReplicaSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.ReplicaSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.ReplicaSetSpec", "k8s.io/api/apps/v1.ReplicaSetStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetCondition describes the state of a replica set at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of replica set condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetList is a collection of ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ReplicaSets. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1.ReplicaSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.ReplicaSet", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetSpec is the specification of a ReplicaSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
				},
				Required: []string{"selector"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetStatus represents the current status of a ReplicaSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the most recently observed number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fullyLabeledReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pods that have labels matching the labels of the pod template of the replicaset.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of available replicas (ready for at least minReadySeconds) for this replica set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration reflects the generation of the most recently observed ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a replica set's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1.ReplicaSetCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.ReplicaSetCondition"},
	}
}

func schema_k8sio_api_apps_v1_RollingUpdateDaemonSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of daemon set rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_k8sio_api_apps_v1_RollingUpdateDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_k8sio_api_apps_v1_RollingUpdateStatefulSetStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_k8sio_api_apps_v1_StatefulSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSet represents a set of pods with consistent identities. Identities are defined as:\n  - Network: A single stable DNS and hostname.\n  - Storage: As many VolumeClaims as requested.\n\nThe StatefulSet guarantees that a given network identity will always map to the same storage identity.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired identities of pods in this set.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.StatefulSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.StatefulSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.StatefulSetSpec", "k8s.io/api/apps/v1.StatefulSetStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetCondition describes the state of a statefulset at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of statefulset condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetList is a collection of StatefulSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of stateful sets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1.StatefulSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.StatefulSet", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetOrdinals(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"start": {
						SchemaProps: spec.SchemaProps{
							Description: "start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:\n  [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).\nIf unset, defaults to 0. Replica indices will be in the range:\n  [0, .spec.replicas).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetPersistentVolumeClaimRetentionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"whenDeleted": {
						SchemaProps: spec.SchemaProps{
							Description: "WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"whenScaled": {
						SchemaProps: spec.SchemaProps{
							Description: "WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A StatefulSetSpec is the specification of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named \"web\" with index number \"3\" would be named \"web-3\". The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
					"volumeClaimTemplates": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/core/v1.PersistentVolumeClaim"),
									},
								},
							},
						},
					},
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podManagementPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.\n\nPossible enum values:\n - `\"OrderedReady\"` will create pods in strictly increasing order on scale up and strictly decreasing order on scale down, progressing only when the previous pod is ready or terminated. At most one pod will be changed at any time.\n - `\"Parallel\"` will create and delete pods as soon as the stateful set replica count is changed, and will not wait for pods to be ready or complete termination.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"OrderedReady", "Parallel"},
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1.StatefulSetUpdateStrategy"),
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"persistentVolumeClaimRetentionPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down. This requires the StatefulSetAutoDeletePVC feature gate to be enabled, which is beta.",
							Ref:         ref("k8s.io/api/apps/v1.StatefulSetPersistentVolumeClaimRetentionPolicy"),
						},
					},
					"ordinals": {
						SchemaProps: spec.SchemaProps{
							Description: "ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a \"0\" index to the first replica and increments the index by one for each additional replica requested.",
							Ref:         ref("k8s.io/api/apps/v1.StatefulSetOrdinals"),
						},
					},
				},
				Required: []string{"selector", "template", "serviceName"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.StatefulSetOrdinals", "k8s.io/api/apps/v1.StatefulSetPersistentVolumeClaimRetentionPolicy", "k8s.io/api/apps/v1.StatefulSetUpdateStrategy", "k8s.io/api/core/v1.PersistentVolumeClaim", "k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetStatus represents the current state of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of Pods created by the StatefulSet controller.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a statefulset's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1.StatefulSetCondition"),
									},
								},
							},
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.StatefulSetCondition"},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.\n\nPossible enum values:\n - `\"OnDelete\"` triggers the legacy behavior. Version tracking and ordered rolling restarts are disabled. Pods are recreated from the StatefulSetSpec when they are manually deleted. When a scale operation is performed with this strategy,specification version indicated by the StatefulSet's currentRevision.\n - `\"RollingUpdate\"` indicates that update will be applied to all Pods in the StatefulSet with respect to the StatefulSet ordering constraints. When a scale operation is performed with this strategy, new Pods will be created from the specification version indicated by the StatefulSet's updateRevision.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"OnDelete", "RollingUpdate"},
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.",
							Ref:         ref("k8s.io/api/apps/v1.RollingUpdateStatefulSetStrategy"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1.RollingUpdateStatefulSetStrategy"},
	}
}

func schema_k8sio_api_apps_v1beta1_ControllerRevision(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision. See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "data is the serialized representation of the state.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "revision indicates the revision of the state represented by Data.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"revision"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_k8sio_api_apps_v1beta1_ControllerRevisionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRevisionList is a resource containing a list of ControllerRevision objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerRevisions",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta1.ControllerRevision"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.ControllerRevision", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1beta1_Deployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment. See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta1.DeploymentSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta1.DeploymentStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.DeploymentSpec", "k8s.io/api/apps/v1beta1.DeploymentStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentCondition describes the state of a deployment at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentList is a list of Deployments.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Deployments.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta1.Deployment"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.Deployment", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentRollback(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED. DeploymentRollback stores the information required to rollback a deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: This must match the Name of a deployment.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updatedAnnotations": {
						SchemaProps: spec.SchemaProps{
							Description: "The annotations to be updated to a deployment",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"rollbackTo": {
						SchemaProps: spec.SchemaProps{
							Description: "The config of this deployment rollback.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta1.RollbackConfig"),
						},
					},
				},
				Required: []string{"name", "rollbackTo"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.RollbackConfig"},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentSpec is the specification of the desired behavior of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
					"strategy": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-strategy": "retainKeys",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing pods with new ones.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta1.DeploymentStrategy"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "minReadySeconds is the minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "revisionHistoryLimit is the number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 2.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "paused indicates that the deployment is paused.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"rollbackTo": {
						SchemaProps: spec.SchemaProps{
							Description: "DEPRECATED. rollbackTo is the config this deployment is rolling back to. Will be cleared after rollback is done.",
							Ref:         ref("k8s.io/api/apps/v1beta1.RollbackConfig"),
						},
					},
					"progressDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "progressDeadlineSeconds is the maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.DeploymentStrategy", "k8s.io/api/apps/v1beta1.RollbackConfig", "k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStatus is the most recently observed status of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the generation observed by the deployment controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the total number of non-terminated pods targeted by this deployment (their labels match the selector).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "updatedReplicas is the total number of non-terminated pods targeted by this deployment that have the desired template spec.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unavailableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "unavailableReplicas is the total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represent the latest available observations of a deployment's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta1.DeploymentCondition"),
									},
								},
							},
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "collisionCount is the count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.DeploymentCondition"},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStrategy describes how to replace existing pods with new ones.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment. Can be \"Recreate\" or \"RollingUpdate\". Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.",
							Ref:         ref("k8s.io/api/apps/v1beta1.RollingUpdateDeployment"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.RollingUpdateDeployment"},
	}
}

func schema_k8sio_api_apps_v1beta1_RollbackConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "The revision to rollback to. If set to 0, rollback to the last revision.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_RollingUpdateDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_k8sio_api_apps_v1beta1_RollingUpdateStatefulSetStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "maxUnavailable is the maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_k8sio_api_apps_v1beta1_Scale(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Scale represents a scaling request for a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta1.ScaleSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status defines current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta1.ScaleStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.ScaleSpec", "k8s.io/api/apps/v1beta1.ScaleStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1beta1_ScaleSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleSpec describes the attributes of a scale subresource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of observed instances of the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_ScaleStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleStatus represents the current status of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replias is the actual number of observed instances of the scaled object.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"targetSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "targetSelector is the label selector for pods that should match the replicas count. This is a serializated version of both map-based and more expressive set-based selectors. This is done to avoid introspection in the clients. The string will be in the same format as the query-param syntax. If the target type only supports map-based selectors, both this field and map-based selector field are populated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of StatefulSet is deprecated by apps/v1beta2/StatefulSet. See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:\n  - Network: A single stable DNS and hostname.\n  - Storage: As many VolumeClaims as requested.\n\nThe StatefulSet guarantees that a given network identity will always map to the same storage identity.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired identities of pods in this set.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta1.StatefulSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta1.StatefulSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.StatefulSetSpec", "k8s.io/api/apps/v1beta1.StatefulSetStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetCondition describes the state of a statefulset at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of statefulset condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetList is a collection of StatefulSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta1.StatefulSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.StatefulSet", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetOrdinals(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"start": {
						SchemaProps: spec.SchemaProps{
							Description: "start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:\n  [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).\nIf unset, defaults to 0. Replica indices will be in the range:\n  [0, .spec.replicas).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetPersistentVolumeClaimRetentionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"whenDeleted": {
						SchemaProps: spec.SchemaProps{
							Description: "whenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"whenScaled": {
						SchemaProps: spec.SchemaProps{
							Description: "whenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A StatefulSetSpec is the specification of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replica count. If empty, defaulted to labels on the pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named \"web\" with index number \"3\" would be named \"web-3\".",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
					"volumeClaimTemplates": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/core/v1.PersistentVolumeClaim"),
									},
								},
							},
						},
					},
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podManagementPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta1.StatefulSetUpdateStrategy"),
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "minReadySeconds is the minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"persistentVolumeClaimRetentionPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "PersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates. This requires the StatefulSetAutoDeletePVC feature gate to be enabled, which is alpha.",
							Ref:         ref("k8s.io/api/apps/v1beta1.StatefulSetPersistentVolumeClaimRetentionPolicy"),
						},
					},
					"ordinals": {
						SchemaProps: spec.SchemaProps{
							Description: "ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a \"0\" index to the first replica and increments the index by one for each additional replica requested.",
							Ref:         ref("k8s.io/api/apps/v1beta1.StatefulSetOrdinals"),
						},
					},
				},
				Required: []string{"template", "serviceName"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.StatefulSetOrdinals", "k8s.io/api/apps/v1beta1.StatefulSetPersistentVolumeClaimRetentionPolicy", "k8s.io/api/apps/v1beta1.StatefulSetUpdateStrategy", "k8s.io/api/core/v1.PersistentVolumeClaim", "k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetStatus represents the current state of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of Pods created by the StatefulSet controller.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods created by this StatefulSet controller with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "conditions represent the latest available observations of a statefulset's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta1.StatefulSetCondition"),
									},
								},
							},
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "availableReplicas is the total number of available pods (ready for at least minReadySeconds) targeted by this StatefulSet.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.StatefulSetCondition"},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type indicates the type of the StatefulSetUpdateStrategy.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.",
							Ref:         ref("k8s.io/api/apps/v1beta1.RollingUpdateStatefulSetStrategy"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta1.RollingUpdateStatefulSetStrategy"},
	}
}

func schema_k8sio_api_apps_v1beta2_ControllerRevision(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1/ControllerRevision. See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data is the serialized representation of the state.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "Revision indicates the revision of the state represented by Data.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"revision"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_k8sio_api_apps_v1beta2_ControllerRevisionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRevisionList is a resource containing a list of ControllerRevision objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerRevisions",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta2.ControllerRevision"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.ControllerRevision", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of DaemonSet is deprecated by apps/v1/DaemonSet. See the release notes for more information. DaemonSet represents the configuration of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.DaemonSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.DaemonSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.DaemonSetSpec", "k8s.io/api/apps/v1beta2.DaemonSetStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetCondition describes the state of a DaemonSet at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of DaemonSet condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetList is a collection of daemon sets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of daemon sets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta2.DaemonSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.DaemonSet", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetSpec is the specification of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is \"Always\". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "An update strategy to replace existing DaemonSet pods with new pods.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.DaemonSetUpdateStrategy"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.DaemonSetUpdateStrategy", "k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetStatus represents the current status of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"currentNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberMisscheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberReady": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition by passing the readinessProbe.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The most recent generation observed by the daemon set controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"updatedNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The total number of nodes that are running updated daemon pod",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a DaemonSet's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta2.DaemonSetCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"currentNumberScheduled", "numberMisscheduled", "desiredNumberScheduled", "numberReady"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.DaemonSetCondition"},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of daemon set update. Can be \"RollingUpdate\" or \"OnDelete\". Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if type = \"RollingUpdate\".",
							Ref:         ref("k8s.io/api/apps/v1beta2.RollingUpdateDaemonSet"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.RollingUpdateDaemonSet"},
	}
}

func schema_k8sio_api_apps_v1beta2_Deployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of Deployment is deprecated by apps/v1/Deployment. See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.DeploymentSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.DeploymentStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.DeploymentSpec", "k8s.io/api/apps/v1beta2.DeploymentStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentCondition describes the state of a deployment at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentList is a list of Deployments.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Deployments.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta2.Deployment"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.Deployment", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentSpec is the specification of the desired behavior of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
					"strategy": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-strategy": "retainKeys",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing pods with new ones.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.DeploymentStrategy"),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the deployment is paused.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"progressDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.DeploymentStrategy", "k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStatus is the most recently observed status of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the deployment controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated pods targeted by this deployment (their labels match the selector).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminated pods targeted by this deployment that have the desired template spec.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unavailableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a deployment's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta2.DeploymentCondition"),
									},
								},
							},
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.DeploymentCondition"},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStrategy describes how to replace existing pods with new ones.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment. Can be \"Recreate\" or \"RollingUpdate\". Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.",
							Ref:         ref("k8s.io/api/apps/v1beta2.RollingUpdateDeployment"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.RollingUpdateDeployment"},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1/ReplicaSet. See the release notes for more information. ReplicaSet ensures that a specified number of pod replicas are running at any given time.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.ReplicaSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.ReplicaSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.ReplicaSetSpec", "k8s.io/api/apps/v1beta2.ReplicaSetStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetCondition describes the state of a replica set at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of replica set condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetList is a collection of ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ReplicaSets. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta2.ReplicaSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.ReplicaSet", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetSpec is the specification of a ReplicaSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
				},
				Required: []string{"selector"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetStatus represents the current status of a ReplicaSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the most recently observed number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fullyLabeledReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pods that have labels matching the labels of the pod template of the replicaset.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods targeted by this ReplicaSet controller with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of available replicas (ready for at least minReadySeconds) for this replica set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration reflects the generation of the most recently observed ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a replica set's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta2.ReplicaSetCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.ReplicaSetCondition"},
	}
}

func schema_k8sio_api_apps_v1beta2_RollingUpdateDaemonSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of daemon set rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_k8sio_api_apps_v1beta2_RollingUpdateDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_k8sio_api_apps_v1beta2_RollingUpdateStatefulSetStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_k8sio_api_apps_v1beta2_Scale(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Scale represents a scaling request for a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.ScaleSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.ScaleStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.ScaleSpec", "k8s.io/api/apps/v1beta2.ScaleStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_ScaleSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleSpec describes the attributes of a scale subresource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of instances for the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta2_ScaleStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleStatus represents the current status of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "actual number of observed instances of the scaled object.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-map-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"targetSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "label selector for pods that should match the replicas count. This is a serializated version of both map-based and more expressive set-based selectors. This is done to avoid introspection in the clients. The string will be in the same format as the query-param syntax. If the target type only supports map-based selectors, both this field and map-based selector field are populated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of StatefulSet is deprecated by apps/v1/StatefulSet. See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:\n  - Network: A single stable DNS and hostname.\n  - Storage: As many VolumeClaims as requested.\n\nThe StatefulSet guarantees that a given network identity will always map to the same storage identity.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired identities of pods in this set.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.StatefulSetSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.StatefulSetStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.StatefulSetSpec", "k8s.io/api/apps/v1beta2.StatefulSetStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetCondition describes the state of a statefulset at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of statefulset condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetList is a collection of StatefulSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta2.StatefulSet"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.StatefulSet", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetOrdinals(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"start": {
						SchemaProps: spec.SchemaProps{
							Description: "start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:\n  [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).\nIf unset, defaults to 0. Replica indices will be in the range:\n  [0, .spec.replicas).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetPersistentVolumeClaimRetentionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"whenDeleted": {
						SchemaProps: spec.SchemaProps{
							Description: "WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"whenScaled": {
						SchemaProps: spec.SchemaProps{
							Description: "WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A StatefulSetSpec is the specification of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named \"web\" with index number \"3\" would be named \"web-3\". The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
					"volumeClaimTemplates": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/core/v1.PersistentVolumeClaim"),
									},
								},
							},
						},
					},
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podManagementPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/apps/v1beta2.StatefulSetUpdateStrategy"),
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"persistentVolumeClaimRetentionPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "PersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates. This requires the StatefulSetAutoDeletePVC feature gate to be enabled, which is alpha.",
							Ref:         ref("k8s.io/api/apps/v1beta2.StatefulSetPersistentVolumeClaimRetentionPolicy"),
						},
					},
					"ordinals": {
						SchemaProps: spec.SchemaProps{
							Description: "ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a \"0\" index to the first replica and increments the index by one for each additional replica requested.",
							Ref:         ref("k8s.io/api/apps/v1beta2.StatefulSetOrdinals"),
						},
					},
				},
				Required: []string{"selector", "template", "serviceName"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.StatefulSetOrdinals", "k8s.io/api/apps/v1beta2.StatefulSetPersistentVolumeClaimRetentionPolicy", "k8s.io/api/apps/v1beta2.StatefulSetUpdateStrategy", "k8s.io/api/core/v1.PersistentVolumeClaim", "k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetStatus represents the current state of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of Pods created by the StatefulSet controller.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods created by this StatefulSet controller with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a statefulset's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/apps/v1beta2.StatefulSetCondition"),
									},
								},
							},
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this StatefulSet.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.StatefulSetCondition"},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.",
							Ref:         ref("k8s.io/api/apps/v1beta2.RollingUpdateStatefulSetStrategy"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/apps/v1beta2.RollingUpdateStatefulSetStrategy"},
	}
}

func schema_k8sio_api_authentication_v1_BoundObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BoundObjectReference is a reference to an object that a token is bound to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent. Valid kinds are 'Pod' and 'Secret'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID of the referent.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authentication_v1_SelfSubjectReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReview contains the user information that the kube-apiserver has about the user making this request. When using impersonation, users will receive the user info of the user being impersonated.  If impersonation or request header authentication is used, any extra keys will have their case ignored and returned as lowercase.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server with the user attributes.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1.SelfSubjectReviewStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1.SelfSubjectReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authentication_v1_SelfSubjectReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReviewStatus is filled by the kube-apiserver and sent back to a user.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"userInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "User attributes of the user making this request.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1.UserInfo"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1.UserInfo"},
	}
}

func schema_k8sio_api_authentication_v1_TokenRequest(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenRequest requests a token for a given service account.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1.TokenRequestSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the token can be authenticated.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1.TokenRequestStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1.TokenRequestSpec", "k8s.io/api/authentication/v1.TokenRequestStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authentication_v1_TokenRequestSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenRequestSpec contains client provided parameters of a token request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences are the intendend audiences of the token. A recipient of a token must identify themself with an identifier in the list of audiences of the token, and otherwise should reject the token. A token issued for multiple audiences may be used to authenticate against any of the audiences listed but implies a high degree of trust between the target audiences.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"expirationSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "ExpirationSeconds is the requested duration of validity of the request. The token issuer may return a token with a different validity duration so a client needs to check the 'expiration' field in a response.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"boundObjectRef": {
						SchemaProps: spec.SchemaProps{
							Description: "BoundObjectRef is a reference to an object that the token will be bound to. The token will only be valid for as long as the bound object exists. NOTE: The API server's TokenReview endpoint will validate the BoundObjectRef, but other audiences may not. Keep ExpirationSeconds small if you want prompt revocation.",
							Ref:         ref("k8s.io/api/authentication/v1.BoundObjectReference"),
						},
					},
				},
				Required: []string{"audiences"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1.BoundObjectReference"},
	}
}

func schema_k8sio_api_authentication_v1_TokenRequestStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenRequestStatus is the result of a token request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"token": {
						SchemaProps: spec.SchemaProps{
							Description: "Token is the opaque bearer token.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expirationTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "ExpirationTimestamp is the time of expiration of the returned token.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
				Required: []string{"token", "expirationTimestamp"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_authentication_v1_TokenReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1.TokenReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request can be authenticated.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1.TokenReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1.TokenReviewSpec", "k8s.io/api/authentication/v1.TokenReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authentication_v1_TokenReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewSpec is a description of the token authentication request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"token": {
						SchemaProps: spec.SchemaProps{
							Description: "Token is the opaque bearer token.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences is a list of the identifiers that the resource server presented with the token identifies as. Audience-aware token authenticators will verify that the token was intended for at least one of the audiences in this list. If no audiences are provided, the audience will default to the audience of the Kubernetes apiserver.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authentication_v1_TokenReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewStatus is the result of the token authentication request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"authenticated": {
						SchemaProps: spec.SchemaProps{
							Description: "Authenticated indicates that the token was associated with a known user.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the UserInfo associated with the provided token.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1.UserInfo"),
						},
					},
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences are audience identifiers chosen by the authenticator that are compatible with both the TokenReview and token. An identifier is any identifier in the intersection of the TokenReviewSpec audiences and the token's audiences. A client of the TokenReview API that sets the spec.audiences field should validate that a compatible audience identifier is returned in the status.audiences field to ensure that the TokenReview server is audience aware. If a TokenReview returns an empty status.audience field where status.authenticated is \"true\", the token is valid against the audience of the Kubernetes API server.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error indicates that the token couldn't be checked",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1.UserInfo"},
	}
}

func schema_k8sio_api_authentication_v1_UserInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UserInfo holds the information about the user needed to implement the user.Info interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"username": {
						SchemaProps: spec.SchemaProps{
							Description: "The name that uniquely identifies this user among all active users.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "A unique value that identifies this user across time. If this user is deleted and another user by the same name is added, they will have different UIDs.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The names of groups this user is a part of.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Any additional information provided by the authenticator.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Default: "",
													Type:    []string{"string"},
													Format:  "",
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authentication_v1alpha1_SelfSubjectReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReview contains the user information that the kube-apiserver has about the user making this request. When using impersonation, users will receive the user info of the user being impersonated.  If impersonation or request header authentication is used, any extra keys will have their case ignored and returned as lowercase.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server with the user attributes.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1alpha1.SelfSubjectReviewStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1alpha1.SelfSubjectReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authentication_v1alpha1_SelfSubjectReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReviewStatus is filled by the kube-apiserver and sent back to a user.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"userInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "User attributes of the user making this request.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1.UserInfo"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1.UserInfo"},
	}
}

func schema_k8sio_api_authentication_v1beta1_SelfSubjectReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReview contains the user information that the kube-apiserver has about the user making this request. When using impersonation, users will receive the user info of the user being impersonated.  If impersonation or request header authentication is used, any extra keys will have their case ignored and returned as lowercase.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server with the user attributes.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1beta1.SelfSubjectReviewStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1beta1.SelfSubjectReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authentication_v1beta1_SelfSubjectReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReviewStatus is filled by the kube-apiserver and sent back to a user.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"userInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "User attributes of the user making this request.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1.UserInfo"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1.UserInfo"},
	}
}

func schema_k8sio_api_authentication_v1beta1_TokenReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1beta1.TokenReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the token can be authenticated.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1beta1.TokenReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1beta1.TokenReviewSpec", "k8s.io/api/authentication/v1beta1.TokenReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authentication_v1beta1_TokenReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewSpec is a description of the token authentication request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"token": {
						SchemaProps: spec.SchemaProps{
							Description: "Token is the opaque bearer token.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences is a list of the identifiers that the resource server presented with the token identifies as. Audience-aware token authenticators will verify that the token was intended for at least one of the audiences in this list. If no audiences are provided, the audience will default to the audience of the Kubernetes apiserver.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authentication_v1beta1_TokenReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewStatus is the result of the token authentication request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"authenticated": {
						SchemaProps: spec.SchemaProps{
							Description: "Authenticated indicates that the token was associated with a known user.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the UserInfo associated with the provided token.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authentication/v1beta1.UserInfo"),
						},
					},
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences are audience identifiers chosen by the authenticator that are compatible with both the TokenReview and token. An identifier is any identifier in the intersection of the TokenReviewSpec audiences and the token's audiences. A client of the TokenReview API that sets the spec.audiences field should validate that a compatible audience identifier is returned in the status.audiences field to ensure that the TokenReview server is audience aware. If a TokenReview returns an empty status.audience field where status.authenticated is \"true\", the token is valid against the audience of the Kubernetes API server.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error indicates that the token couldn't be checked",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authentication/v1beta1.UserInfo"},
	}
}

func schema_k8sio_api_authentication_v1beta1_UserInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UserInfo holds the information about the user needed to implement the user.Info interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"username": {
						SchemaProps: spec.SchemaProps{
							Description: "The name that uniquely identifies this user among all active users.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "A unique value that identifies this user across time. If this user is deleted and another user by the same name is added, they will have different UIDs.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The names of groups this user is a part of.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Any additional information provided by the authenticator.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Default: "",
													Type:    []string{"string"},
													Format:  "",
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_FieldSelectorAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FieldSelectorAttributes indicates a field limited access. Webhook authors are encouraged to * ensure rawSelector and requirements are not both set * consider the requirements field if set * not try to parse or consider the rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting different systems to agree on how exactly to parse a query is not something we want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack for more details. For the *SubjectAccessReview endpoints of the kube-apiserver: * If rawSelector is empty and requirements are empty, the request is not limited. * If rawSelector is present and requirements are empty, the rawSelector will be parsed and limited if the parsing succeeds. * If rawSelector is empty and requirements are present, the requirements should be honored * If rawSelector is present and requirements are present, the request is invalid.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"rawSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"requirements": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "requirements is the parsed interpretation of a field selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.FieldSelectorRequirement"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.FieldSelectorRequirement"},
	}
}

func schema_k8sio_api_authorization_v1_LabelSelectorAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LabelSelectorAttributes indicates a label limited access. Webhook authors are encouraged to * ensure rawSelector and requirements are not both set * consider the requirements field if set * not try to parse or consider the rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting different systems to agree on how exactly to parse a query is not something we want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack for more details. For the *SubjectAccessReview endpoints of the kube-apiserver: * If rawSelector is empty and requirements are empty, the request is not limited. * If rawSelector is present and requirements are empty, the rawSelector will be parsed and limited if the parsing succeeds. * If rawSelector is empty and requirements are present, the requirements should be honored * If rawSelector is present and requirements are present, the request is invalid.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"rawSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"requirements": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "requirements is the parsed interpretation of a label selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"},
	}
}

func schema_k8sio_api_authorization_v1_LocalSubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1.SubjectAccessReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1.SubjectAccessReviewSpec", "k8s.io/api/authorization/v1.SubjectAccessReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authorization_v1_NonResourceAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path of the request",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is the standard HTTP verb",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_NonResourceRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceRule holds information that describes a rule for the non-resource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a list of kubernetes non-resource API verbs, like: get, post, put, delete, patch, head, options.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"nonResourceURLs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"verbs"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_ResourceAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces \"\" (empty) is defaulted for LocalSubjectAccessReviews \"\" (empty) is empty for cluster-scoped resources \"\" (empty) means \"all\" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "Group is the API Group of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the API Version of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Resource is one of the existing resource types.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "Subresource is one of the existing resource types.  \"\" means none.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the resource being requested for a \"get\" or deleted for a \"delete\". \"\" (empty) means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldSelector describes the limitation on access based on field.  It can only limit access, not broaden it.\n\nThis field  is alpha-level. To use this field, you must enable the `AuthorizeWithSelectors` feature gate (disabled by default).",
							Ref:         ref("k8s.io/api/authorization/v1.FieldSelectorAttributes"),
						},
					},
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "labelSelector describes the limitation on access based on labels.  It can only limit access, not broaden it.\n\nThis field  is alpha-level. To use this field, you must enable the `AuthorizeWithSelectors` feature gate (disabled by default).",
							Ref:         ref("k8s.io/api/authorization/v1.LabelSelectorAttributes"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1.FieldSelectorAttributes", "k8s.io/api/authorization/v1.LabelSelectorAttributes"},
	}
}

func schema_k8sio_api_authorization_v1_ResourceRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceRule is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a list of kubernetes resource API verbs, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.  \"*\" means all in the specified apiGroups.\n \"*/foo\" represents the subresource 'foo' for all resources in the specified apiGroups.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"verbs"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_SelfSubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means \"in all namespaces\".  Self is a special case, because users should always be able to check whether they can perform an action",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  user and groups must be empty",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1.SelfSubjectAccessReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1.SelfSubjectAccessReviewSpec", "k8s.io/api/authorization/v1.SubjectAccessReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authorization_v1_SelfSubjectAccessReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         ref("k8s.io/api/authorization/v1.ResourceAttributes"),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         ref("k8s.io/api/authorization/v1.NonResourceAttributes"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1.NonResourceAttributes", "k8s.io/api/authorization/v1.ResourceAttributes"},
	}
}

func schema_k8sio_api_authorization_v1_SelfSubjectRulesReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace. The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1.SelfSubjectRulesReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates the set of actions a user can perform.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1.SubjectRulesReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1.SelfSubjectRulesReviewSpec", "k8s.io/api/authorization/v1.SubjectRulesReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authorization_v1_SelfSubjectRulesReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectRulesReviewSpec defines the specification for SelfSubjectRulesReview.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace to evaluate rules for. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_SubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReview checks whether or not a user or group can perform an action.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1.SubjectAccessReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1.SubjectAccessReviewSpec", "k8s.io/api/authorization/v1.SubjectAccessReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authorization_v1_SubjectAccessReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         ref("k8s.io/api/authorization/v1.ResourceAttributes"),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         ref("k8s.io/api/authorization/v1.NonResourceAttributes"),
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the user you're testing for. If you specify \"User\" but not \"Groups\", then is it interpreted as \"What if User were not a member of any groups",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Groups is the groups you're testing for.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Default: "",
													Type:    []string{"string"},
													Format:  "",
												},
											},
										},
									},
								},
							},
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID information about the requesting user.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1.NonResourceAttributes", "k8s.io/api/authorization/v1.ResourceAttributes"},
	}
}

func schema_k8sio_api_authorization_v1_SubjectAccessReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewStatus",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"allowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Allowed is required. True if the action would be allowed, false otherwise.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"denied": {
						SchemaProps: spec.SchemaProps{
							Description: "Denied is optional. True if the action would be denied, otherwise false. If both allowed is false and denied is false, then the authorizer has no opinion on whether to authorize the action. Denied may not be true if Allowed is true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is optional.  It indicates why a request was allowed or denied.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it. For instance, RBAC can be missing a role, but enough roles are still present and bound to reason about the request.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"allowed"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_SubjectRulesReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectRulesReviewStatus contains the result of a rules check. This check can be incomplete depending on the set of authorizers the server is configured with and any errors experienced during evaluation. Because authorization rules are additive, if a rule appears in a list it's safe to assume the subject has that permission, even if that list is incomplete.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/authorization/v1.ResourceRule"),
									},
								},
							},
						},
					},
					"nonResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceRules is the list of actions the subject is allowed to perform on non-resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/authorization/v1.NonResourceRule"),
									},
								},
							},
						},
					},
					"incomplete": {
						SchemaProps: spec.SchemaProps{
							Description: "Incomplete is true when the rules returned by this call are incomplete. This is most commonly encountered when an authorizer, such as an external authorizer, doesn't support rules evaluation.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"evaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError can appear in combination with Rules. It indicates an error occurred during rule evaluation, such as an authorizer that doesn't support rule evaluation, and that ResourceRules and/or NonResourceRules may be incomplete.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"resourceRules", "nonResourceRules", "incomplete"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1.NonResourceRule", "k8s.io/api/authorization/v1.ResourceRule"},
	}
}

func schema_k8sio_api_authorization_v1beta1_LocalSubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1beta1.SubjectAccessReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1beta1.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1beta1.SubjectAccessReviewSpec", "k8s.io/api/authorization/v1beta1.SubjectAccessReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authorization_v1beta1_NonResourceAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path of the request",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is the standard HTTP verb",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_NonResourceRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceRule holds information that describes a rule for the non-resource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a list of kubernetes non-resource API verbs, like: get, post, put, delete, patch, head, options.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"nonResourceURLs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"verbs"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_ResourceAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces \"\" (empty) is defaulted for LocalSubjectAccessReviews \"\" (empty) is empty for cluster-scoped resources \"\" (empty) means \"all\" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "Group is the API Group of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the API Version of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Resource is one of the existing resource types.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "Subresource is one of the existing resource types.  \"\" means none.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the resource being requested for a \"get\" or deleted for a \"delete\". \"\" (empty) means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldSelector describes the limitation on access based on field.  It can only limit access, not broaden it.",
							Ref:         ref("k8s.io/api/authorization/v1.FieldSelectorAttributes"),
						},
					},
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "labelSelector describes the limitation on access based on labels.  It can only limit access, not broaden it.",
							Ref:         ref("k8s.io/api/authorization/v1.LabelSelectorAttributes"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1.FieldSelectorAttributes", "k8s.io/api/authorization/v1.LabelSelectorAttributes"},
	}
}

func schema_k8sio_api_authorization_v1beta1_ResourceRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceRule is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a list of kubernetes resource API verbs, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.  \"*\" means all in the specified apiGroups.\n \"*/foo\" represents the subresource 'foo' for all resources in the specified apiGroups.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"verbs"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_SelfSubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means \"in all namespaces\".  Self is a special case, because users should always be able to check whether they can perform an action",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  user and groups must be empty",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1beta1.SelfSubjectAccessReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1beta1.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1beta1.SelfSubjectAccessReviewSpec", "k8s.io/api/authorization/v1beta1.SubjectAccessReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authorization_v1beta1_SelfSubjectAccessReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         ref("k8s.io/api/authorization/v1beta1.ResourceAttributes"),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         ref("k8s.io/api/authorization/v1beta1.NonResourceAttributes"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1beta1.NonResourceAttributes", "k8s.io/api/authorization/v1beta1.ResourceAttributes"},
	}
}

func schema_k8sio_api_authorization_v1beta1_SelfSubjectRulesReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace. The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1beta1.SelfSubjectRulesReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates the set of actions a user can perform.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1beta1.SubjectRulesReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1beta1.SelfSubjectRulesReviewSpec", "k8s.io/api/authorization/v1beta1.SubjectRulesReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authorization_v1beta1_SelfSubjectRulesReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectRulesReviewSpec defines the specification for SelfSubjectRulesReview.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace to evaluate rules for. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_SubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReview checks whether or not a user or group can perform an action.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1beta1.SubjectAccessReviewSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/authorization/v1beta1.SubjectAccessReviewStatus"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1beta1.SubjectAccessReviewSpec", "k8s.io/api/authorization/v1beta1.SubjectAccessReviewStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_authorization_v1beta1_SubjectAccessReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         ref("k8s.io/api/authorization/v1beta1.ResourceAttributes"),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         ref("k8s.io/api/authorization/v1beta1.NonResourceAttributes"),
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the user you're testing for. If you specify \"User\" but not \"Group\", then is it interpreted as \"What if User were not a member of any groups",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Groups is the groups you're testing for.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Default: "",
													Type:    []string{"string"},
													Format:  "",
												},
											},
										},
									},
								},
							},
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID information about the requesting user.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1beta1.NonResourceAttributes", "k8s.io/api/authorization/v1beta1.ResourceAttributes"},
	}
}

func schema_k8sio_api_authorization_v1beta1_SubjectAccessReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewStatus",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"allowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Allowed is required. True if the action would be allowed, false otherwise.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"denied": {
						SchemaProps: spec.SchemaProps{
							Description: "Denied is optional. True if the action would be denied, otherwise false. If both allowed is false and denied is false, then the authorizer has no opinion on whether to authorize the action. Denied may not be true if Allowed is true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is optional.  It indicates why a request was allowed or denied.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it. For instance, RBAC can be missing a role, but enough roles are still present and bound to reason about the request.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"allowed"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_SubjectRulesReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectRulesReviewStatus contains the result of a rules check. This check can be incomplete depending on the set of authorizers the server is configured with and any errors experienced during evaluation. Because authorization rules are additive, if a rule appears in a list it's safe to assume the subject has that permission, even if that list is incomplete.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/authorization/v1beta1.ResourceRule"),
									},
								},
							},
						},
					},
					"nonResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceRules is the list of actions the subject is allowed to perform on non-resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/authorization/v1beta1.NonResourceRule"),
									},
								},
							},
						},
					},
					"incomplete": {
						SchemaProps: spec.SchemaProps{
							Description: "Incomplete is true when the rules returned by this call are incomplete. This is most commonly encountered when an authorizer, such as an external authorizer, doesn't support rules evaluation.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"evaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError can appear in combination with Rules. It indicates an error occurred during rule evaluation, such as an authorizer that doesn't support rule evaluation, and that ResourceRules and/or NonResourceRules may be incomplete.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"resourceRules", "nonResourceRules", "incomplete"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/authorization/v1beta1.NonResourceRule", "k8s.io/api/authorization/v1beta1.ResourceRule"},
	}
}

func schema_k8sio_api_autoscaling_v1_ContainerResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in the requests and limits, describing a single container in each of the pods of the current scale target(e.g. CPU or memory). The values will be averaged together before being compared to the target. Such metrics are built into Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source. Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "container"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v1_ContainerResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type. It will always be set, regardless of the corresponding metric specification.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling taget",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "currentAverageValue", "container"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v1_CrossVersionObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "apiVersion is the API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v1_ExternalMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"targetValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetValue is the target value of the metric (as a quantity). Mutually exclusive with TargetAverageValue.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target per-pod value of global metric (as a quantity). Mutually exclusive with TargetValue.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"metricName"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_ExternalMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of a metric used for autoscaling in metric system.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"currentValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentValue is the current value of the metric (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of metric averaged over autoscaled pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"metricName", "currentValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "configuration of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec defines the behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the current information about the autoscaler.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerSpec", "k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type describes the current condition",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the status of the condition (True, False, Unknown)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastTransitionTime is the last time the condition transitioned from one status to another",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "reason is the reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "message is a human-readable explanation containing details about the transition",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "list of horizontal pod autoscaler objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v1.HorizontalPodAutoscaler"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.HorizontalPodAutoscaler", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "specification of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v1.CrossVersionObjectReference"),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "maxReplicas is the upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "targetCPUUtilizationPercentage is the target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.CrossVersionObjectReference"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "current status of a horizontal pod autoscaler",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is the current number of replicas of pods managed by this autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desiredReplicas is the  desired number of replicas of pods managed by this autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "currentCPUUtilizationPercentage is the current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"currentReplicas", "desiredReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v1_MetricSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It should be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object. Note: \"ContainerResource\" type is available on when the feature-gate HPAContainerMetrics is enabled\n\nPossible enum values:\n - `\"ContainerResource\"` is a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics (the \"pods\" source).\n - `\"External\"` is a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).\n - `\"Object\"` is a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).\n - `\"Pods\"` is a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.\n - `\"Resource\"` is a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics (the \"pods\" source).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"ContainerResource", "External", "Object", "Pods", "Resource"},
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v1.ObjectMetricSource"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v1.PodsMetricSource"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v1.ResourceMetricSource"),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.",
							Ref:         ref("k8s.io/api/autoscaling/v1.ContainerResourceMetricSource"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v1.ExternalMetricSource"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.ContainerResourceMetricSource", "k8s.io/api/autoscaling/v1.ExternalMetricSource", "k8s.io/api/autoscaling/v1.ObjectMetricSource", "k8s.io/api/autoscaling/v1.PodsMetricSource", "k8s.io/api/autoscaling/v1.ResourceMetricSource"},
	}
}

func schema_k8sio_api_autoscaling_v1_MetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricStatus describes the last-read state of a single metric.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It will be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each corresponds to a matching field in the object. Note: \"ContainerResource\" type is available on when the feature-gate HPAContainerMetrics is enabled\n\nPossible enum values:\n - `\"ContainerResource\"` is a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics (the \"pods\" source).\n - `\"External\"` is a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).\n - `\"Object\"` is a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).\n - `\"Pods\"` is a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.\n - `\"Resource\"` is a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics (the \"pods\" source).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"ContainerResource", "External", "Object", "Pods", "Resource"},
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v1.ObjectMetricStatus"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v1.PodsMetricStatus"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v1.ResourceMetricStatus"),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v1.ContainerResourceMetricStatus"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v1.ExternalMetricStatus"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.ContainerResourceMetricStatus", "k8s.io/api/autoscaling/v1.ExternalMetricStatus", "k8s.io/api/autoscaling/v1.ObjectMetricStatus", "k8s.io/api/autoscaling/v1.PodsMetricStatus", "k8s.io/api/autoscaling/v1.ResourceMetricStatus"},
	}
}

func schema_k8sio_api_autoscaling_v1_ObjectMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target is the described Kubernetes object.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v1.CrossVersionObjectReference"),
						},
					},
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetValue is the target value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"target", "metricName", "targetValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.CrossVersionObjectReference", "k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_ObjectMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target is the described Kubernetes object.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v1.CrossVersionObjectReference"),
						},
					},
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentValue is the current value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the ObjectMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"target", "metricName", "currentValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.CrossVersionObjectReference", "k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_PodsMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"metricName", "targetAverageValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_PodsMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the PodsMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"metricName", "currentAverageValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_ResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v1_ResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type. It will always be set, regardless of the corresponding metric specification.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"name", "currentAverageValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v1_Scale(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Scale represents a scaling request for a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v1.ScaleSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v1.ScaleStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.ScaleSpec", "k8s.io/api/autoscaling/v1.ScaleStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_autoscaling_v1_ScaleSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleSpec describes the attributes of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the desired number of instances for the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v1_ScaleStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleStatus represents the current status of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the actual number of observed instances of the scaled object.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the label query over pods that should match the replicas count. This is same as the label selector but in the string format to avoid introspection by clients. The string will be in the same format as the query-param syntax. More info about label selectors: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2_ContainerResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricTarget"),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "target", "container"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2_ContainerResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricValueStatus"),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "current", "container"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.MetricValueStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2_CrossVersionObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "apiVersion is the API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2_ExternalMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricIdentifier"),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricTarget"),
						},
					},
				},
				Required: []string{"metric", "target"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.MetricIdentifier", "k8s.io/api/autoscaling/v2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2_ExternalMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricIdentifier"),
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricValueStatus"),
						},
					},
				},
				Required: []string{"metric", "current"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.MetricIdentifier", "k8s.io/api/autoscaling/v2.MetricValueStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2_HPAScalingPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HPAScalingPolicy is a single policy which must hold true for a specified past interval.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is used to specify the scaling policy.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "value contains the amount of change which is permitted by the policy. It must be greater than zero",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"periodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"type", "value", "periodSeconds"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2_HPAScalingRules(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"stabilizationWindowSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selectPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"policies": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2.HPAScalingPolicy"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.HPAScalingPolicy"},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the current information about the autoscaler.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerSpec", "k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerBehavior(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleUp": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:\n  * increase no more than 4 pods per 60 seconds\n  * double the number of pods per 60 seconds\nNo stabilization is used.",
							Ref:         ref("k8s.io/api/autoscaling/v2.HPAScalingRules"),
						},
					},
					"scaleDown": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).",
							Ref:         ref("k8s.io/api/autoscaling/v2.HPAScalingRules"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.HPAScalingRules"},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type describes the current condition",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the status of the condition (True, False, Unknown)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastTransitionTime is the last time the condition transitioned from one status to another",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "reason is the reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "message is a human-readable explanation containing details about the transition",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2.HorizontalPodAutoscaler"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.HorizontalPodAutoscaler", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.CrossVersionObjectReference"),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"metrics": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2.MetricSpec"),
									},
								},
							},
						},
					},
					"behavior": {
						SchemaProps: spec.SchemaProps{
							Description: "behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.",
							Ref:         ref("k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerBehavior"),
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.CrossVersionObjectReference", "k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerBehavior", "k8s.io/api/autoscaling/v2.MetricSpec"},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentMetrics": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "currentMetrics is the last read state of the metrics used by this autoscaler.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2.MetricStatus"),
									},
								},
							},
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"desiredReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.HorizontalPodAutoscalerCondition", "k8s.io/api/autoscaling/v2.MetricStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricIdentifier(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricIdentifier defines the name and optionally selector for a metric",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the given metric",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It should be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object. Note: \"ContainerResource\" type is available on when the feature-gate HPAContainerMetrics is enabled",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v2.ObjectMetricSource"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v2.PodsMetricSource"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v2.ResourceMetricSource"),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.",
							Ref:         ref("k8s.io/api/autoscaling/v2.ContainerResourceMetricSource"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v2.ExternalMetricSource"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.ContainerResourceMetricSource", "k8s.io/api/autoscaling/v2.ExternalMetricSource", "k8s.io/api/autoscaling/v2.ObjectMetricSource", "k8s.io/api/autoscaling/v2.PodsMetricSource", "k8s.io/api/autoscaling/v2.ResourceMetricSource"},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricStatus describes the last-read state of a single metric.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It will be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each corresponds to a matching field in the object. Note: \"ContainerResource\" type is available on when the feature-gate HPAContainerMetrics is enabled",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v2.ObjectMetricStatus"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v2.PodsMetricStatus"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v2.ResourceMetricStatus"),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v2.ContainerResourceMetricStatus"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v2.ExternalMetricStatus"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.ContainerResourceMetricStatus", "k8s.io/api/autoscaling/v2.ExternalMetricStatus", "k8s.io/api/autoscaling/v2.ObjectMetricStatus", "k8s.io/api/autoscaling/v2.PodsMetricStatus", "k8s.io/api/autoscaling/v2.ResourceMetricStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricTarget(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricTarget defines the target value, average value, or average utilization of a specific metric",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type represents whether the metric type is Utilization, Value, or AverageValue",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "value is the target value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"averageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricValueStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricValueStatus holds the current value for a metric",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "value is the current value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"averageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v2_ObjectMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"describedObject": {
						SchemaProps: spec.SchemaProps{
							Description: "describedObject specifies the descriptions of a object,such as kind,name apiVersion",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.CrossVersionObjectReference"),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricTarget"),
						},
					},
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricIdentifier"),
						},
					},
				},
				Required: []string{"describedObject", "target", "metric"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.CrossVersionObjectReference", "k8s.io/api/autoscaling/v2.MetricIdentifier", "k8s.io/api/autoscaling/v2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2_ObjectMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricIdentifier"),
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricValueStatus"),
						},
					},
					"describedObject": {
						SchemaProps: spec.SchemaProps{
							Description: "DescribedObject specifies the descriptions of a object,such as kind,name apiVersion",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.CrossVersionObjectReference"),
						},
					},
				},
				Required: []string{"metric", "current", "describedObject"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.CrossVersionObjectReference", "k8s.io/api/autoscaling/v2.MetricIdentifier", "k8s.io/api/autoscaling/v2.MetricValueStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2_PodsMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricIdentifier"),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricTarget"),
						},
					},
				},
				Required: []string{"metric", "target"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.MetricIdentifier", "k8s.io/api/autoscaling/v2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2_PodsMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricIdentifier"),
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricValueStatus"),
						},
					},
				},
				Required: []string{"metric", "current"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.MetricIdentifier", "k8s.io/api/autoscaling/v2.MetricValueStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2_ResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricTarget"),
						},
					},
				},
				Required: []string{"name", "target"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2_ResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2.MetricValueStatus"),
						},
					},
				},
				Required: []string{"name", "current"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2.MetricValueStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ContainerResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "container"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ContainerResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type. It will always be set, regardless of the corresponding metric specification.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "currentAverageValue", "container"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_CrossVersionObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ExternalMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster). Exactly one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"targetValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetValue is the target value of the metric (as a quantity). Mutually exclusive with TargetAverageValue.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target per-pod value of global metric (as a quantity). Mutually exclusive with TargetValue.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"metricName"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ExternalMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of a metric used for autoscaling in metric system.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"currentValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentValue is the current value of the metric (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of metric averaged over autoscaled pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"metricName", "currentValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the current information about the autoscaler.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerSpec", "k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type describes the current condition",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the status of the condition (True, False, Unknown)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastTransitionTime is the last time the condition transitioned from one status to another",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "reason is the reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "message is a human-readable explanation containing details about the transition",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscaler"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscaler", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.CrossVersionObjectReference"),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"metrics": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2beta1.MetricSpec"),
									},
								},
							},
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta1.CrossVersionObjectReference", "k8s.io/api/autoscaling/v2beta1.MetricSpec"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentMetrics": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "currentMetrics is the last read state of the metrics used by this autoscaler.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2beta1.MetricStatus"),
									},
								},
							},
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"currentReplicas", "desiredReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta1.HorizontalPodAutoscalerCondition", "k8s.io/api/autoscaling/v2beta1.MetricStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_MetricSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It should be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object. Note: \"ContainerResource\" type is available on when the feature-gate HPAContainerMetrics is enabled",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.ObjectMetricSource"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.PodsMetricSource"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.ResourceMetricSource"),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.ContainerResourceMetricSource"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.ExternalMetricSource"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta1.ContainerResourceMetricSource", "k8s.io/api/autoscaling/v2beta1.ExternalMetricSource", "k8s.io/api/autoscaling/v2beta1.ObjectMetricSource", "k8s.io/api/autoscaling/v2beta1.PodsMetricSource", "k8s.io/api/autoscaling/v2beta1.ResourceMetricSource"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_MetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricStatus describes the last-read state of a single metric.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It will be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each corresponds to a matching field in the object. Note: \"ContainerResource\" type is available on when the feature-gate HPAContainerMetrics is enabled",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.ObjectMetricStatus"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.PodsMetricStatus"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.ResourceMetricStatus"),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.ContainerResourceMetricStatus"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.ExternalMetricStatus"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta1.ContainerResourceMetricStatus", "k8s.io/api/autoscaling/v2beta1.ExternalMetricStatus", "k8s.io/api/autoscaling/v2beta1.ObjectMetricStatus", "k8s.io/api/autoscaling/v2beta1.PodsMetricStatus", "k8s.io/api/autoscaling/v2beta1.ResourceMetricStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ObjectMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target is the described Kubernetes object.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.CrossVersionObjectReference"),
						},
					},
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetValue is the target value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"target", "metricName", "targetValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta1.CrossVersionObjectReference", "k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ObjectMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target is the described Kubernetes object.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta1.CrossVersionObjectReference"),
						},
					},
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentValue is the current value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the ObjectMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"target", "metricName", "currentValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta1.CrossVersionObjectReference", "k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_PodsMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"metricName", "targetAverageValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_PodsMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the PodsMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"metricName", "currentAverageValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type. It will always be set, regardless of the corresponding metric specification.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"name", "currentAverageValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_ContainerResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricTarget"),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "target", "container"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_ContainerResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricValueStatus"),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "current", "container"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.MetricValueStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_CrossVersionObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "apiVersion is the API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_ExternalMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricIdentifier"),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricTarget"),
						},
					},
				},
				Required: []string{"metric", "target"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.MetricIdentifier", "k8s.io/api/autoscaling/v2beta2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_ExternalMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricIdentifier"),
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricValueStatus"),
						},
					},
				},
				Required: []string{"metric", "current"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.MetricIdentifier", "k8s.io/api/autoscaling/v2beta2.MetricValueStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_HPAScalingPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HPAScalingPolicy is a single policy which must hold true for a specified past interval.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is used to specify the scaling policy.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "value contains the amount of change which is permitted by the policy. It must be greater than zero",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"periodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"type", "value", "periodSeconds"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_HPAScalingRules(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"stabilizationWindowSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selectPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "selectPolicy is used to specify which policy should be used. If not set, the default value MaxPolicySelect is used.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"policies": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2beta2.HPAScalingPolicy"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.HPAScalingPolicy"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the current information about the autoscaler.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerSpec", "k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerBehavior(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleUp": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:\n  * increase no more than 4 pods per 60 seconds\n  * double the number of pods per 60 seconds\nNo stabilization is used.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.HPAScalingRules"),
						},
					},
					"scaleDown": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.HPAScalingRules"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.HPAScalingRules"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type describes the current condition",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the status of the condition (True, False, Unknown)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastTransitionTime is the last time the condition transitioned from one status to another",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "reason is the reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "message is a human-readable explanation containing details about the transition",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscaler"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscaler", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.CrossVersionObjectReference"),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"metrics": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2beta2.MetricSpec"),
									},
								},
							},
						},
					},
					"behavior": {
						SchemaProps: spec.SchemaProps{
							Description: "behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerBehavior"),
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.CrossVersionObjectReference", "k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerBehavior", "k8s.io/api/autoscaling/v2beta2.MetricSpec"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentMetrics": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "currentMetrics is the last read state of the metrics used by this autoscaler.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2beta2.MetricStatus"),
									},
								},
							},
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"currentReplicas", "desiredReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.HorizontalPodAutoscalerCondition", "k8s.io/api/autoscaling/v2beta2.MetricStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_MetricIdentifier(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricIdentifier defines the name and optionally selector for a metric",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the given metric",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_MetricSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It should be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object. Note: \"ContainerResource\" type is available on when the feature-gate HPAContainerMetrics is enabled",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.ObjectMetricSource"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.PodsMetricSource"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.ResourceMetricSource"),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.ContainerResourceMetricSource"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.ExternalMetricSource"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.ContainerResourceMetricSource", "k8s.io/api/autoscaling/v2beta2.ExternalMetricSource", "k8s.io/api/autoscaling/v2beta2.ObjectMetricSource", "k8s.io/api/autoscaling/v2beta2.PodsMetricSource", "k8s.io/api/autoscaling/v2beta2.ResourceMetricSource"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_MetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricStatus describes the last-read state of a single metric.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It will be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each corresponds to a matching field in the object. Note: \"ContainerResource\" type is available on when the feature-gate HPAContainerMetrics is enabled",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.ObjectMetricStatus"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.PodsMetricStatus"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.ResourceMetricStatus"),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.ContainerResourceMetricStatus"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.ExternalMetricStatus"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.ContainerResourceMetricStatus", "k8s.io/api/autoscaling/v2beta2.ExternalMetricStatus", "k8s.io/api/autoscaling/v2beta2.ObjectMetricStatus", "k8s.io/api/autoscaling/v2beta2.PodsMetricStatus", "k8s.io/api/autoscaling/v2beta2.ResourceMetricStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_MetricTarget(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricTarget defines the target value, average value, or average utilization of a specific metric",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type represents whether the metric type is Utilization, Value, or AverageValue",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "value is the target value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"averageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_MetricValueStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricValueStatus holds the current value for a metric",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "value is the current value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"averageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "averageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_ObjectMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"describedObject": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/api/autoscaling/v2beta2.CrossVersionObjectReference"),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricTarget"),
						},
					},
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricIdentifier"),
						},
					},
				},
				Required: []string{"describedObject", "target", "metric"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.CrossVersionObjectReference", "k8s.io/api/autoscaling/v2beta2.MetricIdentifier", "k8s.io/api/autoscaling/v2beta2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_ObjectMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricIdentifier"),
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricValueStatus"),
						},
					},
					"describedObject": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/api/autoscaling/v2beta2.CrossVersionObjectReference"),
						},
					},
				},
				Required: []string{"metric", "current", "describedObject"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.CrossVersionObjectReference", "k8s.io/api/autoscaling/v2beta2.MetricIdentifier", "k8s.io/api/autoscaling/v2beta2.MetricValueStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_PodsMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricIdentifier"),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricTarget"),
						},
					},
				},
				Required: []string{"metric", "target"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.MetricIdentifier", "k8s.io/api/autoscaling/v2beta2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_PodsMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricIdentifier"),
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricValueStatus"),
						},
					},
				},
				Required: []string{"metric", "current"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.MetricIdentifier", "k8s.io/api/autoscaling/v2beta2.MetricValueStatus"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_ResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricTarget"),
						},
					},
				},
				Required: []string{"name", "target"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.MetricTarget"},
	}
}

func schema_k8sio_api_autoscaling_v2beta2_ResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/autoscaling/v2beta2.MetricValueStatus"),
						},
					},
				},
				Required: []string{"name", "current"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v2beta2.MetricValueStatus"},
	}
}

func schema_k8sio_api_batch_v1_CronJob(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJob represents the configuration of a single cron job.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of a cron job, including the schedule. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/batch/v1.CronJobSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Current status of a cron job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/batch/v1.CronJobStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/batch/v1.CronJobSpec", "k8s.io/api/batch/v1.CronJobStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_batch_v1_CronJobList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJobList is a collection of cron jobs.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of CronJobs.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/batch/v1.CronJob"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/batch/v1.CronJob", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_batch_v1_CronJobSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJobSpec describes how the job execution will look like and when it will actually run.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"schedule": {
						SchemaProps: spec.SchemaProps{
							Description: "The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"timeZone": {
						SchemaProps: spec.SchemaProps{
							Description: "The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones. If not specified, this will default to the time zone of the kube-controller-manager process. The set of valid time zone names and the time zone offset is loaded from the system-wide time zone database by the API server during CronJob validation and the controller manager during execution. If no system-wide time zone database can be found a bundled version of the database is used instead. If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host configuration, the controller will stop creating new new Jobs and will create a system event with the reason UnknownTimeZone. More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startingDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"concurrencyPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies how to treat concurrent executions of a Job. Valid values are:\n\n- \"Allow\" (default): allows CronJobs to run concurrently; - \"Forbid\": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - \"Replace\": cancels currently running job and replaces it with a new one\n\nPossible enum values:\n - `\"Allow\"` allows CronJobs to run concurrently.\n - `\"Forbid\"` forbids concurrent runs, skipping next run if previous hasn't finished yet.\n - `\"Replace\"` cancels currently running job and replaces it with a new one.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Allow", "Forbid", "Replace"},
						},
					},
					"suspend": {
						SchemaProps: spec.SchemaProps{
							Description: "This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"jobTemplate": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the job that will be created when executing a CronJob.",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/batch/v1.JobTemplateSpec"),
						},
					},
					"successfulJobsHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of successful finished jobs to retain. Value must be non-negative integer. Defaults to 3.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failedJobsHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of failed finished jobs to retain. Value must be non-negative integer. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"schedule", "jobTemplate"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/batch/v1.JobTemplateSpec"},
	}
}

func schema_k8sio_api_batch_v1_CronJobStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CronJobStatus represents the current state of a cron job.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"active": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "A list of pointers to currently running jobs.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/core/v1.ObjectReference"),
									},
								},
							},
						},
					},
					"lastScheduleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Information when was the last time the job was successfully scheduled.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastSuccessfulTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Information when was the last time the job successfully completed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_batch_v1_Job(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Job represents the configuration of a single job.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/batch/v1.JobSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Current status of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/batch/v1.JobStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/batch/v1.JobSpec", "k8s.io/api/batch/v1.JobStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_batch_v1_JobCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobCondition describes current state of a job.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of job condition, Complete or Failed.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition was checked.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transit from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_batch_v1_JobList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobList is a collection of jobs.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of Jobs.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/batch/v1.Job"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/batch/v1.Job", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_batch_v1_JobSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobSpec describes how the job execution will look like.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"parallelism": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"completions": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the desired number of successfully finished pods the job should be run with.  Setting to null means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"activeDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the duration in seconds relative to the startTime that the job may be continuously active before the system tries to terminate it; value must be positive integer. If a Job is suspended (at creation or through an update), this timer will effectively be stopped and reset when the Job is resumed again.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"podFailurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the policy of handling failed pods. In particular, it allows to specify the set of actions and conditions which need to be satisfied to take the associated action. If empty, the default behaviour applies - the counter of failed pods, represented by the jobs's .status.failed field, is incremented and it is checked against the backoffLimit. This field cannot be used in combination with restartPolicy=OnFailure.",
							Ref:         ref("k8s.io/api/batch/v1.PodFailurePolicy"),
						},
					},
					"successPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "successPolicy specifies the policy when the Job can be declared as succeeded. If empty, the default behavior applies - the Job is declared as succeeded only when the number of succeeded pods equals to the completions. When the field is specified, it must be immutable and works only for the Indexed Jobs. Once the Job meets the SuccessPolicy, the lingering pods are terminated.\n\nThis field is beta-level. To use this field, you must enable the `JobSuccessPolicy` feature gate (enabled by default).",
							Ref:         ref("k8s.io/api/batch/v1.SuccessPolicy"),
						},
					},
					"backoffLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the number of retries before marking this job failed. Defaults to 6",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"backoffLimitPerIndex": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the limit for the number of retries within an index before marking this index as failed. When enabled the number of failures per index is kept in the pod's batch.kubernetes.io/job-index-failure-count annotation. It can only be set when Job's completionMode=Indexed, and the Pod's restart policy is Never. The field is immutable. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxFailedIndexes": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the maximal number of failed indexes before marking the Job as failed, when backoffLimitPerIndex is set. Once the number of failed indexes exceeds this number the entire Job is marked as Failed and its execution is terminated. When left as null the job continues execution of all of its indexes and is marked with the `Complete` Job condition. It can only be specified when backoffLimitPerIndex is set. It can be null or up to completions. It is required and must be less than or equal to 10^4 when is completions greater than 10^5. This field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"manualSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes the pod that will be created when executing a job. The only allowed template.spec.restartPolicy values are \"Never\" or \"OnFailure\". More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
					"ttlSecondsAfterFinished": {
						SchemaProps: spec.SchemaProps{
							Description: "ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"completionMode": {
						SchemaProps: spec.SchemaProps{
							Description: "completionMode specifies how Pod completions are tracked. It can be `NonIndexed` (default) or `Indexed`.\n\n`NonIndexed` means that the Job is considered complete when there have been .spec.completions successfully completed Pods. Each Pod completion is homologous to each other.\n\n`Indexed` means that the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1), available in the annotation batch.kubernetes.io/job-completion-index. The Job is considered complete when there is one successfully completed Pod for each index. When value is `Indexed`, .spec.completions must be specified and `.spec.parallelism` must be less than or equal to 10^5. In addition, The Pod name takes the form `$(job-name)-$(index)-$(random-string)`, the Pod hostname takes the form `$(job-name)-$(index)`.\n\nMore completion modes can be added in the future. If the Job controller observes a mode that it doesn't recognize, which is possible during upgrades due to version skew, the controller skips updates for the Job.\n\nPossible enum values:\n - `\"Indexed\"` is a Job completion mode. In this mode, the Pods of a Job get an associated completion index from 0 to (.spec.completions - 1). The Job is considered complete when a Pod completes for each completion index.\n - `\"NonIndexed\"` is a Job completion mode. In this mode, the Job is considered complete when there have been .spec.completions successfully completed Pods. Pod completions are homologous to each other.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Indexed", "NonIndexed"},
						},
					},
					"suspend": {
						SchemaProps: spec.SchemaProps{
							Description: "suspend specifies whether the Job controller should create Pods or not. If a Job is created with suspend set to true, no Pods are created by the Job controller. If a Job is suspended after creation (i.e. the flag goes from false to true), the Job controller will delete all active Pods associated with this Job. Users must design their workload to gracefully handle this. Suspending a Job will reset the StartTime field of the Job, effectively resetting the ActiveDeadlineSeconds timer too. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"podReplacementPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "podReplacementPolicy specifies when to create replacement Pods. Possible values are: - TerminatingOrFailed means that we recreate pods\n  when they are terminating (has a metadata.deletionTimestamp) or failed.\n- Failed means to wait until a previously created Pod is fully terminated (has phase\n  Failed or Succeeded) before creating a replacement Pod.\n\nWhen using podFailurePolicy, Failed is the the only allowed value. TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use. This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle. This is on by default.\n\nPossible enum values:\n - `\"Failed\"` means to wait until a previously created Pod is fully terminated (has phase Failed or Succeeded) before creating a replacement Pod.\n - `\"TerminatingOrFailed\"` means that we recreate pods when they are terminating (has a metadata.deletionTimestamp) or failed.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Failed", "TerminatingOrFailed"},
						},
					},
					"managedBy": {
						SchemaProps: spec.SchemaProps{
							Description: "ManagedBy field indicates the controller that manages a Job. The k8s Job controller reconciles jobs which don't have this field at all or the field value is the reserved string `kubernetes.io/job-controller`, but skips reconciling Jobs with a custom value for this field. The value must be a valid domain-prefixed path (e.g. acme.io/foo) - all characters before the first \"/\" must be a valid subdomain as defined by RFC 1123. All characters trailing the first \"/\" must be valid HTTP Path characters as defined by RFC 3986. The value cannot exceed 63 characters. This field is immutable.\n\nThis field is alpha-level. The job controller accepts setting the field when the feature gate JobManagedBy is enabled (disabled by default).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/batch/v1.PodFailurePolicy", "k8s.io/api/batch/v1.SuccessPolicy", "k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_batch_v1_JobStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobStatus represents the current state of a Job.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type":       "atomic",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The latest available observations of an object's current state. When a Job fails, one of the conditions will have type \"Failed\" and status true. When a Job is suspended, one of the conditions will have type \"Suspended\" and status true; when the Job is resumed, the status of this condition will become false. When a Job is completed, one of the conditions will have type \"Complete\" and status true.\n\nA job is considered finished when it is in a terminal condition, either \"Complete\" or \"Failed\". A Job cannot have both the \"Complete\" and \"Failed\" conditions. Additionally, it cannot be in the \"Complete\" and \"FailureTarget\" conditions. The \"Complete\", \"Failed\" and \"FailureTarget\" conditions cannot be disabled.\n\nMore info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/batch/v1.JobCondition"),
									},
								},
							},
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents time when the job controller started processing a job. When a Job is created in the suspended state, this field is not set until the first time it is resumed. This field is reset every time a Job is resumed from suspension. It is represented in RFC3339 form and is in UTC.\n\nOnce set, the field can only be removed when the job is suspended. The field cannot be modified while the job is unsuspended or finished.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"completionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is set when the job finishes successfully, and only then. The value cannot be updated or removed. The value indicates the same or later point in time as the startTime field.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pending and running pods which are not terminating (without a deletionTimestamp). The value is zero for finished jobs.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"succeeded": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pods which reached phase Succeeded. The value increases monotonically for a given spec. However, it may decrease in reaction to scale down of elastic indexed jobs.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failed": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pods which reached phase Failed. The value increases monotonically.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"terminating": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pods which are terminating (in phase Pending or Running and have a deletionTimestamp).\n\nThis field is beta-level. The job controller populates the field when the feature gate JobPodReplacementPolicy is enabled (enabled by default).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"completedIndexes": {
						SchemaProps: spec.SchemaProps{
							Description: "completedIndexes holds the completed indexes when .spec.completionMode = \"Indexed\" in a text format. The indexes are represented as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as \"1,3-5,7\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"failedIndexes": {
						SchemaProps: spec.SchemaProps{
							Description: "FailedIndexes holds the failed indexes when spec.backoffLimitPerIndex is set. The indexes are represented in the text format analogous as for the `completedIndexes` field, ie. they are kept as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the failed indexes are 1, 3, 4, 5 and 7, they are represented as \"1,3-5,7\". The set of failed indexes cannot overlap with the set of completed indexes.\n\nThis field is beta-level. It can be used when the `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uncountedTerminatedPods": {
						SchemaProps: spec.SchemaProps{
							Description: "uncountedTerminatedPods holds the UIDs of Pods that have terminated but the job controller hasn't yet accounted for in the status counters.\n\nThe job controller creates pods with a finalizer. When a pod terminates (succeeded or failed), the controller does three steps to account for it in the job status:\n\n1. Add the pod UID to the arrays in this field. 2. Remove the pod finalizer. 3. Remove the pod UID from the arrays while increasing the corresponding\n    counter.\n\nOld jobs might not be tracked using this field, in which case the field remains null. The structure is empty for finished jobs.",
							Ref:         ref("k8s.io/api/batch/v1.UncountedTerminatedPods"),
						},
					},
					"ready": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of active pods which have a Ready condition and are not terminating (without a deletionTimestamp).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/batch/v1.JobCondition", "k8s.io/api/batch/v1.UncountedTerminatedPods", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_batch_v1_JobTemplateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JobTemplateSpec describes the data a Job should have when created from a template",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata of the jobs created from this template. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref("k8s.io/api/batch/v1.JobSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/batch/v1.JobSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_batch_v1_PodFailurePolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodFailurePolicy describes how failed pods influence the backoffLimit.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"rules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure, the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements are allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("k8s.io/api/batch/v1.PodFailurePolicyRule"),
									},
								},
							},
						},
					},
				},
				Required: []string{"rules"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/batch/v1.PodFailurePolicyRule"},
	}
}

func schema_k8sio_api_batch_v1_PodFailurePolicyOnExitCodesRequirement(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodFailurePolicyOnExitCodesRequirement describes the requirement for handling a failed pod based on its container exit codes. In particular, it lookups the .state.terminated.exitCode for each app container and init container status, represented by the .status.containerStatuses and .status.initContainerStatuses fields in the Pod status, respectively. Containers completed with success (exit code 0) are excluded from the requirement check.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schem