// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies a subnet attribute. You can only modify one attribute at a time.
//
// Use this action to modify subnets on Amazon Web Services Outposts.
//
//   - To modify a subnet on an Outpost rack, set both MapCustomerOwnedIpOnLaunch
//     and CustomerOwnedIpv4Pool . These two parameters act as a single attribute.
//
//   - To modify a subnet on an Outpost server, set either EnableLniAtDeviceIndex
//     or DisableLniAtDeviceIndex .
//
// For more information about Amazon Web Services Outposts, see the following:
//
// [Outpost servers]
//
// [Outpost racks]
//
// [Outpost servers]: https://docs.aws.amazon.com/outposts/latest/userguide/how-servers-work.html
// [Outpost racks]: https://docs.aws.amazon.com/outposts/latest/userguide/how-racks-work.html
func (c *Client) ModifySubnetAttribute(ctx context.Context, params *ModifySubnetAttributeInput, optFns ...func(*Options)) (*ModifySubnetAttributeOutput, error) {
	if params == nil {
		params = &ModifySubnetAttributeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifySubnetAttribute", params, optFns, c.addOperationModifySubnetAttributeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifySubnetAttributeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifySubnetAttributeInput struct {

	// The ID of the subnet.
	//
	// This member is required.
	SubnetId *string

	// Specify true to indicate that network interfaces created in the specified
	// subnet should be assigned an IPv6 address. This includes a network interface
	// that's created when launching an instance into the subnet (the instance
	// therefore receives an IPv6 address).
	//
	// If you enable the IPv6 addressing feature for your subnet, your network
	// interface or instance only receives an IPv6 address if it's created using
	// version 2016-11-15 or later of the Amazon EC2 API.
	AssignIpv6AddressOnCreation *types.AttributeBooleanValue

	// The customer-owned IPv4 address pool associated with the subnet.
	//
	// You must set this value when you specify true for MapCustomerOwnedIpOnLaunch .
	CustomerOwnedIpv4Pool *string

	//  Specify true to indicate that local network interfaces at the current position
	// should be disabled.
	DisableLniAtDeviceIndex *types.AttributeBooleanValue

	// Indicates whether DNS queries made to the Amazon-provided DNS Resolver in this
	// subnet should return synthetic IPv6 addresses for IPv4-only destinations.
	//
	// You must first configure a NAT gateway in a public subnet (separate from the
	// subnet containing the IPv6-only workloads). For example, the subnet containing
	// the NAT gateway should have a 0.0.0.0/0 route pointing to the internet gateway.
	// For more information, see [Configure DNS64 and NAT64]in the Amazon VPC User Guide.
	//
	// [Configure DNS64 and NAT64]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-nat64-dns64.html#nat-gateway-nat64-dns64-walkthrough
	EnableDns64 *types.AttributeBooleanValue

	//  Indicates the device position for local network interfaces in this subnet. For
	// example, 1 indicates local network interfaces in this subnet are the secondary
	// network interface (eth1). A local network interface cannot be the primary
	// network interface (eth0).
	EnableLniAtDeviceIndex *int32

	// Indicates whether to respond to DNS queries for instance hostnames with DNS
	// AAAA records.
	EnableResourceNameDnsAAAARecordOnLaunch *types.AttributeBooleanValue

	// Indicates whether to respond to DNS queries for instance hostnames with DNS A
	// records.
	EnableResourceNameDnsARecordOnLaunch *types.AttributeBooleanValue

	// Specify true to indicate that network interfaces attached to instances created
	// in the specified subnet should be assigned a customer-owned IPv4 address.
	//
	// When this value is true , you must specify the customer-owned IP pool using
	// CustomerOwnedIpv4Pool .
	MapCustomerOwnedIpOnLaunch *types.AttributeBooleanValue

	// Specify true to indicate that network interfaces attached to instances created
	// in the specified subnet should be assigned a public IPv4 address.
	//
	// Amazon Web Services charges for all public IPv4 addresses, including public
	// IPv4 addresses associated with running instances and Elastic IP addresses. For
	// more information, see the Public IPv4 Address tab on the [Amazon VPC pricing page].
	//
	// [Amazon VPC pricing page]: http://aws.amazon.com/vpc/pricing/
	MapPublicIpOnLaunch *types.AttributeBooleanValue

	// The type of hostname to assign to instances in the subnet at launch. For
	// IPv4-only and dual-stack (IPv4 and IPv6) subnets, an instance DNS name can be
	// based on the instance IPv4 address (ip-name) or the instance ID (resource-name).
	// For IPv6 only subnets, an instance DNS name must be based on the instance ID
	// (resource-name).
	PrivateDnsHostnameTypeOnLaunch types.HostnameType

	noSmithyDocumentSerde
}

type ModifySubnetAttributeOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifySubnetAttributeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpModifySubnetAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpModifySubnetAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifySubnetAttribute"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpModifySubnetAttributeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifySubnetAttribute(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifySubnetAttribute(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifySubnetAttribute",
	}
}
