/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the ValidateOptionsResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ValidateOptionsResponse{}

// ValidateOptionsResponse struct for ValidateOptionsResponse
type ValidateOptionsResponse struct {
	// How many VUH will be charged for the test.
	VuhUsage float32 `json:"vuh_usage"`
	// Breakdown of the VUH usage.
	Breakdown            CostBreakdownApiModel `json:"breakdown"`
	AdditionalProperties map[string]interface{}
}

type _ValidateOptionsResponse ValidateOptionsResponse

// NewValidateOptionsResponse instantiates a new ValidateOptionsResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewValidateOptionsResponse(vuhUsage float32, breakdown CostBreakdownApiModel) *ValidateOptionsResponse {
	this := ValidateOptionsResponse{}
	this.VuhUsage = vuhUsage
	this.Breakdown = breakdown
	return &this
}

// NewValidateOptionsResponseWithDefaults instantiates a new ValidateOptionsResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewValidateOptionsResponseWithDefaults() *ValidateOptionsResponse {
	this := ValidateOptionsResponse{}
	return &this
}

// GetVuhUsage returns the VuhUsage field value
func (o *ValidateOptionsResponse) GetVuhUsage() float32 {
	if o == nil {
		var ret float32
		return ret
	}

	return o.VuhUsage
}

// GetVuhUsageOk returns a tuple with the VuhUsage field value
// and a boolean to check if the value has been set.
func (o *ValidateOptionsResponse) GetVuhUsageOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.VuhUsage, true
}

// SetVuhUsage sets field value
func (o *ValidateOptionsResponse) SetVuhUsage(v float32) {
	o.VuhUsage = v
}

// GetBreakdown returns the Breakdown field value
func (o *ValidateOptionsResponse) GetBreakdown() CostBreakdownApiModel {
	if o == nil {
		var ret CostBreakdownApiModel
		return ret
	}

	return o.Breakdown
}

// GetBreakdownOk returns a tuple with the Breakdown field value
// and a boolean to check if the value has been set.
func (o *ValidateOptionsResponse) GetBreakdownOk() (*CostBreakdownApiModel, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Breakdown, true
}

// SetBreakdown sets field value
func (o *ValidateOptionsResponse) SetBreakdown(v CostBreakdownApiModel) {
	o.Breakdown = v
}

func (o ValidateOptionsResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ValidateOptionsResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["vuh_usage"] = o.VuhUsage
	toSerialize["breakdown"] = o.Breakdown

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ValidateOptionsResponse) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"vuh_usage",
		"breakdown",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varValidateOptionsResponse := _ValidateOptionsResponse{}

	err = json.Unmarshal(data, &varValidateOptionsResponse)

	if err != nil {
		return err
	}

	*o = ValidateOptionsResponse(varValidateOptionsResponse)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "vuh_usage")
		delete(additionalProperties, "breakdown")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableValidateOptionsResponse struct {
	value *ValidateOptionsResponse
	isSet bool
}

func (v NullableValidateOptionsResponse) Get() *ValidateOptionsResponse {
	return v.value
}

func (v *NullableValidateOptionsResponse) Set(val *ValidateOptionsResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableValidateOptionsResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableValidateOptionsResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableValidateOptionsResponse(val *ValidateOptionsResponse) *NullableValidateOptionsResponse {
	return &NullableValidateOptionsResponse{value: val, isSet: true}
}

func (v NullableValidateOptionsResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableValidateOptionsResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
