/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
	"time"
)

// checks if the ScheduleRecurrenceRule type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ScheduleRecurrenceRule{}

// ScheduleRecurrenceRule struct for ScheduleRecurrenceRule
type ScheduleRecurrenceRule struct {
	Frequency Frequency `json:"frequency"`
	// The interval between each frequency iteration. An interval of 2 with 'HOURLY' frequency makes the test run once every 2 hours.
	Interval *int32 `json:"interval,omitempty"`
	// The weekdays when the 'WEEKLY' recurrence will be applied. Cannot be set for other frequencies.
	Byday []Weekday `json:"byday,omitempty"`
	// A datetime instance specifying the upper-bound time limit of the recurrence.
	Until NullableTime `json:"until,omitempty"`
	// Determines how many times the recurrence will repeat.
	Count                NullableInt32 `json:"count,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _ScheduleRecurrenceRule ScheduleRecurrenceRule

// NewScheduleRecurrenceRule instantiates a new ScheduleRecurrenceRule object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewScheduleRecurrenceRule(frequency Frequency) *ScheduleRecurrenceRule {
	this := ScheduleRecurrenceRule{}
	this.Frequency = frequency
	var interval int32 = 1
	this.Interval = &interval
	return &this
}

// NewScheduleRecurrenceRuleWithDefaults instantiates a new ScheduleRecurrenceRule object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewScheduleRecurrenceRuleWithDefaults() *ScheduleRecurrenceRule {
	this := ScheduleRecurrenceRule{}
	var interval int32 = 1
	this.Interval = &interval
	return &this
}

// GetFrequency returns the Frequency field value
func (o *ScheduleRecurrenceRule) GetFrequency() Frequency {
	if o == nil {
		var ret Frequency
		return ret
	}

	return o.Frequency
}

// GetFrequencyOk returns a tuple with the Frequency field value
// and a boolean to check if the value has been set.
func (o *ScheduleRecurrenceRule) GetFrequencyOk() (*Frequency, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Frequency, true
}

// SetFrequency sets field value
func (o *ScheduleRecurrenceRule) SetFrequency(v Frequency) {
	o.Frequency = v
}

// GetInterval returns the Interval field value if set, zero value otherwise.
func (o *ScheduleRecurrenceRule) GetInterval() int32 {
	if o == nil || IsNil(o.Interval) {
		var ret int32
		return ret
	}
	return *o.Interval
}

// GetIntervalOk returns a tuple with the Interval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ScheduleRecurrenceRule) GetIntervalOk() (*int32, bool) {
	if o == nil || IsNil(o.Interval) {
		return nil, false
	}
	return o.Interval, true
}

// HasInterval returns a boolean if a field has been set.
func (o *ScheduleRecurrenceRule) HasInterval() bool {
	if o != nil && !IsNil(o.Interval) {
		return true
	}

	return false
}

// SetInterval gets a reference to the given int32 and assigns it to the Interval field.
func (o *ScheduleRecurrenceRule) SetInterval(v int32) {
	o.Interval = &v
}

// GetByday returns the Byday field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ScheduleRecurrenceRule) GetByday() []Weekday {
	if o == nil {
		var ret []Weekday
		return ret
	}
	return o.Byday
}

// GetBydayOk returns a tuple with the Byday field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ScheduleRecurrenceRule) GetBydayOk() ([]Weekday, bool) {
	if o == nil || IsNil(o.Byday) {
		return nil, false
	}
	return o.Byday, true
}

// HasByday returns a boolean if a field has been set.
func (o *ScheduleRecurrenceRule) HasByday() bool {
	if o != nil && !IsNil(o.Byday) {
		return true
	}

	return false
}

// SetByday gets a reference to the given []Weekday and assigns it to the Byday field.
func (o *ScheduleRecurrenceRule) SetByday(v []Weekday) {
	o.Byday = v
}

// GetUntil returns the Until field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ScheduleRecurrenceRule) GetUntil() time.Time {
	if o == nil || IsNil(o.Until.Get()) {
		var ret time.Time
		return ret
	}
	return *o.Until.Get()
}

// GetUntilOk returns a tuple with the Until field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ScheduleRecurrenceRule) GetUntilOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return o.Until.Get(), o.Until.IsSet()
}

// HasUntil returns a boolean if a field has been set.
func (o *ScheduleRecurrenceRule) HasUntil() bool {
	if o != nil && o.Until.IsSet() {
		return true
	}

	return false
}

// SetUntil gets a reference to the given NullableTime and assigns it to the Until field.
func (o *ScheduleRecurrenceRule) SetUntil(v time.Time) {
	o.Until.Set(&v)
}

// SetUntilNil sets the value for Until to be an explicit nil
func (o *ScheduleRecurrenceRule) SetUntilNil() {
	o.Until.Set(nil)
}

// UnsetUntil ensures that no value is present for Until, not even an explicit nil
func (o *ScheduleRecurrenceRule) UnsetUntil() {
	o.Until.Unset()
}

// GetCount returns the Count field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *ScheduleRecurrenceRule) GetCount() int32 {
	if o == nil || IsNil(o.Count.Get()) {
		var ret int32
		return ret
	}
	return *o.Count.Get()
}

// GetCountOk returns a tuple with the Count field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ScheduleRecurrenceRule) GetCountOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Count.Get(), o.Count.IsSet()
}

// HasCount returns a boolean if a field has been set.
func (o *ScheduleRecurrenceRule) HasCount() bool {
	if o != nil && o.Count.IsSet() {
		return true
	}

	return false
}

// SetCount gets a reference to the given NullableInt32 and assigns it to the Count field.
func (o *ScheduleRecurrenceRule) SetCount(v int32) {
	o.Count.Set(&v)
}

// SetCountNil sets the value for Count to be an explicit nil
func (o *ScheduleRecurrenceRule) SetCountNil() {
	o.Count.Set(nil)
}

// UnsetCount ensures that no value is present for Count, not even an explicit nil
func (o *ScheduleRecurrenceRule) UnsetCount() {
	o.Count.Unset()
}

func (o ScheduleRecurrenceRule) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ScheduleRecurrenceRule) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["frequency"] = o.Frequency
	if !IsNil(o.Interval) {
		toSerialize["interval"] = o.Interval
	}
	if o.Byday != nil {
		toSerialize["byday"] = o.Byday
	}
	if o.Until.IsSet() {
		toSerialize["until"] = o.Until.Get()
	}
	if o.Count.IsSet() {
		toSerialize["count"] = o.Count.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ScheduleRecurrenceRule) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"frequency",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varScheduleRecurrenceRule := _ScheduleRecurrenceRule{}

	err = json.Unmarshal(data, &varScheduleRecurrenceRule)

	if err != nil {
		return err
	}

	*o = ScheduleRecurrenceRule(varScheduleRecurrenceRule)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "frequency")
		delete(additionalProperties, "interval")
		delete(additionalProperties, "byday")
		delete(additionalProperties, "until")
		delete(additionalProperties, "count")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableScheduleRecurrenceRule struct {
	value *ScheduleRecurrenceRule
	isSet bool
}

func (v NullableScheduleRecurrenceRule) Get() *ScheduleRecurrenceRule {
	return v.value
}

func (v *NullableScheduleRecurrenceRule) Set(val *ScheduleRecurrenceRule) {
	v.value = val
	v.isSet = true
}

func (v NullableScheduleRecurrenceRule) IsSet() bool {
	return v.isSet
}

func (v *NullableScheduleRecurrenceRule) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableScheduleRecurrenceRule(val *ScheduleRecurrenceRule) *NullableScheduleRecurrenceRule {
	return &NullableScheduleRecurrenceRule{value: val, isSet: true}
}

func (v NullableScheduleRecurrenceRule) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableScheduleRecurrenceRule) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
