/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
	"time"
)

// checks if the ProjectApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ProjectApiModel{}

// ProjectApiModel struct for ProjectApiModel
type ProjectApiModel struct {
	// Project ID.
	Id int32 `json:"id"`
	// Project name.
	Name string `json:"name"`
	// Use this project as default for running tests when no explicit project ID is provided.
	IsDefault bool `json:"is_default"`
	// Grafana folder UID.
	GrafanaFolderUid NullableString `json:"grafana_folder_uid"`
	// The date when the project was created.
	Created time.Time `json:"created"`
	// The date when the project was last updated.
	Updated              time.Time `json:"updated"`
	AdditionalProperties map[string]interface{}
}

type _ProjectApiModel ProjectApiModel

// NewProjectApiModel instantiates a new ProjectApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewProjectApiModel(id int32, name string, isDefault bool, grafanaFolderUid NullableString, created time.Time, updated time.Time) *ProjectApiModel {
	this := ProjectApiModel{}
	this.Id = id
	this.Name = name
	this.IsDefault = isDefault
	this.GrafanaFolderUid = grafanaFolderUid
	this.Created = created
	this.Updated = updated
	return &this
}

// NewProjectApiModelWithDefaults instantiates a new ProjectApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewProjectApiModelWithDefaults() *ProjectApiModel {
	this := ProjectApiModel{}
	return &this
}

// GetId returns the Id field value
func (o *ProjectApiModel) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *ProjectApiModel) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *ProjectApiModel) SetId(v int32) {
	o.Id = v
}

// GetName returns the Name field value
func (o *ProjectApiModel) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *ProjectApiModel) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *ProjectApiModel) SetName(v string) {
	o.Name = v
}

// GetIsDefault returns the IsDefault field value
func (o *ProjectApiModel) GetIsDefault() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.IsDefault
}

// GetIsDefaultOk returns a tuple with the IsDefault field value
// and a boolean to check if the value has been set.
func (o *ProjectApiModel) GetIsDefaultOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.IsDefault, true
}

// SetIsDefault sets field value
func (o *ProjectApiModel) SetIsDefault(v bool) {
	o.IsDefault = v
}

// GetGrafanaFolderUid returns the GrafanaFolderUid field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ProjectApiModel) GetGrafanaFolderUid() string {
	if o == nil || o.GrafanaFolderUid.Get() == nil {
		var ret string
		return ret
	}

	return *o.GrafanaFolderUid.Get()
}

// GetGrafanaFolderUidOk returns a tuple with the GrafanaFolderUid field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ProjectApiModel) GetGrafanaFolderUidOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.GrafanaFolderUid.Get(), o.GrafanaFolderUid.IsSet()
}

// SetGrafanaFolderUid sets field value
func (o *ProjectApiModel) SetGrafanaFolderUid(v string) {
	o.GrafanaFolderUid.Set(&v)
}

// GetCreated returns the Created field value
func (o *ProjectApiModel) GetCreated() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.Created
}

// GetCreatedOk returns a tuple with the Created field value
// and a boolean to check if the value has been set.
func (o *ProjectApiModel) GetCreatedOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Created, true
}

// SetCreated sets field value
func (o *ProjectApiModel) SetCreated(v time.Time) {
	o.Created = v
}

// GetUpdated returns the Updated field value
func (o *ProjectApiModel) GetUpdated() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.Updated
}

// GetUpdatedOk returns a tuple with the Updated field value
// and a boolean to check if the value has been set.
func (o *ProjectApiModel) GetUpdatedOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Updated, true
}

// SetUpdated sets field value
func (o *ProjectApiModel) SetUpdated(v time.Time) {
	o.Updated = v
}

func (o ProjectApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ProjectApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["name"] = o.Name
	toSerialize["is_default"] = o.IsDefault
	toSerialize["grafana_folder_uid"] = o.GrafanaFolderUid.Get()
	toSerialize["created"] = o.Created
	toSerialize["updated"] = o.Updated

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ProjectApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"name",
		"is_default",
		"grafana_folder_uid",
		"created",
		"updated",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varProjectApiModel := _ProjectApiModel{}

	err = json.Unmarshal(data, &varProjectApiModel)

	if err != nil {
		return err
	}

	*o = ProjectApiModel(varProjectApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "id")
		delete(additionalProperties, "name")
		delete(additionalProperties, "is_default")
		delete(additionalProperties, "grafana_folder_uid")
		delete(additionalProperties, "created")
		delete(additionalProperties, "updated")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableProjectApiModel struct {
	value *ProjectApiModel
	isSet bool
}

func (v NullableProjectApiModel) Get() *ProjectApiModel {
	return v.value
}

func (v *NullableProjectApiModel) Set(val *ProjectApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableProjectApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableProjectApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableProjectApiModel(val *ProjectApiModel) *NullableProjectApiModel {
	return &NullableProjectApiModel{value: val, isSet: true}
}

func (v NullableProjectApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableProjectApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
