/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the AuthenticationResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AuthenticationResponse{}

// AuthenticationResponse struct for AuthenticationResponse
type AuthenticationResponse struct {
	// The ID of the Grafana stack matching the provided URL.
	StackId int32 `json:"stack_id"`
	// The ID of the default project in the stack.
	DefaultProjectId     int32 `json:"default_project_id"`
	AdditionalProperties map[string]interface{}
}

type _AuthenticationResponse AuthenticationResponse

// NewAuthenticationResponse instantiates a new AuthenticationResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAuthenticationResponse(stackId int32, defaultProjectId int32) *AuthenticationResponse {
	this := AuthenticationResponse{}
	this.StackId = stackId
	this.DefaultProjectId = defaultProjectId
	return &this
}

// NewAuthenticationResponseWithDefaults instantiates a new AuthenticationResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAuthenticationResponseWithDefaults() *AuthenticationResponse {
	this := AuthenticationResponse{}
	return &this
}

// GetStackId returns the StackId field value
func (o *AuthenticationResponse) GetStackId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.StackId
}

// GetStackIdOk returns a tuple with the StackId field value
// and a boolean to check if the value has been set.
func (o *AuthenticationResponse) GetStackIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.StackId, true
}

// SetStackId sets field value
func (o *AuthenticationResponse) SetStackId(v int32) {
	o.StackId = v
}

// GetDefaultProjectId returns the DefaultProjectId field value
func (o *AuthenticationResponse) GetDefaultProjectId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.DefaultProjectId
}

// GetDefaultProjectIdOk returns a tuple with the DefaultProjectId field value
// and a boolean to check if the value has been set.
func (o *AuthenticationResponse) GetDefaultProjectIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.DefaultProjectId, true
}

// SetDefaultProjectId sets field value
func (o *AuthenticationResponse) SetDefaultProjectId(v int32) {
	o.DefaultProjectId = v
}

func (o AuthenticationResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AuthenticationResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["stack_id"] = o.StackId
	toSerialize["default_project_id"] = o.DefaultProjectId

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AuthenticationResponse) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"stack_id",
		"default_project_id",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varAuthenticationResponse := _AuthenticationResponse{}

	err = json.Unmarshal(data, &varAuthenticationResponse)

	if err != nil {
		return err
	}

	*o = AuthenticationResponse(varAuthenticationResponse)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "stack_id")
		delete(additionalProperties, "default_project_id")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAuthenticationResponse struct {
	value *AuthenticationResponse
	isSet bool
}

func (v NullableAuthenticationResponse) Get() *AuthenticationResponse {
	return v.value
}

func (v *NullableAuthenticationResponse) Set(val *AuthenticationResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableAuthenticationResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableAuthenticationResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAuthenticationResponse(val *AuthenticationResponse) *NullableAuthenticationResponse {
	return &NullableAuthenticationResponse{value: val, isSet: true}
}

func (v NullableAuthenticationResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAuthenticationResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
