// Copyright 2017 Prometheus Team
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: types.proto

//go:build !protoopaque

package _go

import (
	_ "buf.build/gen/go/gogo/protobuf/protocolbuffers/go/gogoproto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MetricMetadata_MetricType int32

const (
	MetricMetadata_UNKNOWN        MetricMetadata_MetricType = 0
	MetricMetadata_COUNTER        MetricMetadata_MetricType = 1
	MetricMetadata_GAUGE          MetricMetadata_MetricType = 2
	MetricMetadata_HISTOGRAM      MetricMetadata_MetricType = 3
	MetricMetadata_GAUGEHISTOGRAM MetricMetadata_MetricType = 4
	MetricMetadata_SUMMARY        MetricMetadata_MetricType = 5
	MetricMetadata_INFO           MetricMetadata_MetricType = 6
	MetricMetadata_STATESET       MetricMetadata_MetricType = 7
)

// Enum value maps for MetricMetadata_MetricType.
var (
	MetricMetadata_MetricType_name = map[int32]string{
		0: "UNKNOWN",
		1: "COUNTER",
		2: "GAUGE",
		3: "HISTOGRAM",
		4: "GAUGEHISTOGRAM",
		5: "SUMMARY",
		6: "INFO",
		7: "STATESET",
	}
	MetricMetadata_MetricType_value = map[string]int32{
		"UNKNOWN":        0,
		"COUNTER":        1,
		"GAUGE":          2,
		"HISTOGRAM":      3,
		"GAUGEHISTOGRAM": 4,
		"SUMMARY":        5,
		"INFO":           6,
		"STATESET":       7,
	}
)

func (x MetricMetadata_MetricType) Enum() *MetricMetadata_MetricType {
	p := new(MetricMetadata_MetricType)
	*p = x
	return p
}

func (x MetricMetadata_MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricMetadata_MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_types_proto_enumTypes[0].Descriptor()
}

func (MetricMetadata_MetricType) Type() protoreflect.EnumType {
	return &file_types_proto_enumTypes[0]
}

func (x MetricMetadata_MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type Histogram_ResetHint int32

const (
	Histogram_UNKNOWN Histogram_ResetHint = 0 // Need to test for a counter reset explicitly.
	Histogram_YES     Histogram_ResetHint = 1 // This is the 1st histogram after a counter reset.
	Histogram_NO      Histogram_ResetHint = 2 // There was no counter reset between this and the previous Histogram.
	Histogram_GAUGE   Histogram_ResetHint = 3 // This is a gauge histogram where counter resets don't happen.
)

// Enum value maps for Histogram_ResetHint.
var (
	Histogram_ResetHint_name = map[int32]string{
		0: "UNKNOWN",
		1: "YES",
		2: "NO",
		3: "GAUGE",
	}
	Histogram_ResetHint_value = map[string]int32{
		"UNKNOWN": 0,
		"YES":     1,
		"NO":      2,
		"GAUGE":   3,
	}
)

func (x Histogram_ResetHint) Enum() *Histogram_ResetHint {
	p := new(Histogram_ResetHint)
	*p = x
	return p
}

func (x Histogram_ResetHint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Histogram_ResetHint) Descriptor() protoreflect.EnumDescriptor {
	return file_types_proto_enumTypes[1].Descriptor()
}

func (Histogram_ResetHint) Type() protoreflect.EnumType {
	return &file_types_proto_enumTypes[1]
}

func (x Histogram_ResetHint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type LabelMatcher_Type int32

const (
	LabelMatcher_EQ  LabelMatcher_Type = 0
	LabelMatcher_NEQ LabelMatcher_Type = 1
	LabelMatcher_RE  LabelMatcher_Type = 2
	LabelMatcher_NRE LabelMatcher_Type = 3
)

// Enum value maps for LabelMatcher_Type.
var (
	LabelMatcher_Type_name = map[int32]string{
		0: "EQ",
		1: "NEQ",
		2: "RE",
		3: "NRE",
	}
	LabelMatcher_Type_value = map[string]int32{
		"EQ":  0,
		"NEQ": 1,
		"RE":  2,
		"NRE": 3,
	}
)

func (x LabelMatcher_Type) Enum() *LabelMatcher_Type {
	p := new(LabelMatcher_Type)
	*p = x
	return p
}

func (x LabelMatcher_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LabelMatcher_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_types_proto_enumTypes[2].Descriptor()
}

func (LabelMatcher_Type) Type() protoreflect.EnumType {
	return &file_types_proto_enumTypes[2]
}

func (x LabelMatcher_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// We require this to match chunkenc.Encoding.
type Chunk_Encoding int32

const (
	Chunk_UNKNOWN         Chunk_Encoding = 0
	Chunk_XOR             Chunk_Encoding = 1
	Chunk_HISTOGRAM       Chunk_Encoding = 2
	Chunk_FLOAT_HISTOGRAM Chunk_Encoding = 3
)

// Enum value maps for Chunk_Encoding.
var (
	Chunk_Encoding_name = map[int32]string{
		0: "UNKNOWN",
		1: "XOR",
		2: "HISTOGRAM",
		3: "FLOAT_HISTOGRAM",
	}
	Chunk_Encoding_value = map[string]int32{
		"UNKNOWN":         0,
		"XOR":             1,
		"HISTOGRAM":       2,
		"FLOAT_HISTOGRAM": 3,
	}
)

func (x Chunk_Encoding) Enum() *Chunk_Encoding {
	p := new(Chunk_Encoding)
	*p = x
	return p
}

func (x Chunk_Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Chunk_Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_types_proto_enumTypes[3].Descriptor()
}

func (Chunk_Encoding) Type() protoreflect.EnumType {
	return &file_types_proto_enumTypes[3]
}

func (x Chunk_Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type MetricMetadata struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Represents the metric type, these match the set from Prometheus.
	// Refer to github.com/prometheus/common/model/metadata.go for details.
	Type             MetricMetadata_MetricType `protobuf:"varint,1,opt,name=type,proto3,enum=prometheus.MetricMetadata_MetricType" json:"type,omitempty"`
	MetricFamilyName string                    `protobuf:"bytes,2,opt,name=metric_family_name,json=metricFamilyName,proto3" json:"metric_family_name,omitempty"`
	Help             string                    `protobuf:"bytes,4,opt,name=help,proto3" json:"help,omitempty"`
	Unit             string                    `protobuf:"bytes,5,opt,name=unit,proto3" json:"unit,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *MetricMetadata) Reset() {
	*x = MetricMetadata{}
	mi := &file_types_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricMetadata) ProtoMessage() {}

func (x *MetricMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MetricMetadata) GetType() MetricMetadata_MetricType {
	if x != nil {
		return x.Type
	}
	return MetricMetadata_UNKNOWN
}

func (x *MetricMetadata) GetMetricFamilyName() string {
	if x != nil {
		return x.MetricFamilyName
	}
	return ""
}

func (x *MetricMetadata) GetHelp() string {
	if x != nil {
		return x.Help
	}
	return ""
}

func (x *MetricMetadata) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

func (x *MetricMetadata) SetType(v MetricMetadata_MetricType) {
	x.Type = v
}

func (x *MetricMetadata) SetMetricFamilyName(v string) {
	x.MetricFamilyName = v
}

func (x *MetricMetadata) SetHelp(v string) {
	x.Help = v
}

func (x *MetricMetadata) SetUnit(v string) {
	x.Unit = v
}

type MetricMetadata_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Represents the metric type, these match the set from Prometheus.
	// Refer to github.com/prometheus/common/model/metadata.go for details.
	Type             MetricMetadata_MetricType
	MetricFamilyName string
	Help             string
	Unit             string
}

func (b0 MetricMetadata_builder) Build() *MetricMetadata {
	m0 := &MetricMetadata{}
	b, x := &b0, m0
	_, _ = b, x
	x.Type = b.Type
	x.MetricFamilyName = b.MetricFamilyName
	x.Help = b.Help
	x.Unit = b.Unit
	return m0
}

type Sample struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	Value float64                `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// timestamp is in ms format, see model/timestamp/timestamp.go for
	// conversion from time.Time to Prometheus timestamp.
	Timestamp     int64 `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Sample) Reset() {
	*x = Sample{}
	mi := &file_types_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Sample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sample) ProtoMessage() {}

func (x *Sample) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Sample) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *Sample) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Sample) SetValue(v float64) {
	x.Value = v
}

func (x *Sample) SetTimestamp(v int64) {
	x.Timestamp = v
}

type Sample_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value float64
	// timestamp is in ms format, see model/timestamp/timestamp.go for
	// conversion from time.Time to Prometheus timestamp.
	Timestamp int64
}

func (b0 Sample_builder) Build() *Sample {
	m0 := &Sample{}
	b, x := &b0, m0
	_, _ = b, x
	x.Value = b.Value
	x.Timestamp = b.Timestamp
	return m0
}

type Exemplar struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Optional, can be empty.
	Labels []*Label `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	Value  float64  `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
	// timestamp is in ms format, see model/timestamp/timestamp.go for
	// conversion from time.Time to Prometheus timestamp.
	Timestamp     int64 `protobuf:"varint,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Exemplar) Reset() {
	*x = Exemplar{}
	mi := &file_types_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Exemplar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Exemplar) ProtoMessage() {}

func (x *Exemplar) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Exemplar) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Exemplar) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *Exemplar) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Exemplar) SetLabels(v []*Label) {
	x.Labels = v
}

func (x *Exemplar) SetValue(v float64) {
	x.Value = v
}

func (x *Exemplar) SetTimestamp(v int64) {
	x.Timestamp = v
}

type Exemplar_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Optional, can be empty.
	Labels []*Label
	Value  float64
	// timestamp is in ms format, see model/timestamp/timestamp.go for
	// conversion from time.Time to Prometheus timestamp.
	Timestamp int64
}

func (b0 Exemplar_builder) Build() *Exemplar {
	m0 := &Exemplar{}
	b, x := &b0, m0
	_, _ = b, x
	x.Labels = b.Labels
	x.Value = b.Value
	x.Timestamp = b.Timestamp
	return m0
}

// A native histogram, also known as a sparse histogram.
// Original design doc:
// https://docs.google.com/document/d/1cLNv3aufPZb3fNfaJgdaRBZsInZKKIHo9E6HinJVbpM/edit
// The appendix of this design doc also explains the concept of float
// histograms. This Histogram message can represent both, the usual
// integer histogram as well as a float histogram.
type Histogram struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Types that are valid to be assigned to Count:
	//
	//	*Histogram_CountInt
	//	*Histogram_CountFloat
	Count isHistogram_Count `protobuf_oneof:"count"`
	Sum   float64           `protobuf:"fixed64,3,opt,name=sum,proto3" json:"sum,omitempty"` // Sum of observations in the histogram.
	// The schema defines the bucket schema. Currently, valid numbers
	// are -4 <= n <= 8. They are all for base-2 bucket schemas, where 1
	// is a bucket boundary in each case, and then each power of two is
	// divided into 2^n logarithmic buckets. Or in other words, each
	// bucket boundary is the previous boundary times 2^(2^-n). In the
	// future, more bucket schemas may be added using numbers < -4 or >
	// 8.
	Schema        int32   `protobuf:"zigzag32,4,opt,name=schema,proto3" json:"schema,omitempty"`
	ZeroThreshold float64 `protobuf:"fixed64,5,opt,name=zero_threshold,json=zeroThreshold,proto3" json:"zero_threshold,omitempty"` // Breadth of the zero bucket.
	// Types that are valid to be assigned to ZeroCount:
	//
	//	*Histogram_ZeroCountInt
	//	*Histogram_ZeroCountFloat
	ZeroCount isHistogram_ZeroCount `protobuf_oneof:"zero_count"`
	// Negative Buckets.
	NegativeSpans []*BucketSpan `protobuf:"bytes,8,rep,name=negative_spans,json=negativeSpans,proto3" json:"negative_spans,omitempty"`
	// Use either "negative_deltas" or "negative_counts", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	NegativeDeltas []int64   `protobuf:"zigzag64,9,rep,packed,name=negative_deltas,json=negativeDeltas,proto3" json:"negative_deltas,omitempty"` // Count delta of each bucket compared to previous one (or to zero for 1st bucket).
	NegativeCounts []float64 `protobuf:"fixed64,10,rep,packed,name=negative_counts,json=negativeCounts,proto3" json:"negative_counts,omitempty"` // Absolute count of each bucket.
	// Positive Buckets.
	PositiveSpans []*BucketSpan `protobuf:"bytes,11,rep,name=positive_spans,json=positiveSpans,proto3" json:"positive_spans,omitempty"`
	// Use either "positive_deltas" or "positive_counts", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	PositiveDeltas []int64             `protobuf:"zigzag64,12,rep,packed,name=positive_deltas,json=positiveDeltas,proto3" json:"positive_deltas,omitempty"` // Count delta of each bucket compared to previous one (or to zero for 1st bucket).
	PositiveCounts []float64           `protobuf:"fixed64,13,rep,packed,name=positive_counts,json=positiveCounts,proto3" json:"positive_counts,omitempty"`  // Absolute count of each bucket.
	ResetHint      Histogram_ResetHint `protobuf:"varint,14,opt,name=reset_hint,json=resetHint,proto3,enum=prometheus.Histogram_ResetHint" json:"reset_hint,omitempty"`
	// timestamp is in ms format, see model/timestamp/timestamp.go for
	// conversion from time.Time to Prometheus timestamp.
	Timestamp int64 `protobuf:"varint,15,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// custom_values are not part of the specification, DO NOT use in remote write clients.
	// Used only for converting from OpenTelemetry to Prometheus internally.
	CustomValues  []float64 `protobuf:"fixed64,16,rep,packed,name=custom_values,json=customValues,proto3" json:"custom_values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Histogram) Reset() {
	*x = Histogram{}
	mi := &file_types_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Histogram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Histogram) ProtoMessage() {}

func (x *Histogram) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Histogram) GetCount() isHistogram_Count {
	if x != nil {
		return x.Count
	}
	return nil
}

func (x *Histogram) GetCountInt() uint64 {
	if x != nil {
		if x, ok := x.Count.(*Histogram_CountInt); ok {
			return x.CountInt
		}
	}
	return 0
}

func (x *Histogram) GetCountFloat() float64 {
	if x != nil {
		if x, ok := x.Count.(*Histogram_CountFloat); ok {
			return x.CountFloat
		}
	}
	return 0
}

func (x *Histogram) GetSum() float64 {
	if x != nil {
		return x.Sum
	}
	return 0
}

func (x *Histogram) GetSchema() int32 {
	if x != nil {
		return x.Schema
	}
	return 0
}

func (x *Histogram) GetZeroThreshold() float64 {
	if x != nil {
		return x.ZeroThreshold
	}
	return 0
}

func (x *Histogram) GetZeroCount() isHistogram_ZeroCount {
	if x != nil {
		return x.ZeroCount
	}
	return nil
}

func (x *Histogram) GetZeroCountInt() uint64 {
	if x != nil {
		if x, ok := x.ZeroCount.(*Histogram_ZeroCountInt); ok {
			return x.ZeroCountInt
		}
	}
	return 0
}

func (x *Histogram) GetZeroCountFloat() float64 {
	if x != nil {
		if x, ok := x.ZeroCount.(*Histogram_ZeroCountFloat); ok {
			return x.ZeroCountFloat
		}
	}
	return 0
}

func (x *Histogram) GetNegativeSpans() []*BucketSpan {
	if x != nil {
		return x.NegativeSpans
	}
	return nil
}

func (x *Histogram) GetNegativeDeltas() []int64 {
	if x != nil {
		return x.NegativeDeltas
	}
	return nil
}

func (x *Histogram) GetNegativeCounts() []float64 {
	if x != nil {
		return x.NegativeCounts
	}
	return nil
}

func (x *Histogram) GetPositiveSpans() []*BucketSpan {
	if x != nil {
		return x.PositiveSpans
	}
	return nil
}

func (x *Histogram) GetPositiveDeltas() []int64 {
	if x != nil {
		return x.PositiveDeltas
	}
	return nil
}

func (x *Histogram) GetPositiveCounts() []float64 {
	if x != nil {
		return x.PositiveCounts
	}
	return nil
}

func (x *Histogram) GetResetHint() Histogram_ResetHint {
	if x != nil {
		return x.ResetHint
	}
	return Histogram_UNKNOWN
}

func (x *Histogram) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

func (x *Histogram) GetCustomValues() []float64 {
	if x != nil {
		return x.CustomValues
	}
	return nil
}

func (x *Histogram) SetCountInt(v uint64) {
	x.Count = &Histogram_CountInt{v}
}

func (x *Histogram) SetCountFloat(v float64) {
	x.Count = &Histogram_CountFloat{v}
}

func (x *Histogram) SetSum(v float64) {
	x.Sum = v
}

func (x *Histogram) SetSchema(v int32) {
	x.Schema = v
}

func (x *Histogram) SetZeroThreshold(v float64) {
	x.ZeroThreshold = v
}

func (x *Histogram) SetZeroCountInt(v uint64) {
	x.ZeroCount = &Histogram_ZeroCountInt{v}
}

func (x *Histogram) SetZeroCountFloat(v float64) {
	x.ZeroCount = &Histogram_ZeroCountFloat{v}
}

func (x *Histogram) SetNegativeSpans(v []*BucketSpan) {
	x.NegativeSpans = v
}

func (x *Histogram) SetNegativeDeltas(v []int64) {
	x.NegativeDeltas = v
}

func (x *Histogram) SetNegativeCounts(v []float64) {
	x.NegativeCounts = v
}

func (x *Histogram) SetPositiveSpans(v []*BucketSpan) {
	x.PositiveSpans = v
}

func (x *Histogram) SetPositiveDeltas(v []int64) {
	x.PositiveDeltas = v
}

func (x *Histogram) SetPositiveCounts(v []float64) {
	x.PositiveCounts = v
}

func (x *Histogram) SetResetHint(v Histogram_ResetHint) {
	x.ResetHint = v
}

func (x *Histogram) SetTimestamp(v int64) {
	x.Timestamp = v
}

func (x *Histogram) SetCustomValues(v []float64) {
	x.CustomValues = v
}

func (x *Histogram) HasCount() bool {
	if x == nil {
		return false
	}
	return x.Count != nil
}

func (x *Histogram) HasCountInt() bool {
	if x == nil {
		return false
	}
	_, ok := x.Count.(*Histogram_CountInt)
	return ok
}

func (x *Histogram) HasCountFloat() bool {
	if x == nil {
		return false
	}
	_, ok := x.Count.(*Histogram_CountFloat)
	return ok
}

func (x *Histogram) HasZeroCount() bool {
	if x == nil {
		return false
	}
	return x.ZeroCount != nil
}

func (x *Histogram) HasZeroCountInt() bool {
	if x == nil {
		return false
	}
	_, ok := x.ZeroCount.(*Histogram_ZeroCountInt)
	return ok
}

func (x *Histogram) HasZeroCountFloat() bool {
	if x == nil {
		return false
	}
	_, ok := x.ZeroCount.(*Histogram_ZeroCountFloat)
	return ok
}

func (x *Histogram) ClearCount() {
	x.Count = nil
}

func (x *Histogram) ClearCountInt() {
	if _, ok := x.Count.(*Histogram_CountInt); ok {
		x.Count = nil
	}
}

func (x *Histogram) ClearCountFloat() {
	if _, ok := x.Count.(*Histogram_CountFloat); ok {
		x.Count = nil
	}
}

func (x *Histogram) ClearZeroCount() {
	x.ZeroCount = nil
}

func (x *Histogram) ClearZeroCountInt() {
	if _, ok := x.ZeroCount.(*Histogram_ZeroCountInt); ok {
		x.ZeroCount = nil
	}
}

func (x *Histogram) ClearZeroCountFloat() {
	if _, ok := x.ZeroCount.(*Histogram_ZeroCountFloat); ok {
		x.ZeroCount = nil
	}
}

const Histogram_Count_not_set_case case_Histogram_Count = 0
const Histogram_CountInt_case case_Histogram_Count = 1
const Histogram_CountFloat_case case_Histogram_Count = 2

func (x *Histogram) WhichCount() case_Histogram_Count {
	if x == nil {
		return Histogram_Count_not_set_case
	}
	switch x.Count.(type) {
	case *Histogram_CountInt:
		return Histogram_CountInt_case
	case *Histogram_CountFloat:
		return Histogram_CountFloat_case
	default:
		return Histogram_Count_not_set_case
	}
}

const Histogram_ZeroCount_not_set_case case_Histogram_ZeroCount = 0
const Histogram_ZeroCountInt_case case_Histogram_ZeroCount = 6
const Histogram_ZeroCountFloat_case case_Histogram_ZeroCount = 7

func (x *Histogram) WhichZeroCount() case_Histogram_ZeroCount {
	if x == nil {
		return Histogram_ZeroCount_not_set_case
	}
	switch x.ZeroCount.(type) {
	case *Histogram_ZeroCountInt:
		return Histogram_ZeroCountInt_case
	case *Histogram_ZeroCountFloat:
		return Histogram_ZeroCountFloat_case
	default:
		return Histogram_ZeroCount_not_set_case
	}
}

type Histogram_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof Count:
	CountInt   *uint64
	CountFloat *float64
	// -- end of Count
	Sum float64
	// The schema defines the bucket schema. Currently, valid numbers
	// are -4 <= n <= 8. They are all for base-2 bucket schemas, where 1
	// is a bucket boundary in each case, and then each power of two is
	// divided into 2^n logarithmic buckets. Or in other words, each
	// bucket boundary is the previous boundary times 2^(2^-n). In the
	// future, more bucket schemas may be added using numbers < -4 or >
	// 8.
	Schema        int32
	ZeroThreshold float64
	// Fields of oneof ZeroCount:
	ZeroCountInt   *uint64
	ZeroCountFloat *float64
	// -- end of ZeroCount
	// Negative Buckets.
	NegativeSpans []*BucketSpan
	// Use either "negative_deltas" or "negative_counts", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	NegativeDeltas []int64
	NegativeCounts []float64
	// Positive Buckets.
	PositiveSpans []*BucketSpan
	// Use either "positive_deltas" or "positive_counts", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	PositiveDeltas []int64
	PositiveCounts []float64
	ResetHint      Histogram_ResetHint
	// timestamp is in ms format, see model/timestamp/timestamp.go for
	// conversion from time.Time to Prometheus timestamp.
	Timestamp int64
	// custom_values are not part of the specification, DO NOT use in remote write clients.
	// Used only for converting from OpenTelemetry to Prometheus internally.
	CustomValues []float64
}

func (b0 Histogram_builder) Build() *Histogram {
	m0 := &Histogram{}
	b, x := &b0, m0
	_, _ = b, x
	if b.CountInt != nil {
		x.Count = &Histogram_CountInt{*b.CountInt}
	}
	if b.CountFloat != nil {
		x.Count = &Histogram_CountFloat{*b.CountFloat}
	}
	x.Sum = b.Sum
	x.Schema = b.Schema
	x.ZeroThreshold = b.ZeroThreshold
	if b.ZeroCountInt != nil {
		x.ZeroCount = &Histogram_ZeroCountInt{*b.ZeroCountInt}
	}
	if b.ZeroCountFloat != nil {
		x.ZeroCount = &Histogram_ZeroCountFloat{*b.ZeroCountFloat}
	}
	x.NegativeSpans = b.NegativeSpans
	x.NegativeDeltas = b.NegativeDeltas
	x.NegativeCounts = b.NegativeCounts
	x.PositiveSpans = b.PositiveSpans
	x.PositiveDeltas = b.PositiveDeltas
	x.PositiveCounts = b.PositiveCounts
	x.ResetHint = b.ResetHint
	x.Timestamp = b.Timestamp
	x.CustomValues = b.CustomValues
	return m0
}

type case_Histogram_Count protoreflect.FieldNumber

func (x case_Histogram_Count) String() string {
	md := file_types_proto_msgTypes[3].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_Histogram_ZeroCount protoreflect.FieldNumber

func (x case_Histogram_ZeroCount) String() string {
	md := file_types_proto_msgTypes[3].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isHistogram_Count interface {
	isHistogram_Count()
}

type Histogram_CountInt struct {
	CountInt uint64 `protobuf:"varint,1,opt,name=count_int,json=countInt,proto3,oneof"`
}

type Histogram_CountFloat struct {
	CountFloat float64 `protobuf:"fixed64,2,opt,name=count_float,json=countFloat,proto3,oneof"`
}

func (*Histogram_CountInt) isHistogram_Count() {}

func (*Histogram_CountFloat) isHistogram_Count() {}

type isHistogram_ZeroCount interface {
	isHistogram_ZeroCount()
}

type Histogram_ZeroCountInt struct {
	ZeroCountInt uint64 `protobuf:"varint,6,opt,name=zero_count_int,json=zeroCountInt,proto3,oneof"`
}

type Histogram_ZeroCountFloat struct {
	ZeroCountFloat float64 `protobuf:"fixed64,7,opt,name=zero_count_float,json=zeroCountFloat,proto3,oneof"`
}

func (*Histogram_ZeroCountInt) isHistogram_ZeroCount() {}

func (*Histogram_ZeroCountFloat) isHistogram_ZeroCount() {}

// A BucketSpan defines a number of consecutive buckets with their
// offset. Logically, it would be more straightforward to include the
// bucket counts in the Span. However, the protobuf representation is
// more compact in the way the data is structured here (with all the
// buckets in a single array separate from the Spans).
type BucketSpan struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	Offset        int32                  `protobuf:"zigzag32,1,opt,name=offset,proto3" json:"offset,omitempty"` // Gap to previous span, or starting point for 1st span (which can be negative).
	Length        uint32                 `protobuf:"varint,2,opt,name=length,proto3" json:"length,omitempty"`   // Length of consecutive buckets.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BucketSpan) Reset() {
	*x = BucketSpan{}
	mi := &file_types_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BucketSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketSpan) ProtoMessage() {}

func (x *BucketSpan) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *BucketSpan) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *BucketSpan) GetLength() uint32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *BucketSpan) SetOffset(v int32) {
	x.Offset = v
}

func (x *BucketSpan) SetLength(v uint32) {
	x.Length = v
}

type BucketSpan_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Offset int32
	Length uint32
}

func (b0 BucketSpan_builder) Build() *BucketSpan {
	m0 := &BucketSpan{}
	b, x := &b0, m0
	_, _ = b, x
	x.Offset = b.Offset
	x.Length = b.Length
	return m0
}

// TimeSeries represents samples and labels for a single time series.
type TimeSeries struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// For a timeseries to be valid, and for the samples and exemplars
	// to be ingested by the remote system properly, the labels field is required.
	Labels        []*Label     `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	Samples       []*Sample    `protobuf:"bytes,2,rep,name=samples,proto3" json:"samples,omitempty"`
	Exemplars     []*Exemplar  `protobuf:"bytes,3,rep,name=exemplars,proto3" json:"exemplars,omitempty"`
	Histograms    []*Histogram `protobuf:"bytes,4,rep,name=histograms,proto3" json:"histograms,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TimeSeries) Reset() {
	*x = TimeSeries{}
	mi := &file_types_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimeSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeries) ProtoMessage() {}

func (x *TimeSeries) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TimeSeries) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *TimeSeries) GetSamples() []*Sample {
	if x != nil {
		return x.Samples
	}
	return nil
}

func (x *TimeSeries) GetExemplars() []*Exemplar {
	if x != nil {
		return x.Exemplars
	}
	return nil
}

func (x *TimeSeries) GetHistograms() []*Histogram {
	if x != nil {
		return x.Histograms
	}
	return nil
}

func (x *TimeSeries) SetLabels(v []*Label) {
	x.Labels = v
}

func (x *TimeSeries) SetSamples(v []*Sample) {
	x.Samples = v
}

func (x *TimeSeries) SetExemplars(v []*Exemplar) {
	x.Exemplars = v
}

func (x *TimeSeries) SetHistograms(v []*Histogram) {
	x.Histograms = v
}

type TimeSeries_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// For a timeseries to be valid, and for the samples and exemplars
	// to be ingested by the remote system properly, the labels field is required.
	Labels     []*Label
	Samples    []*Sample
	Exemplars  []*Exemplar
	Histograms []*Histogram
}

func (b0 TimeSeries_builder) Build() *TimeSeries {
	m0 := &TimeSeries{}
	b, x := &b0, m0
	_, _ = b, x
	x.Labels = b.Labels
	x.Samples = b.Samples
	x.Exemplars = b.Exemplars
	x.Histograms = b.Histograms
	return m0
}

type Label struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value         string                 `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Label) Reset() {
	*x = Label{}
	mi := &file_types_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Label) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label) ProtoMessage() {}

func (x *Label) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Label) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Label) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Label) SetName(v string) {
	x.Name = v
}

func (x *Label) SetValue(v string) {
	x.Value = v
}

type Label_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name  string
	Value string
}

func (b0 Label_builder) Build() *Label {
	m0 := &Label{}
	b, x := &b0, m0
	_, _ = b, x
	x.Name = b.Name
	x.Value = b.Value
	return m0
}

type Labels struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	Labels        []*Label               `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Labels) Reset() {
	*x = Labels{}
	mi := &file_types_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Labels) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Labels) ProtoMessage() {}

func (x *Labels) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Labels) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Labels) SetLabels(v []*Label) {
	x.Labels = v
}

type Labels_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Labels []*Label
}

func (b0 Labels_builder) Build() *Labels {
	m0 := &Labels{}
	b, x := &b0, m0
	_, _ = b, x
	x.Labels = b.Labels
	return m0
}

// Matcher specifies a rule, which can match or set of labels or not.
type LabelMatcher struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	Type          LabelMatcher_Type      `protobuf:"varint,1,opt,name=type,proto3,enum=prometheus.LabelMatcher_Type" json:"type,omitempty"`
	Name          string                 `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Value         string                 `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LabelMatcher) Reset() {
	*x = LabelMatcher{}
	mi := &file_types_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelMatcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelMatcher) ProtoMessage() {}

func (x *LabelMatcher) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *LabelMatcher) GetType() LabelMatcher_Type {
	if x != nil {
		return x.Type
	}
	return LabelMatcher_EQ
}

func (x *LabelMatcher) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LabelMatcher) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *LabelMatcher) SetType(v LabelMatcher_Type) {
	x.Type = v
}

func (x *LabelMatcher) SetName(v string) {
	x.Name = v
}

func (x *LabelMatcher) SetValue(v string) {
	x.Value = v
}

type LabelMatcher_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Type  LabelMatcher_Type
	Name  string
	Value string
}

func (b0 LabelMatcher_builder) Build() *LabelMatcher {
	m0 := &LabelMatcher{}
	b, x := &b0, m0
	_, _ = b, x
	x.Type = b.Type
	x.Name = b.Name
	x.Value = b.Value
	return m0
}

type ReadHints struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	StepMs        int64                  `protobuf:"varint,1,opt,name=step_ms,json=stepMs,proto3" json:"step_ms,omitempty"`    // Query step size in milliseconds.
	Func          string                 `protobuf:"bytes,2,opt,name=func,proto3" json:"func,omitempty"`                       // String representation of surrounding function or aggregation.
	StartMs       int64                  `protobuf:"varint,3,opt,name=start_ms,json=startMs,proto3" json:"start_ms,omitempty"` // Start time in milliseconds.
	EndMs         int64                  `protobuf:"varint,4,opt,name=end_ms,json=endMs,proto3" json:"end_ms,omitempty"`       // End time in milliseconds.
	Grouping      []string               `protobuf:"bytes,5,rep,name=grouping,proto3" json:"grouping,omitempty"`               // List of label names used in aggregation.
	By            bool                   `protobuf:"varint,6,opt,name=by,proto3" json:"by,omitempty"`                          // Indicate whether it is without or by.
	RangeMs       int64                  `protobuf:"varint,7,opt,name=range_ms,json=rangeMs,proto3" json:"range_ms,omitempty"` // Range vector selector range in milliseconds.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadHints) Reset() {
	*x = ReadHints{}
	mi := &file_types_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadHints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadHints) ProtoMessage() {}

func (x *ReadHints) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ReadHints) GetStepMs() int64 {
	if x != nil {
		return x.StepMs
	}
	return 0
}

func (x *ReadHints) GetFunc() string {
	if x != nil {
		return x.Func
	}
	return ""
}

func (x *ReadHints) GetStartMs() int64 {
	if x != nil {
		return x.StartMs
	}
	return 0
}

func (x *ReadHints) GetEndMs() int64 {
	if x != nil {
		return x.EndMs
	}
	return 0
}

func (x *ReadHints) GetGrouping() []string {
	if x != nil {
		return x.Grouping
	}
	return nil
}

func (x *ReadHints) GetBy() bool {
	if x != nil {
		return x.By
	}
	return false
}

func (x *ReadHints) GetRangeMs() int64 {
	if x != nil {
		return x.RangeMs
	}
	return 0
}

func (x *ReadHints) SetStepMs(v int64) {
	x.StepMs = v
}

func (x *ReadHints) SetFunc(v string) {
	x.Func = v
}

func (x *ReadHints) SetStartMs(v int64) {
	x.StartMs = v
}

func (x *ReadHints) SetEndMs(v int64) {
	x.EndMs = v
}

func (x *ReadHints) SetGrouping(v []string) {
	x.Grouping = v
}

func (x *ReadHints) SetBy(v bool) {
	x.By = v
}

func (x *ReadHints) SetRangeMs(v int64) {
	x.RangeMs = v
}

type ReadHints_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	StepMs   int64
	Func     string
	StartMs  int64
	EndMs    int64
	Grouping []string
	By       bool
	RangeMs  int64
}

func (b0 ReadHints_builder) Build() *ReadHints {
	m0 := &ReadHints{}
	b, x := &b0, m0
	_, _ = b, x
	x.StepMs = b.StepMs
	x.Func = b.Func
	x.StartMs = b.StartMs
	x.EndMs = b.EndMs
	x.Grouping = b.Grouping
	x.By = b.By
	x.RangeMs = b.RangeMs
	return m0
}

// Chunk represents a TSDB chunk.
// Time range [min, max] is inclusive.
type Chunk struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	MinTimeMs     int64                  `protobuf:"varint,1,opt,name=min_time_ms,json=minTimeMs,proto3" json:"min_time_ms,omitempty"`
	MaxTimeMs     int64                  `protobuf:"varint,2,opt,name=max_time_ms,json=maxTimeMs,proto3" json:"max_time_ms,omitempty"`
	Type          Chunk_Encoding         `protobuf:"varint,3,opt,name=type,proto3,enum=prometheus.Chunk_Encoding" json:"type,omitempty"`
	Data          []byte                 `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Chunk) Reset() {
	*x = Chunk{}
	mi := &file_types_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Chunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Chunk) ProtoMessage() {}

func (x *Chunk) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Chunk) GetMinTimeMs() int64 {
	if x != nil {
		return x.MinTimeMs
	}
	return 0
}

func (x *Chunk) GetMaxTimeMs() int64 {
	if x != nil {
		return x.MaxTimeMs
	}
	return 0
}

func (x *Chunk) GetType() Chunk_Encoding {
	if x != nil {
		return x.Type
	}
	return Chunk_UNKNOWN
}

func (x *Chunk) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Chunk) SetMinTimeMs(v int64) {
	x.MinTimeMs = v
}

func (x *Chunk) SetMaxTimeMs(v int64) {
	x.MaxTimeMs = v
}

func (x *Chunk) SetType(v Chunk_Encoding) {
	x.Type = v
}

func (x *Chunk) SetData(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.Data = v
}

type Chunk_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	MinTimeMs int64
	MaxTimeMs int64
	Type      Chunk_Encoding
	Data      []byte
}

func (b0 Chunk_builder) Build() *Chunk {
	m0 := &Chunk{}
	b, x := &b0, m0
	_, _ = b, x
	x.MinTimeMs = b.MinTimeMs
	x.MaxTimeMs = b.MaxTimeMs
	x.Type = b.Type
	x.Data = b.Data
	return m0
}

// ChunkedSeries represents single, encoded time series.
type ChunkedSeries struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Labels should be sorted.
	Labels []*Label `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// Chunks will be in start time order and may overlap.
	Chunks        []*Chunk `protobuf:"bytes,2,rep,name=chunks,proto3" json:"chunks,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChunkedSeries) Reset() {
	*x = ChunkedSeries{}
	mi := &file_types_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChunkedSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChunkedSeries) ProtoMessage() {}

func (x *ChunkedSeries) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ChunkedSeries) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ChunkedSeries) GetChunks() []*Chunk {
	if x != nil {
		return x.Chunks
	}
	return nil
}

func (x *ChunkedSeries) SetLabels(v []*Label) {
	x.Labels = v
}

func (x *ChunkedSeries) SetChunks(v []*Chunk) {
	x.Chunks = v
}

type ChunkedSeries_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Labels should be sorted.
	Labels []*Label
	// Chunks will be in start time order and may overlap.
	Chunks []*Chunk
}

func (b0 ChunkedSeries_builder) Build() *ChunkedSeries {
	m0 := &ChunkedSeries{}
	b, x := &b0, m0
	_, _ = b, x
	x.Labels = b.Labels
	x.Chunks = b.Chunks
	return m0
}

var File_types_proto protoreflect.FileDescriptor

const file_types_proto_rawDesc = "" +
	"\n" +
	"\vtypes.proto\x12\n" +
	"prometheus\x1a\x14gogoproto/gogo.proto\"\x9c\x02\n" +
	"\x0eMetricMetadata\x129\n" +
	"\x04type\x18\x01 \x01(\x0e2%.prometheus.MetricMetadata.MetricTypeR\x04type\x12,\n" +
	"\x12metric_family_name\x18\x02 \x01(\tR\x10metricFamilyName\x12\x12\n" +
	"\x04help\x18\x04 \x01(\tR\x04help\x12\x12\n" +
	"\x04unit\x18\x05 \x01(\tR\x04unit\"y\n" +
	"\n" +
	"MetricType\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\v\n" +
	"\aCOUNTER\x10\x01\x12\t\n" +
	"\x05GAUGE\x10\x02\x12\r\n" +
	"\tHISTOGRAM\x10\x03\x12\x12\n" +
	"\x0eGAUGEHISTOGRAM\x10\x04\x12\v\n" +
	"\aSUMMARY\x10\x05\x12\b\n" +
	"\x04INFO\x10\x06\x12\f\n" +
	"\bSTATESET\x10\a\"<\n" +
	"\x06Sample\x12\x14\n" +
	"\x05value\x18\x01 \x01(\x01R\x05value\x12\x1c\n" +
	"\ttimestamp\x18\x02 \x01(\x03R\ttimestamp\"o\n" +
	"\bExemplar\x12/\n" +
	"\x06labels\x18\x01 \x03(\v2\x11.prometheus.LabelB\x04\xc8\xde\x1f\x00R\x06labels\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x01R\x05value\x12\x1c\n" +
	"\ttimestamp\x18\x03 \x01(\x03R\ttimestamp\"\xf0\x05\n" +
	"\tHistogram\x12\x1d\n" +
	"\tcount_int\x18\x01 \x01(\x04H\x00R\bcountInt\x12!\n" +
	"\vcount_float\x18\x02 \x01(\x01H\x00R\n" +
	"countFloat\x12\x10\n" +
	"\x03sum\x18\x03 \x01(\x01R\x03sum\x12\x16\n" +
	"\x06schema\x18\x04 \x01(\x11R\x06schema\x12%\n" +
	"\x0ezero_threshold\x18\x05 \x01(\x01R\rzeroThreshold\x12&\n" +
	"\x0ezero_count_int\x18\x06 \x01(\x04H\x01R\fzeroCountInt\x12*\n" +
	"\x10zero_count_float\x18\a \x01(\x01H\x01R\x0ezeroCountFloat\x12C\n" +
	"\x0enegative_spans\x18\b \x03(\v2\x16.prometheus.BucketSpanB\x04\xc8\xde\x1f\x00R\rnegativeSpans\x12'\n" +
	"\x0fnegative_deltas\x18\t \x03(\x12R\x0enegativeDeltas\x12'\n" +
	"\x0fnegative_counts\x18\n" +
	" \x03(\x01R\x0enegativeCounts\x12C\n" +
	"\x0epositive_spans\x18\v \x03(\v2\x16.prometheus.BucketSpanB\x04\xc8\xde\x1f\x00R\rpositiveSpans\x12'\n" +
	"\x0fpositive_deltas\x18\f \x03(\x12R\x0epositiveDeltas\x12'\n" +
	"\x0fpositive_counts\x18\r \x03(\x01R\x0epositiveCounts\x12>\n" +
	"\n" +
	"reset_hint\x18\x0e \x01(\x0e2\x1f.prometheus.Histogram.ResetHintR\tresetHint\x12\x1c\n" +
	"\ttimestamp\x18\x0f \x01(\x03R\ttimestamp\x12#\n" +
	"\rcustom_values\x18\x10 \x03(\x01R\fcustomValues\"4\n" +
	"\tResetHint\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\a\n" +
	"\x03YES\x10\x01\x12\x06\n" +
	"\x02NO\x10\x02\x12\t\n" +
	"\x05GAUGE\x10\x03B\a\n" +
	"\x05countB\f\n" +
	"\n" +
	"zero_count\"<\n" +
	"\n" +
	"BucketSpan\x12\x16\n" +
	"\x06offset\x18\x01 \x01(\x11R\x06offset\x12\x16\n" +
	"\x06length\x18\x02 \x01(\rR\x06length\"\xe8\x01\n" +
	"\n" +
	"TimeSeries\x12/\n" +
	"\x06labels\x18\x01 \x03(\v2\x11.prometheus.LabelB\x04\xc8\xde\x1f\x00R\x06labels\x122\n" +
	"\asamples\x18\x02 \x03(\v2\x12.prometheus.SampleB\x04\xc8\xde\x1f\x00R\asamples\x128\n" +
	"\texemplars\x18\x03 \x03(\v2\x14.prometheus.ExemplarB\x04\xc8\xde\x1f\x00R\texemplars\x12;\n" +
	"\n" +
	"histograms\x18\x04 \x03(\v2\x15.prometheus.HistogramB\x04\xc8\xde\x1f\x00R\n" +
	"histograms\"1\n" +
	"\x05Label\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\"9\n" +
	"\x06Labels\x12/\n" +
	"\x06labels\x18\x01 \x03(\v2\x11.prometheus.LabelB\x04\xc8\xde\x1f\x00R\x06labels\"\x95\x01\n" +
	"\fLabelMatcher\x121\n" +
	"\x04type\x18\x01 \x01(\x0e2\x1d.prometheus.LabelMatcher.TypeR\x04type\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x14\n" +
	"\x05value\x18\x03 \x01(\tR\x05value\"(\n" +
	"\x04Type\x12\x06\n" +
	"\x02EQ\x10\x00\x12\a\n" +
	"\x03NEQ\x10\x01\x12\x06\n" +
	"\x02RE\x10\x02\x12\a\n" +
	"\x03NRE\x10\x03\"\xb1\x01\n" +
	"\tReadHints\x12\x17\n" +
	"\astep_ms\x18\x01 \x01(\x03R\x06stepMs\x12\x12\n" +
	"\x04func\x18\x02 \x01(\tR\x04func\x12\x19\n" +
	"\bstart_ms\x18\x03 \x01(\x03R\astartMs\x12\x15\n" +
	"\x06end_ms\x18\x04 \x01(\x03R\x05endMs\x12\x1a\n" +
	"\bgrouping\x18\x05 \x03(\tR\bgrouping\x12\x0e\n" +
	"\x02by\x18\x06 \x01(\bR\x02by\x12\x19\n" +
	"\brange_ms\x18\a \x01(\x03R\arangeMs\"\xd1\x01\n" +
	"\x05Chunk\x12\x1e\n" +
	"\vmin_time_ms\x18\x01 \x01(\x03R\tminTimeMs\x12\x1e\n" +
	"\vmax_time_ms\x18\x02 \x01(\x03R\tmaxTimeMs\x12.\n" +
	"\x04type\x18\x03 \x01(\x0e2\x1a.prometheus.Chunk.EncodingR\x04type\x12\x12\n" +
	"\x04data\x18\x04 \x01(\fR\x04data\"D\n" +
	"\bEncoding\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\a\n" +
	"\x03XOR\x10\x01\x12\r\n" +
	"\tHISTOGRAM\x10\x02\x12\x13\n" +
	"\x0fFLOAT_HISTOGRAM\x10\x03\"q\n" +
	"\rChunkedSeries\x12/\n" +
	"\x06labels\x18\x01 \x03(\v2\x11.prometheus.LabelB\x04\xc8\xde\x1f\x00R\x06labels\x12/\n" +
	"\x06chunks\x18\x02 \x03(\v2\x11.prometheus.ChunkB\x04\xc8\xde\x1f\x00R\x06chunksB;Z9buf.build/gen/go/prometheus/prometheus/protocolbuffers/gob\x06proto3"

var file_types_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_types_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_types_proto_goTypes = []any{
	(MetricMetadata_MetricType)(0), // 0: prometheus.MetricMetadata.MetricType
	(Histogram_ResetHint)(0),       // 1: prometheus.Histogram.ResetHint
	(LabelMatcher_Type)(0),         // 2: prometheus.LabelMatcher.Type
	(Chunk_Encoding)(0),            // 3: prometheus.Chunk.Encoding
	(*MetricMetadata)(nil),         // 4: prometheus.MetricMetadata
	(*Sample)(nil),                 // 5: prometheus.Sample
	(*Exemplar)(nil),               // 6: prometheus.Exemplar
	(*Histogram)(nil),              // 7: prometheus.Histogram
	(*BucketSpan)(nil),             // 8: prometheus.BucketSpan
	(*TimeSeries)(nil),             // 9: prometheus.TimeSeries
	(*Label)(nil),                  // 10: prometheus.Label
	(*Labels)(nil),                 // 11: prometheus.Labels
	(*LabelMatcher)(nil),           // 12: prometheus.LabelMatcher
	(*ReadHints)(nil),              // 13: prometheus.ReadHints
	(*Chunk)(nil),                  // 14: prometheus.Chunk
	(*ChunkedSeries)(nil),          // 15: prometheus.ChunkedSeries
}
var file_types_proto_depIdxs = []int32{
	0,  // 0: prometheus.MetricMetadata.type:type_name -> prometheus.MetricMetadata.MetricType
	10, // 1: prometheus.Exemplar.labels:type_name -> prometheus.Label
	8,  // 2: prometheus.Histogram.negative_spans:type_name -> prometheus.BucketSpan
	8,  // 3: prometheus.Histogram.positive_spans:type_name -> prometheus.BucketSpan
	1,  // 4: prometheus.Histogram.reset_hint:type_name -> prometheus.Histogram.ResetHint
	10, // 5: prometheus.TimeSeries.labels:type_name -> prometheus.Label
	5,  // 6: prometheus.TimeSeries.samples:type_name -> prometheus.Sample
	6,  // 7: prometheus.TimeSeries.exemplars:type_name -> prometheus.Exemplar
	7,  // 8: prometheus.TimeSeries.histograms:type_name -> prometheus.Histogram
	10, // 9: prometheus.Labels.labels:type_name -> prometheus.Label
	2,  // 10: prometheus.LabelMatcher.type:type_name -> prometheus.LabelMatcher.Type
	3,  // 11: prometheus.Chunk.type:type_name -> prometheus.Chunk.Encoding
	10, // 12: prometheus.ChunkedSeries.labels:type_name -> prometheus.Label
	14, // 13: prometheus.ChunkedSeries.chunks:type_name -> prometheus.Chunk
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_types_proto_init() }
func file_types_proto_init() {
	if File_types_proto != nil {
		return
	}
	file_types_proto_msgTypes[3].OneofWrappers = []any{
		(*Histogram_CountInt)(nil),
		(*Histogram_CountFloat)(nil),
		(*Histogram_ZeroCountInt)(nil),
		(*Histogram_ZeroCountFloat)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_types_proto_rawDesc), len(file_types_proto_rawDesc)),
			NumEnums:      4,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_types_proto_goTypes,
		DependencyIndexes: file_types_proto_depIdxs,
		EnumInfos:         file_types_proto_enumTypes,
		MessageInfos:      file_types_proto_msgTypes,
	}.Build()
	File_types_proto = out.File
	file_types_proto_goTypes = nil
	file_types_proto_depIdxs = nil
}
