// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by client-gen. DO NOT EDIT.

package v0alpha1

import (
	context "context"

	provisioningv0alpha1 "github.com/grafana/grafana/apps/provisioning/pkg/apis/provisioning/v0alpha1"
	applyconfigurationprovisioningv0alpha1 "github.com/grafana/grafana/apps/provisioning/pkg/generated/applyconfiguration/provisioning/v0alpha1"
	scheme "github.com/grafana/grafana/apps/provisioning/pkg/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// HistoricJobsGetter has a method to return a HistoricJobInterface.
// A group's client should implement this interface.
type HistoricJobsGetter interface {
	HistoricJobs(namespace string) HistoricJobInterface
}

// HistoricJobInterface has methods to work with HistoricJob resources.
type HistoricJobInterface interface {
	Create(ctx context.Context, historicJob *provisioningv0alpha1.HistoricJob, opts v1.CreateOptions) (*provisioningv0alpha1.HistoricJob, error)
	Update(ctx context.Context, historicJob *provisioningv0alpha1.HistoricJob, opts v1.UpdateOptions) (*provisioningv0alpha1.HistoricJob, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, historicJob *provisioningv0alpha1.HistoricJob, opts v1.UpdateOptions) (*provisioningv0alpha1.HistoricJob, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*provisioningv0alpha1.HistoricJob, error)
	List(ctx context.Context, opts v1.ListOptions) (*provisioningv0alpha1.HistoricJobList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *provisioningv0alpha1.HistoricJob, err error)
	Apply(ctx context.Context, historicJob *applyconfigurationprovisioningv0alpha1.HistoricJobApplyConfiguration, opts v1.ApplyOptions) (result *provisioningv0alpha1.HistoricJob, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, historicJob *applyconfigurationprovisioningv0alpha1.HistoricJobApplyConfiguration, opts v1.ApplyOptions) (result *provisioningv0alpha1.HistoricJob, err error)
	HistoricJobExpansion
}

// historicJobs implements HistoricJobInterface
type historicJobs struct {
	*gentype.ClientWithListAndApply[*provisioningv0alpha1.HistoricJob, *provisioningv0alpha1.HistoricJobList, *applyconfigurationprovisioningv0alpha1.HistoricJobApplyConfiguration]
}

// newHistoricJobs returns a HistoricJobs
func newHistoricJobs(c *ProvisioningV0alpha1Client, namespace string) *historicJobs {
	return &historicJobs{
		gentype.NewClientWithListAndApply[*provisioningv0alpha1.HistoricJob, *provisioningv0alpha1.HistoricJobList, *applyconfigurationprovisioningv0alpha1.HistoricJobApplyConfiguration](
			"historicjobs",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *provisioningv0alpha1.HistoricJob { return &provisioningv0alpha1.HistoricJob{} },
			func() *provisioningv0alpha1.HistoricJobList { return &provisioningv0alpha1.HistoricJobList{} },
		),
	}
}
