---
date: 2025-01-21
slug: goreleaser-v2.6
categories: [announcements]
authors: [caarlos0]
---

# Announcing GoReleaser v2.6

Happy new year! The first release of the year is here!

<!-- more -->

Let's dig into some of the news!

## Bun and Deno

This release adds support for both Bun and Deno!
You can run `goreleaser init` in an existing project, and it should figure it
out from there!

If you want to see it in action, check out [example-bun][] and [example-deno][].

We aim to add support to more builders/languages in the coming releases.
You can join the discussion [in our Discord][discord].

## Use AI to increment your release notes

<!-- md:pro -->

You can now use ChatGPT, Anthropic, and Ollama to increment/change your release
notes.

The [default prompt](https://gist.github.com/caarlos0/419c8cb2bab28f7c53c7e228af3ab219)
instructs the assistant to write a introduction chapter and to join dependency
update commits, but I recommend you roll your own.

Usage is fairly simple, too:

```yaml title=".goreleaser.yaml"
changelog:
  ai:
    use: anthropic
    prompt:
      from_file:
        path: ./prompt.md
```

You can read the full docs [here](/customization/changelog).

## New macOS App Bundle capatilities

<!-- md:pro -->

On [macOS App Bundles](/customization/app_bundles), you may now set extra
files (and templated extra files), and use that to override your `Info.plist`
(which was previously generated by GoReleaser and impossible to replace):

```yaml title=".goreleaser.yaml"
app_bundles:
  - extra_files:
      - src: ./icon.png
        dst: Contents/Resources/icon.png
    templated_extra_files:
      - src: ./Info.plist
        dst: Contents/Info.plist
```

## New macOS signing features

The [native macOS signing](/customization/notarize) now allows you to set
the `entitlements`:

```yaml title=".goreleaser.yaml"
notarize:
  macos:
    - sign:
        entitlements: ./entitlements.xml
```

## New MSI features

The [MSI](/customization/msi) now allows to set`extensions`:

```yaml title=".goreleaser.yaml"
msi:
  - extensions:
      - '{{ if eq .Runtime.Goos "windows" }}WixUIExtension{{ end }}'
      - "WixUtilExtension"
```

## Archive multiple formats

Instead of repeating the archive section for each format, you may now set
`formats: [ all the formats you want ]`.
Incidentally, you may also use `format_override` to set multiple formats.

A use case for this is if you want to release as `tar.gz` for all OSs, but also
want a `zip` for Windows. You can then do:

```yaml title=".goreleaser.yaml"
archives:
  - formats:
      - tar.gz
    format_overrides:
      - goos: windows
        formats:
          - zip
          - tar.gz
```

## Announce enabled

All the [announcers](/customization/announce) `enabled` fields are
now templateable.

Example usage:

```yaml title=".goreleaser.yaml"
announce:
  mastodon:
    enabled: "{{ eq .Patch 0 }}" # only if new feature release!
    message_template: "#GoReleaser {{ .Tag }} is out! Check it out: https://github.com/goreleaser/goreleaser/releases/tag/{{ .Tag }}"
    server: https://fosstodon.org
```

## Nightlies for real

Our own nightly builds were being built weekly.
Now they are, in fact, running every night!
This should help users play with new features earlier.

## Other Highlights

Most of the work in this release was around multi-language support, but
nevertheless, we have a few other news:

#### New features

- **new**: `.Format` template variable in `archives` (only on [Pro][pro])
- **new**: Allow to template `release.make_latest`
- **new**: Set the `mtime` in `nfpms`
- **new**: We made a [maintainers page](/maintainers). Make sure to check
  it out!
- **deprecations**: we deprecated `archives.format` and
  `archives.format_overrides.format` in favor of
  `archives.formats` and `archives.format_overrides.formats`, respectively.
  [Details](/deprecations)

As always, bug fixes, dependency updates, housekeeping, and documentation
updates are included in this release as well.

## Other news

- GoReleaser now has ~14.1k stars and 417 contributors! Thanks, everyone!
- We eventually discuss new features in our Discord server. 
  [Join the conversation][discord]!
- nFPM had new releases as well, 
  [check it out](https://github.com/goreleaser/nfpm/releases).

## Download

You can [install][] or upgrade using your favorite package manager, or see the
full release notes and download the pre-compiled binaries [here][oss-rel] and
[here (for Pro)][pro-rel].

## Helping out

You can help by reporting issues, contributing features, documentation
improvements, and bug fixes.
You can also [sponsor the project](/sponsors), or get a
[GoReleaser Pro licence][pro].

[pro]: /pro
[install]: https://goreleaser.com/install
[pro-rel]: https://github.com/goreleaser/goreleaser-pro/releases/tag/v2.6.0-pro
[oss-rel]: https://github.com/goreleaser/goreleaser/releases/tag/v2.6.0
[discord]: https://goreleaser.com/discord
[example-deno]: https://github.com/goreleaser/example-deno/
[example-bun]: https://github.com/goreleaser/example-bun/
