package proposallineage

import (
	"strings"

	"github.com/git-town/git-town/v22/internal/git/gitdomain"
)

const spacesPerIndent = 2

func RenderTree(tree TreeNodeWithProposal, currentBranch gitdomain.LocalBranchName) string {
	var builder strings.Builder
	builder.WriteString("\n-------------------------\n")
	renderNode(&builder, tree, currentBranch, 0, false)
	builder.WriteString("\n<sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>\n")
	return builder.String()
}

func renderNode(builder *strings.Builder, node TreeNodeWithProposal, currentBranch gitdomain.LocalBranchName, depth int, foundCurrent bool) {
	if node.BranchOrAncestorHasProposal() || !foundCurrent {
		builder.WriteString(strings.Repeat(" ", depth*spacesPerIndent))
		builder.WriteString("- ")
		if proposal, hasProposal := node.Proposal.Get(); hasProposal {
			builder.WriteString(proposal.Data.Data().URL)
		} else {
			builder.WriteString(node.Branch.String())
		}
		isCurrentBranch := node.Branch == currentBranch && !foundCurrent
		if isCurrentBranch {
			builder.WriteString(" :point_left:")
			foundCurrent = true
		}
		builder.WriteString("\n")
	}
	for _, child := range node.Children {
		renderNode(builder, child, currentBranch, depth+1, foundCurrent)
	}
}
