package messages

const (
	AliasedCommands                  = "Aliased commands: %s\n"
	APIProposalFindStart             = "Finding proposal from %s into %s ... "
	APIProposalSearchStart           = "Finding all proposals for %s ... "
	APIProposalUpdateBody            = "Update body for %s ... "
	APIProposalUpdateStart           = "Updating proposal online ... "
	APIUnexpectedResultDataStructure = "unexpected result data structure"
	APIUpdateProposalSource          = "Updating source branch of proposal %s to %s ... "
	APIUpdateProposalTarget          = "Updating target branch of proposal %s to %s ... "
	AppendDetachedHead               = "please check out the branch to which you want to append a child"
	ArgumentUnknown                  = "unknown argument: %q"
	AuthenticationMissing            = "not logged in"
	AuthorizationMissing             = `cannot find "repo" scope: %v`
	AutoDetect                       = "auto-detect"
	AutoSync                         = "auto-sync: %s\n"

	BitbucketAppPasswordPrompt      = "Bitbucket App Password: "
	BitbucketAppPasswordResult      = "Bitbucket App Password: %s"
	BitbucketUsernamePrompt         = "Bitbucket username: "
	BitbucketUsernameResult         = "Bitbucket username: %s"
	BranchAlreadyExistsLocally      = "there is already a branch %s"
	BranchAlreadyExistsRemotely     = "there is already a branch %s at the %s remote"
	BranchAuthorMultiple            = "\nMultiple people authored the %s branch.\n\n"
	BranchCheckoutProblem           = "cannot check out branch %s: %w"
	BranchContainsMergeCommits      = "branch %s contains merge commits, please compress and try again"
	BranchCurrentProblem            = "cannot determine current branch: %w"
	BranchDeleted                   = "deleted branch %s"
	BranchDeletedAtRemote           = "branch %s was deleted at the remote"
	BranchDeletedHasUnmergedChanges = "Branch %s was deleted at the remote but the local branch contains unshipped changes.\nI am therefore not removing this branch. You can see the unshipped changes by running \"git town diff-parent\"."
	BranchDiffProblem               = "cannot determine if branch %s has unmerged commits: %w"
	BranchDoesntContainCommit       = "branch %s does not contain commit %s. Found commits %s"
	BranchDoesntExist               = "there is no branch %q"
	BranchHasWrongSHA               = "cannot reset branch %s to %s because it received additional commits in the meantime. It should have SHA %s but has %s"
	BranchInfoNoContent             = "BranchInfo has neither a local nor remote name"
	BranchInfoNotFound              = "cannot find branch info for %s"
	BranchInfosNotProvided          = "An opcode that requires BranchInfos was called from the Light engine"
	BranchIsAlreadyContribution     = "branch %s is already a contribution branch"
	BranchIsAlreadyObserved         = "branch %s is already observed"
	BranchIsAlreadyParked           = "branch %s is already parked"
	BranchIsAlreadyPrototype        = "branch %s is already a prototype branch"
	BranchIsNowContribution         = "branch %s is now a contribution branch\n"
	BranchIsNowFeature              = "branch %s is now a feature branch\n"
	BranchIsNowObserved             = "branch %s is now an observed branch\n"
	BranchIsNowParked               = "branch %s is now parked\n"
	BranchIsNowPerennial            = "branch %s is now perennial\n"
	BranchIsNowPrototype            = "branch %s is now a prototype branch\n"
	BranchLocalProblem              = "cannot determine whether the local branch %s exists: %w"
	BranchLocalSHAProblem           = "cannot determine SHA of local branch %s: %w"
	BranchNotAvailable              = "there is no other branch to switch to"
	BranchNotInSyncWithParent       = `branch %s is not in sync with its parent, please run "git town sync" and try again`
	BranchOtherWorktree             = `branch %s is active in another worktree`
	BranchParentChanged             = "branch %s is now a child of %s"
	BranchPrefixPrompt              = "Branch prefix: "
	BranchPrefixResult              = "Branch prefix: %s\n"
	BranchTypeCannotDetermine       = "cannot determine type of branch %s"
	BrowserOpen                     = "Please open in a browser: %s\n"

	CacheUnitialized                   = "using a cached value before initialization"
	CannotParse                        = "cannot parse %s: %w"
	CommandsRun                        = "Ran %d shell commands."
	CommitDetachedHead                 = "please check out a branch before committing"
	CommitDownNoAncestor               = "branch %s doesn't have the given ancestor"
	CommitIntoMainBranch               = "cannot commit into the main branch"
	CommitMessageProblem               = "cannot determine last commit message: %w"
	CommitNoBranchToCommitInto         = "please provide the branch to commit into"
	CommitsSelected                    = "%d commits selected"
	CommitWrongBranchType              = "cannot commit into branch %s because it is %v %s branch"
	CompletionTypeUnknown              = "unknown completion type: %q"
	CompressAlreadyOneCommit           = "branch %s has already just one commit"
	CompressBranchNoParent             = "cannot compress branch %s because it has no parent"
	CompressContributionBranch         = "you are merely contributing to branch %s and should leave compressing it to the branch owner"
	CompressDetachedHead               = "please check out the branch to compress"
	CompressIsPerennial                = "better not compress perennial branches"
	CompressNoBranchInfo               = "no branch info for branch %s"
	CompressNoCommits                  = "branch %s has no commits"
	CompressObservedBranch             = "you are merely observing branch %s and should leave compressing it to the branch owner"
	CompressParkedBranch               = "branch %s and should not compress it"
	CompressUnsynced                   = "please sync branch %s before compressing it"
	ConfigBranchTypeOverrideEmpty      = "removing empty branch type entry"
	ConfigDirUserCannotDetermine       = "cannot determine the user configuration directory: %w"
	ConfigFile                         = "config file"
	ConfigFileCannotRead               = "cannot read the configuration file %s: %w"
	ConfigFileInvalidContent           = "the configuration file %s does not contain TOML-formatted content: %w"
	ConfigLineageEmptyChild            = "removing empty lineage entry"
	ConfigLineageParentIsChild         = "removing lineage entry for %s because the parent is the child"
	ConfigMainbranchInConfigFile       = "please configure the main branch in the config file"
	ConfigNeeded                       = "Git Town needs to be configured\n\n"
	ConfigRemoveError                  = "unexpected error while removing the 'git-town' section from the Git configuration: %w"
	ConfigScopeUnknown                 = "unknown configuration scope"
	ConfigShipStrategyUnknown          = "unknown ship strategy in %s: %q"
	ConfigStorage                      = "Config storage: %s\n"
	ConfigSyncStrategyUnknown          = "unknown sync strategy: %q"
	ConflictDetectionProblem           = "cannot determine conflicts: %w"
	ConflictMerge                      = "git merge conflict"
	ConflictRebase                     = "git rebase conflict"
	ConnectorCannotSearchProposals     = "connector cannot search proposals"
	ConnectorCannotUpdateProposalBody  = "connector cannot update proposal body"
	ContinueMessage                    = `You can run "git town continue" to finish it.`
	ContinueNothingToDo                = "nothing to continue"
	ContinueSkipGuidance               = "To continue by skipping the current branch, run \"git town skip\"."
	ContinueUnresolvedConflicts        = "you must resolve the conflicts before continuing"
	ContinueUntrackedChanges           = "please stage or commit the untracked changes first"
	ContributeBranchIsLocal            = "branch %s is local only - branches you want to contribute to must have a remote branch because they are per definition other people's branches"
	ContributeDetachedHead             = "please check out the branch you want to convert into a contribution branch"
	ContributionBranchCannotPark       = "cannot park contribution branches"
	ContributionBranchCannotPropose    = "cannot propose contribution branches"
	ContributionBranchCannotShip       = "cannot ship contribution branches"
	ContributionRegex                  = "Contribution regex: %s\n"
	ContributionRegexPrompt            = "Contribution regex: "
	ContributionRegexResult            = "Contribution regex: %s\n"
	CreatePrototypeBranchesDeprecation = `The Git Town configuration file contains the deprecated setting "create-prototype-branches".
Please upgrade to the new format: create.new-branch-type = "prototype"`
	CredentialsAccess            = "API token permits access to pull requests"
	CredentialsForgeUserName     = "Forge access as %s\n"
	CredentialsNoAccess          = "Credentials don't provide access: %s\n"
	CurrentBranchCannotDetermine = "cannot determine the current branch"

	DeleteCannotDeleteMainBranch        = "you cannot delete the main branch"
	DeleteCannotDeletePerennialBranches = "you cannot delete perennial branches"
	DeleteNoActiveBranch                = "please check out the branch to delete"
	DeleteRepoHasDetachedHead           = "please check out the branch to delete"
	DetachedResult                      = "Detached: %s\n"
	DetachNeedsSync                     = "please sync this stack before detaching branches from it"
	DetachNoActiveBranch                = "please check out the branch to detach"
	DetachNoParent                      = "cannot detach branches without parent"
	DetachOtherWorkTree                 = "cannot detach because branch %s it is active in another worktree"
	DetachRemoteBranch                  = "cannot detach a remote branch"
	DetachRepoHasDetachedHead           = "please check out the branch to detach"
	DetachUnsupportedBranchType         = "cannot detach %s branches since you don't own them"
	DevRemote                           = "Development remote: %s\n"
	DialogResultAll                     = "(all)"
	DialogResultNone                    = "(none)"
	DialogResultUnknownBranchType       = "unknown branch type defined in %s: %q"
	DialogUnexpectedResponse            = "unexpected response: %q"
	DialogUseGlobalValue                = "use global value (%s)"
	DiffConflictWithMain                = "conflicts between your uncommmitted changes and the main branch"
	DiffParentDetachedHead              = "please check out the branch to diff"
	DiffParentNoFeatureBranch           = "you can only diff-parent feature branches"
	DiffProblem                         = "cannot list diff of %s and %s: %w"
	DirCurrentProblem                   = "cannot determine the current directory"
	DownNoCurrentBranch                 = "you need to be on a branch to go down"
	DownNoParent                        = "branch %s has no parent"
	DryRun                              = "In dry run mode. No commands will be run. When run in normal mode, the command output will appear beneath the command. Some commands will only be run if necessary. For example: 'git push' will run if and only if there are local commits not on origin."

	FeatureDetachedHead          = "please check out the branch to make a feature branch"
	FeatureRegexPrompt           = "Feature regex: "
	FeatureRegexResult           = "Feature regex: %s\n"
	FileContentInvalidJSON       = "cannot parse JSON content of file %s: %w"
	FileDeleteProblem            = "cannot delete file %s: %w"
	FileReadProblem              = "cannot read file %s: %w"
	FileStatProblem              = "cannot check file %s: %w"
	FileWriteProblem             = "cannot write file %s: %w"
	Forge                        = "Forge: %s\n"
	ForgeAPITokenLocation        = "API token scope: %s\n"
	ForgeBitbucketMergingViaAPI  = "Bitbucket API: merging PR %s ... "
	ForgeBitbucketNotImplemented = "shipping pull requests via the Bitbucket API is currently not supported. If you need this functionality, please vote for it by opening a ticket at https://github.com/git-town/git-town/issues"
	ForgeForgejoMergingViaAPI    = "Forgejo API: merging PR %s ... "
	ForgeGiteaNotImplemented     = "shipping pull requests via the Gitea API is currently not supported. If you need this functionality, please vote for it by opening a ticket at https://github.com/git-town/git-town/issues"
	ForgeGiteaUpdatePRViaAPI     = "Gitea API: Updating base branch for PR #%d to #%s"
	ForgeGithubMergingViaAPI     = "GitHub API: merging PR %s ... "
	ForgeGitlabMergingViaAPI     = "Merging MR !%d ... "
	ForgeGitlabUpdateMRViaAPI    = "Updating target branch for MR !%d to %s ... "
	ForgejoTokenPrompt           = "Forgejo API token: "
	ForgejoTokenResult           = "Forgejo token: %s\n"
	ForgeTypeUnknown             = "unknown forge type defined in %s: %q"

	GitAnotherProcessIsRunningRetry = "another git process seems to be running in this repository, retrying in 1 sec ..."
	GitDirMissing                   = "cannot determine the '.git' directory: %w"
	GiteaTokenPrompt                = "Gitea token: "
	GiteaTokenResult                = "Gitea token: %s\n"
	GithubConnectorTypeResult       = "GitHub connector: %s\n"
	GithubConnectorTypeUnknown      = "unknown GithubConnectorType defined in %s: %q"
	GithubEnterpriseInitializeError = "cannot initialize GitHub Enterprise client: %q"
	GithubTokenPrompt               = "GitHub API token: "
	GithubTokenResult               = "GitHub token: %s\n"
	GitLabConnectorTypePrompt       = "GitLab connector: "
	GitlabConnectorTypeResult       = "GitLab connector: %s\n"
	GitlabConnectorTypeUnknown      = "unknown GitLabConnectorType defined in %s: %q"
	GitlabTokenPrompt               = "GitLab token: "
	GitlabTokenResult               = "GitLab token: %s\n"
	GitURLCannotParse               = "cannot parse Git URL %q"
	GitVersionMajorNotNumber        = "cannot convert major version %s to int: %w"
	GitVersionMinorNotNumber        = "cannot convert minor version %s to int: %w"
	GitVersionProblem               = "cannot determine Git version: %w"
	GitVersionTooLow                = "this app requires Git 2.30 or higher"
	GitVersionUnexpectedOutput      = "'git version' returned unexpected output: %q.\nPlease open an issue and supply the output of running 'git version'"

	HackBranchIsAlreadyFeature = "branch %s is already a feature branch"
	HackTooManyArguments       = "please provide only one branch to create"

	IgnoreUncommitted   = "Ship ignores uncommitted changes: %s\n"
	InputAddOrRemove    = `invalid argument %q. Please provide either "add" or "remove"`
	InputYesOrNo        = `invalid argument: %q. Please provide either "yes" or "no".\n`
	InvalidStatusOutput = `invalid "git status -z" output: %q`

	MainBranch                       = "Main branch: %s\n"
	MainBranchCannotMakeContribution = "cannot make the main branch a contribution branch"
	MainBranchCannotMakeFeature      = "cannot make the main branch a feature branch"
	MainBranchCannotObserve          = "cannot observe the main branch"
	MainBranchCannotPark             = "cannot park the main branch"
	MainBranchCannotPropose          = "cannot propose the main branch"
	MainBranchCannotPrototype        = "cannot prototype the main branch"
	MainBranchCannotShip             = "cannot ship the main branch"
	MainBranchNotFound               = "cannot find the main branch"
	MergeBranchNotLocal              = "cannot merge: branch %s is not local"
	MergeDetachedHead                = "please check out the branch to merge"
	MergeNoGrandParent               = "cannot merge branch %s because its parent branch %s has no parent"
	MergeNoParent                    = "cannot merge branch %s because it has no parent"
	MergeNotInSyncWithTracking       = `branch %s is not in sync with its tracking branch, please run "git town sync" and try again`
	MergeOpenChanges                 = "please commit or remove the open changes first"
	MergeWrongBranchType             = "cannot merge %s branches"

	NewBranchType = "New branch type:"

	ObserveBranchIsLocal        = "branch %s is local only - branches you want to observe must have a remote branch because they are per definition other people's branches"
	ObservedBranchCannotPark    = "cannot park observed branches"
	ObservedBranchCannotPropose = "cannot propose observed branches"
	ObservedBranchCannotShip    = "cannot ship observed branches"
	ObserveDetachedHead         = "please check out the branch to make observed"
	ObservedRegexCannotParse    = "unknown observed regex value %q defined in %s: %w"
	ObservedRegexPrompt         = "Observed regex: "
	ObservedRegexResult         = "Observed regex: %s\n"
	OfflineNotAllowed           = "this command requires an active internet connection"
	OpcodeNotRunnable           = "unrunnable opcode: %q"
	OpcodeUnknown               = "unknown opcode: %q, run \"git town status reset\" to reset it"
	OpenChangesProblem          = "cannot determine open changes: %w"
	Order                       = "Order: %s\n"
	OrderInvalid                = "invalid order defined in %s: %q"
	OriginHostnamePrompt        = "Origin hostname override: "
	OriginHostnameResult        = "Origin hostname: %s\n"

	ParentBranchTitle                       = `Parent branch for %s`
	ParkDetachedHead                        = "please check out the branch to park"
	ParkedRemoved                           = "branch %s is no longer parked"
	PerennialBranchCannotMakeContribution   = "cannot make perennial branches contribution branches"
	PerennialBranchCannotMakeFeature        = "cannot make perennial branches feature branches"
	PerennialBranchCannotObserve            = "cannot observe perennial branches"
	PerennialBranchCannotPark               = "cannot park perennial branches"
	PerennialBranchCannotPropose            = "cannot propose perennial branches"
	PerennialBranchCannotPrototype          = "cannot prototype perennial branches"
	PerennialBranchCannotShip               = "cannot ship perennial branches"
	PerennialBranches                       = "Perennial branches: %s\n"
	PerennialBranchRemovedParentEntry       = "Removed parent entry for perennial branch %s\n"
	PerennialRegexPrompt                    = "Perennial regex: "
	PerennialRegexResult                    = "Perennial regex: %s\n"
	PrependDetachedHead                     = "please check out the branch for which you want to prepend a parent"
	PreviousCommandFinished                 = "The previous Git Town command (%s) finished successfully.\n"
	PreviousCommandProblem                  = "The last Git Town command (%s) hit a problem %v ago.\n"
	ProposalBodyUpdateProblem               = "cannot update proposal body: %v"
	ProposalBreadcrumb                      = "Proposals display breadcrumb: %s\n"
	ProposalBreadcrumbInvalid               = "invalid value for proposal breadcrumb in %s: %q. Valid values are: none, stacks, branches"
	ProposalFindProblem                     = "cannot find proposal: %s"
	ProposalLineageUnsupportedForBranchType = "Proposal stack lineage unsupported for branch type %s"
	ProposalMultipleFromFound               = "found %d proposals for branch %s"
	ProposalMultipleFromToFound             = "found %d proposals from branch %s to branch %s"
	ProposalNoNumberGiven                   = "no proposal number given"
	ProposalNoParent                        = "branch %s has no parent and can therefore not be proposed"
	ProposalSourceCannotUpdate              = "cannot update the proposal source branch on your forge"
	ProposalTargetBranchUpdateProblem       = "cannot update the target branch of proposal %d on your forge"
	ProposalURLProblem                      = "cannot determine proposal URL from %s to %s: %w"
	ProposeDetached                         = "please check out the branch to propose"
	PrototypeDetachedHead                   = "please check out the branch to make a prototype branch"
	PrototypeRemoved                        = "branch %s is no longer a prototype branch"
	PullRequestDeprecation                  = `DEPRECATION NOTICE

This command has been renamed to "git town propose"
and will be removed in future versions of Git Town.`
	PushBranches               = "Push branches: %s\n"
	PushHook                   = "Push hook: %s\n"
	PushNewBranchesDeprecation = `The Git Town configuration file contains the deprecated setting "push-new-branches".
Please upgrade to the new format: share-new-branches = "push"`

	RebaseProblem           = "cannot determine rebase in progress: %w"
	RemoteExistsProblem     = "cannot determine if remote %s exists: %w"
	RemotesProblem          = "cannot determine remotes: %w"
	RenameBranchDeprecation = `DEPRECATION NOTICE

This command has been renamed to "git town rename"
and will be removed in future versions of Git Town.`
	RenameDetachedHead           = "please check out the branch to rename"
	RenameMainBranch             = "the main branch cannot be renamed"
	RenamePerennialBranchWarning = "%s is a perennial branch. Renaming a perennial branch typically requires other updates. If you are sure you want to do this, use '--force'"
	RenameToSameName             = "cannot rename branch to current name"
	RepoOutside                  = "this is not a Git repository"
	RunAutoUndo                  = "%s\nAuto-undo... "
	RunCommandProblem            = "error running command %q: %w"
	RunLogCannotOpen             = "cannot open runlog file %q: %w"
	RunLogCannotRead             = "cannot read runlog file %q: %w"
	RunLogCannotWrite            = "cannot write to runlog file %q: %w"
	RunLogDeleted                = "Runlog deleted."
	RunlogDisplaying             = "Displaying runlog at %s\n"
	RunLogDoesntExist            = "Runlog doesn't exist."
	RunLogSerializeProblem       = "cannot encode runlog: %w"
	RunstateDeleted              = "Runstate file deleted."
	RunstateDeleteProblem        = "cannot delete previous run state: %w"
	RunstateDoesntExist          = "Runstate file doesn't exist."
	RunstateLoadProblem          = "cannot load previous run state: %w"
	RunstateSaveProblem          = "cannot save run state: %w"
	RunstateSerializeProblem     = "cannot encode run-state: %w"

	SetParentNoFeatureBranch              = "the branch %s is not a feature branch. Only feature branches can have parent branches"
	SetParentNoneOption                   = "<none> (make perennial)"
	SetParentRepoHasDetachedHead          = "please check out the branch for which to set the parent"
	SettingCannotRemove                   = "ERROR: cannot remove %s Git setting %s: %v"
	SettingCannotWrite                    = "ERROR: cannot write %s Git setting %s: %v"
	SettingDeprecatedMessage              = "Upgrading deprecated %s setting %s to %s."
	SettingDeprecatedValueMessage         = "Upgrading value of %s Git alias %s from %s to %s."
	SettingIgnoreInvalid                  = "Notice: ignoring invalid dialog input setting %s\n"
	SettingSunsetBranchList               = "Inlining deprecated branch list %s"
	SettingSunsetDeleted                  = "Deleting obsolete setting %s"
	ShareNewBranches                      = "Share new branches: %s\n"
	ShipAPIConnectorRequired              = "please configure API access to your forge, more info at https://www.git-town.com/configuration#access-tokens"
	ShipAPIConnectorUnsupported           = "the Git Town driver for your forge does not support shipping via the API"
	ShipAPINoProposal                     = "cannot ship branch %s via API because it has no proposal"
	ShipAPINoRemoteBranch                 = "cannot ship branch %s via API because it has no remote branch"
	ShipBranchHasNoParent                 = "branch %s has no parent to ship into"
	ShipBranchIsInOtherWorktree           = "branch %s is checked out in another worktree, please ship from there"
	ShipBranchNothingToDo                 = "the branch %s has no shippable changes"
	ShipBranchOtherWorktree               = "branch %s is active in another worktree"
	ShipChildBranch                       = "shipping this branch would ship %s as well,\nplease ship %s first"
	ShipDeletesTrackingBranches           = "Ship deletes tracking branches: %s\n"
	ShipExitMergeError                    = "aborted because merge exited with error"
	ShipMessageWithFastForward            = "shipping with the fast-forward strategy does not use the given commit message"
	ShipNoBranchToShip                    = "please provide the branch to ship"
	ShipOpenChanges                       = "you have uncommitted changes. Did you mean to commit them before shipping?"
	ShipRepoHasDetachedHead               = "please check out the branch to ship"
	ShipStrategy                          = "Ship strategy: %s\n"
	ShipStrategyMissing                   = "no ship strategy provided"
	SkipBranchHasConflicts                = "cannot skip branch that resulted in conflicts"
	SkipMessage                           = `You can run "git town skip" to skip the currently failing operation.`
	SkipNoFinalBranchInfo                 = "found no information about branch %s in the final snapshot"
	SkipNoFinalSnapshot                   = "found no final snapshot"
	SkipNoInitialBranchInfo               = "found no information about branch %s in the initial snapshot"
	SkipNothingToDo                       = "nothing to skip"
	SquashCannotReadFile                  = "cannot read squash message file %s: %w"
	SquashCommitAuthorProblem             = "error getting squash commit author: %w"
	SquashCommitAuthorQuery               = "Please choose an author for the squash commit:"
	SquashCommitAuthorSelection           = "Selected squash commit author: %s\n"
	SquashMessageProblem                  = "cannot comment out the squash commit message: %w"
	StashResult                           = "Stash: %s\n"
	StatusFileNotFound                    = "No status file found for this repository."
	SwapNeedsCompress                     = "cannot swap because branch %s contains merge commits - please compress and try again"
	SwapNeedsSync                         = "please sync your branches before swapping"
	SwapNoGrandParent                     = "cannot swap a branch without grand-parent"
	SwapNoParent                          = "cannot swap a branch without parent"
	SwapOtherWorkTree                     = "cannot swap because branch %s it is active in another worktree"
	SwapParentNotLocal                    = "cannot swap: parent branch %s is not available locally"
	SwapParentWrongBranchType             = "cannot swap: branch %s is a %s branch"
	SwapRemoteBranch                      = "cannot swap: branch %s is remote"
	SwapRepoHasDetachedHead               = "please check out the branch to swap"
	SwapUnsupportedBranchType             = "cannot swap: branch %s is a %s branch"
	SwitchNoBranches                      = "no branches to switch to"
	SwitchUncommittedChanges              = "uncommitted changes"
	SyncFeatureBranches                   = "Sync feature branches: %s\n"
	SyncPerennialBranches                 = "Sync perennial branches: %s\n"
	SyncPerennialBranchHasUnpushedCommits = `cannot sync branch %s because it has unpushed local commits`
	SyncPrototypeBranches                 = "Sync prototype branches: %s\n"
	SyncRepoHasDetachedHead               = "please check out the branch to sync"
	SyncStatusNotRecognized               = "cannot determine the sync status for Git remote %s and branch name %s"
	SyncTags                              = "Sync tags: %s\n"
	SyncWithUpstream                      = "Sync with upstream: %s\n"

	UndoCannotRevertCommitOnPerennialBranch = "Cannot undo commit %s because it is on a perennial branch"
	UndoContinueGuidance                    = "\n\nTo continue after having resolved conflicts, run \"git town continue\".\nTo go back to where you started, run \"git town undo\".\n"
	UndoCreateOpcodeProblem                 = "cannot create undo operations for %q: %w"
	UndoMessage                             = `You can run "git town undo" to go back to where you started.`
	UndoNothingToDo                         = "nothing to undo"
	UnfinishedCommandHandle                 = "Handle unfinished command: %s\n"
	UnfinishedRunStateBoth                  = `Continue the old %s command and then run the current command`
	UnfinishedRunStateContinue              = "Continue the \"%s\" command after having resolved conflicts"
	UnfinishedRunStateDiscard               = "Discard the unfinished state and run the new command"
	UnfinishedRunStateQuit                  = "Quit without running anything"
	UnfinishedRunStateSkip                  = "Skip the current branch and continue the \"%s\" command on the next branch"
	UnfinishedRunStateUndo                  = "Undo the previous \"%s\" command"
	UnknownBranchType                       = "Unknown branch type: %s\n"
	UpdateProposalBodyUnsupported           = "the Git Town driver for your forge does not support updating the proposal body"
	UpNoChild                               = "branch %s has no children"
	UpNoCurrentBranch                       = "you need to be on a branch to go up"

	ValueInvalid = "invalid value for %s: %q. Please provide either \"yes\" or \"no\""

	WalkAllOrStack   = "please provide either --all or --stack"
	WalkDetachedHead = "please check out the branch from which to walk"
	WalkDone         = "Branch walk done."
	WalkNoDryRun     = "there is no dry-run mode for walking through branches on your shell, please call with a command to run on each branch"
)
