package dialog

import (
	"fmt"

	"github.com/git-town/git-town/v22/internal/cli/dialog/dialogcomponents"
	"github.com/git-town/git-town/v22/internal/cli/dialog/dialogcomponents/list"
	"github.com/git-town/git-town/v22/internal/cli/dialog/dialogdomain"
	"github.com/git-town/git-town/v22/internal/forge/forgedomain"
	"github.com/git-town/git-town/v22/internal/messages"
	. "github.com/git-town/git-town/v22/pkg/prelude"
)

const (
	gitlabConnectorTypeTitle = `GitLab connector`
	gitlabConnectorTypeHelp  = `
Git Town supports two ways to connect to GitLab:

1. GitLab API:
   Git Town talks directly with the GitLab API.
	 This uses an access token for your account
	 that you provide on the next screen.

2. GitLab's "glab" application:
   This doesn't require an access token
	 but you need to install and configure the glab tool.

`
)

func GitlabConnectorType(args Args[forgedomain.GitlabConnectorType]) (Option[forgedomain.GitlabConnectorType], dialogdomain.Exit, error) {
	entries := list.Entries[Option[forgedomain.GitlabConnectorType]]{}
	if global, hasGlobal := args.Global.Get(); hasGlobal {
		entries = append(entries, list.Entry[Option[forgedomain.GitlabConnectorType]]{
			Data: None[forgedomain.GitlabConnectorType](),
			Text: fmt.Sprintf(messages.DialogUseGlobalValue, global),
		})
	}
	entries = append(entries, list.Entries[Option[forgedomain.GitlabConnectorType]]{
		{
			Data: Some(forgedomain.GitlabConnectorTypeAPI),
			Text: "API token",
		},
		{
			Data: Some(forgedomain.GitlabConnectorTypeGlab),
			Text: "glab tool",
		},
	}...)
	cursor := entries.IndexOf(args.Local)
	selection, exit, err := dialogcomponents.RadioList(entries, cursor, gitlabConnectorTypeTitle, gitlabConnectorTypeHelp, args.Inputs, "gitlab-connector")
	fmt.Printf(messages.GitlabConnectorTypeResult, dialogcomponents.FormattedSelection(selection.GetOrZero().String(), exit))
	return selection, exit, err
}
