Feature: display all executed Git commands for the "compress" sync strategy

  Background:
    Given a Git repo with origin
    And the branches
      | NAME     | TYPE    | PARENT | LOCATIONS     |
      | branch-1 | feature | main   | local, origin |
      | branch-2 | feature | main   | local, origin |
    And the commits
      | BRANCH   | LOCATION      | MESSAGE         |
      | branch-1 | local, origin | branch-1 commit |
    And Git setting "git-town.sync-feature-strategy" is "compress"
    And origin deletes the "branch-2" branch
    And the current branch is "branch-2"
    When I run "git-town sync --verbose"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH   | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      | branch-2 | frontend | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |          | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git log main..branch-2 --format=%s --reverse                                                                                                                                                                                                                                                                                                     |
      |          | frontend | git checkout main                                                                                                                                                                                                                                                                                                                                |
      | main     | frontend | git branch -D branch-2                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git config --unset git-town-branch.branch-2.parent                                                                                                                                                                                                                                                                                               |
      |          | backend  | git config --unset git-town-branch.branch-2.branchtype                                                                                                                                                                                                                                                                                           |
      |          | backend  | git rev-parse --verify -q refs/heads/branch-2                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git rev-parse --verify -q refs/heads/branch-1                                                                                                                                                                                                                                                                                                    |
      |          | frontend | git checkout branch-1                                                                                                                                                                                                                                                                                                                            |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 27 shell commands.
      """
    And this lineage exists now
      """
      main
        branch-1
      """
    And the branches are now
      | REPOSITORY    | BRANCHES       |
      | local, origin | main, branch-1 |

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH   | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      |          | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |          | backend  | git config git-town-branch.branch-2.branchtype feature                                                                                                                                                                                                                                                                                           |
      |          | backend  | git config git-town-branch.branch-2.parent main                                                                                                                                                                                                                                                                                                  |
      | branch-1 | frontend | git branch branch-2 {{ sha 'initial commit' }}                                                                                                                                                                                                                                                                                                   |
      |          | backend  | git rev-parse --verify -q refs/heads/branch-2                                                                                                                                                                                                                                                                                                    |
      |          | frontend | git checkout branch-2                                                                                                                                                                                                                                                                                                                            |
    And Git Town prints:
      """
      Ran 18 shell commands.
      """
    And the initial branches and lineage exist now
