Feature: sync all branches and update proposals

  Background:
    Given a Git repo with origin
    And the origin is "git@github.com:git-town/git-town.git"
    And the branches
      | NAME     | TYPE    | PARENT | LOCATIONS     |
      | alpha    | feature | main   | local, origin |
      | beta     | feature | alpha  | local, origin |
      | gamma    | feature | beta   | local, origin |
      | branch-1 | feature | main   | local, origin |
    And the commits
      | BRANCH   | LOCATION      | MESSAGE         |
      | alpha    | local, origin | alpha commit    |
      | beta     | local, origin | beta commit     |
      | gamma    | local, origin | gamma commit    |
      | branch-1 | local, origin | branch-1 commit |
    And the proposals
      | ID | SOURCE BRANCH | TARGET BRANCH | TITLE             | BODY          | URL                      |
      | 1  | alpha         | main          | alpha proposal    | alpha body    | https://example.com/pr/1 |
      | 2  | beta          | alpha         | beta proposal     | beta body     | https://example.com/pr/2 |
      | 3  | gamma         | beta          | gamma proposal    | gamma body    | https://example.com/pr/3 |
      | 4  | branch-1      | main          | branch-1 proposal | branch-1 body | https://example.com/pr/4 |
    And Git setting "git-town.proposal-breadcrumb" is "stacks"
    And the current branch is "main"
    When I run "git-town sync --all"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH   | COMMAND                                                       |
      | main     | git fetch --prune --tags                                      |
      |          | git checkout alpha                                            |
      | alpha    | git checkout beta                                             |
      | beta     | git merge --no-edit --ff alpha                                |
      |          | git push                                                      |
      |          | git checkout gamma                                            |
      | gamma    | git merge --no-edit --ff beta                                 |
      |          | git push                                                      |
      |          | git checkout branch-1                                         |
      | branch-1 | git checkout main                                             |
      | main     | git push --tags                                               |
      |          | Finding all proposals for alpha ... main                      |
      |          | Finding proposal from alpha into main ... #1 (alpha proposal) |
      |          | Finding proposal from beta into alpha ... #2 (beta proposal)  |
      |          | Finding proposal from gamma into beta ... #3 (gamma proposal) |
      |          | Update body for #1 ... ok                                     |
      |          | Finding all proposals for beta ... alpha                      |
      |          | Finding proposal from alpha into main ... #1 (alpha proposal) |
      |          | Update body for #2 ... ok                                     |
      |          | Finding all proposals for branch-1 ... main                   |
      |          | Update body for #4 ... ok                                     |
      |          | Finding all proposals for gamma ... beta                      |
      |          | Finding proposal from beta into alpha ... #2 (beta proposal)  |
      |          | Update body for #3 ... ok                                     |
    And the initial branches and lineage exist now
    And the proposals are now
      """
      url: https://example.com/pr/1
      number: 1
      source: alpha
      target: main
      body:
        alpha body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1 :point_left:
            - https://example.com/pr/2
              - https://example.com/pr/3

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/2
      number: 2
      source: beta
      target: alpha
      body:
        beta body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1
            - https://example.com/pr/2 :point_left:
              - https://example.com/pr/3

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/3
      number: 3
      source: gamma
      target: beta
      body:
        gamma body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/1
            - https://example.com/pr/2
              - https://example.com/pr/3 :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/4
      number: 4
      source: branch-1
      target: main
      body:
        branch-1 body

        <!-- branch-stack-start -->

        <!-- branch-stack-end -->
      """
