Feature: swapping empty branches

  Background:
    Given a Git repo with origin
    And the branches
      | NAME     | TYPE    | PARENT   | LOCATIONS     |
      | branch-1 | feature | main     | local, origin |
      | branch-2 | feature | branch-1 | local, origin |
      | branch-3 | feature | branch-2 | local, origin |
    And the current branch is "branch-2"
    When I run "git-town swap"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH   | COMMAND                                                                           |
      | branch-2 | git fetch --prune --tags                                                          |
      |          | git rebase --onto main branch-1 --no-update-refs                                  |
      |          | git checkout branch-1                                                             |
      | branch-1 | git rebase --onto branch-2 main --no-update-refs                                  |
      |          | git checkout branch-3                                                             |
      | branch-3 | git rebase --onto branch-1 {{ sha-before-run 'initial commit' }} --no-update-refs |
      |          | git checkout branch-2                                                             |
    And these commits exist now
      | BRANCH | LOCATION | MESSAGE |
    And this lineage exists now
      | BRANCH   | PARENT   |
      | branch-1 | branch-2 |
      | branch-2 | main     |
      | branch-3 | branch-1 |

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs no commands
    And the initial commits exist now
    And the initial lineage exists now
