<!--
How to use this template:

- Make a copy of this file in the docs/ directory
- Set the name of the file to contain the next logical number and the name of the feature
- Fill out at least the Status, Motivation and Goals/Non-Goals fields.
- Open a PR to eksctl
- Merge early and iterate

For more tips see the Contributing docs: https://github.com/eksctl-io/eksctl/blob/master/CONTRIBUTING.md#proposals
-->

# Short, descriptive title

<!--
Keep the title short, simple, and descriptive. A good
title can help communicate what the proposal is and should be considered as part of
any review.
-->

## Authors

<!--
Who is responsible for this proposal? Who can answer questions?
-->

## Status

<!--
Can be just one word to help anyone understand where the proposal is in the process.
-->


<!--
The headings here are just starting points, add more as makes sense in what you
are proposing.
-->
## Table of Contents
<!-- toc -->
- [Summary](#summary)
- [Motivation](#motivation)
  - [Goals](#goals)
  - [Non-Goals](#non-goals)
  - [Linked Docs](#linked-docs)
- [Proposal](#proposal)
  - [User Stories (Optional)](#user-stories-optional)
    - [Story 1](#story-1)
    - [Story 2](#story-2)
  - [Notes/Constraints/Caveats (Optional)](#notesconstraintscaveats-optional)
  - [Risks and Mitigations](#risks-and-mitigations)
- [Design Details](#design-details)
  - [Test Plan](#test-plan)
  - [Graduation Criteria (Optional)](#graduation-criteria-optional)
  - [Migration Strategy (Optional)](#migration-strategy-optional)
- [Drawbacks (Optional)](#drawbacks-optional)
- [Alternatives](#alternatives)
- [Open Questions / Known Unknowns](#open-questions--known-unknowns)
- [Implementation Stages (Optional)](#implementation-stages-optional)
- [Success Metrics (Optional)](#success-metrics-optional)
<!-- /toc -->

<!--
Ensure the TOC is wrapped with
  <!-- toc --> and <!-- /toc -->
tags, and then generate with mdtoc https://github.com/kubernetes-sigs/mdtoc.
-->

## Summary

<!--
A good summary is at least a paragraph in length and should be written with a wide audience
in mind.

This TLDR should encompass the entire document, and serve as both future documentation
and as a quick reference for people coming by to learn the proposal's purpose
without reading the entire thing.
-->

## Motivation

<!--
This section is for explicitly listing the motivation, goals and non-goals of
this proposal. Describe why the change is important, how it fits into the project's
goals and the benefits to users.

It is helpful to frame this to answer the question: "What is the problem this proposal
is trying to solve?"
-->

### Goals

<!--
List the specific goals of the proposal. What is it trying to achieve? How will we
know that this has succeeded?
-->

### Non-Goals

<!--
What is out of scope for this proposal? Listing non-goals helps to focus discussion
and make progress.

It is important to remember that non-goals are still equally important things
which will be dealt with one day but are not things which need to be dealt with immediately
within the scope of this work. This helps make sure everyone is crystal clear on the outcomes.
-->

### Linked Docs

<!--
Provide links to previous discussions/threads, motivation issues or any other document
with context. It is really helpful to provide a "source of truth" for the work
so that people aren't searching all over the place for lost context.
-->

## Proposal

<!--
This is where we get down to the specifics of what the proposal actually is:
outlining your solution to the problem described in the Motivation section.
This should have enough detail that reviewers can understand exactly what
you're proposing, but should not include things like API designs or
implementation. The "Design Details" section below is for the real
nitty-gritty.
-->

### User Stories (Optional)

<!--
Detail the things that people will be able to do if this proposal is implemented.
Include as much detail as possible so that people can understand the "how" of
the system. The goal here is to make this feel real for users without getting
bogged down. Including CLI/config etc examples is a good was to illustrate this.
-->

#### Story 1

#### Story 2

### Notes/Constraints/Caveats (Optional)

<!--
What are the caveats to the proposal?
What are some important details that didn't come across above?
Go in to as much detail as necessary here.
This might be a good place to talk about core concepts and how they relate.
-->

### Risks and Mitigations

<!--
What are the risks of this proposal, and how do we mitigate?
What could get in the way of this solution being implemented the way we want?
(This is technical stuff: do not count natural disasters or pandemics.)
Think broadly.  For example, consider how this will impact or be impacted by other
things within the project as well as other components/APIs it interacts with.
-->

## Design Details

<!--
This section should contain enough information that the specifics of your
change are understandable. This may include API specs (though not always
required) or even code snippets. If there's any ambiguity about HOW your
proposal will be implemented, this is the place to discuss them.
-->

### Test Plan

<!--
This will almost always say "Everything covered by unit tests, main uses cases
covered by integration tests", but it is good to be very clear on goals.
-->

### Graduation Criteria (Optional)

<!--
List criteria which would allow progression from one maturity level to another.
eg. What needs to have been accomplished/demonstrated to move from Alpha to Beta.

If applicable, what is the milestone marker which will allow deprecation of the
replaced capability?
-->

### Migration Strategy (Optional)

<!--
How will this new implementation play with existing features?
How can we mitigate issues?
-->

## Drawbacks (Optional)

<!--
Why should the proposal NOT be implemented?
This is not to say we won't do it, but to acknowledge the "cons" of the argument.
Aka: devil's advocate.
-->

## Alternatives

<!--
What other approaches did you consider, and why did you rule them out? These do
not need to be as detailed as the proposal (pros and cons are fine),
but should include enough information to express the idea and why it was not acceptable
as well as illustrate why the final solution was selected.
-->

## Open Questions / Known Unknowns

<!--
List any questions for things you unsure about or to
direct reviewers to particular areas where their expertise is needed.
-->

## Implementation Stages (Optional)

<!--
This will usually be filled in when the work is broken down into Issues/tickets
and work can begin.
-->

## Success Metrics (Optional)

<!--
A little hard to do with a CLI tool, but it is always nice
to plan how you will learn about the success of a feature in the wild.
-->
