<?php
{{ $config := . }}
/**
 * This is a Backdrop settings.ddev.php file automatically generated by DDEV.
 * {{ $config.Signature }}: Automatically generated Backdrop settings.ddev.php file.
 * DDEV manages this file and may delete or overwrite the file unless this comment is removed.
 */

$host = "{{ $config.DatabaseHost }}";
$port = {{ $config.DatabasePort }};
$driver = "{{ $config.DatabaseDriver }}";

// If DDEV_PHP_VERSION is not set but IS_DDEV_PROJECT *is*, it means we're running (drush) on the host,
// so use the host-side bind port on docker IP
if (empty(getenv('DDEV_PHP_VERSION') && getenv('IS_DDEV_PROJECT') == "true")) {
  $host = "{{ $config.DockerIP }}";
  $port = {{ $config.DBPublishedPort }};
}

$database = "$driver://{{ $config.DatabaseUsername }}:{{ $config.DatabasePassword }}@$host:$port/{{ $config.DatabaseName }}";

$settings['hash_salt'] = '{{ $config.HashSalt }}';
