# Copyright 2023 The cert-manager Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

.PHONY: generate-versionchecker-testdata
## Generate versionchecker testdata
## @category Testing
generate-versionchecker-testdata: | $(NEEDS_GO)
	cd ./internal/versionchecker/test/testdata/ && \
		$(GO) run . \
			$(CURDIR)/internal/versionchecker/test/testdata/test_manifests.yaml \
			$(cert_manager_version)

shared_generate_targets += generate-versionchecker-testdata

.PHONY: test-unit
## Unit tests
## @category Testing
test-unit: | $(NEEDS_GO) $(NEEDS_GOTESTSUM) $(ARTIFACTS)
	KUBEBUILDER_ASSETS=$(CURDIR)/$(bin_dir)/tools \
	$(GOTESTSUM) \
		--junitfile=$(ARTIFACTS)/junit-go-e2e.xml \
		-- \
		-coverprofile=$(ARTIFACTS)/filtered.cov \
		./cmd/... ./internal/... ./pkg/... \
		-- \
		-ldflags $(go_cmctl_ldflags)

	$(GO) tool cover -html=$(ARTIFACTS)/filtered.cov -o=$(ARTIFACTS)/filtered.html
