package cmd

import (
	"github.com/carapace-sh/carapace"
	"github.com/carapace-sh/carapace-bin/pkg/actions/tools/golang"
	"github.com/spf13/cobra"
)

var rootCmd = &cobra.Command{
	Use:   "gonew",
	Short: "Gonew starts a new Go module by copying a template module",
	Long:  "https://pkg.go.dev/golang.org/x/tools/cmd/gonew",
	Run:   func(cmd *cobra.Command, args []string) {},
}

func Execute() error {
	return rootCmd.Execute()
}
func init() {
	carapace.Gen(rootCmd).Standalone()

	carapace.Gen(rootCmd).PositionalCompletion(
		golang.ActionModuleSearch(),
		golang.ActionModuleSearch(),
	)
}
