package fs

import (
	"github.com/carapace-sh/carapace"
	"github.com/carapace-sh/carapace/pkg/style"
)

// ActionFilenameExtensions completes filename extensions
//
//	3ds (3D Studio Graphics format)
//	3g2 (Mobile Phone Video)
func ActionFilenameExtensions() carapace.Action {
	// https://en.wikipedia.org/wiki/Filename_extension
	return carapace.ActionValuesDescribed(
		"3ds", "3D Studio Graphics format",
		"3ds", "cartridge for a Nintendo 3DS",
		"3g2", "Mobile Phone Video",
		"3gp", "Mobile Phone Video",
		"3mf", "3D Manufacturing Format",
		"7z", "A compressed archive file format",
		"accdb", "Microsoft Access Database",
		"accft", "Microsoft Access Data Type Template",
		"adame", "Adame Ransomware file",
		"adicht", "LabChart data acquisition file",
		"adt", "Abrechnungsdatentransfer, an xDT application",
		"adx", "Document",
		"adz", "Amiga Disk Zipped (See Amiga Disk File)",
		"agr", "ArcView ASCII grid",
		"ahk", "AutoHotkey script file",
		"ai", "Adobe Illustrator Artwork",
		"aiff", "Audio Interchange File Format",
		"aio", "APL programming language file transfer format file",
		"air", "Adobe AIR installation package",
		"akm", "Akai Multitimbral sample information file",
		"akp", "Akai Program sample information file",
		"alc", "Molecular coordinates",
		"ale", "Avid Log Exchange (used in film & video editing)",
		"all", "General printer information",
		"amf", "Additive Manufacturing File Format",
		"amg", "System image file",
		"aml", "AutomationML",
		"amlx", "Compressed and packed AutomationML file",
		"ampl", "AMPL source code file",
		"ani", "Animation cursors for Win",
		"ann", "Annotations of old Windows Help file",
		"ape", "Monkey's Audio (Lossless)",
		"apk", "Android Package Kit",
		"apk", "Alpine Linux Package",
		"ar", "Argon - for 3D Modeling",
		"arc", "ARC (file format)",
		"art", "Gerber format",
		"asax", "ASP.NET global application file",
		"ascx", "ASP.NET User Control",
		"asf", "Advanced Streaming Format (Compressed Windows audio/video)",
		"ashx", "ASP.NET handler file",
		"asm", "Assembler language source",
		"asx", "Advanced Stream Redirector file, redirects to an ASF file (see ASF)",
		"at3", "Atrac 3 Sound/music file",
		"aty", "Produced when an association type is exported by 3D Topicscape",
		"avi", "Audio Video Interleave",
		"awk", "AWK script/program",
		"axf", "lightweight geodatabase",
		"aep", "After effects project",
		"b", "BASIC language source",
		"b", "Grand Theft Auto 3 save file",
		"b", "bc arbitrary precision calculator language file",
		"bar", "Broker Archive. Compressed file containing number of other files for deployment.",
		"bas", "BASIC language source",
		"bat", "Batch file",
		"bdt", "Behandlungsdatentransfer, an xDT application",
		"beam", "Executable bytecode file in fat binary format",
		"bin", "binary file",
		"bm3", "UIQ3 Phone backup",
		"bmp", "OS/2 or Win graphics format (BitMap Picture)",
		"bps", "WPS backup file",
		"bz2", "Archive",
		"blend", "Blender project file",
		"c--", "C-- language source",
		"c", "C language source",
		"c", "Unix file archive",
		"c++", "C++ language source",
		"cpp", "C++ language source",
		"c32", "COMBOOT Executable (32-bit)",
		"cab", "Cabinet archive",
		"cbt", "COMBOOT Executable (incompatible with DOS COM files)",
		"cc", "C++ language source",
		"cd", "ASP.NET class diagram file",
		"cdf", "Common Data Format",
		"cdf", "Computable Document Format",
		"cdr", "Vector graphics format (drawinF",
		"cer", "Security certificate",
		"cgm", "Computer Graphics Metafile vector graphics",
		"chm", "Compiled Help File",
		"cho", "ChordPro lead sheet (lyrics and chords)",
		"cia", "Decrypted Nintendo 3DS ROM cartridge",
		"cif", "Crystallographic Information File",
		"class", "Java class file",
		"cmd", "Command Prompt batch file",
		"cmd", "executable programs",
		"cmod", "Celestia Model",
		"cn1", "CNR IDL",
		"coe", "Coefficient file",
		"compile", "ASP.NET precompiled stub file",
		"copac", "Copac bibliographic reference file",
		"cpc", "Compressed image",
		"cpl", "Control panel file",
		"cr2", "Raw image format",
		"crai", "CRAM index",
		"crdownload", "Chrome download file",
		"crt", "Security certificate",
		"cs", "C# language source",
		"csproj", "C# project file",
		"css", "cascading style sheet",
		"csv", "Comma Separated Values text file format (ASCII)",
		"d", "D Programming Language source file",
		"d", "Directory containing configuration files (informal standard)",
		"d3v", "Video file",
		"d4d", "Data",
		"d4p", "Data",
		"d64", "Commodore 64 disk image",
		"d88", "Toshiba Pasopeia D88 disk image format",
		"daa", "Direct Access Archive",
		"dae", "COLLADA file",
		"daf", "Data file",
		"dal", "Digidim system",
		"dart", "Dart (programming language) source file",
		"dat", "AMPL data file",
		"dat", "Maxum chromatograph chromatogram",
		"dat", "LDraw (Sub)Part File, 3D Model",
		"dat", "Document",
		"dat", "data",
		"dat", "Data file in special format or ASCII",
		"dat", "Database file",
		"dat", "Norton Utilities disc image data. It saves Boot sector, part of FAT and root directory in image.DAT on same drive.",
		"dat", "Optical disc image (can be ISO9660, but not restricted to)",
		"dat", "Video CD MPEG stream",
		"dat", "Windows registry hive (REG.DAT Windows 3.11; USER.DAT and SYSTEM.DAT Windows 95, 98, and ME; NTUSER.DAT Windows NT/2000/XP/7)",
		"dat", "Minecraft game data",
		"dats", "Dynamic source",
		"dav", "Proprietary DVR format",
		"db$", "Temperature debug info",
		"db$", "Temporary file",
		"db", "Database file",
		"db", "Configuration",
		"db", "Multi Edit config",
		"db2", "Database",
		"db3", "Database",
		"dba", "Database file",
		"dba", "DarkBasic source code",
		"dbc", "DataBaseContainer",
		"dbd", "Business data",
		"dbd", "Debug info",
		"dbf", "Database file",
		"dbfx", "DevBox Database File",
		"dbg", "Debugger script",
		"dbg", "Symbolic debugging information",
		"dbk", "Database backup",
		"dbl", "DIBOL source file",
		"dbl", "Design Block file",
		"dbm", "Datafile",
		"dbm", "Menu template",
		"dbo", "Compiled program",
		"dbpro", "DarkBasicPro Project",
		"dbs", "Data file used by Managing Your Money",
		"dbs", "Database in SQL Windows format",
		"dbs", "Datafile",
		"dbs", "Printer description file",
		"dbt", "FoxBASE+ style memo",
		"dbt", "Memo file for database w/same name",
		"dbw", "Windows file",
		"dbx", "DataBeam",
		"dbx", "AutoCAD Database",
		"dbx", "Archive File",
		"dc", "CAD drawing file",
		"dc6", "Image file",
		"dca", "Document Content Architecture text file",
		"dcc", "Animation",
		"dcd", "CAD Drawing File",
		"dch", "Schematic Drawing file",
		"dci", "Dreamcast Save File",
		"dcl", "Delphi Control Library",
		"dcm", "DCM music module",
		"dcp", "OS/2 device code page",
		"dcs", "Bitmap graphics (CYMK format)",
		"dcs", "Datafile",
		"dct", "Dictionary: used by many programs with program dependent format",
		"dct", "Spell checking dictionary",
		"dct", "DataBaseContainer Extension",
		"dcu", "Delphi unit (compiled)",
		"dcw", "Walter Machine Programing",
		"dcx", "Multi-page PCX graphics (common fax format)",
		"dcx", "DataBaseContainer Index",
		"dd", "Macintosh file archive",
		"dda", "Data",
		"ddb", "Bitmap graphics",
		"ddb", "Digidesign Database File",
		"ddd", "Building Diagram",
		"ddi", "Disk image",
		"ddp", "Device Driver Profile file",
		"dds", "DirectDraw Surface file",
		"deb", "Unix archive file (software package format)",
		"deb", "DEBUG script",
		"def", "Assembly header file",
		"def", "Defaults - definitions",
		"def", "Linker definition file",
		"dem", "Demonstration",
		"dem", "Digital Elevation Model",
		"dem", "Graphics file",
		"dem", "Vista DEM file",
		"der", "Security certificate",
		"des", "Ascii text parameter description",
		"desklink", "Windows Explorer Desktop Control",
		"desktop", "Desktop Entry",
		"dev", "Device driver",
		"dev", "SYSGEN handler build procedure",
		"dev", "Dev-C++ project file",
		"dex", "Dalvik executable",
		"dfd", "Data Flow Diagram graphic file",
		"dff", "RenderWare model data (e.g. Grand Theft Auto III and later)",
		"dff", "Audio file created by converting the audio format from an SACD. Normally found on torrenting sites like The Pirate Bay.",
		"dfi", "Outline font description",
		"dfl", "Default program settings",
		"dfm", "Data Flow Diagram model file",
		"dfm", "Delphi form module",
		"dfpwm", "Dynamic Filter Pulse Width Modulation (audio codec)",
		"dfs", "Delight Sound File",
		"dfti", "Dynamic Formatted Text and Images (Word Processing)",
		"dfv", "Printing form (Word)",
		"dfx", "Micrografx Effects DLL",
		"dgn", "Graphics file",
		"dgs", "Diagnostics",
		"dh", "Dependency information for .ph",
		"dhp", "Dr. Halo PIC Format graphics file",
		"dht", "Datafile",
		"di", "D Programming Language interface file",
		"dia", "Diagraph graphics file",
		"dib", "Device Independent Bitmap",
		"dic", "Dictionary (e.g. from WinWord)",
		"dicom", "Digital Imaging and Communications in Medicine (DICOM) bitmap",
		"dif", "Borland patch data file",
		"dif", "Data Interchange Format",
		"dif", "OS/2 V2.2 Display Information File",
		"dif", "Output from Diff command - script for Patch command",
		"dif", "SRCCOM, BINCOM output file",
		"dig", "Digilink",
		"dig", "Sound Designer 1 audio file",
		"dip", "Graphics",
		"dip", "Watcom debug info processor",
		"dip", "PCB Drawing file",
		"dir", "Dialing directory file",
		"dir", "Directory file",
		"dir", "Movie",
		"dir", "Directory listing file",
		"dired", "Directory listing (ls format)",
		"dis", "Distribution file",
		"dis", "Thesaurus",
		"diz", "Description file (Description In Zip)",
		"djvu", "DJVU Document Format, a format similar to PDF but with higher compression rates at the same quality.",
		"dkb", "Raytraced graphics",
		"dl", "Animation format (Italian origin)",
		"dlc", "JDownloader Link Container",
		"dld", "",
		"dlf", "Dialogue Live Format",
		"dlg", "Dialog resource script file",
		"dlg", "Dialog resources",
		"dlg", "Windows SDK dialog editor data file",
		"dlg", "Windows SDK dialog editor data file",
		"dll", "Dynamic-link library",
		"dll", "Export/import filter",
		"dlm", "Microsoft File Transfer Manager",
		"dlp", "Data",
		"dls", "Setup",
		"dmf", "Music format (Delusion Digital Music File)",
		"dmf", "DeleD files",
		"dmg", "Apple Disk Image",
		"dmo", "Demo",
		"dmp", "Dump file (e.g. screen or memory)",
		"dmp", "DUMP utility output file",
		"dn", "Dimension model format",
		"dng", "Digital Negative, a-publicly available archival format for the raw files generated by digital cameras",
		"doc", "A Document, or an ASCII text file with text formatting codes in with the text; used by many word processors",
		"docm", "Microsoft Word Macro-Enabled Document",
		"docx", "Microsoft Word Document",
		"dochtml", "Microsoft Word HTML Document",
		"docmhtml", "Microsoft Word MIME HTML Document",
		"dot", "Microsoft Word 97 - 2003 Template",
		"dotm", "Microsoft Word Macro-Enabled Template",
		"dotx", "Microsoft Word Template",
		"dothtml", "Microsoft Word HTML Template",
		"dof", "Delphi project options file",
		"dog", "Screen file",
		"doh", "Dependency information for .poh",
		"dol", "Nintendo Wii and GameCube proprietary executable format",
		"dor", "Roland Digital audio file",
		"dot", "Microsoft Word document template",
		"dotx", "Office Open XML Text document template",
		"download", "Download file",
		"dpf", "Debrief Plot File",
		"dpx", "Digital Moving Picture Exchange",
		"dru", "Design Rules",
		"ds", "Data file used by Adobe Dimension",
		"dsc", "Celestia Deep Space Catalog file",
		"dtd", "Document Type Definition",
		"dvc", "Data version control yaml pointer into blob storage",
		"dw2", "Drawing",
		"dwf", "Autodesk Design Web Format",
		"dwg", "Drawing",
		"dxf", "Drawing Interchange File Format vector graphics",
		"dxp", "SpotFire data",
		"dylib", "Mach shared library",
		"e", "E language source code",
		"e##", "EnCase Evidence File chunk",
		"e00", "ArcInfo interchange file",
		"e2d", "2-dimensional vector graphics file",
		"e57", "A file format developed by ASTM International for storing point clouds and images",
		"ebd", "versions of DOS system files (AUTOEXEC.BAT, COMMAND.COM, CONFIG.SYS, WINBOOT.SYS, etc. ) for an emergency boot disk",
		"ec", "Source code",
		"ecc", "Error-checking file",
		"ede", "Ensoniq EPS disk image",
		"edf", "European data format",
		"efi", "Extensible Firmware Interface",
		"eis", "EIS Spectrum Analyser Project",
		"el", "Emacs Lisp source code file",
		"elc", "Byte-compiled Emacs Lisp code",
		"elf", "Executable and Linkable File",
		"email", "Outlook Express Email Message",
		"emaker", "E language source code (maker)",
		"emf", "Microsoft Enhanced Metafile",
		"eml", "Stationery Template",
		"emz", "Microsoft Enhanced Metafile compressed with ZIP",
		"eot", "Embedded OpenType",
		"ep", "GUI wireframe/prototype project",
		"epa", "Award BIOS splash screen",
		"eps", "Encapsulated PostScript",
		"epub", "Electronic Publication - (e-Reader format)",
		"erl", "Erlang source code file",
		"es6", "ECMAScript 6 file",
		"escpcb", "Data file of \"esCAD pcb\", PCB Pattern Layout Design Software",
		"escsch", "Data file of \"esCAD sch\", Drawing Schematics Diagram Software",
		"esd", "Windows Imaging Format",
		"etl", "event trace log file",
		"evt", "Windows Event log file",
		"evtx", "Windows Event log file XML structured",
		"ex", "Elixir source code file",
		"exe", "Directly executable program",
		"exp", "Drawing File format",
		"exp", "Melco Embroidery Format",
		"exs", "Elixir script file",
		"ezw", "easyOFFER document file[67]",
		"f", "Forth language source code file",
		"f", "Fortran language source code file (in fixed form)",
		"f01", "Fax",
		"f03", "Fortran language source code file (in free form)",
		"f08", "Fortran language source code file (in free form)",
		"f18", "Fortran language source code file (in free form)",
		"f4", "Fortran IV source code file",
		"f4v", "A container format for Flash Video that differs from the older FLV file format (see also SWF)",
		"f77", "Fortran language source code file (in fixed form)",
		"f90", "Fortran language source code file (in free form)",
		"f95", "Fortran language source code file (in free form)",
		"fa", "FASTA format sequence file",
		"faa", "FASTA format amino acid",
		"fasta", "FASTA format sequence file",
		"fastq", "FASTQ format sequence file",
		"fb2", "FictionBook e-book 2.0 file (DRM-free XML format)",
		"fbx ", "3D model geometry, material textures, lighting, armature, and animation sequences for inter application use/transport",
		"fen", "Forsyth–Edwards Notation",
		"ff", "Farbfeld image",
		"ffn", "FASTA format nucleotide of gene regions",
		"fits", "Flexible Image Transport System",
		"fj", "FlipJump source code file.",
		"fjm", "FlipJump assembled memory file.",
		"flac", "Audio codec, Audio file format",
		"flame", "Fractal configuration file",
		"flv", "A container format for Flash Video (see also SWF)",
		"fna", "FASTA format nucleic acid",
		"fni", "FileNet Native Document",
		"fodg", "OpenDocument Flat XML Drawings and vector graphics",
		"fodp", "OpenDocument Flat XML Presentations",
		"fods", "OpenDocument Flat XML Spreadsheets",
		"fodt", "OpenDocument Flat XML Text Document",
		"for", "Fortran language source file",
		"frag", "Fragment File, usually stored on MOVPKG files",
		"frm", "MySQL Database Metadata",
		"fs", "F# source file",
		"fsb", "FSB file,  usually used by games like Minecraft to store soundtracks",
		"g3a", "Add-in file",
		"g3b", "Flipbook file",
		"g3e", "eActivity file",
		"g3k", "Manager PLUS Key-Log file",
		"g3l", "Language add-in file",
		"g3m", "Memory file",
		"g3p", "Picture Plot file",
		"gbr", "Gerber format",
		"gbs", "OtterUI binary scene format. UI library & tool specifically aimed at game developers.",
		"gdf", "General Data Format for Biomedical Signals",
		"gdt", "Gerätedatentransfer, an xDT application",
		"ged", "GEDCOM",
		"ggb", "GeoGebra File",
		"gif", "Compuserves' Graphics Interchange Format (bitmapped graphics)",
		"gmk", "GameMaker Project File",
		"gml", "Geography Markup Language File",
		"go", "Go source code file",
		"gpx", "GPS eXchange Format",
		"grp", "Data pack files for the Build Engine",
		"gtf", "Gene transfer format",
		"gv", "Graph Visualization",
		"gz", "gzip compressed data",
		"h!", "On-line help file",
		"h!", "Pertext database",
		"h--", "C-- language header",
		"h", "Header file (usually C language)",
		"h++", "Header file",
		"ha", "Archive",
		"hack", "Source file for the programming language hack",
		"har", "HTTP Archive format (JSON-format web-browser log)",
		"hdi", "Hard Disk Image file (PC-9800 disk image file)",
		"hdmp", "heap dumpfile",
		"hh", "C++ header file",
		"hof", "Basic Configuration file",
		"hpp", "C++ header file",
		"hta", "HTML Application",
		"htm", "see HTML",
		"html", "Hypertext Markup Language (WWW)",
		"hum", "3D Model database",
		"hxx", "C++ header file",
		"icc", "ICC profile",
		"ice", "LHA Archive",
		"ico", "Icon file",
		"ifc", "Industry Foundation Classes",
		"igc", "Flight tracks downloaded from GPS devices in the International Gliding Commission's prescribed format",
		"iges", "Initial Graphics Exchange Specification",
		"img", "disk IMaGe",
		"ini", "Configuration file",
		"io", "Archive",
		"ipa", "IOS packed application",
		"ipt", "XnView IPTC template",
		"irx", "IOP Relocatable eXecutable",
		"iso", "ISO-9660 table",
		"it", "Impulse Tracker music file",
		"jl", "Julia script file",
		"j2c", "JPEG 2000 image",
		"jar", "Java archive",
		"jav", "see JAVA",
		"java", "Java source code file",
		"jbig", "Joint Bilevel Image Group",
		"jnlp", "Java Network Launching Protocol",
		"jp2", "JPEG 2000 image",
		"jpeg", "Joint Photographic Experts Group graphics file format",
		"jpeg", "Joint Photographic Experts Group graphics file format",
		"jpeg", "Joint Photographic Group",
		"js", "JavaScript file",
		"json", "JSON (JavaScript Object Notation)",
		"jsp", "Jakarta Server Pages",
		"key", "Keynote Presentation",
		"kml", "Keyhole Markup Language",
		"kmz", "Keyhole Markup Language (Zip compressed)",
		"kra", "Krita image file",
		"kt", "Kotlin source code",
		"kve", "Key value",
		"label", "Dymo label file",
		"lbr", ".LBR Archive",
		"ldt", "Labordatenträger, an xDT application",
		"lha", "LHA Archive",
		"lisp", "LISP source code file",
		"ll", "LLVM Assembly Language",
		"lua", "Lua script file",
		"lvproj", "LabVIEW project file",
		"ly", "LilyPond Notation File",
		"lz", "Archive",
		"m", "MATLAB M-File",
		"m", "Mercury Source File",
		"m", "Source code",
		"mcf", "Multimedia Container Format (predecessor of Matroska)",
		"md", "Markdown-formatted text file",
		"mdf", "Master Data File, a Microsoft SQL Server file type",
		"mdf", "Measurement Data Format, a binary file format for vector measurement data",
		"mdi", "Document save in high-resolution, created by MSOffice to scan documents (OCR) and turn them into a .DOC",
		"mdg", "Digital Geometry (Programmable CAD) file format, developed by DInsight",
		"mdl", "Model",
		"mds", "Midi Session",
		"mex", "MEX file (executable command)",
		"mgf", "Materials and Geometry Format",
		"mid", "Standard MIDI file",
		"mm", "Source code",
		"mmdc", "MediaMonkey Device Settings",
		"mmip", "MediaMonkey Add-on Installation Package",
		"mmpz", "LMMS Compressed Project File",
		"mnt", "Surface metrology or image analysis document",
		"mobi", "eBook",
		"mod", "AMPL model file",
		"mod", "Modula language source",
		"mod", "MODULA-2 source code file",
		"modules", "Module",
		"mol", "MDL Molfile",
		"mol2", "Tripos Sybyl MOL2 Format",
		"mop", "MOPAC input file",
		"mov", "Animation format (Mac)",
		"mp2", "Mpeg audio file",
		"mp3", "MPEG audio stream, layer 3",
		"mp4", "multimedia container format, MPEG 4 Part 14",
		"mpa", "MPEG audio stream, layer 1,2,3",
		"mpc", "Musepack audio",
		"mpd", "LDraw file (multi-part DAT file)",
		"mpeg", "multimedia containter format, video, audio",
		"mpg", "see MPEG",
		"msc", "management saved console",
		"msdl", "Manchester Scene Description Language",
		"msf", "Multiple sequence file (Pileup format)",
		"msi", "Windows Installer Package",
		"mso", "Microsoft Outlook metadata for a Microsoft Word 2000 email attachment",
		"mxf", "Material exchange format (RFC 4539, SMPTE 377M)",
		"myd", "a MyISAM data file in MySQL",
		"myi", "a MyISAM index file in MySQL",
		"nb", "Wolfram Mathematica Notebook (see Wolfram Language)",
		"nc", "Binary Data",
		"nc", "Instructions for NC (Numerical Control) machine",
		"nc", "Name code program",
		"ncd", "NC Drill File (Excellon Format, printed circuit board hole definitions)",
		"nef", "Nikon RAW image format",
		"neu", "Pro/Engineer neutral file format",
		"nim", "Nim source code file",
		"nmf", "Node Map File",
		"npr", "Nuendo Project File",
		"nrw", "Nikon Coolpix RAW image",
		"ns1", "NetStumbler file",
		"nsa", "media",
		"nsf", "NES sound format file",
		"nsv", "media",
		"numbers", "Numbers spreadsheet file",
		"nwd, nwf", "Navisworks 3D drawing",
		"o", "Object file",
		"obj", "Compiled machine language code",
		"obj", "Object code",
		"obj", "Wavefront Object",
		"obs", "Script",
		"ocx", "OLE custom control",
		"odb", "Database front end document",
		"odf", "Formula, mathematical equations",
		"odg", "Drawings and vector graphics",
		"odp", "Presentations",
		"ods", "Spreadsheets",
		"odt", "Text (Word processing) documents",
		"oga", "Audio file in the Ogg container format",
		"ogg", "Vorbis audio in the Ogg container format",
		"ogv", "Video file in the Ogg container format",
		"ogx", "Ogg Multiplex Profile",
		"opus", "Ogg/Opus audio file",
		"org", "Emacs Org mode",
		"org", "Older Origin Project",
		"osc", "OpenStreetMap Changeset",
		"osm", "OpenStreetMap data",
		"osm", "OpenStreetMap note",
		"ost", "Offline Storage Table",
		"otb", "Over-the-air bitmap graphics",
		"otl", "The Vim Outliner",
		"otf", "Formula, mathematical equations template",
		"otg", "Drawings and vector graphics template",
		"otp", "Presentations template",
		"ots", "Spreadsheets template",
		"ott", "Text (Word processing) documents template",
		"ov2", "Overlay file (part of program to be loaded when needed)",
		"owl", "Web ontology language (OWL) file",
		"oxt", "OpenOffice.org extension",
		"p", "Database PROGRESS source code",
		"p", "PASCAL source code file",
		"p", "Parser source code file",
		"p10", "Certificate Request",
		"p12", "Personal Information Exchange",
		"pack", "Pack200 Packed Jar File",
		"pages", "Pages document file",
		"pak", "Archive",
		"pal", "Paint Shop Pro color palette (JASC format)",
		"pam", "PAM Portable Arbitrary Map graphics format",
		"par", "Parity Archive",
		"par2", "Parity Archive v2",
		"pas", "Pascal language source",
		"pblib", "Power Library",
		"pbo", "A file type used by Bohemia Interactive",
		"pcl", "HP-PCL graphics data file",
		"pcs", "PCSurvey file",
		"pdb", "debugging data",
		"pdb", "Molecule (protein data bank)",
		"pde", "source code file",
		"pdf", "Adobe's Portable Document Format",
		"pdi", "Portable Database Image",
		"pdm", "Program",
		"pdm", "PowerDesigner's physical data model (relational model) file format",
		"pdm", "Visual Basic (VB) Project Information File",
		"pdn", "Image file",
		"pds", "PALASM Design Description",
		"pds", "Planetary Data System Format",
		"pem", "A text-based certificate file defined in RFC 1421 through RFC 1424",
		"pet", "package",
		"pfa", "PostScript Font File",
		"pfa", "Type 3 font file (unhinted PostScript font)",
		"pfam", "PFAM format",
		"pfb", "PostScript font",
		"pfc", "(Personal Filing Cabinet) contains e-mail, preferences and other personal information",
		"pfm", "PostScript Type 1 font metric file",
		"pfm", "Windows Type 1 font metric file",
		"pgn", "Portable Game Notation -Text specification for Chess game",
		"pfx", "An encrypted certificate file",
		"php", "PHP file",
		"php3", "PHP 3 file",
		"php4", "PHP 4 file",
		"phy", "Phylip format",
		"phf", "Database File",
		"phr", "Phrases",
		"pi2", "Portrait Innovations High Resolution Encrypted Image file",
		"pie", "GlovePIE script file",
		"pir", "PIR format",
		"pit", "Compressed Mac file archive created by PACKIT",
		"pit", "Partition Information Table for Samsung's smartphone with Android",
		"pkl", "Pickle file",
		"pka", "Archive",
		"pl", "Perl source code file",
		"pl", "Prolog source code file",
		"pl", "IRAF pixel list",
		"pli", "PL/I source file",
		"plr", "Terraria player/character file",
		"pm", "Perl module",
		"pma", "PMarc Archive",
		"png", "Portable Network Graphics file",
		"pom", "Build manager configuration file",
		"pptx", "MS Office Open-XML Presentation",
		"ppsx", "MS Office Open-XML Auto-Play Presentation",
		"prj", "Mkd (Unix command)",
		"proto", "Message specification",
		"prp", "Plasma Registry Page",
		"ps", "Adobe Postscript file",
		"psd", "Photoshop bitmap file",
		"psm1", "Windows Powershell module",
		"psppalette", "Paint Shop Pro color palette (JASC format)",
		"pst", "Archive File",
		"ps1", "Windows Powershell script",
		"ptf", "PlayStation Portable Theme file",
		"ptf", "Pro Tools Session File",
		"pub", "Public key ring file",
		"pup", "Pileup format",
		"py", "Python script file",
		"qfx", "Quicken-specific implementation of the OFX specification",
		"qif", "Quicken Interchange Format",
		"qlc", "ATM Type 1 fonts script",
		"qt", "QuickTime movie (animation)",
		"qtvr", "QuickTime VR Movie",
		"r", "Ratfor file",
		"r", "Script file",
		"r00, r01, ...", "Part of a multi-file RAR archive",
		"r2d", "Reflex 2 datafile",
		"r3d", "Red Raw Video (raw video data created with a Red camera)",
		"r8p", "PCL 4 bitmap font file",
		"rad", "2-op FM music",
		"rad", "Radiance",
		"ral", "Remote Access Language file",
		"ram", "Ramfile",
		"rap", "Flowchart",
		"rar", "Archive",
		"ras", "Graphics format",
		"rb", "Ruby Script file",
		"rbxm", "Roblox \"model\"",
		"rbxl", "Roblox \"level\"",
		"rc", "Configuration file",
		"rc", "Resource Compiler script file",
		"rdp", "RDP connection",
		"rds", "Data file",
		"res", "Compiled resource",
		"rkt", "Racket  language source file",
		"rm", "RealMedia",
		"rmvb", "RealMedia Variable Bitrate",
		"rpm", "Red Hat Package Manager",
		"rs", "Rust language source",
		"rsl, rsls, rslf", "Resilio Sync File Placeholder",
		"rst", "reStructuredText",
		"rtf", "Rich Text Format text file (help file script)",
		"run", "AMPL script file",
		"run", "Makeself shell self-extracting archive",
		"s3m", "Scream Tracker 3 module",
		"s7i", "Seed7 library / include file",
		"saif", "Spatial Archive and Interchange Format",
		"sass", "Sass stylesheet language, indented-format",
		"sat", "ACIS ACIS .sat",
		"sav", "SPSS tabular data (binary)",
		"savegame", "Astroneer game save",
		"sb", "Scratch project",
		"sb2", "Scratch 2.0 project",
		"sb3", "Scratch 3.0 project",
		"sbh", "Header",
		"sbv", "YouTube captions data, may also contain subtitles",
		"sbv", "Superbase RDBMS form definition data",
		"sbx", "For experimental extensions to Scratch",
		"sbx", "Sequenced Box container",
		"scala", "Scala source code file",
		"scm", "Scheme source code file",
		"scr", "Screen Protector file",
		"scss", "Saas stylesheet language, block-formatted with braces and semicolons to denote end-of-line",
		"sdf", "SQL Server Compact database file",
		"sd7", "Seed7 source file",
		"sds", "Self Defining Structure provides for N-dimensional very large datasets using HHCode",
		"sdts", "Spatial Data Transfer Standard",
		"sec", "Secret key ring file",
		"sed", "Self extraction directive file",
		"seq", "Video",
		"sf", "JAR Digital Signature",
		"sfb", "Configuration file",
		"sfc", "Super Nintendo Entertainment System Or Super Family Computer Cartage file",
		"sfx", "SFX (self-extracting archives) script",
		"sh", "Unix shell script",
		"shar", "Shell self-extracting archive",
		"shtm", "SSI-enabled HTM file",
		"shtml", "SSI-enabled HTML file",
		"shx", "Shape entities ESRI shapefile",
		"sig", "Signature file",
		"sl", "S-Lang source code file",
		"sm", "SMALLTALK source code file",
		"smclvl", "Secret Maryo Chronicles Level",
		"smk", "Smacker video Format (RAD Video)",
		"sno", "SNOBOL4 source code file",
		"so", "shared object, dynamically linked library",
		"spf", "data",
		"spiff", "Still Picture Interchange File Format",
		"spin", "Spin source file",
		"sps", "SPSS program file (text)",
		"spt", "SPITBOL source code file",
		"spx", "Ogg Speex bitstream",
		"spz", "Crestron SIMPL Windows compiled program (ZIP format)",
		"sql", "Structured Query Language",
		"ssc", "Celestia Solar System Catalog file",
		"ssc", "Stellarium Script",
		"st", "SMALLTALK source code file",
		"stc", "Celestia Star Catalog file",
		"stc", "OpenOffice.org XML spreadsheet template",
		"std", "OpenOffice.org XML drawing template",
		"sti", "OpenOffice.org XML presentation template",
		"stk", "Stockholm multiple sequence alignment",
		"stm", "Scream Tracker Module",
		"stm", "SSI-enabled HTML file",
		"sto", "Stockholm multiple sequence alignment",
		"stp", "Standard for the Exchange of Product Data",
		"sts", "Scream Tracker Song",
		"stw", "OpenOffice.org XML text document template",
		"sur", "Surface topography (in native \"SURF\" format)",
		"svc", "Represents the ServiceHost instance hosted by Internet Information Services",
		"svg", "Scalable Vector Graphics",
		"svp", "Vocal synthesis track data",
		"swatches", "Color Palettes",
		"swf", "Shockwave Flash",
		"swg", "SWIG source code",
		"swift", "Swift source code",
		"swm", "split Windows Imaging Format",
		"sxc", "OpenOffice.org XML spreadsheet",
		"sxd", "OpenOffice.org XML drawing",
		"sxg", "OpenOffice.org XML master document",
		"sxi", "OpenOffice.org XML presentation",
		"sxm", "OpenOffice.org XML formula",
		"sxp", "3DS Process file",
		"sxw", "OpenOffice.org XML text document",
		"sylk", "Symbolic link file for windows",
		"symboliclink", "Replace file for a symbolic link",
		"tak", "Audio codec, Lossless audio file format",
		"tar", "tar archive",
		"taz", "compressed tar archive",
		"tbg", "text based graphics",
		"tbl", "TBLater table File",
		"tc", "Theme Colour file",
		"thm", "Thumbnail File",
		"tlb", "Type library",
		"tmp", "Temporary file",
		"torrent", "Torrent file",
		"ts", "MPEG transport stream",
		"ts", "TypeScript",
		"tsv", "Tab-separated values",
		"tt", "Theme Template File",
		"ttf", "TrueType Font file",
		"tga", "Truevision TGA file",
		"ui", "Espire source code file",
		"ui", "Qt Designer's UI File",
		"ump", "Umple UML Programming Language Format",
		"unv", "Text file containing finite elements nodal coordinates and more See notes",
		"uos", "Uniform Office Format spreadsheet",
		"uot", "Uniform Office Format text",
		"ups", "ROM patch file",
		"usdz", "Augmented Reality (AR) File",
		"ust", "Vocal synthesis track data",
		"ut!", "datafile",
		"v", "Coq source file",
		"v", "Verilog source file",
		"v4p", "vvvv patch",
		"v64", "Nintendo 64 ROM",
		"vb", "Visual Basic .Net source file",
		"vbox", "virtual machine settings file (in XML format)",
		"vbox-extpack", "VirtualBox extension package",
		"vbproj", "Visual Basic .Net project file",
		"vbr", "Visual Basic Custom Control file",
		"vbs", "VBScript script file",
		"vbx", "Visual Basic eXtension",
		"vc6", "Graphite - 2D and 3D drafting",
		"vcls", "VocaListener voice scanner file",
		"vda", "Targa bitmap graphics",
		"vdi", "Virtual Disk Image",
		"vdw", "Visio web drawing",
		"vdx", "Visio XML drawing",
		"vfd", "Virtual Floppy Disk",
		"vi", "Virtual Instrument",
		"vmcz", "Hyper-V Exported Virtual Machine",
		"vmdk", "Virtual Disk file",
		"vmg", "Nokia message file format",
		"vob", "Video Object",
		"vpm", "Garmin Voice Processing Module",
		"vpp", "Visual Paradigm Project",
		"vpr", "Vocal synthesizer track data",
		"vqm", "Hardware description language",
		"vs", "Vellum Solids",
		"vsd", "Visio drawing",
		"vsdx", "Visio drawing",
		"vsm", "Visual Simulation Model",
		"vsq", "Vocal synthesizer track data",
		"vsqx", "Vocal synthesizer track data",
		"vst", "Truevision Vista graphics",
		"vsto", "Microsoft Office add-in file",
		"vsvnbak", "VisualSVN Server repository backup",
		"vtf", "Valve Texture Format file",
		"vvvvvv", "VVVVVV map file",
		"wav", "Sound format (Microsoft Windows RIFF WAVE)",
		"witness_campaign", "Game save file for The Witness",
		"wk1", "Spreadsheet",
		"wk3", "Spreadsheet",
		"wks", "Spreadsheet",
		"wld", "Terraria world file",
		"wlmp", "Windows Live Moviemaker Project, contains paths from where the images/audios/videos of the project are located",
		"wma", "Windows Media Audio audio file",
		"wmdb", "Windows Media Player database",
		"wmf", "Windows MetaFile vector graphics",
		"wos", "WoS bibliographic reference file",
		"x", "LEX source code file",
		"x", "XBasic Source code file",
		"x3d", "x3d and xdart Formats",
		"xar", "Xara graphics file",
		"xar", "eXtensible ARchive",
		"xbrl", "eXtensible Business Reporting Language instance file",
		"xcf", "Gimp image file",
		"xdm", "Directory Manipulator for 32-bit Protected Mode",
		"xe", "Xenon - for Associative 3D Modeling",
		"xex", "Xbox 360 Executable File",
		"xls", "Microsoft Excel Spreadsheet",
		"xlsb", "Microsoft Excel 2007 Binary Workbook (BIFF12)(Spreadsheets)",
		"xlsm", "Microsoft Excel 2007 Macro-Enabled Workbook (Spreadsheets)",
		"xlsx", "Office Open XML Workbook (Spreadsheets)",
		"xm", "FastTracker 2 extended module",
		"xml", "eXtensible Markup Language file",
		"xmf", "eXtensible Music Format",
		"xp", "eXtended Pattern",
		"xpl", "X-Plane system file",
		"xps", "Open XML Paper Specification / OpenXPS",
		"xsd", "XML schema description",
		"xsf", "data",
		"xspf", "XML Sharable Playlist Format",
		"xsl", "XSL Stylesheet",
		"xslt", "XSLT file",
		"xsn", "Microsoft InfoPath template",
		"xx", "XX-encoded file (ASCII)",
		"xxe", "XX-encoded file (ASCII)",
		"xxx", "Singer Embroidery Format",
		"xyz", "Molecular coordinates",
		"xz", "a lossless data compression file format incorporating the LZMA/LZMA2 compression algorithms.",
		"y", "YACC grammar file",
		"yml", "YML markup file",
		"yaml", "YAML source file",
		"z64", "Nintendo 64 ROM file (emulation only)",
		"zip", "Zip (file format)",
		"zrx", "REXX scripting language for ZOC_(software)",
		"zs", "Script for Minecraft mod MineTweaker and CraftTweaker",
	).StyleF(func(s string, sc style.Context) string {
		return style.ForPathExt("."+s, sc)
	})
}
