# v0.22 - Running Man

![](./v0.22/banner.png)

Specs now support a `run` field enabling cross shell aliases and simple nested custom commands.

## Run

`run` can either contain an alias (`[command, arg1, arg2]`) which bridges completion or a shell macro (`$(echo example)`) with custom completions / flag parsing.

```yaml
name: runnable
description: runnable spec
commands:
  -  name: sub1
     description: alias
     run: "[git, log]"

  -  name: sub2
     description: shell
     run: "$(git show $1)"
     completion:
       positional:
         - - "$(git branch --format '%(refname:short)\t%(subject)\tblue')"
           - "$(git tag --format '%(refname:short)\t\tyellow')"

  -  name: sub3
     description: shell with flags
     run: "$(git log --author \"${C_FLAG_AUTHOR}\" $1)"
     flags:
       -a, --author=: limit to author
     completion:
       flag:
         author: ["$(git shortlog --summary --email HEAD | sed -e 's/^.*\t//' -e 's/ </\t</')"]
       positional:
         - - "$(git branch --format '%(refname:short)\t%(subject)\tblue')"
           - "$(git tag --format '%(refname:short)\t\tyellow')"
```

![](./v0.22/runnable.cast)

## PATH

`carapace _carapace` now prepends [`${UserConfigDir}/carapace/bin`] to `PATH` unless it already exists.

> In `nushell` this needs to be done manually (see output of `carapace _carapace nushell`):
> ```nushell
> let-env PATH = ($env.PATH | prepend "/home/rsteube/.config/carapace/bin")
> ```

## Shim

It also creates [Shims](https://en.wikipedia.org/wiki/Shim_(computing)) in [`${UserConfigDir}/carapace/bin`] to execute the specs.
For unix systems this is a simple shell script, but for windows an [embedded binary](https://github.com/carapace-sh/carapace-bin/blob/v0.22.0/cmd/shim/main.go) is used.

```sh
#!/bin/sh
carapace --run "/home/rsteube/.config/carapace/specs/runnable.yaml" "$@"
```

> The [`${UserConfigDir}/carapace/bin`] directory is fully managed by carapace and **unrelated files within it are removed**.

## Nargs

Initial support for flags consuming multiple arguments as seen in [argparse](https://docs.python.org/3/library/argparse.html#nargs) and various `nix` commands.

## XDG

[XDG] base directories for `XDG_CACHE_HOME` and `XDG_CONFIG_HOME` are now supported.

[`${UserConfigDir}/carapace/bin`]:https://pkg.go.dev/os#UserConfigDir
[XDG]:https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html
