# v0.14 - In A Nutshell

![](./v0.14/banner.png)


## Nushell

https://github.com/nushell/nushell/pull/6295 adds support for external completers to nushell.
For this `config.nu` must be updated manually according to the snippet output of `carapace`.
Here's an example with `carapace` as default completer and a couple custom completers:

```sh
let external_completer = {|spans| 
  {
    $spans.0: { carapace $spans.0 nushell $spans | from json } # default                                                             
    example: { example _carapace nushell $spans | from json }                                                                 
    pkill: { carapace --spec '/home/rsteube/.config/carapace/specs/pkill.yaml' nushell $spans | from json }  
    vault: { carapace --bridge vault/posener nushell $spans | from json }
  } | get $spans.0 | each {|it| do $it}
}

let-env config = {
  external_completer: $external_completer
}
```