/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
	iamauthenticatorv1alpha1 "sigs.k8s.io/aws-iam-authenticator/pkg/mapper/crd/apis/iamauthenticator/v1alpha1"
)

// IAMIdentityMappingLister helps list IAMIdentityMappings.
// All objects returned here must be treated as read-only.
type IAMIdentityMappingLister interface {
	// List lists all IAMIdentityMappings in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*iamauthenticatorv1alpha1.IAMIdentityMapping, err error)
	// Get retrieves the IAMIdentityMapping from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*iamauthenticatorv1alpha1.IAMIdentityMapping, error)
	IAMIdentityMappingListerExpansion
}

// iAMIdentityMappingLister implements the IAMIdentityMappingLister interface.
type iAMIdentityMappingLister struct {
	listers.ResourceIndexer[*iamauthenticatorv1alpha1.IAMIdentityMapping]
}

// NewIAMIdentityMappingLister returns a new IAMIdentityMappingLister.
func NewIAMIdentityMappingLister(indexer cache.Indexer) IAMIdentityMappingLister {
	return &iAMIdentityMappingLister{listers.New[*iamauthenticatorv1alpha1.IAMIdentityMapping](indexer, iamauthenticatorv1alpha1.Resource("iamidentitymapping"))}
}
